/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class GameLogic {
    protected static final int NO_RACE = 0;
    protected static final int RACE_IDLE = 1;
    protected static final int BEFORE_RACE_CAM_ANIM = 2;
    protected static final int BEFORE_MISSION_INTRO = 3;
    protected static final int BEFORE_MISSION_DESCRIPTION = 4;
    protected static final int BEFORE_RACE_COUNT = 5;
    public static final int DURING_RACE = 6;
    protected static final int AFTER_RACE_INFO = 7;
    protected static final int AFTER_RACE_SUMMARY = 8;
    protected static final int AFTER_RACE_UNLOCK = 9;
    protected static final int AFTER_RACE_NAME = 10;
    protected static final int AFTER_RACE_CUP = 11;
    protected static final int AFTER_RACE_CONGRATS = 12;
    public static final int CUP_MODE = 0;
    public static final int MISSION_MODE = 1;
    public static final int TRIAL_MODE = 2;
    public static final int GHOST_MODE = 3;
    public static final int LMS_MODE = 4;
    public static final int MIRROR_MODE = 5;
    protected static final long BEFORE_RACE_TIME = 3000L;
    protected static final long AFTER_RACE_TIME = 2000L;
    protected static final long TIME_LIMIT = 599999L;
    public static final int PACMAN_WORLD = 0;
    public static final int GHOST_WORLD = 1;
    public static final int KATAMARI_WORLD = 2;
    public static final int DIGDUG_WORLD = 3;
    public static final int NUMBER_OF_WORLDS = 4;
    public static int gameState;
    public static int gameMode;
    public static int gameKart;
    public static int gameChar;
    public static int gameRace;
    public static int gameWorld;
    public static int gameTrack;
    public static int gameDifficulty;
    public static int gameLapsSet;
    public static int gameLaps;
    public static boolean gameItemsSet;
    public static boolean gameItems;
    protected RaceManager m_RaceManager;
    protected int[][] race;
    protected long timer;
    protected long pauseTimer;
    protected long raceTimer;
    protected long raceTime;
    protected String timeStr;
    protected String timeDisp;
    protected boolean win;
    protected boolean pass;
    protected boolean timeout;
    protected int nrActiveKarts;
    protected boolean[] kartsFinished;
    protected int nrFinishedKarts;
    protected int[] kartsOrder;
    protected String[] kartsTimes;
    protected int playerLaps;
    protected long playerTime;
    protected int playerFinalPos;
    protected long playerActLapTime;
    protected long[] playerLapTimes;
    protected long playerBestLapTime;
    protected int playerBestLap;
    protected boolean highscore;
    protected boolean firstFinish;
    protected boolean save;
    protected int unlock;
    protected String[] unlockStr = new String[]{"", "", "", ""};
    public static boolean idle;
    protected int fpsTestDuration = 0;
    protected long idleTimeout = 0L;
    public static boolean[][] CharUnlocks;
    public static boolean[][] KartUnlocks;
    protected Image hudFrame;
    protected Image hudGums;
    protected Image hudCharacter;
    protected Image hudArrow;
    protected Image hudStar;
    protected Image hudShade;
    protected Image steeringWheel;
    protected Random mRandom = new Random();
    public boolean blink;
    protected Vector3D wayDir = new Vector3D();
    protected Vector3D kartDir = new Vector3D();
    protected Vector3D dir = new Vector3D();
    public static final int HUD_STRIPES_H = 45;
    public static int HUD_MINIMAP_W;
    public static int HUD_MINIMAP_H;
    private static int HUD_GAP;
    private static int HUD_ITEM_Y;
    private static int HUD_AVATAR_Y;
    private static int HUD_GUM_X;
    private static int HUD_POSITION_X;
    private static int HUD_POSITION_Y;
    private static int HUD_FINISHED_Y;
    private static int HUD_FINISHED_H;
    private static int HUD_FINISHED_X;
    private static int HUD_FINISHED_AVATAR_X;
    private static int HUD_FINISHED_TIME_X;
    private static int HUD_SUMMARY_X;
    private static int HUD_SUMMARY_Y;
    private static int HUD_SUMMARY_H;
    public static GameFrame m_GameFrame;
    private long departureSfxTime;
    private boolean playEngineSfx = false;
    private static final int TILESET_SMALL = 0;
    private static final int TILESET_COUNT = 1;
    private static final int TILESET_ITEMS = 2;
    private static final int TILESET_NUMBER_OF = 3;
    private static final int[][][] tiles_desc;
    private static Image[] tiles;
    private int tiles_a;

    public abstract void init();

    protected void initHUD() {
        try {
            this.hudFrame = Image.createImage((String)"/Sprites/Hud/frame.png");
            this.hudGums = Image.createImage((String)"/Sprites/Hud/gums.png");
            this.hudArrow = Image.createImage((String)"/Sprites/Hud/arrow.png");
            this.hudStar = Image.createImage((String)"/Sprites/Hud/star.png");
            this.hudShade = Image.createImage((String)"/Sprites/Hud/shade.png");
            this.steeringWheel = Image.createImage((String)"/Sprites/Hud/wheel.png");
            this.hudCharacter = Image.createImage((String)("/Sprites/Hud/icon_" + Stats.char_name[gameChar] + ".png"));
        }
        catch (Exception e) {
            System.out.println("Error: Unable to load InGame images.");
            System.out.println("gameChar: " + gameChar);
        }
        this.initTiles();
        HUD_MINIMAP_W = 160;
        HUD_MINIMAP_H = 90;
        HUD_GAP = 10;
        HUD_ITEM_Y = this.hudFrame.getHeight() + HUD_GAP * 2 >= 45 ? HUD_GAP : 45 - this.hudFrame.getHeight() >> 1;
        HUD_FINISHED_H = Menu.digtFont.getHeight() >= 19 ? Menu.digtFont.getHeight() : 19;
        HUD_SUMMARY_H = Menu.digtFont.getHeight() >= Menu.bigFont.getHeight() ? Menu.digtFont.getHeight() : Menu.bigFont.getHeight();
        HUD_SUMMARY_Y = 360 - (gameLaps + 1) * HUD_SUMMARY_H >> 1;
        int xspace = 320 - (HUD_GAP + (HUD_GAP >> 1) + (this.hudFrame.getWidth() >> 1) + this.hudCharacter.getWidth() + Menu.digtFont.stringWidth("4/4x10") + this.hudGums.getWidth());
        if (xspace >= HUD_GAP * 2) {
            HUD_GUM_X = HUD_GAP + (HUD_GAP >> 1) + this.hudCharacter.getWidth() + Menu.digtFont.stringWidth("4/4") + this.hudGums.getWidth() + (xspace >> 1);
            HUD_AVATAR_Y = this.hudCharacter.getHeight() + HUD_GAP * 2 >= 45 ? HUD_GAP : 45 - this.hudCharacter.getHeight() >> 1;
            HUD_POSITION_Y = 22;
            HUD_POSITION_X = HUD_GAP + (HUD_GAP >> 1) + this.hudCharacter.getWidth() + (Menu.digtFont.stringWidth("4/4") >> 1);
            HUD_FINISHED_Y = this.hudCharacter.getHeight() + HUD_GAP >= 45 ? HUD_ITEM_Y + this.hudCharacter.getHeight() + HUD_GAP + (HUD_FINISHED_H >> 1) : 45 + HUD_GAP + (HUD_FINISHED_H >> 1);
            HUD_FINISHED_X = HUD_GAP;
        } else {
            HUD_GUM_X = HUD_GAP + this.hudGums.getWidth();
            HUD_AVATAR_Y = 45 + HUD_GAP;
            HUD_POSITION_Y = HUD_AVATAR_Y + this.hudCharacter.getHeight() + HUD_GAP + (Menu.digtFont.getHeight() >> 1);
            HUD_POSITION_X = HUD_GAP + (this.hudCharacter.getWidth() >> 1);
            HUD_FINISHED_Y = this.hudFrame.getHeight() + HUD_GAP >= 45 ? HUD_ITEM_Y + this.hudFrame.getHeight() + HUD_GAP + (HUD_FINISHED_H >> 1) : 45 + HUD_GAP + (HUD_FINISHED_H >> 1);
            if (HUD_SUMMARY_Y - HUD_SUMMARY_H < HUD_FINISHED_Y + HUD_FINISHED_H * this.nrActiveKarts) {
                HUD_SUMMARY_Y = HUD_FINISHED_Y + HUD_FINISHED_H * this.nrActiveKarts + HUD_SUMMARY_H;
            }
            HUD_FINISHED_X = 640 - Menu.digtFont.stringWidth("4:0:00:000") - 18 >> 1;
        }
        HUD_FINISHED_AVATAR_X = HUD_FINISHED_X + Menu.digtFont.stringWidth("4:");
        HUD_FINISHED_TIME_X = HUD_FINISHED_AVATAR_X + 18;
        int summary_w = Menu.bigFont.stringWidth(Text.getText(236) + " ");
        if (Menu.bigFont.stringWidth(Text.getText(234) + " 0 ") > summary_w) {
            summary_w = Menu.bigFont.stringWidth(Text.getText(234) + " 0 ");
        }
        HUD_SUMMARY_X = 640 - summary_w - Menu.digtFont.stringWidth("0:00:000") >> 1;
    }

    protected void updateControll() {
        boolean captured = false;
        if (this.m_RaceManager.m_AI[0].sleeping) {
            if (m_GameFrame.isKeyDown(1)) {
                this.m_RaceManager.m_Karts[0].acceleratePush();
                this.m_RaceManager.m_Karts[0].handbrakePush();
                captured = true;
            }
            if (m_GameFrame.isKeyDown(6)) {
                this.m_RaceManager.m_Karts[0].accelerateRelease();
                this.m_RaceManager.m_Karts[0].brakePush();
                captured = true;
            }
            if (m_GameFrame.isKeyDown(2)) {
                this.m_RaceManager.m_Karts[0].turnPush((byte)1);
            }
            if (m_GameFrame.isKeyDown(5)) {
                this.m_RaceManager.m_Karts[0].turnPush((byte)-1);
            }
            if (m_GameFrame.isKeyUp(8)) {
                this.m_RaceManager.m_Karts[0].useItem();
            }
            if (m_GameFrame.isKeyUp(1)) {
                this.m_RaceManager.m_Karts[0].handbrakeRelease();
                captured = true;
            }
            if (m_GameFrame.isKeyUp(6)) {
                this.m_RaceManager.m_Karts[0].brakeRelease();
                this.m_RaceManager.m_Karts[0].acceleratePush();
                captured = true;
            }
            if (m_GameFrame.isKeyUp(2)) {
                this.m_RaceManager.m_Karts[0].turnRelease();
            }
            if (m_GameFrame.isKeyUp(5)) {
                this.m_RaceManager.m_Karts[0].turnRelease();
            }
        }
        for (int i = 0; i < this.m_RaceManager.m_AI.length; ++i) {
            this.m_RaceManager.m_AI[i].think();
        }
        if (captured) {
            m_GameFrame.clearKeys();
        }
    }

    public abstract boolean update(float var1);

    public void paint(Graphics g) {
        g.setClip(0, 45, 640, 270);
        this.m_RaceManager.paint(g);
        g.setClip(0, 0, 640, 360);
        this.paintHUD(g);
    }

    protected abstract boolean checkEndCondition();

    protected int checkPosition() {
        int position = 1;
        for (int i = 1; i < this.m_RaceManager.m_Karts.length; ++i) {
            if (this.m_RaceManager.m_Karts[i].actPos > this.m_RaceManager.m_Karts[0].actPos) {
                ++position;
                continue;
            }
            if (this.m_RaceManager.m_Karts[i].actPos != this.m_RaceManager.m_Karts[0].actPos) continue;
            int ap = this.m_RaceManager.m_Karts[0].nearestPoint[0];
            int np = ap + 1;
            if (np == this.m_RaceManager.m_Track.iPoints.length) {
                np = 0;
            }
            Vector3D trV = new Vector3D(this.m_RaceManager.m_Track.iPoints[np]);
            trV.sub(this.m_RaceManager.m_Track.iPoints[ap]);
            Vector3D posV = new Vector3D(this.m_RaceManager.m_Track.iPoints[np]);
            posV.sub(this.m_RaceManager.m_Karts[0].getPosition());
            float d0 = Math.abs(trV.dotProduct(posV));
            posV.set(this.m_RaceManager.m_Track.iPoints[np]);
            posV.sub(this.m_RaceManager.m_Karts[i].getPosition());
            float di = Math.abs(trV.dotProduct(posV));
            if (!(d0 > di)) continue;
            ++position;
        }
        return position;
    }

    protected void paintHUDboost(Graphics g) {
        if ((this.m_RaceManager.m_Karts[0].isBoosted || this.m_RaceManager.m_Karts[0].isInvincible) && (this.m_RaceManager.m_Karts[0].boostFrame > 10.0f || this.m_RaceManager.m_Karts[0].invincibilityFrame > 10.0f || this.blink)) {
            g.setColor(255, 255, 255);
            float radius1 = this.mRandom.nextInt(30) + 30;
            float radius2 = this.mRandom.nextInt(40) + 160;
            for (int i = 0; i < (int)(this.m_RaceManager.m_Karts[0].vVelocity.length() / (float)(3 * Track.mScale)) - 3; ++i) {
                float degInRad = (float)this.mRandom.nextInt(360) * 3.14159f / 180.0f;
                float x1 = (float)(mMath.cos(degInRad) * (double)radius1) + 320.0f;
                float y1 = (float)(mMath.sin(degInRad) * (double)radius1) + 180.0f;
                float x2 = (float)(mMath.cos(degInRad) * (double)radius2) + 320.0f;
                float y2 = (float)(mMath.sin(degInRad) * (double)radius2) + 180.0f;
                g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
            }
        }
    }

    protected void paintHUDautopilot(Graphics g) {
        if (this.m_RaceManager.m_Karts[0].isAutopilot && (this.m_RaceManager.m_Karts[0].autopilotFrame > 10.0f || this.blink)) {
            if (this.m_RaceManager.rotateLeft) {
                g.drawRegion(this.steeringWheel, this.m_RaceManager.frameX, 0, RaceManager.frameBase, RaceManager.frameBase, 0, 320, 135, 3);
            } else {
                g.drawRegion(this.steeringWheel, this.m_RaceManager.frameX, 0, RaceManager.frameBase, RaceManager.frameBase, 2, 320, 135, 3);
            }
        }
    }

    protected void paintHUDstripes(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 640, 45);
        g.fillRect(0, 315, 640, 45);
    }

    protected void paintHUDminimap(Graphics g) {
        int size = (int)(15.0f * this.m_RaceManager.scale);
        if (size < 5) {
            size = 5;
        }
        g.drawImage(this.m_RaceManager.img_MiniMap, 640 - HUD_GAP, 45 + HUD_GAP, 24);
        for (int i = this.m_RaceManager.m_Karts.length - 1; i >= 0; --i) {
            if (this.m_RaceManager.m_Karts[i].isSleeping()) continue;
            Vector3D pos = this.m_RaceManager.m_Karts[i].getPosition();
            int px = (int)(pos.getx() * this.m_RaceManager.scale) + this.m_RaceManager.mmapTx;
            int py = (int)(pos.getz() * this.m_RaceManager.scale) + this.m_RaceManager.mmapTy;
            if (i != 0) {
                g.setColor(0xFFFFFF);
            } else {
                g.setColor(0);
            }
            g.fillArc(640 - HUD_MINIMAP_W + px - ((size >> 1) + 1) - HUD_GAP, py - ((size >> 1) + 1) + 45 + HUD_GAP, size + 2, size + 2, 0, 360);
            g.setColor(Stats.char_color[this.race[0][i]]);
            g.fillArc(640 - HUD_MINIMAP_W + px - (size >> 1) - HUD_GAP, py - (size >> 1) + 45 + HUD_GAP, size, size, 0, 360);
        }
    }

    protected void paintHUDlap(Graphics g) {
        Menu.digtFont.drawString(g, this.playerLaps + "/" + gameLaps, 640 - HUD_GAP - (HUD_MINIMAP_W >> 1), 45 + HUD_GAP + HUD_MINIMAP_H, 17);
    }

    protected void paintHUDavatar(Graphics g) {
        g.drawImage(this.hudCharacter, HUD_GAP, HUD_AVATAR_Y, 20);
    }

    protected void paintHUDplayerPosition(Graphics g) {
        String pos = gameState > 6 ? "" + this.playerFinalPos : (this.m_RaceManager.m_Karts[0].nearestPoint[1] != 0 || gameState < 6 ? "?" : "" + this.checkPosition());
        pos = pos + "/" + this.nrActiveKarts;
        Menu.digtFont.drawString(g, pos, HUD_POSITION_X, HUD_POSITION_Y, 3);
    }

    protected void paintHUDgumNumber(Graphics g) {
        g.drawImage(this.hudGums, HUD_GUM_X, 22, 10);
        Menu.digtFont.drawString(g, "x" + this.m_RaceManager.m_Karts[0].getCollectibleCount(), HUD_GUM_X, 22, 6);
    }

    protected void paintHUDcollectedItem(Graphics g) {
        g.drawImage(this.hudFrame, 320, HUD_ITEM_Y, 17);
        int item = this.m_RaceManager.m_Karts[0].getItem();
        if (item == -2) {
            item = Math.abs(this.mRandom.nextInt() % 6) + 1;
        }
        if (item >= 0 && item <= 6) {
            if (item == 1 && this.m_RaceManager.m_Karts[0].getItemCount() == 2) {
                item = 7;
            } else if (item == 1 && this.m_RaceManager.m_Karts[0].getItemCount() == 3) {
                item = 8;
            } else if (item == 2 && this.m_RaceManager.m_Karts[0].getItemCount() == 2) {
                item = 9;
            } else if (item == 2 && this.m_RaceManager.m_Karts[0].getItemCount() == 3) {
                item = 10;
            }
            this.tileDrawImage(g, 2, item - 1, 296, HUD_ITEM_Y + (this.hudFrame.getWidth() - 48 >> 1));
        }
    }

    protected void paintHUDraceTime(Graphics g) {
        Menu.digtFont.drawString(g, this.timeDisp, 640 - HUD_GAP, 22, 10);
    }

    protected void paintHUDpauseArrow(Graphics g) {
        g.drawImage(this.hudArrow, HUD_GAP, 338, 6);
    }

    protected void paintHUDkartSpeed(Graphics g) {
        int ispeed = (int)(this.m_RaceManager.m_Karts[0].getVelocity().length() * 50.0f);
        float speed = (float)ispeed / 10.0f;
        String speedstring = "" + speed;
        Menu.digtFont.drawString(g, speedstring, 640 - HUD_GAP, 338, 10);
    }

    protected void paintHUDkartsFinished(Graphics g) {
        for (int i = 0; i < this.nrFinishedKarts; ++i) {
            if (gameMode == 0 || gameMode == 5) {
                Menu.digtFont.drawString(g, i + 1 + ":", HUD_FINISHED_X, HUD_FINISHED_Y + HUD_FINISHED_H * i, 6);
                this.tileDrawImage(g, 0, this.race[0][this.kartsOrder[i]], HUD_FINISHED_AVATAR_X, HUD_FINISHED_Y - 9 + HUD_FINISHED_H * i);
                Menu.digtFont.drawString(g, "" + this.kartsTimes[i], HUD_FINISHED_TIME_X, HUD_FINISHED_Y + HUD_FINISHED_H * i, 6);
            }
            if (gameMode != 4) continue;
            Menu.digtFont.drawString(g, this.m_RaceManager.m_Karts.length - i + ":", HUD_FINISHED_X, HUD_FINISHED_Y + HUD_FINISHED_H * i, 6);
            this.tileDrawImage(g, 0, this.race[0][this.kartsOrder[i]], HUD_FINISHED_AVATAR_X, HUD_FINISHED_Y - 9 + HUD_FINISHED_H * i);
        }
    }

    protected void paintHUDstartLights(Graphics g) {
        if (gameState == 5) {
            SoundManager.playSfx(4);
            int st = (int)((this.timer + 3000L - MainCanvas.m_CurrTime) / 1000L) + 1;
            if (st <= 3) {
                int h = 180;
                if (st == 3) {
                    h = (int)((MainCanvas.m_CurrTime - this.timer) * 180L / 1000L);
                }
                if (st == 3 && !this.m_RaceManager.as) {
                    this.m_RaceManager.as = true;
                } else if (st == 2 && !this.m_RaceManager.bs) {
                    this.m_RaceManager.bs = true;
                    SoundManager.playSfx(21);
                } else if (st == 1 && !this.m_RaceManager.cs) {
                    this.m_RaceManager.cs = true;
                    SoundManager.playSfx(21);
                }
                this.tileDrawImage(g, 1, st, 258, h - 27);
            }
        } else if (this.raceTime < 1000L) {
            if (!this.m_RaceManager.ds) {
                this.m_RaceManager.ds = true;
                SoundManager.playSfx(22);
                this.departureSfxTime = MainCanvas.m_CurrTime;
                this.playEngineSfx = true;
            }
            this.tileDrawImage(g, 1, 0, 258, (int)((1000L - this.raceTime) * 153L / 1000L));
            SoundManager.playSfx(7);
        }
    }

    protected boolean paintHUDwrongWay(Graphics g) {
        int ap = this.m_RaceManager.m_Karts[0].nearestPoint[0];
        int np = ap + 1;
        if (this.m_RaceManager.m_Karts[0].nearestPoint[1] == 0) {
            if (np == this.m_RaceManager.m_Track.iPoints.length) {
                np = 0;
            }
            this.wayDir.set(this.m_RaceManager.m_Track.iPoints[np]);
            this.wayDir.sub(this.m_RaceManager.m_Track.iPoints[ap]);
        } else {
            TrackShortcut sc = (TrackShortcut)this.m_RaceManager.m_Track.mShortcutsArray.elementAt(this.m_RaceManager.m_Karts[0].nearestPoint[1] - 1);
            if (np == sc.iPoints.length) {
                np = 0;
            }
            this.wayDir.set(sc.iPoints[np]);
            this.wayDir.sub(sc.iPoints[ap]);
        }
        this.kartDir.set(this.m_RaceManager.m_Karts[0].getBoundingBox()[6]);
        this.kartDir.sub(this.m_RaceManager.m_Karts[0].getBoundingBox()[5]);
        if (this.kartDir.FBdir(this.wayDir) < -0.5f) {
            Menu.bigFont.drawString(g, Text.getText(247), 320, 180, 3);
            return true;
        }
        return false;
    }

    protected void paintHUDlapFinished(Graphics g) {
        if (this.playerLaps > 1 && this.playerLaps <= gameLaps && this.raceTime - this.playerActLapTime < 3000L && this.blink) {
            Menu.bigFont.drawString(g, Text.getText(234) + " " + this.playerLaps + "/" + gameLaps, 320, 180, 3);
        }
    }

    protected void paintHUDafterRaceInfo(Graphics g) {
        String infoStr = "";
        infoStr = gameMode == 1 ? (this.pass ? Text.getText(244) : Text.getText(245)) : (this.pass ? Text.getText(242) : Text.getText(243));
        Menu.bigFont.drawString(g, infoStr, 320, 180, 3);
    }

    protected void paintHUDafterRaceSummary(Graphics g) {
        if (this.highscore && this.blink) {
            Menu.bigFont.drawString(g, Text.getText(246), 320, HUD_SUMMARY_Y - HUD_SUMMARY_H, 3);
        }
        for (int i = 0; i < this.playerLapTimes.length; ++i) {
            Menu.bigFont.drawString(g, Text.getText(234) + " " + (i + 1), HUD_SUMMARY_X, HUD_SUMMARY_Y + HUD_SUMMARY_H * i, 6);
            Menu.digtFont.drawString(g, GameFrame.timeToStr(this.playerLapTimes[i]), 640 - HUD_SUMMARY_X, HUD_SUMMARY_Y + HUD_SUMMARY_H * i, 10);
            if (i != this.playerBestLap - 1) continue;
            g.drawImage(this.hudStar, 640 - HUD_SUMMARY_X, HUD_SUMMARY_Y + HUD_SUMMARY_H * i, 6);
        }
        Menu.bigFont.drawString(g, Text.getText(236), HUD_SUMMARY_X, HUD_SUMMARY_Y + HUD_SUMMARY_H * gameLaps, 6);
        Menu.digtFont.drawString(g, GameFrame.timeToStr(this.playerTime), 640 - HUD_SUMMARY_X, HUD_SUMMARY_Y + HUD_SUMMARY_H * gameLaps, 10);
    }

    protected void paintHUDafterRaceUnlock(Graphics g) {
        for (int i = 0; i <= this.unlock; ++i) {
            Menu.bigFont.drawString(g, this.unlockStr[i], 320, 180 + (i - this.unlock / 2) * Menu.bigFont.getHeight(), 3);
        }
    }

    protected void paintHUDshade(Graphics g) {
        for (int i = 0; i < 640; i += this.hudShade.getWidth()) {
            for (int j = 0; j < 360; j += this.hudShade.getHeight()) {
                g.drawImage(this.hudShade, i, j, 20);
            }
        }
    }

    protected void paintHUDpressInfo(Graphics g) {
        if (this.blink) {
            Menu.bigFont.drawString(g, Text.getText(13), 320, 315 - Menu.bigFont.getHeight(), 3);
        }
    }

    protected void paintHUDPerformedDrifts(Graphics g) {
        String msg = Text.getText(69) + ": " + this.m_RaceManager.m_Karts[0].getDrfitBoostCounter();
        Menu.smallFont.drawString(g, msg, HUD_GAP, 315, 36);
    }

    protected void paintHUDcollectedDoors(Graphics g) {
        String msg = Text.getText(68) + ": " + (this.m_RaceManager.m_Karts[0].getCurrentDoor() + 1) + " " + Text.getText(70) + " " + this.m_RaceManager.getDoorNumber();
        Menu.smallFont.drawString(g, msg, HUD_GAP, 315, 36);
    }

    protected abstract void paintHUD(Graphics var1);

    public void release() {
        this.m_RaceManager = null;
    }

    public void pauseGame() {
        this.pauseTimer = MainCanvas.m_CurrTime;
    }

    public void resumeGame() {
        long pauseTime = MainCanvas.m_CurrTime - this.pauseTimer;
        this.timer += pauseTime;
        this.raceTimer += pauseTime;
        this.m_RaceManager.m_Karts[0].release();
        if (gameState >= 6) {
            this.raceTime = MainCanvas.m_CurrTime - this.raceTimer;
            this.timeStr = GameFrame.timeToStr(this.raceTime);
            this.m_RaceManager.m_Karts[0].acceleratePush();
        }
    }

    public void init_00() {
        this.m_RaceManager.init_00();
    }

    public void init_01() {
        this.m_RaceManager.init_01();
    }

    public void init_02() {
        this.m_RaceManager.init_02();
    }

    public void init_03() {
        this.m_RaceManager.init_03();
    }

    public void init_04() {
        this.m_RaceManager.init_04();
    }

    public void init_05() {
        this.m_RaceManager.init_05();
    }

    private void initTiles() {
        tiles = new Image[3];
        try {
            GameLogic.tiles[0] = Image.createImage((String)"/Sprites/Hud/small.png");
            GameLogic.tiles[1] = Image.createImage((String)"/Sprites/Hud/count.png");
            GameLogic.tiles[2] = Image.createImage((String)"/Sprites/Hud/items.png");
        }
        catch (IOException e) {
            System.out.println("HUD tiles init FAILED.");
        }
    }

    private void freeTiles() {
        if (tiles != null) {
            this.tiles_a = 0;
            while (this.tiles_a < 3) {
                GameLogic.tiles[this.tiles_a] = null;
                ++this.tiles_a;
            }
            tiles = null;
            System.gc();
        }
    }

    private void tileDrawImage(Graphics g, int tileset, int tile, int x, int y) {
        g.drawRegion(tiles[tileset], tiles_desc[tileset][tile][0], tiles_desc[tileset][tile][1], tiles_desc[tileset][tile][2], tiles_desc[tileset][tile][3], 0, x, y, 0);
    }

    static {
        gameLapsSet = 3;
        gameItemsSet = true;
        idle = true;
        CharUnlocks = new boolean[][]{{false, false, false}, {false, false, false}, {false, false, false}, {false, false, false}};
        KartUnlocks = new boolean[][]{{false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false}};
        tiles_desc = new int[][][]{new int[][]{{0, 0, 18, 18}, {18, 0, 18, 18}, {36, 0, 18, 18}, {54, 0, 18, 18}, {72, 0, 18, 18}, {90, 0, 18, 18}, {108, 0, 18, 18}, {126, 0, 18, 18}, {144, 0, 18, 18}, {162, 0, 18, 18}}, new int[][]{{0, 0, 123, 54}, {123, 0, 123, 54}, {246, 0, 123, 54}, {369, 0, 123, 54}}, new int[][]{{144, 0, 48, 48}, {0, 0, 48, 48}, {432, 0, 48, 48}, {336, 0, 48, 48}, {288, 0, 48, 48}, {384, 0, 48, 48}, {192, 0, 48, 48}, {240, 0, 48, 48}, {48, 0, 48, 48}, {96, 0, 48, 48}}};
    }
}

