/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class GameFrame {
    public MainMIDlet m_Midlet;
    public MainCanvas m_Canvas;
    public Random m_Random;
    public Graphics m_Graphics;
    public Font m_Font;
    public Menu m_Menu;
    private int[] m_Keys;
    private int[] m_KeyMap;
    public static final int KEY_ANY = 999;
    public boolean isRMS;
    static final int FIRST_STATE = -1;
    static final int GAME_STATE_INTRO = 1;
    static final int GAME_STATE_MENU = 2;
    static final int GAME_STATE_GAME = 3;
    static final int GAME_STATE_OPTIONS = 4;
    static final int GAME_STATE_EXIT = 5;
    static final int GAME_STATE_PAUSE = 6;
    public static int m_State;
    public static int m_StateBackup;
    public static int m_InternalState;
    public boolean m_StateInitialized;
    public boolean m_StateChanged;
    public boolean m_StateChanging;
    public boolean m_KeepRunning;
    private int m_IntroState;
    private int m_MenuState;
    private int m_GameState;
    public long m_LastPuckTime;
    private int m_MenuInd;
    public static Image img;
    private static Graphics gr;
    private Graphics g;
    public GameLogic currentGame;
    public boolean loadingInterrupted;
    private Image namcoImage;
    private Image fadeImage;
    private Image transImage;
    private Image AnnImage;
    private int introIa;
    private int introIb;
    private int introIv;
    private int introIx;
    private int introIy;
    private int fadeSize;
    public float currentFrame = 0.0f;

    public GameFrame(MainCanvas mc) {
        this.m_Midlet = mc.m_Midlet;
        this.m_Canvas = mc;
        this.m_Keys = new int[256];
        this.m_KeyMap = new int[32];
        this.m_Random = new Random();
    }

    public void clearKeys() {
        for (int i = 0; i < 256; ++i) {
            this.m_Keys[i] = 0;
        }
    }

    public void setKeyDown(int a_Key) {
        this.m_Keys[a_Key + 128] = 1;
    }

    public void setKeyUp(int a_Key) {
        this.m_Keys[a_Key + 128] = -1;
    }

    public boolean isKeyDown(int a_Key) {
        if (a_Key == 999) {
            for (int k = -128; k < 128; ++k) {
                if (!this.isKeyDown(k)) continue;
                return true;
            }
            return false;
        }
        return this.m_Keys[a_Key + 128] == 1;
    }

    public boolean isKeyUp(int a_Key) {
        if (a_Key == 999) {
            for (int k = -128; k < 128; ++k) {
                if (!this.isKeyUp(k)) continue;
                return true;
            }
            return false;
        }
        return this.m_Keys[a_Key + 128] == -1;
    }

    private int doInputHandling() {
        for (int i = 0; i < 256; ++i) {
            if (this.m_Keys[i] != -1) continue;
            this.m_Keys[i] = 0;
        }
        return 1;
    }

    public void init() {
        m_State = -1;
        this.m_StateChanging = false;
        this.m_StateChanged = false;
        this.m_KeepRunning = true;
        this.m_Font = Font.getFont((int)0, (int)1, (int)0);
        this.m_GameState = -1;
        this.m_IntroState = -1;
        this.m_MenuInd = 0;
        this.m_Menu = new Menu(this);
        this.m_Menu.enterLoading(0);
        img = Image.createImage((int)640, (int)360);
        this.g = img.getGraphics();
        GameLogic.m_GameFrame = this;
        GameLogic.gameState = 0;
        this.loadSettings();
        this.m_Menu.initTexts();
        GameLogic.gameLapsSet = Menu.menuSettings_sel[2][0] + 2;
        GameLogic.gameItemsSet = Menu.menuSettings_sel[3][0] == 0;
        SoundManager.init(this.m_Midlet);
        SoundManager.loadAll();
        this.changeState(1);
    }

    private int loadSettings() {
        RecordStore rs;
        try {
            rs = RecordStore.openRecordStore((String)"PMK3DSettings", (boolean)true);
        }
        catch (RecordStoreException rse) {
            this.isRMS = false;
            return 2;
        }
        try {
            if (rs.getNextRecordID() == 2) {
                byte[] data = rs.getRecord(1);
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                DataInputStream is = new DataInputStream(bais);
                try {
                    this.m_Menu.initSettings(true, is);
                    this.m_Menu.initHighScore(true, is);
                    this.m_Menu.initLocks(true, is);
                    this.m_Menu.initMissionBase(true, is);
                    int tmp = is.readInt();
                    data = null;
                    bais = null;
                    is = null;
                    this.isRMS = true;
                }
                catch (IOException io) {}
            } else {
                this.m_Menu.initHighScore(false, null);
                this.m_Menu.initLocks(false, null);
                this.isRMS = false;
                boolean tmp = false;
            }
        }
        catch (RecordStoreException rse) {
            this.isRMS = false;
            return 2;
        }
        try {
            rs.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            this.isRMS = false;
            return 2;
        }
        return 0;
    }

    public int saveSettings() {
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)"PMK3DSettings", (boolean)true);
        }
        catch (RecordStoreException rse) {
            return 2;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream os = new DataOutputStream(baos);
        try {
            int tmp = 1;
            this.m_Menu.updateSettings(os);
            this.m_Menu.updateHighScore(os);
            this.m_Menu.updateLocks(os);
            this.m_Menu.updateMissionBase(os);
            os.writeInt(tmp);
        }
        catch (Exception ioe) {
            return 2;
        }
        byte[] b = baos.toByteArray();
        try {
            if (rs.getNextRecordID() == 2) {
                rs.setRecord(1, b, 0, b.length);
            } else {
                rs.addRecord(b, 0, b.length);
            }
        }
        catch (RecordStoreException rse) {
            return 2;
        }
        try {
            rs.closeRecordStore();
        }
        catch (RecordStoreException rse) {
            return 2;
        }
        baos = null;
        os = null;
        b = null;
        return 0;
    }

    public void changeState(int a_NewState) {
        if (a_NewState == m_State) {
            return;
        }
        if (m_State != -1 && !this.m_StateChanging) {
            this.m_StateChanging = true;
            switch (m_State) {
                case 1: {
                    this.finishIntroState();
                    break;
                }
                case 2: {
                    this.finishMenuState();
                    break;
                }
                case 3: {
                    this.finishGameState();
                    break;
                }
                case 4: {
                    this.finishOptionsState();
                    break;
                }
                case 5: {
                    this.finishExitState();
                    break;
                }
                case 6: {
                    this.finishPauseState();
                }
            }
        }
        if (!this.m_StateChanged) {
            m_StateBackup = m_State;
            m_State = a_NewState;
            this.m_StateInitialized = false;
            this.m_StateChanged = true;
            switch (a_NewState) {
                case 1: {
                    this.initIntroState();
                    break;
                }
                case 2: {
                    this.initMenuState();
                    break;
                }
                case 3: {
                    this.initGameState();
                    break;
                }
                case 4: {
                    this.initOptionsState();
                    break;
                }
                case 5: {
                    this.initExitState();
                    break;
                }
                case 6: {
                    this.initPauseState();
                }
            }
            this.m_StateChanging = false;
        }
    }

    public void enterName() {
        this.clearKeys();
        this.m_Menu.goName();
        this.changeState(2);
    }

    public void showMessage(String msg) {
        this.clearKeys();
        this.currentGame.pauseGame();
        this.m_Menu.goMessage(msg);
        this.changeState(2);
    }

    public void showMessage(String msg, String msg2) {
        this.clearKeys();
        this.currentGame.pauseGame();
        this.m_Menu.goDoubleMessage(msg2, msg);
        this.changeState(2);
    }

    public void pauseGame() {
        this.clearKeys();
        SoundManager.pauseMusic();
        SoundManager.stopAllSfx();
        this.currentGame.pauseGame();
        this.m_Menu.goPause();
        this.changeState(2);
    }

    public void resumeGame() {
        this.currentGame.resumeGame();
        SoundManager.resumeMusic();
        this.changeState(3);
    }

    public boolean tick(Graphics g) {
        this.m_Graphics = g;
        this.m_StateChanged = false;
        switch (m_State) {
            case 1: {
                this.doIntroState();
                break;
            }
            case 2: {
                this.doMenuState();
                break;
            }
            case 3: {
                this.doGameState(this.currentFrame);
                break;
            }
            case 4: {
                this.doOptionsState();
                break;
            }
            case 5: {
                this.doExitState();
                break;
            }
            case 6: {
                this.doPauseState();
            }
        }
        this.doInputHandling();
        return this.m_KeepRunning;
    }

    private void initIntroState() {
        try {
            this.namcoImage = Image.createImage((String)"/Sprites/Intro/namco.png");
            this.fadeImage = Image.createImage((String)"/Sprites/Intro/fade.png");
            this.transImage = Image.createImage((String)"/Sprites/Intro/trans.png");
            this.AnnImage = Image.createImage((String)"/Sprites/Intro/30th.png");
        }
        catch (Exception e) {
            System.out.println("Error: Unable to load Intro images.");
            this.m_Midlet.destroyApp(false);
        }
        this.clearKeys();
    }

    private void doIntroState() {
        if (this.m_Menu.isLoading) {
            this.m_Menu.drawLoading(this.m_Graphics);
            this.m_LastPuckTime = System.currentTimeMillis();
            return;
        }
        switch (this.m_IntroState) {
            case -1: {
                ++this.m_IntroState;
                this.introIy = 255;
                this.fadeSize = this.fadeImage.getHeight();
                break;
            }
            case 0: 
            case 12: 
            case 14: {
                this.m_Graphics.setColor(0xFFFFFF);
                this.m_Graphics.setClip(0, 0, 640, 360);
                this.m_Graphics.fillRect(0, 0, 640, 360);
                if (MainCanvas.m_CurrTime - this.m_LastPuckTime <= 200L) break;
                ++this.m_IntroState;
                this.introIv = 0;
                this.introIx = 0;
                this.m_LastPuckTime = System.currentTimeMillis();
                this.introIx = 0;
                break;
            }
            case 1: {
                this.m_IntroState += 5;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.introIa = 640 - this.namcoImage.getWidth() >> 1;
                this.introIb = 360 - this.namcoImage.getHeight() >> 1;
                this.m_Graphics.setColor(0xFFFFFF);
                this.m_Graphics.fillRect(0, 0, 640, 360);
                this.m_Graphics.drawImage(this.namcoImage, this.introIa, this.introIb, 0);
                this.introIb = 360 - this.namcoImage.getHeight() >> 1;
                while (this.introIb < 360 + this.namcoImage.getHeight() >> 1) {
                    this.introIa = 640 - this.namcoImage.getWidth() >> 1;
                    while (this.introIa < 640 + this.namcoImage.getWidth() >> 1) {
                        this.m_Graphics.drawRegion(this.fadeImage, this.introIv, 0, this.fadeSize, this.fadeSize, 0, this.introIa, this.introIb, 0);
                        this.introIa += this.fadeSize;
                    }
                    this.introIb += this.fadeSize;
                }
                if (MainCanvas.m_CurrTime - this.m_LastPuckTime <= 100L) break;
                ++this.m_IntroState;
                this.m_LastPuckTime = System.currentTimeMillis();
                this.introIv += this.fadeSize;
                break;
            }
            case 6: {
                this.m_Graphics.setColor(0xFFFFFF);
                this.m_Graphics.fillRect(0, 0, 640, 360);
                this.m_Graphics.drawImage(this.namcoImage, 640 - this.namcoImage.getWidth() >> 1, 360 - this.namcoImage.getHeight() >> 1, 0);
                if (MainCanvas.m_CurrTime - this.m_LastPuckTime <= 4000L) break;
                ++this.m_IntroState;
                this.m_LastPuckTime = System.currentTimeMillis();
                this.introIv = 128;
                break;
            }
            case 13: {
                this.m_Graphics.setColor(0xFFFFFF);
                this.m_Graphics.fillRect(0, 0, 640, 360);
                this.m_Graphics.drawImage(this.AnnImage, 640 - this.AnnImage.getWidth() >> 1, 360 - this.AnnImage.getHeight() >> 1, 0);
                if (MainCanvas.m_CurrTime - this.m_LastPuckTime <= 3000L) break;
                ++this.m_IntroState;
                this.introIv = 0;
                this.introIx = 0;
                this.m_LastPuckTime = System.currentTimeMillis();
                break;
            }
            case 7: {
                this.m_IntroState += 5;
                break;
            }
            case 8: {
                System.out.println("8");
            }
            case 9: 
            case 10: 
            case 11: {
                System.out.println("11");
                this.introIa = 640 - this.namcoImage.getWidth() >> 1;
                this.introIb = 360 - this.namcoImage.getHeight() >> 1;
                this.m_Graphics.setColor(0xFFFFFF);
                this.m_Graphics.fillRect(0, 0, 640, 360);
                this.m_Graphics.drawImage(this.namcoImage, this.introIa, this.introIb, 0);
                this.fadeSize = this.fadeImage.getHeight();
                this.introIb = 360 - this.namcoImage.getHeight() >> 1;
                while (this.introIb < 360 + this.namcoImage.getHeight() >> 1) {
                    this.introIa = 640 - this.namcoImage.getWidth() >> 1;
                    while (this.introIa < 640 + this.namcoImage.getWidth() >> 1) {
                        this.m_Graphics.drawRegion(this.fadeImage, this.introIv, 0, this.fadeSize, this.fadeSize, 0, this.introIa, this.introIb, 0);
                        this.introIa += this.fadeSize;
                    }
                    this.introIb += this.fadeSize;
                }
                if (MainCanvas.m_CurrTime - this.m_LastPuckTime <= 100L) break;
                ++this.m_IntroState;
                this.m_LastPuckTime = System.currentTimeMillis();
                this.introIv -= this.fadeSize;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.introIb = 0;
                while (this.introIb < 360) {
                    this.introIa = 0;
                    while (this.introIa < 640) {
                        this.m_Graphics.drawRegion(this.transImage, this.introIx, 0, this.fadeSize, this.fadeSize, 0, this.introIa, this.introIb, 0);
                        this.introIa += this.fadeSize;
                    }
                    this.introIb += this.fadeSize;
                }
                if (MainCanvas.m_CurrTime - this.m_LastPuckTime <= 100L) break;
                ++this.m_IntroState;
                this.m_LastPuckTime = System.currentTimeMillis();
                this.introIx += this.fadeSize;
                break;
            }
            case 20: {
                if (Menu.currentLang == -1) {
                    this.m_Menu.goLangSel();
                    this.changeState(2);
                } else {
                    this.m_Menu.dontGoLangSel();
                }
                ++this.m_IntroState;
                break;
            }
            case 21: {
                this.m_Graphics.setColor(0);
                this.m_Graphics.fillRect(0, 0, 640, 360);
                this.m_Menu.goSoundQ();
                ++this.m_IntroState;
                this.changeState(2);
                break;
            }
            case 22: {
                this.m_Graphics.setColor(0);
                this.m_Graphics.fillRect(0, 0, 640, 360);
                ++this.m_IntroState;
                this.m_LastPuckTime = System.currentTimeMillis();
                this.introIx = this.fadeSize << 2;
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                this.introIb = 0;
                while (this.introIb < 360) {
                    this.introIa = 0;
                    while (this.introIa < 640) {
                        this.m_Graphics.drawRegion(this.transImage, this.introIx, 0, this.fadeSize, this.fadeSize, 0, this.introIa, this.introIb, 0);
                        this.introIa += this.fadeSize;
                    }
                    this.introIb += this.fadeSize;
                }
                if (MainCanvas.m_CurrTime - this.m_LastPuckTime <= 100L) break;
                ++this.m_IntroState;
                this.m_LastPuckTime = System.currentTimeMillis();
                this.introIx -= this.fadeSize;
                break;
            }
            case 28: {
                SoundManager.playMusic(1);
                this.m_Graphics.setColor(-1);
                this.m_Graphics.fillRect(0, 0, 640, 360);
                this.m_Menu.startIntro();
                ++this.m_IntroState;
                this.m_LastPuckTime = System.currentTimeMillis();
                break;
            }
            case 29: {
                this.namcoImage = null;
                this.fadeImage = null;
                this.AnnImage = null;
                System.gc();
                this.m_Menu.drawMenuBackground(this.m_Graphics);
                this.m_Menu.drawPressAny(this.m_Graphics);
                if (MainCanvas.m_CurrTime - this.m_LastPuckTime <= 5000L) break;
                this.leavePressAny();
                this.m_LastPuckTime = System.currentTimeMillis();
            }
        }
    }

    public void leavePressAny() {
        this.clearKeys();
        this.m_Menu.goMenu(0, true);
        this.changeState(2);
    }

    private void finishIntroState() {
    }

    private void initMenuState() {
        this.clearKeys();
        this.m_MenuState = 0;
        this.m_MenuInd = 0;
        this.m_LastPuckTime = System.currentTimeMillis();
    }

    private void doMenuState() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Menu.paint(this.m_Graphics);
        if (this.m_Menu.currentT == 2 || this.m_Menu.currentT == 16 || this.m_Menu.currentT == 10) {
            if (this.isKeyDown(6)) {
                this.m_Menu.scrollDown();
            } else if (this.isKeyDown(1)) {
                this.m_Menu.scrollUp();
            }
        } else if (this.isKeyUp(6)) {
            this.clearKeys();
            this.m_Menu.incItem(false);
        } else if (this.isKeyUp(1)) {
            this.clearKeys();
            this.m_Menu.decItem();
        }
        if (this.isKeyUp(8) || this.isKeyUp(-6)) {
            this.clearKeys();
            this.m_Menu.goNext();
        } else if (this.isKeyDown(-7)) {
            this.clearKeys();
            if (this.m_Menu.currentSfk != null && this.m_Menu.currentSfk[0]) {
                this.m_Menu.goPrev();
            }
        } else if (this.isKeyUp(5)) {
            this.clearKeys();
            this.m_Menu.nextItem();
        } else if (this.isKeyUp(2)) {
            this.clearKeys();
            this.m_Menu.prevItem();
        }
    }

    private void finishMenuState() {
    }

    private void initPauseState() {
        this.clearKeys();
    }

    private void doPauseState() {
    }

    private void finishPauseState() {
    }

    private void initOptionsState() {
        this.clearKeys();
        this.m_LastPuckTime = System.currentTimeMillis();
    }

    private void doOptionsState() {
    }

    private void finishOptionsState() {
    }

    public void initGameLogic() {
        this.currentGame = GameLogic.gameMode == 1 ? new MissionManager() : new GameManager();
        this.currentGame.init();
    }

    public void releaseGameLogic() {
        if (this.currentGame != null) {
            this.currentGame.release();
        }
        GameLogic.idle = true;
        this.currentGame = null;
        System.gc();
        Kart.clearData();
        SimpleObject.clear();
        SpriteLoader.free();
    }

    private void initGameState() {
        this.clearKeys();
        this.m_LastPuckTime = System.currentTimeMillis();
        this.currentGame.update(1.0f);
    }

    private void doGameState(float frame) {
        boolean finish = this.currentGame.update(frame);
        this.currentGame.paint(this.g);
        this.m_Graphics.drawImage(img, 0, 0, 0);
        if (finish) {
            this.m_Menu.goAfter();
            this.changeState(2);
        }
        if ((this.isKeyDown(-6) || this.loadingInterrupted) && (GameLogic.gameState == 6 || GameLogic.gameState == 2 || GameLogic.gameState == 5)) {
            this.loadingInterrupted = false;
            this.pauseGame();
        }
    }

    private void finishGameState() {
    }

    private void initExitState() {
        this.clearKeys();
        this.m_LastPuckTime = System.currentTimeMillis();
    }

    private void doExitState() {
    }

    private void finishExitState() {
    }

    public void updateFrame() {
        long duration = System.currentTimeMillis() - MainCanvas.m_CurrTime;
        float tempFPS = 1000.0f / (float)duration;
        this.currentFrame = 12.0f / tempFPS;
        MainCanvas.m_CurrTime = System.currentTimeMillis();
    }

    public static String timeToStr(long longTime) {
        String stringTime = "";
        int min = (int)(longTime / 1000L) / 60;
        int sec = (int)(longTime / 1000L) % 60;
        int ms = (int)longTime % 1000;
        if (min > 0) {
            stringTime = min + ":";
            if (sec < 10) {
                stringTime = stringTime + "0";
            }
        }
        stringTime = stringTime + sec + ":";
        if (ms < 100) {
            stringTime = stringTime + "0";
            if (ms < 10) {
                stringTime = stringTime + "0";
            }
        }
        stringTime = stringTime + ms;
        return stringTime;
    }
}

