/*
 * Decompiled with CFR 0.152.
 */
package mcloud.sik.smssender;

import javax.microedition.io.Connector;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;
import mcloud.sik.common.Module;
import mcloud.sik.common.Params;
import mcloud.sik.common.Resources;
import mcloud.sik.common.SIK;

public class SMSSenderModule
extends Module
implements Resources,
Params,
Runnable {
    public static final int SMS_SENDING_TIMEOUT = 10000;
    private String smsNumber = "";
    private String smsMessage = "";
    private int callingModule;
    private String message;
    private int status;
    private final byte PARAM_CALL_MODULE;
    private final byte PARAM_SMS_NUMBER;
    private final byte PARAM_SMS_MESSAGE = (byte)2;
    private byte STATE_SENDING = 0;
    private boolean callbackOldStyle = true;

    public SMSSenderModule() {
        this.PARAM_CALL_MODULE = 0;
        this.PARAM_SMS_NUMBER = 1;
    }

    public boolean initActive(Object[] params) {
        if (params != null && params.length == 3) {
            this.callingModule = (Integer)params[0];
            this.smsNumber = (String)params[1];
            this.smsMessage = (String)params[2];
        }
        this.setState(this.STATE_SENDING);
        return true;
    }

    public void run() {
        this.sendSMS(this.smsNumber, this.smsMessage);
    }

    public void initState(byte newState) {
        if (newState == this.STATE_SENDING) {
            new Thread(this).start();
        }
    }

    public void destroy() {
    }

    private MessageConnection openConn(String url) throws Exception {
        MessageConnection messageConnection;
        MessageConnection messageConnection2 = messageConnection = (MessageConnection)Connector.open((String)url);
        return messageConnection2;
    }

    public void sentPartOfSMS(MessageConnection messageConnection, String text) throws Exception {
        TextMessage textMessage = (TextMessage)messageConnection.newMessage("text");
        textMessage.setPayloadText(text);
        int numberOfSegments = messageConnection.numberOfSegments((Message)textMessage);
        if (numberOfSegments == 0) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            throw new Exception("numberOfSegments = 0");
        }
        messageConnection.send((Message)textMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSMS(String number, String message) {
        String url = "sms://" + number;
        MessageConnection messageConnection = null;
        try {
            messageConnection = this.openConn(url);
            this.sentPartOfSMS(messageConnection, message);
            this.status = 1;
            if (this.callbackOldStyle) {
                SIK.instance.getModule(this.callingModule).smsSenderCallback(this.status);
            } else {
                SIK.instance.getHardware().notifySMSState(this.status);
            }
        }
        catch (Exception e) {
            this.status = 2;
            SIK.instance.getModule(this.callingModule).smsSenderCallback(this.status);
        }
        finally {
            try {
                if (messageConnection != null) {
                    messageConnection.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public int getOperationResult() {
        return this.status;
    }

    public String getOperationDetails() {
        return this.message;
    }

    public void setCallingModule(int callingModule) {
        this.callingModule = callingModule;
    }

    public void setCallbackOldStyle(boolean callbackOldStyle) {
        this.callbackOldStyle = callbackOldStyle;
    }
}

