/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.m3g.Graphics3D;

public class TrackHelper
extends TrackObject {
    public static final int TYPE_SLOW_DOWN = 0;
    public static final int TYPE_BOOST = 1;
    public static final int TYPE_JUMPER = 2;
    public static final int TYPE_ARCH = 3;
    public static final int NUMBER_OF_TYPES = 4;
    private float size;
    private int type;
    private SimpleObject object;
    private SimpleObject alt;
    private float frameCounter = 0.0f;
    private boolean active = false;
    Vector3D movementPlaneRot = new Vector3D();
    Vector3D trackDirection = new Vector3D();
    public int num = 0;

    public TrackHelper() {
        this.vPosition = new Vector3D();
    }

    public void init(Vector3D location, int objecttype, int objectNum) {
        this.type = objecttype;
        float scale = 64.0f * (float)Track.mScale;
        switch (objecttype) {
            case 0: {
                this.object = new SimpleObject();
                this.alt = new SimpleObject();
                this.object.init("/Sprites/Onroad/slow_" + Stats.worldName[GameLogic.gameWorld] + ".png", scale, scale, false, false);
                this.alt.init("/Sprites/Onroad/slow_" + Stats.worldName[GameLogic.gameWorld] + "_alt.png", scale, scale, false, false);
                break;
            }
            case 1: {
                this.object = new SimpleObject();
                this.alt = new SimpleObject();
                this.object.init("/Sprites/Onroad/boost.png", scale, scale, false, false);
                this.alt.init("/Sprites/Onroad/boost_alt.png", scale, scale, false, false);
                break;
            }
            case 2: {
                this.object = new SimpleObject();
                this.object.init("/Meshes/Other/jump.vam", "/Meshes/Other/jump.png", 1.0f, false, false);
                break;
            }
            case 3: {
                this.object = new SimpleObject();
                this.object.init("/Meshes/Other/arch.vam", "/Meshes/Other/arch.png", 62.0f, false, false);
                this.num = objectNum;
            }
        }
        this.vPosition.set(location);
        this.objectInfo = "track helper";
        this.size = scale / 2.0f * (scale / 2.0f) * 1.0f;
    }

    public void setGround(float h, Vector3D planeNorm) {
        this.object.setPosition(this.vPosition);
        this.object.setGroundLevel(h - this.object.getHeight());
        this.movementPlaneRot.setz(-((float)mMath.toDegrees(mMath.asin(planeNorm.getx()))));
        this.movementPlaneRot.setx((float)mMath.toDegrees(mMath.asin(planeNorm.getz())));
        if (this.type == 2) {
            this.object.setRotation(new Vector3D(0.0f, 90.0f, 0.0f));
            this.object.setPlaneRotation(this.movementPlaneRot);
            this.object.update();
        } else if (this.type == 3) {
            this.object.setRotation(new Vector3D(0.0f, 0.0f, 0.0f));
            this.object.setPlaneRotation(this.movementPlaneRot);
            this.object.update();
        } else {
            this.object.setDirection(new Vector3D(0.0f, 1.0f, 0.0f));
            this.alt.setPosition(this.vPosition);
            this.alt.setGroundLevel(h - this.object.getHeight());
            this.alt.setDirection(new Vector3D(0.0f, 1.0f, 0.0f));
            this.object.setPlaneRotation(this.movementPlaneRot);
            this.alt.setPlaneRotation(this.movementPlaneRot);
            this.object.update();
            this.alt.update();
        }
    }

    public void setTrackRotation(float rot) {
        this.movementPlaneRot.sety(rot);
    }

    public float getCollisionRadius() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public void update(float frame) {
        if (this.active) {
            this.frameCounter -= frame;
        }
        if (this.frameCounter < 0.0f) {
            this.frameCounter = 0.0f;
            this.active = false;
        }
    }

    public void render(Graphics3D g3d) {
        if (!this.sleeping) {
            if (this.frameCounter > 0.0f && this.type != 2 && this.type != 3) {
                this.alt.render(g3d);
            } else {
                this.object.render(g3d);
            }
        }
    }

    public void used() {
        this.active = true;
        this.frameCounter = 5.0f;
    }
}

