/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Loader;
import javax.microedition.m3g.Mesh;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class Track {
    public static final String TRACK_DIR = "/Track/";
    public static final int ROADSIDE_WALL_HEIGHT = 100;
    public static int mScale = 1;
    public static final int[][] TXT_TILES_COORDINATES = new int[][]{{0, 63, 63, 63, 0, 0, 63, 0}, {64, 63, 127, 63, 64, 0, 127, 0}, {128, 63, 191, 63, 128, 0, 191, 0}, {192, 63, 255, 63, 192, 0, 255, 0}, {0, 127, 63, 127, 0, 64, 63, 64}, {64, 127, 127, 127, 64, 64, 127, 64}, {128, 127, 191, 127, 128, 64, 191, 64}, {192, 64, 192, 127, 255, 64, 255, 127}, {0, 191, 63, 191, 0, 128, 63, 128}, {64, 191, 127, 191, 64, 128, 127, 128}, {128, 191, 191, 191, 128, 128, 191, 128}, {192, 191, 255, 191, 192, 128, 255, 128}, {0, 255, 63, 255, 0, 192, 63, 192}, {64, 255, 127, 255, 64, 192, 127, 192}, {128, 255, 191, 255, 128, 192, 191, 192}, {192, 255, 255, 255, 192, 192, 255, 192}};
    public int numBasePoints;
    public int numInterpolationSteps;
    private int m_versionNumber;
    private int[] m_tBasePoints;
    public Vector3D[] iPoints;
    public float[] iPointsWidth;
    private float[] iPointsAngle;
    public short[] roadVertices;
    public short[] leftSideVertices;
    public short[] rightSideVertices;
    public short[] leftWallVertices;
    public short[] rightWallVertices;
    public float roadSideWidth;
    public int m_numTextures;
    public String[] m_TextureNames;
    public int m_startPoint;
    public Vector[] mItemArray;
    public boolean[][] mItemMovableArray;
    public float[] mItemScale;
    public Vector[] mHelperArray;
    public Vector mShortcutsArray = new Vector();
    public Vector3D[] mArchPos;
    public Vector3D[] mGatePos;
    public int[] mainRoadTextureNr;
    public int[] leftSideTextureNr;
    public int[] rightSideTextureNr;
    public int[] leftWallTextureNr;
    public int[] rightWallTextureNr;
    int tx;
    int ty;
    int tz;
    float sx;
    float sy;
    float sz;
    public Mesh[] meshTrackSegments;
    public Mesh[] meshLeftSideSegments;
    public Mesh[] meshRightSideSegments;
    public Mesh[] meshLeftWallSegments;
    public Mesh[] meshRightWallSegments;
    public Appearance roadAp;
    public Appearance wallAp;
    private Texture2D mTexture;
    static /* synthetic */ Class class$Track;

    public void init(String fileName) {
        this.sz = 1.0f;
        this.sy = 1.0f;
        this.sx = 1.0f;
        this.setupTrackAppearance();
        this.loadTrackData(fileName);
        this.generateTrackVertices();
        this.generateTrackMeshes();
    }

    private void setupTrackAppearance() {
        try {
            int wnr = GameLogic.gameWorld + 1;
            this.mTexture = new Texture2D((Image2D)Loader.load((String)("/Track/txt_theme_" + wnr + ".png"))[0]);
            this.mTexture.setBlending(228);
            this.mTexture.setWrapping(240, 240);
        }
        catch (Exception e) {
            System.out.println("Error while initializing track textures.");
        }
        CompositingMode cm = new CompositingMode();
        cm.setDepthTestEnable(true);
        cm.setDepthWriteEnable(true);
        cm.setAlphaWriteEnable(false);
        cm.setBlending(68);
        PolygonMode pm = new PolygonMode();
        pm.setPerspectiveCorrectionEnable(true);
        pm.setCulling(160);
        pm.setLocalCameraLightingEnable(false);
        pm.setTwoSidedLightingEnable(false);
        this.roadAp = new Appearance();
        this.roadAp.setPolygonMode(pm);
        this.roadAp.setCompositingMode(cm);
        this.roadAp.setTexture(0, this.mTexture);
        PolygonMode wallPm = new PolygonMode();
        wallPm.setPerspectiveCorrectionEnable(true);
        wallPm.setCulling(162);
        wallPm.setLocalCameraLightingEnable(false);
        wallPm.setTwoSidedLightingEnable(false);
        CompositingMode wallCm = new CompositingMode();
        wallCm.setDepthTestEnable(true);
        wallCm.setDepthWriteEnable(true);
        wallCm.setAlphaWriteEnable(true);
        wallCm.setBlending(64);
        wallCm.setAlphaThreshold(0.1f);
        this.wallAp = new Appearance();
        this.wallAp.setPolygonMode(wallPm);
        this.wallAp.setCompositingMode(wallCm);
        this.wallAp.setTexture(0, this.mTexture);
    }

    private void loadTrackData(String fileName) {
        try {
            int i;
            DataInputStream din = new DataInputStream((class$Track == null ? (class$Track = Track.class$("Track")) : class$Track).getResourceAsStream(TRACK_DIR + fileName));
            this.m_versionNumber = din.readInt();
            this.numBasePoints = din.readInt();
            this.numInterpolationSteps = din.readInt();
            this.m_startPoint = din.readInt();
            this.roadSideWidth = din.readInt();
            int bpSize = this.numBasePoints * 5;
            this.m_tBasePoints = new int[bpSize];
            for (i = 0; i < bpSize; ++i) {
                if (i < this.m_startPoint * 5) {
                    this.m_tBasePoints[bpSize + i - this.m_startPoint * 5] = din.readInt();
                    continue;
                }
                this.m_tBasePoints[i - this.m_startPoint * 5] = din.readInt();
            }
            for (i = 0; i < this.numBasePoints; ++i) {
                int n = i * 5 + 0;
                this.m_tBasePoints[n] = this.m_tBasePoints[n] + this.tx;
                int n2 = i * 5 + 1;
                this.m_tBasePoints[n2] = this.m_tBasePoints[n2] + this.ty;
                int n3 = i * 5 + 2;
                this.m_tBasePoints[n3] = this.m_tBasePoints[n3] + this.tz;
            }
            this.mainRoadTextureNr = new int[this.numBasePoints * this.numInterpolationSteps + 1];
            this.leftSideTextureNr = new int[this.mainRoadTextureNr.length];
            this.rightSideTextureNr = new int[this.mainRoadTextureNr.length];
            this.leftWallTextureNr = new int[this.mainRoadTextureNr.length];
            this.rightWallTextureNr = new int[this.mainRoadTextureNr.length];
            for (int i2 = 0; i2 < this.mainRoadTextureNr.length; ++i2) {
                int index = i2 < this.m_startPoint * this.numInterpolationSteps ? this.mainRoadTextureNr.length + i2 - this.m_startPoint * this.numInterpolationSteps : i2 - this.m_startPoint * this.numInterpolationSteps;
                if (GameLogic.gameMode != 5) {
                    this.mainRoadTextureNr[index] = din.readByte();
                    this.leftSideTextureNr[index] = din.readByte();
                    this.rightSideTextureNr[index] = din.readByte();
                    this.leftWallTextureNr[index] = din.readByte();
                    this.rightWallTextureNr[index] = din.readByte();
                    if (i2 != this.mainRoadTextureNr.length - 1) continue;
                    this.mainRoadTextureNr[index] = this.mainRoadTextureNr[index - 1];
                    this.leftSideTextureNr[index] = this.leftSideTextureNr[index - 1];
                    this.rightSideTextureNr[index] = this.rightSideTextureNr[index - 1];
                    this.leftWallTextureNr[index] = this.leftWallTextureNr[index - 1];
                    this.rightWallTextureNr[index] = this.rightWallTextureNr[index - 1];
                    continue;
                }
                this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 1) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 2;
                } else if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 2) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 1;
                }
                if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 5) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 6;
                } else if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 6) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 5;
                }
                if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 9) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 10;
                } else if (this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] == 10) {
                    this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = 9;
                }
                this.leftSideTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                this.rightSideTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                this.leftWallTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                this.rightWallTextureNr[this.mainRoadTextureNr.length - index - 1] = din.readByte();
                if (i2 != this.mainRoadTextureNr.length - 1) continue;
                this.mainRoadTextureNr[this.mainRoadTextureNr.length - index - 1] = this.mainRoadTextureNr[this.mainRoadTextureNr.length - index];
                this.leftSideTextureNr[this.mainRoadTextureNr.length - index - 1] = this.leftSideTextureNr[this.mainRoadTextureNr.length - index];
                this.rightSideTextureNr[this.mainRoadTextureNr.length - index - 1] = this.rightSideTextureNr[this.mainRoadTextureNr.length - index];
                this.leftWallTextureNr[this.mainRoadTextureNr.length - index - 1] = this.leftWallTextureNr[this.mainRoadTextureNr.length - index];
                this.rightWallTextureNr[this.mainRoadTextureNr.length - index - 1] = this.rightWallTextureNr[this.mainRoadTextureNr.length - index];
            }
            if (this.m_versionNumber >= 7) {
                float z;
                float y;
                int j;
                int numItem;
                int i3;
                int numItemType = din.readInt();
                boolean helpers = false;
                if (numItemType > 19) {
                    helpers = true;
                    numItemType -= 5;
                }
                this.mItemArray = new Vector[numItemType];
                this.mItemScale = new float[numItemType];
                if (this.m_versionNumber >= 10) {
                    this.mItemMovableArray = new boolean[numItemType][0];
                }
                for (i3 = 0; i3 < numItemType; ++i3) {
                    this.mItemArray[i3] = new Vector();
                    numItem = din.readInt();
                    this.mItemScale[i3] = din.readInt();
                    if (this.m_versionNumber >= 10) {
                        this.mItemMovableArray[i3] = new boolean[numItem];
                    }
                    for (j = 0; j < numItem; ++j) {
                        if (this.m_versionNumber >= 10) {
                            this.mItemMovableArray[i3][j] = din.readBoolean();
                        }
                        float x = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                        y = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                        z = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                        Vector3D tmp = GameLogic.gameMode == 5 ? new Vector3D(-x, -y, z) : new Vector3D(x, y, z);
                        this.mItemArray[i3].addElement(tmp);
                    }
                }
                if (helpers) {
                    this.mHelperArray = new Vector[3];
                    for (i3 = 0; i3 < 3; ++i3) {
                        this.mHelperArray[i3] = new Vector();
                        numItem = din.readInt();
                        float scale = din.readInt();
                        for (int j2 = 0; j2 < numItem; ++j2) {
                            float x = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                            y = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                            z = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                            Vector3D tmp = GameLogic.gameMode == 5 ? new Vector3D(-x, -y, z) : new Vector3D(x, y, z);
                            this.mHelperArray[i3].addElement(tmp);
                        }
                    }
                    int numItem2 = din.readInt();
                    float scale = din.readInt();
                    this.mArchPos = new Vector3D[numItem2];
                    for (j = 0; j < numItem2; ++j) {
                        float x = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                        y = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                        z = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                        this.mArchPos[j] = GameLogic.gameMode == 5 ? new Vector3D(-x, -y, z) : new Vector3D(x, y, z);
                        int rot = din.readInt();
                    }
                    numItem2 = din.readInt();
                    scale = din.readInt();
                    this.mGatePos = new Vector3D[numItem2];
                    for (j = 0; j < numItem2; ++j) {
                        float x = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                        y = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                        z = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                        this.mGatePos[j] = GameLogic.gameMode == 5 ? new Vector3D(-x, -y, z) : new Vector3D(x, y, z);
                        int rot = din.readInt();
                        int gateNr = din.readInt();
                    }
                }
            }
            if (this.m_versionNumber >= 8) {
                int numArrays = din.readInt();
                for (int j = 0; j < numArrays; ++j) {
                    TrackShortcut sc;
                    int i4;
                    int endSide;
                    int startSide;
                    int n = din.readInt();
                    int steps = din.readInt();
                    int rw = din.readInt();
                    int sp = din.readInt();
                    int ep = din.readInt();
                    int[] startPoints = new int[4];
                    int[] endPoints = new int[4];
                    if (GameLogic.gameMode != 5) {
                        startSide = din.readInt();
                        endSide = din.readInt();
                        for (i4 = 0; i4 < startPoints.length; ++i4) {
                            startPoints[i4] = din.readInt() - this.m_startPoint * this.numInterpolationSteps;
                            if (startPoints[i4] >= 0) continue;
                            startPoints[i4] = this.numInterpolationSteps * this.numBasePoints + startPoints[i4];
                        }
                        for (i4 = 0; i4 < endPoints.length; ++i4) {
                            endPoints[i4] = din.readInt() - this.m_startPoint * this.numInterpolationSteps;
                            if (endPoints[i4] >= 0) continue;
                            endPoints[i4] = this.numInterpolationSteps * this.numBasePoints + endPoints[i4];
                        }
                        sc = new TrackShortcut(this, sp, ep, n, steps, rw);
                        for (i4 = 0; i4 < sc.numBasePoints; ++i4) {
                            sc.xPoints[i4] = (float)((din.readInt() + this.tx) * mScale) * this.sx;
                            sc.zPoints[i4] = (float)((din.readInt() + this.ty) * mScale) * this.sy;
                            sc.yPoints[i4] = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                            sc.wPoints[i4] = din.readInt() * mScale;
                            sc.aPoints[i4] = din.readInt();
                        }
                    } else {
                        endSide = din.readInt();
                        startSide = din.readInt();
                        for (i4 = 0; i4 < endPoints.length; ++i4) {
                            endPoints[endPoints.length - 1 - i4] = (this.numBasePoints + this.m_startPoint) * this.numInterpolationSteps - din.readInt();
                            if (endPoints[endPoints.length - 1 - i4] <= this.numInterpolationSteps * this.numBasePoints) continue;
                            int n4 = endPoints.length - 1 - i4;
                            endPoints[n4] = endPoints[n4] - this.numInterpolationSteps * this.numBasePoints;
                        }
                        for (i4 = 0; i4 < startPoints.length; ++i4) {
                            startPoints[startPoints.length - 1 - i4] = (this.numBasePoints + this.m_startPoint) * this.numInterpolationSteps - din.readInt();
                            if (startPoints[startPoints.length - 1 - i4] <= this.numInterpolationSteps * this.numBasePoints) continue;
                            int n5 = startPoints.length - 1 - i4;
                            startPoints[n5] = startPoints[n5] - this.numInterpolationSteps * this.numBasePoints;
                        }
                        sc = new TrackShortcut(this, sp, ep, n, steps, rw);
                        for (i4 = 0; i4 < sc.numBasePoints; ++i4) {
                            sc.xPoints[sc.numBasePoints - 1 - i4] = (float)((-din.readInt() + this.tx) * mScale) * this.sx;
                            sc.zPoints[sc.numBasePoints - 1 - i4] = (float)((-din.readInt() + this.ty) * mScale) * this.sy;
                            sc.yPoints[sc.numBasePoints - 1 - i4] = (float)((din.readInt() + this.tz) * mScale) * this.sz;
                            sc.wPoints[sc.numBasePoints - 1 - i4] = din.readInt() * mScale;
                            sc.aPoints[sc.numBasePoints - 1 - i4] = din.readInt();
                        }
                    }
                    sc.mainRoadTextureNr = new int[(sc.numBasePoints - 1) * sc.numInterpolationSteps];
                    sc.leftSideTextureNr = new int[sc.mainRoadTextureNr.length];
                    sc.rightSideTextureNr = new int[sc.mainRoadTextureNr.length];
                    sc.leftWallTextureNr = new int[sc.mainRoadTextureNr.length];
                    sc.rightWallTextureNr = new int[sc.mainRoadTextureNr.length];
                    for (i4 = 0; i4 < (sc.numBasePoints - 1) * sc.numInterpolationSteps; ++i4) {
                        if (GameLogic.gameMode != 5) {
                            sc.mainRoadTextureNr[i4] = din.readByte();
                            sc.leftSideTextureNr[i4] = din.readByte();
                            sc.rightSideTextureNr[i4] = din.readByte();
                            sc.leftWallTextureNr[i4] = din.readByte();
                            sc.rightWallTextureNr[i4] = din.readByte();
                            continue;
                        }
                        sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                        if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 1) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 2;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 2) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 1;
                        }
                        if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 5) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 6;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 6) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 5;
                        }
                        if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 9) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 10;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 10) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 9;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 11) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 12;
                        } else if (sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] == 12) {
                            sc.mainRoadTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = 11;
                        }
                        sc.leftSideTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                        sc.rightSideTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                        sc.leftWallTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                        sc.rightWallTextureNr[sc.mainRoadTextureNr.length - i4 - 1] = din.readByte();
                    }
                    sc.createGeometry();
                    sc.startSide = startSide;
                    sc.endSide = endSide;
                    for (i4 = 0; i4 < startPoints.length; ++i4) {
                        sc.startPoints[i4] = startPoints[i4];
                    }
                    for (i4 = 0; i4 < endPoints.length; ++i4) {
                        sc.endPoints[i4] = endPoints[i4];
                    }
                    this.mShortcutsArray.addElement(sc);
                }
            }
            din.close();
        }
        catch (Exception e) {
            System.out.println("Error while loading track data.");
        }
    }

    private void generateTrackVertices() {
        Vector3D v3;
        int i;
        int i2;
        float[] xPoints = new float[this.numBasePoints];
        float[] yPoints = new float[this.numBasePoints];
        float[] zPoints = new float[this.numBasePoints];
        float[] wPoints = new float[this.numBasePoints];
        float[] aPoints = new float[this.numBasePoints];
        if (GameLogic.gameMode != 5) {
            for (i2 = 0; i2 < this.numBasePoints; ++i2) {
                xPoints[i2] = (float)(this.m_tBasePoints[i2 * 5 + 0] * mScale) * this.sx;
                yPoints[i2] = (float)(this.m_tBasePoints[i2 * 5 + 1] * mScale) * this.sy;
                zPoints[i2] = (float)(this.m_tBasePoints[i2 * 5 + 2] * mScale) * this.sz;
                wPoints[i2] = this.m_tBasePoints[i2 * 5 + 3] * mScale;
                aPoints[i2] = this.m_tBasePoints[i2 * 5 + 4];
            }
        } else {
            xPoints[0] = (float)(-this.m_tBasePoints[0] * mScale) * this.sx;
            yPoints[0] = (float)(-this.m_tBasePoints[1] * mScale) * this.sy;
            zPoints[0] = (float)(this.m_tBasePoints[2] * mScale) * this.sz;
            wPoints[0] = this.m_tBasePoints[3] * mScale;
            aPoints[0] = this.m_tBasePoints[4];
            for (i2 = 1; i2 < this.numBasePoints; ++i2) {
                xPoints[this.numBasePoints - i2] = (float)(-this.m_tBasePoints[i2 * 5 + 0] * mScale) * this.sx;
                yPoints[this.numBasePoints - i2] = (float)(-this.m_tBasePoints[i2 * 5 + 1] * mScale) * this.sy;
                zPoints[this.numBasePoints - i2] = (float)(this.m_tBasePoints[i2 * 5 + 2] * mScale) * this.sz;
                wPoints[this.numBasePoints - i2] = this.m_tBasePoints[i2 * 5 + 3] * mScale;
                aPoints[this.numBasePoints - i2] = this.m_tBasePoints[i2 * 5 + 4];
            }
        }
        Spline[] xSpline = Spline.calculateClosedCubic(this.numBasePoints - 1, xPoints);
        Spline[] ySpline = Spline.calculateClosedCubic(this.numBasePoints - 1, yPoints);
        Spline[] zSpline = Spline.calculateClosedCubic(this.numBasePoints - 1, zPoints);
        Spline[] wSpline = Spline.calculateClosedCubic(this.numBasePoints - 1, wPoints);
        Spline[] aSpline = Spline.calculateClosedCubic(this.numBasePoints - 1, aPoints);
        int size = this.numInterpolationSteps * this.numBasePoints;
        this.iPoints = new Vector3D[size];
        this.iPointsWidth = new float[size];
        this.iPointsAngle = new float[size];
        int iPointNr = 0;
        for (int i3 = 0; i3 < this.numBasePoints; ++i3) {
            for (int j = 0; j < this.numInterpolationSteps; ++j) {
                float u = (float)j / (float)this.numInterpolationSteps;
                this.iPoints[iPointNr] = new Vector3D(xSpline[i3].eval(u), ySpline[i3].eval(u), zSpline[i3].eval(u));
                this.iPointsWidth[iPointNr] = wSpline[i3].eval(u);
                this.iPointsAngle[iPointNr] = aSpline[i3].eval(u);
                ++iPointNr;
            }
        }
        this.roadVertices = new short[this.iPoints.length * 2 * 3];
        this.leftSideVertices = new short[this.iPoints.length * 2 * 3];
        this.rightSideVertices = new short[this.iPoints.length * 2 * 3];
        this.leftWallVertices = new short[this.iPoints.length * 2 * 3];
        this.rightWallVertices = new short[this.iPoints.length * 2 * 3];
        int vCount = 0;
        for (i = 0; i < this.iPoints.length; ++i) {
            Vector3D vTmp = i < this.iPoints.length - 1 ? Vector3D.sub(this.iPoints[i + 1], this.iPoints[i]) : Vector3D.sub(this.iPoints[0], this.iPoints[i]);
            vTmp.normalize();
            Vector3D vUp = new Vector3D(0.0f, 1.0f, 0.0f);
            float angle = (float)((double)this.iPointsAngle[i] * Math.PI / 180.0);
            if (angle != 0.0f) {
                float nx = (float)((double)vUp.getx() * mMath.cos(angle) - (double)vUp.gety() * mMath.sin(angle));
                float ny = (float)((double)vUp.getx() * mMath.sin(angle) + (double)vUp.gety() * mMath.cos(angle));
                float nz = vUp.getz();
                vUp.set(nx, ny, nz);
            }
            Vector3D vC = Vector3D.crossProduct(vTmp, vUp);
            Vector3D vD = new Vector3D(vC);
            vC.scalarMul(this.iPointsWidth[i]);
            vD.scalarMul(this.iPointsWidth[i] + this.roadSideWidth * (float)mScale);
            Vector3D v1 = Vector3D.sub(this.iPoints[i], vC);
            Vector3D v2 = Vector3D.add(this.iPoints[i], vC);
            v3 = Vector3D.sub(this.iPoints[i], vD);
            Vector3D v4 = Vector3D.add(this.iPoints[i], vD);
            this.roadVertices[vCount + 0] = (short)v1.getx();
            this.roadVertices[vCount + 1] = (short)v1.gety();
            this.roadVertices[vCount + 2] = (short)v1.getz();
            this.leftSideVertices[vCount + 0] = (short)v3.getx();
            this.leftSideVertices[vCount + 1] = (short)v3.gety();
            this.leftSideVertices[vCount + 2] = (short)v3.getz();
            this.rightSideVertices[vCount + 0] = (short)v2.getx();
            this.rightSideVertices[vCount + 1] = (short)v2.gety();
            this.rightSideVertices[vCount + 2] = (short)v2.getz();
            this.leftWallVertices[vCount + 0] = (short)v3.getx();
            this.leftWallVertices[vCount + 1] = (short)(v3.gety() + (float)(100 * mScale));
            this.leftWallVertices[vCount + 2] = (short)v3.getz();
            this.rightWallVertices[vCount + 0] = (short)v4.getx();
            this.rightWallVertices[vCount + 1] = (short)(v4.gety() + (float)(100 * mScale));
            this.rightWallVertices[vCount + 2] = (short)v4.getz();
            this.roadVertices[(vCount += 3) + 0] = (short)v2.getx();
            this.roadVertices[vCount + 1] = (short)v2.gety();
            this.roadVertices[vCount + 2] = (short)v2.getz();
            this.leftSideVertices[vCount + 0] = (short)v1.getx();
            this.leftSideVertices[vCount + 1] = (short)v1.gety();
            this.leftSideVertices[vCount + 2] = (short)v1.getz();
            this.rightSideVertices[vCount + 0] = (short)v4.getx();
            this.rightSideVertices[vCount + 1] = (short)v4.gety();
            this.rightSideVertices[vCount + 2] = (short)v4.getz();
            this.leftWallVertices[vCount + 0] = (short)v3.getx();
            this.leftWallVertices[vCount + 1] = (short)v3.gety();
            this.leftWallVertices[vCount + 2] = (short)v3.getz();
            this.rightWallVertices[vCount + 0] = (short)v4.getx();
            this.rightWallVertices[vCount + 1] = (short)v4.gety();
            this.rightWallVertices[vCount + 2] = (short)v4.getz();
            vCount += 3;
        }
        for (i = 0; i < this.mShortcutsArray.size(); ++i) {
            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(i);
            sc.updateFitPoints();
            sc.createMeshes();
        }
        for (int k = 0; k < this.mShortcutsArray.size(); ++k) {
            int index;
            int j;
            Vector3D v12;
            Vector3D v2;
            Vector3D v1;
            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(k);
            int da = sc.startPoints[2] - sc.startPoints[1];
            if (da > 1) {
                int j2;
                if (sc.startSide == 0) {
                    v1 = new Vector3D(this.leftSideVertices[sc.startPoints[1] * 2 * 3 + 0], this.leftSideVertices[sc.startPoints[1] * 2 * 3 + 1], this.leftSideVertices[sc.startPoints[1] * 2 * 3 + 2]);
                    v2 = new Vector3D(this.leftSideVertices[sc.startPoints[2] * 2 * 3 + 0], this.leftSideVertices[sc.startPoints[2] * 2 * 3 + 1], this.leftSideVertices[sc.startPoints[2] * 2 * 3 + 2]);
                    v12 = Vector3D.sub(v2, v1);
                    v12.scalarDiv(da);
                    for (j2 = 1; j2 <= da - 1; ++j2) {
                        int index2 = sc.startPoints[1] + j2;
                        v3 = Vector3D.add(v1, Vector3D.scalarMul(j2, v12));
                        this.leftSideVertices[index2 * 2 * 3 + 0] = (short)v3.getx();
                        this.leftSideVertices[index2 * 2 * 3 + 1] = (short)v3.gety();
                        this.leftSideVertices[index2 * 2 * 3 + 2] = (short)v3.getz();
                    }
                } else {
                    v1 = new Vector3D(this.rightSideVertices[sc.startPoints[1] * 2 * 3 + 0 + 3], this.rightSideVertices[sc.startPoints[1] * 2 * 3 + 1 + 3], this.rightSideVertices[sc.startPoints[1] * 2 * 3 + 2 + 3]);
                    v2 = new Vector3D(this.rightSideVertices[sc.startPoints[2] * 2 * 3 + 0 + 3], this.rightSideVertices[sc.startPoints[2] * 2 * 3 + 1 + 3], this.rightSideVertices[sc.startPoints[2] * 2 * 3 + 2 + 3]);
                    v12 = Vector3D.sub(v2, v1);
                    v12.scalarDiv(da);
                    for (j2 = 1; j2 <= da - 1; ++j2) {
                        int index3 = sc.startPoints[1] + j2;
                        v3 = Vector3D.add(v1, Vector3D.scalarMul(j2, v12));
                        this.rightSideVertices[index3 * 2 * 3 + 0 + 3] = (short)v3.getx();
                        this.rightSideVertices[index3 * 2 * 3 + 1 + 3] = (short)v3.gety();
                        this.rightSideVertices[index3 * 2 * 3 + 2 + 3] = (short)v3.getz();
                    }
                }
            }
            if ((da = sc.endPoints[2] - sc.endPoints[1]) <= 1) continue;
            if (sc.endSide == 0) {
                v1 = new Vector3D(this.leftSideVertices[sc.endPoints[1] * 2 * 3 + 0], this.leftSideVertices[sc.endPoints[1] * 2 * 3 + 1], this.leftSideVertices[sc.endPoints[1] * 2 * 3 + 2]);
                v2 = new Vector3D(this.leftSideVertices[sc.endPoints[2] * 2 * 3 + 0], this.leftSideVertices[sc.endPoints[2] * 2 * 3 + 1], this.leftSideVertices[sc.endPoints[2] * 2 * 3 + 2]);
                v12 = Vector3D.sub(v2, v1);
                v12.scalarDiv(da);
                for (j = 1; j <= da - 1; ++j) {
                    index = sc.endPoints[1] + j;
                    v3 = Vector3D.add(v1, Vector3D.scalarMul(j, v12));
                    this.leftSideVertices[index * 2 * 3 + 0] = (short)v3.getx();
                    this.leftSideVertices[index * 2 * 3 + 1] = (short)v3.gety();
                    this.leftSideVertices[index * 2 * 3 + 2] = (short)v3.getz();
                }
                continue;
            }
            v1 = new Vector3D(this.rightSideVertices[sc.endPoints[1] * 2 * 3 + 0 + 3], this.rightSideVertices[sc.endPoints[1] * 2 * 3 + 1 + 3], this.rightSideVertices[sc.endPoints[1] * 2 * 3 + 2 + 3]);
            v2 = new Vector3D(this.rightSideVertices[sc.endPoints[2] * 2 * 3 + 0 + 3], this.rightSideVertices[sc.endPoints[2] * 2 * 3 + 1 + 3], this.rightSideVertices[sc.endPoints[2] * 2 * 3 + 2 + 3]);
            v12 = Vector3D.sub(v2, v1);
            v12.scalarDiv(da);
            for (j = 1; j <= da - 1; ++j) {
                index = sc.endPoints[1] + j;
                v3 = Vector3D.add(v1, Vector3D.scalarMul(j, v12));
                this.rightSideVertices[index * 2 * 3 + 0 + 3] = (short)v3.getx();
                this.rightSideVertices[index * 2 * 3 + 1 + 3] = (short)v3.gety();
                this.rightSideVertices[index * 2 * 3 + 2 + 3] = (short)v3.getz();
            }
        }
    }

    private void generateTrackMeshes() {
        TrackShortcut sc;
        TriangleStripArray ts;
        VertexArray vaCoordinates;
        VertexArray vaPositions;
        VertexBuffer vb;
        int[] ttIndices;
        int m;
        int i;
        this.meshTrackSegments = new Mesh[this.numBasePoints];
        this.meshLeftSideSegments = new Mesh[this.numBasePoints];
        this.meshRightSideSegments = new Mesh[this.numBasePoints];
        this.meshLeftWallSegments = new Mesh[this.numBasePoints];
        this.meshRightWallSegments = new Mesh[this.numBasePoints];
        short[] segVertex = new short[this.numInterpolationSteps * 4 * 3];
        short[] segCoords = new short[this.numInterpolationSteps * 4 * 2];
        int[] segIndices = new int[this.numInterpolationSteps * 4];
        int vIndex = 0;
        int cIndex = 0;
        int iIndex = 0;
        int vertexColor = -6250336;
        for (i = 0; i < this.numBasePoints; ++i) {
            int j;
            int j2;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                for (j2 = 0; j2 < 12; ++j2) {
                    if (vIndex + j2 > this.roadVertices.length - 1) {
                        vIndex = -j2;
                    }
                    segVertex[k * 12 + j2] = this.roadVertices[vIndex + j2];
                }
                vIndex += 6;
            }
            block16: for (j = 0; j < this.numInterpolationSteps; ++j) {
                int inr = i * this.numInterpolationSteps + j;
                boolean lmode = false;
                boolean rmode = false;
                int ftile = 0;
                for (m = 0; m < this.mShortcutsArray.size(); ++m) {
                    TrackShortcut sc2 = (TrackShortcut)this.mShortcutsArray.elementAt(m);
                    if (inr >= sc2.startPoints[1] && inr < sc2.startPoints[2] && sc2.startSide == 0 || inr >= sc2.endPoints[1] && inr < sc2.endPoints[2] && sc2.startSide == 0) {
                        lmode = true;
                        if (inr == sc2.startPoints[1] || inr == sc2.endPoints[1]) {
                            ftile = 1;
                        } else if (inr == sc2.startPoints[2] - 1 || inr == sc2.endPoints[2] - 1) {
                            ftile = 2;
                        }
                    }
                    if ((inr < sc2.startPoints[1] || inr >= sc2.startPoints[2] || sc2.startSide != 1) && (inr < sc2.endPoints[1] || inr >= sc2.endPoints[2] || sc2.startSide != 1)) continue;
                    rmode = true;
                    if (inr == sc2.startPoints[1] || inr == sc2.endPoints[1]) {
                        ftile = 1;
                        continue;
                    }
                    if (inr != sc2.startPoints[2] - 1 && inr != sc2.endPoints[2] - 1) continue;
                    ftile = 2;
                }
                int mode = 0;
                if (lmode) {
                    ++mode;
                }
                if (rmode) {
                    mode += 2;
                }
                mode = 0;
                switch (mode) {
                    case 0: {
                        for (int m2 = 0; m2 < 8; ++m2) {
                            segCoords[j * 8 + m2] = (short)TXT_TILES_COORDINATES[this.mainRoadTextureNr[inr]][m2];
                        }
                        continue block16;
                    }
                    case 1: {
                        if (ftile == 1) {
                            segCoords[j * 8 + 0] = (short)TXT_TILES_COORDINATES[14][2];
                            segCoords[j * 8 + 1] = (short)TXT_TILES_COORDINATES[14][3];
                            segCoords[j * 8 + 2] = (short)TXT_TILES_COORDINATES[14][0];
                            segCoords[j * 8 + 3] = (short)TXT_TILES_COORDINATES[14][1];
                            segCoords[j * 8 + 4] = (short)TXT_TILES_COORDINATES[14][6];
                            segCoords[j * 8 + 5] = (short)TXT_TILES_COORDINATES[14][7];
                            segCoords[j * 8 + 6] = (short)TXT_TILES_COORDINATES[14][4];
                            segCoords[j * 8 + 7] = (short)TXT_TILES_COORDINATES[14][5];
                            continue block16;
                        }
                        if (ftile == 2) {
                            segCoords[j * 8 + 0] = (short)TXT_TILES_COORDINATES[15][2];
                            segCoords[j * 8 + 1] = (short)TXT_TILES_COORDINATES[15][3];
                            segCoords[j * 8 + 2] = (short)TXT_TILES_COORDINATES[15][0];
                            segCoords[j * 8 + 3] = (short)TXT_TILES_COORDINATES[15][1];
                            segCoords[j * 8 + 4] = (short)TXT_TILES_COORDINATES[15][6];
                            segCoords[j * 8 + 5] = (short)TXT_TILES_COORDINATES[15][7];
                            segCoords[j * 8 + 6] = (short)TXT_TILES_COORDINATES[15][4];
                            segCoords[j * 8 + 7] = (short)TXT_TILES_COORDINATES[15][5];
                            continue block16;
                        }
                        if (ftile != 0) continue block16;
                        segCoords[j * 8 + 0] = (short)TXT_TILES_COORDINATES[13][2];
                        segCoords[j * 8 + 1] = (short)TXT_TILES_COORDINATES[13][3];
                        segCoords[j * 8 + 2] = (short)TXT_TILES_COORDINATES[13][0];
                        segCoords[j * 8 + 3] = (short)TXT_TILES_COORDINATES[13][1];
                        segCoords[j * 8 + 4] = (short)TXT_TILES_COORDINATES[13][6];
                        segCoords[j * 8 + 5] = (short)TXT_TILES_COORDINATES[13][7];
                        segCoords[j * 8 + 6] = (short)TXT_TILES_COORDINATES[13][4];
                        segCoords[j * 8 + 7] = (short)TXT_TILES_COORDINATES[13][5];
                        continue block16;
                    }
                    case 2: {
                        if (ftile == 1) {
                            segCoords[j * 8 + 0] = (short)TXT_TILES_COORDINATES[14][0];
                            segCoords[j * 8 + 1] = (short)TXT_TILES_COORDINATES[14][1];
                            segCoords[j * 8 + 2] = (short)TXT_TILES_COORDINATES[14][2];
                            segCoords[j * 8 + 3] = (short)TXT_TILES_COORDINATES[14][3];
                            segCoords[j * 8 + 4] = (short)TXT_TILES_COORDINATES[14][4];
                            segCoords[j * 8 + 5] = (short)TXT_TILES_COORDINATES[14][5];
                            segCoords[j * 8 + 6] = (short)TXT_TILES_COORDINATES[14][6];
                            segCoords[j * 8 + 7] = (short)TXT_TILES_COORDINATES[14][7];
                            continue block16;
                        }
                        if (ftile == 2) {
                            segCoords[j * 8 + 0] = (short)TXT_TILES_COORDINATES[15][0];
                            segCoords[j * 8 + 1] = (short)TXT_TILES_COORDINATES[15][1];
                            segCoords[j * 8 + 2] = (short)TXT_TILES_COORDINATES[15][2];
                            segCoords[j * 8 + 3] = (short)TXT_TILES_COORDINATES[15][3];
                            segCoords[j * 8 + 4] = (short)TXT_TILES_COORDINATES[15][4];
                            segCoords[j * 8 + 5] = (short)TXT_TILES_COORDINATES[15][5];
                            segCoords[j * 8 + 6] = (short)TXT_TILES_COORDINATES[15][6];
                            segCoords[j * 8 + 7] = (short)TXT_TILES_COORDINATES[15][7];
                            continue block16;
                        }
                        if (ftile != 0) continue block16;
                        segCoords[j * 8 + 0] = (short)TXT_TILES_COORDINATES[13][0];
                        segCoords[j * 8 + 1] = (short)TXT_TILES_COORDINATES[13][1];
                        segCoords[j * 8 + 2] = (short)TXT_TILES_COORDINATES[13][2];
                        segCoords[j * 8 + 3] = (short)TXT_TILES_COORDINATES[13][3];
                        segCoords[j * 8 + 4] = (short)TXT_TILES_COORDINATES[13][4];
                        segCoords[j * 8 + 5] = (short)TXT_TILES_COORDINATES[13][5];
                        segCoords[j * 8 + 6] = (short)TXT_TILES_COORDINATES[13][6];
                        segCoords[j * 8 + 7] = (short)TXT_TILES_COORDINATES[13][7];
                    }
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (j2 = 0; j2 < ttIndices.length; ++j2) {
                ttIndices[j2] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshTrackSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.roadAp);
        }
        iIndex = 0;
        cIndex = 0;
        vIndex = 0;
        for (i = 0; i < this.numBasePoints; ++i) {
            int j;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                for (int j3 = 0; j3 < 12; ++j3) {
                    if (vIndex + j3 > this.leftSideVertices.length - 1) {
                        vIndex = -j3;
                    }
                    segVertex[k * 12 + j3] = this.leftSideVertices[vIndex + j3];
                }
                vIndex += 6;
            }
            block24: for (j = 0; j < this.numInterpolationSteps; ++j) {
                int inr = i * this.numInterpolationSteps + j;
                int txtMode = 0;
                float dtx = 0.0f;
                int dtnr = 0;
                for (m = 0; m < this.mShortcutsArray.size(); ++m) {
                    TrackShortcut sc3 = (TrackShortcut)this.mShortcutsArray.elementAt(m);
                    if (inr >= sc3.startPoints[1] && inr < sc3.startPoints[2] && sc3.startSide == 0) {
                        dtx = 64.0f / (float)(sc3.startPoints[2] - sc3.startPoints[1]);
                        dtnr = inr - sc3.startPoints[1];
                        txtMode = 1;
                        break;
                    }
                    if (inr < sc3.endPoints[1] || inr >= sc3.endPoints[2] || sc3.startSide != 0) continue;
                    dtx = 64.0f / (float)(sc3.endPoints[2] - sc3.endPoints[1]);
                    dtnr = inr - sc3.endPoints[1];
                    txtMode = 1;
                    break;
                }
                txtMode = 0;
                switch (txtMode) {
                    case 0: {
                        for (m = 0; m < 8; ++m) {
                            segCoords[j * 8 + m] = (short)TXT_TILES_COORDINATES[this.leftSideTextureNr[inr]][m];
                        }
                        continue block24;
                    }
                    case 1: {
                        segCoords[j * 8 + 0] = (short)((float)TXT_TILES_COORDINATES[0][4] + (float)dtnr * dtx);
                        segCoords[j * 8 + 1] = (short)TXT_TILES_COORDINATES[0][5];
                        segCoords[j * 8 + 2] = (short)((float)TXT_TILES_COORDINATES[0][0] + (float)dtnr * dtx);
                        segCoords[j * 8 + 3] = (short)TXT_TILES_COORDINATES[0][1];
                        segCoords[j * 8 + 4] = (short)((float)TXT_TILES_COORDINATES[0][4] + (float)(dtnr + 1) * dtx);
                        segCoords[j * 8 + 5] = (short)TXT_TILES_COORDINATES[0][7];
                        segCoords[j * 8 + 6] = (short)((float)TXT_TILES_COORDINATES[0][0] + (float)(dtnr + 1) * dtx);
                        segCoords[j * 8 + 7] = (short)TXT_TILES_COORDINATES[0][3];
                    }
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (int j4 = 0; j4 < ttIndices.length; ++j4) {
                ttIndices[j4] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshLeftSideSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.roadAp);
        }
        iIndex = 0;
        cIndex = 0;
        vIndex = 0;
        for (i = 0; i < this.numBasePoints; ++i) {
            int j;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                for (int j5 = 0; j5 < 12; ++j5) {
                    if (vIndex + j5 > this.rightSideVertices.length - 1) {
                        vIndex = -j5;
                    }
                    segVertex[k * 12 + j5] = this.rightSideVertices[vIndex + j5];
                }
                vIndex += 6;
            }
            block32: for (j = 0; j < this.numInterpolationSteps; ++j) {
                int inr = i * this.numInterpolationSteps + j;
                int txtMode = 0;
                float dtx = 0.0f;
                int dtnr = 0;
                for (m = 0; m < this.mShortcutsArray.size(); ++m) {
                    TrackShortcut sc4 = (TrackShortcut)this.mShortcutsArray.elementAt(m);
                    if (inr >= sc4.startPoints[1] && inr < sc4.startPoints[2] && sc4.startSide == 1) {
                        dtx = 64.0f / (float)(sc4.startPoints[2] - sc4.startPoints[1]);
                        dtnr = inr - sc4.startPoints[1];
                        txtMode = 1;
                        break;
                    }
                    if (inr < sc4.endPoints[1] || inr >= sc4.endPoints[2] || sc4.startSide != 1) continue;
                    dtx = 64.0f / (float)(sc4.endPoints[2] - sc4.endPoints[1]);
                    dtnr = inr - sc4.endPoints[1];
                    txtMode = 1;
                    break;
                }
                txtMode = 0;
                switch (txtMode) {
                    case 0: {
                        for (m = 0; m < 8; ++m) {
                            segCoords[j * 8 + m] = (short)TXT_TILES_COORDINATES[this.rightSideTextureNr[inr]][m];
                        }
                        continue block32;
                    }
                    case 1: {
                        segCoords[j * 8 + 0] = (short)((float)TXT_TILES_COORDINATES[0][4] + (float)dtnr * dtx);
                        segCoords[j * 8 + 1] = (short)TXT_TILES_COORDINATES[0][5];
                        segCoords[j * 8 + 2] = (short)((float)TXT_TILES_COORDINATES[0][0] + (float)dtnr * dtx);
                        segCoords[j * 8 + 3] = (short)TXT_TILES_COORDINATES[0][1];
                        segCoords[j * 8 + 4] = (short)((float)TXT_TILES_COORDINATES[0][4] + (float)(dtnr + 1) * dtx);
                        segCoords[j * 8 + 5] = (short)TXT_TILES_COORDINATES[0][7];
                        segCoords[j * 8 + 6] = (short)((float)TXT_TILES_COORDINATES[0][0] + (float)(dtnr + 1) * dtx);
                        segCoords[j * 8 + 7] = (short)TXT_TILES_COORDINATES[0][3];
                    }
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (int j6 = 0; j6 < ttIndices.length; ++j6) {
                ttIndices[j6] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshRightSideSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.roadAp);
        }
        iIndex = 0;
        cIndex = 0;
        vIndex = 0;
        for (i = 0; i < this.numBasePoints; ++i) {
            int j;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                boolean skipThisQuad = false;
                for (int j7 = 0; j7 < 12; ++j7) {
                    if (j7 == 0) {
                        for (int l = 0; l < this.mShortcutsArray.size(); ++l) {
                            sc = (TrackShortcut)this.mShortcutsArray.elementAt(l);
                            if ((vIndex < sc.startPoints[0] * 3 * 2 || vIndex >= sc.startPoints[3] * 3 * 2 || sc.startSide != 0) && (vIndex < sc.endPoints[0] * 3 * 2 || vIndex >= sc.endPoints[3] * 3 * 2 || sc.endSide != 0)) continue;
                            skipThisQuad = true;
                            break;
                        }
                    }
                    if (vIndex + j7 > this.leftWallVertices.length - 1) {
                        vIndex = -j7;
                    }
                    segVertex[k * 12 + j7] = !skipThisQuad ? this.leftWallVertices[vIndex + j7] : (short)0;
                }
                vIndex += 6;
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                for (int m3 = 0; m3 < 8; ++m3) {
                    segCoords[j * 8 + m3] = (short)TXT_TILES_COORDINATES[7][m3];
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (int j8 = 0; j8 < ttIndices.length; ++j8) {
                ttIndices[j8] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshLeftWallSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.wallAp);
        }
        iIndex = 0;
        cIndex = 0;
        vIndex = 0;
        for (i = 0; i < this.numBasePoints; ++i) {
            int j;
            for (int k = 0; k < this.numInterpolationSteps; ++k) {
                boolean skipThisQuad = false;
                for (int j9 = 0; j9 < 12; ++j9) {
                    if (j9 == 0) {
                        for (int l = 0; l < this.mShortcutsArray.size(); ++l) {
                            sc = (TrackShortcut)this.mShortcutsArray.elementAt(l);
                            if ((vIndex < sc.startPoints[0] * 3 * 2 || vIndex >= sc.startPoints[3] * 3 * 2 || sc.startSide != 1) && (vIndex < sc.endPoints[0] * 3 * 2 || vIndex >= sc.endPoints[3] * 3 * 2 || sc.endSide != 1)) continue;
                            skipThisQuad = true;
                            break;
                        }
                    }
                    if (vIndex + j9 > this.rightWallVertices.length - 1) {
                        vIndex = -j9;
                    }
                    segVertex[k * 12 + j9] = !skipThisQuad ? this.rightWallVertices[vIndex + j9] : (short)0;
                }
                vIndex += 6;
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                for (int m4 = 0; m4 < 8; ++m4) {
                    segCoords[j * 8 + m4] = (short)TXT_TILES_COORDINATES[7][m4];
                }
            }
            for (j = 0; j < segIndices.length; ++j) {
                segIndices[j] = j;
            }
            ttIndices = new int[this.numInterpolationSteps];
            for (int j10 = 0; j10 < ttIndices.length; ++j10) {
                ttIndices[j10] = 4;
            }
            vb = new VertexBuffer();
            vaPositions = new VertexArray(segVertex.length / 3, 3, 2);
            vaPositions.set(0, segVertex.length / 3, segVertex);
            vb.setPositions(vaPositions, 1.0f, null);
            vaCoordinates = new VertexArray(segCoords.length / 2, 2, 2);
            vaCoordinates.set(0, segCoords.length / 2, segCoords);
            vb.setTexCoords(0, vaCoordinates, 0.003921569f, null);
            ts = new TriangleStripArray(segIndices, ttIndices);
            this.meshRightWallSegments[i] = new Mesh(vb, (IndexBuffer)ts, this.wallAp);
        }
    }

    public void renderMainRoad(Graphics3D g3d, int[][] nearestPoint) {
        int currSegNr = nearestPoint[0][0] / this.numInterpolationSteps;
        int prevSegNr = currSegNr - 1;
        int prevPrevSegNr = prevSegNr - 1;
        int nextSegNr = currSegNr + 1;
        int nextNextSegNr = nextSegNr + 1;
        if (prevSegNr < 0) {
            prevSegNr = this.numBasePoints + prevSegNr;
        }
        if (nextSegNr > this.numBasePoints - 1) {
            nextSegNr -= this.numBasePoints;
        }
        if (prevPrevSegNr < 0) {
            prevPrevSegNr = this.numBasePoints + prevPrevSegNr;
        }
        if (nextNextSegNr > this.numBasePoints - 1) {
            nextNextSegNr -= this.numBasePoints;
        }
        if (nearestPoint[0][1] == 0) {
            g3d.render((Node)this.meshTrackSegments[prevSegNr], null);
            g3d.render((Node)this.meshTrackSegments[currSegNr], null);
            g3d.render((Node)this.meshTrackSegments[nextSegNr], null);
            g3d.render((Node)this.meshTrackSegments[nextNextSegNr], null);
            g3d.render((Node)this.meshLeftSideSegments[prevSegNr], null);
            g3d.render((Node)this.meshLeftSideSegments[currSegNr], null);
            g3d.render((Node)this.meshLeftSideSegments[nextSegNr], null);
            g3d.render((Node)this.meshLeftSideSegments[nextNextSegNr], null);
            g3d.render((Node)this.meshRightSideSegments[prevSegNr], null);
            g3d.render((Node)this.meshRightSideSegments[currSegNr], null);
            g3d.render((Node)this.meshRightSideSegments[nextSegNr], null);
            g3d.render((Node)this.meshRightSideSegments[nextNextSegNr], null);
        } else {
            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(nearestPoint[0][1] - 1);
            currSegNr = sc.startPoints[1] / this.numInterpolationSteps;
            g3d.render((Node)this.meshTrackSegments[currSegNr], null);
            g3d.render((Node)this.meshLeftSideSegments[currSegNr], null);
            g3d.render((Node)this.meshRightSideSegments[currSegNr], null);
            g3d.render((Node)this.meshTrackSegments[currSegNr - 1], null);
            g3d.render((Node)this.meshLeftSideSegments[currSegNr - 1], null);
            g3d.render((Node)this.meshRightSideSegments[currSegNr - 1], null);
            g3d.render((Node)this.meshTrackSegments[currSegNr + 1], null);
            g3d.render((Node)this.meshLeftSideSegments[currSegNr + 1], null);
            g3d.render((Node)this.meshRightSideSegments[currSegNr + 1], null);
            currSegNr = sc.endPoints[1] / this.numInterpolationSteps;
            g3d.render((Node)this.meshTrackSegments[currSegNr], null);
            g3d.render((Node)this.meshLeftSideSegments[currSegNr], null);
            g3d.render((Node)this.meshRightSideSegments[currSegNr], null);
            g3d.render((Node)this.meshTrackSegments[currSegNr + 1], null);
            g3d.render((Node)this.meshLeftSideSegments[currSegNr + 1], null);
            g3d.render((Node)this.meshRightSideSegments[currSegNr + 1], null);
            g3d.render((Node)this.meshTrackSegments[currSegNr - 1], null);
            g3d.render((Node)this.meshLeftSideSegments[currSegNr - 1], null);
            g3d.render((Node)this.meshRightSideSegments[currSegNr - 1], null);
        }
    }

    public void renderShortcut(Graphics3D g3d, int[][] nearestPoint) {
        if (this.mShortcutsArray.size() > 0) {
            for (int j = 0; j < this.mShortcutsArray.size(); ++j) {
                TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(j);
                if (nearestPoint[0][1] != 0) {
                    if (nearestPoint[0][1] - 1 != j) continue;
                    for (int i = 0; i < sc.meshTrackSegments.length; ++i) {
                        g3d.render((Node)sc.meshTrackSegments[i], null);
                        g3d.render((Node)sc.meshLeftSideSegments[i], null);
                        g3d.render((Node)sc.meshRightSideSegments[i], null);
                        g3d.render((Node)sc.meshLeftWallSegments[i], null);
                        g3d.render((Node)sc.meshRightWallSegments[i], null);
                    }
                    continue;
                }
                int d1 = Math.abs(nearestPoint[0][0] - sc.startPoints[0]);
                int d2 = Math.abs(nearestPoint[0][0] - sc.startPoints[3]);
                int tolerance = 10;
                if (d1 < tolerance || d2 < tolerance) {
                    g3d.render((Node)sc.meshTrackSegments[0], null);
                    g3d.render((Node)sc.meshLeftSideSegments[0], null);
                    g3d.render((Node)sc.meshRightSideSegments[0], null);
                    g3d.render((Node)sc.meshLeftWallSegments[0], null);
                    g3d.render((Node)sc.meshRightWallSegments[0], null);
                    continue;
                }
                int d3 = Math.abs(nearestPoint[0][0] - sc.endPoints[0]);
                int d4 = Math.abs(nearestPoint[0][0] - sc.endPoints[3]);
                if (d3 >= tolerance && d4 >= tolerance) continue;
                g3d.render((Node)sc.meshTrackSegments[sc.meshTrackSegments.length - 1], null);
                g3d.render((Node)sc.meshLeftSideSegments[sc.meshTrackSegments.length - 1], null);
                g3d.render((Node)sc.meshRightSideSegments[sc.meshTrackSegments.length - 1], null);
                g3d.render((Node)sc.meshLeftWallSegments[sc.meshTrackSegments.length - 1], null);
                g3d.render((Node)sc.meshRightWallSegments[sc.meshTrackSegments.length - 1], null);
            }
        }
    }

    public void renderRoadWalls(Graphics3D g3d, int[][] nearestPoint) {
        int currSegNr = nearestPoint[0][0] / this.numInterpolationSteps;
        int prevSegNr = currSegNr - 1;
        int prevPrevSegNr = prevSegNr - 1;
        int nextSegNr = currSegNr + 1;
        int nextNextSegNr = nextSegNr + 1;
        if (prevSegNr < 0) {
            prevSegNr = this.numBasePoints + prevSegNr;
        }
        if (nextSegNr > this.numBasePoints - 1) {
            nextSegNr -= this.numBasePoints;
        }
        if (prevPrevSegNr < 0) {
            prevPrevSegNr = this.numBasePoints + prevPrevSegNr;
        }
        if (nextNextSegNr > this.numBasePoints - 1) {
            nextNextSegNr -= this.numBasePoints;
        }
        if (nearestPoint[0][1] == 0) {
            g3d.render((Node)this.meshLeftWallSegments[prevSegNr], null);
            g3d.render((Node)this.meshLeftWallSegments[currSegNr], null);
            g3d.render((Node)this.meshLeftWallSegments[nextSegNr], null);
            g3d.render((Node)this.meshLeftWallSegments[nextNextSegNr], null);
            g3d.render((Node)this.meshRightWallSegments[prevSegNr], null);
            g3d.render((Node)this.meshRightWallSegments[currSegNr], null);
            g3d.render((Node)this.meshRightWallSegments[nextSegNr], null);
            g3d.render((Node)this.meshRightWallSegments[nextNextSegNr], null);
        } else {
            TrackShortcut sc = (TrackShortcut)this.mShortcutsArray.elementAt(nearestPoint[0][1] - 1);
            currSegNr = sc.startPoints[1] / this.numInterpolationSteps;
            g3d.render((Node)this.meshLeftWallSegments[currSegNr], null);
            g3d.render((Node)this.meshRightWallSegments[currSegNr], null);
            g3d.render((Node)this.meshLeftWallSegments[currSegNr - 1], null);
            g3d.render((Node)this.meshRightWallSegments[currSegNr - 1], null);
            currSegNr = sc.endPoints[1] / this.numInterpolationSteps;
            g3d.render((Node)this.meshLeftWallSegments[currSegNr], null);
            g3d.render((Node)this.meshRightWallSegments[currSegNr], null);
            g3d.render((Node)this.meshLeftWallSegments[currSegNr + 1], null);
            g3d.render((Node)this.meshRightWallSegments[currSegNr + 1], null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

