/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.CompositingMode;
import javax.microedition.m3g.Graphics3D;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.PolygonMode;
import javax.microedition.m3g.Sprite3D;
import javax.microedition.m3g.Texture2D;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.TriangleStripArray;
import javax.microedition.m3g.VertexArray;
import javax.microedition.m3g.VertexBuffer;

public class SimpleObject {
    private boolean billboard;
    private boolean model;
    private Sprite3D objectSprite;
    protected VertexBuffer objectVertices;
    protected IndexBuffer objectIndices;
    protected Appearance objectAppearance;
    private static Vector vertices = new Vector();
    private static Vector indices = new Vector();
    private static Vector appearances = new Vector();
    private static Vector sprites = new Vector();
    private static Vector quadPaths = new Vector();
    private static Vector billboardPaths = new Vector();
    protected Transform objectTrans;
    public Vector3D vPosition = new Vector3D();
    protected Vector3D vDirection;
    protected Vector3D vRotation;
    protected Vector3D vPlaneRotation;
    protected float width;
    protected float height;
    protected float length;
    public int animFrame;
    private int widthInt;
    private int heightInt;
    public int animationFrame;
    private String name;
    private static Appearance appNoDepth = new Appearance();
    private static Appearance appDepth = new Appearance();
    private static boolean intiated = false;
    public boolean reverseAnim = false;

    private static void init() {
        if (!intiated) {
            CompositingMode cm1 = new CompositingMode();
            cm1.setDepthTestEnable(true);
            cm1.setDepthWriteEnable(true);
            cm1.setAlphaWriteEnable(true);
            cm1.setAlphaThreshold(0.5f);
            cm1.setBlending(64);
            appDepth.setCompositingMode(cm1);
            CompositingMode cm2 = new CompositingMode();
            cm2.setDepthTestEnable(false);
            cm2.setDepthWriteEnable(true);
            cm2.setAlphaWriteEnable(true);
            cm2.setAlphaThreshold(0.5f);
            cm2.setBlending(64);
            appNoDepth.setCompositingMode(cm2);
            intiated = true;
        }
    }

    SimpleObject() {
        this.objectTrans = new Transform();
        SimpleObject.init();
    }

    public void init(String tex, boolean billboard, boolean depth) {
        this.init(null, tex, billboard, depth, 1.0f);
    }

    public void init(String tex, float scaleX, float scaleY, boolean billboard, boolean depth) {
        this.init(null, tex, billboard, depth, 1.0f);
        this.reScale(scaleX * (float)Track.mScale, scaleY * (float)Track.mScale);
    }

    public void init(String tex, Vector3D loc, Vector3D dir, boolean billboard, boolean depth) {
        this.init(null, tex, billboard, depth, 1.0f);
        this.setPosition(loc);
        this.setDirection(dir);
    }

    public void init(String tex, Vector3D loc, Vector3D dir, float scaleX, float scaleY, boolean billboard, boolean depth) {
        this.init(null, tex, billboard, depth, 1.0f);
        this.setPosition(loc);
        this.setDirection(dir);
        this.reScale(scaleX * (float)Track.mScale, scaleY * (float)Track.mScale);
    }

    public void init(String filepath, String tex, boolean billboard, boolean depth) {
        this.init(filepath, tex, billboard, depth, 1.0f);
    }

    public void init(String filepath, String tex, float scale, boolean billboard, boolean depth) {
        this.init(filepath, tex, billboard, depth, scale);
    }

    public void init(String filepath, String tex, Vector3D loc, Vector3D dir, boolean billboard, boolean depth) {
        this.init(filepath, tex, billboard, depth, 1.0f);
        this.setPosition(loc);
        this.setDirection(dir);
    }

    public void init(String filepath, String tex, Vector3D loc, Vector3D dir, float scale, boolean billboard, boolean depth) {
        this.init(filepath, tex, billboard, depth, scale);
        this.setPosition(loc);
        this.setDirection(dir);
    }

    public void init(String filepath, String texpath, boolean billboard, boolean depth, float scale) {
        this.name = filepath != null ? filepath : texpath;
        if (filepath != null) {
            this.loadModel(filepath, texpath, scale);
        } else {
            this.loadSprite(texpath, billboard, depth);
        }
    }

    private void loadSprite(String filepath, boolean billboard, boolean depth) {
        this.billboard = billboard;
        this.model = false;
        Image2D img = null;
        try {
            img = SpriteLoader.LoadSprite(filepath);
            this.width = img.getWidth();
            this.widthInt = img.getWidth();
            this.height = img.getHeight();
            this.heightInt = img.getHeight();
            if (this.width < this.height) {
                this.width /= this.height;
                this.height = 1.0f;
            } else if (this.width > this.height) {
                this.height /= this.width;
                this.width = 1.0f;
            } else {
                this.width = 1.0f;
                this.height = 1.0f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (billboard) {
            if (!billboardPaths.contains(filepath)) {
                billboardPaths.addElement(filepath);
                if (depth) {
                    sprites.addElement(new Sprite3D(true, img, appDepth));
                } else {
                    sprites.addElement(new Sprite3D(true, img, appNoDepth));
                }
            }
            this.objectSprite = (Sprite3D)sprites.elementAt(billboardPaths.indexOf(filepath));
        } else {
            this.vDirection = new Vector3D();
            this.vRotation = new Vector3D();
            this.vPlaneRotation = new Vector3D();
            if (!quadPaths.contains(filepath)) {
                quadPaths.addElement(filepath);
                short[] v = new short[12];
                short[] t = new short[8];
                int[] ind = new int[]{4};
                v[3] = (short)(-this.width * 100.0f);
                v[4] = (short)(-this.height * 100.0f);
                v[5] = 0;
                v[0] = (short)(this.width * 100.0f);
                v[1] = (short)(-this.height * 100.0f);
                v[2] = 0;
                v[6] = (short)(this.width * 100.0f);
                v[7] = (short)(this.height * 100.0f);
                v[8] = 0;
                v[9] = (short)(-this.width * 100.0f);
                v[10] = (short)(this.height * 100.0f);
                v[11] = 0;
                t[2] = 256;
                t[3] = 256;
                t[0] = 0;
                t[1] = 256;
                t[4] = 0;
                t[5] = 0;
                t[6] = 256;
                t[7] = 0;
                VertexArray va = new VertexArray(v.length / 3, 3, 2);
                va.set(0, v.length / 3, v);
                float[] pbias = new float[]{0.003921569f, 0.003921569f, 0.003921569f};
                VertexBuffer vert = new VertexBuffer();
                vert.setPositions(va, 0.005f, pbias);
                VertexArray texArray = new VertexArray(t.length / 2, 2, 2);
                texArray.set(0, t.length / 2, t);
                vert.setTexCoords(0, texArray, 0.003921569f, null);
                vertices.addElement(vert);
                indices.addElement(new TriangleStripArray(0, ind));
                Texture2D texture = new Texture2D(img);
                texture.setBlending(228);
                Appearance app = new Appearance();
                app.setTexture(0, texture);
                PolygonMode pm = new PolygonMode();
                pm.setPerspectiveCorrectionEnable(true);
                pm.setCulling(162);
                pm.setLocalCameraLightingEnable(false);
                pm.setTwoSidedLightingEnable(false);
                pm.setShading(164);
                CompositingMode cm = new CompositingMode();
                cm.setDepthTestEnable(depth);
                cm.setDepthWriteEnable(true);
                cm.setAlphaWriteEnable(true);
                cm.setAlphaThreshold(0.5f);
                cm.setBlending(64);
                app.setPolygonMode(pm);
                app.setCompositingMode(cm);
                appearances.addElement(app);
            }
            this.objectAppearance = (Appearance)appearances.elementAt(quadPaths.indexOf(filepath));
            this.objectVertices = (VertexBuffer)vertices.elementAt(quadPaths.indexOf(filepath));
            this.objectIndices = (IndexBuffer)indices.elementAt(quadPaths.indexOf(filepath));
        }
    }

    private void loadModel(String filepath, String texpath, float scale) {
        this.model = true;
        boolean loaded = false;
        Object[] buffers = new Object[3];
        float[] sizes = new float[3];
        loaded = MeshLoader.loadVam(filepath, texpath, buffers, sizes, scale);
        if (loaded) {
            this.vDirection = new Vector3D();
            this.vRotation = new Vector3D();
            this.vPlaneRotation = new Vector3D();
            this.billboard = false;
            this.objectVertices = (VertexBuffer)buffers[0];
            this.objectIndices = (IndexBuffer)buffers[1];
            this.objectAppearance = (Appearance)buffers[2];
            this.width = sizes[0];
            this.height = sizes[1];
            this.length = sizes[2];
        } else {
            System.out.println("There was an error in simple object.");
        }
    }

    public boolean isBillboard() {
        return this.billboard;
    }

    public boolean isModel() {
        return this.model;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getLength() {
        return this.length;
    }

    public float getCollisionQuaterDist() {
        return this.width / 2.0f * (this.width / 2.0f);
    }

    public float getTreeCollisionQuaterDist() {
        return this.width / 5.0f * (this.width / 5.0f);
    }

    public void setSize(float sX, float sY) {
        this.width = sX;
        this.height = sY;
    }

    public void reScale(float sX, float sY) {
        if (sX > 0.0f && sY > 0.0f) {
            this.width *= sX;
            this.height *= sY;
        }
    }

    public void setGroundLevel(float h) {
        this.vPosition.sety(this.height / 2.0f + h);
    }

    public void setPosition(Vector3D loc) {
        this.vPosition.set(loc);
    }

    public void setDirection(Vector3D dir) {
        if (!this.billboard) {
            this.vDirection.set(dir);
            this.vDirection.normalize();
            this.vRotation.setx((float)mMath.toDegrees(mMath.acos(this.vDirection.getx())));
            this.vRotation.sety((float)mMath.toDegrees(mMath.acos(this.vDirection.gety())));
            this.vRotation.setz((float)mMath.toDegrees(mMath.acos(this.vDirection.getz())));
        }
    }

    public void setRotation(Vector3D rot) {
        if (!this.billboard) {
            this.vRotation.set(rot);
            this.vDirection.setx((float)mMath.cos(mMath.toRadians(this.vRotation.getx())));
            this.vDirection.sety((float)mMath.cos(mMath.toRadians(this.vRotation.gety())));
            this.vDirection.setz((float)mMath.cos(mMath.toRadians(this.vRotation.getz())));
        }
    }

    public void setPlaneRotation(Vector3D rot) {
        if (!this.billboard) {
            this.vPlaneRotation.set(rot);
        }
    }

    public Vector3D getPlaneRotation() {
        return this.vPlaneRotation;
    }

    public Vector3D getPosition() {
        return new Vector3D(this.vPosition);
    }

    public Vector3D getDirection() {
        return new Vector3D(this.vDirection);
    }

    public void update() {
        try {
            this.objectTrans.setIdentity();
            this.objectTrans.postTranslate(this.vPosition.getx(), this.vPosition.gety() + this.height / 2.0f, this.vPosition.getz());
            if (!this.billboard) {
                this.objectTrans.postRotate(this.vPlaneRotation.getx(), 1.0f, 0.0f, 0.0f);
                this.objectTrans.postRotate(this.vPlaneRotation.getz(), 0.0f, 0.0f, 1.0f);
                this.objectTrans.postRotate(this.vPlaneRotation.gety(), 0.0f, 1.0f, 0.0f);
                this.objectTrans.postRotate(this.vRotation.getx(), 1.0f, 0.0f, 0.0f);
                this.objectTrans.postRotate(this.vRotation.gety(), 0.0f, 1.0f, 0.0f);
                this.objectTrans.postRotate(this.vRotation.getz(), 0.0f, 0.0f, 1.0f);
            }
            if (!this.model) {
                this.objectTrans.postScale(this.width, this.height, 1.0f);
            }
        }
        catch (Exception e) {
            System.out.println("All's hell broken loose!");
            System.out.println("The evil one: " + this.name);
            System.out.println("height: " + this.height);
            System.out.println("width: " + this.width);
            System.out.println("position: " + this.vPosition);
            System.out.println("plane: " + this.vPlaneRotation);
            System.out.println("rotation: " + this.vRotation);
            e.printStackTrace();
        }
    }

    public void render(Graphics3D g3d) {
        if (this.billboard) {
            if (this.animationFrame == 8) {
                this.objectSprite.setCrop(this.widthInt / 9 * this.animFrame, 0, this.widthInt / 9, this.heightInt);
            } else if (this.animationFrame == 4) {
                this.objectSprite.setCrop(this.widthInt / 5 * this.animFrame, 0, this.widthInt / 5, this.heightInt);
            } else if (this.animationFrame == 3) {
                this.objectSprite.setCrop(this.widthInt / 4 * this.animFrame, 0, this.widthInt / 4, this.heightInt);
            } else {
                this.objectSprite.setCrop(0, 0, this.widthInt, this.heightInt);
            }
            g3d.render((Node)this.objectSprite, this.objectTrans);
        } else {
            g3d.render(this.objectVertices, this.objectIndices, this.objectAppearance, this.objectTrans);
        }
    }

    public static void clear() {
        vertices.removeAllElements();
        indices.removeAllElements();
        appearances.removeAllElements();
        sprites.removeAllElements();
        quadPaths.removeAllElements();
        billboardPaths.removeAllElements();
        try {
            Thread.sleep(250L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }
}

