/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public class SoundManager {
    private static final String[] type = new String[]{".mid", ".wav", ".amr"};
    private static final String[] type2 = new String[]{"audio/midi", "audio/x-wav", "audio/amr"};
    public static Player sound;
    private static boolean playMusic;
    private static boolean playSound;
    private static boolean vibrate;
    private static int numberOfSounds;
    private static MIDlet midlet;
    private static boolean isPaused;
    private static int prevSfx;
    private static int previousTune;
    public static int lastSfx;
    private static final long CONF_DURATION = 1000L;
    private static long confZero;
    private static boolean confStarted;
    private static long prevMusicTime;
    private static boolean playIdle;

    public static boolean isPlayMusic() {
        return playMusic;
    }

    public static void setPlayMusic(boolean playMusic) {
        SoundManager.playMusic = playMusic;
        if (playMusic) {
            playSound = false;
        }
    }

    public static boolean isPlaySound() {
        return playSound;
    }

    public static void setPlaySound(boolean playSound) {
        SoundManager.playSound = playSound;
        if (playSound) {
            playMusic = false;
        }
    }

    public static boolean isVibrate() {
        return vibrate;
    }

    public static void setVibrate(boolean vibrate) {
        SoundManager.vibrate = vibrate;
    }

    public static void init(MIDlet app) {
        midlet = app;
    }

    public static void loadAll() {
    }

    public static void playMusic(int musicToPlay) {
        if (!playMusic) {
            return;
        }
        if (sound != null) {
            try {
                sound.stop();
                sound.deallocate();
                sound = null;
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (playMusic && musicToPlay != -1) {
            previousTune = musicToPlay;
            try {
                String tune = musicToPlay == 0 ? "/Audio/PacManMenuTheme" + type[0] : "/Audio/PacManCupTheme_" + Stats.worldName[GameLogic.gameWorld] + type[0];
                sound = Manager.createPlayer((InputStream)tune.getClass().getResourceAsStream(tune), (String)type2[0]);
                sound.realize();
                sound.setLoopCount(-1);
                sound.start();
            }
            catch (Exception e) {
                System.out.println("playmusic error");
                e.printStackTrace();
                SoundManager.stopAllSfx();
            }
        }
    }

    public static void pauseMusic() {
        if (playMusic) {
            try {
                sound.stop();
                Thread.sleep(100L);
                sound.deallocate();
                Thread.sleep(100L);
                sound.close();
                Thread.sleep(100L);
                sound = null;
                Thread.sleep(250L);
                System.gc();
                Thread.sleep(250L);
            }
            catch (Exception e) {
                sound = null;
                e.printStackTrace();
            }
            isPaused = true;
        }
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void resumeMusic() {
        if (playMusic) {
            SoundManager.playMusic(previousTune);
            isPaused = false;
        }
    }

    public static void playSfx(int sfxToPlay) {
        if (sfxToPlay > Constant.sfxName.length) {
            return;
        }
        if (playSound) {
            if (sfxToPlay == lastSfx && sound != null) {
                try {
                    sound.setMediaTime(0L);
                    sound.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            lastSfx = sfxToPlay;
            if (sound != null) {
                try {
                    sound.stop();
                    sound.deallocate();
                    sound.close();
                    sound = null;
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    sound = null;
                    e.printStackTrace();
                }
            }
            try {
                Object obj = new Object();
                sound = Manager.createPlayer((InputStream)obj.getClass().getResourceAsStream("/Audio/" + Constant.sfxName[sfxToPlay] + type[2]), (String)type2[2]);
                sound.realize();
                sound.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                SoundManager.stopAllSfx();
            }
            previousTune = -1;
        }
    }

    public static void stopAllSfx() {
        if (sound != null) {
            try {
                sound.stop();
                Thread.sleep(100L);
                sound.deallocate();
                Thread.sleep(100L);
                sound.close();
                Thread.sleep(100L);
                sound = null;
                Thread.sleep(250L);
                System.gc();
                Thread.sleep(250L);
            }
            catch (Exception e) {
                sound = null;
                e.printStackTrace();
            }
        }
    }

    public static void stopAllSfxNoSleep() {
        if (sound != null) {
            try {
                sound.stop();
                sound.deallocate();
                sound.close();
                sound = null;
            }
            catch (Exception e) {
                sound = null;
                e.printStackTrace();
            }
        }
    }

    public static void vibration(int duration) {
        if (vibrate) {
            Display.getDisplay((MIDlet)midlet).vibrate(duration);
        }
    }

    public static void checkMusic() {
        if (isPaused) {
            return;
        }
        if (sound != null && playMusic && sound.getState() != 400) {
            try {
                SoundManager.playMusic(previousTune);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void startConfirmation() {
        if (confStarted) {
            return;
        }
        SoundManager.playMusic(-1);
        SoundManager.playMusic(1);
        confZero = System.currentTimeMillis();
        confStarted = true;
    }

    public static void checkConfirmation() {
        if (!confStarted) {
            return;
        }
        if (System.currentTimeMillis() - confZero >= 1000L) {
            SoundManager.playMusic(-1);
            confStarted = false;
        }
    }

    public static void stopConfirmation() {
        if (confStarted) {
            confStarted = false;
        }
    }

    public static void check() {
        if (playMusic && sound != null && sound.getState() == 400) {
            long time = sound.getMediaTime();
            if (prevMusicTime == time) {
                try {
                    sound.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                prevMusicTime = time;
            }
        }
    }

    static {
        playMusic = false;
        playSound = false;
        vibrate = false;
        isPaused = false;
        prevSfx = -1;
        previousTune = -1;
        lastSfx = -1024;
        confStarted = false;
        prevMusicTime = 0L;
        playIdle = false;
    }
}

