/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;
import java.util.Random;

public class Kart
extends PhysicalEntity {
    private Vector3D vIntroMovement;
    private float randomIntroStart;
    private Vector3D vEffectRotation;
    private Vector3D chasisRot;
    private float wheelTurn = 0.0f;
    private float wheelRot = 0.0f;
    private float chasisOscillation = 0.0f;
    private Figure kartFigure;
    private Figure driverFigure;
    private Figure fwFigure;
    private Figure bwFigure;
    private Figure addFigure;
    private static Figure scaredFigure;
    private static Texture kartTexture;
    private static Texture driverTexture;
    private FigureLayout kartLayout = new FigureLayout();
    private Effect3D kartEffect = new Effect3D();
    private AffineTrans viewTransform;
    public Transform kartTrans;
    private Vector3D wheelFLLoc;
    private Vector3D wheelFRLoc;
    private Vector3D wheelBLLoc;
    private Vector3D wheelBRLoc;
    private Vector3D driverLoc;
    private Transform wheelFRTrans;
    private Transform wheelBLTrans;
    private Transform wheelFLTrans;
    private Transform wheelBRTrans;
    private Transform driverTrans;
    private float currentFrame = 0.0f;
    private float wheelSize;
    public static Vector3D sun;
    private Vector3D vCameraVector;
    public int collectibleCounter;
    public static int MAX_COLLECTIBLES;
    public static int BEGIN_COLLECTIBLES;
    private int itemCounter;
    private int currentItem;
    private int collectiblesToDrop;
    private int droppedItem;
    private int currentEffect;
    private float currentEffectTimeout;
    private boolean isVibrating;
    private float vibrateEffectTimeout;
    public int lap;
    public int actPos;
    public int bestPos;
    public boolean eaten;
    private float respawnTime;
    private float randomFrame;
    private int tempItem;
    public long randomItemGeneratorTimer;
    private float colectibleMultplier = 1.0f;
    private float boostMultiplier = 1.0f;
    private float autopilotMultiplier = 1.0f;
    private float invincibilityBoost = 1.0f;
    private int speedup;
    public boolean isBoosted;
    public float boostFrame;
    public boolean isSlowed;
    public float slowedFrame;
    public boolean activateFatality;
    public boolean isFatality;
    public boolean isScarred;
    public float fatalityFrame;
    public boolean isInvincible;
    public float invincibilityFrame;
    public boolean isAutopilot;
    public float autopilotFrame;
    private float lowestPoint = 0.0f;
    public static final int ITEM_RANDOM = -2;
    public static final int ITEM_NONE = -1;
    public static final int ITEM_COLLECTIBLE = 0;
    public static final int ITEM_BOOST = 1;
    public static final int ITEM_MISSILE = 2;
    public static final int ITEM_TRAP = 3;
    public static final int ITEM_FATALITY = 4;
    public static final int ITEM_INIVINCIBILITY = 5;
    public static final int ITEM_AUTOPILOT = 6;
    public static final int ITEM_BOOST_X3 = 7;
    public static final int ITEM_MISSILE_X3 = 8;
    public static final int EFFECT_NONE = -1;
    public static final int EFFECT_JUMP = 0;
    public static final int EFFECT_SKID = 1;
    public static final int EFFECT_BLINK = 2;
    public static final int EFFECT_DROP = 3;
    public static final int EFFECT_VIBRATION = 4;
    public static final int INSIDE_TRACK = 0;
    public static final int INNER_BORDER_TRACK = 1;
    public static final int OUTSIDE_BORDER_TRACK = 2;
    private int currentTrackSection;
    private static boolean intro;
    private SimpleObject shadow;
    private float shadowHeight;
    private float shadowWidth;
    private SimpleObject[] effect;
    private Transform[] tireLeftoverLeftTrans;
    private Transform[] tireLeftoverRightTrans;
    private Transform[] drillerTrans;
    private Transform[] tireLeftoverLeftTransBonus;
    private Transform[] tireLeftoverRightTransBonus;
    private float tireLeftoverScale;
    private int tireLeftoverFrame;
    private boolean showSmoke = false;
    public boolean showMud = false;
    private Transform flameTrans;
    private static final float flameScale = 14.0f;
    private int flameFrame = 0;
    private static Sprite3D[] smoke;
    private static Sprite3D[] boostsmoke;
    private static Sprite3D[] mud;
    private static Sprite3D[] grass;
    private static Sprite3D[] dust;
    private static Sprite3D driller;
    private static Sprite3D[] flame;
    private static Sprite3D[] flame1;
    private Transform flameTrans1;
    private static final float flameScale1 = 10.0f;
    private int flameFrame1 = 0;
    private static Sprite3D[] flame2;
    private Transform flameTrans2;
    private static final float flameScale2 = 6.0f;
    private int flameFrame2 = 0;
    private static float drillerScale;
    private Vector3D[] vEffectPos;
    private static final int NUMBER_OF_EFFECTS = 3;
    private static final int NUMBER_OF_EFFECTS_TYPES = 5;
    private static final int STAR = 0;
    private static final int GHOST = 1;
    private static final int CHERRY = 2;
    private static final int BIG_GUM = 3;
    private static final int KATAMARI = 4;
    private float maxCurrentJumpHeight;
    public int kartPosition;
    private float resistance;
    private float driftBoostTimer;
    private float driftBoostDuration;
    private int driftBoostCounter = 0;
    private static Random rand;
    public boolean isKatamari;
    private float katamariFrame;
    private Vector3D drillerLoc;
    private Vector3D flameLoc;
    private Vector3D flameLoc1;
    private Vector3D flameLoc2;
    private int offset;
    private float modframe;
    public boolean isTrapSet;
    private float isTrapSetFrame;
    private float teleportCounter = 0.0f;
    public boolean isTrap;
    public boolean showGrass = false;
    public boolean isGrass;
    public float invisibleHelperBoost = 1.0f;
    public boolean isTrapDeployed;
    private int driver;
    private int kart;
    private static int kartAmount;
    public int kartIndex;
    private int currentDoor = -1;
    public Vector3D posOffset;
    private Vector3D posNoY;
    private Vector3D oldPosNoY;
    private boolean showDust = false;
    public boolean isOnRocks = false;
    private float roll;
    private float maxRoll;
    private float driftRoll;
    private float maxDriftRoll;
    public int side;
    public boolean isBridgeCollision;
    private static boolean intitated;
    public boolean hasAddons = false;
    Vector3D sc_oldCamera = new Vector3D();
    Vector3D sc_newCamera = new Vector3D();
    Vector3D sc_vel = new Vector3D();
    Vector3D sc_sub = new Vector3D();
    Vector3D sc_modvec = new Vector3D();
    Vector3D sc_modvec2 = new Vector3D();
    private boolean angleDone = false;
    Vector3D st_pos = new Vector3D();
    Vector3D st_pos1 = new Vector3D();
    private AffineTrans kartTransform = new AffineTrans();
    private AffineTrans driverTransform = new AffineTrans();
    private AffineTrans flWheelTransform = new AffineTrans();
    private AffineTrans frWheelTransform = new AffineTrans();
    private AffineTrans blWheelTransform = new AffineTrans();
    private AffineTrans brWheelTransform = new AffineTrans();
    private static float[] m;
    private AffineTrans trans = new AffineTrans();
    private boolean driftSfx = false;

    private static void initSprites() {
        if (!intitated) {
            int i;
            Appearance app = new Appearance();
            int s = 150;
            Kart.smoke[0] = ResourceManager.createSprite3D(true, 29, app);
            Kart.smoke[1] = ResourceManager.createSprite3D(true, 30, app);
            Kart.smoke[2] = ResourceManager.createSprite3D(true, 31, app);
            Kart.smoke[3] = ResourceManager.createSprite3D(true, 32, app);
            for (i = 0; i < 4; ++i) {
                smoke[i].setSize(s, s);
            }
            Kart.boostsmoke[0] = ResourceManager.createSprite3D(true, 33, app);
            Kart.boostsmoke[1] = ResourceManager.createSprite3D(true, 34, app);
            Kart.boostsmoke[2] = ResourceManager.createSprite3D(true, 35, app);
            Kart.boostsmoke[3] = ResourceManager.createSprite3D(true, 36, app);
            for (i = 0; i < 4; ++i) {
                boostsmoke[i].setSize(s, s);
            }
            if (Stats.worldName[GameLogic.gameWorld].equals("ghost")) {
                Kart.mud[0] = ResourceManager.createSprite3D(true, 57, app);
                Kart.mud[1] = ResourceManager.createSprite3D(true, 58, app);
                Kart.mud[2] = ResourceManager.createSprite3D(true, 59, app);
                Kart.mud[3] = ResourceManager.createSprite3D(true, 60, app);
                for (i = 0; i < 4; ++i) {
                    mud[i].setSize(s, s);
                }
                Kart.grass[0] = ResourceManager.createSprite3D(true, 41, app);
                Kart.grass[1] = ResourceManager.createSprite3D(true, 42, app);
                Kart.grass[2] = ResourceManager.createSprite3D(true, 43, app);
                Kart.grass[3] = ResourceManager.createSprite3D(true, 44, app);
                for (i = 0; i < 4; ++i) {
                    grass[i].setSize(s, s);
                }
            } else {
                Kart.mud[0] = ResourceManager.createSprite3D(true, 53, app);
                Kart.mud[1] = ResourceManager.createSprite3D(true, 54, app);
                Kart.mud[2] = ResourceManager.createSprite3D(true, 55, app);
                Kart.mud[3] = ResourceManager.createSprite3D(true, 56, app);
                for (i = 0; i < 4; ++i) {
                    mud[i].setSize(80, 80);
                }
                Kart.grass[0] = ResourceManager.createSprite3D(true, 37, app);
                Kart.grass[1] = ResourceManager.createSprite3D(true, 38, app);
                Kart.grass[2] = ResourceManager.createSprite3D(true, 39, app);
                Kart.grass[3] = ResourceManager.createSprite3D(true, 40, app);
                for (i = 0; i < 4; ++i) {
                    grass[i].setSize(s, s);
                }
            }
            if (Stats.worldName[GameLogic.gameWorld].equals("kat")) {
                Kart.dust[0] = ResourceManager.createSprite3D(true, 49, app);
                Kart.dust[1] = ResourceManager.createSprite3D(true, 50, app);
                Kart.dust[2] = ResourceManager.createSprite3D(true, 51, app);
                Kart.dust[3] = ResourceManager.createSprite3D(true, 52, app);
                for (i = 0; i < 4; ++i) {
                    dust[i].setSize(s, s);
                }
            } else {
                Kart.dust[0] = ResourceManager.createSprite3D(true, 45, app);
                Kart.dust[1] = ResourceManager.createSprite3D(true, 46, app);
                Kart.dust[2] = ResourceManager.createSprite3D(true, 47, app);
                Kart.dust[3] = ResourceManager.createSprite3D(true, 48, app);
                for (i = 0; i < 4; ++i) {
                    dust[i].setSize(s, s);
                }
            }
            Kart.flame[0] = ResourceManager.createSprite3D(true, 61, app);
            Kart.flame[1] = ResourceManager.createSprite3D(true, 62, app);
            Kart.flame[2] = ResourceManager.createSprite3D(true, 63, app);
            Kart.flame[3] = ResourceManager.createSprite3D(true, 61, app);
            for (i = 0; i < 4; ++i) {
                flame[i].setSize(s, s);
            }
            driller = ResourceManager.createSprite3D(true, 75, app);
            driller.setSize(85, 85);
            Kart.flame1[0] = ResourceManager.createSprite3D(true, 62, app);
            Kart.flame1[1] = ResourceManager.createSprite3D(true, 63, app);
            Kart.flame1[2] = ResourceManager.createSprite3D(true, 61, app);
            Kart.flame1[3] = ResourceManager.createSprite3D(true, 62, app);
            for (i = 0; i < 4; ++i) {
                flame1[i].setSize(s, s);
            }
            Kart.flame2[0] = ResourceManager.createSprite3D(true, 63, app);
            Kart.flame2[1] = ResourceManager.createSprite3D(true, 61, app);
            Kart.flame2[2] = ResourceManager.createSprite3D(true, 62, app);
            Kart.flame2[3] = ResourceManager.createSprite3D(true, 63, app);
            for (i = 0; i < 4; ++i) {
                flame2[i].setSize(s, s);
            }
            intitated = true;
        }
    }

    public static void clearData() {
        if (intitated) {
            int i;
            for (i = 0; i < smoke.length; ++i) {
                Kart.smoke[i] = null;
            }
            for (i = 0; i < boostsmoke.length; ++i) {
                Kart.boostsmoke[i] = null;
            }
            for (i = 0; i < mud.length; ++i) {
                Kart.mud[i] = null;
            }
            for (i = 0; i < grass.length; ++i) {
                Kart.grass[i] = null;
            }
            for (i = 0; i < dust.length; ++i) {
                Kart.dust[i] = null;
            }
            for (i = 0; i < flame.length; ++i) {
                Kart.flame[i] = null;
            }
            driller = null;
            for (i = 0; i < flame1.length; ++i) {
                Kart.flame1[i] = null;
            }
            for (i = 0; i < flame2.length; ++i) {
                Kart.flame2[i] = null;
            }
            intitated = false;
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.gc();
        }
    }

    public Kart() {
        this.kartIndex = kartAmount++;
        this.entityType = 0;
        this.chasisRot = new Vector3D();
        this.vIntroMovement = new Vector3D();
        this.kartTrans = new Transform();
        this.wheelFRTrans = new Transform();
        this.wheelBLTrans = new Transform();
        this.wheelFLTrans = new Transform();
        this.wheelBRTrans = new Transform();
        this.driverTrans = new Transform();
        this.vCameraVector = new Vector3D();
        this.vEffectRotation = new Vector3D();
        this.effect = new SimpleObject[15];
        this.vEffectPos = new Vector3D[15];
    }

    public void init(Vector3D position, Vector3D direction, Vector3D _posOffset, int _kart, int _driver, int HANDLING, int ACCELERATION, int WEIGHT, int difficulty, boolean player, float roll, float drift_roll) {
        if (Menu.loadingStage != 1) {
            Kart.initSprites();
        }
        this.roll = roll;
        this.driftRoll = drift_roll;
        this.eaten = false;
        this.isPlayer = player;
        this.driver = _driver;
        this.kart = _kart;
        this.hasAddons = this.kart != 0;
        this.posOffset = new Vector3D(_posOffset);
        this.objectInfo = "Entity " + this.kart + " with " + this.driver;
        float mass = Stats.calculateMass(WEIGHT, difficulty);
        float enginepull = Stats.calculateEnginePull(ACCELERATION, difficulty);
        float brakefactor = Stats.calculateBrakeFactor(WEIGHT, HANDLING, difficulty);
        float maxspeed = Stats.MAX_SPEED[difficulty] * (float)Track.mScale;
        float turnangle = Stats.calculateTurnAngle(HANDLING, difficulty);
        float turningspeed = Stats.calculateTurningSpeed(HANDLING, difficulty);
        float tirefriction = Stats.calculateTireFriction(HANDLING, difficulty);
        super.init(mass, position, direction, enginepull, brakefactor, maxspeed, turnangle, turningspeed, tirefriction);
        this.setStaticCollisionModifier(Stats.COLLISION_POWER);
        this.collectibleCounter = BEGIN_COLLECTIBLES;
        if (GameLogic.gameMode != 2) {
            this.itemCounter = 0;
            this.currentItem = -1;
        } else {
            this.itemCounter = 3;
            this.currentItem = 1;
        }
        this.currentEffect = -1;
        this.maxRoll = Math.abs(turnangle * maxspeed * roll);
        this.maxDriftRoll = Math.abs(turnangle * maxspeed * this.driftRoll);
        this.loadWheel();
        this.loadKart();
        this.loadAdds();
        this.loadDriver();
        this.loadScarredGhost();
        String fName = "/Meshes/Kart/txt_karts_set.bmp";
        try {
            if (kartTexture == null) {
                kartTexture = new Texture(fName, true);
            }
            this.kartFigure.setTexture(kartTexture);
            if (this.driver != 4) {
                this.fwFigure.setTexture(kartTexture);
                this.bwFigure.setTexture(kartTexture);
            }
            if (this.hasAddons) {
                this.addFigure.setTexture(kartTexture);
            }
        }
        catch (Exception e) {
            System.out.println("Error: unable to load kart texture: " + fName);
        }
        fName = "/Meshes/Character/txt_drivers_set.bmp";
        try {
            if (driverTexture == null) {
                driverTexture = SpriteLoader.LoadSprite(fName);
            }
            if (this.driver != 4) {
                this.driverFigure.setTexture(driverTexture);
            }
            scaredFigure.setTexture(driverTexture);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error: unable to load kart texture: " + fName);
        }
        this.loadTireEffects();
        this.loadFlame();
        this.chasisRot.setx(0.0f);
        this.chasisRot.sety(0.0f);
        this.chasisRot.setz(0.0f);
        this.lap = 1;
        this.droppedItem = -1;
        this.collectiblesToDrop = 0;
        this.maxCurrentJumpHeight = 0.0f;
        for (int i = 0; i < 15; ++i) {
            this.effect[i] = new SimpleObject();
            this.vEffectPos[i] = new Vector3D();
            if (i < 3) {
                this.effect[i].init(64, 8.0f, 8.0f, true, true);
                continue;
            }
            if (i < 6) {
                this.effect[i].init(73, 6.0f, 6.0f, true, true);
                continue;
            }
            if (i < 9) {
                this.effect[i].init(74, 6.0f, 6.0f, true, true);
                continue;
            }
            if (i < 12) {
                this.effect[i].init(69, 6.0f, 6.0f, true, true);
                continue;
            }
            if (i >= 15) continue;
            this.effect[i].init(66, 10.0f, 10.0f, true, true);
        }
        this.shadow = new SimpleObject();
        float sw = this.getWidth() * 2.0f / (float)Track.mScale;
        float sh = this.getLength() * 1.5f / (float)Track.mScale;
        if (this.driver == 4) {
            this.shadow.init(88, sw, sh, false, false);
        } else if (this.driver == 1 || this.driver == 5) {
            this.shadow.init(87, sw, sh, false, false);
        } else {
            this.shadow.init(86, sw, sh, false, false);
        }
        this.shadowHeight = this.shadow.getHeight();
        this.shadowWidth = this.shadow.getWidth();
        this.setResistance();
        this.currentTrackSection = 0;
        this.randomIntroStart = rand.nextFloat();
    }

    private void loadTireEffects() {
        this.tireLeftoverLeftTrans = new Transform[3];
        this.tireLeftoverRightTrans = new Transform[3];
        this.tireLeftoverLeftTransBonus = new Transform[3];
        this.tireLeftoverRightTransBonus = new Transform[3];
        for (int i = 0; i < 3; ++i) {
            this.tireLeftoverLeftTrans[i] = new Transform();
            this.tireLeftoverRightTrans[i] = new Transform();
            this.tireLeftoverLeftTransBonus[i] = new Transform();
            this.tireLeftoverRightTransBonus[i] = new Transform();
        }
        this.tireLeftoverScale = 8.0f;
        this.tireLeftoverFrame = 0;
    }

    private void loadFlame() {
        this.flameTrans = new Transform();
        this.drillerTrans = new Transform[3];
        for (int i = 0; i < 3; ++i) {
            this.drillerTrans[i] = new Transform();
        }
        this.flameTrans1 = new Transform();
        this.flameTrans2 = new Transform();
    }

    private void loadAdds() {
        if (!this.hasAddons) {
            return;
        }
        String fName = "";
        fName = this.driver < 6 ? "/Meshes/Kart/" + Stats.char_name[this.driver] + Stats.kart_adds[this.kart - 1] + ".mbac" : "/Meshes/Kart/Ghost" + Stats.kart_adds[this.kart - 1] + ".mbac";
        try {
            this.addFigure = new Figure(fName);
        }
        catch (Exception e) {
            System.out.println("Error: unable to load add-on mesh: " + fName);
        }
    }

    private void loadWheel() {
        if (this.driver == 4) {
            return;
        }
        String fName = "/Meshes/Kart/" + Stats.char_name[this.driver] + "_fw" + ".mbac";
        try {
            this.fwFigure = new Figure(fName);
        }
        catch (Exception e) {
            System.out.println("Error: unable to load front wheel mesh: " + fName);
        }
        fName = "/Meshes/Kart/" + Stats.char_name[this.driver] + "_bw" + ".mbac";
        try {
            this.bwFigure = new Figure(fName);
        }
        catch (Exception e) {
            System.out.println("Error: unable to load rear wheel mesh: " + fName);
        }
    }

    private void loadKart() {
        Object[] buffers = new Object[3];
        float[] sizes = new float[6];
        String[] names = new String[]{"wheel1", "wheel2", "wheel3", "wheel4", "driver", "flame"};
        Vector3D[] bones = new Vector3D[6];
        boolean loaded = true;
        String fName = "/Meshes/Kart/" + Stats.char_name[this.driver] + "_ch" + ".mbac";
        try {
            this.kartFigure = new Figure(fName);
        }
        catch (Exception e) {
            System.out.println("Error: unable to load kart mesh: " + fName);
            loaded = false;
        }
        if (loaded) {
            for (int i = 0; i < 6; ++i) {
                sizes[i] = Stats.kartSizes[this.driver][i];
            }
            float vs = 0.091503f;
            for (int i = 0; i < 6; ++i) {
                bones[i] = new Vector3D(Stats.kartBones[this.driver][i * 3 + 0] * vs, Stats.kartBones[this.driver][i * 3 + 1] * vs, Stats.kartBones[this.driver][i * 3 + 2] * vs);
            }
            this.setHeight(Math.abs(sizes[1] - sizes[3]) + this.wheelSize / 2.0f);
            this.setLength(Math.abs(sizes[4] - sizes[5]));
            this.setWidth(Math.abs(sizes[0] - sizes[1]));
            Vector3D[] bb = new Vector3D[8];
            for (int i = 0; i < 8; ++i) {
                bb[i] = new Vector3D();
            }
            this.lowestPoint = sizes[3] + this.wheelSize / 2.0f;
            bb[0].setx(sizes[0]);
            bb[0].sety(sizes[3] - this.wheelSize / 2.0f);
            bb[0].setz(sizes[4]);
            bb[1].setx(sizes[1]);
            bb[1].sety(sizes[3] - this.wheelSize / 2.0f);
            bb[1].setz(sizes[4]);
            bb[2].setx(sizes[1]);
            bb[2].sety(sizes[3] - this.wheelSize / 2.0f);
            bb[2].setz(sizes[5]);
            bb[3].setx(sizes[0]);
            bb[3].sety(sizes[3] - this.wheelSize / 2.0f);
            bb[3].setz(sizes[5]);
            bb[4].setx(sizes[0]);
            bb[4].sety(sizes[2]);
            bb[4].setz(sizes[4]);
            bb[5].setx(sizes[1]);
            bb[5].sety(sizes[2]);
            bb[5].setz(sizes[4]);
            bb[6].setx(sizes[1]);
            bb[6].sety(sizes[2]);
            bb[6].setz(sizes[5]);
            bb[7].setx(sizes[0]);
            bb[7].sety(sizes[2]);
            bb[7].setz(sizes[5]);
            this.setBoundingBox(bb);
            this.wheelFLLoc = bones[0];
            this.wheelFRLoc = bones[1];
            this.wheelBLLoc = bones[2];
            this.wheelBRLoc = bones[3];
            this.driverLoc = bones[4];
            if (this.driver == 4) {
                this.driverLoc.sub(new Vector3D(0.0f, -90.0f, 50.0f));
            }
            this.drillerLoc = new Vector3D();
            this.drillerLoc.set(this.driverLoc);
            Vector3D tempd = new Vector3D(0.0f, 1.0f, -20.0f);
            tempd.scalarMul(Track.mScale);
            this.drillerLoc.sub(tempd);
            bones[5] = null;
            if (bones[5] != null) {
                this.flameLoc = bones[5];
                this.flameLoc1 = new Vector3D();
                this.flameLoc1.set(bones[5]);
                Vector3D temp1 = new Vector3D(0.0f, 10.0f, -6.0f);
                temp1.scalarMul(Track.mScale);
                this.flameLoc1.sub(temp1);
                this.flameLoc2 = new Vector3D();
                this.flameLoc2.set(bones[5]);
                Vector3D temp2 = new Vector3D(0.0f, 10.0f, -9.0f);
                temp2.scalarMul(Track.mScale);
                this.flameLoc2.sub(temp2);
            } else {
                this.flameLoc = new Vector3D();
                this.flameLoc.set(this.driverLoc);
                Vector3D temp = new Vector3D(15.0f, 100.0f, -110.0f);
                this.flameLoc.sub(temp);
                this.flameLoc1 = new Vector3D();
                this.flameLoc1.set(bones[4]);
                Vector3D temp1 = new Vector3D(15.0f, 100.0f, -125.0f);
                this.flameLoc1.sub(temp1);
                this.flameLoc2 = new Vector3D();
                this.flameLoc2.set(bones[4]);
                Vector3D temp2 = new Vector3D(15.0f, 100.0f, -140.0f);
                this.flameLoc2.sub(temp2);
            }
            this.setTurnBase(Math.abs(this.wheelFRLoc.getz() - this.wheelBRLoc.getz()));
        } else {
            System.out.println("There was an error in kart.");
        }
    }

    private void loadDriver() {
        if (this.driver == 4) {
            return;
        }
        String fName = "/Meshes/Character/" + Stats.char_name[this.driver] + ".mbac";
        try {
            this.driverFigure = new Figure(fName);
        }
        catch (Exception e) {
            System.out.println("Error: unable to load driver mesh: " + fName);
        }
    }

    private void loadScarredGhost() {
        String fName = "/Meshes/Character/Ghost.mbac";
        try {
            if (scaredFigure == null) {
                scaredFigure = new Figure(fName);
            }
        }
        catch (Exception e) {
            System.out.println("Error: unable to load scared ghost mesh: " + fName);
        }
    }

    public static void beginIntro() {
        intro = true;
    }

    public static void endIntro() {
        intro = false;
    }

    public int getCurrentDoor() {
        return this.currentDoor;
    }

    public void setCurrentDoor(int door) {
        this.currentDoor = door;
    }

    public void teleport(Vector3D pos, Vector3D dir) {
        this.setPosition(pos);
        this.setDirection(dir);
        this.clearCollisions();
        this.startEffect(3, 30);
        if (this.isPlayer) {
            SoundManager.vibration(1200);
        }
        this.teleportCounter = 0.0f;
    }

    public void eatGhost() {
        this.teleport(this.vPosition, this.vDirection);
        this.eaten = true;
        this.respawnTime = 0.0f;
        this.setSleep();
    }

    private void dropCollectibles() {
        int power = GameLogic.gameMode == 3 ? (int)(this.getCollisionVelocity().length() * 0.6f) : (int)(this.getCollisionVelocity().length() * 0.25f);
        for (int i = 0; i < power && i < 3; ++i) {
            this.dropCollectible();
        }
    }

    public void brakePush() {
        super.brakePush();
        this.endBoost();
    }

    public void triggerObjectCollision(Vector3D dist, Vector3D v, float myPower, float opPower, float myMod, float opMod, float opMass, boolean victim, boolean opscarred, boolean opinvulnerable, boolean opautopilot, boolean opkatamari) {
        super.triggerObjectCollision(dist, v, opMass, myPower, opPower, myMod, opMod);
        if (this.isPlayer) {
            if (!RaceManager.vibrateCamera) {
                RaceManager.vibrateCamera = true;
                RaceManager.cameraFrameCounter = this.getCollisionVelocity().length() * 4.0f;
            }
            if (!RaceManager.gForceCamera) {
                RaceManager.gForceCamera = true;
                RaceManager.gForceCameraFrameCounter = this.getCollisionVelocity().length() / 8.0f;
                RaceManager.gForceCameraVector.set(this.getCollisionVelocity());
            }
            SoundManager.playSfx(8);
        }
        if (GameLogic.gameMode == 3) {
            if (this.isPlayer) {
                SoundManager.vibration(10);
                if (!this.isInvincible && !this.isFatality) {
                    if (this.isKatamari) {
                        --this.itemCounter;
                        if (this.itemCounter == 0) {
                            this.currentItem = -1;
                        }
                    } else {
                        this.dropCollectibles();
                        if (myMod == 0.0f) {
                            this.startEffect(0, 20);
                            this.eaten = true;
                            SoundManager.vibration(700);
                        } else {
                            SoundManager.vibration(100);
                        }
                    }
                }
            } else if (this.isScarred && !opscarred) {
                for (int i = 0; i < 5; ++i) {
                    this.dropCollectible();
                }
                this.eatGhost();
            }
        } else {
            if (this.isPlayer) {
                SoundManager.vibration(10);
            }
            if (this.isKatamari) {
                --this.itemCounter;
                if (this.itemCounter == 0) {
                    this.currentItem = -1;
                }
            }
            if (opkatamari) {
                if (!this.isInvincible) {
                    this.startEffect(0, 20);
                    if (this.isPlayer) {
                        SoundManager.vibration(600);
                    }
                }
            } else if (opinvulnerable) {
                if (this.isInvincible) {
                    if (victim) {
                        this.dropCollectibles();
                        if (myMod == 0.0f) {
                            this.startEffect(0, 20);
                            if (this.isPlayer) {
                                SoundManager.vibration(600);
                            }
                        }
                    }
                } else if (this.isAutopilot) {
                    this.startEffect(0, 20);
                    if (this.isPlayer) {
                        SoundManager.vibration(600);
                    }
                } else if (this.isScarred) {
                    this.startEffect(0, 20);
                    if (this.isPlayer) {
                        SoundManager.vibration(600);
                    }
                } else {
                    this.startEffect(0, 20);
                    if (this.isPlayer) {
                        SoundManager.vibration(600);
                    }
                }
            } else if (opautopilot) {
                if (!this.isInvincible) {
                    if (this.isAutopilot) {
                        if (victim) {
                            this.dropCollectibles();
                            if (myMod == 0.0f) {
                                this.startEffect(0, 20);
                                if (this.isPlayer) {
                                    SoundManager.vibration(600);
                                }
                            }
                        }
                    } else if (this.isScarred) {
                        this.startEffect(0, 20);
                        if (this.isPlayer) {
                            SoundManager.vibration(600);
                        }
                    } else if (victim) {
                        this.dropCollectibles();
                        if (myMod == 0.0f) {
                            this.startEffect(0, 20);
                            if (this.isPlayer) {
                                SoundManager.vibration(600);
                            }
                        }
                    }
                }
            } else if (opscarred) {
                if (!this.isInvincible && !this.isAutopilot && this.isScarred && victim) {
                    this.dropCollectibles();
                    if (myMod == 0.0f) {
                        this.startEffect(0, 20);
                        if (this.isPlayer) {
                            SoundManager.vibration(600);
                        }
                    }
                }
            } else if (!this.isInvincible && !this.isAutopilot) {
                if (this.isScarred) {
                    for (int i = 0; i < 5; ++i) {
                        this.dropCollectible();
                    }
                    this.startEffect(0, 30);
                    if (this.isPlayer) {
                        SoundManager.vibration(700);
                    }
                } else if (victim) {
                    this.dropCollectibles();
                    if (myMod == 0.0f) {
                        this.startEffect(0, 20);
                        if (this.isPlayer) {
                            SoundManager.vibration(600);
                        }
                    }
                }
            }
        }
    }

    public void manageIntro(float frame) {
        this.vIntroMovement.setz((float)mMath.sin(this.currentFrame + this.randomIntroStart) / (1.0f + this.randomIntroStart));
    }

    public void update(float frame) {
        if (GameLogic.gameMode == 3 && this.eaten) {
            this.respawnTime += frame;
            if (!this.isPlayer && this.respawnTime < 30.0f) {
                this.setEffectEatenGhosts(this.respawnTime);
            }
            if (this.respawnTime > 90.0f) {
                this.eaten = false;
                this.setAwake();
            }
        }
        super.update(frame);
        this.currentFrame += frame;
        this.setCamera();
        if (intro) {
            this.setEffects(frame);
        } else {
            this.manageItems(frame);
            this.setEffects(frame);
            this.setDriftBoost(frame);
            this.setMaxSpeed();
            if (this.activateFatality) {
                this.fatalityFrame = GameLogic.gameMode != 3 ? 120.0f : 180.0f;
                if (this.isScarred) {
                    this.isFatality = true;
                    this.activateFatality = false;
                }
            }
            this.setVariableCollisionModifier(this.resistance);
            this.setTeleportCounter(frame);
        }
        if ((this.isHandbrakeActive() || this.isHandbrakeReleased()) && this.getAltitudeVelocity().length() == 0.0f) {
            if (!this.showSmoke) {
                for (int i = 0; i < this.tireLeftoverLeftTrans.length; ++i) {
                    this.tireLeftoverLeftTrans[i].setIdentity();
                    this.tireLeftoverRightTrans[i].setIdentity();
                }
            }
            this.showGrass = false;
            this.showMud = false;
            this.showDust = false;
            this.showSmoke = true;
        } else if (!(this.showSmoke || this.showMud || !this.isGrass || this.showGrass || this.showDust)) {
            for (int i = 0; i < this.tireLeftoverLeftTrans.length; ++i) {
                this.tireLeftoverLeftTrans[i].setIdentity();
                this.tireLeftoverRightTrans[i].setIdentity();
            }
            this.showGrass = true;
        } else if (!this.isGrass) {
            this.showGrass = false;
            this.showSmoke = false;
        } else {
            this.showSmoke = false;
        }
        if (!this.isBridgeCollision) {
            this.side = 0;
        }
        if (this.isBridgeCollision) {
            this.isBridgeCollision = false;
        }
    }

    public void setPhysicalConstraints(float frame) {
        super.setPhysicalConstraints(frame);
        if (this.isPlayer) {
            this.posNoY = new Vector3D(this.vPosition);
            this.posNoY.sety(0.0f);
            this.oldPosNoY = new Vector3D(this.vOldPosition);
            this.oldPosNoY.sety(0.0f);
            new Vector3D();
            this.actualSpeed = Vector3D.sub(this.posNoY, this.oldPosNoY);
        }
    }

    public void updateShadow() {
        float loc_maxRoll;
        float loc_roll;
        float scale = 1.0f + (float)mMath.ln(1.0f + Math.max(0.0f, this.getPosition().gety() - this.getGroundLevel() - this.getHeight() / 3.0f) / 350.0f) + this.chasisOscillation / 10.0f;
        if (this.isHandbrakeActive()) {
            loc_roll = this.driftRoll;
            loc_maxRoll = this.maxDriftRoll;
        } else {
            loc_roll = this.roll;
            loc_maxRoll = this.maxRoll;
        }
        if (loc_roll < 0.0f) {
            this.shadow.setSize(this.shadowWidth * scale / (1.0f + Math.abs(this.chasisRot.getz()) / loc_maxRoll * 0.33f), this.shadowHeight * scale);
        } else {
            this.shadow.setSize(this.shadowWidth * scale, this.shadowHeight * scale);
        }
        Vector3D sunMove = Vector3D.add(sun, this.getPosition());
        if (loc_roll > 0.0f) {
            Vector3D pos = new Vector3D(sunMove);
            Vector3D move = Vector3D.crossProduct(this.getDirection(), new Vector3D(0.0f, 1.0f, 0.0f));
            move.scalarMul(-this.chasisRot.getz() * -0.05f);
            pos.add(move);
            this.shadow.setPosition(pos);
        } else {
            this.shadow.setPosition(sunMove);
        }
        this.shadow.setGroundLevel(this.getGroundLevel() - this.shadow.getHeight() + 10.0f);
        this.shadow.setDirection(new Vector3D(0.0f, 1.0f, 0.0f));
        Vector3D rot = new Vector3D(this.getMovementPlaneRotation());
        rot.sety(this.getEntityRotation().gety() - 90.0f);
        this.shadow.setPlaneRotation(rot);
        this.shadow.update();
    }

    private void setCamera() {
        this.sc_oldCamera.set(this.vCameraVector);
        this.sc_vel.set(this.getEngineVelocity());
        if (this.getForwardBackward() <= 0) {
            this.sc_vel.reverse();
        }
        this.sc_vel.add(this.getDriftVelocity());
        if (this.getForwardBackward() > 0 && this.sc_vel.length() > 0.0f) {
            this.sc_newCamera.set(this.sc_vel);
        } else {
            this.sc_newCamera.set(this.vDirection);
        }
        this.sc_newCamera.normalize();
        this.sc_newCamera.scalarMul(MainCanvas.CAMERA_POSITION_Y);
        this.sc_sub.set(0.0f, 1.0f, 0.0f);
        this.sc_newCamera.sub(this.sc_sub);
        this.sc_newCamera.normalize();
        this.sc_modvec.set(this.getMovementPlaneNormal());
        this.sc_modvec.sub(this.sc_sub);
        this.sc_modvec2.set(this.sc_sub);
        if (!this.sc_vel.isFdir(this.sc_modvec)) {
            this.sc_modvec2.scalarMul(this.sc_modvec.length());
        } else if (!this.getIsJumpDrift()) {
            this.sc_modvec2.scalarMul(-this.sc_modvec.length() - this.getAltitudeVelocity().length() / (20.0f * (float)Track.mScale));
        } else {
            this.sc_modvec2.scalarMul(-this.sc_modvec.length() + Math.min(0.0f, this.getAltitudeVelocity().gety()) / (30.0f * (float)Track.mScale));
        }
        this.sc_newCamera.add(this.sc_modvec2);
        this.sc_newCamera.normalize();
        this.vCameraVector.set(this.sc_oldCamera);
        this.vCameraVector.add(Vector3D.scalarDiv(2.0f, this.sc_newCamera));
        this.vCameraVector.normalize();
    }

    private void manageItems(float frame) {
        if (this.currentItem == -2) {
            this.randomFrame -= frame;
            if (this.randomFrame <= 0.0f) {
                this.currentItem = this.tempItem;
                this.tempItem = -1;
            }
        }
        if (this.isBoosted) {
            this.boostFrame -= frame;
            if (this.boostFrame <= 0.0f) {
                this.endBoost();
            }
        }
        if (this.isSlowed) {
            this.slowedFrame -= frame;
            if (this.slowedFrame <= 0.0f) {
                this.endSlowed();
            }
        }
        if (this.isFatality) {
            this.fatalityFrame -= frame;
            if (this.fatalityFrame <= 0.0f) {
                this.endFatality();
            }
        }
        if (this.isTrapSet) {
            this.isTrapSetFrame -= frame;
            if (this.isTrapSetFrame <= 0.0f) {
                this.endTrapSet();
            }
        }
        if (this.isInvincible) {
            this.invincibilityFrame -= frame;
            if (this.invincibilityFrame <= 0.0f) {
                this.endInvincibility();
            }
        }
        if (this.isAutopilot) {
            this.autopilotFrame -= frame;
            if (this.autopilotFrame <= 0.0f) {
                this.endAutopilot();
            }
        }
        if (this.isKatamari) {
            this.katamariFrame -= frame;
            if (this.itemCounter == 0) {
                this.endKatamari();
            }
        }
        if (this.isTrap && this.itemCounter == 0) {
            this.endTrap();
        }
    }

    private void setDriftBoost(float frame) {
        if (this.isHandbrakeActive()) {
            this.driftBoostTimer += frame;
        } else if (this.isHandbrakeProperlyEnded()) {
            if (this.driftBoostTimer > 17.0f) {
                this.driftBoostDuration = (this.driftBoostTimer - 17.0f) * 1.4f;
                ++this.driftBoostCounter;
                this.startBoost(this.driftBoostDuration);
                this.driftSfx = false;
            }
            this.driftBoostTimer = 0.0f;
        } else {
            this.driftBoostTimer = 0.0f;
        }
        if (this.driftBoostDuration > 0.0f) {
            this.driftBoostDuration -= frame;
        } else if (this.driftBoostDuration != 0.0f) {
            this.driftBoostDuration = 0.0f;
            this.endBoost();
        }
    }

    public int getDrfitBoostCounter() {
        return this.driftBoostCounter;
    }

    private void setMaxSpeed() {
        this.speedup = this.collectibleCounter;
        if (this.speedup > 10) {
            this.speedup = 10;
        }
        this.colectibleMultplier = Stats.colectibleSpeedup[this.speedup];
        float ms = this.getNominalMaxSpeed() * this.boostMultiplier * this.colectibleMultplier * this.invisibleHelperBoost * this.autopilotMultiplier * this.invincibilityBoost;
        if (this.getCurrentTurnAngle().gety() != 0.0f) {
            ms *= 0.85f;
        }
        if (this.isScarred) {
            ms *= 0.5f;
        }
        if (GameLogic.gameMode == 3 && !this.isPlayer) {
            ms *= 1.4f;
        }
        this.setCurrentMaxSpeed(ms);
        if (this.currentTrackSection == 1 || this.isSlowed) {
            if (!this.isBoosted && !this.isInvincible) {
                this.setCurrentMaxSpeed(ms / 2.0f);
            }
            this.canMove = true;
            this.isGrass = true;
        } else if (this.currentTrackSection == 2) {
            this.canMove = false;
            this.isGrass = false;
            this.stopKart(2);
        } else {
            this.isGrass = false;
        }
    }

    private void setResistance() {
        this.resistance = (float)this.collectibleCounter / 10.0f;
    }

    private void setEffects(float frame) {
        switch (this.currentEffect) {
            case 1: {
                this.setEffectSkid(frame);
                break;
            }
            case 0: {
                this.setEffectJump(frame);
                break;
            }
            case 2: {
                this.setEffectBlink(frame);
                break;
            }
            case 3: {
                this.clearCollisions();
                this.setEffectDrop(frame);
            }
        }
        if (this.isFatality) {
            this.setEffectGhosts(this.fatalityFrame);
        }
        if (this.isBoosted) {
            this.setEffectBoost(this.boostFrame);
        }
        if (this.isSlowed) {
            this.setEffectSlowed(this.slowedFrame);
        }
        if (this.isAutopilot) {
            this.setEffectAutopilot(this.autopilotFrame);
        }
        if (this.isInvincible) {
            this.setEffectStars(this.invincibilityFrame);
        }
        if (this.isKatamari) {
            this.setEffectKatamari(this.katamariFrame);
        }
        if (this.isVibrating) {
            this.setEffectVibrate(frame);
        }
        this.chasisOscillation = (float)mMath.sin(this.currentFrame) * Math.min(7.0f, this.getEngineVelocity().length()) / 45.0f;
        this.chasisRot.setx((this.chasisRot.getx() - this.getEngineAcceleration() * 2.0f) / 2.0f);
        float loc_roll = this.isHandbrakeActive() ? this.driftRoll : this.roll;
        if (!this.isAutopilot) {
            this.chasisRot.setz((this.chasisRot.getz() - this.getCurrentTurnAngle().gety() * this.getVelocity().length() * loc_roll) / 2.0f);
        } else {
            this.chasisRot.setz(0.0f);
        }
        this.wheelRot = this.getForwardBackward() == -1 ? (this.wheelRot += 9.0f * this.getEngineVelocity().length() * frame) : (this.wheelRot -= 9.0f * this.getEngineVelocity().length() * frame);
        this.wheelTurn = this.getForwardBackward() == -1 ? -this.getCurrentTurnAngle().gety() * 12.5f : this.getCurrentTurnAngle().gety() * 12.5f;
    }

    public void setTransformations() {
        if (!this.sleeping) {
            try {
                this.st_pos.set(this.getPosition());
                new Vector3D();
                new Vector3D();
                this.st_pos1.set(Vector3D.scalarMul(0.5f, Vector3D.add(this.st_pos, this.vOldPosition)));
                this.kartTrans.setIdentity();
                this.kartTrans.postTranslate(this.st_pos.getx(), this.st_pos.gety() + this.chasisOscillation - this.lowestPoint, this.st_pos.getz());
                this.kartTrans.postRotate(this.getMovementPlaneRotation().getx() + this.vEffectRotation.getx() - this.getEntityRotation().getx() + this.chasisRot.getx(), 1.0f, 0.0f, 0.0f);
                this.kartTrans.postRotate(this.getMovementPlaneRotation().getz() + this.vEffectRotation.getz() + this.getEntityRotation().getz() + this.chasisRot.getz(), 0.0f, 0.0f, 1.0f);
                this.kartTrans.postRotate(this.vEffectRotation.gety() + this.getEntityRotation().gety() + this.chasisRot.gety(), 0.0f, 1.0f, 0.0f);
            }
            catch (Exception e) {
                System.out.println(e + " in Kart");
            }
            try {
                this.driverTrans.setIdentity();
                this.driverTrans.postTranslate(this.st_pos.getx(), this.st_pos.gety() + this.chasisOscillation * 0.6f - this.lowestPoint, this.st_pos.getz());
                this.driverTrans.postRotate(this.getMovementPlaneRotation().getx() + this.vEffectRotation.getx() + this.getEntityRotation().getx(), 1.0f, 0.0f, 0.0f);
                this.driverTrans.postRotate(this.getMovementPlaneRotation().getz() + this.vEffectRotation.getz() + this.getEntityRotation().getz(), 0.0f, 0.0f, 1.0f);
                this.driverTrans.postRotate(this.vEffectRotation.gety() + this.getEntityRotation().gety(), 0.0f, 1.0f, 0.0f);
                this.driverTrans.postTranslate(this.driverLoc.getx(), this.driverLoc.gety(), this.driverLoc.getz());
                this.driverTrans.postRotate(this.chasisRot.getz(), 0.0f, 0.0f, 1.0f);
            }
            catch (Exception e) {
                System.out.println(e + " in Driver");
            }
            try {
                this.wheelFRTrans.setIdentity();
                this.wheelFRTrans.postTranslate(this.st_pos.getx(), this.st_pos.gety() - this.lowestPoint, this.st_pos.getz());
                this.wheelFRTrans.postRotate(this.getMovementPlaneRotation().getx() + this.vEffectRotation.getx() + this.getEntityRotation().getx(), 1.0f, 0.0f, 0.0f);
                this.wheelFRTrans.postRotate(this.getMovementPlaneRotation().getz() + this.vEffectRotation.getz() + this.getEntityRotation().getz(), 0.0f, 0.0f, 1.0f);
                this.wheelFRTrans.postRotate(this.vEffectRotation.gety() + this.getEntityRotation().gety(), 0.0f, 1.0f, 0.0f);
                this.wheelBLTrans.set(this.wheelFRTrans);
                this.wheelFLTrans.set(this.wheelFRTrans);
                this.wheelBRTrans.set(this.wheelFRTrans);
                this.wheelFRTrans.postTranslate(this.wheelFRLoc.getx(), this.wheelFRLoc.gety(), this.wheelFRLoc.getz());
                this.wheelBLTrans.postTranslate(this.wheelBLLoc.getx(), this.wheelBLLoc.gety(), this.wheelBLLoc.getz());
                this.wheelFLTrans.postTranslate(this.wheelFLLoc.getx(), this.wheelFLLoc.gety(), this.wheelFLLoc.getz());
                this.wheelBRTrans.postTranslate(this.wheelBRLoc.getx(), this.wheelBRLoc.gety(), this.wheelBRLoc.getz());
                this.wheelFRTrans.postRotate(this.wheelTurn, 0.0f, 1.0f, 0.0f);
                this.wheelFLTrans.postRotate(this.wheelTurn, 0.0f, 1.0f, 0.0f);
                this.wheelFRTrans.postRotate(this.chasisRot.getz(), 0.0f, 0.0f, 1.0f);
                this.wheelFLTrans.postRotate(this.chasisRot.getz(), 0.0f, 0.0f, 1.0f);
                this.wheelBLTrans.postRotate(this.chasisRot.getz(), 0.0f, 0.0f, 1.0f);
                this.wheelBRTrans.postRotate(this.chasisRot.getz(), 0.0f, 0.0f, 1.0f);
                this.wheelFRTrans.postRotate(this.wheelRot, 1.0f, 0.0f, 0.0f);
                this.wheelFLTrans.postRotate(this.wheelRot, 1.0f, 0.0f, 0.0f);
                this.wheelBLTrans.postRotate(this.wheelRot, 1.0f, 0.0f, 0.0f);
                this.wheelBRTrans.postRotate(this.wheelRot, 1.0f, 0.0f, 0.0f);
            }
            catch (Exception e) {
                System.out.println(e + " in Wheels");
            }
            if (this.isBoosted || this.isInvincible) {
                try {
                    this.flameTrans.setIdentity();
                    this.flameTrans.postTranslate(this.st_pos.getx(), this.st_pos.gety(), this.st_pos.getz());
                    this.flameTrans.postRotate(this.getMovementPlaneRotation().getx() + this.vEffectRotation.getx() + this.getEntityRotation().getx(), 1.0f, 0.0f, 0.0f);
                    this.flameTrans.postRotate(this.getMovementPlaneRotation().getz() + this.vEffectRotation.getz() + this.getEntityRotation().getz(), 0.0f, 0.0f, 1.0f);
                    this.flameTrans.postRotate(this.vEffectRotation.gety() + this.getEntityRotation().gety(), 0.0f, 1.0f, 0.0f);
                    this.flameTrans.postTranslate(this.flameLoc.getx(), this.flameLoc.gety(), this.flameLoc.getz());
                    float s = 0.9f + rand.nextFloat() / 10.0f;
                    this.flameTrans.postScale(14.0f * s, 14.0f * s, 1.0f);
                    this.flameFrame = (this.flameFrame + 1) % flame.length;
                }
                catch (Exception e) {
                    System.out.println(e + " in Flame");
                }
                try {
                    this.flameTrans1.setIdentity();
                    this.flameTrans1.postTranslate(this.st_pos.getx(), this.st_pos.gety(), this.st_pos.getz());
                    this.flameTrans1.postRotate(this.getMovementPlaneRotation().getx() + this.vEffectRotation.getx() + this.getEntityRotation().getx(), 1.0f, 0.0f, 0.0f);
                    this.flameTrans1.postRotate(this.getMovementPlaneRotation().getz() + this.vEffectRotation.getz() + this.getEntityRotation().getz(), 0.0f, 0.0f, 1.0f);
                    this.flameTrans1.postRotate(this.vEffectRotation.gety() + this.getEntityRotation().gety(), 0.0f, 1.0f, 0.0f);
                    this.flameTrans1.postTranslate(this.flameLoc1.getx(), this.flameLoc1.gety(), this.flameLoc1.getz());
                    float s = 0.9f + rand.nextFloat() / 10.0f;
                    this.flameTrans1.postScale(10.0f * s, 10.0f * s, 1.0f);
                    this.flameFrame1 = (this.flameFrame1 + 1) % flame1.length;
                }
                catch (Exception e) {
                    System.out.println(e + " in Flame");
                }
                try {
                    this.flameTrans2.setIdentity();
                    this.flameTrans2.postTranslate(this.st_pos.getx(), this.st_pos.gety(), this.st_pos.getz());
                    this.flameTrans2.postRotate(this.getMovementPlaneRotation().getx() + this.vEffectRotation.getx() + this.getEntityRotation().getx(), 1.0f, 0.0f, 0.0f);
                    this.flameTrans2.postRotate(this.getMovementPlaneRotation().getz() + this.vEffectRotation.getz() + this.getEntityRotation().getz(), 0.0f, 0.0f, 1.0f);
                    this.flameTrans2.postRotate(this.vEffectRotation.gety() + this.getEntityRotation().gety(), 0.0f, 1.0f, 0.0f);
                    this.flameTrans2.postTranslate(this.flameLoc2.getx(), this.flameLoc2.gety(), this.flameLoc2.getz());
                    float s = 0.9f + rand.nextFloat() / 10.0f;
                    this.flameTrans2.postScale(6.0f * s, 6.0f * s, 1.0f);
                    this.flameFrame2 = (this.flameFrame2 + 1) % flame2.length;
                }
                catch (Exception e) {
                    System.out.println(e + " in Flame");
                }
            }
            if (this.showSmoke || this.showMud || this.showGrass || this.showDust) {
                try {
                    for (int i = this.tireLeftoverLeftTrans.length - 1; i > 0; --i) {
                        this.tireLeftoverLeftTrans[i].set(this.tireLeftoverLeftTrans[i - 1]);
                        this.tireLeftoverRightTrans[i].set(this.tireLeftoverRightTrans[i - 1]);
                        this.tireLeftoverLeftTransBonus[i].set(this.tireLeftoverLeftTrans[i - 1]);
                        this.tireLeftoverRightTransBonus[i].set(this.tireLeftoverRightTrans[i - 1]);
                    }
                    this.tireLeftoverLeftTrans[0].setIdentity();
                    this.tireLeftoverLeftTrans[0].postTranslate(this.st_pos.getx(), this.st_pos.gety() - this.lowestPoint, this.st_pos.getz());
                    this.tireLeftoverLeftTrans[0].postRotate(this.getMovementPlaneRotation().getx() + this.vEffectRotation.getx() + this.getEntityRotation().getx(), 1.0f, 0.0f, 0.0f);
                    this.tireLeftoverLeftTrans[0].postRotate(this.getMovementPlaneRotation().getz() + this.vEffectRotation.getz() + this.getEntityRotation().getz(), 0.0f, 0.0f, 1.0f);
                    this.tireLeftoverLeftTrans[0].postRotate(this.vEffectRotation.gety() + this.getEntityRotation().gety(), 0.0f, 1.0f, 0.0f);
                    this.tireLeftoverRightTrans[0].set(this.tireLeftoverLeftTrans[0]);
                    this.tireLeftoverLeftTrans[0].postTranslate(this.wheelBLLoc.getx(), this.wheelBLLoc.gety(), this.wheelBLLoc.getz());
                    this.tireLeftoverRightTrans[0].postTranslate(this.wheelBRLoc.getx(), this.wheelBRLoc.gety(), this.wheelBRLoc.getz());
                    this.tireLeftoverLeftTrans[0].postTranslate(rand.nextFloat(), rand.nextFloat(), this.wheelSize * 0.75f);
                    this.tireLeftoverRightTrans[0].postTranslate(rand.nextFloat(), rand.nextFloat(), this.wheelSize * 0.75f);
                    float s = 0.9f + rand.nextFloat() / 10.0f;
                    this.tireLeftoverLeftTrans[0].postScale(this.tireLeftoverScale * s, this.tireLeftoverScale * s, 1.0f);
                    s = 0.9f + rand.nextFloat() / 10.0f;
                    this.tireLeftoverRightTrans[0].postScale(this.tireLeftoverScale * s, this.tireLeftoverScale * s, 1.0f);
                    this.tireLeftoverLeftTransBonus[0].setIdentity();
                    this.tireLeftoverLeftTransBonus[0].postTranslate(this.st_pos1.getx() - this.vDirection.getx(), this.st_pos1.gety() - this.lowestPoint, this.st_pos1.getz() - this.vDirection.getz());
                    this.tireLeftoverLeftTransBonus[0].postRotate(this.getMovementPlaneRotation().getx() + this.vEffectRotation.getx() + this.getEntityRotation().getx(), 1.0f, 0.0f, 0.0f);
                    this.tireLeftoverLeftTransBonus[0].postRotate(this.getMovementPlaneRotation().getz() + this.vEffectRotation.getz() + this.getEntityRotation().getz(), 0.0f, 0.0f, 1.0f);
                    this.tireLeftoverLeftTransBonus[0].postRotate(this.vEffectRotation.gety() + this.getEntityRotation().gety(), 0.0f, 1.0f, 0.0f);
                    this.tireLeftoverRightTransBonus[0].set(this.tireLeftoverLeftTransBonus[0]);
                    this.tireLeftoverLeftTransBonus[0].postTranslate(this.wheelBLLoc.getx(), this.wheelBLLoc.gety(), this.wheelBLLoc.getz());
                    this.tireLeftoverRightTransBonus[0].postTranslate(this.wheelBRLoc.getx(), this.wheelBRLoc.gety(), this.wheelBRLoc.getz());
                    this.tireLeftoverLeftTransBonus[0].postTranslate(rand.nextFloat(), rand.nextFloat(), this.wheelSize * 0.75f);
                    this.tireLeftoverRightTransBonus[0].postTranslate(rand.nextFloat(), rand.nextFloat(), this.wheelSize * 0.75f);
                    s = 0.9f + rand.nextFloat() / 10.0f;
                    this.tireLeftoverLeftTransBonus[0].postScale(this.tireLeftoverScale * s, this.tireLeftoverScale * s, 1.0f);
                    s = 0.9f + rand.nextFloat() / 10.0f;
                    this.tireLeftoverRightTransBonus[0].postScale(this.tireLeftoverScale * s, this.tireLeftoverScale * s, 1.0f);
                }
                catch (Exception e) {
                    System.out.println(e + " in Smoke");
                }
            }
            if (this.isTrap) {
                try {
                    for (int i = this.drillerTrans.length - 1; i > 0; --i) {
                        this.drillerTrans[i].set(this.drillerTrans[i - 1]);
                    }
                    this.drillerTrans[0].setIdentity();
                    this.drillerTrans[0].postTranslate(this.st_pos.getx(), this.st_pos.gety(), this.st_pos.getz());
                    this.drillerTrans[0].postRotate(this.getMovementPlaneRotation().getx() + this.vEffectRotation.getx() + this.getEntityRotation().getx(), 1.0f, 0.0f, 0.0f);
                    this.drillerTrans[0].postRotate(this.getMovementPlaneRotation().getz() + this.vEffectRotation.getz() + this.getEntityRotation().getz(), 0.0f, 0.0f, 1.0f);
                    this.drillerTrans[0].postRotate(this.vEffectRotation.gety() + this.getEntityRotation().gety(), 0.0f, 1.0f, 0.0f);
                    this.drillerTrans[0].postTranslate(this.drillerLoc.getx(), this.drillerLoc.gety(), this.drillerLoc.getz());
                    this.drillerTrans[0].postScale(drillerScale, drillerScale, 1.0f);
                }
                catch (Exception e) {
                    System.out.println(e + " in driller");
                }
            }
        }
    }

    public void renderShadow(Graphics3D g3d) {
        if (!this.sleeping) {
            if (this.driver != 4) {
                this.shadow.render(g3d);
            } else if (!this.isScarred) {
                this.shadow.render(g3d);
            }
        }
    }

    public void renderShadow(Graphics3D g3d, FigureLayout layout, AffineTrans camTrans) {
        if (!this.sleeping) {
            if (this.driver != 4) {
                this.shadow.render(g3d, layout, camTrans);
            } else if (!this.isScarred) {
                this.shadow.render(g3d, layout, camTrans);
            }
        }
    }

    public static void copyMatrix(Transform src, AffineTrans dest) {
        float mul = 4096.0f;
        src.get(m);
        dest.setIdentity();
        dest.m00 = (int)(m[0] * mul);
        dest.m01 = (int)(m[1] * mul);
        dest.m02 = (int)(m[2] * mul);
        dest.m03 = (int)m[3];
        dest.m10 = (int)(m[4] * mul);
        dest.m11 = (int)(m[5] * mul);
        dest.m12 = (int)(m[6] * mul);
        dest.m13 = (int)m[7];
        dest.m20 = (int)(m[8] * mul);
        dest.m21 = (int)(m[9] * mul);
        dest.m22 = (int)(m[10] * mul);
        dest.m23 = (int)m[11];
    }

    public void render(Graphics3D g3d) {
        if (!this.sleeping) {
            int i;
            if (this.currentEffect != 2 || !MainCanvas.m_GameFrame.currentGame.blink) {
                if (this.getForwardBackward() != -1) {
                    if (this.getVelocity().length() > 0.0f) {
                        if (this.showSmoke) {
                            if (this.driftBoostTimer > 17.0f) {
                                if (this.isPlayer && !this.driftSfx) {
                                    SoundManager.playSfx(10);
                                    this.driftSfx = true;
                                }
                                for (i = 0; i < this.tireLeftoverLeftTrans.length; ++i) {
                                    this.tireLeftoverFrame = rand.nextInt(boostsmoke.length);
                                    Kart.copyMatrix(this.tireLeftoverLeftTrans[i], this.trans);
                                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                    RaceManager.viewTransform.mul(this.trans);
                                    boostsmoke[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                    this.tireLeftoverFrame = rand.nextInt(boostsmoke.length);
                                    Kart.copyMatrix(this.tireLeftoverRightTrans[i], this.trans);
                                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                    RaceManager.viewTransform.mul(this.trans);
                                    boostsmoke[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                    this.tireLeftoverFrame = rand.nextInt(boostsmoke.length);
                                    Kart.copyMatrix(this.tireLeftoverLeftTransBonus[i], this.trans);
                                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                    RaceManager.viewTransform.mul(this.trans);
                                    boostsmoke[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                    this.tireLeftoverFrame = rand.nextInt(boostsmoke.length);
                                }
                            } else {
                                for (i = 0; i < this.tireLeftoverLeftTrans.length; ++i) {
                                    this.tireLeftoverFrame = rand.nextInt(smoke.length);
                                    Kart.copyMatrix(this.tireLeftoverLeftTrans[i], this.trans);
                                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                    RaceManager.viewTransform.mul(this.trans);
                                    smoke[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                    this.tireLeftoverFrame = rand.nextInt(smoke.length);
                                    Kart.copyMatrix(this.tireLeftoverRightTrans[i], this.trans);
                                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                    RaceManager.viewTransform.mul(this.trans);
                                    smoke[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                    this.tireLeftoverFrame = rand.nextInt(smoke.length);
                                    Kart.copyMatrix(this.tireLeftoverLeftTransBonus[i], this.trans);
                                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                    RaceManager.viewTransform.mul(this.trans);
                                    smoke[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                    this.tireLeftoverFrame = rand.nextInt(smoke.length);
                                    Kart.copyMatrix(this.tireLeftoverRightTransBonus[i], this.trans);
                                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                    RaceManager.viewTransform.mul(this.trans);
                                    smoke[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                }
                            }
                        }
                        if (this.showMud) {
                            for (i = 0; i < this.tireLeftoverLeftTrans.length; ++i) {
                                this.tireLeftoverFrame = rand.nextInt(mud.length);
                                Kart.copyMatrix(this.tireLeftoverLeftTrans[i], this.trans);
                                RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                RaceManager.viewTransform.mul(this.trans);
                                mud[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                this.tireLeftoverFrame = rand.nextInt(mud.length);
                                Kart.copyMatrix(this.tireLeftoverRightTrans[i], this.trans);
                                RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                RaceManager.viewTransform.mul(this.trans);
                                mud[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                this.tireLeftoverFrame = rand.nextInt(mud.length);
                                Kart.copyMatrix(this.tireLeftoverLeftTransBonus[i], this.trans);
                                RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                RaceManager.viewTransform.mul(this.trans);
                                mud[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                this.tireLeftoverFrame = rand.nextInt(mud.length);
                                Kart.copyMatrix(this.tireLeftoverRightTransBonus[i], this.trans);
                                RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                RaceManager.viewTransform.mul(this.trans);
                                mud[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                            }
                        }
                        if (this.showDust) {
                            for (i = 0; i < this.tireLeftoverLeftTrans.length; ++i) {
                                this.tireLeftoverFrame = rand.nextInt(dust.length);
                                Kart.copyMatrix(this.tireLeftoverLeftTrans[i], this.trans);
                                RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                RaceManager.viewTransform.mul(this.trans);
                                dust[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                this.tireLeftoverFrame = rand.nextInt(dust.length);
                                Kart.copyMatrix(this.tireLeftoverRightTrans[i], this.trans);
                                RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                RaceManager.viewTransform.mul(this.trans);
                                dust[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                this.tireLeftoverFrame = rand.nextInt(dust.length);
                                Kart.copyMatrix(this.tireLeftoverLeftTransBonus[i], this.trans);
                                RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                RaceManager.viewTransform.mul(this.trans);
                                dust[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                                this.tireLeftoverFrame = rand.nextInt(dust.length);
                                Kart.copyMatrix(this.tireLeftoverRightTransBonus[i], this.trans);
                                RaceManager.viewTransform.set(RaceManager.cameraTransform);
                                RaceManager.viewTransform.mul(this.trans);
                                dust[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                            }
                        }
                    }
                    if (this.getVelocity().length() > 2.0f && this.showGrass) {
                        for (i = 0; i < this.tireLeftoverLeftTrans.length; ++i) {
                            this.tireLeftoverFrame = rand.nextInt(grass.length);
                            Kart.copyMatrix(this.tireLeftoverLeftTrans[i], this.trans);
                            RaceManager.viewTransform.set(RaceManager.cameraTransform);
                            RaceManager.viewTransform.mul(this.trans);
                            grass[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                            this.tireLeftoverFrame = rand.nextInt(grass.length);
                            Kart.copyMatrix(this.tireLeftoverRightTrans[i], this.trans);
                            RaceManager.viewTransform.set(RaceManager.cameraTransform);
                            RaceManager.viewTransform.mul(this.trans);
                            grass[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                            this.tireLeftoverFrame = rand.nextInt(grass.length);
                            Kart.copyMatrix(this.tireLeftoverLeftTransBonus[i], this.trans);
                            RaceManager.viewTransform.set(RaceManager.cameraTransform);
                            RaceManager.viewTransform.mul(this.trans);
                            grass[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                            this.tireLeftoverFrame = rand.nextInt(grass.length);
                            Kart.copyMatrix(this.tireLeftoverRightTransBonus[i], this.trans);
                            RaceManager.viewTransform.set(RaceManager.cameraTransform);
                            RaceManager.viewTransform.mul(this.trans);
                            grass[this.tireLeftoverFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                        }
                    }
                    if (this.isBoosted || this.isInvincible) {
                        Kart.copyMatrix(this.flameTrans, this.trans);
                        RaceManager.viewTransform.set(RaceManager.cameraTransform);
                        RaceManager.viewTransform.mul(this.trans);
                        flame[this.flameFrame].render(g3d, RaceManager.layout, RaceManager.effect);
                        Kart.copyMatrix(this.flameTrans1, this.trans);
                        RaceManager.viewTransform.set(RaceManager.cameraTransform);
                        RaceManager.viewTransform.mul(this.trans);
                        flame1[this.flameFrame1].render(g3d, RaceManager.layout, RaceManager.effect);
                        Kart.copyMatrix(this.flameTrans2, this.trans);
                        RaceManager.viewTransform.set(RaceManager.cameraTransform);
                        RaceManager.viewTransform.mul(this.trans);
                        flame2[this.flameFrame2].render(g3d, RaceManager.layout, RaceManager.effect);
                    }
                    if (this.isTrap) {
                        Kart.copyMatrix(this.drillerTrans[0], this.trans);
                        RaceManager.viewTransform.set(RaceManager.cameraTransform);
                        RaceManager.viewTransform.mul(this.trans);
                        driller.render(g3d, RaceManager.layout, RaceManager.effect);
                    }
                }
                if (this.driver != 4) {
                    Kart.copyMatrix(this.kartTrans, this.kartTransform);
                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                    RaceManager.viewTransform.mul(this.kartTransform);
                    g3d.renderFigure(this.kartFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    if (this.hasAddons) {
                        g3d.renderFigure(this.addFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    }
                    Kart.copyMatrix(this.wheelFLTrans, this.flWheelTransform);
                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                    RaceManager.viewTransform.mul(this.flWheelTransform);
                    g3d.renderFigure(this.fwFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    Kart.copyMatrix(this.wheelFRTrans, this.frWheelTransform);
                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                    RaceManager.viewTransform.mul(this.frWheelTransform);
                    g3d.renderFigure(this.fwFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    Kart.copyMatrix(this.wheelBLTrans, this.blWheelTransform);
                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                    RaceManager.viewTransform.mul(this.blWheelTransform);
                    g3d.renderFigure(this.bwFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    Kart.copyMatrix(this.wheelBRTrans, this.brWheelTransform);
                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                    RaceManager.viewTransform.mul(this.brWheelTransform);
                    g3d.renderFigure(this.bwFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    Kart.copyMatrix(this.driverTrans, this.driverTransform);
                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                    RaceManager.viewTransform.mul(this.driverTransform);
                    if (this.isScarred) {
                        g3d.renderFigure(scaredFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    } else {
                        g3d.renderFigure(this.driverFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    }
                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                } else if (this.isScarred) {
                    Kart.copyMatrix(this.driverTrans, this.driverTransform);
                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                    RaceManager.viewTransform.mul(this.driverTransform);
                    g3d.renderFigure(scaredFigure, 0, 0, RaceManager.layout, this.kartEffect);
                } else {
                    Kart.copyMatrix(this.kartTrans, this.kartTransform);
                    RaceManager.viewTransform.set(RaceManager.cameraTransform);
                    RaceManager.viewTransform.mul(this.kartTransform);
                    g3d.renderFigure(this.kartFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    if (this.hasAddons) {
                        g3d.renderFigure(this.addFigure, 0, 0, RaceManager.layout, this.kartEffect);
                    }
                }
            }
            if (this.isInvincible && (this.invincibilityFrame > 10.0f || MainCanvas.m_GameFrame.currentGame.blink)) {
                for (i = 0; i < 3; ++i) {
                    this.effect[0 + i].render(g3d);
                }
            }
            if (this.isBoosted && (this.boostFrame > 10.0f || MainCanvas.m_GameFrame.currentGame.blink)) {
                for (i = 0; i < 3; ++i) {
                    this.effect[9 + i].render(g3d);
                }
            }
            if (this.isAutopilot && (this.autopilotFrame > 10.0f || MainCanvas.m_GameFrame.currentGame.blink)) {
                for (i = 0; i < 3; ++i) {
                    this.effect[6 + i].render(g3d);
                }
            }
            if (this.isFatality && (this.fatalityFrame > 10.0f || MainCanvas.m_GameFrame.currentGame.blink)) {
                for (i = 0; i < 3; ++i) {
                    this.effect[3 + i].render(g3d);
                }
            }
            if (this.isKatamari) {
                for (i = 0; i < this.itemCounter; ++i) {
                    this.effect[12 + i].render(g3d);
                }
            }
        }
    }

    public void render(Graphics3D g3d, FigureLayout layout, AffineTrans camTrans) {
        this.viewTransform = layout.getAffineTrans();
        Kart.copyMatrix(this.kartTrans, this.kartTransform);
        this.viewTransform.set(camTrans);
        this.viewTransform.mul(this.kartTransform);
        g3d.renderFigure(this.kartFigure, 0, 0, layout, this.kartEffect);
        if (this.hasAddons) {
            g3d.renderFigure(this.addFigure, 0, 0, layout, this.kartEffect);
        }
        if (this.driver == 4) {
            return;
        }
        Kart.copyMatrix(this.wheelFLTrans, this.flWheelTransform);
        this.viewTransform.set(camTrans);
        this.viewTransform.mul(this.flWheelTransform);
        g3d.renderFigure(this.fwFigure, 0, 0, layout, this.kartEffect);
        Kart.copyMatrix(this.wheelFRTrans, this.frWheelTransform);
        this.viewTransform.set(camTrans);
        this.viewTransform.mul(this.frWheelTransform);
        g3d.renderFigure(this.fwFigure, 0, 0, layout, this.kartEffect);
        Kart.copyMatrix(this.wheelBLTrans, this.blWheelTransform);
        this.viewTransform.set(camTrans);
        this.viewTransform.mul(this.blWheelTransform);
        g3d.renderFigure(this.bwFigure, 0, 0, layout, this.kartEffect);
        Kart.copyMatrix(this.wheelBRTrans, this.brWheelTransform);
        this.viewTransform.set(camTrans);
        this.viewTransform.mul(this.brWheelTransform);
        g3d.renderFigure(this.bwFigure, 0, 0, layout, this.kartEffect);
        Kart.copyMatrix(this.driverTrans, this.driverTransform);
        this.viewTransform.set(camTrans);
        this.viewTransform.mul(this.driverTransform);
        g3d.renderFigure(this.driverFigure, 0, 0, layout, this.kartEffect);
    }

    public Vector3D getCameraVector() {
        return this.vCameraVector;
    }

    public void gatherCollectible() {
        ++this.collectibleCounter;
        this.setResistance();
    }

    public void dropCollectible() {
        if (this.collectibleCounter > 0) {
            --this.collectibleCounter;
            ++this.collectiblesToDrop;
        }
        this.setResistance();
    }

    public void setItem(int type, int amount) {
        if (this.currentItem == -1) {
            this.randomFrame = 30.0f;
            this.currentItem = -2;
            this.tempItem = type;
            if (amount == 0) {
                amount = Stats.multipleItemUse[type - 1];
            }
            this.itemCounter = amount;
            if (this.tempItem == 7) {
                this.tempItem = 1;
            } else if (this.tempItem == 8) {
                this.tempItem = 2;
            }
        }
    }

    public void useItem() {
        if (this.itemCounter > 0 && this.currentItem != -2) {
            switch (this.currentItem) {
                case 1: {
                    this.startBoost(50.0f);
                    break;
                }
                case 7: {
                    this.startBoost(50.0f);
                    break;
                }
                case 4: {
                    this.startFatality();
                    break;
                }
                case 5: {
                    this.startInvincibility();
                    break;
                }
                case 6: {
                    this.startAutopilot();
                    break;
                }
                case 2: {
                    if (!this.isKatamari) {
                        this.startKatamari();
                        ++this.itemCounter;
                        break;
                    }
                    this.droppedItem = 2;
                    this.startTrapSet(false);
                    break;
                }
                case 8: {
                    this.droppedItem = 2;
                    this.startTrapSet(false);
                    break;
                }
                case 3: {
                    if (!this.isTrap) {
                        this.startTrap();
                        ++this.itemCounter;
                        break;
                    }
                    this.droppedItem = 3;
                    this.startTrapSet(true);
                    break;
                }
                default: {
                    if (this.droppedItem != -1) break;
                    this.droppedItem = this.currentItem;
                }
            }
            --this.itemCounter;
            if (this.itemCounter == 0) {
                this.currentItem = -1;
            }
        }
    }

    public int getItem() {
        return this.currentItem;
    }

    public int getItemCount() {
        return this.itemCounter;
    }

    public boolean getKatamari() {
        return this.isKatamari;
    }

    public int getCollectibleCount() {
        return this.collectibleCounter;
    }

    public int getDroppedItem() {
        if (this.collectiblesToDrop > 0) {
            --this.collectiblesToDrop;
            return 0;
        }
        int t = this.droppedItem;
        this.droppedItem = -1;
        return t;
    }

    public void startEffect(int ef, int timeout) {
        if (this.currentEffect == -1 || this.currentEffect == 4 || ef == 3) {
            this.currentEffect = ef;
            this.currentEffectTimeout = Math.max(10.0f, (float)timeout);
            switch (ef) {
                case 1: {
                    this.canMove = false;
                    this.stopKart(0);
                    break;
                }
                case 0: {
                    float v = -(Stats.GRAVITY_ACCELERATION * Stats.GRAVITY_ACCELERATION * (float)(timeout / 2) * (float)(timeout / 2)) / (float)(1 - timeout / 2) / (float)Track.mScale;
                    this.initiateJump(v * 2.0f);
                    this.maxCurrentJumpHeight = this.calculateMaxHeight(v);
                    this.canMove = false;
                    this.stopKart(0);
                    break;
                }
                case 3: {
                    System.out.println("drop?");
                    float s = Stats.GRAVITY_ACCELERATION * Stats.GRAVITY_ACCELERATION * (float)timeout * (float)timeout / (float)(8 * Track.mScale) + this.getGroundLevel();
                    float v = -(Stats.GRAVITY_ACCELERATION * Stats.GRAVITY_ACCELERATION * (float)(timeout / 6) * (float)(timeout / 6)) / (float)(1 - timeout / 6) / (float)Track.mScale;
                    this.initiateJump(v);
                    this.setPosition(new Vector3D(this.getPosition().getx(), s, this.getPosition().getz()));
                    this.canMove = false;
                    this.stopKart(0);
                    break;
                }
            }
        }
        if (this.isVibrating || ef == 4) {
            // empty if block
        }
        this.vibrateEffectTimeout = timeout;
        if (this.isPlayer) {
            SoundManager.vibration(timeout * 5);
        }
    }

    public static void resetIndexes() {
        PhysicalEntity.resetIndexes();
    }

    public void startSlowdown(float last, boolean dust) {
        this.boostMultiplier = 0.85f;
        if (!this.isSlowed && this.isPlayer) {
            SoundManager.playSfx(9);
        }
        this.isSlowed = true;
        this.slowedFrame = last;
        if (!this.showMud && !this.showDust) {
            for (int i = 0; i < this.tireLeftoverLeftTrans.length; ++i) {
                this.tireLeftoverLeftTrans[i].setIdentity();
                this.tireLeftoverRightTrans[i].setIdentity();
            }
        }
        this.setSlowed(true);
        this.endBoost();
        if (dust) {
            this.showDust = true;
        } else {
            this.showMud = true;
        }
        this.showSmoke = false;
    }

    public void startBoost(float last) {
        if (this.isDirection == -1) {
            return;
        }
        this.endSlowed();
        this.acceleratePush();
        this.boostMultiplier = 1.4f;
        this.isBoosted = true;
        this.boostFrame = last;
        if (this.isPlayer) {
            SoundManager.playSfx(6);
        }
        this.setBoosted(true);
        this.showMud = false;
        this.showDust = false;
    }

    private void startKatamari() {
        this.isKatamari = true;
        this.katamariFrame = 90.0f;
    }

    private void endKatamari() {
        this.isKatamari = false;
    }

    private void startTrap() {
        this.isTrap = true;
    }

    private void endTrap() {
        this.isTrap = false;
    }

    public void endBoost() {
        this.boostMultiplier = 1.0f;
        this.isBoosted = false;
        this.setBoosted(false);
    }

    public void endSlowed() {
        this.boostMultiplier = 1.0f;
        this.isSlowed = false;
        this.showMud = false;
        this.showDust = false;
        this.setSlowed(false);
    }

    private void startAutopilot() {
        this.isAutopilot = true;
        this.autopilotFrame = 120.0f;
        this.autopilotMultiplier = 2.0f;
        if (this.isPlayer) {
            SoundManager.playSfx(11);
        }
    }

    private void endAutopilot() {
        this.isAutopilot = false;
        this.autopilotMultiplier = 1.0f;
        this.turnRelease();
        this.accelerateRelease();
        this.brakeRelease();
    }

    private void startFatality() {
        if (!this.isFatality) {
            this.activateFatality = true;
            this.isFatality = true;
            this.fatalityFrame = GameLogic.gameMode != 3 ? 120.0f : 180.0f;
            if (this.isPlayer) {
                SoundManager.playSfx(0);
            } else {
                SoundManager.playSfx(16);
            }
        }
    }

    private void endFatality() {
        this.isFatality = false;
        this.isScarred = false;
    }

    private void startTrapSet(boolean trap) {
        this.isTrapDeployed = trap;
        this.isTrapSet = true;
        this.isTrapSetFrame = 4.0f;
    }

    private void endTrapSet() {
        this.isTrapSet = false;
    }

    protected void initiateJump() {
        if (this.getAltitudeVelocity().length() <= 0.2f * (float)Track.mScale && this.isDirection == 1) {
            float jump = this.jumpSpeed * ((this.getEngineVelocity().length() / this.getCurrentMaxSpeed() + 1.0f) * 1.6f) / 2.0f;
            this.initiateJump(jump);
            this.canMove = !(this.getEngineVelocity().length() > 0.0f);
        }
    }

    private void startInvincibility() {
        this.setBoosted(true);
        this.isInvincible = true;
        this.invincibilityFrame = 120.0f;
        this.invincibilityBoost = 1.2f;
    }

    private void endInvincibility() {
        this.setBoosted(false);
        this.isInvincible = false;
        this.invincibilityBoost = 1.0f;
    }

    public void setTrackSection(int section) {
        if (this.currentTrackSection == 2 && section == 1) {
            this.acceleratePush();
        }
        if (section >= 0 && section <= 2) {
            this.currentTrackSection = section;
        }
    }

    public int getTrackSection() {
        return this.currentTrackSection;
    }

    public void setFatality(boolean fatality) {
        this.isFatality = fatality;
    }

    public boolean getFatality() {
        return this.isFatality;
    }

    public void setScarred(boolean scarred) {
        this.isScarred = scarred;
    }

    public boolean getScarred() {
        return this.isScarred;
    }

    public boolean getInvincibility() {
        return this.isInvincible;
    }

    public boolean getAutopilot() {
        return this.isAutopilot;
    }

    private void setEffectSkid(float frame) {
        float y = this.vEffectRotation.gety();
        y = (float)mMath.sin(this.currentFrame) * 15.0f * (Math.min(this.currentEffectTimeout, 30.0f) / 30.0f);
        this.vEffectRotation.sety(y);
        this.currentEffectTimeout -= frame;
        if (this.currentEffectTimeout <= 0.0f) {
            this.currentEffect = -1;
            this.vEffectRotation.set(0.0f, 0.0f, 0.0f);
            this.canMove = true;
        }
    }

    private void setEffectJump(float frame) {
        float angvel = Math.max(15.0f, Math.min(45.0f, this.maxCurrentJumpHeight * 4.0f));
        if (this.getPosition().gety() <= this.calculateMaxHeight(this.maxCurrentJumpHeight) + this.getHeight() / 2.0f - this.getGroundLevel() && this.getAltitudeVelocity().gety() < 0.0f && this.getPosition().gety() - this.getHeight() / 2.0f > this.getGroundLevel()) {
            float enddist = this.getPosition().gety() - this.getGroundLevel();
            float dist = Vector3D.scalarMul(frame, Vector3D.add(this.getAltitudeVelocity(), new Vector3D(0.0f, -Stats.GRAVITY_ACCELERATION * frame, 0.0f))).length();
            float ratio = enddist != 0.0f ? Math.min(1.0f, dist / enddist) : 1.0f;
            float x = this.vEffectRotation.getx();
            if (x > 180.0f && !this.angleDone) {
                x += (360.0f + x) * ratio;
            } else {
                x += (360.0f - x) * ratio;
                this.angleDone = true;
            }
            this.vEffectRotation.setx(x %= 360.0f);
        } else if (this.getPosition().gety() - this.getHeight() / 2.0f > this.getGroundLevel()) {
            float x = this.vEffectRotation.getx();
            x += angvel * frame;
            this.vEffectRotation.setx(x %= 360.0f);
        }
        this.currentEffectTimeout -= frame;
        if (this.currentEffectTimeout <= 0.0f) {
            this.currentEffect = -1;
            this.vEffectRotation.set(0.0f, 0.0f, 0.0f);
            this.maxCurrentJumpHeight = 0.0f;
            this.angleDone = false;
            this.canMove = true;
        }
    }

    private void setEffectBlink(float frame) {
        this.currentEffectTimeout -= frame;
        if (this.currentEffectTimeout <= 0.0f) {
            this.currentEffect = -1;
        }
    }

    private void setEffectDrop(float frame) {
        float y = this.vEffectRotation.gety();
        y = this.currentEffectTimeout > 5.0f ? (y += 40.0f * frame % 360.0f) : (y += (360.0f - y) * frame);
        this.vEffectRotation.sety(y);
        this.currentEffectTimeout -= frame;
        if (this.currentEffectTimeout <= 0.0f) {
            this.currentEffect = -1;
            this.vEffectRotation.set(0.0f, 0.0f, 0.0f);
            this.canMove = true;
            this.stopKart(0);
        }
    }

    private void setEffectStars(float frame) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.vEffectPos[0 + i].set(this.getPosition().getx() + (float)mMath.sin(frame / 2.0f + (float)(i * 2)) * 12.0f * (float)Track.mScale, this.getGroundLevel() + 7.0f, this.getPosition().getz() + (float)mMath.cos(frame / 2.0f + (float)(i * 2)) * 12.0f * (float)Track.mScale);
            }
            catch (Exception e) {
                System.out.println("1" + e);
            }
            this.effect[0 + i].setPosition(this.vEffectPos[0 + i]);
            this.effect[0 + i].update();
        }
    }

    private void setEffectEatenGhosts(float frame) {
        for (int i = 0; i < 3; ++i) {
            try {
                float effDist = 12.0f * (1.0f - frame / 30.0f);
                this.vEffectPos[3 + i].set(this.getPosition().getx() + (float)mMath.sin(frame / 2.0f + (float)(i * 2)) * effDist * (float)Track.mScale, this.getGroundLevel() + frame * 3.0f * (float)Track.mScale, this.getPosition().getz() + (float)mMath.cos(frame / 3.0f + (float)(i * 2)) * effDist * (float)Track.mScale);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.effect[3 + i].setPosition(this.vEffectPos[3 + i]);
            this.effect[3 + i].update();
        }
    }

    private void setEffectGhosts(float frame) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.offset = GameLogic.gameMode == 3 ? 180 : 120;
                this.modframe = this.isScarred ? frame - (float)(this.offset * 3 / 4) : (float)this.offset - frame;
                if (this.modframe < 0.0f) {
                    this.modframe = 0.0f;
                }
                float effDist = 12.0f * (1.0f + 2.0f * this.modframe / (float)this.offset);
                this.vEffectPos[3 + i].set(this.getPosition().getx() + (float)mMath.sin(frame / 5.0f + (float)(i * 2)) * effDist * (float)Track.mScale, this.getPosition().gety() + this.modframe * (float)Track.mScale, this.getPosition().getz() + (float)mMath.cos(frame / 7.0f + (float)(i * 2)) * effDist * (float)Track.mScale);
            }
            catch (Exception e) {
                System.out.println("2" + e);
            }
            this.effect[3 + i].setPosition(this.vEffectPos[3 + i]);
            this.effect[3 + i].update();
        }
    }

    private void setEffectBoost(float frame) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.vEffectPos[9 + i].set(this.getPosition().getx() + (float)mMath.sin(frame / 5.0f + (float)(i * 2)) * 12.0f * (float)Track.mScale, this.getGroundLevel() + 7.0f, this.getPosition().getz() + (float)mMath.cos(frame / 5.0f + (float)(i * 2)) * 12.0f * (float)Track.mScale);
            }
            catch (Exception e) {
                System.out.println("3" + e);
            }
            this.effect[9 + i].setPosition(this.vEffectPos[9 + i]);
            this.effect[9 + i].update();
        }
    }

    private void setEffectSlowed(float frame) {
    }

    private void setEffectAutopilot(float frame) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.vEffectPos[6 + i].set(this.getPosition().getx() + (float)mMath.sin(frame / 6.0f + (float)(i * 2)) * 12.0f * (float)Track.mScale, this.getPosition().gety(), this.getPosition().getz() + (float)mMath.cos(frame / 6.0f + (float)(i * 2)) * 12.0f * (float)Track.mScale);
            }
            catch (Exception e) {
                System.out.println("4" + e);
            }
            this.effect[6 + i].setPosition(this.vEffectPos[6 + i]);
            this.effect[6 + i].update();
        }
    }

    private void setEffectVibrate(float frame) {
        this.vibrateEffectTimeout -= frame;
        if (this.vibrateEffectTimeout <= 0.0f) {
            this.isVibrating = false;
        }
    }

    private void setEffectKatamari(float frame) {
        for (int i = 0; i < 3; ++i) {
            try {
                this.vEffectPos[12 + i].set(this.getPosition().getx() + (float)mMath.sin(frame / 4.0f + (float)(i * 2)) * 12.0f * (float)Track.mScale, this.getGroundLevel() + 7.0f, this.getPosition().getz() + (float)mMath.cos(frame / 4.0f + (float)(i * 2)) * 12.0f * (float)Track.mScale);
            }
            catch (Exception e) {
                System.out.println("5" + e);
            }
            this.effect[12 + i].setPosition(this.vEffectPos[12 + i]);
            this.effect[12 + i].update();
        }
    }

    public float getTeleportCounter() {
        return this.teleportCounter;
    }

    private void setTeleportCounter(float frame) {
        this.teleportCounter = this.currentTrackSection != 0 && this.getVelocity().length() <= 0.5f ? (this.teleportCounter += frame) : 0.0f;
    }

    static {
        sun = new Vector3D();
        intro = false;
        smoke = new Sprite3D[4];
        boostsmoke = new Sprite3D[4];
        mud = new Sprite3D[4];
        grass = new Sprite3D[4];
        dust = new Sprite3D[4];
        flame = new Sprite3D[4];
        flame1 = new Sprite3D[4];
        flame2 = new Sprite3D[4];
        drillerScale = 6.0f;
        rand = new Random(System.currentTimeMillis());
        kartAmount = 0;
        intitated = false;
        m = new float[16];
    }
}

