/*
 * Decompiled with CFR 0.152.
 */
package spl.gamestore.hiscores;

import java.io.DataInputStream;
import java.io.IOException;
import spl.gamestore.common.GameStore;
import spl.gamestore.common.Module;
import spl.gamestore.common.Params;
import spl.gamestore.common.Resources;
import spl.gamestore.hiscores.HttpConnThread;

public class HiScoresModule
extends Module
implements Runnable,
Params,
Resources {
    private String serverLink;
    private String currentLink;
    private String userName;
    private int scores;
    private int recordsCount;
    private int from;
    private boolean enabled;
    private static int basement = 51;
    public boolean connectionInProgress = false;
    private String appName = null;
    public int uploadStatus = 5;
    public long lastTime;
    public long elapsedTime = 0L;
    static final int TIME_OUT_MS = 45000;
    public HttpConnThread httpThread;
    public static boolean connectionOpened;
    public static final byte STATE_SEND_SCORES = 0;
    public static final byte STATE_REQUEST_NEAREST = 1;
    public static final byte STATE_REQUEST_PORTION = 2;

    public HiScoresModule() {
        String appNameJadKey;
        String serverLinkJadKey = (String)GameStore.getResource(51, true);
        if (serverLinkJadKey != null) {
            this.serverLink = GameStore.instance.parent.getJadAttribute(serverLinkJadKey);
        }
        if (this.serverLink != null && this.serverLink.trim().length() == 0) {
            this.serverLink = null;
        }
        if (this.serverLink != null) {
            String host;
            if (this.serverLink.indexOf("http://") == -1) {
                this.serverLink = "http://" + this.serverLink;
            }
            if ((host = this.serverLink.substring(7, this.serverLink.length())).indexOf("/") == -1) {
                this.serverLink = this.serverLink + "/";
            } else if (host.indexOf("/") != host.length() - 1 && host.charAt(host.length() - 1) == '/') {
                this.serverLink = this.serverLink.substring(0, this.serverLink.length() - 1);
            }
        }
        if ((appNameJadKey = (String)GameStore.getResource(40, true)) != null) {
            this.appName = GameStore.instance.parent.getJadAttribute(appNameJadKey);
        }
        if ("".equals(this.appName)) {
            this.appName = null;
        }
        this.enabled = this.appName != null && this.serverLink != null;
        this.httpThread = new HttpConnThread();
    }

    public boolean initActive(Object[] params) {
        GameStore.lang = GameStore.instance.parent.getLanguage();
        int requestType = (Integer)params[0];
        this.userName = (String)params[1];
        this.scores = (Integer)params[2];
        this.recordsCount = (Integer)params[3];
        if (params.length > 4) {
            this.from = (Integer)params[4];
        }
        switch (requestType) {
            case 0: {
                this.setState((byte)0);
                break;
            }
            case 1: {
                this.setState((byte)1);
                break;
            }
            case 2: {
                this.setState((byte)2);
                break;
            }
            case 3: {
                String link = GameStore.instance.getFromJad(GameStore.getResource(50, true));
                try {
                    if (link == null) break;
                    GameStore.instance.goToUrl(link);
                    break;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    public void initState(byte state) {
        if (this.serverLink == null) {
            return;
        }
        this.uploadStatus = 0;
        this.userName = this.userName.trim();
        if (this.userName != null) {
            int index = this.userName.indexOf(32);
            while (index != -1) {
                String first = this.userName.substring(0, index) + "%20";
                String second = "";
                if (index < this.userName.length() - 1) {
                    second = this.userName.substring(index + 1, this.userName.length());
                }
                this.userName = first + second;
                index = this.userName.indexOf(32);
            }
        }
        if (this.appName != null) {
            while (this.appName.indexOf(32) != -1) {
                this.appName = this.appName.replace(' ', '_');
            }
        }
        switch (state) {
            case 0: {
                this.sendScores(this.serverLink, this.appName, this.userName, this.scores, this.recordsCount);
                break;
            }
            case 1: {
                this.requestNearest(this.serverLink, this.appName, this.userName, this.scores, this.recordsCount);
                break;
            }
            case 2: {
                this.requestPortion(this.serverLink, this.appName, this.userName, this.scores, this.recordsCount, this.from);
            }
        }
    }

    private void connectToServer(String link) {
        this.currentLink = link;
        if (this.connectionInProgress) {
            return;
        }
        this.uploadStatus = 0;
        this.connectionInProgress = true;
        connectionOpened = false;
        new Thread(this).start();
    }

    public void requestNearest(String serverLink, String appName, String username, int scores, int recordsCount) {
        String encodedScores = this.encodeScores(scores, basement);
        String serverLinkRead = serverLink + "?" + "add=false&ap=" + appName + "&n=" + username + "&s=" + encodedScores + "&fl=" + recordsCount;
        this.connectToServer(serverLinkRead);
    }

    public void sendScores(String serverLink, String appName, String username, int scores, int recordsCount) {
        String encodedScores = this.encodeScores(scores, basement);
        String serverLinkRead = serverLink + "?" + "add=true&ap=" + appName + "&n=" + username + "&s=" + encodedScores + "&fl=" + recordsCount;
        this.connectToServer(serverLinkRead);
    }

    public void requestPortion(String serverLink, String appName, String username, int scores, int recordsCount, int from) {
        String serverLinkRead = serverLink + "?" + "ap=" + appName + "&fl=" + recordsCount + "&ff=" + from;
        this.connectToServer(serverLinkRead);
    }

    public String encodeScores(int scores, int basement) {
        long coded;
        long copy = coded = (long)((scores + 1) * 7 + 61);
        int degree = 0;
        while (copy > 0L) {
            copy /= (long)basement;
            ++degree;
        }
        int[] result = new int[--degree + 1];
        boolean j = false;
        while (degree >= 0) {
            int i1;
            long c = 1L;
            for (int i = 0; i < degree; ++i) {
                c *= (long)basement;
            }
            result[degree] = i1 = (int)(coded / c);
            coded -= c * (long)i1;
            --degree;
        }
        String strResult = "";
        for (int i = 0; i < result.length; ++i) {
            if (result[i] > 25) {
                result[i] = result[i] + 6;
            }
            strResult = strResult + (char)(result[i] + 65);
        }
        return strResult;
    }

    public static int readInt(DataInputStream dis) throws IOException {
        byte[] buffer = new byte[1];
        byte[] data = new byte[4];
        for (int i = 0; i < 4; ++i) {
            dis.read(buffer, 0, 1);
            data[i] = buffer[0];
        }
        int result = (data[0] & 0xFF) << 24;
        result += (data[1] & 0xFF) << 16;
        result += (data[2] & 0xFF) << 8;
        return result += data[3] & 0xFF;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void destroy() {
    }

    public int getOperationResult() {
        return this.uploadStatus;
    }

    public void run() {
        try {
            this.httpThread.closeOldConnectionAndInputStream();
            this.httpThread.setTargetURL(this.currentLink);
            this.httpThread.result = null;
            this.lastTime = System.currentTimeMillis();
            new Thread(this.httpThread).start();
            while (this.httpThread.result == null && !this.httpThread.thrownDuringConnect) {
                if (System.currentTimeMillis() > this.lastTime) {
                    this.elapsedTime += System.currentTimeMillis() - this.lastTime;
                }
                if (this.elapsedTime > 45000L) {
                    this.uploadStatus = 4;
                    return;
                }
                this.lastTime = System.currentTimeMillis();
                Thread.sleep(2000L);
            }
            this.uploadStatus = this.httpThread.thrownDuringConnect ? this.httpThread.uploadStatus : 1;
            this.connectionInProgress = false;
        }
        catch (Exception x1) {
            this.uploadStatus = x1 instanceof SecurityException ? 3 : 2;
        }
        if (!this.connectionInProgress) {
            try {
                this.httpThread.closeOldConnectionAndInputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getString(int index) {
        String message = null;
        switch (index) {
            case 1: {
                message = this.httpThread.result;
                break;
            }
            case 3: {
                message = (String)GameStore.getResource(17, false);
                if (message != null) break;
                message = (String)GameStore.getResource(17, true);
                break;
            }
            case 2: {
                message = (String)GameStore.getResource(14, false);
                if (message != null) break;
                message = (String)GameStore.getResource(14, true);
                break;
            }
            case 4: {
                message = (String)GameStore.getResource(10, false);
                if (message != null) break;
                message = (String)GameStore.getResource(10, true);
            }
        }
        return message;
    }
}

