/*
 * Decompiled with CFR 0.152.
 */
public class TrackShortcut {
    private Track mTrack;
    public int numBasePoints;
    public int numInterpolationSteps;
    public float roadSideWidth;
    private float roadSideWallHeight;
    public int startPoint;
    public int endPoint;
    public int numIPoints;
    public int[] startPoints = new int[4];
    public int[] endPoints = new int[4];
    public int startSide;
    public int endSide;
    public Vector3D[] iPoints;
    public float[] iPointsWidth;
    public float[] iPointsAngle;
    public short[] roadVertices;
    public short[] leftSideVertices;
    public short[] rightSideVertices;
    public short[] leftWallVertices;
    public short[] rightWallVertices;
    public float[] xPoints;
    public float[] yPoints;
    public float[] zPoints;
    public float[] wPoints;
    public float[] aPoints;
    public int[][] mscRoadVertices;
    public int[][] mscRoadCoordinates;
    public int[][] mscLeftSideVertices;
    public int[][] mscLeftSideCoordinates;
    public int[][] mscRightSideVertices;
    public int[][] mscRightSideCoordinates;
    public int[][] mscLeftWallVertices;
    public int[][] mscLeftWallCoordinates;
    public int[][] mscRightWallVertices;
    public int[][] mscRightWallCoordinates;
    public int[] mainRoadTextureNr;
    public int[] leftSideTextureNr;
    public int[] rightSideTextureNr;
    public int[] leftWallTextureNr;
    public int[] rightWallTextureNr;
    Vector3D v1 = new Vector3D();
    Vector3D v2 = new Vector3D();
    Vector3D v3 = new Vector3D();
    Vector3D v4 = new Vector3D();
    Vector3D vb1;
    Vector3D vb2;
    Vector3D vb3;
    Vector3D vb4;
    Vector3D vcd1;
    Vector3D vcd2;
    Vector3D vrd1;
    Vector3D vrd2;

    public TrackShortcut(Track track, int sp, int ep, int n, int steps, int rw) {
        this.mTrack = track;
        this.startPoint = sp;
        this.endPoint = ep;
        this.numBasePoints = n;
        this.numInterpolationSteps = steps;
        this.roadSideWidth = rw;
        this.roadSideWallHeight = 100.0f;
        this.xPoints = new float[n];
        this.yPoints = new float[n];
        this.zPoints = new float[n];
        this.wPoints = new float[n];
        this.aPoints = new float[n];
    }

    public void createGeometry() {
        Spline[] xSpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.xPoints);
        Spline[] ySpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.yPoints);
        Spline[] zSpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.zPoints);
        Spline[] wSpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.wPoints);
        Spline[] aSpline = Spline.calculateNaturalCubic(this.numBasePoints - 1, this.aPoints);
        int size = this.numInterpolationSteps * (this.numBasePoints - 1) + 1;
        this.iPoints = new Vector3D[size];
        this.iPointsWidth = new float[size];
        this.iPointsAngle = new float[size];
        int iPointNr = 0;
        this.iPoints[iPointNr] = new Vector3D(xSpline[0].eval(0.0f), zSpline[0].eval(0.0f), ySpline[0].eval(0.0f));
        this.iPointsWidth[iPointNr] = wSpline[0].eval(0.0f);
        this.iPointsAngle[iPointNr] = aSpline[0].eval(0.0f);
        ++iPointNr;
        for (int i = 0; i < this.numBasePoints - 1; ++i) {
            for (int j = 1; j <= this.numInterpolationSteps; ++j) {
                float u = (float)j / (float)this.numInterpolationSteps;
                this.iPoints[iPointNr] = new Vector3D(xSpline[i].eval(u), zSpline[i].eval(u), ySpline[i].eval(u));
                this.iPointsWidth[iPointNr] = wSpline[i].eval(u);
                this.iPointsAngle[iPointNr] = aSpline[i].eval(u);
                ++iPointNr;
            }
        }
        this.roadVertices = new short[this.iPoints.length * 2 * 3];
        this.leftSideVertices = new short[this.iPoints.length * 2 * 3];
        this.rightSideVertices = new short[this.iPoints.length * 2 * 3];
        this.leftWallVertices = new short[this.iPoints.length * 2 * 3];
        this.rightWallVertices = new short[this.iPoints.length * 2 * 3];
        int vCount = 0;
        for (int i = 0; i < this.iPoints.length; ++i) {
            Vector3D vTmp = i < this.iPoints.length - 1 ? Vector3D.sub(this.iPoints[i + 1], this.iPoints[i]) : Vector3D.sub(this.iPoints[i], this.iPoints[i - 1]);
            vTmp.normalize();
            Vector3D vUp = new Vector3D(0.0f, 1.0f, 0.0f);
            float angle = (float)((double)this.iPointsAngle[i] * Math.PI / 180.0);
            if (angle != 0.0f) {
                float nx = (float)((double)vUp.getx() * mMath.cos(angle) - (double)vUp.gety() * mMath.sin(angle));
                float ny = (float)((double)vUp.getx() * mMath.sin(angle) + (double)vUp.gety() * mMath.cos(angle));
                float nz = vUp.getz();
                vUp.set(nx, ny, nz);
            }
            Vector3D vC = Vector3D.crossProduct(vTmp, vUp);
            Vector3D vD = new Vector3D(vC);
            vC.scalarMul(this.iPointsWidth[i]);
            vD.scalarMul(this.iPointsWidth[i] + this.roadSideWidth * (float)Track.mScale);
            Vector3D v1 = Vector3D.sub(this.iPoints[i], vC);
            Vector3D v2 = Vector3D.add(this.iPoints[i], vC);
            Vector3D v3 = Vector3D.sub(this.iPoints[i], vD);
            Vector3D v4 = Vector3D.add(this.iPoints[i], vD);
            this.roadVertices[vCount + 0] = (short)v1.getx();
            this.roadVertices[vCount + 1] = (short)v1.gety();
            this.roadVertices[vCount + 2] = (short)v1.getz();
            this.leftSideVertices[vCount + 0] = (short)v3.getx();
            this.leftSideVertices[vCount + 1] = (short)v3.gety();
            this.leftSideVertices[vCount + 2] = (short)v3.getz();
            this.rightSideVertices[vCount + 0] = (short)v2.getx();
            this.rightSideVertices[vCount + 1] = (short)v2.gety();
            this.rightSideVertices[vCount + 2] = (short)v2.getz();
            this.leftWallVertices[vCount + 0] = (short)v3.getx();
            this.leftWallVertices[vCount + 1] = (short)(v3.gety() + this.roadSideWallHeight * (float)Track.mScale);
            this.leftWallVertices[vCount + 2] = (short)v3.getz();
            this.rightWallVertices[vCount + 0] = (short)v4.getx();
            this.rightWallVertices[vCount + 1] = (short)(v4.gety() + this.roadSideWallHeight * (float)Track.mScale);
            this.rightWallVertices[vCount + 2] = (short)v4.getz();
            this.roadVertices[(vCount += 3) + 0] = (short)v2.getx();
            this.roadVertices[vCount + 1] = (short)v2.gety();
            this.roadVertices[vCount + 2] = (short)v2.getz();
            this.leftSideVertices[vCount + 0] = (short)v1.getx();
            this.leftSideVertices[vCount + 1] = (short)v1.gety();
            this.leftSideVertices[vCount + 2] = (short)v1.getz();
            this.rightSideVertices[vCount + 0] = (short)v4.getx();
            this.rightSideVertices[vCount + 1] = (short)v4.gety();
            this.rightSideVertices[vCount + 2] = (short)v4.getz();
            this.leftWallVertices[vCount + 0] = (short)v3.getx();
            this.leftWallVertices[vCount + 1] = (short)v3.gety();
            this.leftWallVertices[vCount + 2] = (short)v3.getz();
            this.rightWallVertices[vCount + 0] = (short)v4.getx();
            this.rightWallVertices[vCount + 1] = (short)v4.gety();
            this.rightWallVertices[vCount + 2] = (short)v4.getz();
            vCount += 3;
        }
    }

    public void createMeshes() {
        int m;
        int m2;
        int inr;
        int j;
        int j2;
        int k;
        int i;
        int mqpr = 3;
        int mqpc = 3;
        int sqpr = 2;
        int sqpc = 2;
        int wqpr = 2;
        int wqpc = 2;
        this.mscRoadVertices = new int[this.numBasePoints - 1][this.numInterpolationSteps * mqpc * mqpr * 4 * 3];
        this.mscRoadCoordinates = new int[this.numBasePoints - 1][this.numInterpolationSteps * mqpc * mqpr * 4 * 2];
        this.mscLeftSideVertices = new int[this.numBasePoints - 1][this.numInterpolationSteps * sqpc * sqpr * 4 * 3];
        this.mscLeftSideCoordinates = new int[this.numBasePoints - 1][this.numInterpolationSteps * sqpc * sqpr * 4 * 2];
        this.mscRightSideVertices = new int[this.numBasePoints - 1][this.numInterpolationSteps * sqpc * sqpr * 4 * 3];
        this.mscRightSideCoordinates = new int[this.numBasePoints - 1][this.numInterpolationSteps * sqpc * sqpr * 4 * 2];
        this.mscLeftWallVertices = new int[this.numBasePoints - 1][this.numInterpolationSteps * wqpc * wqpr * 4 * 3];
        this.mscLeftWallCoordinates = new int[this.numBasePoints - 1][this.numInterpolationSteps * wqpc * wqpr * 4 * 2];
        this.mscRightWallVertices = new int[this.numBasePoints - 1][this.numInterpolationSteps * wqpc * wqpr * 4 * 3];
        this.mscRightWallCoordinates = new int[this.numBasePoints - 1][this.numInterpolationSteps * wqpc * wqpr * 4 * 2];
        int vIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                for (j2 = 0; j2 < 12; ++j2) {
                    if (vIndex + j2 > this.roadVertices.length - 1) {
                        vIndex = -j2;
                    }
                    this.mscRoadVertices[i][k * mqpc * mqpr * 12 + j2] = this.roadVertices[vIndex + j2];
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscRoadVertices, i, k, mqpc, mqpr);
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                inr = i * this.numInterpolationSteps + j;
                for (m2 = 0; m2 < 8; ++m2) {
                    this.mscRoadCoordinates[i][j * mqpc * mqpr * 8 + m2] = (short)Track.TXT_TILES_COORDINATES[this.mainRoadTextureNr[inr]][m2];
                }
                this.splitMainQuadCoordinates(this.mscRoadCoordinates, i, j, mqpc, mqpr);
            }
        }
        vIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                for (j2 = 0; j2 < 12; ++j2) {
                    if (vIndex + j2 > this.leftSideVertices.length - 1) {
                        vIndex = -j2;
                    }
                    this.mscLeftSideVertices[i][k * sqpc * sqpr * 12 + j2] = this.leftSideVertices[vIndex + j2];
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscLeftSideVertices, i, k, sqpc, sqpr);
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                inr = i * this.numInterpolationSteps + j;
                for (m2 = 0; m2 < 8; ++m2) {
                    this.mscLeftSideCoordinates[i][j * sqpc * sqpr * 8 + m2] = (short)Track.TXT_TILES_COORDINATES[this.leftSideTextureNr[inr]][m2];
                }
                this.splitMainQuadCoordinates(this.mscLeftSideCoordinates, i, j, sqpc, sqpr);
            }
        }
        vIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                for (j2 = 0; j2 < 12; ++j2) {
                    if (vIndex + j2 > this.rightSideVertices.length - 1) {
                        vIndex = -j2;
                    }
                    this.mscRightSideVertices[i][k * sqpc * sqpr * 12 + j2] = this.rightSideVertices[vIndex + j2];
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscRightSideVertices, i, k, sqpc, sqpr);
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                inr = i * this.numInterpolationSteps + j;
                for (m2 = 0; m2 < 8; ++m2) {
                    this.mscRightSideCoordinates[i][j * sqpc * sqpr * 8 + m2] = (short)Track.TXT_TILES_COORDINATES[this.rightSideTextureNr[inr]][m2];
                }
                this.splitMainQuadCoordinates(this.mscRightSideCoordinates, i, j, sqpc, sqpr);
            }
        }
        vIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                for (j2 = 0; j2 < 12; ++j2) {
                    if (vIndex + j2 > this.leftWallVertices.length - 1) {
                        vIndex = -j2;
                    }
                    this.mscLeftWallVertices[i][k * wqpc * wqpr * 12 + j2] = this.leftWallVertices[vIndex + j2];
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscLeftWallVertices, i, k, wqpc, wqpr);
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                for (m = 0; m < 8; ++m) {
                    this.mscLeftWallCoordinates[i][j * wqpc * wqpr * 8 + m] = (short)Track.TXT_TILES_COORDINATES[7][m];
                }
                this.splitMainQuadCoordinates(this.mscLeftWallCoordinates, i, j, wqpc, wqpr);
            }
        }
        vIndex = 0;
        for (i = 0; i < this.numBasePoints - 1; ++i) {
            for (k = 0; k < this.numInterpolationSteps; ++k) {
                for (j2 = 0; j2 < 12; ++j2) {
                    if (vIndex + j2 > this.rightWallVertices.length - 1) {
                        vIndex = -j2;
                    }
                    this.mscRightWallVertices[i][k * wqpc * wqpr * 12 + j2] = this.rightWallVertices[vIndex + j2];
                }
                vIndex += 6;
                this.splitMainQuadVertices(this.mscRightWallVertices, i, k, wqpc, wqpr);
            }
            for (j = 0; j < this.numInterpolationSteps; ++j) {
                for (m = 0; m < 8; ++m) {
                    this.mscRightWallCoordinates[i][j * wqpc * wqpr * 8 + m] = (short)Track.TXT_TILES_COORDINATES[7][m];
                }
                this.splitMainQuadCoordinates(this.mscRightWallCoordinates, i, j, wqpc, wqpr);
            }
        }
    }

    private void splitMainQuadVertices(int[][] vertices, int i, int k, int mqpc, int mqpr) {
        int x = vertices[i][k * mqpc * mqpr * 12 + 6];
        int y = vertices[i][k * mqpc * mqpr * 12 + 7];
        int z = vertices[i][k * mqpc * mqpr * 12 + 8];
        vertices[i][k * mqpc * mqpr * 12 + 6] = vertices[i][k * mqpc * mqpr * 12 + 9];
        vertices[i][k * mqpc * mqpr * 12 + 7] = vertices[i][k * mqpc * mqpr * 12 + 10];
        vertices[i][k * mqpc * mqpr * 12 + 8] = vertices[i][k * mqpc * mqpr * 12 + 11];
        vertices[i][k * mqpc * mqpr * 12 + 9] = x;
        vertices[i][k * mqpc * mqpr * 12 + 10] = y;
        vertices[i][k * mqpc * mqpr * 12 + 11] = z;
        this.v1.set(vertices[i][k * mqpc * mqpr * 12 + 0], vertices[i][k * mqpc * mqpr * 12 + 1], vertices[i][k * mqpc * mqpr * 12 + 2]);
        this.v2.set(vertices[i][k * mqpc * mqpr * 12 + 3], vertices[i][k * mqpc * mqpr * 12 + 4], vertices[i][k * mqpc * mqpr * 12 + 5]);
        this.v3.set(vertices[i][k * mqpc * mqpr * 12 + 6], vertices[i][k * mqpc * mqpr * 12 + 7], vertices[i][k * mqpc * mqpr * 12 + 8]);
        this.v4.set(vertices[i][k * mqpc * mqpr * 12 + 9], vertices[i][k * mqpc * mqpr * 12 + 10], vertices[i][k * mqpc * mqpr * 12 + 11]);
        this.vcd1 = Vector3D.sub(this.v4, this.v1);
        this.vcd1.scalarDiv(mqpc);
        this.vcd2 = Vector3D.sub(this.v3, this.v2);
        this.vcd2.scalarDiv(mqpc);
        for (int m = 0; m < mqpc; ++m) {
            this.vb1 = Vector3D.add(this.v1, Vector3D.scalarMul(m, this.vcd1));
            this.vb2 = Vector3D.add(this.v2, Vector3D.scalarMul(m, this.vcd2));
            this.vb3 = Vector3D.add(this.v2, Vector3D.scalarMul(m + 1, this.vcd2));
            this.vb4 = Vector3D.add(this.v1, Vector3D.scalarMul(m + 1, this.vcd1));
            this.vrd1 = Vector3D.sub(this.vb2, this.vb1);
            this.vrd1.scalarDiv(mqpr);
            this.vrd2 = Vector3D.sub(this.vb3, this.vb4);
            this.vrd2.scalarDiv(mqpr);
            for (int j = 0; j < mqpr; ++j) {
                Vector3D vt1 = Vector3D.add(this.vb1, Vector3D.scalarMul(j, this.vrd1));
                Vector3D vt2 = Vector3D.add(this.vb4, Vector3D.scalarMul(j, this.vrd2));
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 0] = (int)vt1.getx();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 1] = (int)vt1.gety();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 2] = (int)vt1.getz();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 9] = (int)vt2.getx();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 10] = (int)vt2.gety();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 11] = (int)vt2.getz();
                vt1 = Vector3D.add(this.vb1, Vector3D.scalarMul(j + 1, this.vrd1));
                vt2 = Vector3D.add(this.vb4, Vector3D.scalarMul(j + 1, this.vrd2));
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 3] = (int)vt1.getx();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 4] = (int)vt1.gety();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 5] = (int)vt1.getz();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 6] = (int)vt2.getx();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 7] = (int)vt2.gety();
                vertices[i][k * mqpc * mqpr * 12 + m * mqpr * 12 + j * 12 + 8] = (int)vt2.getz();
            }
        }
    }

    private void splitMainQuadCoordinates(int[][] coordinates, int i, int j, int mqpc, int mqpr) {
        int tx = coordinates[i][j * mqpc * mqpr * 8 + 4];
        int ty = coordinates[i][j * mqpc * mqpr * 8 + 5];
        coordinates[i][j * mqpc * mqpr * 8 + 4] = coordinates[i][j * mqpc * mqpr * 8 + 6];
        coordinates[i][j * mqpc * mqpr * 8 + 5] = coordinates[i][j * mqpc * mqpr * 8 + 7];
        coordinates[i][j * mqpc * mqpr * 8 + 6] = tx;
        coordinates[i][j * mqpc * mqpr * 8 + 7] = ty;
        this.v1.set(coordinates[i][j * mqpc * mqpr * 8 + 0], coordinates[i][j * mqpc * mqpr * 8 + 1], 0.0f);
        this.v2.set(coordinates[i][j * mqpc * mqpr * 8 + 2], coordinates[i][j * mqpc * mqpr * 8 + 3], 0.0f);
        this.v3.set(coordinates[i][j * mqpc * mqpr * 8 + 4], coordinates[i][j * mqpc * mqpr * 8 + 5], 0.0f);
        this.v4.set(coordinates[i][j * mqpc * mqpr * 8 + 6], coordinates[i][j * mqpc * mqpr * 8 + 7], 0.0f);
        this.vcd1 = Vector3D.sub(this.v4, this.v1);
        this.vcd1.scalarDiv(mqpc);
        this.vcd2 = Vector3D.sub(this.v3, this.v2);
        this.vcd2.scalarDiv(mqpc);
        for (int m = 0; m < mqpc; ++m) {
            this.vb1 = Vector3D.add(this.v1, Vector3D.scalarMul(m, this.vcd1));
            this.vb2 = Vector3D.add(this.v2, Vector3D.scalarMul(m, this.vcd2));
            this.vb3 = Vector3D.add(this.v2, Vector3D.scalarMul(m + 1, this.vcd2));
            this.vb4 = Vector3D.add(this.v1, Vector3D.scalarMul(m + 1, this.vcd1));
            this.vrd1 = Vector3D.sub(this.vb2, this.vb1);
            this.vrd1.scalarDiv(mqpr);
            this.vrd2 = Vector3D.sub(this.vb3, this.vb4);
            this.vrd2.scalarDiv(mqpr);
            for (int k = 0; k < mqpr; ++k) {
                Vector3D vt1 = Vector3D.add(this.vb1, Vector3D.scalarMul(k, this.vrd1));
                Vector3D vt2 = Vector3D.add(this.vb4, Vector3D.scalarMul(k, this.vrd2));
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 0] = (int)vt1.getx();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 1] = (int)vt1.gety();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 6] = (int)vt2.getx();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 7] = (int)vt2.gety();
                vt1 = Vector3D.add(this.vb1, Vector3D.scalarMul(k + 1, this.vrd1));
                vt2 = Vector3D.add(this.vb4, Vector3D.scalarMul(k + 1, this.vrd2));
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 2] = (int)vt1.getx();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 3] = (int)vt1.gety();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 4] = (int)vt2.getx();
                coordinates[i][j * mqpc * mqpr * 8 + m * mqpr * 8 + k * 8 + 5] = (int)vt2.gety();
            }
        }
    }

    public void updateFitPoints() {
        int index;
        if (this.startSide == 0) {
            index = this.startPoints[0];
            this.leftWallVertices[0] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 0];
            this.leftWallVertices[1] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 1];
            this.leftWallVertices[2] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 2];
            this.leftWallVertices[3] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 0];
            this.leftWallVertices[4] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 1];
            this.leftWallVertices[5] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 2];
            this.leftSideVertices[0] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.leftSideVertices[1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.leftSideVertices[2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[1];
            this.leftSideVertices[3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.leftSideVertices[4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.leftSideVertices[5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[1];
            this.roadVertices[0] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.roadVertices[1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.roadVertices[2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[2];
            this.roadVertices[3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.roadVertices[4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.roadVertices[5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[2];
            this.rightSideVertices[0] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.rightSideVertices[1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.rightSideVertices[2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.startPoints[3];
            this.rightSideVertices[3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.rightSideVertices[4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.rightSideVertices[5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[0] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 0];
            this.rightWallVertices[1] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 1];
            this.rightWallVertices[2] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[3] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 0];
            this.rightWallVertices[4] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 1];
            this.rightWallVertices[5] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 2];
        } else {
            index = this.startPoints[3];
            this.leftWallVertices[0] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 0];
            this.leftWallVertices[1] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 1];
            this.leftWallVertices[2] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 2];
            this.leftWallVertices[3] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 0];
            this.leftWallVertices[4] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 1];
            this.leftWallVertices[5] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 2];
            this.leftSideVertices[0] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.leftSideVertices[1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.leftSideVertices[2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[2];
            this.leftSideVertices[3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.leftSideVertices[4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.leftSideVertices[5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[2];
            this.roadVertices[0] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.roadVertices[1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.roadVertices[2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[1];
            this.roadVertices[3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.roadVertices[4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.roadVertices[5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[1];
            this.rightSideVertices[0] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.rightSideVertices[1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.rightSideVertices[2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.startPoints[0];
            this.rightSideVertices[3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.rightSideVertices[4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.rightSideVertices[5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            this.rightWallVertices[0] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 0];
            this.rightWallVertices[1] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 1];
            this.rightWallVertices[2] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[3] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 0];
            this.rightWallVertices[4] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 1];
            this.rightWallVertices[5] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 2];
        }
        if (this.endSide == 0) {
            index = this.endPoints[3];
            this.leftWallVertices[this.leftWallVertices.length - 6] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 0];
            this.leftWallVertices[this.leftWallVertices.length - 5] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 1];
            this.leftWallVertices[this.leftWallVertices.length - 4] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 2];
            this.leftWallVertices[this.leftWallVertices.length - 3] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 0];
            this.leftWallVertices[this.leftWallVertices.length - 2] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 1];
            this.leftWallVertices[this.leftWallVertices.length - 1] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 2];
            this.leftSideVertices[this.leftSideVertices.length - 6] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.leftSideVertices[this.leftSideVertices.length - 5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.leftSideVertices[this.leftSideVertices.length - 4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[2];
            this.leftSideVertices[this.leftSideVertices.length - 3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.leftSideVertices[this.leftSideVertices.length - 2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.leftSideVertices[this.leftSideVertices.length - 1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[2];
            this.roadVertices[this.roadVertices.length - 6] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.roadVertices[this.roadVertices.length - 5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.roadVertices[this.roadVertices.length - 4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[1];
            this.roadVertices[this.roadVertices.length - 3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.roadVertices[this.roadVertices.length - 2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.roadVertices[this.roadVertices.length - 1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[1];
            this.rightSideVertices[this.rightSideVertices.length - 6] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.rightSideVertices[this.rightSideVertices.length - 5] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.rightSideVertices[this.rightSideVertices.length - 4] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            index = this.endPoints[0];
            this.rightSideVertices[this.rightSideVertices.length - 3] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 0];
            this.rightSideVertices[this.rightSideVertices.length - 2] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 1];
            this.rightSideVertices[this.rightSideVertices.length - 1] = this.mTrack.leftSideVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[this.rightWallVertices.length - 6] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 0];
            this.rightWallVertices[this.rightWallVertices.length - 5] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 1];
            this.rightWallVertices[this.rightWallVertices.length - 4] = this.mTrack.leftWallVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[this.rightWallVertices.length - 3] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 0];
            this.rightWallVertices[this.rightWallVertices.length - 2] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 1];
            this.rightWallVertices[this.rightWallVertices.length - 1] = this.mTrack.leftWallVertices[index * 3 * 2 + 3 + 2];
        } else {
            index = this.endPoints[0];
            this.leftWallVertices[this.leftWallVertices.length - 6] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 0];
            this.leftWallVertices[this.leftWallVertices.length - 5] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 1];
            this.leftWallVertices[this.leftWallVertices.length - 4] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 2];
            this.leftWallVertices[this.leftWallVertices.length - 3] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 0];
            this.leftWallVertices[this.leftWallVertices.length - 2] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 1];
            this.leftWallVertices[this.leftWallVertices.length - 1] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 2];
            this.leftSideVertices[this.leftSideVertices.length - 6] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.leftSideVertices[this.leftSideVertices.length - 5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.leftSideVertices[this.leftSideVertices.length - 4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[1];
            this.leftSideVertices[this.leftSideVertices.length - 3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.leftSideVertices[this.leftSideVertices.length - 2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.leftSideVertices[this.leftSideVertices.length - 1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[1];
            this.roadVertices[this.roadVertices.length - 6] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.roadVertices[this.roadVertices.length - 5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.roadVertices[this.roadVertices.length - 4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[2];
            this.roadVertices[this.roadVertices.length - 3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.roadVertices[this.roadVertices.length - 2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.roadVertices[this.roadVertices.length - 1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[2];
            this.rightSideVertices[this.rightSideVertices.length - 6] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.rightSideVertices[this.rightSideVertices.length - 5] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.rightSideVertices[this.rightSideVertices.length - 4] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            index = this.endPoints[3];
            this.rightSideVertices[this.rightSideVertices.length - 3] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 0];
            this.rightSideVertices[this.rightSideVertices.length - 2] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 1];
            this.rightSideVertices[this.rightSideVertices.length - 1] = this.mTrack.rightSideVertices[index * 3 * 2 + 3 + 2];
            this.rightWallVertices[this.rightWallVertices.length - 6] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 0];
            this.rightWallVertices[this.rightWallVertices.length - 5] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 1];
            this.rightWallVertices[this.rightWallVertices.length - 4] = this.mTrack.rightWallVertices[index * 3 * 2 + 0 + 2];
            this.rightWallVertices[this.rightWallVertices.length - 3] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 0];
            this.rightWallVertices[this.rightWallVertices.length - 2] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 1];
            this.rightWallVertices[this.rightWallVertices.length - 1] = this.mTrack.rightWallVertices[index * 3 * 2 + 3 + 2];
        }
    }
}

