/*
 * Decompiled with CFR 0.152.
 */
import com.mascotcapsule.micro3d.v3.AffineTrans;
import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Graphics3D;
import com.mascotcapsule.micro3d.v3.Texture;
import java.util.Vector;

public class SimpleObject {
    private boolean billboard;
    private boolean model;
    private Sprite3D objectSprite;
    protected int[] objectVertices;
    protected Figure objectFigure;
    protected Texture mTexture;
    protected AffineTrans trans = new AffineTrans();
    protected int[] mscVertices;
    protected int[] mscCoordinates;
    private static Vector vertices = new Vector();
    private static Vector indices = new Vector();
    private static Vector appearances = new Vector();
    private static Vector sprites = new Vector();
    private static Vector quadIndices = new Vector();
    private static Vector billboardIndices = new Vector();
    protected Transform objectTrans;
    public Vector3D vPosition;
    protected Vector3D vDirection;
    protected Vector3D vRotation;
    protected Vector3D vPlaneRotation;
    protected float width;
    protected float height;
    protected float length;
    public int animFrame;
    private int widthInt;
    private int heightInt;
    public int animationFrame;
    private String name;
    private static Appearance appNoDepth = new Appearance();
    private static Appearance appDepth = new Appearance();
    private static boolean intiated = false;
    public boolean reverseAnim = false;
    private int cropXPos;
    private int cropYPos;
    AffineTrans viewTransform = new AffineTrans();
    public static Effect3D effect = new Effect3D();

    private static void init() {
        if (!intiated) {
            intiated = true;
        }
    }

    SimpleObject() {
        this.vPosition = new Vector3D();
        this.objectTrans = new Transform();
        SimpleObject.init();
    }

    public void init(int tex, boolean billboard, boolean depth) {
        this.init(tex, billboard, depth, 1.0f);
    }

    public void init(int tex, float scaleX, float scaleY, boolean billboard, boolean depth) {
        this.init(tex, billboard, depth, 1.0f);
        this.reScale(scaleX * (float)Track.mScale, scaleY * (float)Track.mScale);
    }

    public void init(int tex, Vector3D loc, Vector3D dir, boolean billboard, boolean depth) {
        this.init(tex, billboard, depth, 1.0f);
        this.setPosition(loc);
        this.setDirection(dir);
    }

    public void init(int tex, Vector3D loc, Vector3D dir, float scaleX, float scaleY, boolean billboard, boolean depth) {
        this.init(tex, billboard, depth, 1.0f);
        this.setPosition(loc);
        this.setDirection(dir);
        this.reScale(scaleX * (float)Track.mScale, scaleY * (float)Track.mScale);
    }

    public void init(String filepath, int tex, boolean billboard, boolean depth) {
        this.init(filepath, tex, billboard, depth, 1.0f);
    }

    public void init(String filepath, int tex, float scale, boolean billboard, boolean depth) {
        this.init(filepath, tex, billboard, depth, scale);
    }

    public void init(String filepath, int tex, Vector3D loc, Vector3D dir, boolean billboard, boolean depth) {
        this.init(filepath, tex, billboard, depth, 1.0f);
        this.setPosition(loc);
        this.setDirection(dir);
    }

    public void init(String filepath, int tex, Vector3D loc, Vector3D dir, float scale, boolean billboard, boolean depth) {
        this.init(filepath, tex, billboard, depth, scale);
        this.setPosition(loc);
        this.setDirection(dir);
    }

    public void init(int tex, boolean billboard, boolean depth, float scale) {
        this.name = "res no. " + tex;
        this.loadSprite(new Integer(tex), billboard, depth);
    }

    public void init(String filepath, int tex, boolean billboard, boolean depth, float scale) {
        this.name = filepath;
        this.loadModel(filepath, tex, scale);
    }

    private void loadSprite(Integer tex, boolean billboard, boolean depth) {
        this.billboard = billboard;
        this.model = false;
        Texture img = null;
        Resource res = null;
        try {
            res = ResourceManager.getResource(tex);
            img = SpriteLoader.LoadSprite(res.getFileName());
            this.mTexture = SpriteLoader.LoadSprite(res.getFileName());
            this.width = res.getWidth();
            this.widthInt = res.getWidth();
            this.height = res.getHeight();
            this.heightInt = res.getHeight();
            this.cropXPos = res.getX();
            this.cropYPos = res.getY();
            if (this.width < this.height) {
                this.width /= this.height;
                this.height = 1.0f;
            } else if (this.width > this.height) {
                this.height /= this.width;
                this.width = 1.0f;
            } else {
                this.width = 1.0f;
                this.height = 1.0f;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (billboard) {
            if (!billboardIndices.contains(tex)) {
                billboardIndices.addElement(tex);
                if (depth) {
                    sprites.addElement(new Sprite3D(true, img, appDepth));
                } else {
                    sprites.addElement(new Sprite3D(true, img, appNoDepth));
                }
            }
            this.objectSprite = (Sprite3D)sprites.elementAt(billboardIndices.indexOf(tex));
        } else {
            int i;
            this.vDirection = new Vector3D();
            this.vRotation = new Vector3D();
            this.vPlaneRotation = new Vector3D();
            float min_x = this.cropXPos;
            float max_x = this.cropXPos + this.widthInt;
            float min_y = this.cropYPos;
            float max_y = this.cropYPos + this.heightInt;
            short[] v = new short[12];
            short[] t = new short[8];
            int[] ind = new int[]{4};
            v[0] = (short)(-this.width * 100.0f);
            v[1] = (short)(-this.height * 100.0f);
            v[2] = 0;
            v[3] = (short)(this.width * 100.0f);
            v[4] = (short)(-this.height * 100.0f);
            v[5] = 0;
            v[6] = (short)(this.width * 100.0f);
            v[7] = (short)(this.height * 100.0f);
            v[8] = 0;
            v[9] = (short)(-this.width * 100.0f);
            v[10] = (short)(this.height * 100.0f);
            v[11] = 0;
            t[0] = (short)min_x;
            t[1] = (short)max_y;
            t[2] = (short)max_x;
            t[3] = (short)max_y;
            t[4] = (short)max_x;
            t[5] = (short)min_y;
            t[6] = (short)min_x;
            t[7] = (short)min_y;
            this.mscVertices = new int[12];
            this.mscCoordinates = new int[8];
            float s = 1.0f;
            s = tex == 65 ? 1.7f : 0.33333334f;
            for (i = 0; i < 12; ++i) {
                this.mscVertices[i] = (int)((float)(v[i] * Track.mScale) * s);
            }
            for (i = 0; i < 8; ++i) {
                this.mscCoordinates[i] = t[i];
            }
        }
    }

    private void loadModel(String filepath, int tex, float scale) {
        this.model = true;
        boolean loaded = false;
        loaded = true;
        Resource res = ResourceManager.getResource(tex);
        this.mTexture = SpriteLoader.LoadSprite(res.getFileName());
        String fName = filepath;
        try {
            this.objectFigure = new Figure(fName);
        }
        catch (Exception e) {
            System.out.println("Error: unable to load simple object mesh: " + fName);
            loaded = false;
        }
        if (loaded) {
            this.vDirection = new Vector3D();
            this.vRotation = new Vector3D();
            this.vPlaneRotation = new Vector3D();
            this.billboard = false;
            this.objectFigure.setTexture(this.mTexture);
            if (this.name.compareTo("/Meshes/Other/missiongate.mbac") == 0) {
                this.width = 104.499695f * (float)Track.mScale;
                this.height = 64.448875f * (float)Track.mScale;
                this.length = 38.06907f * (float)Track.mScale;
            } else if (this.name.length() > 23 && this.name.substring(0, 24).compareTo("/Meshes/Other/gatenumber") == 0) {
                this.width = 21.594769f * (float)Track.mScale;
                this.height = 62.57959f * (float)Track.mScale;
                this.length = 41.329025f * (float)Track.mScale;
            }
        } else {
            System.out.println("There was an error in simple object.");
        }
    }

    public boolean isBillboard() {
        return this.billboard;
    }

    public boolean isModel() {
        return this.model;
    }

    public float getHeight() {
        return this.height;
    }

    public float getWidth() {
        return this.width;
    }

    public float getLength() {
        return this.length;
    }

    public float getCollisionQuaterDist() {
        return this.width / 2.0f * (this.width / 2.0f);
    }

    public float getTreeCollisionQuaterDist() {
        return this.width / 5.0f * (this.width / 5.0f);
    }

    public void setSize(float sX, float sY) {
        this.width = sX;
        this.height = sY;
        if (!this.billboard && !this.model) {
            short[] v = new short[]{(short)(-this.width), (short)(-this.height), 0, (short)this.width, (short)(-this.height), 0, (short)this.width, (short)this.height, 0, (short)(-this.width), (short)this.height, 0};
            float s = 0.5f;
            for (int i = 0; i < 12; ++i) {
                this.mscVertices[i] = (int)((float)v[i] * s);
            }
        }
    }

    public void reScale(float sX, float sY) {
        if (sX > 0.0f && sY > 0.0f) {
            this.width *= sX;
            this.height *= sY;
        }
    }

    public void setGroundLevel(float h) {
        this.vPosition.sety(this.height / 2.0f + h);
    }

    public void setPosition(Vector3D loc) {
        this.vPosition.set(loc);
    }

    public void setDirection(Vector3D dir) {
        if (!this.billboard) {
            this.vDirection.set(dir);
            this.vDirection.normalize();
            this.vRotation.setx((float)mMath.toDegrees(mMath.acos(this.vDirection.getx())));
            this.vRotation.sety((float)mMath.toDegrees(mMath.acos(this.vDirection.gety())));
            this.vRotation.setz((float)mMath.toDegrees(mMath.acos(this.vDirection.getz())));
        }
    }

    public void setRotation(Vector3D rot) {
        if (!this.billboard) {
            this.vRotation.set(rot);
            this.vDirection.setx((float)mMath.cos(mMath.toRadians(this.vRotation.getx())));
            this.vDirection.sety((float)mMath.cos(mMath.toRadians(this.vRotation.gety())));
            this.vDirection.setz((float)mMath.cos(mMath.toRadians(this.vRotation.getz())));
        }
    }

    public void setPlaneRotation(Vector3D rot) {
        if (!this.billboard) {
            this.vPlaneRotation.set(rot);
        }
    }

    public Vector3D getPlaneRotation() {
        return this.vPlaneRotation;
    }

    public Vector3D getPosition() {
        return new Vector3D(this.vPosition);
    }

    public Vector3D getDirection() {
        return new Vector3D(this.vDirection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update() {
        try {
            this.objectTrans.setIdentity();
            this.objectTrans.postTranslate(this.vPosition.getx(), this.vPosition.gety() + this.height / 2.0f, this.vPosition.getz());
            if (!this.billboard) {
                this.objectTrans.postRotate(this.vPlaneRotation.getx(), 1.0f, 0.0f, 0.0f);
                this.objectTrans.postRotate(this.vPlaneRotation.getz(), 0.0f, 0.0f, 1.0f);
                this.objectTrans.postRotate(this.vPlaneRotation.gety(), 0.0f, 1.0f, 0.0f);
                this.objectTrans.postRotate(this.vRotation.getx(), 1.0f, 0.0f, 0.0f);
                this.objectTrans.postRotate(this.vRotation.gety(), 0.0f, 1.0f, 0.0f);
                this.objectTrans.postRotate(this.vRotation.getz(), 0.0f, 0.0f, 1.0f);
            }
            if (this.model) return;
        }
        catch (Exception e) {
            System.out.println("All's hell broken loose!");
            System.out.println("The evil one: " + this.name);
            System.out.println("height: " + this.height);
            System.out.println("width: " + this.width);
            System.out.println("position: " + this.vPosition);
            System.out.println("plane: " + this.vPlaneRotation);
            System.out.println("rotation: " + this.vRotation);
            e.printStackTrace();
        }
    }

    public void render(Graphics3D g3d) {
        if (this.billboard) {
            if (this.animationFrame != 0 && !this.reverseAnim) {
                this.objectSprite.setCrop(this.cropXPos + this.widthInt / (this.animationFrame + 1) * this.animFrame, this.cropYPos, this.widthInt / (this.animationFrame + 1), this.heightInt);
            } else if (this.animationFrame != 0 && this.reverseAnim) {
                this.objectSprite.setCrop(this.cropXPos + this.widthInt - this.widthInt / (this.animationFrame + 1) * (this.animFrame + 1), this.cropYPos, this.widthInt / (this.animationFrame + 1), this.heightInt);
            } else {
                this.objectSprite.setCrop(this.cropXPos, this.cropYPos, this.widthInt, this.heightInt);
            }
            this.objectSprite.setSize((int)this.width, (int)this.height);
            Kart.copyMatrix(this.objectTrans, this.trans);
            RaceManager.viewTransform.set(RaceManager.cameraTransform);
            RaceManager.viewTransform.mul(this.trans);
            this.objectSprite.render(g3d, RaceManager.layout, RaceManager.effect);
        } else {
            Kart.copyMatrix(this.objectTrans, this.trans);
            RaceManager.viewTransform.set(RaceManager.cameraTransform);
            RaceManager.viewTransform.mul(this.trans);
            if (this.isModel()) {
                try {
                    g3d.renderFigure(this.objectFigure, 0, 0, RaceManager.layout, RaceManager.effect);
                }
                catch (Exception e) {
                    System.out.println("error rendering simple object mesh");
                }
            } else {
                try {
                    int command = 67121168;
                    int[] normals = new int[]{};
                    int[] colors = new int[]{};
                    g3d.renderPrimitives(this.mTexture, 0, 0, RaceManager.layout, RaceManager.effect, command, 1, this.mscVertices, normals, this.mscCoordinates, colors);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void render(Graphics3D g3d, FigureLayout layout, AffineTrans camTrans) {
        this.viewTransform = layout.getAffineTrans();
        if (this.billboard) {
            if (this.animationFrame != 0 && !this.reverseAnim) {
                this.objectSprite.setCrop(this.cropXPos + this.widthInt / (this.animationFrame + 1) * this.animFrame, this.cropYPos, this.widthInt / (this.animationFrame + 1), this.heightInt);
            } else if (this.animationFrame != 0 && this.reverseAnim) {
                this.objectSprite.setCrop(this.cropXPos + this.widthInt - this.widthInt / (this.animationFrame + 1) * (this.animFrame + 1), this.cropYPos, this.widthInt / (this.animationFrame + 1), this.heightInt);
            } else {
                this.objectSprite.setCrop(this.cropXPos, this.cropYPos, this.widthInt, this.heightInt);
            }
            this.objectSprite.setSize((int)this.width, (int)this.height);
            Kart.copyMatrix(this.objectTrans, this.trans);
            this.viewTransform.set(camTrans);
            this.viewTransform.mul(this.trans);
            effect.setTransparency(true);
            this.objectSprite.render(g3d, layout, effect);
        } else {
            Kart.copyMatrix(this.objectTrans, this.trans);
            this.viewTransform.set(camTrans);
            this.viewTransform.mul(this.trans);
            if (this.isModel()) {
                try {
                    g3d.renderFigure(this.objectFigure, 0, 0, layout, effect);
                }
                catch (Exception e) {
                    System.out.println("error rendering simple object mesh");
                }
            } else {
                try {
                    int command = 67121168;
                    int[] normals = new int[]{};
                    int[] colors = new int[]{};
                    g3d.renderPrimitives(this.mTexture, 0, 0, layout, effect, command, 1, this.mscVertices, normals, this.mscCoordinates, colors);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void clear() {
        vertices.removeAllElements();
        indices.removeAllElements();
        appearances.removeAllElements();
        sprites.removeAllElements();
        quadIndices.removeAllElements();
        billboardIndices.removeAllElements();
        try {
            Thread.sleep(250L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }
}

