/*
 * Decompiled with CFR 0.152.
 */
public class Transform {
    private float[] m = new float[16];
    private static float[] tmpBuf1 = new float[16];
    private static float[] tmpBuf2 = new float[16];

    public Transform() {
        this.setIdentity();
    }

    public void set(float[] matrix) {
        for (int i = 0; i < 16; ++i) {
            this.m[i] = matrix[i];
        }
    }

    public void set(Transform t) {
        t.get(tmpBuf1);
        for (int i = 0; i < 16; ++i) {
            this.m[i] = tmpBuf1[i];
        }
    }

    public void get(float[] matrix) {
        for (int i = 0; i < 16; ++i) {
            matrix[i] = this.m[i];
        }
    }

    public void setIdentity() {
        for (int i = 0; i < 16; ++i) {
            this.m[i] = i == 0 || i == 5 || i == 10 || i == 15 ? 1.0f : 0.0f;
        }
    }

    public void setTranslation(float tx, float ty, float tz) {
        this.m[3] = tx;
        this.m[7] = ty;
        this.m[11] = tz;
    }

    public void postMultiply(Transform t) {
        this.get(tmpBuf1);
        t.get(tmpBuf2);
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                float sum = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    sum += tmpBuf1[i * 4 + k] * tmpBuf2[k * 4 + j];
                }
                this.m[i * 4 + j] = sum;
            }
        }
    }

    public void postTranslate(float tx, float ty, float tz) {
        Transform t = new Transform();
        t.setTranslation(tx, ty, tz);
        this.postMultiply(t);
    }

    public void postRotate(float angle, float x, float y, float z) {
        angle = (float)(Math.PI * (double)angle / 180.0);
        float s = (float)Math.sin(angle);
        float c = (float)Math.cos(angle);
        this.get(tmpBuf1);
        Transform.tmpBuf1[0] = x * x * (1.0f - c) + c;
        Transform.tmpBuf1[1] = x * y * (1.0f - c) - z * s;
        Transform.tmpBuf1[2] = x * z * (1.0f - c) + y * s;
        Transform.tmpBuf1[3] = 0.0f;
        Transform.tmpBuf1[4] = y * x * (1.0f - c) + z * s;
        Transform.tmpBuf1[5] = y * y * (1.0f - c) + c;
        Transform.tmpBuf1[6] = y * z * (1.0f - c) - x * s;
        Transform.tmpBuf1[7] = 0.0f;
        Transform.tmpBuf1[8] = x * z * (1.0f - c) - y * s;
        Transform.tmpBuf1[9] = y * z * (1.0f - c) + x * s;
        Transform.tmpBuf1[10] = z * z * (1.0f - c) + c;
        Transform.tmpBuf1[11] = 0.0f;
        Transform.tmpBuf1[12] = 0.0f;
        Transform.tmpBuf1[13] = 0.0f;
        Transform.tmpBuf1[14] = 0.0f;
        Transform.tmpBuf1[15] = 1.0f;
        Transform r = new Transform();
        r.set(tmpBuf1);
        this.postMultiply(r);
    }

    public void postScale(float sx, float sy, float sz) {
    }
}

