/*
 * Decompiled with CFR 0.152.
 */
class Spline {
    float a;
    float b;
    float c;
    float d;

    public Spline(float a, float b, float c, float d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    public float eval(float u) {
        return ((this.d * u + this.c) * u + this.b) * u + this.a;
    }

    public static Spline[] calculateClosedCubic(int n, float[] x) {
        int k;
        float[] w = new float[n + 1];
        float[] v = new float[n + 1];
        float[] y = new float[n + 1];
        float[] D = new float[n + 1];
        float z = 0.25f;
        v[1] = 0.25f;
        w[1] = 0.25f;
        y[0] = z * 3.0f * (x[1] - x[n]);
        float H = 4.0f;
        float F = 3.0f * (x[0] - x[n - 1]);
        float G = 1.0f;
        for (k = 1; k < n; ++k) {
            v[k + 1] = z = 1.0f / (4.0f - v[k]);
            w[k + 1] = -z * w[k];
            y[k] = z * (3.0f * (x[k + 1] - x[k - 1]) - y[k - 1]);
            H -= G * w[k];
            F -= G * y[k - 1];
            G = -v[k] * G;
        }
        y[n] = F - (G + 1.0f) * y[n - 1];
        D[n] = y[n] / (H -= (G + 1.0f) * (v[n] + w[n]));
        D[n - 1] = y[n - 1] - (v[n] + w[n]) * D[n];
        for (k = n - 2; k >= 0; --k) {
            D[k] = y[k] - v[k + 1] * D[k + 1] - w[k + 1] * D[n];
        }
        Spline[] C = new Spline[n + 1];
        for (k = 0; k < n; ++k) {
            C[k] = new Spline(x[k], D[k], 3.0f * (x[k + 1] - x[k]) - 2.0f * D[k] - D[k + 1], 2.0f * (x[k] - x[k + 1]) + D[k] + D[k + 1]);
        }
        C[n] = new Spline(x[n], D[n], 3.0f * (x[0] - x[n]) - 2.0f * D[n] - D[0], 2.0f * (x[n] - x[0]) + D[n] + D[0]);
        return C;
    }

    public static Spline[] calculateNaturalCubic(int n, float[] x) {
        int i;
        float[] gamma = new float[n + 1];
        float[] delta = new float[n + 1];
        float[] D = new float[n + 1];
        gamma[0] = 0.5f;
        for (i = 1; i < n; ++i) {
            gamma[i] = 1.0f / (4.0f - gamma[i - 1]);
        }
        gamma[n] = 1.0f / (2.0f - gamma[n - 1]);
        delta[0] = 3.0f * (x[1] - x[0]) * gamma[0];
        for (i = 1; i < n; ++i) {
            delta[i] = (3.0f * (x[i + 1] - x[i - 1]) - delta[i - 1]) * gamma[i];
        }
        delta[n] = (3.0f * (x[n] - x[n - 1]) - delta[n - 1]) * gamma[n];
        D[n] = delta[n];
        for (i = n - 1; i >= 0; --i) {
            D[i] = delta[i] - gamma[i] * D[i + 1];
        }
        Spline[] C = new Spline[n];
        for (i = 0; i < n; ++i) {
            C[i] = new Spline(x[i], D[i], 3.0f * (x[i + 1] - x[i]) - 2.0f * D[i] - D[i + 1], 2.0f * (x[i] - x[i + 1]) + D[i] + D[i + 1]);
        }
        return C;
    }
}

