/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKString;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.IStringConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.state.StateInGame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimData {
    public boolean m_rmsGSBonusUnlocked;
    public int numTimesFlown;
    public int numTimesFlownFirstClass;
    public int moneyEarned = 0;
    public int numVisitsBeijing;
    public int numVisitsCairo;
    public int numVisitsParis;
    public int numVisitsSanFran;
    private short[] d_skillDescStrings;
    private int[][] d_skillRates;
    private short[][] d_skillLevelDescStrings;
    private short[] d_careerDescStrings;
    private short[] d_careerStreamers;
    private short[] d_careerRabbitHoles;
    private byte[] d_careerBosses;
    private short[] d_careerFreakDeath1s;
    private short[] d_careerFreakDeath2s;
    private short[] d_careerRaiseFail;
    private short[][] d_careerLevelDescStrings;
    private short[][] d_careerLevelIncomes;
    private short[][] d_careerLevelFlags;
    private short[][] d_careerLevelHoursStarts;
    private short[][] d_careerLevelHoursEnds;
    private byte[][][] d_careerLevelRequirements;
    private short[] d_personaDescStrings;
    private short[] d_personaLongDescStrings;
    private short[] d_personaIcons;
    private short[] d_personaFlags;
    private short[] d_dreamDescStrings;
    private short[] d_dreamFlags;
    private int d_motiveCount;
    private short[] d_motiveDescStrings;
    private int[] d_motiveStartLevel;
    private int[] d_motiveDecayRate;
    private short[] d_motiveTriggersNeeds;
    private int[] d_motiveTriggersNeedLevels;
    private short[] d_motiveAnimHighs;
    private short[] d_motiveAnimLows;
    private byte[] d_timeRangeDreams;
    private int d_buffCount;
    private short[] d_buffDescStringIds;
    private int[] d_buffTimeouts;
    private byte[] d_buffTimeoutChains;
    private byte[] d_buffTimes;
    private byte[] d_buffFlags;
    private byte[][] d_buffTriggerMotives;
    private int[][] d_buffTriggerMotiveLevels;
    private byte[][] d_buffEffectMood;
    private byte[][] d_buffEffectMoodAmount;
    private byte[][] d_buffEffectMotive;
    private int[][] d_buffEffectMotiveFactors;
    private short[] d_traitDescStrings;
    private short[] d_traitExcludes;
    private int d_numRelLevels;
    private short[] d_relStateDescStrings;
    private byte[] d_relStateFlags;
    private short[] d_relStateEffectAnims;
    private short[] d_relStateToStrings;
    private byte[][] d_relStateTriggerToStates;
    private byte[][] d_relStateTriggerLevels;
    private short[][] d_relStateTriggerLevelValues;
    private int d_numSims;
    private short[] d_simNameStrings;
    private byte[] d_simMacromapColors;
    private byte[][] d_simAttributes;
    private short[] d_simHomes;
    private byte[] d_simFlags;
    private byte[] d_simPartners;
    private byte[] d_simCareers;
    private byte[] d_simCareerLevels;
    private byte[][] d_simTraits;
    private int d_numPresets;
    private byte[][] d_simPresets;
    private short[] d_commodityStringIds;
    private int d_numActions;
    private short[] d_actionStringIds;
    private short[] d_actionGroupStringIds;
    private int[] d_actionFlags;
    private short[] d_actionWorldArgs;
    private byte[][] d_actionConditionCommodities;
    private byte[][] d_actionConditionTraits;
    private int[][] d_actionConditionRelStates;
    private short[][] d_actionEffectFlags;
    private byte[][] d_actionAffectFriendships;
    private byte[][] d_actionAffectRomances;
    private byte[][] d_actionAffectCommodities;
    private byte[][] d_actionAffectCommodityAmounts;
    private short[][] d_actionResponseActions;
    private byte[][] d_actionPhases;
    public boolean initMsgHasShownAtHome;
    public boolean initMsgHasShownAtAirport;
    public boolean initMsgHasShownAtCounter;
    public int timeArrivedInCairo;
    public short toursTried;
    private short[] objectActions = new short[20];
    public static final int[] DAY_FLAGS = new int[]{4, 8, 16, 32, 64, 128, 256};
    public static final int[] DAY_STRINGS = new int[]{554, 555, 556, 557, 558, 559, 560};
    public int m_timeTimer;
    private int m_timeTotal;
    private int m_money;
    private int m_moneySpent;
    private int m_moneySpentOnFlying;
    private boolean m_fastForward;
    private byte[] m_inventory;
    private int m_activeRecipe;
    private int[] m_skillLevelsF;
    public static final int[] PERK_FLAGS = new int[]{1, 2};
    public static final int[] PERK_STRINGS = new int[]{566, 567};
    private byte m_careerAcceptDay;
    private short m_careerDaysWorked;
    private short m_careerDaysMissed;
    private byte[] m_careerLevelsAttained;
    private byte m_phoneCareer;
    private int m_phoneCareerTimer;
    private byte m_persona;
    private byte m_dream;
    private int m_dreamTimer;
    private byte[] m_promises;
    private int m_personaGoalsCompleted;
    private boolean m_personaGoalsCompletedAll;
    public boolean m_personaGoalsCompletedAllShown;
    private int[] m_timeRanges;
    private int[] m_woohooTimes;
    private int[] m_woohooPartners;
    private int m_quickLinkFlags;
    private int m_motiveTimer;
    private int[] m_motiveLevelsF;
    private int[] m_motiveDecaysF;
    private int[] m_motiveDecayFactorsF;
    private int[] m_motiveDecayAdjustsF;
    private short[] m_buffsActive;
    private int[] m_buffTimers;
    private static final short[] MOODDESC_STRINGS = new short[]{354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365};
    private int[] m_moodLevelsF;
    private int m_moodDesc;
    private int m_moodLevel;
    private byte[] m_currentRelStates;
    private short[] m_currentRelStateFlags;
    private int[][] m_currentRelLevelsF;
    private int[][] m_commodityLevelsF;
    private short[][] m_actionHistories;
    private byte[][] m_knownTraits;
    private int m_commodityTimer;
    private int m_lastNPC;
    private int m_lastNPCTimer;
    private int m_timeoutDelay;
    private short[] m_objectStateIds;
    private int[] m_objectStateValues;
    private int[] m_objectStateTimes;

    public SimData() {
        this.initData();
        this.resetRMSGameData();
    }

    public int determinePotentialVisitor() {
        int n;
        int n2;
        int[] nArray = new int[]{5, 6, 7, 8, 9, 10};
        int[] nArray2 = new int[]{1, 3, 5, 7, 9, 11};
        int n3 = 0;
        for (n2 = 1; n2 < this.d_numSims; ++n2) {
            if (this.getSimHome(n2) == 0) continue;
            for (n = 0; n < nArray.length; ++n) {
                if (this.m_currentRelStates[n2] != nArray[n]) continue;
                n3 += nArray2[n];
                n = nArray.length;
            }
        }
        if (n3 == 0) {
            return -1;
        }
        int[] nArray3 = new int[n3];
        n2 = 0;
        for (n = 1; n < this.d_numSims; ++n) {
            if (this.getSimHome(n) == 0) continue;
            for (int i = 0; i < nArray.length; ++i) {
                if (this.m_currentRelStates[n] != nArray[i]) continue;
                for (int j = 0; j < nArray2[i]; ++j) {
                    if (n2 < n3) {
                        nArray3[n2] = n;
                    }
                    ++n2;
                }
                i = nArray.length;
            }
        }
        return nArray3[Main.rand(0, nArray3.length - 1)];
    }

    public void numSlapped() {
        int n = 0;
        for (int i = 1; i < this.d_numSims; ++i) {
            if ((this.m_currentRelStateFlags[i] & 0x20) == 0) continue;
            ++n;
        }
        if (n >= 10) {
            this.dreamCompleteEvent(36);
        }
    }

    private void initData() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Intro.ResourceManager_loadBinaryFile(64);
        int n10 = Cursor.PMFile_readByte();
        this.d_skillDescStrings = new short[n10];
        this.d_skillRates = new int[n10][5];
        this.d_skillLevelDescStrings = new short[n10][6];
        for (n9 = 0; n9 < n10; ++n9) {
            this.d_skillDescStrings[n9] = Main.lookupSimsData();
            for (n8 = 0; n8 < 5; ++n8) {
                this.d_skillRates[n9][n8] = Cursor.PMFile_readInt();
            }
            for (n8 = 0; n8 < 6; ++n8) {
                this.d_skillLevelDescStrings[n9][n8] = Main.lookupSimsData();
            }
        }
        n9 = Cursor.PMFile_readByte();
        this.d_careerDescStrings = new short[n9];
        this.d_careerStreamers = new short[n9];
        this.d_careerRabbitHoles = new short[n9];
        this.d_careerBosses = new byte[n9];
        this.d_careerFreakDeath1s = new short[n9];
        this.d_careerFreakDeath2s = new short[n9];
        this.d_careerRaiseFail = new short[n9];
        this.d_careerLevelDescStrings = new short[n9][];
        this.d_careerLevelIncomes = new short[n9][];
        this.d_careerLevelFlags = new short[n9][];
        this.d_careerLevelHoursStarts = new short[n9][];
        this.d_careerLevelHoursEnds = new short[n9][];
        this.d_careerLevelRequirements = new byte[n9][][];
        for (n8 = 0; n8 < n9; ++n8) {
            this.d_careerDescStrings[n8] = Main.lookupSimsData();
            this.d_careerStreamers[n8] = Main.lookupSimsData();
            this.d_careerRabbitHoles[n8] = Main.lookupSimsData();
            this.d_careerBosses[n8] = Cursor.PMFile_readByte();
            this.d_careerFreakDeath1s[n8] = Main.lookupSimsData();
            this.d_careerFreakDeath2s[n8] = Main.lookupSimsData();
            this.d_careerRaiseFail[n8] = Main.lookupSimsData();
            n7 = Cursor.PMFile_readByte();
            this.d_careerLevelDescStrings[n8] = new short[n7];
            this.d_careerLevelIncomes[n8] = new short[n7];
            this.d_careerLevelFlags[n8] = new short[n7];
            this.d_careerLevelHoursStarts[n8] = new short[n7];
            this.d_careerLevelHoursEnds[n8] = new short[n7];
            this.d_careerLevelRequirements[n8] = new byte[n7][4];
            for (n6 = 0; n6 < n7; ++n6) {
                this.d_careerLevelDescStrings[n8][n6] = Main.lookupSimsData();
                this.d_careerLevelIncomes[n8][n6] = Cursor.PMFile_readShort();
                this.d_careerLevelFlags[n8][n6] = Cursor.PMFile_readShort();
                n5 = Cursor.PMFile_readShort();
                n4 = Cursor.PMFile_readShort();
                n5 = n5 % 100 + n5 / 100 * 60;
                n4 = n4 % 100 + n4 / 100 * 60;
                this.d_careerLevelHoursStarts[n8][n6] = (short)n5;
                this.d_careerLevelHoursEnds[n8][n6] = (short)n4;
                this.d_careerLevelRequirements[n8][n6][0] = (byte)Main.lookupSimsData();
                this.d_careerLevelRequirements[n8][n6][1] = Cursor.PMFile_readByte();
                this.d_careerLevelRequirements[n8][n6][2] = (byte)Main.lookupSimsData();
                this.d_careerLevelRequirements[n8][n6][3] = Cursor.PMFile_readByte();
            }
        }
        this.d_careerLevelDescStrings = ArrayOptimizer.Optimize(this.d_careerLevelDescStrings);
        this.d_careerLevelIncomes = ArrayOptimizer.Optimize(this.d_careerLevelIncomes);
        this.d_careerLevelFlags = ArrayOptimizer.Optimize(this.d_careerLevelFlags);
        this.d_careerLevelHoursStarts = ArrayOptimizer.Optimize(this.d_careerLevelHoursStarts);
        this.d_careerLevelHoursEnds = ArrayOptimizer.Optimize(this.d_careerLevelHoursEnds);
        this.d_careerLevelRequirements = ArrayOptimizer.Optimize(this.d_careerLevelRequirements);
        n8 = Cursor.PMFile_readByte();
        this.d_personaDescStrings = new short[n8];
        this.d_personaLongDescStrings = new short[n8];
        this.d_personaIcons = new short[n8];
        this.d_personaFlags = new short[n8];
        for (n7 = 0; n7 < n8; ++n7) {
            this.d_personaDescStrings[n7] = Main.lookupSimsData();
            this.d_personaLongDescStrings[n7] = Main.lookupSimsData();
            this.d_personaIcons[n7] = Main.lookupSimsData();
            this.d_personaFlags[n7] = Cursor.PMFile_readShort();
        }
        n7 = Cursor.PMFile_readByte();
        this.d_dreamDescStrings = new short[n7];
        this.d_dreamFlags = new short[n7];
        for (n6 = 0; n6 < n7; ++n6) {
            this.d_dreamDescStrings[n6] = Main.lookupSimsData();
            this.d_dreamFlags[n6] = Cursor.PMFile_readShort();
        }
        this.d_motiveCount = Cursor.PMFile_readByte();
        this.d_motiveDescStrings = new short[this.d_motiveCount];
        this.d_motiveStartLevel = new int[this.d_motiveCount];
        this.d_motiveDecayRate = new int[this.d_motiveCount];
        this.d_motiveTriggersNeeds = new short[this.d_motiveCount];
        this.d_motiveTriggersNeedLevels = new int[this.d_motiveCount];
        this.d_motiveAnimHighs = new short[this.d_motiveCount];
        this.d_motiveAnimLows = new short[this.d_motiveCount];
        for (n6 = 0; n6 < this.d_motiveCount; ++n6) {
            this.d_motiveDescStrings[n6] = Main.lookupSimsData();
            this.d_motiveStartLevel[n6] = Cursor.PMFile_readInt();
            this.d_motiveDecayRate[n6] = Cursor.PMFile_readInt();
            this.d_motiveTriggersNeeds[n6] = Cursor.PMFile_readShort();
            this.d_motiveTriggersNeedLevels[n6] = Cursor.PMFile_readInt();
            this.d_motiveAnimHighs[n6] = Main.lookupSimsData();
            this.d_motiveAnimLows[n6] = Main.lookupSimsData();
        }
        n6 = Cursor.PMFile_readByte();
        this.d_timeRangeDreams = new byte[n6];
        for (n5 = 0; n5 < this.d_timeRangeDreams.length; ++n5) {
            this.d_timeRangeDreams[n5] = Cursor.PMFile_readByte();
        }
        this.d_buffCount = Cursor.PMFile_readByte();
        this.d_buffDescStringIds = new short[this.d_buffCount];
        this.d_buffTimeouts = new int[this.d_buffCount];
        this.d_buffTimeoutChains = new byte[this.d_buffCount];
        this.d_buffTimes = new byte[this.d_buffCount];
        this.d_buffFlags = new byte[this.d_buffCount];
        this.d_buffTriggerMotives = new byte[this.d_buffCount][];
        this.d_buffTriggerMotiveLevels = new int[this.d_buffCount][];
        this.d_buffEffectMood = new byte[this.d_buffCount][];
        this.d_buffEffectMoodAmount = new byte[this.d_buffCount][];
        this.d_buffEffectMotive = new byte[this.d_buffCount][];
        this.d_buffEffectMotiveFactors = new int[this.d_buffCount][];
        for (n5 = 0; n5 < this.d_buffCount; ++n5) {
            this.d_buffDescStringIds[n5] = Main.lookupSimsData();
            this.d_buffTimeouts[n5] = Cursor.PMFile_readInt();
            this.d_buffTimeoutChains[n5] = Cursor.PMFile_readByte();
            this.d_buffTimes[n5] = Cursor.PMFile_readByte();
            this.d_buffFlags[n5] = Cursor.PMFile_readByte();
            n4 = Cursor.PMFile_readByte();
            this.d_buffTriggerMotives[n5] = new byte[n4];
            this.d_buffTriggerMotiveLevels[n5] = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.d_buffTriggerMotives[n5][n3] = Cursor.PMFile_readByte();
                this.d_buffTriggerMotiveLevels[n5][n3] = Cursor.PMFile_readInt();
            }
            n3 = Cursor.PMFile_readByte();
            this.d_buffEffectMood[n5] = new byte[n3];
            this.d_buffEffectMoodAmount[n5] = new byte[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.d_buffEffectMood[n5][n2] = (byte)Main.lookupSimsData();
                this.d_buffEffectMoodAmount[n5][n2] = Cursor.PMFile_readByte();
            }
            n3 = Cursor.PMFile_readByte();
            this.d_buffEffectMotive[n5] = new byte[n3];
            this.d_buffEffectMotiveFactors[n5] = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.d_buffEffectMotive[n5][n2] = Cursor.PMFile_readByte();
                this.d_buffEffectMotiveFactors[n5][n2] = Cursor.PMFile_readInt();
            }
        }
        this.d_buffTriggerMotives = ArrayOptimizer.Optimize(this.d_buffTriggerMotives);
        this.d_buffTriggerMotiveLevels = ArrayOptimizer.Optimize(this.d_buffTriggerMotiveLevels);
        this.d_buffEffectMood = ArrayOptimizer.Optimize(this.d_buffEffectMood);
        this.d_buffEffectMoodAmount = ArrayOptimizer.Optimize(this.d_buffEffectMoodAmount);
        this.d_buffEffectMotive = ArrayOptimizer.Optimize(this.d_buffEffectMotive);
        this.d_buffEffectMotiveFactors = ArrayOptimizer.Optimize(this.d_buffEffectMotiveFactors);
        n5 = Cursor.PMFile_readByte();
        this.d_traitDescStrings = new short[n5];
        this.d_traitExcludes = new short[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            this.d_traitDescStrings[n4] = Main.lookupSimsData();
            this.d_traitExcludes[n4] = Cursor.PMFile_readByte();
        }
        this.d_numRelLevels = Cursor.PMFile_readByte();
        n4 = Cursor.PMFile_readByte();
        this.d_relStateDescStrings = new short[n4];
        this.d_relStateFlags = new byte[n4];
        this.d_relStateEffectAnims = new short[n4];
        this.d_relStateToStrings = new short[n4];
        this.d_relStateTriggerToStates = new byte[n4][];
        this.d_relStateTriggerLevels = new byte[n4][];
        this.d_relStateTriggerLevelValues = new short[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            this.d_relStateDescStrings[n3] = Main.lookupSimsData();
            this.d_relStateFlags[n3] = Cursor.PMFile_readByte();
            this.d_relStateEffectAnims[n3] = Main.lookupSimsData();
            this.d_relStateToStrings[n3] = Main.lookupSimsData();
            n2 = Cursor.PMFile_readUnsignedByte();
            this.d_relStateTriggerToStates[n3] = new byte[n2];
            this.d_relStateTriggerLevels[n3] = new byte[n2];
            this.d_relStateTriggerLevelValues[n3] = new short[n2];
            for (n = 0; n < n2; ++n) {
                this.d_relStateTriggerToStates[n3][n] = Cursor.PMFile_readByte();
                this.d_relStateTriggerLevels[n3][n] = Cursor.PMFile_readByte();
                this.d_relStateTriggerLevelValues[n3][n] = Cursor.PMFile_readShort();
            }
        }
        this.d_relStateTriggerToStates = ArrayOptimizer.Optimize(this.d_relStateTriggerToStates);
        this.d_relStateTriggerLevels = ArrayOptimizer.Optimize(this.d_relStateTriggerLevels);
        this.d_relStateTriggerLevelValues = ArrayOptimizer.Optimize(this.d_relStateTriggerLevelValues);
        this.d_numSims = Cursor.PMFile_readByte();
        this.d_simNameStrings = new short[this.d_numSims];
        this.d_simMacromapColors = new byte[this.d_numSims];
        this.d_simAttributes = new byte[this.d_numSims][10];
        this.d_simHomes = new short[this.d_numSims];
        this.d_simFlags = new byte[this.d_numSims];
        this.d_simPartners = new byte[this.d_numSims];
        this.d_simCareers = new byte[this.d_numSims];
        this.d_simCareerLevels = new byte[this.d_numSims];
        this.d_simTraits = new byte[this.d_numSims][];
        for (n3 = 0; n3 < this.d_numSims; ++n3) {
            this.d_simNameStrings[n3] = Main.lookupSimsData();
            this.d_simMacromapColors[n3] = Cursor.PMFile_readByte();
            if (this.d_simMacromapColors[n3] == 2) {
                // empty if block
            }
            if (this.d_simMacromapColors[n3] == 3) {
                this.d_simMacromapColors[n3] = 1;
            }
            for (n2 = 0; n2 < 10; ++n2) {
                this.d_simAttributes[n3][n2] = Cursor.PMFile_readByte();
            }
            this.d_simHomes[n3] = Main.lookupSimsData();
            this.d_simFlags[n3] = Cursor.PMFile_readByte();
            this.d_simPartners[n3] = Cursor.PMFile_readByte();
            this.d_simCareers[n3] = Cursor.PMFile_readByte();
            this.d_simCareerLevels[n3] = Cursor.PMFile_readByte();
            n2 = Cursor.PMFile_readByte();
            this.d_simTraits[n3] = new byte[n2];
            for (n = 0; n < n2; ++n) {
                this.d_simTraits[n3][n] = Cursor.PMFile_readByte();
            }
        }
        ArrayOptimizer.Optimize(this.d_simTraits);
        this.d_numPresets = Cursor.PMFile_readByte();
        this.d_simPresets = new byte[this.d_numPresets][12];
        for (n3 = 0; n3 < this.d_numPresets; ++n3) {
            for (n2 = 0; n2 < 12; ++n2) {
                this.d_simPresets[n3][n2] = Cursor.PMFile_readByte();
            }
        }
        n3 = Cursor.PMFile_readByte();
        this.d_commodityStringIds = new short[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.d_commodityStringIds[n2] = Main.lookupSimsData();
        }
        this.d_numActions = Cursor.PMFile_readShort();
        this.d_actionStringIds = new short[this.d_numActions];
        this.d_actionGroupStringIds = new short[this.d_numActions];
        this.d_actionFlags = new int[this.d_numActions];
        this.d_actionWorldArgs = new short[this.d_numActions];
        this.d_actionPhases = new byte[this.d_numActions][];
        this.d_actionConditionCommodities = new byte[this.d_numActions][];
        this.d_actionConditionTraits = new byte[this.d_numActions][];
        this.d_actionConditionRelStates = new int[this.d_numActions][];
        this.d_actionEffectFlags = new short[this.d_numActions][];
        this.d_actionAffectFriendships = new byte[this.d_numActions][];
        this.d_actionAffectRomances = new byte[this.d_numActions][];
        this.d_actionAffectCommodities = new byte[this.d_numActions][];
        this.d_actionAffectCommodityAmounts = new byte[this.d_numActions][];
        this.d_actionResponseActions = new short[this.d_numActions][];
        for (n2 = 0; n2 < this.d_numActions; ++n2) {
            int n11;
            int n12;
            this.d_actionStringIds[n2] = Main.lookupSimsData();
            this.d_actionGroupStringIds[n2] = Main.lookupSimsData();
            this.d_actionFlags[n2] = Cursor.PMFile_readInt();
            this.d_actionWorldArgs[n2] = Main.lookupSimsData();
            n = Cursor.PMFile_readByte();
            this.d_actionConditionCommodities[n2] = new byte[n];
            this.d_actionConditionTraits[n2] = new byte[n];
            this.d_actionConditionRelStates[n2] = new int[n];
            this.d_actionEffectFlags[n2] = new short[n];
            this.d_actionAffectFriendships[n2] = new byte[n];
            this.d_actionAffectRomances[n2] = new byte[n];
            this.d_actionAffectCommodities[n2] = new byte[n];
            this.d_actionAffectCommodityAmounts[n2] = new byte[n];
            this.d_actionResponseActions[n2] = new short[n];
            for (n12 = 0; n12 < n; ++n12) {
                this.d_actionConditionCommodities[n2][n12] = Cursor.PMFile_readByte();
                this.d_actionConditionTraits[n2][n12] = Cursor.PMFile_readByte();
                n11 = Cursor.PMFile_readInt();
                this.d_actionConditionRelStates[n2][n12] = (n11 & 1) != 0 ? ~n11 : n11;
                this.d_actionEffectFlags[n2][n12] = Cursor.PMFile_readShort();
                this.d_actionAffectFriendships[n2][n12] = Cursor.PMFile_readByte();
                this.d_actionAffectRomances[n2][n12] = Cursor.PMFile_readByte();
                this.d_actionAffectCommodities[n2][n12] = Cursor.PMFile_readByte();
                this.d_actionAffectCommodityAmounts[n2][n12] = Cursor.PMFile_readByte();
                this.d_actionResponseActions[n2][n12] = Cursor.PMFile_readShort();
            }
            n12 = Cursor.PMFile_readByte();
            if ((this.d_actionFlags[n2] & 0x20000000) != 0) {
                Debug.ASSERT(this.d_actionPhases[24] != null && n12 == 0, "invalid generic talk");
                this.d_actionPhases[n2] = this.d_actionPhases[24];
                continue;
            }
            this.d_actionPhases[n2] = new byte[n12];
            for (n11 = 0; n11 < this.d_actionPhases[n2].length; ++n11) {
                this.d_actionPhases[n2][n11] = Cursor.PMFile_readByte();
            }
        }
        this.d_actionPhases = ArrayOptimizer.Optimize(this.d_actionPhases);
        this.d_actionConditionCommodities = ArrayOptimizer.Optimize(this.d_actionConditionCommodities);
        this.d_actionConditionTraits = ArrayOptimizer.Optimize(this.d_actionConditionTraits);
        this.d_actionConditionRelStates = ArrayOptimizer.Optimize(this.d_actionConditionRelStates);
        this.d_actionEffectFlags = ArrayOptimizer.Optimize(this.d_actionEffectFlags);
        this.d_actionAffectFriendships = ArrayOptimizer.Optimize(this.d_actionAffectFriendships);
        this.d_actionAffectRomances = ArrayOptimizer.Optimize(this.d_actionAffectRomances);
        this.d_actionAffectCommodities = ArrayOptimizer.Optimize(this.d_actionAffectCommodities);
        this.d_actionAffectCommodityAmounts = ArrayOptimizer.Optimize(this.d_actionAffectCommodityAmounts);
        this.d_actionResponseActions = ArrayOptimizer.Optimize(this.d_actionResponseActions);
        Cursor.PMFile_closeFile();
    }

    public int getGameTimeAbs() {
        return this.m_timeTotal;
    }

    public int getGameTime() {
        return this.getGameTime(this.m_timeTotal);
    }

    public int getGameTime(int n) {
        return n % 1440;
    }

    public int getGameDay() {
        return this.getGameDay(this.m_timeTotal);
    }

    public int getGameDay(int n) {
        return n / 1440 % 7;
    }

    public int getGameMidnight(int n) {
        return n / 1440 * 1440;
    }

    public int getTotalDays() {
        return (this.getGameTimeAbs() - 840) / 1440;
    }

    public int getMoney() {
        return this.m_money;
    }

    public int getMoneySpent() {
        return this.m_moneySpent;
    }

    public int getMoneySpentOnFlying() {
        return this.m_moneySpentOnFlying;
    }

    public void adjustMoney(int n, boolean bl) {
        this.m_money += n;
        if (n < 0) {
            this.m_moneySpent -= n;
            if (bl) {
                this.m_moneySpentOnFlying -= n;
            }
        }
    }

    private void initGameTimeMoney() {
        this.m_timeTotal = 840;
        this.m_money = 700;
        this.m_moneySpent = 0;
        this.m_moneySpentOnFlying = 0;
        this.m_fastForward = false;
    }

    public void setFastforward(boolean bl) {
        this.m_fastForward = bl;
    }

    public boolean getFastforward() {
        return this.m_fastForward;
    }

    private void updateGameTime(int n) {
        this.m_timeTimer += n;
        if (this.m_timeTimer > 1000) {
            int n2 = this.m_timeTimer / 1000;
            this.m_timeTimer -= n2 * 1000;
            int n3 = this.m_timeTotal;
            this.m_timeTotal += n2;
            StateInGame.checkGameTimeTriggers(n3, this.m_timeTotal);
        }
    }

    public int getCostForAction(int n) {
        if (n == 98) {
            if (Main.isAirport(Main.m_simWorld.getHouseId())) {
                return 20;
            }
            return 10;
        }
        if (n == 126) {
            int n2;
            int n3;
            int n4 = this.getSimCareer(0);
            if (n4 != -1 && ((n3 = this.getCareerLevelFlags(n4, n2 = this.getSimCareerLevel(0))) & 2) != 0) {
                return 15;
            }
            return 30;
        }
        Debug.ASSERT(false, "unknown cost for action");
        return 0;
    }

    public int getDesiredWakeupTime(int n) {
        int n2 = 480;
        if (this.hasSimGotTrait(n, 10) != -1) {
            n2 = 540;
        } else if (this.hasSimGotTrait(n, 11) != -1) {
            n2 = 420;
        }
        return n2;
    }

    public int getWakeupTime(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getGameTimeAbs();
        if (n == 0) {
            n5 = this.m_motiveLevelsF[1];
            n4 = 65536 - IStringConstants.MathExt_Fdiv(n5, 0x640000);
            n3 = n6 + IStringConstants.MathExt_Fmul(n4, 600);
        } else {
            n3 = n6 + 600;
        }
        n5 = this.getSimCareer(n);
        if (n5 != -1 && (n2 = (n4 = this.getNextJobStartTime(n, n6)) - 60) > n6 && n2 - n6 < 1440) {
            n3 = Math.min(n2, n3);
        }
        Debug.ASSERT(n3 >= n6, "can't wake up in the past!");
        return n3;
    }

    public void updateSkipWorking() {
        int n;
        int n2;
        int n3 = this.getSimCareer(0);
        int n4 = this.getCareerLevelHoursEnd(n3, n2 = this.getSimCareerLevel(0));
        int n5 = n4 - (n = this.getGameTime());
        if (n5 < 0) {
            n5 += 1440;
        }
        Debug.ASSERT(n4 >= n, "Can't knock-off *before* we go to work!");
        int n6 = n5 * 1000;
        this.updateGameTime(n6);
        this.adjustMotiveLevelWithBuffCheck(1, -983040, 3);
        this.adjustMotiveLevelWithBuffCheck(3, -1310720, 7);
        this.adjustMotiveLevel(5, -1638400);
        this.adjustMotiveLevel(2, this.getMotiveLevel(2) < 0x230000 ? 0x320000 : -983040);
        if (this.getSimCareer(0) != 0) {
            this.adjustMotiveLevelWithBuffCheck(0, -1310720, 0);
        }
        this.delayAlerts();
    }

    public void updateSkipSleeping(int n) {
        int n2 = this.getGameTimeAbs();
        Debug.ASSERT(n >= n2, "Can't wake up *before* we go to sleep!");
        int n3 = (n - n2) * 1000;
        this.updateGameTime(n3);
        this.adjustMotiveLevel(1, 0x640000);
        this.adjustMotiveLevel(2, -655360);
        this.adjustMotiveLevelWithBuffCheck(0, -1310720, 0);
        this.adjustMotiveLevelWithBuffCheck(3, -983040, 7);
        this.delayAlerts();
    }

    private void initInventory() {
        if (this.m_inventory == null) {
            int n = Main.m_simWorld.getItemCount();
            this.m_inventory = new byte[n];
        }
        ArrayHandler.fillArray(this.m_inventory, 0);
    }

    public int getInventoryCount(int n) {
        return this.m_inventory[n];
    }

    public int getInventoryNthCount() {
        return this.m_inventory.length - ArrayHandler.countOf(0, this.m_inventory);
    }

    public int getInventoryNthItem(int n) {
        return ArrayHandler.indexOfNthElement(n, this.m_inventory, 0);
    }

    public void adjustInventory(int n, int n2) {
        this.m_inventory[n] = (byte)Math.min(Main.m_simWorld.getItemMaxInventory(n), this.m_inventory[n] + n2);
    }

    public void createCookContextMenu(short[] sArray, short[] sArray2, int n) {
        short s = this.d_actionStringIds[n];
        Main.menuClear(sArray, s);
        Main.menuClear(sArray2, s);
        byte[] byArray = this.m_inventory;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] <= 0 || (Main.m_simWorld.getItemFlags(i) & 0x80) == 0) continue;
            Main.menuAppendItem(sArray, Main.m_simWorld.getItemDescString(i));
            Main.menuAppendItem(sArray2, n);
        }
    }

    public boolean startRecipe(int n) {
        int n2;
        int n3 = Main.m_simWorld.getRecipeIngredientCount(n);
        for (n2 = 0; n2 < n3; ++n2) {
            if (this.getInventoryCount(Main.m_simWorld.getRecipeIngredient(n, n2)) >= 1) continue;
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.adjustInventory(Main.m_simWorld.getRecipeIngredient(n, n2), -1);
        }
        this.m_activeRecipe = n;
        return true;
    }

    private void initSkills() {
        int n = this.getSkillCount();
        if (this.m_skillLevelsF == null) {
            this.m_skillLevelsF = new int[n];
        }
        ArrayHandler.fillArray(this.m_skillLevelsF, 0);
    }

    public int getSkillLevel(int n) {
        return this.m_skillLevelsF[n];
    }

    public int getSkillCount() {
        return this.d_skillDescStrings.length;
    }

    public int getSkillDesc(int n) {
        return this.d_skillDescStrings[n];
    }

    public int getSkillLevelDesc(int n) {
        return this.d_skillLevelDescStrings[n][this.getSkillRank(n)];
    }

    public int getSkillRank(int n) {
        return this.m_skillLevelsF[n] / 65536;
    }

    public void increaseSkill(int n) {
        int[] nArray = this.m_skillLevelsF;
        int n2 = this.getSkillRank(n);
        if (n2 < 5) {
            int n3 = n;
            nArray[n3] = nArray[n3] + this.d_skillRates[n][n2];
            nArray[n] = Math.min(nArray[n], 65536 * (n2 + 1));
        }
    }

    private void initCareer() {
        this.d_simCareers[0] = -1;
        this.d_simCareerLevels[0] = 0;
        this.m_careerAcceptDay = (byte)-1;
        this.m_careerDaysWorked = 0;
        this.m_careerDaysMissed = 0;
        if (this.m_careerLevelsAttained == null) {
            this.m_careerLevelsAttained = new byte[this.d_careerDescStrings.length];
        }
        ArrayHandler.fillArray(this.m_careerLevelsAttained, 0);
        this.m_phoneCareer = (byte)(Main.rand(0, this.d_careerDescStrings.length) - 1);
        this.m_phoneCareerTimer = 1440000;
    }

    private void updateCareer(int n) {
        this.m_phoneCareerTimer += n;
        if (this.m_phoneCareerTimer > 1440000) {
            this.m_phoneCareerTimer = 0;
            this.m_phoneCareer = (byte)(Main.rand(0, this.d_careerDescStrings.length) - 1);
        }
    }

    public void careerAcceptJob(int n, int n2) {
        byte by = this.d_simCareers[0];
        byte by2 = this.d_simCareerLevels[0];
        this.d_simCareers[0] = (byte)n;
        this.d_simCareerLevels[0] = (byte)n2;
        if (n != -1) {
            this.m_careerLevelsAttained[n] = (byte)n2;
        }
        this.m_careerDaysWorked = 0;
        this.m_careerDaysMissed = 0;
        if (n != -1) {
            if (by != n) {
                this.m_careerAcceptDay = (byte)this.getGameDay();
            }
            int n3 = by == n ? (n2 > by2 ? 536 : 538) : 535;
            int n4 = this.getNextJobStartTime(0, this.getGameTimeAbs());
            int n5 = this.getGameDay(n4);
            int n6 = this.getGameDay(this.getGameTimeAbs() + 1440) == n5 ? 561 : DAY_STRINGS[n5];
            SDKString sDKString = GameConstants.TextHandler_getString(n6);
            SDKString sDKString2 = GameConstants.TextHandler_clearStringBuffer();
            GameConstants.TextHandler_appendTimeToBuffer24Hour(this.d_careerLevelHoursStarts[n][n2]);
            SDKString sDKString3 = GameConstants.TextHandler_getString(Main.m_simWorld.getObjectStringId(this.d_careerRabbitHoles[n]));
            GameConstants.TextHandler_dynamicString(-11, n3, sDKString, sDKString2, sDKString3);
            int n7 = 0;
            if (by == n && n2 > by2) {
                n7 = 4;
            } else if (n != -1) {
                n7 = 3;
            }
            int n8 = this.getCareerLevelDescString(n, n2);
            StateInGame.showMessageBox(-11, n8, n7);
        }
    }

    public int careerDayWorked() {
        int n = this.getSimCareer(0);
        int n2 = this.getSimCareerLevel(0);
        int n3 = this.getCareerLevelIncome(n, n2);
        this.adjustMoney(n3, false);
        this.moneyEarned += n3;
        this.m_careerDaysWorked = (short)(this.m_careerDaysWorked + 1);
        if (this.m_careerDaysWorked % 3 == 2 && this.m_careerDaysMissed > 0) {
            this.m_careerDaysMissed = (short)(this.m_careerDaysMissed - 1);
        }
        return n3;
    }

    public void careerDayMissed() {
        this.m_careerDaysMissed = (short)(this.m_careerDaysMissed + 1);
        if (this.m_careerDaysMissed >= 3) {
            this.careerAcceptJob(-1, 0);
        }
    }

    public int getRequirementValue(int n) {
        switch (n) {
            default: {
                Debug.ASSERT(false, "invalid requirement");
            }
            case 0: {
                return this.getSkillRank(0);
            }
            case 4: {
                return this.getSkillRank(2);
            }
            case 2: {
                return this.getSkillRank(4);
            }
            case 3: {
                return this.getSkillRank(3);
            }
            case 1: {
                return this.getSkillRank(1);
            }
            case 5: 
        }
        int n2 = 0;
        for (int i = 1; i < this.d_numSims; ++i) {
            if ((this.getRelStateFlags(this.m_currentRelStates[i]) & 0x10) == 0) continue;
            ++n2;
        }
        return n2;
    }

    public int getRequimentName(int n) {
        switch (n) {
            case 0: {
                return 463;
            }
            case 4: {
                return 477;
            }
            case 1: {
                return 470;
            }
            case 2: {
                return 491;
            }
            case 3: {
                return 484;
            }
            case 5: {
                return 608;
            }
        }
        return 4;
    }

    public boolean careerRequirementsMet(int n, int n2) {
        int n3;
        int n4;
        byte[] byArray = this.d_careerLevelRequirements[n][n2];
        byte by = byArray[0];
        byte by2 = byArray[1];
        if (by != -1 && (n4 = this.getRequirementValue(by)) < by2) {
            return false;
        }
        n4 = byArray[2];
        byte by3 = byArray[3];
        if (n4 != -1 && (n3 = this.getRequirementValue(n4)) < by3) {
            return false;
        }
        n3 = this.getCareerBoss(n);
        byte by4 = this.m_currentRelStates[n3];
        return (this.getRelStateFlags(by4) & 2) == 0;
    }

    public boolean careerAutoPromotionDue() {
        int n = this.getSimCareer(0);
        int n2 = this.getSimCareerLevel(0);
        return n2 < this.getCareerLevelCount(n) - 1 && this.careerRequirementsMet(n, n2 + 1) && this.m_careerDaysWorked >= 10;
    }

    public int getJobSearchCareerFromObject(MapObject mapObject) {
        byte by = this.d_simCareers[0];
        int n = -1;
        if (mapObject == null || mapObject.getType() == 28) {
            int n2 = this.getGameTime();
            if (n2 >= 450 && n2 <= 1110 && this.m_phoneCareer != by) {
                n = this.m_phoneCareer;
            }
        } else {
            n = ArrayHandler.indexOf(mapObject.getType(), this.d_careerRabbitHoles);
        }
        return n;
    }

    public int getJobSearchLevel(int n) {
        if (n == -1) {
            return 0;
        }
        int n2 = Math.max(this.m_careerLevelsAttained[n] - 1, 0);
        return n2;
    }

    public boolean isItAWorkDayToday() {
        int n = 0;
        if (this.d_simCareers[n] == -1) {
            return false;
        }
        short s = this.d_careerLevelFlags[this.d_simCareers[n]][this.d_simCareerLevels[n]];
        int n2 = DAY_FLAGS[this.getGameDay(this.getGameTimeAbs())];
        return (s & n2) != 0;
    }

    public boolean isTimeInRange(int n, int n2, int n3) {
        if ((n2 = (n2 + 1440) % 1440) < (n3 = (n3 + 1440) % 1440)) {
            return n >= n2 && n <= n3;
        }
        return n >= n2 || n <= n3;
    }

    public int getTimeFlags(int n) {
        return this.getTimeFlags(n, this.getGameTimeAbs());
    }

    public int getTimeFlags(int n, int n2) {
        int n3 = 0;
        int n4 = this.getGameDay(n2);
        int n5 = this.getGameTime(n2);
        int n6 = this.getDesiredWakeupTime(n);
        int n7 = n6 - 600;
        byte by = this.d_simCareers[n];
        if (by == -1) {
            n3 |= 8;
        } else {
            byte by2 = this.d_simCareerLevels[n];
            short s = this.d_careerLevelHoursStarts[by][by2];
            if (n == 0 && n4 == this.m_careerAcceptDay) {
                n3 |= 8;
            } else {
                int n8;
                short s2;
                if (n == 0) {
                    this.m_careerAcceptDay = (byte)-1;
                }
                if (((s2 = this.d_careerLevelFlags[by][by2]) & (n8 = DAY_FLAGS[n4])) != 0) {
                    short s3 = this.d_careerLevelHoursEnds[by][by2];
                    n3 = n5 < s - 30 ? (n3 |= 8) : (n5 < s ? (n3 |= 1) : (n5 < s + 60 ? (n3 |= 2) : (n5 < s3 ? (n3 |= 4) : (n3 |= 8))));
                } else {
                    n3 |= 8;
                }
            }
            n7 = s - 660;
            n6 = s - 60;
        }
        if (this.isTimeInRange(n5, n7, n6)) {
            n3 |= 0x10;
        }
        return n3;
    }

    public int getNextJobStartTime(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.getSimCareer(n);
        Debug.ASSERT(n5 != -1, "Can't get the start time for a slacker");
        int n6 = this.getSimCareerLevel(n);
        int n7 = this.getCareerLevelFlags(n5, n6);
        int n8 = this.getCareerLevelHoursStart(n5, n6);
        int n9 = this.getGameTime(n2);
        int n10 = n4 = this.getGameDay(n2);
        for (n3 = 0; n3 < 7 && ((n7 & DAY_FLAGS[n10 = (n4 + n3) % 7]) == 0 || n == 0 && n10 == this.m_careerAcceptDay || n10 == n4 && n9 >= n8); ++n3) {
        }
        n3 = this.getGameMidnight(this.getGameTimeAbs()) + n8;
        if (n10 != n4) {
            n3 += (n10 - n4 + 7) % 7 * 1440;
        }
        return n3;
    }

    private boolean isPlaceForWork(MapObject mapObject, int n) {
        byte by = this.d_simCareers[n];
        if (by == -1) {
            return false;
        }
        if (mapObject != null) {
            int n2 = this.getCareerRabbitHole(by);
            return mapObject.getType() == n2;
        }
        return false;
    }

    public boolean isTimeForWork(MapObject mapObject, int n) {
        if (mapObject != null && !this.isPlaceForWork(mapObject, n)) {
            return false;
        }
        int n2 = this.getTimeFlags(n);
        return (n2 & 3) != 0;
    }

    public int getCareerLevelCount(int n) {
        return this.d_careerLevelDescStrings[n].length;
    }

    public int getCareerDescString(int n) {
        if (n == -1) {
            return 568;
        }
        return this.d_careerDescStrings[n];
    }

    public int getCareerRabbitHole(int n) {
        return this.d_careerRabbitHoles[n];
    }

    public int getCareerBoss(int n) {
        return this.d_careerBosses[n];
    }

    public int getCareerDeathString() {
        byte by = this.d_simCareers[0];
        if (Main.randPercent() < 50) {
            return this.d_careerFreakDeath1s[by];
        }
        return this.d_careerFreakDeath2s[by];
    }

    public int getCareerFailString(int n) {
        return this.d_careerRaiseFail[n];
    }

    public int getCareerLevelDescString(int n, int n2) {
        return this.d_careerLevelDescStrings[n][n2];
    }

    public int getCareerLevelIncome(int n, int n2) {
        return this.d_careerLevelIncomes[n][n2];
    }

    public int getCareerLevelFlags(int n, int n2) {
        return this.d_careerLevelFlags[n][n2];
    }

    public int getCareerLevelHoursStart(int n, int n2) {
        return this.d_careerLevelHoursStarts[n][n2];
    }

    public int getCareerLevelHoursEnd(int n, int n2) {
        return this.d_careerLevelHoursEnds[n][n2];
    }

    public byte[] getCareerLevelRequirements(int n, int n2) {
        return this.d_careerLevelRequirements[n][n2];
    }

    public int getPersona() {
        return this.m_persona;
    }

    public void setPersona(int n) {
        this.m_persona = (byte)n;
    }

    public int getPersonaCount() {
        return this.d_personaDescStrings.length;
    }

    public short getPersonaDescString(int n) {
        if (n == -1) {
            n = 0;
        }
        return this.d_personaDescStrings[n];
    }

    public short getPersonaLongDescString(int n) {
        return this.d_personaLongDescStrings[n];
    }

    public int getPersonaFlags() {
        if (this.m_persona == -1) {
            return 0;
        }
        return this.d_personaFlags[this.m_persona];
    }

    public int getPersonaNthGoalCount() {
        return ArrayHandler.countOfFlags(this.getPersonaFlags(), this.d_dreamFlags);
    }

    public int getPersonaNthGoalItem(int n) {
        return ArrayHandler.indexOfNthElementFlags(n, this.d_dreamFlags, this.getPersonaFlags());
    }

    private int getPersonaActionFlags() {
        switch (this.m_persona) {
            default: {
                Debug.ASSERT(false, "invalid persona");
            }
            case 0: {
                return 0x800000;
            }
            case 5: {
                return 0x1000000;
            }
            case 4: {
                return 0x2000000;
            }
            case 3: {
                return 0x4000000;
            }
            case 2: {
                return 0x8000000;
            }
            case 1: 
        }
        return 0x10000000;
    }

    public boolean showPersonaComplete() {
        return this.m_personaGoalsCompletedAll && !this.m_personaGoalsCompletedAllShown;
    }

    private void initDreams() {
        this.m_dream = (byte)-1;
        this.m_dreamTimer = 115000;
        if (this.m_promises == null) {
            this.m_promises = new byte[4];
            this.m_timeRanges = new int[this.d_timeRangeDreams.length];
            this.m_woohooTimes = new int[10];
            this.m_woohooPartners = new int[10];
        }
        ArrayHandler.fillArray(this.m_promises, -1);
        this.m_personaGoalsCompleted = 0;
        this.m_personaGoalsCompletedAll = false;
        this.m_personaGoalsCompletedAllShown = false;
        ArrayHandler.fillArray(this.m_timeRanges, this.getGameTimeAbs());
        ArrayHandler.fillArray(this.m_woohooTimes, -1);
        ArrayHandler.fillArray(this.m_woohooPartners, -1);
        this.m_quickLinkFlags = 0;
    }

    private void updateDreams(int n) {
        this.m_dreamTimer += n;
        if (this.m_dream != -1) {
            if (this.m_dreamTimer > 240000) {
                StateInGame.showExpiredDream(this.m_dream);
                this.m_dream = (byte)-1;
                this.m_dreamTimer = 0;
            }
        } else if (this.m_dreamTimer > 120000) {
            this.m_dream = (byte)this.dreamNew();
            this.m_dreamTimer = 0;
            StateInGame.showNewDream();
        }
        int n2 = this.getGameTimeAbs();
        for (int i = 0; i < this.m_timeRanges.length; ++i) {
            int n3 = this.m_timeRanges[i];
            if (n3 == -1 || n2 - n3 <= 4320) continue;
            this.m_timeRanges[i] = n2;
            this.dreamCompleteEvent(this.d_timeRangeDreams[i]);
        }
    }

    private int dreamNew() {
        int n;
        int n2 = this.d_dreamFlags.length;
        int n3 = -1;
        int n4 = -1;
        boolean bl = true;
        if (bl) {
            for (n = 0; n < n2; ++n) {
                n4 = Main.rand(0, n2 - 1);
                if ((this.d_dreamFlags[n4] & 1) != 0 && Main.isGoalCompleted(n4) || this.getDreamSlot(n4) != -1 || (this.d_dreamFlags[n4] & 4) != 0 || !this.dreamSuitable(n4) || Main.isGoalCompleted(n4) && Main.randPercent() < 70) continue;
                n3 = n4;
                break;
            }
        }
        if ((n = ArrayHandler.indexOf(n3, this.d_timeRangeDreams)) != -1 && this.m_timeRanges[n] != -1) {
            this.m_timeRanges[n] = this.getGameTimeAbs();
        }
        if (n3 != -1) {
            Main.setGoalDiscovered(n3);
        }
        return n3;
    }

    public void dreamToPromise() {
        int n = this.getDreamSlot(-1);
        if (n != -1 && this.m_dream != -1) {
            this.m_promises[n] = this.m_dream;
            this.m_dream = (byte)-1;
            this.m_dreamTimer = 0;
            StateInGame.showNewPromise(n);
        }
    }

    public boolean isDreamToPromisePossible() {
        return ArrayHandler.indexOf(-1, this.m_promises) != -1;
    }

    private boolean dreamSuitable(int n) {
        switch (n) {
            case 27: {
                return this.d_simCareers[0] == 3;
            }
            case 29: {
                return this.d_simCareers[0] == 1;
            }
            case 28: {
                return this.d_simCareers[0] == 0;
            }
            case 30: {
                return this.d_simCareers[0] == 2;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                int n2;
                int n3 = n2 = n == 13 ? 8 : 16;
                int n4 = n == 4 ? 8 : (n == 5 ? 16 : (n == 6 ? 32 : 64));
                for (int i = 1; i < this.d_numSims; ++i) {
                    if (!this.hasSimGotFlag(i, n4) || (this.getRelStateFlags(this.m_currentRelStates[i]) & n2) != 0) continue;
                    return true;
                }
                return false;
            }
            case 12: {
                return Main.m_simWorld.cookingSchoolIsMoreRecipesAvailable() > 0;
            }
            case 22: {
                return Main.m_simWorld.areThereAnyRecipesLeftToBuy();
            }
        }
        return true;
    }

    public int getDreamSlot(int n) {
        return ArrayHandler.indexOf(n, this.m_promises);
    }

    public int getDream() {
        return this.m_dream;
    }

    public int getPromise(int n) {
        return this.m_promises[n];
    }

    public int getDreamDescString(int n) {
        if (n < 0 || n >= this.d_dreamDescStrings.length) {
            return 524;
        }
        return this.d_dreamDescStrings[n];
    }

    public int getTaskCount() {
        return this.d_dreamDescStrings.length;
    }

    public int getTaskFlags(int n) {
        return this.d_dreamFlags[n];
    }

    public void dreamCompleteEvent(int n) {
        int n2;
        int n3;
        boolean bl = false;
        int n4 = this.getDreamSlot(n);
        if (n4 != -1) {
            bl = true;
            this.m_promises[n4] = -1;
        } else if (this.m_dream == n) {
            bl = true;
            this.m_dream = (byte)-1;
            this.m_dreamTimer = 0;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = this.getTaskCount();
        int n8 = this.getPersonaFlags();
        for (n3 = 0; n3 < n7; ++n3) {
            if ((this.getTaskFlags(n3) & n8) == 0) continue;
            n2 = 1 << n5;
            if (n == n3 && (this.m_personaGoalsCompleted & n2) == 0) {
                this.m_personaGoalsCompleted |= n2;
                bl = true;
            }
            if ((this.m_personaGoalsCompleted & n2) != 0) {
                ++n6;
            }
            ++n5;
        }
        if (bl) {
            Main.setGoalCompleted(n);
            StateInGame.showGoalCompleted(n, n4);
        }
        if (n6 == n5 && n5 > 0) {
            this.m_personaGoalsCompletedAll = true;
            if (!this.isBonusUnlocked()) {
                n3 = 1;
                for (n2 = 0; n2 < this.getTaskCount(); ++n2) {
                    if ((this.getTaskFlags(n2) & 4) != 0 || Main.isGoalCompleted(n2)) continue;
                    n3 = 0;
                    break;
                }
                if (n3 != 0) {
                    StateInGame.m_showBonusUnlocked = true;
                }
            }
        }
        if ((n == 27 || n == 29 || n == 28 || n == 30) && bl) {
            this.adjustMoney(600, false);
        }
    }

    public boolean registerWooHoo() {
        int n;
        int[] nArray = this.m_woohooTimes;
        int n2 = this.getGameTimeAbs();
        int n3 = 0;
        int n4 = -1;
        for (n = 0; n < 10; ++n) {
            int n5 = nArray[n];
            if (n2 - n5 > 1440) {
                nArray[n] = -1;
                n5 = -1;
            }
            if (n5 == -1 && n4 == -1) {
                n4 = n;
                nArray[n] = n2;
                n5 = n2;
            }
            if (n5 == -1) continue;
            ++n3;
        }
        if (n4 == -1 || n3 >= 10) {
            return true;
        }
        if (this.m_persona == 2 && (n = ArrayHandler.indexOf(-1, this.m_woohooPartners)) != -1 && ArrayHandler.indexOf(Event.m_eventParam, this.m_woohooPartners) == -1) {
            this.m_woohooPartners[n] = Event.m_eventParam;
            if (ArrayHandler.indexOf(-1, this.m_woohooPartners) == -1) {
                this.dreamCompleteEvent(42);
            }
        }
        return false;
    }

    public boolean isPersonaGoalsCompleted(int n) {
        return (this.m_personaGoalsCompleted & 1 << n) != 0;
    }

    public boolean isQuickLinkVisited(int n) {
        int n2 = Main.m_simWorld.getObjectQuickLinkIndex(n);
        if (n2 != -1) {
            return (this.m_quickLinkFlags & 1 << n2) != 0;
        }
        return false;
    }

    public void setQuickLinkVisited(int n) {
        int n2 = Main.m_simWorld.getObjectQuickLinkIndex(n);
        if (n2 != -1) {
            this.m_quickLinkFlags |= 1 << n2;
        }
    }

    public int getMotiveCount() {
        return this.d_motiveCount;
    }

    public short getMotiveDescString(int n) {
        return this.d_motiveDescStrings[n];
    }

    public short getMotiveHighAnim(int n) {
        return this.d_motiveAnimHighs[n];
    }

    public short getMotiveLowAnim(int n) {
        return this.d_motiveAnimLows[n];
    }

    public int getMotiveLevel(int n) {
        return this.m_motiveLevelsF[n];
    }

    private void initMotives() {
        if (this.m_motiveLevelsF == null) {
            this.m_motiveLevelsF = new int[this.d_motiveCount];
            this.m_motiveDecaysF = new int[this.d_motiveCount];
            this.m_motiveDecayAdjustsF = new int[this.d_motiveCount];
            this.m_motiveDecayFactorsF = new int[this.d_motiveCount];
        }
        System.arraycopy(this.d_motiveStartLevel, 0, this.m_motiveLevelsF, 0, this.d_motiveCount);
        System.arraycopy(this.d_motiveDecayRate, 0, this.m_motiveDecaysF, 0, this.d_motiveCount);
        ArrayHandler.fillArray(this.m_motiveDecayAdjustsF, 0);
        ArrayHandler.fillArray(this.m_motiveDecayFactorsF, 65536);
        this.m_motiveTimer = 0;
    }

    private void updateMotives(int n) {
        this.m_motiveTimer += n;
        if (this.m_motiveTimer > 500) {
            this.m_motiveTimer -= 500;
            int[] nArray = this.m_motiveDecaysF;
            int[] nArray2 = this.m_motiveDecayFactorsF;
            int[] nArray3 = this.m_motiveDecayAdjustsF;
            for (int i = 0; i < this.d_motiveCount; ++i) {
                int n2 = IStringConstants.MathExt_Fmul(nArray2[i], nArray[i]);
                this.adjustMotiveLevel(i, n2 + nArray3[i] >> 1);
            }
        }
    }

    public void adjustMotiveLevel(int n, int n2) {
        int[] nArray = this.m_motiveLevelsF;
        int n3 = n;
        nArray[n3] = nArray[n3] + n2;
        nArray[n] = IStringConstants.MathExt_clip(nArray[n], 0, 0x640000);
    }

    public void adjustMotivePercent(int n, int n2) {
        if (n2 >= 0 && n2 <= 100) {
            this.m_motiveLevelsF[n] = this.m_motiveLevelsF[n] * n2 / 100;
        }
    }

    private void adjustMotiveLevelWithBuffCheck(int n, int n2, int n3) {
        if (this.buffGetActiveSlot(n3) == -1) {
            this.adjustMotiveLevel(n, n2);
        }
    }

    public void setMotiveAdjust(int n, int n2) {
        this.m_motiveDecayAdjustsF[n] = n2;
    }

    public int getPlayerNeedFlags() {
        int n = 0;
        int[] nArray = this.m_motiveLevelsF;
        short[] sArray = this.d_motiveTriggersNeeds;
        int[] nArray2 = this.d_motiveTriggersNeedLevels;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= nArray2[i]) continue;
            n |= sArray[i];
        }
        return n;
    }

    private void initBuffs() {
        if (this.m_buffsActive == null) {
            this.m_buffsActive = new short[6];
            this.m_buffTimers = new int[6];
        }
        ArrayHandler.fillArray(this.m_buffsActive, -1);
        ArrayHandler.fillArray(this.m_buffTimers, 0);
    }

    private void updateBuffs(int n) {
        int n2;
        int n3;
        int n4;
        short[] sArray = this.m_buffsActive;
        int[] nArray = this.m_buffTimers;
        byte[] byArray = this.d_buffFlags;
        int[] nArray2 = this.d_buffTimeouts;
        byte[] byArray2 = this.d_buffTimeoutChains;
        block5: for (n4 = 0; n4 < 6; ++n4) {
            n3 = sArray[n4];
            if (n3 == -1) continue;
            if ((byArray[n3] & 2) == 0 && !this.buffTriggerConditionsExist(n3)) {
                this.removeActiveBuff(n3);
                continue;
            }
            n2 = nArray2[n3] * 1000;
            int n5 = n4;
            nArray[n5] = nArray[n5] + n;
            if (nArray[n4] <= n2) continue;
            nArray[n4] = n2;
            if (byArray2[n3] != -1) {
                this.setBuff(n4, byArray2[n3]);
                continue;
            }
            if (!this.buffTriggerConditionsExist(n3)) {
                this.removeActiveBuff(n3);
                continue;
            }
            switch (n3) {
                default: {
                    continue block5;
                }
                case 2: {
                    GameConstants.TextHandler_dynamicString(-11, 694, Main.getSimName());
                    StateInGame.killPlayer(-11);
                    this.delayAlerts();
                    return;
                }
                case 5: {
                    StateInGame.passOut();
                    this.delayAlerts();
                    this.setBuff(n4, 4);
                    return;
                }
                case 9: {
                    this.adjustMotiveLevel(2, 0x320000);
                    this.removeActiveBuff(n3);
                    if (!StateInGame.isMapMode()) {
                        if (!StateInGame.m_playerSim.isReady()) {
                            StateInGame.m_playerSim.interrupt();
                        }
                        StateInGame.m_playerSim.queueSimAction(4, null, 0, 0);
                    }
                    this.delayAlerts();
                    return;
                }
            }
        }
        n4 = this.d_buffCount;
        for (n3 = 0; n3 < n4; ++n3) {
            int n6;
            n2 = n3;
            if ((byArray[n2] & 8) != 0 || !this.buffTriggerConditionsExist(n2) || (n6 = this.buffGetActiveSlot(n2)) != -1) continue;
            this.addActiveBuff(n2);
            this.delayAlerts();
            return;
        }
    }

    private void applyBuffsToMood() {
        int n;
        int[] nArray = this.m_moodLevelsF;
        ArrayHandler.fillArray(nArray, 0);
        for (n = 0; n < 6; ++n) {
            short s = this.m_buffsActive[n];
            if (s == -1) continue;
            byte[] byArray = this.d_buffEffectMood[s];
            byte[] byArray2 = this.d_buffEffectMoodAmount[s];
            int n2 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                byte by = byArray[i];
                nArray[by] = nArray[by] + (byArray2[i] << 16);
            }
        }
        for (n = 0; n < 2; ++n) {
            nArray[n] = IStringConstants.MathExt_clip(nArray[n], -6553600, 0x640000);
        }
        this.updateMood();
    }

    private void setBuff(int n, int n2) {
        int n3;
        short s = this.m_buffsActive[n];
        this.m_buffsActive[n] = (short)n2;
        this.m_buffTimers[n] = 0;
        StateInGame.m_playerSim.endBuff(s);
        StateInGame.m_playerSim.startBuff(n2);
        byte[][] byArray = this.d_buffEffectMotive;
        int[][] nArray = this.d_buffEffectMotiveFactors;
        int[] nArray2 = this.m_motiveDecayFactorsF;
        if (s != -1) {
            for (n3 = 0; n3 < byArray[s].length; ++n3) {
                byte by = byArray[s][n3];
                nArray2[by] = nArray2[by] + nArray[s][n3];
            }
        }
        if (n2 != -1) {
            for (n3 = 0; n3 < byArray[n2].length; ++n3) {
                byte by = byArray[n2][n3];
                nArray2[by] = nArray2[by] - nArray[n2][n3];
            }
            if (n2 == 8) {
                this.removeActiveBuff(7);
            } else if (n2 == 3) {
                this.removeActiveBuff(6);
            }
            if (n2 == 2) {
                StateInGame.showMessageBox(693, 368);
            } else if (n2 == 1) {
                StateInGame.showTutorialMessage((byte)11);
            } else if (n2 == 4) {
                StateInGame.showTutorialMessage((byte)12);
            } else if (n2 == 5) {
                StateInGame.showTutorialMessage((byte)13);
            } else if (n2 == 9) {
                StateInGame.showTutorialMessage((byte)14);
            } else if (n2 == 8) {
                StateInGame.showTutorialMessage((byte)15);
            } else if (n2 == 10) {
                StateInGame.showTutorialMessage((byte)16);
            }
        }
        this.applyBuffsToMood();
    }

    private void addActiveBuff(int n) {
        int n2;
        byte by = this.d_buffTimes[n];
        if (by != -1) {
            this.m_timeRanges[by] = -1;
        }
        if ((n2 = ArrayHandler.indexOf(-1, this.m_buffsActive)) != -1) {
            this.setBuff(n2, n);
        }
    }

    private void removeActiveBuff(int n) {
        int n2;
        byte by = this.d_buffTimes[n];
        if (by != -1) {
            this.m_timeRanges[by] = this.getGameTimeAbs();
        }
        if ((n2 = ArrayHandler.indexOf(n, this.m_buffsActive)) != -1) {
            this.setBuff(n2, -1);
        }
    }

    private boolean buffTriggerConditionsExist(int n) {
        byte by = this.d_buffTimeoutChains[n];
        if (by != -1 && this.buffGetActiveSlot(by) != -1) {
            return false;
        }
        int[] nArray = this.m_motiveLevelsF;
        byte[] byArray = this.d_buffTriggerMotives[n];
        int[] nArray2 = this.d_buffTriggerMotiveLevels[n];
        int n2 = byArray.length;
        if (n2 == 0) {
            return true;
        }
        for (int i = 0; i < n2; ++i) {
            byte by2 = byArray[i];
            int n3 = nArray2[i];
            int n4 = nArray[by2];
            if (n3 > 0 && n4 > n3) {
                return true;
            }
            if (n3 >= 0 || n4 >= -n3) continue;
            return true;
        }
        return false;
    }

    public int buffGetActiveSlot(int n) {
        short[] sArray = this.m_buffsActive;
        for (int i = 0; i < 6; ++i) {
            if (sArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    public int getBuff(int n) {
        return this.m_buffsActive[n];
    }

    public int getBuffDescString(int n) {
        return this.d_buffDescStringIds[n];
    }

    public int getBuffFlags(int n) {
        return this.d_buffFlags[n];
    }

    public int getTraitCount() {
        return 17;
    }

    public short getTraitDescString(int n) {
        return this.d_traitDescStrings[n];
    }

    private void initMoods() {
        if (this.m_moodLevelsF == null) {
            this.m_moodLevelsF = new int[4];
        }
        ArrayHandler.fillArray(this.m_moodLevelsF, 0x190000);
    }

    private void updateMood() {
        int n;
        int[] nArray = this.m_moodLevelsF;
        int n2 = Integer.MIN_VALUE;
        int n3 = -1;
        int n4 = Integer.MAX_VALUE;
        for (n = 0; n < 4; ++n) {
            if (nArray[n] > n2) {
                n2 = nArray[n];
            }
            if (nArray[n] >= n4) continue;
            n3 = n;
            n4 = nArray[n];
        }
        n = 3;
        int n5 = n2;
        if (n4 < -655360) {
            if (n4 < -3276800) {
                switch (n3) {
                    default: {
                        Debug.ASSERT(false, "invalid mood");
                    }
                    case 0: {
                        n = 5;
                        break;
                    }
                    case 1: {
                        n = 7;
                        break;
                    }
                    case 2: {
                        n = 9;
                        break;
                    }
                    case 3: {
                        n = 11;
                        break;
                    }
                }
            } else {
                switch (n3) {
                    default: {
                        Debug.ASSERT(false, "invalid mood");
                    }
                    case 0: {
                        n = 4;
                        break;
                    }
                    case 1: {
                        n = 6;
                        break;
                    }
                    case 2: {
                        n = 8;
                        break;
                    }
                    case 3: {
                        n = 10;
                    }
                }
            }
            n5 = n4;
        } else if (n2 > 655360) {
            n = n2 > 0x4B0000 ? 0 : (n2 > 0x280000 ? 1 : 2);
            n5 = n2;
        }
        this.m_moodDesc = n;
        this.m_moodLevel = n5;
    }

    public int getMoodDescStringId() {
        return MOODDESC_STRINGS[this.m_moodDesc];
    }

    public int getMoodLevel() {
        return this.m_moodLevel;
    }

    private void initRelationships() {
        int n = this.d_numSims;
        if (this.m_currentRelStates == null) {
            byte[] byArray = new byte[n];
            short[] sArray = new short[n];
            int[][] nArrayArray = new int[n][];
            int[][] nArrayArray2 = new int[n][];
            short[][] sArrayArray = new short[n][];
            byte[][] byArrayArray = new byte[n][];
            for (int i = 1; i < n; ++i) {
                nArrayArray[i] = new int[this.d_numRelLevels];
                nArrayArray2[i] = new int[this.d_commodityStringIds.length];
                sArrayArray[i] = new short[10];
                byArrayArray[i] = new byte[this.d_simTraits[i].length];
            }
            this.m_currentRelStates = byArray;
            this.m_currentRelStateFlags = sArray;
            this.m_currentRelLevelsF = nArrayArray;
            this.m_commodityLevelsF = nArrayArray2;
            this.m_actionHistories = sArrayArray;
            this.m_knownTraits = byArrayArray;
        }
        for (int i = 1; i < n; ++i) {
            this.m_currentRelStates[i] = 0;
            this.m_currentRelStateFlags[i] = 0;
            ArrayHandler.fillArray(this.m_currentRelLevelsF[i], 0);
            ArrayHandler.fillArray(this.m_actionHistories[i], -1);
            ArrayHandler.fillArray(this.m_knownTraits[i], 0);
        }
        this.m_commodityTimer = 0;
        this.m_lastNPC = -1;
        this.m_lastNPCTimer = 0;
    }

    private void updateRelationships(int n) {
        if (this.m_lastNPCTimer < 10000) {
            this.m_lastNPCTimer += StateInGame.getNormalTimeStep();
            if (this.m_lastNPCTimer >= 10000) {
                this.m_lastNPC = -1;
            }
        }
        this.m_commodityTimer += n;
        if (this.m_commodityTimer > 3000) {
            this.m_commodityTimer = 0;
        }
        int n2 = this.d_numSims;
        for (int i = 1; i < n2; ++i) {
            this.checkRelationshipTriggers(i);
            if (this.m_commodityTimer != 0) continue;
            int n3 = this.getDominantCommodity(i);
            this.decayCommodities(i, 327680);
            int n4 = this.getDominantCommodity(i);
            if (this.m_lastNPC != i || this.m_lastNPCTimer >= 10000 || n3 == n4) continue;
            short s = this.d_commodityStringIds[n4];
            int n5 = this.getSimName(i);
            GameConstants.TextHandler_dynamicString(-12, (int)s, n5);
            StateInGame.showTickerMessage(-12, -1);
        }
    }

    public void setLastNPC(int n) {
        this.m_lastNPC = n;
        this.m_lastNPCTimer = 0;
    }

    public int getLastNPC() {
        return this.m_lastNPC;
    }

    public boolean isLastNPCStillRelevant() {
        return this.m_lastNPCTimer < 10000;
    }

    private void decayCommodities(int n, int n2) {
        int[] nArray = this.m_commodityLevelsF[n];
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = i;
            nArray[n3] = nArray[n3] - n2;
            if (nArray[i] >= 0) continue;
            nArray[i] = 0;
        }
    }

    private boolean checkRelationshipStranger(int n) {
        if (this.m_currentRelStates[n] == 0) {
            int n2 = 1;
            if (this.m_currentRelLevelsF[n][0] < 0) {
                n2 = 2;
            }
            this.relationshipStateTransition(n, n2);
            return true;
        }
        return false;
    }

    public void adjustRelLevels(int n, int n2, int n3) {
        int[] nArray = this.m_currentRelLevelsF[n];
        int n4 = nArray[0] + (n2 << 16);
        int n5 = nArray[1] + (n3 << 16);
        nArray[0] = IStringConstants.MathExt_clip(n4, -1966080, 0x1E0000);
        nArray[1] = IStringConstants.MathExt_clip(n5, -327680, 0x1E0000);
    }

    private boolean checkRelationshipTriggers(int n) {
        byte by = this.m_currentRelStates[n];
        int[] nArray = this.m_currentRelLevelsF[n];
        byte[] byArray = this.d_relStateTriggerToStates[by];
        byte[] byArray2 = this.d_relStateTriggerLevels[by];
        short[] sArray = this.d_relStateTriggerLevelValues[by];
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            boolean bl = true;
            byte by2 = byArray2[i];
            short s = sArray[i];
            int n3 = nArray[by2];
            boolean bl2 = s < 0;
            int n4 = s << 16;
            if (bl2 && n3 > n4 || !bl2 && n3 < n4) {
                bl = false;
            }
            if (!bl) continue;
            int n5 = byArray[i];
            if (n5 == 1 && nArray[0] < 0) {
                n5 = 2;
            }
            this.relationshipStateTransition(n, n5);
            return true;
        }
        return false;
    }

    public int[] gatherRelationshipInfo() {
        int[] nArray = new int[]{8, 16, 32, 64};
        int[] nArray2 = new int[nArray.length];
        for (int i = 1; i < this.d_numSims; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                if (!this.hasSimGotFlag(i, nArray[j]) || (this.d_relStateFlags[this.m_currentRelStates[i]] & 0x10) == 0) continue;
                int n = j;
                nArray2[n] = nArray2[n] + 1;
            }
        }
        return nArray2;
    }

    private void relationshipStateTransition(int n, int n2) {
        int n3;
        int n4;
        byte[] byArray = this.m_currentRelStates;
        byte by = byArray[n];
        byArray[n] = (byte)n2;
        ArrayHandler.fillArray(this.m_currentRelLevelsF[n], 0);
        if (n2 == 12 && this.hasSimGotFlag(n, 120)) {
            this.dreamCompleteEvent(33);
        }
        if ((this.getRelStateFlags(by) & 0x10) == 0 && (this.getRelStateFlags(n2) & 0x10) != 0) {
            if (this.hasSimGotFlag(n, 8)) {
                this.dreamCompleteEvent(4);
            } else if (this.hasSimGotFlag(n, 16)) {
                this.dreamCompleteEvent(5);
            } else if (this.hasSimGotFlag(n, 32)) {
                this.dreamCompleteEvent(6);
            } else if (this.hasSimGotFlag(n, 64)) {
                this.dreamCompleteEvent(7);
            }
            if (this.getPersona() == 0) {
                int[] nArray = new int[]{8, 16, 32, 64};
                boolean[] blArray = new boolean[nArray.length];
                for (n4 = 1; n4 < this.d_numSims; ++n4) {
                    for (n3 = 0; n3 < blArray.length; ++n3) {
                        if (blArray[n3] || !this.hasSimGotFlag(n4, nArray[n3]) || (this.d_relStateFlags[byArray[n4]] & 0x10) == 0) continue;
                        blArray[n3] = true;
                        break;
                    }
                    if (!blArray[0] || !blArray[1] || !blArray[2] || !blArray[3]) continue;
                    this.dreamCompleteEvent(32);
                    break;
                }
            }
        }
        if (by == 6 && n2 == 7) {
            int n5 = 0;
            for (int i = 1; i < this.d_numSims; ++i) {
                if (this.getRelState(i) != 7) continue;
                ++n5;
            }
            if (n5 >= 10) {
                this.dreamCompleteEvent(39);
            }
        }
        if ((this.getRelStateFlags(by) & 8) == 0 && (this.getRelStateFlags(n2) & 8) != 0) {
            this.dreamCompleteEvent(13);
        }
        if ((this.getRelStateFlags(by) & 4) == 0 && (this.getRelStateFlags(n2) & 4) != 0 && this.hasSimGotFlag(n, 32)) {
            this.dreamCompleteEvent(43);
        }
        int n6 = 0;
        boolean bl = true;
        for (n4 = 1; n4 < byArray.length; ++n4) {
            n3 = byArray[n4];
            boolean bl2 = (this.d_relStateFlags[n3] & 1) != 0;
            boolean bl3 = bl = bl && bl2;
            if ((this.d_relStateFlags[n3] & 2) == 0) continue;
            ++n6;
        }
        if (n6 >= 12) {
            this.dreamCompleteEvent(35);
        }
        if (bl) {
            this.dreamCompleteEvent(38);
        }
        if (n2 == 12) {
            Event.triggerEvent(1, -1, n);
        } else {
            n4 = this.d_relStateToStrings[n2];
            n3 = this.d_simNameStrings[n];
            GameConstants.TextHandler_dynamicString(-11, n4, n3);
            StateInGame.showMessageBox(-11, this.getRelStateDescString(n2));
        }
    }

    private boolean actionEffectEvent(int n, int n2, int n3) {
        byte by = this.m_currentRelStates[n];
        int n4 = -1;
        if (n2 == 54) {
            Debug.ASSERT(by == 10, "non-partners becoming fiancees");
            n4 = 11;
        } else if (n2 == 55) {
            Debug.ASSERT(by == 11, "non-fiancees getting married");
            n4 = 12;
        } else if (n2 == 65) {
            Debug.ASSERT(by == 12, "non-spouse getting divorced");
            n4 = 13;
        } else if (n2 == 64) {
            Debug.ASSERT(by == 9 || by == 10 || by == 11, "non-date/partner/fiancee breakup");
            n4 = 14;
        } else if (n2 == 66) {
            this.setSimCurRelStateFlags(n, 2);
            StateInGame.showMessageBox(673, 672);
        } else if (n2 == 67) {
            this.unsetSimCurRelStateFlags(n, 2);
            StateInGame.showMessageBox(674, 669);
        } else if (n2 == 68) {
            if ((n3 & 0x1000) != 0) {
                StateInGame.showMessageBox(537, this.getSimName(n));
            } else {
                byte by2 = this.d_simCareerLevels[0];
                byte by3 = this.d_simCareers[0];
                if (by2 < this.d_careerLevelFlags[by3].length - 1) {
                    StateInGame.showJobOffer(by3, by2 + 1, false);
                }
            }
        } else if (n2 == 69) {
            StateInGame.showQuitJob();
        }
        if (n4 != -1) {
            this.relationshipStateTransition(n, n4);
            return true;
        }
        return false;
    }

    public void relationshipAction(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        int n6 = -1;
        int n7 = -1;
        short s = 0;
        boolean bl = false;
        int n8 = this.d_actionFlags[n3];
        if (n2 == 0) {
            if ((n8 & 0x80000) == 0) {
                if (n3 == 18) {
                    n5 = 35;
                    n6 = 11;
                } else {
                    n5 = 19;
                    n6 = 10;
                }
            }
            this.setSimCurRelStateFlags(n, 1);
            this.setSimCurRelStateFlags(0, 1);
            if (this.checkRelationshipStranger(n)) {
                bl = true;
            }
        } else if (n != 0) {
            if ((n8 & 0x80000) == 0) {
                n5 = 20;
                n6 = 10;
            }
        } else {
            n4 = this.calcActionEffect(n2, n3);
            if (n4 == -1) {
                n6 = (n8 & 0x200000) != 0 ? -1 : -1;
            } else {
                byte by;
                int n9;
                int n10;
                boolean bl2 = false;
                byte by2 = this.d_actionConditionTraits[n3][n4];
                if (by2 != -1) {
                    bl2 = this.tryDiscoverTrait(n2, by2);
                }
                short[] sArray = this.m_actionHistories[n2];
                for (n10 = 9; n10 > 0; --n10) {
                    sArray[n10] = sArray[n10 - 1];
                }
                sArray[0] = (short)n3;
                if ((n8 & 0x10) != 0) {
                    this.unsetSimCurRelStateFlags(n2, 1);
                } else {
                    this.setSimCurRelStateFlags(n2, 1);
                    this.setSimCurRelStateFlags(0, 1);
                }
                n6 = this.d_actionResponseActions[n3][n4];
                n10 = 1;
                MapObjectSim mapObjectSim = StateInGame.findSim(n2);
                if (n6 == -1 && mapObjectSim != null && mapObjectSim.isSleeping()) {
                    n10 = 0;
                }
                int n11 = 0;
                if (n10 != 0) {
                    int n12;
                    n9 = this.d_actionAffectFriendships[n3][n4];
                    by = this.d_actionAffectRomances[n3][n4];
                    this.adjustRelLevels(n2, n9, by);
                    n11 = n9 + by;
                    if (by > 0) {
                        n5 |= 0x40;
                    }
                    int n13 = this.getDominantCommodity(n2);
                    byte by3 = this.d_actionAffectCommodities[n3][n4];
                    byte by4 = this.d_actionAffectCommodityAmounts[n3][n4];
                    int[] nArray2 = this.m_commodityLevelsF[n2];
                    for (n12 = 0; n12 < nArray2.length; ++n12) {
                        if (n12 == by3) {
                            byte by5 = by3;
                            nArray2[by5] = nArray2[by5] + (by4 << 16);
                            if (nArray2[by3] <= 0xC80000) continue;
                            nArray2[by3] = 0xC80000;
                            continue;
                        }
                        int n14 = n12;
                        nArray2[n14] = nArray2[n14] - 655360;
                        if (nArray2[n12] >= 0) continue;
                        nArray2[n12] = 0;
                    }
                    n12 = this.getDominantCommodity(n2);
                    if (n12 != n13 && !bl2) {
                        short s2 = this.d_commodityStringIds[n12];
                        int n15 = this.getSimName(n2);
                        GameConstants.TextHandler_dynamicString(-12, (int)s2, n15);
                        StateInGame.showTickerMessage(-12, -1);
                        if (n12 == 2) {
                            this.setSimCurRelStateFlags(n2, 64);
                        }
                        if (n12 == 1) {
                            this.setSimCurRelStateFlags(n2, 128);
                        }
                    }
                }
                if (((s = this.d_actionEffectFlags[n3][n4]) & 8) != 0) {
                    if (this.actionEffectEvent(n2, n3, s)) {
                        bl = true;
                    }
                } else if (n3 == 68 && (by = this.d_simCareerLevels[0]) < this.d_careerLevelFlags[n9 = this.d_simCareers[0]].length - 1) {
                    StateInGame.showJobRaiseFail(n9, by + 1);
                }
                if (this.checkRelationshipTriggers(n2)) {
                    bl = true;
                } else if ((n8 & 0x200000) == 0 && this.checkRelationshipStranger(n2)) {
                    bl = true;
                }
                if (bl) {
                    n7 = this.d_relStateEffectAnims[this.m_currentRelStates[n2]];
                }
                if (n7 != -1) {
                    n5 |= 3;
                } else {
                    n9 = 3 + n11;
                    n9 = IStringConstants.MathExt_clip(n9, 0, 6);
                    n5 |= n9;
                }
                n5 = n5 < 3 ? (n5 |= 0x20) : (n5 |= 0x10);
            }
        }
        if (n6 != -1) {
            n4 = -1;
            if (n == 0) {
                n4 = n2;
            } else if (n2 == 0) {
                n4 = n;
            }
            if (n4 != -1) {
                this.adjustMotiveLevel(4, 0x140000);
                this.setLastNPC(n4);
            }
        }
        nArray[0] = n5;
        nArray[1] = n6;
        nArray[2] = n7;
    }

    public int getRelStateDescString(int n) {
        return this.d_relStateDescStrings[n];
    }

    public int getRelStateFlags(int n) {
        return this.d_relStateFlags[n];
    }

    public int getRelState(int n) {
        return this.m_currentRelStates[n];
    }

    public void getRelationshipLevels(int n, int[] nArray) {
        int n2 = this.getRelState(n);
        int[] nArray2 = this.m_currentRelLevelsF[n];
        byte[] byArray = this.d_relStateTriggerToStates[n2];
        byte[] byArray2 = this.d_relStateTriggerLevels[n2];
        short[] sArray = this.d_relStateTriggerLevelValues[n2];
        int n3 = 0;
        int n4 = byArray.length;
        for (int i = 0; i < n4; ++i) {
            byte by = byArray2[i];
            short s = sArray[i];
            int n5 = nArray2[by] >> 16;
            if ((s <= 0 || n5 <= 0) && (s >= 0 || n5 >= 0)) continue;
            nArray[n3 + 0] = byArray[i];
            nArray[n3 + 1] = IStringConstants.MathExt_Fdiv(n5 << 16, s << 16);
            n3 += 2;
        }
        nArray[n3] = -1;
    }

    public boolean isWelcome() {
        if (!StateInGame.isHouseMode()) {
            return true;
        }
        int n = Main.m_simWorld.getHouseId();
        int n2 = this.getSimCount();
        for (int i = 1; i < n2; ++i) {
            int n3;
            int n4;
            if (this.getSimHome(i) != n || ((n4 = this.getRelStateFlags(n3 = this.getRelState(i))) & 0x20) == 0) continue;
            return true;
        }
        return n == 0;
    }

    public void setHouseCurRelStateFlags(int n, int n2) {
        for (int i = 1; i < this.d_numSims; ++i) {
            if (this.d_simHomes[i] != n) continue;
            int n3 = i;
            this.m_currentRelStateFlags[n3] = (short)(this.m_currentRelStateFlags[n3] | n2);
        }
    }

    public void setSimCurRelStateFlags(int n, int n2) {
        int n3 = n;
        this.m_currentRelStateFlags[n3] = (short)(this.m_currentRelStateFlags[n3] | n2);
    }

    private void unsetSimCurRelStateFlags(int n, int n2) {
        int n3 = n;
        this.m_currentRelStateFlags[n3] = (short)(this.m_currentRelStateFlags[n3] & ~n2);
    }

    public boolean getSimCurRelStateFlags(int n, int n2) {
        return (this.m_currentRelStateFlags[n] & n2) != 0;
    }

    public int getRelationshipNthCount() {
        Debug.ASSERT(true, "stranger should be 0");
        Debug.ASSERT(this.m_currentRelStates[0] == 0, "player rel state should be stranger");
        return this.m_currentRelStates.length - ArrayHandler.countOf(0, this.m_currentRelStates);
    }

    public int getRelationshipNthItem(int n) {
        return ArrayHandler.indexOfNthElement(n, this.m_currentRelStates, 0);
    }

    public int getActionWorldArg(int n) {
        return this.d_actionWorldArgs[n];
    }

    public int getActionString(int n) {
        return this.d_actionStringIds[n];
    }

    public int getActionFlags(int n) {
        return this.d_actionFlags[n];
    }

    public int getActionPhaseCount(int n) {
        return this.d_actionPhases[n].length;
    }

    public int getActionPhase(int n, int n2) {
        return this.d_actionPhases[n][n2];
    }

    public void createContextMenu(MapObject mapObject, short[] sArray, short[] sArray2) {
        if (mapObject.getFlag(16384)) {
            MapObjectSim mapObjectSim = (MapObjectSim)mapObject;
            this.createSimContextMenu(mapObjectSim, sArray, sArray2);
        } else {
            this.createObjectContextMenu(mapObject, sArray, sArray2);
        }
    }

    private void createSimContextMenu(MapObjectSim mapObjectSim, short[] sArray, short[] sArray2) {
        int n = this.d_numActions;
        short[] sArray3 = this.d_actionStringIds;
        int[] nArray = this.d_actionFlags;
        int n2 = mapObjectSim.getId();
        boolean bl = mapObjectSim.isSleeping();
        this.setLastNPC(n2);
        short s = this.d_simNameStrings[n2];
        Main.menuClear(sArray, s);
        Main.menuClear(sArray2, s);
        if (StateInGame.isMapMode()) {
            int n3 = 123;
            Main.menuAppendItem(sArray, sArray3[n3]);
            Main.menuAppendItem(sArray2, n3);
            return;
        }
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            if ((nArray[i] & 1) == 0 || (nArray[i] & 4) == 0 && bl || (nArray[i] & 4) != 0 && !bl || sArray3[i] == 4) continue;
            boolean bl2 = true;
            int n6 = nArray[i];
            if (bl2) {
                if ((n6 & 8) != 0) {
                    bl2 = !this.getSimCurRelStateFlags(n2, 1);
                } else if ((n6 & 0x10) != 0) {
                    bl2 = this.getSimCurRelStateFlags(n2, 1);
                }
            }
            if ((n6 & 0x1F800000) != 0) {
                n5 = this.getPersonaActionFlags();
                boolean bl3 = bl2 = (n6 & n5) != 0;
            }
            if (bl2) {
                n5 = this.calcActionEffect(n2, i);
                boolean bl4 = bl2 = n5 != -1;
            }
            if (bl2) {
                n5 = this.d_simCareers[0];
                if ((n6 & 0x4000) != 0) {
                    bl2 = n5 != -1 ? (n4 = this.getCareerBoss(n5)) == n2 : false;
                }
                if (bl2 && (n6 & 0x8000) != 0) {
                    bl2 = n5 != -1 ? this.getSimCareer(n2) == n5 : false;
                }
            }
            if (bl2) {
                n5 = Main.m_simWorld.getHouseId();
                n4 = this.getSimHome(n2);
                if ((n6 & 0x30000) == 196608) {
                    bl2 = this.getSimCurRelStateFlags(n2, 2);
                } else if ((n6 & 0x10000) != 0) {
                    bl2 = n5 == 0 && n4 != 0;
                } else if ((n6 & 0x20000) != 0) {
                    boolean bl5 = bl2 = n5 != 0 && n4 == n5;
                }
            }
            if (bl2) {
                switch (i) {
                    default: {
                        break;
                    }
                    case 68: {
                        bl2 = this.d_simCareerLevels[0] < this.d_careerLevelFlags[this.d_simCareers[0]].length - 1;
                        break;
                    }
                    case 66: {
                        bl2 = ArrayHandler.indexOfFlags(2, this.m_currentRelStateFlags) == -1;
                        break;
                    }
                    case 67: {
                        bl2 = this.m_currentRelStates[n2] != 12;
                        break;
                    }
                    case 54: {
                        bl2 = ArrayHandler.indexOf(12, this.m_currentRelStates) == -1;
                        break;
                    }
                    case 63: {
                        MapObjectSim mapObjectSim2 = StateInGame.getPlayerSim();
                        n4 = Math.abs(mapObjectSim.getPosX() - mapObjectSim2.getPosX());
                        int n7 = Math.abs(mapObjectSim.getPosZ() - mapObjectSim2.getPosZ());
                        int n8 = 524288 << 2;
                        bl2 = n4 + n7 > n8;
                        break;
                    }
                }
            }
            if (!bl2) continue;
            Main.menuAppendItem(sArray, sArray3[i]);
            Main.menuAppendItem(sArray2, i);
        }
    }

    private void createObjectContextMenu(MapObject mapObject, short[] sArray, short[] sArray2) {
        MapObject mapObject2;
        int n;
        MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
        short[] sArray3 = this.d_actionStringIds;
        int[] nArray = this.d_actionFlags;
        int n2 = mapObject.getTypeString();
        Main.menuClear(sArray, n2);
        Main.menuClear(sArray2, n2);
        int n3 = mapObject.getType();
        int n4 = Main.m_simWorld.getObjectActions(n3, this.objectActions);
        int n5 = Main.m_simWorld.getObjectFlags(n3);
        if ((n5 & 0x2000000) != 0 && mapObject.getRuntimeFlag(256)) {
            Main.menuAppendItem(sArray, sArray3[84]);
            Main.menuAppendItem(sArray2, 84);
        }
        if ((n5 & 0x4000000) != 0 && mapObject.getRuntimeFlag(512)) {
            Main.menuAppendItem(sArray, sArray3[79]);
            Main.menuAppendItem(sArray2, 79);
        }
        for (int i = 0; i < n4; ++i) {
            int n6;
            n = this.objectActions[i];
            Debug.ASSERT(sArray3[n] != 4, "invalid action");
            int n7 = nArray[n];
            if ((n7 & 1) != 0 || (n7 & 0x20) != 0 && !mapObject.getRuntimeFlag(64) || (n7 & 0x40) != 0 && mapObject.getRuntimeFlag(64) || (n7 & 0x80) != 0 && !mapObject.isIdle() || (n7 & 0x100) != 0 && !mapObject.isActive() || (n7 & 0x200) != 0 && mapObject.getRuntimeFlag(256) || (n7 & 0x400) != 0 && mapObject.getRuntimeFlag(512) || (n7 & 0x1000) != 0 && !this.isPlaceForWork(mapObject, 0) || (n7 & 0x2000) != 0 && !this.isTimeForWork(mapObject, 0) || (n7 & 0x800) != 0 && this.isPlaceForWork(mapObject, 0) || (n7 & 0x20000) != 0 && Main.m_simWorld.getHouseId() != 0 || (n7 & 0x10000) != 0 && Main.m_simWorld.getHouseId() == 0 || (n == 80 || n == 81) && (!this.initMsgHasShownAtCounter || this.timeArrivedInCairo >= 0) || n == 75 && this.initMsgHasShownAtCounter || n == 121 && (Main.getNextHouseId() == 8 || !StateInGame.isHouseMode()) || n == 122 && !StateInGame.isZoomMapMode() || (n7 & 0x1F800000) != 0 && (n7 & (n6 = this.getPersonaActionFlags())) == 0 || n == 102 && mapObject.getRuntimeFlag(16384) || n == 103 && mapObject.getRuntimeFlag(32768) || n == 116 && !this.getSimCurRelStateFlags(0, 1) && Main.m_simWorld.getHouseId() != 0 && !Main.isAirport(Main.m_simWorld.getHouseId()) || n == 119 && (this.getSimCurRelStateFlags(0, 1) || Main.m_simWorld.getHouseId() == 0) || (n == 118 || n == 119) && Main.isAirport(Main.m_simWorld.getHouseId())) continue;
            if (n == 118) {
                n6 = Main.m_simWorld.coordWorldToWorldTileX(mapObjectSim.getPosX());
                int n8 = Main.m_simWorld.coordWorldToWorldTileZ(mapObjectSim.getPosZ());
                if ((Main.m_simWorld.getAttribute(n6, n8) & 0x10) != 0) continue;
            }
            if (n == 68) {
                Event.PMDebug_println("Asking for raise!");
            }
            Main.menuAppendItem(sArray, sArray3[n]);
            Main.menuAppendItem(sArray2, n);
        }
        if ((n5 & 0x1000) != 0 && ((mapObject2 = mapObjectSim.getOccupiedObject()) == null || mapObject2 != null && !mapObject2.equals(mapObject) || StateInGame.m_mapMode == 2)) {
            n = 76;
            Main.menuAppendItem(sArray, sArray3[n]);
            Main.menuAppendItem(sArray2, n);
        }
        if (sArray[0] == 0) {
            Main.menuAppendItem(sArray, 240);
            Main.menuAppendItem(sArray2, -4);
        }
    }

    public void compactContextMenu(short[] sArray, short[] sArray2, short[] sArray3) {
        Main.menuClear(sArray, sArray3[1]);
        Main.menuClear(sArray2, 4);
        short[] sArray4 = this.d_actionStringIds;
        short[] sArray5 = this.d_actionGroupStringIds;
        int n = sArray3[0];
        for (int i = 0; i < n; ++i) {
            short s = sArray3[5 + i];
            short s2 = sArray5[s];
            if (s2 != 4 && this.countContextMenuGroup(sArray3, s2) >= 2) {
                if (Main.menuContains(sArray, s2)) continue;
                Main.menuAppendItem(sArray, s2);
                Main.menuAppendItem(sArray2, -2);
                continue;
            }
            Main.menuAppendItem(sArray, sArray4[s]);
            Main.menuAppendItem(sArray2, s);
        }
    }

    private int countContextMenuGroup(short[] sArray, int n) {
        short[] sArray2 = this.d_actionGroupStringIds;
        int n2 = 0;
        int n3 = sArray[0];
        for (int i = 0; i < n3; ++i) {
            short s = sArray[i + 5];
            short s2 = sArray2[s];
            if (s2 != n) continue;
            ++n2;
        }
        return n2;
    }

    public void filterContextMenu(short[] sArray, short[] sArray2, short[] sArray3, int n) {
        Main.menuClear(sArray, n);
        Main.menuClear(sArray2, n);
        short[] sArray4 = this.d_actionStringIds;
        short[] sArray5 = this.d_actionGroupStringIds;
        int n2 = sArray3[0];
        for (int i = 0; i < n2; ++i) {
            short s = sArray3[5 + i];
            short s2 = sArray5[s];
            if (s2 != n) continue;
            Main.menuAppendItem(sArray, sArray4[s]);
            Main.menuAppendItem(sArray2, s);
        }
    }

    public void createCallContextMenu(short[] sArray, short[] sArray2, int n) {
        short s = this.d_actionStringIds[n];
        Main.menuClear(sArray, s);
        Main.menuClear(sArray2, s);
        int n2 = Main.m_simWorld.getHouseId();
        for (int i = 1; i < this.d_numSims; ++i) {
            if (this.m_currentRelStates[i] == 0 || this.getSimHome(i) == n2) continue;
            Main.menuAppendItem(sArray, this.d_simNameStrings[i]);
            Main.menuAppendItem(sArray2, n);
        }
    }

    public int getDominantCommodity(int n) {
        int[] nArray = this.m_commodityLevelsF[n];
        int n2 = nArray.length;
        int n3 = 3;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] <= n4) continue;
            n4 = nArray[i];
            n3 = i;
        }
        return n3;
    }

    private int relStateToRelStateBit(int n) {
        switch (n) {
            default: {
                Debug.ASSERT(false, "invalid state");
            }
            case 0: {
                return 2;
            }
            case 1: {
                return 4;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 64;
            }
            case 7: {
                return 128;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 256;
            }
            case 10: {
                return 512;
            }
            case 2: {
                return 32;
            }
            case 3: {
                return 1024;
            }
            case 4: {
                return 2048;
            }
            case 11: {
                return 4096;
            }
            case 12: {
                return 8192;
            }
            case 13: {
                return 16384;
            }
            case 14: 
        }
        return 32768;
    }

    private boolean checkActionHistory(int n, int n2, int n3, int n4) {
        short[] sArray = this.m_actionHistories[n];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            if (sArray[i] != n2 || ++n5 < n3) continue;
            return true;
        }
        return false;
    }

    private int calcActionEffect(int n, int n2) {
        int n3 = this.getDominantCommodity(n);
        byte by = this.m_currentRelStates[n];
        int n4 = this.relStateToRelStateBit(by);
        byte[] byArray = this.d_actionConditionCommodities[n2];
        byte[] byArray2 = this.d_actionConditionTraits[n2];
        int[] nArray = this.d_actionConditionRelStates[n2];
        short[] sArray = this.d_actionEffectFlags[n2];
        for (int i = byArray.length - 1; i >= 0; --i) {
            int n5;
            int n6;
            int n7;
            int n8;
            byte by2;
            byte by3 = byArray[i];
            if (by3 != -1 && by3 != n3 || (by2 = byArray2[i]) != -1 && this.hasSimGotTrait(n, by2) == -1 || (n8 = nArray[i]) != 0 && (n8 & n4) == 0) continue;
            short s = sArray[i];
            if ((s & 7) != 0) {
                int n9 = 3;
                n7 = 6;
                if ((s & 1) != 0) {
                    n9 = 2;
                    n7 = 4;
                } else if ((s & 4) != 0) {
                    n9 = 6;
                    n7 = 10;
                }
                if (!this.checkActionHistory(n, n2, n9, n7)) continue;
            }
            if ((s & 0x1F0) != 0) {
                n7 = (s & 0x10) != 0 ? 0 : ((s & 0x20) != 0 ? 1 : ((s & 0x40) != 0 ? 2 : ((s & 0x80) != 0 ? 3 : 4)));
                n6 = this.m_skillLevelsF[n7];
                int n10 = n5 = (s & 0x200) != 0 ? 196608 : 65536;
                if (n6 < n5) continue;
            }
            if ((s & 0xC00) != 0 && ((s & 0x800) == 0 ? !this.buffTriggerConditionsExist(1) : !this.buffTriggerConditionsExist(4))) continue;
            if (n2 == 68 && (s & 8) != 0 && (s & 0x1000) == 0 && ((n6 = this.d_simCareers[0]) == -1 || (n5 = this.d_simCareerLevels[0]) >= this.d_careerLevelDescStrings[n6].length - 1 || !this.careerRequirementsMet(n6, n5 + 1))) continue;
            return i;
        }
        return -1;
    }

    public boolean actionAccept(int n, int n2, int n3) {
        if (n == 0) {
            int n4 = this.calcActionEffect(n2, n3);
            return (this.d_actionEffectFlags[n3][n4] & 0x1000) == 0;
        }
        return true;
    }

    public int getActionTalkIcon(int n) {
        return 87;
    }

    private void initSims() {
        if (this.d_simTraits[0].length != 5) {
            this.d_simTraits[0] = new byte[5];
            ArrayHandler.fillArray(this.d_simTraits[0], -1);
        }
    }

    public int getSimCount() {
        return this.d_numSims;
    }

    public int getSimName(int n) {
        return this.d_simNameStrings[n];
    }

    public int getSimPartner(int n) {
        return this.d_simPartners[n];
    }

    public int getSimMacromapColor(int n) {
        return this.d_simMacromapColors[n];
    }

    public int getSimAttribute(int n, int n2) {
        if (n == -1) {
            n = 0;
        }
        return this.d_simAttributes[n][n2];
    }

    public int getSimHome(int n) {
        if (this.getSimCurRelStateFlags(n, 2)) {
            return 0;
        }
        return this.d_simHomes[n];
    }

    public int getSimCareer(int n) {
        return this.d_simCareers[n];
    }

    public int getSimCareerLevel(int n) {
        return this.d_simCareerLevels[n];
    }

    public int getPresetCount() {
        return this.d_numPresets;
    }

    public byte[] getAttributePreset(int n) {
        return this.d_simPresets[n];
    }

    public void setPlayerSimAttribute(int n, int n2) {
        this.d_simAttributes[0][n] = (byte)n2;
    }

    public boolean hasSimGotFlag(int n, int n2) {
        return (this.d_simFlags[n] & n2) != 0;
    }

    public int hasSimGotTrait(int n, int n2) {
        return ArrayHandler.indexOf(n2, this.d_simTraits[n]);
    }

    public boolean isTraitDiscovered(int n, int n2) {
        int n3 = this.hasSimGotTrait(n, n2);
        if (n3 != -1) {
            return this.m_knownTraits[n][n3] >= 3;
        }
        return false;
    }

    public boolean tryDiscoverTrait(int n, int n2) {
        byte[] byArray = this.m_knownTraits[n];
        int n3 = this.hasSimGotTrait(n, n2);
        if (byArray[n3] < 3) {
            int n4 = n3;
            byArray[n4] = (byte)(byArray[n4] + 1);
            if (byArray[n3] == 3) {
                int n5 = this.getSimName(n);
                short s = this.d_traitDescStrings[n2];
                GameConstants.TextHandler_dynamicString(-12, 379, n5, s);
                StateInGame.showTickerMessage(-12, -1);
                int n6 = 120;
                if (this.hasSimGotFlag(n, n6)) {
                    this.dreamCompleteEvent(24);
                }
                return true;
            }
        }
        return false;
    }

    public int getSimTraitCount(int n) {
        return this.d_simTraits[n].length;
    }

    public int getSimTrait(int n, int n2) {
        return this.d_simTraits[n][n2];
    }

    public int getNumPlayerTraits() {
        byte[] byArray = this.d_simTraits[0];
        return byArray.length - ArrayHandler.countOf(-1, byArray);
    }

    public void traitPlayerAdd(int n) {
        if (this.hasSimGotTrait(0, n) == -1) {
            int n2;
            short s = this.d_traitExcludes[n];
            if (s != -1) {
                this.traitPlayerRemove(s);
            }
            if ((n2 = this.hasSimGotTrait(0, -1)) != -1) {
                this.d_simTraits[0][n2] = (byte)n;
            }
        }
    }

    public void traitPlayerRemove(int n) {
        int n2 = this.hasSimGotTrait(0, n);
        if (n2 != -1) {
            this.d_simTraits[0][n2] = -1;
        }
    }

    public int getSimByName(int n) {
        return ArrayHandler.indexOf(n, this.d_simNameStrings, 1);
    }

    public boolean acceptInvitation(int n) {
        byte by = this.m_currentRelStates[n];
        return by != 2 && by != 3 && by != 4 && (this.getTimeFlags(n) & 0x10) == 0 && (this.getTimeFlags(n) & 8) != 0;
    }

    public void update(int n, boolean bl) {
        this.updateGameTime(n);
        this.updateCareer(n);
        if (!this.isDelayed()) {
            this.updateMotives(n);
            this.updateBuffs(n);
            this.updateRelationships(n);
            this.updateDreams(n);
        }
        if (this.isDelayed()) {
            this.m_timeoutDelay = Math.max(this.m_timeoutDelay - n, 0);
        }
    }

    public void newScene() {
        this.setFastforward(false);
        this.setLastNPC(-1);
        ArrayHandler.fillArray(this.m_motiveDecayAdjustsF, 0);
        for (int i = 1; i < this.d_numSims; ++i) {
            this.unsetSimCurRelStateFlags(i, 1);
            ArrayHandler.fillArray(this.m_commodityLevelsF[i], 0);
            ArrayHandler.fillArray(this.m_actionHistories[i], -1);
        }
        this.unsetSimCurRelStateFlags(0, 1);
        this.delayAlerts();
    }

    public void delayAlerts() {
        this.m_timeoutDelay = 2500;
    }

    public boolean isDelayed() {
        return this.m_timeoutDelay != 0;
    }

    public void newGame() {
        int n = this.getTaskCount();
        int n2 = this.getPersonaFlags();
        for (int i = 0; i < n; ++i) {
            if ((this.getTaskFlags(i) & n2) == 0) continue;
            Main.setGoalDiscovered(i);
        }
        this.setQuickLinkVisited(35);
    }

    private void initObjectValues() {
        if (this.m_objectStateIds == null) {
            this.m_objectStateIds = new short[100];
            this.m_objectStateValues = new int[100];
            this.m_objectStateTimes = new int[100];
        }
        ArrayHandler.fillArray(this.m_objectStateIds, -1);
        ArrayHandler.fillArray(this.m_objectStateValues, 0);
        ArrayHandler.fillArray(this.m_objectStateTimes, 0);
    }

    public void saveObjectValue(int n, int n2, int n3) {
        Debug.ASSERT(n2 >= 0, "invalid id");
        int n4 = n << 8 | n2;
        int n5 = ArrayHandler.indexOf(n4, this.m_objectStateIds);
        if (n3 == 0 && n5 != -1) {
            this.removeObjectValue(n, n2);
        } else {
            if (n5 == -1) {
                n5 = ArrayHandler.indexOf(-1, this.m_objectStateIds);
                Debug.ASSERT(n5 != -1, "no room in persistant object data");
            }
            this.m_objectStateIds[n5] = (short)n4;
            this.m_objectStateValues[n5] = n3;
            this.m_objectStateTimes[n5] = this.getGameTimeAbs();
        }
    }

    public int getObjectValue(int n, int n2) {
        Debug.ASSERT(n2 >= 0, "invalid id");
        int n3 = n << 8 | n2;
        int n4 = ArrayHandler.indexOf(n3, this.m_objectStateIds);
        if (n4 == -1) {
            return 0;
        }
        return this.m_objectStateValues[n4];
    }

    public void removeObjectValue(int n, int n2) {
        int n3 = n << 8 | n2;
        int n4 = ArrayHandler.indexOf(n3, this.m_objectStateIds);
        if (n4 != -1) {
            this.m_objectStateIds[n4] = -1;
            this.m_objectStateValues[n4] = 0;
            this.m_objectStateTimes[n4] = 0;
        }
    }

    public void resetRMSGameData() {
        this.initGameTimeMoney();
        this.initInventory();
        this.initSkills();
        this.initCareer();
        this.m_persona = (byte)-1;
        ArrayHandler.fillArray(this.d_simTraits[0], -1);
        this.initDreams();
        this.initMotives();
        this.initBuffs();
        this.initMoods();
        this.initSims();
        this.initRelationships();
        this.initObjectValues();
        ArrayHandler.fillArray(this.d_simAttributes[0], 0);
        this.initMsgHasShownAtHome = false;
        this.initMsgHasShownAtAirport = false;
        this.initMsgHasShownAtCounter = false;
        this.timeArrivedInCairo = 0;
        this.toursTried = 0;
        this.m_rmsGSBonusUnlocked = false;
        this.numTimesFlown = 0;
        this.numTimesFlownFirstClass = 0;
        this.moneyEarned = 0;
        this.numVisitsBeijing = 0;
        this.numVisitsCairo = 0;
        this.numVisitsParis = 0;
        this.numVisitsSanFran = 0;
    }

    public void loadRMSGameData(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        for (int i = 0; i < 10; ++i) {
            this.d_simAttributes[0][i] = dataInputStream.readByte();
        }
        byte[] byArray = this.d_simTraits[0];
        for (n2 = 0; n2 < 5; ++n2) {
            byArray[n2] = dataInputStream.readByte();
        }
        this.m_timeTimer = dataInputStream.readInt();
        this.m_timeTotal = dataInputStream.readInt();
        this.m_money = dataInputStream.readInt();
        this.m_moneySpent = dataInputStream.readInt();
        this.m_moneySpentOnFlying = dataInputStream.readInt();
        for (n2 = 0; n2 < this.m_inventory.length; ++n2) {
            this.m_inventory[n2] = dataInputStream.readByte();
        }
        for (n2 = 0; n2 < this.m_skillLevelsF.length; ++n2) {
            this.m_skillLevelsF[n2] = dataInputStream.readInt();
        }
        this.d_simCareers[0] = dataInputStream.readByte();
        this.d_simCareerLevels[0] = dataInputStream.readByte();
        this.m_careerAcceptDay = dataInputStream.readByte();
        this.m_careerDaysWorked = dataInputStream.readShort();
        this.m_careerDaysMissed = dataInputStream.readShort();
        for (n2 = 0; n2 < this.m_careerLevelsAttained.length; ++n2) {
            this.m_careerLevelsAttained[n2] = dataInputStream.readByte();
        }
        this.m_phoneCareer = dataInputStream.readByte();
        this.m_phoneCareerTimer = dataInputStream.readInt();
        this.m_persona = dataInputStream.readByte();
        this.m_dream = dataInputStream.readByte();
        this.m_dreamTimer = dataInputStream.readInt();
        for (n2 = 0; n2 < this.m_promises.length; ++n2) {
            this.m_promises[n2] = dataInputStream.readByte();
        }
        this.m_personaGoalsCompleted = dataInputStream.readInt();
        this.m_personaGoalsCompletedAll = dataInputStream.readBoolean();
        this.m_personaGoalsCompletedAllShown = dataInputStream.readBoolean();
        for (n2 = 0; n2 < this.m_timeRanges.length; ++n2) {
            this.m_timeRanges[n2] = dataInputStream.readInt();
        }
        for (n2 = 0; n2 < this.m_woohooTimes.length; ++n2) {
            this.m_woohooTimes[n2] = dataInputStream.readInt();
        }
        for (n2 = 0; n2 < this.m_woohooPartners.length; ++n2) {
            this.m_woohooPartners[n2] = dataInputStream.readInt();
        }
        this.m_quickLinkFlags = dataInputStream.readInt();
        for (n2 = 0; n2 < this.m_motiveLevelsF.length; ++n2) {
            this.m_motiveLevelsF[n2] = dataInputStream.readInt();
        }
        for (n2 = 0; n2 < 6; ++n2) {
            this.m_buffsActive[n2] = dataInputStream.readShort();
            this.m_buffTimers[n2] = dataInputStream.readInt();
        }
        this.applyBuffsToMood();
        n2 = this.d_numSims;
        for (n = 1; n < n2; ++n) {
            this.m_currentRelStates[n] = dataInputStream.readByte();
            this.m_currentRelStateFlags[n] = dataInputStream.readShort();
            int[] nArray = this.m_currentRelLevelsF[n];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = dataInputStream.readInt();
            }
            byte[] byArray2 = this.m_knownTraits[n];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = dataInputStream.readByte();
            }
        }
        for (n = 0; n < 100; ++n) {
            this.m_objectStateIds[n] = dataInputStream.readShort();
            this.m_objectStateValues[n] = dataInputStream.readInt();
            this.m_objectStateTimes[n] = dataInputStream.readInt();
        }
        this.initMsgHasShownAtHome = dataInputStream.readBoolean();
        this.initMsgHasShownAtAirport = dataInputStream.readBoolean();
        this.initMsgHasShownAtCounter = dataInputStream.readBoolean();
        this.timeArrivedInCairo = dataInputStream.readInt();
        this.toursTried = dataInputStream.readShort();
        this.m_rmsGSBonusUnlocked = dataInputStream.readBoolean();
        this.numTimesFlown = dataInputStream.readInt();
        this.numTimesFlownFirstClass = dataInputStream.readInt();
        this.moneyEarned = dataInputStream.readInt();
        this.numVisitsBeijing = dataInputStream.readInt();
        this.numVisitsCairo = dataInputStream.readInt();
        this.numVisitsParis = dataInputStream.readInt();
        this.numVisitsSanFran = dataInputStream.readInt();
    }

    public void saveRMSGameData(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        for (int i = 0; i < 10; ++i) {
            dataOutputStream.writeByte(this.d_simAttributes[0][i]);
        }
        byte[] byArray = this.d_simTraits[0];
        for (n2 = 0; n2 < 5; ++n2) {
            dataOutputStream.writeByte(byArray[n2]);
        }
        dataOutputStream.writeInt(this.m_timeTimer);
        dataOutputStream.writeInt(this.m_timeTotal);
        dataOutputStream.writeInt(this.m_money);
        dataOutputStream.writeInt(this.m_moneySpent);
        dataOutputStream.writeInt(this.m_moneySpentOnFlying);
        for (n2 = 0; n2 < this.m_inventory.length; ++n2) {
            dataOutputStream.writeByte(this.m_inventory[n2]);
        }
        for (n2 = 0; n2 < this.m_skillLevelsF.length; ++n2) {
            dataOutputStream.writeInt(this.m_skillLevelsF[n2]);
        }
        dataOutputStream.writeByte(this.d_simCareers[0]);
        dataOutputStream.writeByte(this.d_simCareerLevels[0]);
        dataOutputStream.writeByte(this.m_careerAcceptDay);
        dataOutputStream.writeShort(this.m_careerDaysWorked);
        dataOutputStream.writeShort(this.m_careerDaysMissed);
        for (n2 = 0; n2 < this.m_careerLevelsAttained.length; ++n2) {
            dataOutputStream.writeByte(this.m_careerLevelsAttained[n2]);
        }
        dataOutputStream.writeByte(this.m_phoneCareer);
        dataOutputStream.writeInt(this.m_phoneCareerTimer);
        dataOutputStream.writeByte(this.m_persona);
        dataOutputStream.writeByte(this.m_dream);
        dataOutputStream.writeInt(this.m_dreamTimer);
        for (n2 = 0; n2 < this.m_promises.length; ++n2) {
            dataOutputStream.writeByte(this.m_promises[n2]);
        }
        dataOutputStream.writeInt(this.m_personaGoalsCompleted);
        dataOutputStream.writeBoolean(this.m_personaGoalsCompletedAll);
        dataOutputStream.writeBoolean(this.m_personaGoalsCompletedAllShown);
        for (n2 = 0; n2 < this.m_timeRanges.length; ++n2) {
            dataOutputStream.writeInt(this.m_timeRanges[n2]);
        }
        for (n2 = 0; n2 < this.m_woohooTimes.length; ++n2) {
            dataOutputStream.writeInt(this.m_woohooTimes[n2]);
        }
        for (n2 = 0; n2 < this.m_woohooPartners.length; ++n2) {
            dataOutputStream.writeInt(this.m_woohooPartners[n2]);
        }
        dataOutputStream.writeInt(this.m_quickLinkFlags);
        for (n2 = 0; n2 < this.m_motiveLevelsF.length; ++n2) {
            dataOutputStream.writeInt(this.m_motiveLevelsF[n2]);
        }
        for (n2 = 0; n2 < 6; ++n2) {
            dataOutputStream.writeShort(this.m_buffsActive[n2]);
            dataOutputStream.writeInt(this.m_buffTimers[n2]);
        }
        n2 = this.d_numSims;
        for (n = 1; n < n2; ++n) {
            dataOutputStream.writeByte(this.m_currentRelStates[n]);
            dataOutputStream.writeShort(this.m_currentRelStateFlags[n]);
            int[] nArray = this.m_currentRelLevelsF[n];
            for (int i = 0; i < nArray.length; ++i) {
                dataOutputStream.writeInt(nArray[i]);
            }
            byte[] byArray2 = this.m_knownTraits[n];
            for (int i = 0; i < byArray2.length; ++i) {
                dataOutputStream.writeByte(byArray2[i]);
            }
        }
        for (n = 0; n < 100; ++n) {
            dataOutputStream.writeShort(this.m_objectStateIds[n]);
            dataOutputStream.writeInt(this.m_objectStateValues[n]);
            dataOutputStream.writeInt(this.m_objectStateTimes[n]);
        }
        dataOutputStream.writeBoolean(this.initMsgHasShownAtHome);
        dataOutputStream.writeBoolean(this.initMsgHasShownAtAirport);
        dataOutputStream.writeBoolean(this.initMsgHasShownAtCounter);
        dataOutputStream.writeInt(this.timeArrivedInCairo);
        dataOutputStream.writeShort(this.toursTried);
        dataOutputStream.writeBoolean(this.m_rmsGSBonusUnlocked);
        dataOutputStream.writeInt(this.numTimesFlown);
        dataOutputStream.writeInt(this.numTimesFlownFirstClass);
        dataOutputStream.writeInt(this.moneyEarned);
        dataOutputStream.writeInt(this.numVisitsBeijing);
        dataOutputStream.writeInt(this.numVisitsCairo);
        dataOutputStream.writeInt(this.numVisitsParis);
        dataOutputStream.writeInt(this.numVisitsSanFran);
    }

    public boolean isBonusUnlocked() {
        return this.m_rmsGSBonusUnlocked;
    }

    public void unlockBonus() {
        this.m_rmsGSBonusUnlocked = true;
        Main.saveRMSGameData();
    }
}

