/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.IStringConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.SimData;
import dk.progressivemedia.skeleton.SimWorld;
import dk.progressivemedia.skeleton.state.StateInGame;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class Main {
    public static boolean isInitDone = false;
    public static int m_musicID = -1;
    public static int initCounter = 0;
    public static boolean externalDrawing;
    public static long timeLastDrawnExternal;
    public static int m_rightCommandID;
    public static int m_leftCommandID;
    public static long m_leftSoftkeyTime;
    public static long m_rightSoftkeyTime;
    public static AnimPlayer m_softKeyLAnimPlayer;
    public static AnimPlayer m_softKeyRAnimPlayer;
    public static boolean m_softKeyAnimateRight;
    public static int[] d_images;
    public static int m_loadImageIndex;
    public static boolean m_rmsGSTutorialsEnabled;
    public static boolean m_rmsGSAutonomityEnabled;
    public static boolean m_rmsGSSavePrompts;
    public static int m_rmsGSLangIndex;
    public static int m_gameSlotIndex;
    public static SDKString[] m_rmsSimNameString;
    public static boolean[] m_rmsGSActiveGame;
    public static int m_rmsGDTutorialFlags;
    public static long m_rmsGlobalDreamsDiscovered1;
    public static long m_rmsGlobalDreamsComplete1;
    public static long m_rmsGDDreamsDiscovered1;
    public static long m_rmsGDDreamsComplete1;
    public static SimData m_simData;
    public static SimWorld m_simWorld;
    public static int m_nextHouseId;
    public static int m_nextZoomMapId;
    public static short[][] d_uiPanels;
    public static int m_encounterPlayerXF;
    public static int m_encounterPlayerZF;
    public static int m_encounterNPCXF;
    public static int m_encounterNPCZF;
    public static int m_encounterNPCId;
    public static final short[] RESPONSE_ANIMS;

    public static void startMusic(int n) {
        Event.PMDebug_println(2, "Main.startMusic( {0} );", n);
        if (!PMAudio.isEnabled) {
            return;
        }
        if (n == -1) {
            PMAudio.stopAll();
            PMAudio.update();
        }
        if (m_musicID != n && n != -1) {
            if (m_musicID != -1) {
                PMAudio.stop(m_musicID);
            }
            PMAudio.play(n, -1);
        }
        m_musicID = n;
    }

    public static void loadSounds() {
        PMAudio.initAudio(2);
        PMAudio.loadRegOnly(1, "menu", 1, 3569);
        PMAudio.loadRegOnly(0, "ui_toggle", 1, 251);
    }

    public static final void DEBUG_MEMORY(String string) {
    }

    public static void init() {
        int n = initCounter++;
        switch (n) {
            case 0: {
                Event.PMStateManager_set(3, 0);
                Event.LoadingScreen_drawBasicBackground();
                Event.LoadingScreen_initProgressBar(11, 60, 120, 120, 20, 0xCCCCCC, 0, 3);
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                break;
            }
            case 1: {
                Main.preMenuInit();
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 2: {
                Event.LoadingScreen_init();
                ArrayHandler.PostEffects_init();
                Debug.Rain_init();
                AnimationManager.Touch_init();
                Intro.ResourceManager_init();
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 3: {
                Main.loadSounds();
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 4: {
                if (AnimationManager.loadSubimageFile()) {
                    ++initCounter;
                } else {
                    --Event.LoadingScreen_currentStep;
                }
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                break;
            }
            case 5: {
                if (AnimationManager.loadAnimFile()) {
                    ++initCounter;
                } else {
                    --Event.LoadingScreen_currentStep;
                }
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                break;
            }
            case 6: {
                AnimationManager.loadColorsFile();
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 7: {
                m_softKeyLAnimPlayer = new AnimPlayer();
                m_softKeyRAnimPlayer = new AnimPlayer();
                Main.loadGameData();
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 8: {
                Object var1_1 = null;
                for (int i = 0; i < 1; ++i) {
                    Main.m_rmsSimNameString[i] = new SDKString(8, 0);
                    Main.clearSimName(i);
                }
                GlobalConstants.StateMenu_casNameString = new SDKString(8, 0);
                GlobalConstants.StateMenu_casNameString.setLength(1);
                GlobalConstants.StateMenu_casNameString.setCharAt(0, GlobalConstants.StateMenu_SELECT_LETTERS[0]);
                Main.loadRMSAppSettings();
                GameConstants.TextHandler_initWraps();
                Main.DEBUG_MEMORY("init wraps");
                GameConstants.TextHandler_loadTextSDKStrings();
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 9: {
                int n2;
                Main.DEBUG_MEMORY("loaded strings");
                if (GameConstants.TextHandler_m_sdkStringInstances == null) {
                    GameConstants.TextHandler_m_sdkStringInstances = new SDKString[10];
                    for (n2 = 0; n2 < 10; ++n2) {
                        GameConstants.TextHandler_m_sdkStringInstances[n2] = new SDKString();
                    }
                }
                GameConstants.TextHandler_m_tempStringBuffers = new SDKString[25];
                for (n2 = 0; n2 < 25; ++n2) {
                    GameConstants.TextHandler_m_tempStringBuffers[n2] = new SDKString(100, 0);
                }
                Main.loadAllImages(1);
                Event.PMDebug_println("loaded AppEngine images");
                Main.resetRMSGameData();
                Main.loadRMSGameData();
                Event.PMDebug_println("loaded RMS");
                Event.LoadingScreen_updateAndDrawProgressBar(true);
                ++initCounter;
                break;
            }
            case 10: {
                GlobalConstants.StateMenu_initSharedMenus();
                isInitDone = true;
                int n3 = 5;
                if (m_rmsGSLangIndex == -1) {
                    n3 = 4;
                }
                Event.PMStateManager_set(1, n3);
                break;
            }
        }
    }

    public static void preFlush() {
    }

    public static void preMenuInit() {
        GlobalConstants.PMRandom_init(0);
        Cursor.PMFile_initBFC();
        SDKUtils.setGraphics(Debug.PMGraphics_g);
    }

    public static void externalEvent() {
        if (!isInitDone) {
            IStringConstants.PMSystem_externalPause = false;
        }
        GameConstants.TextHandler_resetScrollers();
        externalDrawing = false;
        Main.startMusic(-1);
        timeLastDrawnExternal = ArrayOptimizer.PMTimer_tick();
    }

    public static void drawExternal() {
        if (!externalDrawing) {
            Main.setVarsOnExternal();
        }
        externalDrawing = true;
        GameConstants.TextHandler_updateScrollers((int)(ArrayOptimizer.PMTimer_tick() - timeLastDrawnExternal));
        AnimationManager.setColor(77);
        Debug.PMGraphics_fillRect(0, 0, 240, 260);
        int n = AnimationManager.getAnimFrameWidth(306, 0);
        for (int i = 0; i < 240; i += n) {
            AnimationManager.drawAnimFrame(306, 0, i, 260);
        }
        short[] sArray = new short[6];
        Main.menuClear(sArray, 48);
        Main.menuAppendItem(sArray, 15);
        Debug.UserInterface_drawGenericMenu(sArray, 1);
        int n2 = m_leftCommandID;
        int n3 = m_rightCommandID;
        Main.setSoftKeys(0, 8);
        m_rightSoftkeyTime = 400L;
        m_leftSoftkeyTime = 400L;
        Main.renderSoftkeyButtons(0);
        Main.setSoftKeys(n3, n2);
        timeLastDrawnExternal = ArrayOptimizer.PMTimer_tick();
    }

    public static boolean softPressPos() {
        return AnimationManager.PMInput_isPressed(2048) && m_leftCommandID != 0;
    }

    public static boolean softPressPos(int n) {
        return AnimationManager.PMInput_isPressed(2048) && m_leftCommandID == n;
    }

    public static boolean softPressNeg() {
        return AnimationManager.PMInput_isPressed(4096) && m_rightCommandID != 0 || AnimationManager.PMInput_isPressed(4);
    }

    public static boolean softPressNeg(int n) {
        return AnimationManager.PMInput_isPressed(4096) && m_rightCommandID == n;
    }

    public static void setSoftKeys(int n, int n2) {
        Event.PMDebug_println(2, "Main.setSoftKeys( {0}, {1} );", n, n2);
        int n3 = n;
        n = n2;
        n2 = n3;
        if (n2 != m_rightCommandID) {
            m_rightCommandID = n2;
            m_rightSoftkeyTime = 0L;
        }
        if (n != m_leftCommandID) {
            m_leftCommandID = n;
            m_leftSoftkeyTime = 0L;
        }
    }

    public static final int getCommandString(int n) {
        if (n == 0) {
            return -1;
        }
        if (n == 1) {
            return 26;
        }
        if (n == 2) {
            return 17;
        }
        if (n == 4) {
            return 18;
        }
        if (n == 8) {
            return 19;
        }
        if (n == 16) {
            return 20;
        }
        if (n == 32) {
            return 21;
        }
        if (n == 64) {
            return 22;
        }
        if (n == 128) {
            return 30;
        }
        if (n == 256) {
            return 24;
        }
        if (n == 512) {
            return 25;
        }
        if (n == 1024) {
            return 16;
        }
        if (n == 2048) {
            return 27;
        }
        if (n == 4096) {
            return 28;
        }
        if (n == 8192) {
            return 29;
        }
        if (n == 16384) {
            return 1;
        }
        if (n == 32768) {
            return 2;
        }
        return -1;
    }

    public static int rand(int n, int n2) {
        int n3 = n2 - n + 1;
        return n + GlobalConstants.PMRandom_get() % n3;
    }

    public static int randPercent() {
        return Main.rand(0, 99);
    }

    public static int popupSize(int n, int n2, int n3, long l, long l2) {
        if (l >= l2) {
            return n3;
        }
        if (l < 0L) {
            return n2;
        }
        return (int)((long)n2 + l * (long)(n3 - n2) / l2);
    }

    public static void updateSoftKeys(int n) {
        if (ArrayHandler.PostEffects_isFading()) {
            m_leftSoftkeyTime = 0L;
            m_rightSoftkeyTime = 0L;
        } else {
            if (m_leftSoftkeyTime < 400L) {
                m_leftSoftkeyTime += (long)n;
            }
            if (m_rightSoftkeyTime < 400L) {
                m_rightSoftkeyTime += (long)n;
            }
        }
    }

    public static void renderSoftkeyBar() {
        Main.renderSoftkeyBar(0);
    }

    public static void renderSoftkeyBar(int n) {
        int n2 = AnimationManager.getAnimFrameWidth(306, 0);
        for (int i = 0; i < 240; i += n2) {
            AnimationManager.drawAnimFrame(306, 0, i, 260 + n);
        }
        if (!ArrayHandler.PostEffects_isFading()) {
            Main.renderSoftkeyButtons(n);
        }
    }

    public static void renderSoftkeyButtons(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        SDKString sDKString;
        SDKString sDKString2;
        int n8 = Main.getCommandString(m_leftCommandID);
        int n9 = Main.getCommandString(m_rightCommandID);
        if (n8 >= 0) {
            sDKString2 = GameConstants.TextHandler_getString(n8);
            sDKString = new SDKString(" (!)");
            n7 = Main.popupSize(1, 15, 0, m_leftSoftkeyTime, 400L);
            n6 = 260 + n7 + n;
            n5 = n6 - 7;
            n4 = 15 + Math.max(25, GameConstants.TextHandler_getStringWidth(sDKString2, 0));
            n3 = 11 + n4 - 4;
            n2 = 11 + n3 >> 1;
            if (m_softKeyLAnimPlayer.isAnimating() && !m_softKeyAnimateRight) {
                AnimationManager.drawAnim(m_softKeyLAnimPlayer, 11, n6);
                AnimationManager.drawAnim(m_softKeyRAnimPlayer, n3, n6);
                Main.renderSoftKeyJoin(13, n6, n3 - 11 - 4, true);
                GameConstants.TextHandler_drawString(sDKString2, 0, n2 - 7, n5, 3);
                GameConstants.TextHandler_drawString(sDKString, 0, n2 + n4 / 2 - 7, n5, 3);
            } else {
                AnimationManager.drawAnimFrame(309, 0, n3, n6);
                AnimationManager.drawAnimFrame(307, 0, 11, n6);
                Main.renderSoftKeyJoin(13, n6, n3 - 11 - 4, false);
                GameConstants.TextHandler_drawString(sDKString2, 0, n2 - 7, n5, 3);
                GameConstants.TextHandler_drawString(sDKString, 0, n2 + n4 / 2 - 7, n5, 3);
            }
        }
        if (n9 >= 0) {
            sDKString2 = GameConstants.TextHandler_getString(n9);
            sDKString = new SDKString(" (.)");
            n7 = Main.popupSize(1, 15, 0, m_rightSoftkeyTime, 400L);
            n6 = 260 + n7 + n;
            n5 = n6 - 7;
            n4 = 15 + Math.max(25, GameConstants.TextHandler_getStringWidth(sDKString2, 0));
            n3 = 229 - n4 + 4;
            n2 = n3 + 229 >> 1;
            if (m_softKeyLAnimPlayer.isAnimating() && m_softKeyAnimateRight) {
                AnimationManager.drawAnim(m_softKeyLAnimPlayer, n3, n6);
                AnimationManager.drawAnim(m_softKeyRAnimPlayer, 229, n6);
                Main.renderSoftKeyJoin(n3 + 2, n6, 229 - n3 - 4, true);
                GameConstants.TextHandler_drawString(sDKString2, 0, n2 - 7, n5, 3);
                GameConstants.TextHandler_drawString(sDKString, 0, n2 - 7 + n4 / 2, n5, 3);
            } else {
                AnimationManager.drawAnimFrame(309, 0, 229, n6);
                AnimationManager.drawAnimFrame(307, 0, n3, n6);
                Main.renderSoftKeyJoin(n3 + 2, n6, 229 - n3 - 4, false);
                GameConstants.TextHandler_drawString(sDKString2, 0, n2 - 7, n5, 3);
                GameConstants.TextHandler_drawString(sDKString, 0, n2 - 7 + n4 / 2, n5, 3);
            }
        }
    }

    public static void renderSoftKeyJoin(int n, int n2, int n3, boolean bl) {
        int n4 = bl ? 1 : 0;
        int n5 = Debug.PMGraphics_getClipX();
        int n6 = Debug.PMGraphics_getClipY();
        int n7 = Debug.PMGraphics_getClipWidth();
        int n8 = Debug.PMGraphics_getClipHeight();
        Debug.PMGraphics_setClip(n, n6, n3, n8);
        AnimationManager.drawAnimFrame(308, n4, n, n2);
        Debug.PMGraphics_setClip(n5, n6, n7, n8);
    }

    public static void loadImagesBegin() {
        m_loadImageIndex = 0;
    }

    public static boolean loadImagesNext(int n) {
        return Main.loadImagesNext(n, null, null, 0);
    }

    public static boolean loadImagesNext(int n, int[] nArray, int[] nArray2, int n2) {
        int n3 = 0;
        int n4 = m_loadImageIndex;
        while (n4 << 1 < d_images.length && n3 < 2) {
            if ((d_images[(n4 << 1) + 1] & n) != 0) {
                int n5;
                for (n5 = 1; !AnimationManager.loadImage(d_images[n4 << 1], nArray, nArray2, n2) && n5 < 2; ++n5) {
                    IStringConstants.PMSystem_forceGC();
                }
                if (n5 >= 2) {
                    Event.PMDebug_println("OOM: failed to load image: " + d_images[n4 << 1]);
                    return true;
                }
                ++n3;
            }
            ++n4;
        }
        m_loadImageIndex = n4;
        return n4 << 1 == d_images.length;
    }

    public static void loadAllImages(int n) {
        Main.loadAllImages(n, null, null, 0);
    }

    public static void loadAllImages(int n, int[] nArray, int[] nArray2, int n2) {
        Main.loadImagesBegin();
        while (!Main.loadImagesNext(n, nArray, nArray2, n2)) {
        }
    }

    public static void unloadAllImages(int n, int n2) {
        int[] nArray = d_images;
        int n3 = 0;
        while (n3 << 1 < nArray.length) {
            if ((nArray[(n3 << 1) + 1] & n) != 0) {
                int n4 = nArray[n3 << 1];
                if (n2 == -1) {
                    for (int i = 0; i < 3; ++i) {
                        AnimationManager.unloadImage(n4, i);
                    }
                } else {
                    AnimationManager.unloadImage(n4, n2);
                }
            }
            ++n3;
        }
        IStringConstants.PMSystem_forceGC();
    }

    public static void menuClear(short[] sArray, int n) {
        Main.menuClear(sArray, n, -1);
    }

    public static void menuClear(short[] sArray, int n, int n2) {
        sArray[1] = (short)n;
        sArray[2] = 0;
        sArray[3] = 0;
        sArray[4] = (short)n2;
        sArray[0] = 0;
    }

    public static void menuAppendItem(short[] sArray, int n) {
        short s = sArray[0];
        sArray[5 + s] = (short)n;
        sArray[0] = (short)(s + 1);
    }

    public static boolean menuContains(short[] sArray, int n) {
        int n2 = sArray[0] + 5;
        for (int i = 5; i < n2; ++i) {
            if (n != sArray[i]) continue;
            return true;
        }
        return false;
    }

    public static void menuCopy(short[] sArray, short[] sArray2) {
        System.arraycopy(sArray2, 0, sArray, 0, 5 + sArray2[0]);
    }

    public static void menuVisible(short[] sArray) {
        short s = sArray[4];
        if (s <= 0) {
            return;
        }
        int n = sArray[2];
        int n2 = sArray[3];
        if (n < n2) {
            n2 = n;
        } else if (n >= n2 + s) {
            n2 = Math.max(0, n - s + 1);
        }
        sArray[3] = (short)n2;
    }

    public static boolean menuCursorUpDown(short[] sArray) {
        short s = sArray[0];
        short s2 = sArray[2];
        if (AnimationManager.PMInput_isPressed(32)) {
            sArray[2] = (short)((s2 + s - 1) % s);
        }
        if (AnimationManager.PMInput_isPressed(64)) {
            sArray[2] = (short)((s2 + 1) % s);
        }
        if (sArray[2] != s2) {
            Main.menuVisible(sArray);
            return true;
        }
        return false;
    }

    public static boolean menuCursorLeftRight(short[] sArray) {
        short s = sArray[0];
        short s2 = sArray[2];
        if (AnimationManager.PMInput_isPressed(8)) {
            sArray[2] = (short)((s2 + s - 1) % s);
        }
        if (AnimationManager.PMInput_isPressed(16)) {
            sArray[2] = (short)((s2 + 1) % s);
        }
        if (sArray[2] != s2) {
            Main.menuVisible(sArray);
            GameConstants.TextHandler_resetScrollers();
            return true;
        }
        return false;
    }

    public static void menuSelectById(short[] sArray, int n) {
    }

    public static int getSimNameLength() {
        return GlobalConstants.StateMenu_casNameString.length();
    }

    public static void setSimNameLength(int n) {
        GlobalConstants.StateMenu_casNameString.setLength(n);
    }

    public static void clearSimName(int n) {
        m_rmsSimNameString[n].setLength(1);
        m_rmsSimNameString[n].setCharAt(0, GlobalConstants.StateMenu_SELECT_LETTERS[0]);
    }

    public static int getSimNameCharIndex(int n) {
        for (int i = 0; i < GlobalConstants.StateMenu_SELECT_LETTERS.length; ++i) {
            if (GlobalConstants.StateMenu_casNameString.charAt(n) != GlobalConstants.StateMenu_SELECT_LETTERS[i]) continue;
            return i;
        }
        return -1;
    }

    public static void setSimNameCharIndex(int n, int n2) {
        if ((n2 %= GlobalConstants.StateMenu_SELECT_LETTERS.length) < 0) {
            n2 += GlobalConstants.StateMenu_SELECT_LETTERS.length;
        }
        if (n >= GlobalConstants.StateMenu_casNameString.length()) {
            GlobalConstants.StateMenu_casNameString.setLength(n + 1);
        }
        GlobalConstants.StateMenu_casNameString.setCharAt(n, GlobalConstants.StateMenu_SELECT_LETTERS[n2]);
    }

    public static boolean getAutonomityEnabled() {
        return m_rmsGSAutonomityEnabled;
    }

    public static boolean getTutorialsEnabled() {
        return m_rmsGSTutorialsEnabled;
    }

    public static boolean getSavePromptsEnabled() {
        return m_rmsGSSavePrompts;
    }

    public static int getRMSLangIndex() {
        return m_rmsGSLangIndex;
    }

    public static void resetRMSAppSettings() {
        Intro.PMVibrate_on = true;
        m_rmsGSTutorialsEnabled = true;
        m_rmsGSAutonomityEnabled = true;
        m_rmsGSSavePrompts = true;
        m_rmsGlobalDreamsDiscovered1 = 0L;
        m_rmsGlobalDreamsComplete1 = 0L;
        m_rmsGSLangIndex = -1;
        Main.resetSimSaveData();
    }

    public static void loadRMSAppSettings() {
        Event.PMDebug_println("loadRMSAppSettings");
        ByteArrayInputStream byteArrayInputStream = null;
        DataInputStream dataInputStream = null;
        byte[] byArray = GameConstants.PMStorage_load("sims3wtset");
        if (byArray != null) {
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                if (n == 100 && n2 == 1) {
                    Intro.PMVibrate_on = dataInputStream.readBoolean();
                    m_rmsGSTutorialsEnabled = dataInputStream.readBoolean();
                    m_rmsGSAutonomityEnabled = dataInputStream.readBoolean();
                    m_rmsGSSavePrompts = dataInputStream.readBoolean();
                    m_rmsGlobalDreamsDiscovered1 = dataInputStream.readLong();
                    m_rmsGlobalDreamsComplete1 = dataInputStream.readLong();
                    m_rmsGSLangIndex = dataInputStream.readByte();
                    for (int i = 0; i != 1; ++i) {
                        boolean bl = false;
                        char c = ' ';
                        SDKString sDKString = m_rmsSimNameString[i];
                        for (int j = 0; j < 8; ++j) {
                            c = dataInputStream.readChar();
                            if (c == ' ') {
                                bl = true;
                                continue;
                            }
                            if (bl) continue;
                            sDKString.setLength(j + 1);
                            sDKString.setCharAt(j, c);
                        }
                        if (!bl) {
                            sDKString.setLength(8);
                        }
                        Main.m_rmsGSActiveGame[i] = dataInputStream.readBoolean();
                    }
                } else {
                    Main.resetRMSAppSettings();
                    Main.saveRMSAppSettings();
                }
            }
            catch (Exception exception) {
                Event.PMDebug_println("exception reading RMS settings, resetting to standard values!");
                Main.resetRMSAppSettings();
                Main.saveRMSAppSettings();
            }
            try {
                dataInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
        } else {
            Main.resetRMSAppSettings();
            Main.saveRMSAppSettings();
        }
    }

    public static boolean saveRMSAppSettings() {
        Event.PMDebug_println("saveRMSAppSettings");
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(100);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeBoolean(Intro.PMVibrate_on);
            dataOutputStream.writeBoolean(m_rmsGSTutorialsEnabled);
            dataOutputStream.writeBoolean(m_rmsGSAutonomityEnabled);
            dataOutputStream.writeBoolean(m_rmsGSSavePrompts);
            dataOutputStream.writeLong(m_rmsGlobalDreamsDiscovered1);
            dataOutputStream.writeLong(m_rmsGlobalDreamsComplete1);
            dataOutputStream.writeByte(m_rmsGSLangIndex);
            for (int i = 0; i != 1; ++i) {
                SDKString sDKString = m_rmsSimNameString[i];
                for (int j = 0; j != 8; ++j) {
                    int n = 32;
                    if (j < sDKString.length()) {
                        n = sDKString.charAt(j);
                    }
                    dataOutputStream.writeChar(n);
                }
                dataOutputStream.writeBoolean(m_rmsGSActiveGame[i]);
            }
            GameConstants.PMStorage_save(byteArrayOutputStream.toByteArray(), "sims3wtset");
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        return !bl;
    }

    public static void resetRMSGameData() {
        Event.PMDebug_println("resetRMSGameData");
        m_rmsGDTutorialFlags = 0;
        Main.resetGDGoals();
        m_simData.resetRMSGameData();
        m_simWorld.resetRMSGameData();
    }

    public static void loadRMSGameData() {
        Event.PMDebug_println("loadRMSGameData");
        ByteArrayInputStream byteArrayInputStream = null;
        DataInputStream dataInputStream = null;
        byte[] byArray = GameConstants.PMStorage_load("sims3wtdat");
        if (byArray != null) {
            try {
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                dataInputStream = new DataInputStream(byteArrayInputStream);
                int n = dataInputStream.readInt();
                if (n == 100) {
                    m_rmsGDTutorialFlags = dataInputStream.readInt();
                    m_simData.loadRMSGameData(dataInputStream);
                    m_simWorld.loadRMSGameData(dataInputStream);
                    m_nextHouseId = 0;
                } else {
                    Main.resetRMSGameData();
                    Main.saveRMSGameData();
                }
            }
            catch (Exception exception) {
                Event.PMDebug_println(1, "exception reading game data: {0}", exception.toString());
                Main.resetRMSGameData();
                Main.saveRMSGameData();
            }
            try {
                dataInputStream.close();
                byteArrayInputStream.close();
            }
            catch (Exception exception) {}
        } else {
            Main.resetRMSGameData();
            Main.saveRMSGameData();
        }
    }

    public static boolean saveRMSGameData() {
        Event.PMDebug_println("saveRMSGameData");
        m_rmsGlobalDreamsDiscovered1 |= m_rmsGDDreamsDiscovered1;
        m_rmsGlobalDreamsComplete1 |= m_rmsGDDreamsComplete1;
        Main.saveRMSAppSettings();
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(100);
            dataOutputStream.writeInt(m_rmsGDTutorialFlags);
            m_simData.saveRMSGameData(dataOutputStream);
            m_simWorld.saveRMSGameData(dataOutputStream);
            GameConstants.PMStorage_save(byteArrayOutputStream.toByteArray(), "sims3wtdat");
        }
        catch (Exception exception) {
            bl = true;
            Event.PMDebug_println("Main.saveRMSGameData().error --> " + exception.toString());
        }
        try {
            dataOutputStream.close();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            bl = true;
        }
        return !bl;
    }

    public static int getRMSOptionString(int n) {
        if (n == 61) {
            return PMAudio.isEnabled ? 69 : 70;
        }
        if (n == 62) {
            return Intro.PMVibrate_on ? 69 : 70;
        }
        if (n == 63) {
            return m_rmsGSTutorialsEnabled ? 69 : 70;
        }
        if (n == 64) {
            return m_rmsGSAutonomityEnabled ? 69 : 70;
        }
        if (n == 65) {
            return m_rmsGSSavePrompts ? 69 : 70;
        }
        return -1;
    }

    public static SDKString getSimName() {
        return m_rmsSimNameString[m_gameSlotIndex];
    }

    public static boolean getRMSActiveGame() {
        return m_rmsGSActiveGame[m_gameSlotIndex];
    }

    public static void resetSimSaveData() {
        Event.PMDebug_println("resetSimSaveData");
        for (int i = 0; i < 1; ++i) {
            Main.resetSimSaveData(i);
        }
    }

    public static void resetSimSaveData(int n) {
        Main.clearSimName(n);
        Main.m_rmsGSActiveGame[n] = false;
    }

    public static void newGame() {
        Event.PMDebug_println("newGame");
        Main.m_rmsGSActiveGame[Main.m_gameSlotIndex] = true;
        m_rmsGDTutorialFlags = 0;
        Main.saveRMSAppSettings();
        m_simData.newGame();
        Main.saveRMSGameData();
        StateInGame.m_timeAnimPlayer = null;
    }

    public static void beginGame() {
        Event.PMDebug_println("beginGame");
        Main.loadRMSGameData();
        m_nextHouseId = 0;
    }

    public static boolean getRMSHasSeenTutorial(int n) {
        return (1 << n & m_rmsGDTutorialFlags) != 0;
    }

    public static void setRMSHasSeenTutorial(int n) {
        m_rmsGDTutorialFlags |= 1 << n;
    }

    public static void resetGlobalGoals() {
        Main.m_simData.m_rmsGSBonusUnlocked = false;
        m_rmsGlobalDreamsDiscovered1 = 0L;
        m_rmsGlobalDreamsComplete1 = 0L;
    }

    public static void resetGDGoals() {
        m_rmsGDDreamsDiscovered1 = 0L;
        m_rmsGDDreamsComplete1 = 0L;
    }

    public static boolean isDreamDiscovered(int n) {
        long l = 1L << n;
        return ((m_rmsGlobalDreamsDiscovered1 | m_rmsGDDreamsDiscovered1) & l) != 0L;
    }

    public static void setGoalDiscovered(int n) {
        long l = 1L << n;
        m_rmsGDDreamsDiscovered1 |= l;
    }

    public static int getNumGoalsDiscovered() {
        long l = m_rmsGlobalDreamsDiscovered1 | m_rmsGDDreamsDiscovered1;
        int n = 0;
        for (int i = 0; i < 64; ++i) {
            n = (int)((long)n + (l >> i & 1L));
        }
        return n;
    }

    public static boolean isGoalCompleted(int n) {
        long l = 1L << n;
        return ((m_rmsGlobalDreamsComplete1 | m_rmsGDDreamsComplete1) & l) != 0L;
    }

    public static void setGoalCompleted(int n) {
        Main.setGoalDiscovered(n);
        long l = 1L << n;
        m_rmsGDDreamsComplete1 |= l;
    }

    public static int getNumGoalsComplete() {
        long l = m_rmsGlobalDreamsComplete1 | m_rmsGDDreamsComplete1;
        int n = 0;
        for (int i = 0; i < 64; ++i) {
            n = (int)((long)n + (l >> i & 1L));
        }
        return n;
    }

    public static void drawLoading() {
        Event.LoadingScreen_draw(false);
    }

    public static void loadGameData() {
        Main.loadUIPanels();
        m_simWorld = new SimWorld();
        m_simData = new SimData();
        m_nextHouseId = 0;
        m_nextZoomMapId = -1;
        m_encounterNPCId = -1;
    }

    public static void setNextHouseId(int n) {
        m_nextHouseId = n;
        m_nextZoomMapId = -1;
    }

    public static int getNextHouseId() {
        return m_nextHouseId;
    }

    public static void setNextZoomMapId(int n) {
        m_nextZoomMapId = n;
    }

    public static int getNextZoomMapId() {
        return m_nextZoomMapId;
    }

    public static void setupEncounter(MapObjectSim mapObjectSim) {
        MapObjectSim mapObjectSim2 = StateInGame.getPlayerSim();
        m_encounterPlayerXF = mapObjectSim2.getPosX();
        m_encounterPlayerZF = mapObjectSim2.getPosZ();
        if (mapObjectSim != null) {
            m_encounterNPCXF = mapObjectSim.getPosX();
            m_encounterNPCZF = mapObjectSim.getPosZ();
            m_encounterNPCId = mapObjectSim.getId();
        } else {
            m_encounterNPCId = -1;
        }
        m_nextHouseId = -1;
    }

    public static int getEncounterPlayerX() {
        return m_encounterPlayerXF;
    }

    public static int getEncounterPlayerZ() {
        return m_encounterPlayerZF;
    }

    public static int getEncounterNPCX() {
        return m_encounterNPCXF;
    }

    public static int getEncounterNPCZ() {
        return m_encounterNPCZF;
    }

    public static int getEncounterNPCId() {
        return m_encounterNPCId;
    }

    public static final short lookupSimsUI() {
        return AnimationManager.SimsUIConstants_SIMSUI_SYMBOL_LOOKUPS[Cursor.PMFile_readShort()];
    }

    public static void loadUIPanels() {
        int n;
        int n2;
        Intro.ResourceManager_loadBinaryFile(66);
        int n3 = Cursor.PMFile_readByte();
        short[][] sArrayArray = new short[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = Cursor.PMFile_readByte();
            short[] sArray = new short[n4 << 1];
            n = 0;
            for (int i = 0; i < n4; ++i) {
                sArray[n] = Cursor.PMFile_readByte();
                sArray[n + 1] = Main.lookupSimsUI();
                n += 2;
            }
            sArrayArray[n2] = sArray;
        }
        n2 = Cursor.PMFile_readByte();
        int[] nArray = new int[n2 << 1];
        int n5 = 0;
        for (n = 0; n < n2; ++n) {
            nArray[n5] = Main.lookupSimsUI();
            nArray[n5 + 1] = Cursor.PMFile_readInt();
            n5 += 2;
        }
        d_images = nArray;
        Cursor.PMFile_closeFile();
        d_uiPanels = sArrayArray;
        d_uiPanels = ArrayOptimizer.Optimize(d_uiPanels);
    }

    public static short[] getUIPanel(int n) {
        return d_uiPanels[n];
    }

    public static boolean isAirport(int n) {
        return Main.isForeignAirport(n) || n == 8;
    }

    public static boolean isForeignAirport(int n) {
        return n == 7 || n == 6 || n == 4 || n == 5;
    }

    public static final short lookupSimsData() {
        short s = Cursor.PMFile_readShort();
        return Cursor.SimsDataConstants_SIMSDATA_SYMBOL_LOOKUPS[s];
    }

    public static final short lookupSimsWorld() {
        return ArrayHandler.SimsWorldConstants_SIMSWORLD_SYMBOL_LOOKUPS[Cursor.PMFile_readShort()];
    }

    public static final short lookupSimsHouses() {
        return GameConstants.SimsHousesConstants_HOUSES_SYMBOL_LOOKUPS[Cursor.PMFile_readShort()];
    }

    public static int responseToFeedbackAnim(int n) {
        return RESPONSE_ANIMS[n & 0xF];
    }

    public static int fromZoommapToLocationIndex(int n) {
        switch (n) {
            case 57: {
                return 0;
            }
            case 58: {
                return 1;
            }
            case 60: {
                return 2;
            }
            case 61: {
                return 3;
            }
        }
        return 0;
    }

    public static int fromZoommapToLocationFlag(int n) {
        switch (n) {
            case 57: {
                return 8;
            }
            case 58: {
                return 16;
            }
            case 60: {
                return 32;
            }
            case 61: {
                return 64;
            }
        }
        return 0;
    }

    public static int fromAirportToLocationFlag(int n) {
        switch (n) {
            case 7: {
                return 8;
            }
            case 6: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
        }
        return -1;
    }

    public static int fromAirportToLocationIndex(int n) {
        switch (n) {
            case 7: {
                return 0;
            }
            case 6: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 8: {
                return 4;
            }
        }
        return -1;
    }

    public static int fromCounterToLocationIndex(int n) {
        switch (n) {
            case 11: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 12: {
                return 3;
            }
        }
        return -1;
    }

    public static void setVarsOnExternal() {
        Debug.UserInterface_newScrollTimePressed = -1;
        IStringConstants.Minigame_externalEvent();
    }

    static {
        m_rmsSimNameString = new SDKString[1];
        m_rmsGSActiveGame = new boolean[1];
        RESPONSE_ANIMS = new short[]{236, 235, 234, 87, 237, 238, 239};
    }
}

