/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKImage;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.IStringConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.constants.AnimConstants;

public class AnimationManager {
    private static byte[] s_colourData;
    private static short[][] s_subImages;
    private static int s_curBank;
    private static SDKImage[][] s_animImageArray;
    private static short subImageFileLoadProgress;
    private static int subImageFileLoadCIndex;
    private static int subImageFileLoadCIndexMax;
    private static short animFileLoadProgress;
    private static int animFileLoadCIndex;
    private static int animFileLoadCIndexMax;
    private static short[][] s_frameDurations;
    private static short[][] s_frameOffsets;
    private static short[][] s_frameData;
    public static int[] primitiveBinaryDataCount;
    public static int[] primitiveDataCount;
    static boolean Touch_isTouchedNotPressed;
    public static boolean Touch_isKeyboardEnabled;
    public static int Touch_touchCount;
    public static boolean Touch_keyCodeUsed;
    public static int Touch_pointerPosX;
    public static int Touch_pointerPosY;
    public static int Touch_pointerDraggedPosX;
    public static int Touch_pointerDraggedPosY;
    public static int Touch_pointerPosPressedX;
    public static int Touch_pointerPosPressedY;
    public static int Touch_pointerReleasedPosX;
    public static int Touch_pointerReleasedPosY;
    public static int Touch_touchedCode;
    public static boolean Touch_touchDataAdded;
    public static boolean Touch_touchDataAdded2;
    public static boolean Touch_isUseClickConfirmed;
    public static boolean Touch_ifTouched;
    private static boolean Touch_IsSomethingPressed;
    public static boolean Touch_inName;
    public static final short[] SimsUIConstants_SIMSUI_SYMBOL_LOOKUPS;
    public static int PMInput_keyFlag;
    public static int PMInput_keyLast;
    public static int PMInput_keyState;
    public static int PMInput_keyClear;
    public static final int[][] PMInput_KEY_CODES;

    public static final boolean loadColorsFile() {
        s_colourData = Cursor.PMFile_fileToByteArray(ArrayOptimizer.ResourceConstants_RESOURCE_FILENAMES_LIST[55]);
        return true;
    }

    public static final void setColor(int n) {
        if (s_colourData != null) {
            int n2 = n * 3;
            Debug.PMGraphics_setColor(s_colourData[n2] & 0xFF, s_colourData[n2 + 1] & 0xFF, s_colourData[n2 + 2] & 0xFF);
        }
    }

    public static final boolean loadSubimageFile() {
        if (subImageFileLoadProgress == 0) {
            s_subImages = new short[5][760];
            Intro.ResourceManager_loadBinaryFile(56);
            subImageFileLoadProgress = (short)(subImageFileLoadProgress + 1);
            return false;
        }
        short[][] sArray = s_subImages;
        if ((subImageFileLoadCIndexMax += 23) > 759) {
            subImageFileLoadCIndexMax = 759;
        }
        while (subImageFileLoadCIndex <= subImageFileLoadCIndexMax) {
            int n = subImageFileLoadCIndex++;
            sArray[0][n] = (short)Cursor.PMFile_readUnsignedByte();
            sArray[1][n] = Cursor.PMFile_readShort();
            sArray[2][n] = Cursor.PMFile_readShort();
            sArray[3][n] = Cursor.PMFile_readShort();
            sArray[4][n] = Cursor.PMFile_readShort();
        }
        return subImageFileLoadCIndexMax == 759;
    }

    public static final boolean loadAnimFile() {
        int n = 0;
        if (animFileLoadProgress == 0) {
            Intro.ResourceManager_loadBinaryFile(54);
            s_frameDurations = new short[345][];
            s_frameOffsets = new short[345][];
            s_frameData = new short[345][];
            animFileLoadProgress = 1;
            return false;
        }
        if (animFileLoadProgress == 1) {
            short[][] sArray = s_frameDurations;
            short[][] sArray2 = s_frameOffsets;
            short[][] sArray3 = s_frameData;
            if ((animFileLoadCIndexMax += 10) > 344) {
                animFileLoadCIndexMax = 344;
            }
            while (animFileLoadCIndex <= animFileLoadCIndexMax) {
                n = animFileLoadCIndex;
                int n2 = 0;
                int n3 = Cursor.PMFile_readUnsignedByte();
                for (int i = 0; i < n3; ++i) {
                    Cursor.PMFile_readShort();
                    int n4 = Cursor.PMFile_readUnsignedByte();
                    for (int j = 0; j < n4; ++j) {
                        int n5 = Cursor.PMFile_readUnsignedByte();
                        int n6 = primitiveBinaryDataCount[n5];
                        for (int k = 0; k < n6; ++k) {
                            Cursor.PMFile_readByte();
                        }
                        n2 += primitiveDataCount[n5];
                    }
                }
                sArray[n] = new short[n3];
                sArray2[n] = new short[n3];
                sArray3[n] = new short[n2];
                ++animFileLoadCIndex;
            }
            if (animFileLoadCIndexMax != 344) {
                return false;
            }
            animFileLoadProgress = (short)2;
            return false;
        }
        if (animFileLoadProgress == 2) {
            Cursor.PMFile_closeFile();
            Intro.ResourceManager_loadBinaryFile(54);
            animFileLoadCIndex = 0;
            animFileLoadCIndexMax = 0;
            animFileLoadProgress = (short)3;
            return false;
        }
        if (animFileLoadProgress == 3) {
            if ((animFileLoadCIndexMax += 10) > 344) {
                animFileLoadCIndexMax = 344;
            }
            while (animFileLoadCIndex <= animFileLoadCIndexMax) {
                n = animFileLoadCIndex;
                int n7 = 0;
                short[] sArray = s_frameData[n];
                short[] sArray4 = s_frameDurations[n];
                short[] sArray5 = s_frameOffsets[n];
                int n8 = Cursor.PMFile_readUnsignedByte();
                for (int i = 0; i < n8; ++i) {
                    sArray4[i] = Cursor.PMFile_readShort();
                    sArray5[i] = (short)n7;
                    int n9 = Cursor.PMFile_readUnsignedByte();
                    for (int j = 0; j < n9; ++j) {
                        int n10 = Cursor.PMFile_readUnsignedByte();
                        switch (n10) {
                            case 0: 
                            case 11: {
                                sArray[n7 + 3] = Cursor.PMFile_readShort();
                                sArray[n7 + 1] = Cursor.PMFile_readShort();
                                sArray[n7 + 2] = Cursor.PMFile_readShort();
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 8: {
                                sArray[n7 + 1] = Cursor.PMFile_readShort();
                                sArray[n7 + 2] = Cursor.PMFile_readShort();
                                sArray[n7 + 3] = Cursor.PMFile_readShort();
                                sArray[n7 + 4] = Cursor.PMFile_readShort();
                                break;
                            }
                            case 7: {
                                sArray[n7 + 1] = Cursor.PMFile_readShort();
                                sArray[n7 + 2] = Cursor.PMFile_readShort();
                                break;
                            }
                            case 10: {
                                sArray[n7 + 1] = Cursor.PMFile_readByte();
                                break;
                            }
                        }
                        sArray[n7] = (short)n10;
                        n7 += primitiveDataCount[n10];
                    }
                }
                ++animFileLoadCIndex;
            }
            if (animFileLoadCIndexMax != 344) {
                return false;
            }
        }
        Cursor.PMFile_closeFile();
        s_frameDurations = ArrayOptimizer.Optimize(s_frameDurations);
        s_frameOffsets = ArrayOptimizer.Optimize(s_frameOffsets);
        s_frameData = ArrayOptimizer.Optimize(s_frameData);
        Event.PMDebug_println(2, "finished, loadAnimFile");
        return true;
    }

    private static final int getFrameOffsetStart(int n, int n2) {
        return s_frameOffsets[n][n2];
    }

    private static final int getFrameOffsetEnd(int n, int n2) {
        short[] sArray = s_frameOffsets[n];
        if (n2 < sArray.length - 1) {
            return sArray[n2 + 1];
        }
        return s_frameData[n].length;
    }

    public static final boolean loadImage(int n, int[] nArray, int[] nArray2, int n2) {
        int n3;
        for (n3 = 0; n3 < 47 && n != AnimConstants.IMAGE_RES_IDS[n3]; ++n3) {
        }
        if (47 == n3) {
            Event.PMDebug_println(1, "No resID found!");
            return false;
        }
        SDKImage[] sDKImageArray = s_animImageArray[n2];
        if (sDKImageArray[n3] == null) {
            SDKImage sDKImage;
            if (nArray != null) {
                sDKImage = Intro.ResourceManager_loadImage(n, nArray, nArray2);
            } else {
                Event.PMDebug_println(2, "load image: resId={0}, name=Intro.ResourceManager_getFileName( resID )", n);
                sDKImage = Intro.ResourceManager_loadImage(n);
            }
            sDKImageArray[n3] = sDKImage;
            if (sDKImage == null) {
                Event.PMDebug_println("load fail");
                return false;
            }
        }
        if (sDKImageArray[n3] == null) {
            Event.PMDebug_println("load 'success', but image is null!");
        }
        return true;
    }

    public static final boolean unloadImage(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < 47 && n != AnimConstants.IMAGE_RES_IDS[n3]; ++n3) {
        }
        if (47 == n3) {
            Event.PMDebug_println("unload aborted (resID not found)");
            return false;
        }
        AnimationManager.s_animImageArray[n2][n3] = null;
        IStringConstants.PMSystem_forceGC();
        return true;
    }

    public static final void drawAnimFrame(int n, int n2, int n3, int n4) {
        short s;
        if (n < 0) {
            return;
        }
        int n5 = 1;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            n5 = -1;
        }
        SDKImage[] sDKImageArray = s_animImageArray[s_curBank];
        short[][] sArray = s_subImages;
        short[] sArray2 = s_frameData[n];
        int n6 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n6; i += primitiveDataCount[s]) {
            s = sArray2[i + 0];
            if (s == 0 || s == 11) {
                short s2 = sArray2[i + 3];
                short s3 = sArray[0][s2];
                short s4 = sArray[1][s2];
                short s5 = sArray[2][s2];
                short s6 = sArray[3][s2];
                short s7 = sArray[4][s2];
                int n7 = s3 & 0xFFFF;
                SDKImage sDKImage = sDKImageArray[n7];
                if (sDKImage == null) continue;
                int n8 = n3 + n5 * sArray2[i + 1];
                int n9 = n4 + sArray2[i + 2];
                if (n5 < 0) {
                    n8 -= s6;
                }
                int n10 = 0;
                if (n5 > 0 && s == 11 || n5 < 0 && s == 0) {
                    n10 = 2;
                }
                Debug.PMGraphics_drawRegion(sDKImage, s4, s5, s6, s7, n10, n8, n9, 20);
                continue;
            }
            if (s == 2 || s == 7) continue;
            AnimationManager.drawPrimitive(n3, n4, sArray2, i, n5);
        }
    }

    public static final boolean drawAnimFrameExt(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        short s;
        if (n < 0) {
            return false;
        }
        int n7 = 1;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            n7 = -1;
        }
        SDKImage[] sDKImageArray = s_animImageArray[s_curBank];
        short[][] sArray = s_subImages;
        boolean bl = false;
        short[] sArray2 = s_frameData[n];
        int n8 = AnimationManager.getFrameOffsetEnd(n, n2);
        short[] sArray3 = n5 >= 0 ? s_frameData[n5] : null;
        block0: for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n8; i += primitiveDataCount[s]) {
            s = sArray2[i + 0];
            if (s == 0 || s == 11) {
                int n9;
                int n10;
                SDKImage sDKImage;
                short s2 = sArray2[i + 3];
                short s3 = sArray[0][s2];
                short s4 = sArray[1][s2];
                short s5 = sArray[2][s2];
                short s6 = sArray[3][s2];
                short s7 = sArray[4][s2];
                int n11 = n3 + n7 * sArray2[i + 1];
                int n12 = n4 + sArray2[i + 2];
                if (n7 < 0) {
                    n11 -= s6;
                }
                if ((sDKImage = sDKImageArray[n10 = s3 & 0xFFFF]) != null) {
                    n9 = 0;
                    if (n7 > 0 && s == 11 || n7 < 0 && s == 0) {
                        n9 = 2;
                    }
                    Debug.PMGraphics_drawRegion(sDKImage, s4, s5, s6, s7, n9, n11, n12, 20);
                }
                if (sArray3 == null) continue;
                n9 = AnimationManager.getAnimFrameCount(n5);
                for (int j = 0; j < n9; ++j) {
                    int n13;
                    int n14;
                    int n15 = AnimationManager.getFrameOffsetStart(n5, j);
                    Debug.ASSERT(sArray3[n15 + 0] == 0, "non-sprite in extras anim");
                    int n16 = sArray3[n15 + 3] & 0xFFFF;
                    if (s2 != n16) continue;
                    int n17 = AnimationManager.getFrameOffsetEnd(n5, j);
                    short s8 = sArray3[n15 + 1];
                    short s9 = sArray3[n15 + 2];
                    int n18 = 0;
                    do {
                        if ((n15 += primitiveDataCount[sArray3[n15 + 0]]) >= n17 || sArray3[n15 + 0] != 0) continue;
                        ++n18;
                    } while (n18 < n6 && n15 < n17);
                    if (nArray != null) {
                        bl = true;
                        n14 = n17 - primitiveDataCount[7];
                        Debug.ASSERT(sArray3[n14 + 0] == 7, "non-firepoint at end of lookup anim frame");
                        nArray[0] = n11 + sArray3[n14 + 1] - s8;
                        nArray[1] = n12 + sArray3[n14 + 2] - s9;
                    }
                    if (n15 >= n17) continue block0;
                    n14 = sArray3[n15 + 1] - s8;
                    int n19 = sArray3[n15 + 2] - s9;
                    short s10 = sArray3[n15 + 3];
                    short s11 = sArray[0][s10];
                    short s12 = sArray[1][s10];
                    short s13 = sArray[2][s10];
                    short s14 = sArray[3][s10];
                    short s15 = sArray[4][s10];
                    int n20 = s11 & 0xFFFF;
                    SDKImage sDKImage2 = sDKImageArray[n20];
                    if (sDKImage == null) continue block0;
                    if (n7 > 0 && s == 11 || n7 < 0 && s == 0) {
                        n13 = 2;
                        short s16 = s14;
                        short s17 = s6;
                        n14 = -n14 - (s16 - s17);
                    } else {
                        n13 = 0;
                    }
                    Debug.PMGraphics_drawRegion(sDKImage2, s12, s13, s14, s15, n13, n14 += n11, n19 += n12, 20);
                    continue block0;
                }
                continue;
            }
            AnimationManager.drawPrimitive(n3, n4, sArray2, i, n7);
        }
        return bl;
    }

    private static void drawPrimitive(int n, int n2, short[] sArray, int n3, int n4) {
        short s = sArray[n3 + 0];
        block0 : switch (s) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                short s2 = sArray[n3 + 3];
                short s3 = sArray[n3 + 4];
                int n5 = n + n4 * sArray[n3 + 1];
                int n6 = n2 + sArray[n3 + 2];
                if (n4 < 0) {
                    n5 -= s2;
                }
                switch (s) {
                    case 3: {
                        Debug.PMGraphics_drawRect(n5, n6, s2, s3);
                        break block0;
                    }
                    case 4: {
                        Debug.PMGraphics_fillRect(n5, n6, s2, s3);
                        break block0;
                    }
                    case 5: {
                        Debug.PMGraphics_drawArc(n5, n6, s2, s3, 0, 360);
                        break block0;
                    }
                    case 6: {
                        Debug.PMGraphics_fillArc(n5, n6, s2, s3, 0, 360);
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                int n7 = n + n4 * sArray[n3 + 1];
                int n8 = n2 + sArray[n3 + 2];
                int n9 = n + n4 * sArray[n3 + 3];
                int n10 = n2 + sArray[n3 + 4];
                Debug.PMGraphics_drawLine(n7, n8, n9, n10);
                break;
            }
            case 10: {
                AnimationManager.setColor(sArray[n3 + 1]);
                break;
            }
        }
    }

    public static final int getAnimFrameCount(int n) {
        return s_frameDurations[n &= 0xFFFFBFFF].length;
    }

    public static final short getAnimFrameDuration(int n, int n2) {
        return s_frameDurations[n &= 0xFFFFBFFF][n2];
    }

    private static final int getPrimitiveX(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return sArray[n + 1];
            }
            case 8: {
                short s = sArray[n + 1];
                short s2 = sArray[n + 3];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private static final int getPrimitiveY(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return sArray[n + 2];
            }
            case 8: {
                short s = sArray[n + 2];
                short s2 = sArray[n + 4];
                return s < s2 ? s : s2;
            }
        }
        return 0;
    }

    private static final int getPrimitiveWidth(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 11: {
                int n2 = sArray[n + 3];
                return s_subImages[3][n2 &= 0xFFFF];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[n + 3];
            }
            case 8: {
                int n3 = sArray[n + 1] - sArray[n + 3];
                return Math.abs(n3);
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    private static final int getPrimitiveHeight(short[] sArray, int n) {
        switch (sArray[n + 0]) {
            case 0: 
            case 11: {
                int n2 = sArray[n + 3];
                return s_subImages[4][n2 &= 0xFFFF];
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return sArray[n + 4];
            }
            case 8: {
                int n3 = sArray[n + 2] - sArray[n + 4];
                return Math.abs(n3);
            }
            case 9: {
                return 0;
            }
        }
        return 0;
    }

    public static final int getAnimFrameWidth(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n6 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n6 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n6 < n3) {
            short s = sArray[n6 + 0];
            if (s != 10) {
                int n7 = AnimationManager.getPrimitiveX(sArray, n6);
                int n8 = n7 + AnimationManager.getPrimitiveWidth(sArray, n6);
                if (n7 < n4) {
                    n4 = n7;
                }
                if (n8 > n5) {
                    n5 = n8;
                }
            }
            n6 += primitiveDataCount[s];
        }
        return n5 - n4;
    }

    public static final int getAnimFrameHeight(int n, int n2) {
        int n3;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MIN_VALUE;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n6 = AnimationManager.getFrameOffsetStart(n, n2);
        if (n6 == (n3 = AnimationManager.getFrameOffsetEnd(n, n2))) {
            return 0;
        }
        while (n6 < n3) {
            short s = sArray[n6 + 0];
            if (s != 10) {
                int n7 = AnimationManager.getPrimitiveY(sArray, n6);
                int n8 = n7 + AnimationManager.getPrimitiveHeight(sArray, n6);
                if (n7 < n4) {
                    n4 = n7;
                }
                if (n8 > n5) {
                    n5 = n8;
                }
            }
            n6 += primitiveDataCount[s];
        }
        return n5 - n4;
    }

    public static final int getAnimFrameFirePointCount(int n, int n2) {
        short s;
        int n3 = 0;
        short[] sArray = s_frameData[n &= 0xFFFFBFFF];
        int n4 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n4; i += primitiveDataCount[s]) {
            s = sArray[i + 0];
            if (s != 7) continue;
            ++n3;
        }
        return n3;
    }

    public static final boolean getAnimFrameFirePoint(int[] nArray, int n, int n2, int n3) {
        short s;
        boolean bl = false;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            bl = true;
        }
        int n4 = 0;
        short[] sArray = s_frameData[n];
        int n5 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n5; i += primitiveDataCount[s]) {
            s = sArray[i + 0];
            if (s != 7) continue;
            if (n4 == n3) {
                nArray[0] = sArray[i + 1];
                nArray[1] = sArray[i + 2];
                if (bl) {
                    nArray[0] = -nArray[0];
                }
                return true;
            }
            ++n4;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        return false;
    }

    public static final boolean getAnimFrameCollisionBox(int[] nArray, int n, int n2, int n3) {
        short s;
        boolean bl = false;
        if ((n & 0x4000) != 0) {
            n &= 0xFFFFBFFF;
            bl = true;
        }
        int n4 = 0;
        short[] sArray = s_frameData[n];
        int n5 = AnimationManager.getFrameOffsetEnd(n, n2);
        for (int i = AnimationManager.getFrameOffsetStart(n, n2); i < n5; i += primitiveDataCount[s]) {
            s = sArray[i + 0];
            if (s != 2) continue;
            if (n4 == n3) {
                nArray[0] = sArray[i + 1];
                nArray[1] = sArray[i + 2];
                nArray[2] = sArray[i + 3];
                nArray[3] = sArray[i + 4];
                if (bl) {
                    // empty if block
                }
                return true;
            }
            ++n4;
        }
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        return false;
    }

    public static final void drawAnim(AnimPlayer animPlayer, int n, int n2) {
        AnimationManager.drawAnimFrame(animPlayer.getAnimID(), animPlayer.getCurrAnimFrame(), n, n2);
    }

    public static final void setBank(int n) {
        if (n >= 0 && n < 3) {
            s_curBank = n;
        }
    }

    public static void Touch_init() {
    }

    public static void Touch_clear() {
    }

    public static void Touch_addTouchData(int n, int n2, int n3, int n4, int n5) {
    }

    public static void PMInput_readKeys() {
        IStringConstants.PMSystem_sleep(5L);
        PMInput_keyLast = PMInput_keyFlag;
        PMInput_keyFlag = PMInput_keyState;
        PMInput_keyState &= ~PMInput_keyClear;
        PMInput_keyClear = 0;
    }

    private static int PMInput_codeToKey(int n) {
        for (int i = 0; i < PMInput_KEY_CODES.length; ++i) {
            for (int j = 0; j < PMInput_KEY_CODES[i].length; ++j) {
                if (n != PMInput_KEY_CODES[i][j]) continue;
                return 1 << i;
            }
        }
        return 0x100000;
    }

    public static void PMInput_keyDown(int n) {
        Event.StateMoreGames_processKey(n);
        PMInput_keyState |= AnimationManager.PMInput_codeToKey(n);
    }

    public static void PMInput_keyUp(int n) {
        PMInput_keyClear |= AnimationManager.PMInput_codeToKey(n);
    }

    public static boolean PMInput_isHeld(int n) {
        return (PMInput_keyFlag & n) > 0;
    }

    public static boolean PMInput_isPressed(int n) {
        return (PMInput_keyFlag & n) > 0 && (PMInput_keyLast & n) == 0;
    }

    public static boolean PMInput_isReleased(int n) {
        return (PMInput_keyLast & n) > 0 && (PMInput_keyFlag & n) == 0;
    }

    public static void PMInput_reset() {
        PMInput_keyFlag = 0;
        PMInput_keyLast = 0;
        PMInput_keyState = 0;
        PMInput_keyClear = 0;
    }

    static {
        s_animImageArray = new SDKImage[3][47];
        subImageFileLoadProgress = 0;
        subImageFileLoadCIndex = 0;
        subImageFileLoadCIndexMax = 0;
        animFileLoadProgress = 0;
        animFileLoadCIndex = 0;
        animFileLoadCIndexMax = 0;
        primitiveBinaryDataCount = new int[]{6, 8, 8, 8, 8, 8, 8, 4, 8, 0, 1, 6};
        primitiveDataCount = new int[]{4, 5, 5, 5, 5, 5, 5, 3, 5, 0, 2, 4};
        Touch_isTouchedNotPressed = false;
        Touch_isKeyboardEnabled = true;
        Touch_touchCount = 0;
        Touch_keyCodeUsed = false;
        Touch_pointerPosX = -1;
        Touch_pointerPosY = -1;
        Touch_pointerDraggedPosX = -1;
        Touch_pointerDraggedPosY = -1;
        Touch_pointerPosPressedX = -1;
        Touch_pointerPosPressedY = -1;
        Touch_pointerReleasedPosX = -1;
        Touch_pointerReleasedPosY = -1;
        Touch_touchedCode = -1;
        Touch_touchDataAdded = false;
        Touch_touchDataAdded2 = false;
        Touch_isUseClickConfirmed = false;
        Touch_ifTouched = false;
        Touch_IsSomethingPressed = false;
        Touch_inName = false;
        SimsUIConstants_SIMSUI_SYMBOL_LOOKUPS = new short[]{53, 9, 52, 42, 43, 51, 34, 26, 1, 10, 11, 12, 22, 2, 3, 4, 6, 5, 0, 23, 18, 19, 24, 29, 27, 30, 31, 32, 33, 37, 35, 38, 39, 40, 41, 25, 14, 15, 13, 16, 17, 20, 21, 7, 8, 14, 0, 10, 13, -13, 4, 4, 40, 2, 3, -14, -15, 109, 568, 7, 1, 553, -20, 562, -21, 564, -22, 547, 548, -16, 550, -17, 551, -18, 552, -19, 9, 107, 5, 498, -5, 3, 499, 500, 106, 518, 8, 519, 77, 2, 110, 5, 213, 6, 104, 7, -10, 108, 4, 105, 3, 0, 1, 2, 3, 4, 0, 644, 1, 9, 610, 611, 614, 615, 613, 276, 10, 515, 514};
        PMInput_keyFlag = 0;
        PMInput_keyLast = 0;
        PMInput_keyState = 0;
        PMInput_keyClear = 0;
        PMInput_KEY_CODES = new int[][]{{4096, 16}, {128}, {524288}, {2048, 4}, {8192, 8}, {512, 1}, {32768, 2}, {256}, {1024}, {16384}, {65536}, {32}, {64}};
    }
}

