/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.state;

import com.ea.sdk.SDKString;
import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.GlobalConstants;
import dk.progressivemedia.skeleton.IStringConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.SimData;
import dk.progressivemedia.skeleton.TileMap;
import java.util.Stack;

public class StateInGame {
    public static boolean hasJustFlownFlag;
    public static boolean raining;
    public static int[] m_tempInt10;
    public static int m_state;
    public static int m_stateTime;
    public static int m_afterFadeState;
    public static int m_nextScene;
    public static int m_nextSceneState;
    public static int m_initialState;
    public static byte m_mapMode;
    public static byte m_mapModePrev;
    public static boolean m_suppressMenus;
    public static int m_hudBottomHeight;
    public static int m_viewportX;
    public static int m_viewportY;
    public static int m_viewportWidth;
    public static int m_viewportHeight;
    public static short m_maxContextMenuItems;
    public static int m_loadingState;
    public static int m_nextSimBank;
    public static int m_loadSimId;
    public static int[] m_palSources;
    public static int[] m_palPatches;
    public static byte m_loadSimCount;
    public static byte[] m_loadedSims;
    public static int CURTAIN_N_Y;
    public static int CURTAIN_S_Y;
    public static int MOOD_H;
    public static boolean courseBought;
    public static long m_playedMapModeMoveMusicTime;
    public static boolean m_tutorialMessageActive;
    public static byte m_tutorialMessageShowing;
    public static int tutMsgStringBody;
    public static int tutMsgStringTitle;
    public static int m_normalTimeStep;
    public static AnimPlayer m_timeAnimPlayer;
    public static AnimPlayer m_buffRisingAnimPlayer;
    public static AnimPlayer m_buffDroppingAnimPlayer;
    public static int m_displayedMoney;
    public static int m_postMessageBox;
    public static int m_curtainState;
    public static int m_curtainPlayerAction;
    public static int m_curtainTime;
    public static short m_tickerString1;
    public static short m_tickerString2;
    public static int m_tickerTimer;
    public static int m_tickerOffsetF;
    public static int m_tickerLengthF;
    public static int m_cameraDestX;
    public static int m_cameraDestZ;
    public static int m_cameraVelX;
    public static int m_cameraVelZ;
    public static int m_cameraLastVelX;
    public static int m_cameraLastVelZ;
    public static boolean m_cameraAtDest;
    public static MapObject m_cameraFollowTarget;
    public static boolean m_cameraFollowTargetReturn;
    public static MapObject[] m_objects;
    public static MapObjectSim[] m_objectsSims;
    public static MapObjectSim m_playerSim;
    public static Stack m_objectStack;
    public static boolean m_refreshObjects;
    public static boolean m_refreshObjectsSims;
    public static boolean m_contextMenuActive;
    public static boolean m_contextMenuOnSubMenu;
    public static short m_contextMenuBackCursor;
    public static short[] m_contextMenuItems;
    public static short[] m_contextMenuActions;
    public static short[] m_contextMenuFullActions;
    public static MapObject m_contextMenuObject;
    public static boolean m_pauseMenuActive;
    public static short[] m_pauseMenuItems;
    public static int m_pauseMenuState;
    public static boolean m_shortcutMenuActive;
    public static boolean m_shortcutByShortcutKey;
    public static short[] m_shortcutMenuItems;
    public static boolean m_quickLinksActive;
    public static short[] m_quickLinksMenu;
    public static int m_infoScreenState;
    public static int m_infoLoadedNPC;
    public static int m_infoScreenSimSelectedIndex;
    public static int m_npcLongestStringLength;
    public static int m_skillLongestStringLength;
    public static int m_motiveLongestStringLength;
    public static int m_infoScreenRecipeSelected;
    public static int m_infoScreenItemSelectedIndex;
    public static int m_jobOfferCareer;
    public static int m_jobOfferLevel;
    public static int m_payIncome;
    public static boolean m_quitJobConfirmed;
    public static boolean m_showBonusUnlocked;
    public static boolean m_showNewDream;
    public static AnimPlayer[] m_dreamAnimPlayers;
    public static int m_showGetItem;
    public static int m_showGetItemQty;
    public static int m_showGetItemTitle;
    public static int m_showGetItemMessage;
    public static int m_simAIEventTimer;
    public static int m_ambientEventTimer;
    public static short[] m_ambientSounds;
    public static int m_ambientSoundRate;
    public static int m_simInactivityTimer;
    public static int lastVisitorTime;
    public static int currentVisitorChance;
    public static final short[] AMBIENT_SOUNDS_MM;
    public static final short[] AMBIENT_SOUNDS_BEIJING;
    public static final short[] AMBIENT_SOUNDS_CAIRO;
    public static final short[] AMBIENT_SOUNDS_PARIS;
    public static final short[] AMBIENT_SOUNDS_SANFRAN;
    public static int m_actionQueueSize;
    public static int[] m_actionQueueActions;
    public static MapObject[] m_actionQueueArg1s;
    public static int[] m_actionQueueArg2s;
    public static int[] m_actionQueueArg3s;
    public static int m_displayedMoodLevel;
    public static int m_timeHit;
    public static AnimPlayer m_playerGemAnimPlayer;
    public static int m_shoppingState;
    public static int m_shoppingObjectType;
    public static int m_shoppingTradeAmount;
    public static long timeStamp;
    public static int timeInterval;
    public static boolean m_isCursorOnMove;
    public static int cursorScrollX;
    public static int cursorScrollZ;

    public static boolean isHouseMode() {
        return m_mapMode == 0;
    }

    public static boolean isMapMode() {
        return m_mapMode == 2;
    }

    public static boolean isZoomMapMode() {
        return m_mapMode == 1;
    }

    public static void updateLoading(int n) {
        Event.LoadingScreen_update(n);
        StateInGame.updateLoadingState();
        if (Main.softPressNeg()) {
            StateInGame.showPauseMenu();
        }
    }

    public static void updateLoadingState() {
        switch (m_loadingState) {
            default: {
                break;
            }
            case 0: {
                ++m_loadingState;
                break;
            }
            case 1: {
                Main.m_simWorld.setViewport(m_viewportX, m_viewportY, m_viewportWidth, m_viewportHeight);
                m_refreshObjects = true;
                m_refreshObjectsSims = true;
                boolean bl = true;
                if (m_mapMode == 2) {
                    StateInGame.initMacroMap();
                } else if (m_mapMode == 1) {
                    StateInGame.initZoomMap();
                    if (StateInGame.getSimObjects().length > 1) {
                        bl = false;
                    }
                } else {
                    StateInGame.initHouseMap();
                }
                if (bl) {
                    MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
                    int n = mapObjectSim.getPosX();
                    int n2 = mapObjectSim.getPosZ();
                    Cursor.m_cursorDestX = Main.m_simWorld.coordWorldToScreenX(n, n2);
                    Cursor.m_cursorDestZ = Main.m_simWorld.coordWorldToScreenY(n, n2);
                }
                Cursor.m_cursorPosX = Cursor.m_cursorDestX;
                Cursor.m_cursorPosZ = Cursor.m_cursorDestZ;
                StateInGame.clearCameraFollow();
                StateInGame.snapCameraPosition();
                ++m_loadingState;
                Main.loadImagesBegin();
                break;
            }
            case 2: {
                int n = 8;
                switch (m_mapMode) {
                    default: {
                        Debug.ASSERT(false, "invalid map mode");
                    }
                    case 2: {
                        n |= 0x20;
                        break;
                    }
                    case 0: {
                        if (Main.isAirport(Main.m_simWorld.getHouseId())) {
                            n |= 0x20000000;
                            break;
                        }
                        n |= 0x10;
                        break;
                    }
                    case 1: {
                        if (Main.getNextZoomMapId() == 57) {
                            n |= 0x2000000;
                            break;
                        }
                        if (Main.getNextZoomMapId() == 58) {
                            n |= 0x4000000;
                            break;
                        }
                        if (Main.getNextZoomMapId() == 60) {
                            n |= 0x8000000;
                            break;
                        }
                        if (Main.getNextZoomMapId() == 61) {
                            n |= 0x10000000;
                            break;
                        }
                        if (Main.getNextZoomMapId() != 62) break;
                        n |= 0x20000;
                    }
                }
                if (!Main.loadImagesNext(n)) break;
                ++m_loadingState;
                break;
            }
            case 3: {
                if (StateInGame.isMapMode()) {
                    int[] nArray = Main.m_simWorld.getPatch(0);
                    int n = 0;
                    int[] nArray2 = Main.m_simWorld.getPatch(1);
                    AnimationManager.loadImage(15, nArray, nArray2, n);
                    AnimationManager.loadImage(13, nArray, nArray2, n);
                    nArray2 = Main.m_simWorld.getPatch(2);
                    AnimationManager.loadImage(15, nArray, nArray2, ++n);
                    AnimationManager.loadImage(13, nArray, nArray2, n);
                    nArray2 = Main.m_simWorld.getPatch(3);
                    AnimationManager.loadImage(15, nArray, nArray2, ++n);
                    AnimationManager.loadImage(13, nArray, nArray2, n);
                    ++n;
                    StateInGame.loadPlayerSim();
                    ++m_loadingState;
                    break;
                }
                StateInGame.loadNewSimBegin();
                while (m_loadSimCount > 0) {
                    StateInGame.updateLoadSim();
                }
                ++m_loadingState;
                break;
            }
            case 4: {
                if (StateInGame.isMapMode()) {
                    m_ambientSounds = AMBIENT_SOUNDS_MM;
                    m_ambientSoundRate = 3000;
                } else {
                    int n = Main.getNextZoomMapId();
                    if (n == 57) {
                        m_ambientSounds = AMBIENT_SOUNDS_BEIJING;
                        m_ambientSoundRate = 15000;
                    } else if (n == 58) {
                        m_ambientSounds = AMBIENT_SOUNDS_CAIRO;
                        m_ambientSoundRate = 12000;
                    } else if (n == 60) {
                        m_ambientSounds = AMBIENT_SOUNDS_PARIS;
                        m_ambientSoundRate = 13000;
                    } else if (n == 61) {
                        m_ambientSounds = AMBIENT_SOUNDS_SANFRAN;
                        m_ambientSoundRate = 14000;
                    } else if (n != -1) {
                        m_ambientSounds = AMBIENT_SOUNDS_MM;
                        m_ambientSoundRate = 10000;
                    } else {
                        m_ambientSounds = null;
                    }
                }
                ++m_loadingState;
                break;
            }
            case 5: {
                StateInGame.stateTransition(m_initialState);
                if (StateInGame.isMapMode()) {
                    StateInGame.showTutorialMessage((byte)2);
                } else if (StateInGame.isHouseMode()) {
                    if (Main.getNextHouseId() == 0) {
                        currentVisitorChance = 5;
                        if (lastVisitorTime == 0) {
                            lastVisitorTime = Main.m_simData.getGameTimeAbs() - 48 * 60;
                        }
                        StateInGame.showTutorialMessage((byte)0);
                    }
                    if (!Main.m_simData.initMsgHasShownAtAirport && Main.getNextHouseId() == 8) {
                        Main.m_simData.initMsgHasShownAtAirport = true;
                        StateInGame.showMessageBox(830, 829);
                    }
                }
                if (StateInGame.isZoomMapMode() && Main.getNextZoomMapId() == 58 && Main.m_simData.timeArrivedInCairo != -1) {
                    Main.m_simData.timeArrivedInCairo = Main.m_simData.getGameTimeAbs();
                }
                ArrayHandler.PostEffects_startFadeIn();
            }
        }
    }

    public static void initSimAssets() {
        Event.PMDebug_println("initSimAssets start");
        m_nextSimBank = 0;
        m_loadSimId = 0;
        m_loadSimCount = 0;
        if (!StateInGame.isMapMode()) {
            if (m_loadedSims == null) {
                m_loadedSims = new byte[3];
            }
            ArrayHandler.fillArray(m_loadedSims, -1);
        }
        Event.PMDebug_println("initSimAssets end");
    }

    public static void loadNewSim(MapObjectSim mapObjectSim) {
        if (!StateInGame.isMapMode()) {
            Debug.ASSERT(m_loadSimId == -1 || m_state == 1, "trying to load too many sims mid-frame");
            if (m_loadSimId != -1 && m_state != 1) {
                return;
            }
            m_loadSimCount = (byte)(m_loadSimCount + 1);
            int n = StateInGame.nextAvailableBank();
            Debug.ASSERT(n != -1, "no banks available to load sim");
            if (n != -1) {
                StateInGame.m_loadedSims[n] = (byte)mapObjectSim.getId();
            }
        }
    }

    public static void loadNewSimBegin() {
        for (int i = 0; i < 3; ++i) {
            MapObjectSim mapObjectSim;
            int n = m_loadedSims[i];
            if (n == -1 || (mapObjectSim = StateInGame.findSim(n)).getBank() != -1) continue;
            Event.PMDebug_println(2, "loadNewSimBegin: simId = {0}, bank = {1}", n, i);
            m_nextSimBank = i;
            m_loadSimId = n;
            Main.m_simWorld.getSimPatches(n, m_palSources, m_palPatches);
            Main.loadImagesBegin();
            return;
        }
        Debug.ASSERT(false, "shouldn't get to here");
    }

    public static int nextAvailableBank() {
        return ArrayHandler.indexOf(-1, m_loadedSims);
    }

    public static void renderLoadSim() {
        Debug.UserInterface_drawGenericMessageBox();
        StateInGame.renderSoftkeyBar();
    }

    public static void updateLoadSim() {
        if (m_loadSimId == -1) {
            m_loadSimCount = (byte)(m_loadSimCount - 1);
            return;
        }
        int n = m_nextSimBank;
        int n2 = m_loadSimId;
        int n3 = Main.m_simData.getSimAttribute(n2, 0) == 0 ? 512 : 256;
        IStringConstants.PMSystem_forceGC();
        if (Main.loadImagesNext(n3, m_palSources, m_palPatches, n)) {
            int n4 = StateInGame.getSimHairImage(n2);
            AnimationManager.loadImage(n4, m_palSources, m_palPatches, n);
            MapObjectSim mapObjectSim = StateInGame.findSim(n2);
            mapObjectSim.setBank(n);
            m_loadSimId = -1;
            m_nextSimBank = n + 1;
            m_loadSimCount = (byte)(m_loadSimCount - 1);
            if (n2 == 0) {
                StateInGame.loadPlayerSim();
            }
            Event.PMDebug_println("finished loading sim");
            if (m_loadSimCount > 0) {
                Event.PMDebug_println("loading next sim");
                StateInGame.loadNewSimBegin();
            }
        }
    }

    public static void loadPlayerSim() {
        Main.m_simWorld.getSimPatches(0, m_palSources, m_palPatches);
        int n = Main.m_simData.getSimAttribute(0, 0) == 0 ? 4096 : 8192;
        Main.loadAllImages(n, m_palSources, m_palPatches, 0);
    }

    public static int getSimHairImage(int n) {
        int n2 = Main.m_simData.getSimAttribute(n, 2);
        if (Main.m_simData.getSimAttribute(n, 0) == 0) {
            return n2 == 0 ? 38 : (n2 == 1 ? 39 : (n2 == 2 ? 40 : 41));
        }
        return n2 == 0 ? 30 : (n2 == 1 ? 31 : (n2 == 2 ? 32 : 33));
    }

    public static void init(int n) {
        Event.PMDebug_println("StateInGame.starting");
        CURTAIN_N_Y = 28;
        MOOD_H = AnimationManager.getAnimFrameHeight(253, 0);
        CURTAIN_S_Y = 245 - MOOD_H;
        Main.m_simData.newScene();
        if (Debug.UserInterface_m_arrowLeftAnimPlayer == null) {
            Debug.UserInterface_m_arrowLeftAnimPlayer = new AnimPlayer();
            Debug.UserInterface_m_arrowRightAnimPlayer = new AnimPlayer();
        }
        m_state = 0;
        m_stateTime = 0;
        m_afterFadeState = 0;
        m_nextScene = -1;
        m_nextSceneState = -1;
        m_suppressMenus = false;
        m_hudBottomHeight = AnimationManager.getAnimFrameHeight(254, 0) + AnimationManager.getAnimFrameHeight(253, 0);
        m_viewportX = 0;
        m_viewportY = 0;
        m_viewportWidth = 240 - m_viewportX;
        m_viewportHeight = 245 - m_viewportY - m_hudBottomHeight;
        m_maxContextMenuItems = (short)(m_viewportHeight / 26);
        StateInGame.initSimAssets();
        m_playedMapModeMoveMusicTime = -1L;
        m_tutorialMessageActive = false;
        m_normalTimeStep = 0;
        m_displayedMoney = Main.m_simData.getMoney();
        m_postMessageBox = 0;
        m_curtainState = 0;
        m_tickerString1 = (short)-1;
        m_tickerString2 = (short)-1;
        Cursor.m_cursorObject = null;
        Cursor.m_cursorSelectFlags = 0;
        Cursor.m_cursorSnapping = false;
        Cursor.m_keyLeft = false;
        Cursor.m_keyRight = false;
        Cursor.m_keyDown = false;
        Cursor.m_keyUp = false;
        m_cameraDestX = 0;
        m_cameraDestZ = 0;
        m_cameraVelX = 0;
        m_cameraVelZ = 0;
        m_cameraLastVelX = 0;
        m_cameraLastVelZ = 0;
        m_cameraAtDest = false;
        m_cameraFollowTarget = null;
        m_cameraFollowTargetReturn = false;
        m_objects = null;
        m_objectsSims = null;
        m_playerSim = null;
        if (m_objectStack == null) {
            m_objectStack = new Stack();
        }
        m_objectStack.removeAllElements();
        m_refreshObjects = true;
        m_refreshObjectsSims = true;
        m_contextMenuActive = false;
        m_contextMenuOnSubMenu = false;
        m_contextMenuBackCursor = 0;
        if (m_contextMenuItems == null) {
            m_contextMenuItems = new short[55];
            m_contextMenuActions = new short[55];
            m_contextMenuFullActions = new short[55];
        }
        m_contextMenuObject = null;
        m_pauseMenuActive = false;
        if (m_pauseMenuItems == null) {
            short[] sArray = new short[15];
            Main.menuClear(sArray, 48, GlobalConstants.StateMenu_getMaxMenuItemsPerScreen());
            Main.menuAppendItem(sArray, 49);
            Main.menuAppendItem(sArray, 41);
            Main.menuAppendItem(sArray, 42);
            if (Main.m_simData.timeArrivedInCairo == -1) {
                Main.menuAppendItem(sArray, 52);
            }
            Main.menuAppendItem(sArray, 54);
            Main.menuAppendItem(sArray, 56);
            Main.menuAppendItem(sArray, 58);
            m_pauseMenuItems = sArray;
        }
        m_pauseMenuState = 0;
        m_shortcutMenuActive = false;
        m_shortcutByShortcutKey = false;
        if (m_shortcutMenuItems == null) {
            m_shortcutMenuItems = new short[20];
        }
        m_quickLinksActive = false;
        if (m_quickLinksMenu == null) {
            m_quickLinksMenu = new short[25];
        }
        m_infoScreenState = -1;
        m_infoLoadedNPC = 0;
        m_infoScreenSimSelectedIndex = 0;
        m_infoScreenRecipeSelected = 0;
        m_infoScreenItemSelectedIndex = 0;
        m_jobOfferCareer = 0;
        m_jobOfferLevel = 0;
        m_payIncome = 0;
        m_quitJobConfirmed = false;
        m_showBonusUnlocked = false;
        if (Event.PMStateManager_lastState == 1) {
            m_showNewDream = false;
        }
        m_showGetItem = -1;
        m_showGetItemQty = 0;
        m_showGetItemTitle = 0;
        m_showGetItemMessage = 0;
        m_simAIEventTimer = 0;
        m_ambientEventTimer = 0;
        m_ambientSounds = null;
        m_simInactivityTimer = 0;
        StateInGame.initActionQueue();
        m_displayedMoodLevel = Main.m_simData.getMoodLevel();
        m_timeHit = 0;
        Event.m_eventState = 0;
        Event.m_preEventCursorObject = null;
        m_shoppingState = 0;
        if (m_timeAnimPlayer == null) {
            m_timeAnimPlayer = new AnimPlayer();
            m_buffRisingAnimPlayer = new AnimPlayer();
            m_buffDroppingAnimPlayer = new AnimPlayer();
            Cursor.m_cursorAnimPlayer = new AnimPlayer();
            m_dreamAnimPlayers = new AnimPlayer[4];
            int n2 = 0;
            while (true) {
                if (n2 >= 4) break;
                StateInGame.m_dreamAnimPlayers[n2] = new AnimPlayer();
                ++n2;
            }
            m_playerGemAnimPlayer = new AnimPlayer();
        }
        m_timeAnimPlayer.startAnim(304, 20);
        m_buffRisingAnimPlayer.startAnim(272, 20);
        m_buffDroppingAnimPlayer.startAnim(271, 20);
        Cursor.m_cursorAnimPlayer.startAnim(231, 20);
        m_playerGemAnimPlayer.startAnim(249, 20);
        Debug.UserInterface_initUI();
        if (Event.PMStateManager_lastState == 1) {
            Main.m_nextZoomMapId = -1;
        }
        m_mapModePrev = m_mapMode;
        m_mapMode = 0;
        if (n == 99) {
            m_mapModePrev = m_mapMode;
            m_mapMode = (byte)2;
        } else if (n == 98) {
            m_mapModePrev = m_mapMode;
            m_mapMode = (byte)2;
            n = 5;
        } else if (n == 100) {
            m_mapModePrev = m_mapMode;
            m_mapMode = 1;
            n = 5;
        } else if (n == -1) {
            n = 5;
        }
        m_initialState = n;
        StateInGame.stateTransition(1);
        Event.PMDebug_println("StateInGame.started!");
    }

    public static void deinit() {
        if (Event.PMStateManager_nextState == 3) {
            return;
        }
        m_pauseMenuItems = null;
        Main.m_simWorld.unload();
        Main.DEBUG_MEMORY("StateInGame.end: unloaded Main.m_simWorld");
        int n = 1040348152;
        if (Event.PMStateManager_nextState == 0) {
            n &= 0xFFFFFFF7;
        }
        Main.unloadAllImages(n, -1);
        Main.DEBUG_MEMORY("StateInGame.end: unloaded images");
        Main.DEBUG_MEMORY("StateInGame.ended");
    }

    public static void render() {
        switch (m_state) {
            default: {
                break;
            }
            case 1: {
                Event.LoadingScreen_draw(false);
                break;
            }
            case 5: {
                StateInGame.renderMain();
                StateInGame.renderSoftkeyBar();
                break;
            }
            case 6: {
                StateInGame.renderLoadSim();
                break;
            }
            case 8: {
                StateInGame.renderInfoScreen();
                break;
            }
            case 3: 
            case 9: 
            case 21: {
                StateInGame.renderMain();
                if (!m_pauseMenuActive) {
                    ArrayHandler.PostEffects_renderBackgroundDim();
                    Debug.UserInterface_drawGenericMessageBox();
                }
                StateInGame.renderSoftkeyBar();
                break;
            }
            case 10: {
                StateInGame.renderJobOffer();
                break;
            }
            case 11: {
                StateInGame.renderPay();
                break;
            }
            case 12: {
                StateInGame.renderRaiseFailure();
                break;
            }
            case 13: {
                StateInGame.renderQuitJob();
                break;
            }
            case 14: {
                StateInGame.renderNewDream();
                break;
            }
            case 15: {
                StateInGame.renderShowGetItem();
                break;
            }
            case 16: {
                if (IStringConstants.Minigame_renderInGame) {
                    StateInGame.renderMain();
                }
                IStringConstants.Minigame_renderMiniGame();
                break;
            }
            case 17: {
                GlobalConstants.StateMenu_page = 9;
                StateInGame.renderShopping();
                break;
            }
            case 19: {
                Event.renderEvent();
                break;
            }
            case 20: {
                ArrayHandler.Tour_render();
            }
        }
        ArrayHandler.PostEffects_renderFade(-1);
        Debug.renderDebug();
        Debug.renderPerf();
    }

    public static void renderSoftkeyBar() {
        Main.renderSoftkeyBar();
        AnimationManager.drawAnimFrame(270, 0, 120, 260);
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 270, 0, 0);
        int n = 120 + m_tempInt10[0];
        int n2 = 260 + m_tempInt10[1];
        SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendMoneyToBuffer(m_displayedMoney);
        GameConstants.TextHandler_drawString(sDKString, 2, n, n2, 24);
    }

    public static void renderMain() {
        Main.m_simWorld.renderWorld();
        if (raining) {
            Debug.Rain_draw();
        }
        if (!m_quickLinksActive) {
            StateInGame.renderHUDTop();
        }
        if (StateInGame.isCurtainActive()) {
            StateInGame.renderCurtain();
        }
        if (m_pauseMenuActive) {
            Cursor.renderCursor();
            StateInGame.renderContextRelationships();
            StateInGame.renderHUDBottom();
            StateInGame.renderHUDMoodSim();
            StateInGame.renderPauseMenu();
        } else if (!m_suppressMenus && m_contextMenuActive) {
            StateInGame.renderContextRelationships();
            StateInGame.renderHUDBottom();
            StateInGame.renderHUDMoodSim();
            StateInGame.renderContextMenu();
        } else if (m_tutorialMessageActive) {
            StateInGame.renderContextRelationships();
            StateInGame.renderHUDBottom();
            StateInGame.renderHUDMoodSim();
            ArrayHandler.PostEffects_renderBackgroundDim();
            if (!m_pauseMenuActive) {
                Debug.UserInterface_prepareTextScreen(tutMsgStringBody, tutMsgStringTitle, false);
            }
            Debug.UserInterface_drawTextScreen();
        } else {
            if (m_state != 16) {
                Cursor.renderCursor();
            }
            StateInGame.renderContextRelationships();
            StateInGame.renderHUDBottom();
            StateInGame.renderHUDMoodSim();
            if (!m_suppressMenus && m_shortcutMenuActive) {
                StateInGame.renderShortcutMenu();
            }
        }
    }

    public static void processKeys() {
        if (m_state == 1 || StateInGame.isCurtainActive() && m_curtainState != 2 && !m_pauseMenuActive) {
            return;
        }
        if (m_afterFadeState != 0) {
            StateInGame.stateTransition(m_afterFadeState);
            m_afterFadeState = 0;
            return;
        }
        if (ArrayHandler.PostEffects_isFading()) {
            return;
        }
        if (m_pauseMenuActive) {
            StateInGame.processKeysPauseMenu();
        } else if (!m_suppressMenus && m_contextMenuActive) {
            StateInGame.processKeysContextMenu();
        } else if (!m_suppressMenus && m_shortcutMenuActive) {
            StateInGame.processKeysShortcutMenu();
        } else if (m_tutorialMessageActive) {
            StateInGame.processKeysTutorialMessage();
        } else if (m_quickLinksActive) {
            StateInGame.processKeysQuickLinks();
        } else {
            switch (m_state) {
                default: {
                    break;
                }
                case 3: {
                    StateInGame.processKeysSavePrompt();
                    break;
                }
                case 5: {
                    StateInGame.processKeysMain();
                    break;
                }
                case 6: {
                    break;
                }
                case 8: {
                    StateInGame.processKeysInfoScreen();
                    break;
                }
                case 9: {
                    StateInGame.processKeysMessageBox();
                    break;
                }
                case 10: {
                    StateInGame.processKeysJobOffer();
                    break;
                }
                case 11: {
                    StateInGame.processKeysPay();
                    break;
                }
                case 12: {
                    StateInGame.processKeysRaiseFailure();
                    break;
                }
                case 13: {
                    StateInGame.processKeysQuitJob();
                    break;
                }
                case 14: {
                    StateInGame.processKeysNewDream();
                    break;
                }
                case 15: {
                    StateInGame.processKeysShowGetItem();
                    break;
                }
                case 16: {
                    IStringConstants.Minigame_processKeysMiniGame();
                    break;
                }
                case 17: {
                    StateInGame.processKeysShopping();
                    break;
                }
                case 19: {
                    Event.processKeysEvent();
                    break;
                }
                case 20: {
                    ArrayHandler.Tour_processKeys();
                    break;
                }
                case 21: {
                    StateInGame.processKeysCooking();
                }
            }
        }
    }

    public static void processKeysCooking() {
        if (Main.softPressPos() || AnimationManager.PMInput_isPressed(1)) {
            courseBought = true;
            Main.m_simData.adjustMoney(-Main.m_simWorld.cookingSchoolIsMoreRecipesAvailable(), false);
            m_playerSim.endSimPhase();
            StateInGame.stateTransition(5);
        } else if (Main.softPressNeg()) {
            courseBought = false;
            m_playerSim.endSimPhase();
            StateInGame.stateTransition(5);
        }
    }

    public static void processKeysSavePrompt() {
        if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            Main.saveRMSAppSettings();
            Main.saveRMSGameData();
            StateInGame.fadeStateTransition(2);
        } else if (Main.softPressNeg()) {
            StateInGame.fadeStateTransition(2);
        }
    }

    public static void processKeysMain() {
        if (Main.softPressNeg()) {
            StateInGame.showPauseMenu();
            return;
        }
        if (Main.softPressPos()) {
            StateInGame.showShortcutMenu();
            return;
        }
        Cursor.processKeysCursor();
        if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            Cursor.processKeysFire();
        }
    }

    public static void updateStep(int n) {
        m_stateTime += n;
        if (m_state == 1) {
            StateInGame.updateLoading(n);
            return;
        }
        StateInGame.updateHUD(n);
        GameConstants.TextHandler_updateScrollers(n);
        switch (m_state) {
            default: {
                break;
            }
            case 5: {
                StateInGame.updateMain(n);
                break;
            }
            case 6: {
                StateInGame.updateLoadSim();
                if (m_loadSimCount != 0) break;
                StateInGame.stateTransition(5);
                break;
            }
            case 8: {
                StateInGame.updateInfoScreen(n);
                break;
            }
            case 16: {
                IStringConstants.Minigame_updateMiniGame(n);
                break;
            }
            case 19: {
                Event.updateEvent(n);
                break;
            }
            case 20: {
                ArrayHandler.Tour_update(n);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                break;
            }
            case 17: {
                Debug.UserInterface_m_storeHeaderAnimPlayer.updateAnim(n);
            }
        }
    }

    public static void stateTransition(int n) {
        int n2 = m_state;
        m_state = n;
        m_stateTime = 0;
        m_suppressMenus = true;
        GameConstants.TextHandler_resetScrollers();
        Cursor.stopCursor();
        switch (n) {
            default: {
                break;
            }
            case 1: {
                m_loadingState = 0;
                m_contextMenuActive = false;
                m_pauseMenuActive = false;
                break;
            }
            case 2: {
                Event.PMStateManager_set(3, 1);
                break;
            }
            case 3: {
                StateInGame.hideMenus();
                Debug.UserInterface_prepareGenericMessageBox(66, 51);
                break;
            }
            case 4: {
                Main.saveRMSGameData();
                Event.PMStateManager_set(-1, 0);
                break;
            }
            case 5: {
                Cursor.setCursorSelectFlags(1);
                m_suppressMenus = false;
                if (n2 != 21 || !courseBought) break;
                m_playerSim.beginSimAction(137, null);
                break;
            }
            case 6: {
                StateInGame.loadNewSimBegin();
                Debug.UserInterface_prepareGenericMessageBox(13, 14);
                break;
            }
            case 11: {
                m_payIncome = Main.m_simData.careerDayWorked();
                Debug.UserInterface_prepareGenericMessageBox(605, 604);
                break;
            }
            case 15: {
                Debug.UserInterface_prepareGenericMessageBox(m_showGetItemMessage, m_showGetItemTitle);
                break;
            }
            case 21: {
                Debug.UserInterface_prepareGenericMessageBox(949, 948);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 19: {
                break;
            }
            case 17: {
                if (Debug.UserInterface_m_storeHeaderAnimPlayer == null) {
                    Debug.UserInterface_m_storeHeaderAnimPlayer = new AnimPlayer();
                }
                Debug.UserInterface_m_storeHeaderAnimPlayer.startAnim(301, 4);
            }
        }
        StateInGame.setupSoftkeys();
    }

    public static void fadeStateTransition(int n) {
        m_afterFadeState = n;
        if (!ArrayHandler.PostEffects_isFadingOut()) {
            ArrayHandler.PostEffects_startFadeOut();
        }
        Cursor.stopCursor();
    }

    public static void changeSceneWithSavePrompt(int n, int n2) {
        if (Main.getSavePromptsEnabled()) {
            m_nextScene = n;
            m_nextSceneState = n2;
            StateInGame.stateTransition(3);
        } else {
            StateInGame.changeSceneWithFade(n, n2);
        }
    }

    public static void changeSceneWithFade(int n, int n2) {
        m_nextScene = n;
        m_nextSceneState = n2;
        StateInGame.fadeStateTransition(2);
    }

    public static void changeScene(int n, int n2) {
        m_nextScene = n;
        m_nextSceneState = n2;
        StateInGame.stateTransition(2);
    }

    public static void setupSoftkeys() {
        int n = 0;
        int n2 = 0;
        if (m_pauseMenuActive) {
            if (m_pauseMenuState == 1 || m_pauseMenuState == 2 || m_pauseMenuState == 3 || m_pauseMenuState == 4) {
                n2 = 512;
                n = 256;
            } else {
                n2 = 4;
                n = 16;
            }
        } else if (!m_suppressMenus && m_contextMenuActive) {
            n2 = 4;
            n = 16;
        } else if (!m_suppressMenus && m_shortcutMenuActive) {
            n2 = 4;
            n = 16;
        } else if (m_tutorialMessageActive) {
            if (m_tutorialMessageShowing == 0) {
                n = 256;
                n2 = 512;
            } else {
                n = 8;
            }
        } else if (m_quickLinksActive) {
            n2 = 4;
            n = 16;
        } else {
            block0 : switch (m_state) {
                default: {
                    break;
                }
                case 3: {
                    n2 = 512;
                    n = 256;
                    break;
                }
                case 5: {
                    n2 = 1;
                    n = 1024;
                    break;
                }
                case 6: {
                    break;
                }
                case 8: {
                    switch (m_infoScreenState) {
                        default: {
                            break block0;
                        }
                        case 0: {
                            n2 = 4;
                            n = Main.m_simData.getRelationshipNthCount() > 0 ? 16 : 0;
                            break block0;
                        }
                        case 3: {
                            if (Main.m_simData.getDream() != -1 && Main.m_simData.isDreamToPromisePossible()) {
                                n = 8;
                            }
                        }
                        case 1: 
                        case 2: 
                        case 4: 
                        case 5: 
                        case 9: 
                        case 10: {
                            n2 = 4;
                            break block0;
                        }
                        case 6: 
                    }
                    n = 0;
                    n2 = 4;
                    int n3 = StateInGame.getInfoItem();
                    if (n3 == -1 || (Main.m_simWorld.getItemFlags(n3) & 0x80) == 0) break;
                    n = 16;
                    break;
                }
                case 9: {
                    n2 = 0;
                    n = 8;
                    break;
                }
                case 21: {
                    n2 = 512;
                    n = 256;
                    break;
                }
                case 10: {
                    if (m_jobOfferCareer != -1) {
                        n2 = 512;
                        n = 256;
                        break;
                    }
                    n = 8;
                    break;
                }
                case 11: {
                    n = 8;
                    break;
                }
                case 12: {
                    n = 8;
                    break;
                }
                case 13: {
                    if (m_quitJobConfirmed) {
                        n = 8;
                        break;
                    }
                    n2 = 512;
                    n = 256;
                    break;
                }
                case 14: {
                    n2 = 128;
                    n = 8;
                    break;
                }
                case 15: {
                    n = 8;
                    break;
                }
                case 16: {
                    n2 = 1;
                    if (IStringConstants.Minigame_m_miniGameType != 3) {
                        n = 64;
                        break;
                    }
                    if (IStringConstants.Minigame_m_miniGameState == 4) {
                        if (Main.m_simData.getMoney() > GameConstants.MinigameWorldknowledge_price) {
                            Main.setSoftKeys(512, 256);
                        } else {
                            Main.setSoftKeys(0, 8);
                        }
                        return;
                    }
                    if (IStringConstants.Minigame_m_miniGameState != 5) break;
                    Main.setSoftKeys(0, 8);
                    return;
                }
                case 17: {
                    int n4 = m_shoppingState;
                    if (n4 != 0) break;
                    n2 = 4;
                    if (m_shoppingTradeAmount > 0) {
                        n = 4096;
                        break;
                    }
                    if (m_shoppingTradeAmount >= 0) break;
                    n = 8192;
                    break;
                }
                case 19: {
                    switch (Event.m_eventState) {
                        case 3: {
                            n = 8;
                            break block0;
                        }
                    }
                    break;
                }
                case 20: {
                    n2 = 64;
                }
            }
        }
        Main.setSoftKeys(n2, n);
    }

    public static void hideMenus() {
        if (m_contextMenuActive) {
            StateInGame.hideContextMenu();
        }
        if (m_shortcutMenuActive) {
            StateInGame.hideShortcutMenu();
        }
        if (m_quickLinksActive) {
            StateInGame.hideQuickLinks();
        }
    }

    public static void playerMovingOnMapMode() {
        if (m_playedMapModeMoveMusicTime == -1L) {
            m_playedMapModeMoveMusicTime = ArrayOptimizer.PMTimer_tick();
        }
    }

    public static void kickPlayer(int n, int n2) {
        StateInGame.showMessageBox(n, n2, 1);
    }

    public static void killPlayer(int n) {
        GameConstants.TextHandler_dynamicString(-11, n, Main.getSimName());
        Event.triggerEvent(0, -11, -1);
        Main.startMusic(-1);
        m_ambientSounds = null;
    }

    public static void passOut() {
        m_playerSim.beginSimAction(6, null);
        StateInGame.startCurtainIn();
    }

    public static void goHome() {
        Main.setNextHouseId(0);
        StateInGame.changeSceneWithSavePrompt(0, 5);
    }

    public static void gotoWork() {
        StateInGame.changeSceneWithSavePrompt(0, 99);
    }

    public static void gotoMap() {
        StateInGame.changeSceneWithSavePrompt(0, 98);
    }

    public static void gotoMapForObject(MapObject mapObject) {
        int n = mapObject.getType();
        if (n == 1) {
            Main.setupEncounter((MapObjectSim)mapObject);
            Main.setNextZoomMapId(62);
            StateInGame.changeSceneWithSavePrompt(0, 100);
        } else {
            int n2 = Main.m_simWorld.getHouseForObject(n);
            Main.setNextHouseId(n2);
            StateInGame.changeSceneWithSavePrompt(0, -1);
        }
    }

    public static void showTutorialMessage(byte by) {
        m_tutorialMessageShowing = by;
        if (Main.getRMSHasSeenTutorial(by)) {
            return;
        }
        Main.setRMSHasSeenTutorial(by);
        if (!Main.getTutorialsEnabled()) {
            return;
        }
        tutMsgStringBody = 0;
        tutMsgStringTitle = 0;
        switch (by) {
            default: {
                Debug.ASSERT(false, "Invalid message ID");
            }
            case 0: {
                tutMsgStringTitle = 74;
                tutMsgStringBody = 76;
                break;
            }
            case 1: {
                tutMsgStringTitle = 74;
                tutMsgStringBody = 75;
                break;
            }
            case 2: {
                tutMsgStringTitle = 77;
                tutMsgStringBody = 78;
                break;
            }
            case 3: {
                tutMsgStringTitle = 81;
                tutMsgStringBody = 82;
                break;
            }
            case 4: {
                tutMsgStringTitle = 79;
                tutMsgStringBody = 80;
                break;
            }
            case 5: {
                tutMsgStringTitle = 83;
                tutMsgStringBody = 84;
                break;
            }
            case 6: {
                tutMsgStringTitle = 85;
                tutMsgStringBody = 86;
                break;
            }
            case 9: {
                tutMsgStringTitle = 89;
                tutMsgStringBody = 90;
                break;
            }
            case 10: {
                tutMsgStringTitle = 91;
                tutMsgStringBody = 92;
                break;
            }
            case 7: {
                tutMsgStringTitle = 87;
                tutMsgStringBody = 88;
                break;
            }
            case 11: {
                tutMsgStringTitle = 367;
                tutMsgStringBody = 95;
                break;
            }
            case 12: {
                tutMsgStringTitle = 370;
                tutMsgStringBody = 96;
                break;
            }
            case 13: {
                tutMsgStringTitle = 371;
                tutMsgStringBody = 97;
                break;
            }
            case 14: {
                tutMsgStringTitle = 376;
                tutMsgStringBody = 98;
                break;
            }
            case 15: {
                tutMsgStringTitle = 375;
                tutMsgStringBody = 99;
                break;
            }
            case 16: {
                tutMsgStringTitle = 377;
                tutMsgStringBody = 100;
            }
        }
        StateInGame.hideMenus();
        Debug.UserInterface_prepareTextScreen(tutMsgStringBody, tutMsgStringTitle, true);
        m_tutorialMessageActive = true;
        StateInGame.setupSoftkeys();
    }

    public static void processKeysTutorialMessage() {
        Debug.UserInterface_processKeysTextScreen();
        if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            StateInGame.hideTutorialMessage();
            if (m_tutorialMessageShowing == 0) {
                StateInGame.showTutorialMessage((byte)1);
            }
        } else if (Main.softPressNeg()) {
            StateInGame.hideTutorialMessage();
        }
    }

    public static void hideTutorialMessage() {
        m_tutorialMessageActive = false;
        StateInGame.setupSoftkeys();
    }

    public static int getNormalTimeStep() {
        return m_normalTimeStep;
    }

    public static boolean gamePaused() {
        return m_pauseMenuActive || m_shortcutMenuActive || m_tutorialMessageActive || m_state != 5;
    }

    public static void updateMain(int n) {
        if (StateInGame.gamePaused()) {
            return;
        }
        if (m_loadSimCount > 0) {
            StateInGame.stateTransition(6);
            return;
        }
        if (StateInGame.isCurtainActive()) {
            StateInGame.updateCurtain(n);
        }
        if (!m_tutorialMessageActive && !Main.m_simData.isDelayed() && StateInGame.checkTriggers()) {
            return;
        }
        if (hasJustFlownFlag) {
            hasJustFlownFlag = false;
            Main.m_simData.update(400 * 1000, false);
        }
        StateInGame.updateTicker(n);
        m_normalTimeStep = n;
        int n2 = Main.m_simData.getFastforward() ? n << 2 : n;
        StateInGame.updateObjects(n2);
        Cursor.updateCursor(n);
        StateInGame.updateCamera(n);
        Debug.UserInterface_updateLeftRightArrows(n);
        if (!StateInGame.isCurtainActive() && !ArrayHandler.PostEffects_isFading()) {
            StateInGame.updateSimData(n);
            if (m_mapMode == 2) {
                StateInGame.updateEventsMapMode(n);
            } else if (m_mapMode == 0) {
                StateInGame.updateEventsHouse(n);
            } else {
                StateInGame.updateEventsZoomMode(n);
            }
            if (m_ambientSounds != null) {
                StateInGame.updateAmbientSounds(n, m_ambientSoundRate, m_ambientSounds);
            }
            StateInGame.updateSimAction();
        }
    }

    public static boolean checkTriggers() {
        if (m_showGetItem != -1) {
            StateInGame.stateTransition(15);
            return true;
        }
        if (Main.m_simData.showPersonaComplete()) {
            Main.m_simData.m_personaGoalsCompletedAllShown = true;
            Event.triggerEvent(7, -1, -1);
            return true;
        }
        if (m_showBonusUnlocked) {
            m_showBonusUnlocked = false;
            Main.m_simData.unlockBonus();
            StateInGame.showMessageBox(681, 648, 7);
            return true;
        }
        if (m_showNewDream) {
            m_showNewDream = false;
            if (Main.m_simData.getDream() != -1) {
                StateInGame.showNewDreamMessage();
                return true;
            }
        }
        return false;
    }

    public static void updateHUD(int n) {
        m_timeAnimPlayer.updateAnim(n);
        int n2 = Main.m_simData.getMoney();
        m_displayedMoney = Debug.UserInterface_interpolateValue(m_displayedMoney, n2, n, 9);
        if (!StateInGame.gamePaused()) {
            m_buffDroppingAnimPlayer.updateAnim(n);
            m_buffRisingAnimPlayer.updateAnim(n);
            m_playerGemAnimPlayer.updateAnim(n);
        }
        if (m_state == 5 && !m_shortcutMenuActive && !m_pauseMenuActive) {
            for (int i = 0; i < m_dreamAnimPlayers.length; ++i) {
                int n3 = Main.m_simData.getPromise(i);
                AnimPlayer animPlayer = m_dreamAnimPlayers[i];
                animPlayer.updateAnim(n);
                if (animPlayer.isAnimating() || animPlayer.getAnimID() != 256 && n3 == -1) continue;
                animPlayer.startAnim(255, 20);
            }
        }
    }

    public static void renderHUDTop() {
        int n = m_viewportX + m_viewportWidth;
        int n2 = m_viewportY;
        int n3 = AnimationManager.getAnimFrameWidth(4, 0);
        int n4 = AnimationManager.getAnimFrameWidth(5, 0);
        int n5 = m_viewportX + 5 + (n4 >> 1);
        int n6 = n2 + 3 + (n4 >> 1);
        int n7 = n5;
        int n8 = m_actionQueueSize;
        int[] nArray = m_actionQueueActions;
        MapObject[] mapObjectArray = m_actionQueueArg1s;
        for (int i = 0; i < n8; ++i) {
            int n9 = nArray[i];
            MapObject mapObject = mapObjectArray[i];
            int n10 = 5;
            int n11 = n4;
            if (i == 0) {
                n10 = 4;
                n11 = n3;
            }
            int n12 = 87;
            if (n9 == 76) {
                n12 = 3;
            } else if (n9 == 137) {
                n12 = 1;
            } else if (mapObject != null) {
                n12 = mapObject.getFlag(16384) && !StateInGame.isMapMode() ? 6 : Main.m_simWorld.getObjectActionIcon(mapObject.getType());
            }
            AnimationManager.drawAnimFrame(n10, 0, n7, n6);
            AnimationManager.drawAnimFrame(n12, 0, n7, n6);
            n7 += n11 + 2;
        }
        n3 = Main.m_simData.getGameTime();
        SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendTimeToBuffer24Hour(n3);
        AnimationManager.drawAnimFrame(262, 0, n, n2);
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 262, 0, 0);
        int n13 = n + m_tempInt10[0];
        int n14 = n2 + m_tempInt10[1];
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 262, 0, 1);
        int n15 = n + m_tempInt10[0];
        n5 = n2 + m_tempInt10[1];
        GameConstants.TextHandler_drawString(sDKString, 2, n13 + 1, n14 + 1, 24);
        n6 = SimData.DAY_STRINGS[Main.m_simData.getGameDay()];
        GameConstants.TextHandler_drawString(n6, 2, n15 + 1, n5 + 1, 20);
        if (StateInGame.gamePaused()) {
            n7 = 2;
            n8 = 305;
        } else if (Main.m_simData.getFastforward()) {
            n7 = 4;
            n8 = 303;
        } else {
            n7 = 3;
            n8 = 304;
        }
        m_timeAnimPlayer.startAnim(n8, 4);
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 262, 0, n7);
        AnimationManager.drawAnim(m_timeAnimPlayer, n + m_tempInt10[0], n2 + m_tempInt10[1]);
    }

    public static void renderHUDBottom() {
        short s;
        int n;
        int n2;
        if (m_quickLinksActive) {
            StateInGame.renderQuickLinks();
        }
        if (m_state != 16 && StateInGame.getSimContext() == -1 && !m_quickLinksActive) {
            StateInGame.renderBuffs();
        }
        AnimationManager.drawAnimFrame(254, 0, 120, 245);
        if (m_tickerString1 != -1) {
            StateInGame.renderTicker();
        }
        AnimationManager.getAnimFrameCollisionBox(m_tempInt10, 254, 0, 0);
        int n3 = 120 + m_tempInt10[0] - 30;
        int n4 = 245 + m_tempInt10[1];
        int n5 = 0;
        while (true) {
            if (n5 >= 4) break;
            n2 = n3 + n5 * 16;
            AnimPlayer animPlayer = m_dreamAnimPlayers[n5];
            if (animPlayer.isAnimating()) {
                AnimationManager.drawAnim(animPlayer, n2, n4);
            }
            ++n5;
        }
        AnimationManager.getAnimFrameCollisionBox(m_tempInt10, 254, 0, 1);
        n3 = Main.m_simData.getMotiveCount();
        n4 = 120 + m_tempInt10[0] + -8 + 25;
        n5 = 245 + m_tempInt10[1] + (m_tempInt10[3] >> 1);
        n2 = m_tempInt10[2];
        int n6 = n4 + n2;
        for (n = 0; n < n3 && n6 > n4; ++n) {
            if (Main.m_simData.getMotiveLevel(n) >= 0x230000) continue;
            s = Main.m_simData.getMotiveLowAnim(n);
            AnimationManager.drawAnimFrame(s, 0, n6, n5);
            n6 -= 16;
        }
        for (n = 0; n < n3 && n6 > n4; ++n) {
            if (Main.m_simData.getMotiveLevel(n) <= 0x410000) continue;
            s = Main.m_simData.getMotiveHighAnim(n);
            AnimationManager.drawAnimFrame(s, 0, n6, n5);
            n6 -= 16;
        }
    }

    public static void renderHUDMoodSim() {
        AnimationManager.drawAnimFrame(253, 0, 120, 245);
        boolean bl = m_displayedMoodLevel < 0;
        int n = Math.abs(m_displayedMoodLevel >> 16);
        int n2 = 0x640000 >> 16;
        int n3 = AnimationManager.getAnimFrameWidth(251, 0);
        int n4 = n3 * n / n2;
        int n5 = 120 + (bl ? -n4 : 0);
        int n6 = Debug.PMGraphics_getClipX();
        int n7 = Debug.PMGraphics_getClipY();
        int n8 = Debug.PMGraphics_getClipWidth();
        int n9 = Debug.PMGraphics_getClipHeight();
        Debug.PMGraphics_setClip(n5, n7, n4, n9);
        int n10 = bl ? 252 : 251;
        AnimationManager.drawAnimFrame(n10, 0, 120, 245);
        Debug.PMGraphics_setClip(n6, n7, n8, n9);
    }

    public static void showMessageBox(int n, int n2) {
        StateInGame.showMessageBox(n, n2, 0);
    }

    public static void showMessageBox(int n, int n2, int n3) {
        Debug.UserInterface_m_uiTextBoxTopLine = 0;
        StateInGame.hideQuickLinks();
        m_postMessageBox = n3;
        Debug.UserInterface_prepareGenericMessageBox(n, n2);
        StateInGame.stateTransition(9);
    }

    public static void processKeysMessageBox() {
        if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            switch (m_postMessageBox) {
                default: {
                    break;
                }
                case 0: {
                    StateInGame.stateTransition(5);
                    break;
                }
                case 1: {
                    StateInGame.gotoMap();
                    break;
                }
                case 2: {
                    if (StateInGame.getPlayerSim().getSimAction() == 133) {
                        StateInGame.getPlayerSim().interrupt();
                    }
                    StateInGame.stateTransition(5);
                    break;
                }
                case 3: {
                    Event.triggerEvent(5, -1, -1);
                    break;
                }
                case 7: {
                    Event.triggerEvent(8, -1, -1);
                    break;
                }
                case 4: {
                    Event.triggerEvent(6, -1, -1);
                    break;
                }
                case 5: {
                    IStringConstants.Minigame_beginMiniGame(3, null);
                    break;
                }
                case 6: {
                    Main.setNextHouseId(0);
                    StateInGame.changeSceneWithSavePrompt(0, 5);
                    break;
                }
                case 8: {
                    Main.m_simData.timeArrivedInCairo = -1;
                    m_pauseMenuItems = null;
                    hasJustFlownFlag = true;
                    Main.setNextHouseId(0);
                    StateInGame.changeSceneWithFade(0, -1);
                }
            }
        }
    }

    public static boolean isCurtainActive() {
        return m_curtainState != 0;
    }

    public static void startCurtainIn() {
        StateInGame.hideMenus();
        m_curtainPlayerAction = m_playerSim.getSimAction();
        StateInGame.stateTransitionCurtain(1);
    }

    public static void startCurtainOut() {
        StateInGame.hideMenus();
        StateInGame.stateTransitionCurtain(2);
    }

    public static void stateTransitionCurtain(int n) {
        AnimationManager.Touch_clear();
        m_curtainState = n;
        switch (n) {
            default: {
                break;
            }
            case 0: {
                m_curtainTime = 0;
                break;
            }
            case 1: {
                Main.m_simData.delayAlerts();
                m_curtainTime = 0;
                break;
            }
            case 2: {
                m_curtainTime = 1000;
                break;
            }
            case 3: {
                m_curtainTime = 1000;
            }
        }
    }

    public static void updateCurtain(int n) {
        if (!m_cameraAtDest) {
            return;
        }
        switch (m_curtainState) {
            default: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                Main.m_simData.delayAlerts();
                if (m_curtainTime == 1000) {
                    StateInGame.stateTransitionCurtain(2);
                    StateInGame.doCurtainInUpdate();
                    break;
                }
                m_curtainTime = Math.min(m_curtainTime + n, 1000);
                break;
            }
            case 2: {
                Main.m_simData.delayAlerts();
                if ((m_curtainTime += n) < 1500) break;
                StateInGame.stateTransitionCurtain(3);
                break;
            }
            case 3: {
                Main.m_simData.delayAlerts();
                if (m_curtainTime == 0) {
                    StateInGame.stateTransitionCurtain(0);
                    StateInGame.doCurtainOutUpdate();
                    break;
                }
                m_curtainTime = Math.max(m_curtainTime - n, 0);
            }
        }
    }

    public static void doCurtainInUpdate() {
        switch (m_curtainPlayerAction) {
            default: {
                break;
            }
            case 133: {
                Debug.ASSERT(m_playerSim.isWorking(), "sim not working!");
                Main.m_simData.updateSkipWorking();
                StateInGame.cancelWorkMessages();
                m_playerSim.endSimPhase();
                break;
            }
            case 94: {
                Main.m_simData.updateSkipSleeping(StateInGame.getPlayerSim().getFeedbackTime() - 15);
                break;
            }
            case 6: {
                boolean bl = false;
                boolean bl2 = false;
                if (StateInGame.isHouseMode()) {
                    if (Main.m_simWorld.getHouseId() == 0) {
                        bl = true;
                    } else if (Main.isForeignAirport(Main.m_simWorld.getHouseId())) {
                        bl = true;
                        bl2 = true;
                    } else {
                        Main.setNextHouseId(0);
                        Event.PMStateManager_set(0, 96);
                    }
                } else if (StateInGame.isZoomMapMode() && Main.m_nextZoomMapId != 62) {
                    bl = true;
                    bl2 = true;
                } else {
                    Main.setNextHouseId(0);
                    Event.PMStateManager_set(0, 96);
                }
                if (!bl) break;
                StateInGame.putSimInBed(m_playerSim);
                m_timeHit = 120;
                Main.m_simData.delayAlerts();
                MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
                for (int i = 0; i < mapObjectSimArray.length; ++i) {
                    MapObjectSim mapObjectSim = mapObjectSimArray[i];
                    if (mapObjectSim != null && mapObjectSim.equals(m_playerSim)) continue;
                    if (!bl2 && Main.m_simData.getSimHome(mapObjectSim.getId()) != 0) {
                        mapObjectSim.destroy();
                        continue;
                    }
                    mapObjectSim.beginSimAction(0, null);
                }
            }
        }
    }

    public static void doCurtainOutUpdate() {
        switch (m_curtainPlayerAction) {
            case 133: {
                StateInGame.finishWork();
                break;
            }
            default: {
                Main.m_simData.delayAlerts();
            }
        }
    }

    public static void renderCurtain() {
        if (!m_cameraAtDest) {
            return;
        }
        int n = Math.min(m_curtainTime, 1000);
        int n2 = (n * m_viewportHeight / 1000 >> 1) + 1;
        Debug.PMGraphics_setColor(0);
        Debug.PMGraphics_fillRect(m_viewportX, m_viewportY, m_viewportWidth, n2);
        Debug.PMGraphics_fillRect(m_viewportX, m_viewportY + m_viewportHeight - n2, m_viewportWidth, n2);
    }

    public static void showTickerMessage(int n, int n2) {
        m_tickerString1 = (short)n;
        m_tickerString2 = (short)n2;
        m_tickerTimer = 0;
        m_tickerOffsetF = 0;
        m_tickerLengthF = (GameConstants.TextHandler_getStringWidth(n, 0) << 16) + 327680;
        if (n2 != -1) {
            m_tickerLengthF += 5 + GameConstants.TextHandler_getStringWidth(n2, 0) << 16;
        }
    }

    public static void cancelTickerMessage(int n) {
        if (m_tickerString1 == n) {
            m_tickerString1 = (short)-1;
        }
    }

    public static boolean isShowingTickerMessage() {
        return m_tickerString1 != -1;
    }

    public static void updateTicker(int n) {
        if (m_tickerString1 != -1 && (m_tickerTimer += n) > 2000) {
            if (m_tickerOffsetF > m_tickerLengthF) {
                m_tickerString1 = (short)-1;
                m_tickerString2 = (short)-1;
            } else {
                m_tickerOffsetF += n * 3276;
            }
        }
    }

    public static void renderTicker() {
        int n = AnimationManager.getAnimFrameHeight(302, 0);
        int n2 = 245 - m_hudBottomHeight - n;
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 302, 0, 0);
        int n3 = 0 + m_tempInt10[0];
        int n4 = n2 + m_tempInt10[1];
        AnimationManager.drawAnimFrame(302, 0, 0, n2);
        if (m_tickerTimer < 1000 && (m_tickerTimer & 0x1FF) > 255) {
            return;
        }
        int n5 = n3 - (m_tickerOffsetF >> 16);
        GameConstants.TextHandler_drawString(m_tickerString1, 0, n5, n4, 20);
        if (m_tickerString2 != -1) {
            int n6 = GameConstants.TextHandler_getStringWidth(m_tickerString1, 0);
            int n7 = n5 + n6 + 5;
            GameConstants.TextHandler_drawString(m_tickerString2, 0, n7, n4, 20);
        }
    }

    public static void calcCameraDest() {
        int n;
        Object object;
        int n2 = Cursor.m_cursorDestX;
        int n3 = Cursor.m_cursorDestZ;
        if (m_cameraFollowTarget != null) {
            m_cameraFollowTarget.getHotSpot(m_tempInt10);
            n2 = m_tempInt10[0];
            n3 = m_tempInt10[1];
        } else if (m_contextMenuActive || Main.m_simData.getLastNPC() != -1) {
            object = m_contextMenuObject;
            if (object == null && Cursor.m_cursorObject != null && Cursor.m_cursorObject.getFlag(16384) && ((MapObjectSim)Cursor.m_cursorObject).getId() == Main.m_simData.getLastNPC()) {
                object = Cursor.m_cursorObject;
            }
            if (object != null) {
                n = m_viewportWidth << 14;
                n2 = ((MapObject)object).getFlag(16384) ? (n2 -= n) : (n2 += n);
            }
        }
        object = Main.m_simWorld.getTileMap();
        n = Main.m_simWorld.getViewportWidth();
        int n4 = n >> 1;
        int n5 = Main.m_simWorld.getViewportHeight();
        int n6 = n5 >> 1;
        int n7 = n4 << 16;
        int n8 = ((TileMap)object).getWidth() * ((TileMap)object).getTileSizeX() - n4 - 1 << 16;
        int n9 = n6 << 16;
        int n10 = ((TileMap)object).getHeight() * ((TileMap)object).getTileSizeY() - n6 - 1 << 16;
        n2 = IStringConstants.MathExt_clip(n2, n7, n8);
        n3 = IStringConstants.MathExt_clip(n3, n9, n10);
        m_cameraDestX = n2;
        m_cameraDestZ = n3;
    }

    public static void setCameraFollow(MapObject mapObject) {
        if (!m_contextMenuActive && !m_quickLinksActive) {
            m_cameraFollowTarget = mapObject;
            Cursor.m_cursorObject = null;
            if (mapObject == null) {
                m_cameraFollowTargetReturn = true;
            }
        }
    }

    public static void clearCameraFollow() {
        m_cameraFollowTarget = null;
        m_cameraFollowTargetReturn = false;
    }

    public static MapObject getCameraFollow() {
        return m_cameraFollowTarget;
    }

    public static void updateCamera(int n) {
        boolean bl;
        boolean bl2;
        int n2 = Main.m_simWorld.getCameraPosX();
        int n3 = Main.m_simWorld.getCameraPosZ();
        if (m_isCursorOnMove) {
            if (cursorScrollX == 0 && cursorScrollZ == 0) {
                return;
            }
            int n4 = n2 + cursorScrollX;
            int n5 = n3 + cursorScrollZ;
            int n6 = Main.m_simWorld.getViewportWidth();
            int n7 = n6 >> 1;
            int n8 = Main.m_simWorld.getViewportHeight();
            int n9 = n8 >> 1;
            TileMap tileMap = Main.m_simWorld.getTileMap();
            int n10 = n7 << 16;
            int n11 = tileMap.getWidth() * tileMap.getTileSizeX() - n7 - 1 << 16;
            int n12 = n9 << 16;
            int n13 = tileMap.getHeight() * tileMap.getTileSizeY() - n9 - 1 << 16;
            n4 = IStringConstants.MathExt_clip(n4, n10, n11);
            n5 = IStringConstants.MathExt_clip(n5, n12, n13);
            Main.m_simWorld.setCameraPosX(n4);
            Main.m_simWorld.setCameraPosZ(n5);
            Cursor.m_cursorPosX += n4 - n2;
            Cursor.m_cursorPosZ += n5 - n3;
            return;
        }
        int n14 = 11534;
        int n15 = 1441;
        int n16 = 32;
        if (m_quickLinksActive) {
            n14 = IStringConstants.MathExt_Fmul(n14, 196608);
            n16 = IStringConstants.MathExt_Fmul(n16, 196608);
        }
        StateInGame.calcCameraDest();
        int n17 = IStringConstants.MathExt_sign(m_cameraDestX - n2);
        int n18 = IStringConstants.MathExt_sign(m_cameraDestZ - n3);
        if (n17 > 0 && m_cameraLastVelX > 0) {
            m_cameraVelX += n16 * n;
        } else if (n17 > 0 && m_cameraLastVelX <= 0) {
            m_cameraVelX = n15;
        } else if (n17 < 0 && m_cameraLastVelX < 0) {
            m_cameraVelX -= n16 * n;
        } else if (n17 < 0 && m_cameraLastVelX >= 0) {
            m_cameraVelX = -n15;
        } else if (n17 == 0 && m_cameraLastVelX > 0) {
            m_cameraVelX = -n15;
        } else if (n17 == 0 && m_cameraLastVelX < 0) {
            m_cameraVelX = n15;
        }
        if (m_cameraVelX < -n14) {
            m_cameraVelX = -n14;
        }
        if (m_cameraVelX > n14) {
            m_cameraVelX = n14;
        }
        if (n18 > 0 && m_cameraLastVelZ > 0) {
            m_cameraVelZ += n16 * n;
        } else if (n18 > 0 && m_cameraLastVelZ <= 0) {
            m_cameraVelZ = n15;
        } else if (n18 < 0 && m_cameraLastVelZ < 0) {
            m_cameraVelZ -= n16 * n;
        } else if (n18 < 0 && m_cameraLastVelZ >= 0) {
            m_cameraVelZ = -n15;
        } else if (n18 == 0 && m_cameraLastVelZ > 0) {
            m_cameraVelZ = -n15;
        } else if (n18 == 0 && m_cameraLastVelZ < 0) {
            m_cameraVelZ = n15;
        }
        if (m_cameraVelZ < -n14) {
            m_cameraVelZ = -n14;
        }
        if (m_cameraVelZ > n14) {
            m_cameraVelZ = n14;
        }
        int n19 = n2 + m_cameraVelX * n;
        int n20 = n3 + m_cameraVelZ * n;
        if (m_cameraVelX > 0 && n19 > m_cameraDestX || m_cameraVelX < 0 && n19 < m_cameraDestX) {
            bl2 = true;
            n19 = m_cameraDestX;
        } else {
            boolean bl3 = bl2 = n19 == m_cameraDestX;
        }
        if (m_cameraVelZ > 0 && n20 > m_cameraDestZ || m_cameraVelZ < 0 && n20 < m_cameraDestZ) {
            bl = true;
            n20 = m_cameraDestZ;
        } else {
            bl = n20 == m_cameraDestZ;
        }
        m_cameraLastVelX = m_cameraVelX;
        m_cameraLastVelZ = m_cameraVelZ;
        Main.m_simWorld.setCameraPosX(n19);
        Main.m_simWorld.setCameraPosZ(n20);
        boolean bl4 = m_cameraAtDest = bl2 && bl;
        if (m_cameraFollowTarget != null || m_cameraFollowTargetReturn) {
            Cursor.m_cursorPosX += n19 - n2;
            Cursor.m_cursorPosZ += n20 - n3;
        }
    }

    public static void snapCameraPosition() {
        StateInGame.calcCameraDest();
        Main.m_simWorld.setCameraPosX(m_cameraDestX);
        Main.m_simWorld.setCameraPosZ(m_cameraDestZ);
        m_cameraAtDest = true;
    }

    public static void snapCameraAndCursor(MapObject mapObject) {
        Cursor.setCursorObject(mapObject);
        Cursor.m_cursorPosX = Cursor.m_cursorDestX;
        Cursor.m_cursorPosZ = Cursor.m_cursorDestZ;
        StateInGame.snapCameraPosition();
    }

    public static void initHouseMap() {
        Main.m_simWorld.prepareWorldHouse(Main.getNextHouseId());
        if (m_initialState == 96) {
            m_initialState = 5;
            StateInGame.putSimInBed(m_playerSim);
            m_timeHit = 120;
            Main.m_simData.delayAlerts();
            StateInGame.startCurtainOut();
        }
    }

    public static void initZoomMap() {
        Main.m_simWorld.prepareWorldZoomMap(Main.getNextZoomMapId());
    }

    public static void initMacroMap() {
        boolean bl = false;
        if (m_initialState == 99) {
            m_initialState = 5;
            bl = true;
        }
        Main.m_simWorld.prepareWorldMacromap(bl);
        m_playerSim.setFlag(1);
    }

    public static MapObject[] getObjects() {
        if (m_refreshObjects) {
            m_refreshObjects = false;
            if (m_objects == null || m_objects.length != m_objectStack.size()) {
                m_objects = null;
                m_objects = new MapObject[m_objectStack.size()];
            }
            m_objectStack.copyInto(m_objects);
        }
        return m_objects;
    }

    public static MapObjectSim[] getSimObjects() {
        if (m_refreshObjectsSims) {
            m_refreshObjectsSims = false;
            MapObject[] mapObjectArray = StateInGame.getObjects();
            int n = 0;
            for (int i = 0; i < mapObjectArray.length; ++i) {
                if (!mapObjectArray[i].getFlag(16384)) continue;
                ++n;
            }
            MapObjectSim[] mapObjectSimArray = m_objectsSims;
            if (mapObjectSimArray == null || mapObjectSimArray.length != n) {
                m_objectsSims = null;
                mapObjectSimArray = null;
                m_objectsSims = mapObjectSimArray = new MapObjectSim[n];
            }
            int n2 = 0;
            for (int i = 0; i < mapObjectArray.length; ++i) {
                if (!mapObjectArray[i].getFlag(16384)) continue;
                mapObjectSimArray[n2] = (MapObjectSim)mapObjectArray[i];
                ++n2;
            }
        }
        return m_objectsSims;
    }

    public static MapObjectSim getPlayerSim() {
        return m_playerSim;
    }

    public static MapObject findRandomObjectByType(int n) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n2 = Main.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n3 = (n2 + i) % mapObjectArray.length;
            MapObject mapObject = mapObjectArray[n3];
            if (mapObject.getType() != n) continue;
            return mapObject;
        }
        return null;
    }

    public static boolean isObjectAt(int n, int n2, int n3) {
        int n4 = Main.m_simWorld.coordWorldToWorldTileX(n2);
        int n5 = Main.m_simWorld.coordWorldToWorldTileX(n3);
        MapObject[] mapObjectArray = StateInGame.getObjects();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[i];
            if (mapObject.getParentType() != n) continue;
            int n6 = Main.m_simWorld.coordWorldToWorldTileX(mapObject.getPosX());
            int n7 = Main.m_simWorld.coordWorldToWorldTileZ(mapObject.getPosZ());
            if (n6 != n4 || n7 != n5) continue;
            return true;
        }
        return false;
    }

    public static MapObject findRandomObjectByParentType(int n) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n2 = Main.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n3 = (n2 + i) % mapObjectArray.length;
            MapObject mapObject = mapObjectArray[n3];
            if (mapObject.getParentType() != n) continue;
            return mapObject;
        }
        return null;
    }

    public static MapObject findRandomNeedObject(int n) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n2 = Main.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            int n3 = (n2 + i) % mapObjectArray.length;
            MapObject mapObject = mapObjectArray[n3];
            int n4 = mapObject.getType();
            if ((Main.m_simWorld.getObjectNeed(n4) & n) == 0 || !mapObject.occupiedIsAnyAvailable() || mapObject.getRuntimeFlag(768)) continue;
            return mapObject;
        }
        return null;
    }

    public static MapObjectSim findSim(int n) {
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        int n2 = mapObjectSimArray.length;
        for (int i = 0; i < n2; ++i) {
            MapObjectSim mapObjectSim = mapObjectSimArray[i];
            if (mapObjectSim.getId() != n) continue;
            return mapObjectSim;
        }
        return null;
    }

    public static MapObject createObject(int n, int n2, int n3, int n4, int n5) {
        int n6 = Main.m_simWorld.getObjectFlags(n);
        if (StateInGame.isZoomMapMode() && (n == 2 || n == 3)) {
            n6 |= 0x2000;
        }
        MapObject mapObject = null;
        if ((n6 & 0x4000) != 0) {
            mapObject = new MapObjectSim();
            if (n == 0) {
                m_playerSim = mapObject;
            }
        } else if ((n6 & 0x2000) != 0) {
            mapObject = new MapObject();
        }
        if (mapObject != null) {
            mapObject.init(n, n2, n3, n4, n5);
            StateInGame.addObject(mapObject);
            if (mapObject.getFlag(16384)) {
                StateInGame.loadNewSim((MapObjectSim)mapObject);
            }
        }
        return mapObject;
    }

    public static MapObject createObjectOnObjectInterestPoint(int n, MapObject mapObject, int n2) {
        int n3 = 0;
        do {
            mapObject.getInterestPoint(m_tempInt10, n3);
            ++n3;
        } while (!Main.m_simWorld.isWorldPointWalkable(m_tempInt10[0], m_tempInt10[1]));
        return StateInGame.createObject(n, m_tempInt10[0], m_tempInt10[1], 0, n2);
    }

    public static MapObject createObjectOnWorldTile(int n, int n2, int n3, int n4, int n5) {
        int n6 = Main.m_simWorld.coordWorldTileToWorldCenterX(n2);
        int n7 = Main.m_simWorld.coordWorldTileToWorldCenterZ(n3);
        return StateInGame.createObject(n, n6, n7, n4, n5);
    }

    public static void createEffectAnim(int n, int n2, int n3, int n4) {
        MapObject mapObject = StateInGame.createObject(5, n, n2, 3, -1);
        if (mapObject != null) {
            mapObject.effectPlayAnim(n3, n4);
        }
    }

    public static void createEffectMoney(int n, int n2, int n3) {
        MapObject mapObject = StateInGame.createObject(6, n, n2, 3, -1);
        if (mapObject != null) {
            mapObject.effectShowMoney(n3);
        }
    }

    public static void addObject(MapObject mapObject) {
        mapObject.applyFootprint(true);
        m_objectStack.addElement(mapObject);
        m_refreshObjects = true;
        if (mapObject.getFlag(16384)) {
            m_refreshObjectsSims = true;
        }
    }

    public static void removeObject(MapObject mapObject) {
        if (Cursor.m_cursorObject != null && Cursor.m_cursorObject.equals(mapObject)) {
            Cursor.setCursorObject(null);
        }
        if (m_contextMenuActive && m_contextMenuObject != null && m_contextMenuObject.equals(mapObject)) {
            StateInGame.hideContextMenu();
        }
        int n = -1;
        if (mapObject.getFlag(16384)) {
            n = mapObject.getId();
        }
        mapObject.applyFootprint(false);
        m_objectStack.removeElement(mapObject);
        m_refreshObjects = true;
        if (n != -1) {
            m_refreshObjectsSims = true;
            int n2 = ArrayHandler.indexOf(n, m_loadedSims);
            if (n2 != -1) {
                int n3 = Main.m_simData.getSimAttribute(n, 0) == 0 ? 512 : 256;
                Main.unloadAllImages(n3 |= 0x4000, n2);
                StateInGame.m_loadedSims[n2] = -1;
                Event.PMDebug_println(2, "Unloaded sim with id = {0}, bank = {1}", n, n2);
            }
        }
    }

    public static void updateObjects(int n) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        if (mapObjectArray != null) {
            for (int i = 0; i < mapObjectArray.length; ++i) {
                MapObject mapObject = mapObjectArray[i];
                mapObject.update(n);
            }
        }
    }

    public static void updateObjectTypes(int n, int n2) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        if (mapObjectArray != null) {
            for (int i = 0; i < mapObjectArray.length; ++i) {
                MapObject mapObject = mapObjectArray[i];
                if (mapObject.getType() != n2) continue;
                mapObject.update(n);
            }
        }
    }

    public static MapObject getContextMenuObject() {
        return m_contextMenuObject;
    }

    public static void showContextMenu(MapObject mapObject) {
        if (m_shortcutMenuActive) {
            StateInGame.hideShortcutMenu();
        }
        Cursor.stopCursor();
        short[] sArray = m_contextMenuItems;
        short[] sArray2 = m_contextMenuActions;
        Main.m_simData.setLastNPC(-1);
        m_contextMenuActive = true;
        m_contextMenuOnSubMenu = false;
        m_contextMenuBackCursor = (short)-1;
        m_contextMenuObject = mapObject;
        int n = ArrayHandler.indexOf(m_contextMenuObject, m_actionQueueArg1s);
        if (n != -1 && m_actionQueueActions[n] != 2) {
            int n2 = m_contextMenuObject.getFlag(16384) ? Main.m_simData.getSimName(m_contextMenuObject.getId()) : m_contextMenuObject.getTypeString();
            Main.menuClear(sArray, n2);
            Main.menuClear(sArray2, n2);
            Main.menuAppendItem(sArray, 101);
            Main.menuAppendItem(sArray2, -3);
        } else {
            Main.m_simData.createContextMenu(m_contextMenuObject, sArray, sArray2);
        }
        Main.menuCopy(m_contextMenuFullActions, sArray2);
        if (sArray[0] > m_maxContextMenuItems) {
            Main.m_simData.compactContextMenu(sArray, sArray2, m_contextMenuFullActions);
        }
        sArray[4] = m_maxContextMenuItems;
        StateInGame.setupSoftkeys();
    }

    public static void hideContextMenu() {
        m_contextMenuActive = false;
        m_contextMenuOnSubMenu = false;
        m_contextMenuBackCursor = (short)-1;
        m_contextMenuObject = null;
        StateInGame.setupSoftkeys();
        Cursor.setCursorObject(Cursor.m_cursorObject);
    }

    public static void renderContextMenu() {
        boolean bl = m_contextMenuObject != null && m_contextMenuObject.getFlag(16384);
        int n = bl ? 2 : 4;
        Debug.UserInterface_drawGenericMenu(m_contextMenuItems, n);
    }

    public static int getSimContext() {
        if (!m_suppressMenus && m_contextMenuActive) {
            if (m_contextMenuObject != null && m_contextMenuObject.getFlag(16384)) {
                return ((MapObjectSim)m_contextMenuObject).getId();
            }
        } else if (Main.m_simData.isLastNPCStillRelevant()) {
            return Main.m_simData.getLastNPC();
        }
        return -1;
    }

    public static void renderContextRelationships() {
        boolean bl;
        int n = StateInGame.getSimContext();
        boolean bl2 = bl = !m_contextMenuActive || m_suppressMenus;
        if (!m_suppressMenus && m_contextMenuActive) {
            if (m_contextMenuObject != null && m_contextMenuObject.getFlag(16384)) {
                n = ((MapObjectSim)m_contextMenuObject).getId();
            }
        } else if (Main.m_simData.isLastNPCStillRelevant()) {
            bl = true;
            n = Main.m_simData.getLastNPC();
        }
        if (n != -1) {
            int n2;
            Main.m_simData.getRelationshipLevels(n, m_tempInt10);
            int n3 = (m_tempInt10[0] != -1 ? 1 : 0) + (m_tempInt10[2] != -1 ? 1 : 0);
            int n4 = m_viewportX + 3;
            int n5 = AnimationManager.getAnimFrameHeight(302, 0);
            int n6 = 245 - m_hudBottomHeight;
            int n7 = n6 - 18 * (n3 + 1);
            if (m_tickerString1 != -1) {
                n7 -= n5;
            }
            int n8 = n7;
            int n9 = Main.m_simData.getRelState(n);
            StateInGame.drawRelBar(n4, n8, 120, n9, 65536, true);
            n8 += 18;
            for (n2 = 0; n2 < 4 && (n9 = m_tempInt10[n2]) != -1; n2 += 2) {
                int n10 = m_tempInt10[n2 + 1];
                StateInGame.drawRelBar(n4, n8, 120, n9, n10, false);
                n8 += 18;
            }
            if (bl) {
                n2 = -1;
                MapObjectSim mapObjectSim = StateInGame.getPlayerSim().getSimActionArg1Sim();
                if (mapObjectSim != null && mapObjectSim.getId() == n) {
                    n2 = Main.m_simData.getActionString(StateInGame.getPlayerSim().getSimAction());
                }
                if (n2 == 4) {
                    n2 = -1;
                }
                int n11 = n7 - 14 - 4 - (n2 != -1 ? 12 : 0);
                AnimationManager.setColor(76);
                Debug.PMGraphics_fillRect(n4, n11, 120, 14);
                AnimationManager.setColor(77);
                Debug.PMGraphics_drawRect(n4, n11, 120, 14);
                GameConstants.TextHandler_drawString(Main.m_simData.getSimName(n), 0, n4 + 60, n11 + 1, 17);
                if (n2 != -1) {
                    int n12 = n11 + 14;
                    AnimationManager.setColor(76);
                    Debug.PMGraphics_fillRect(n4, n12, 120, 12);
                    AnimationManager.setColor(77);
                    Debug.PMGraphics_drawRect(n4, n12, 120, 12);
                    GameConstants.TextHandler_drawClippedString(n2, 1, n4 + 2, n12 + 2, 116, 17);
                }
            }
        }
    }

    public static void processKeysContextMenu() {
        if (Main.softPressNeg()) {
            StateInGame.resetPlayerInactivity();
            if (m_contextMenuOnSubMenu) {
                Main.m_simData.compactContextMenu(m_contextMenuItems, m_contextMenuActions, m_contextMenuFullActions);
                StateInGame.m_contextMenuItems[4] = m_maxContextMenuItems;
                m_contextMenuOnSubMenu = false;
                StateInGame.m_contextMenuItems[2] = m_contextMenuBackCursor;
                Main.menuVisible(m_contextMenuItems);
            } else {
                StateInGame.hideContextMenu();
            }
        } else if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            int n = 5 + m_contextMenuItems[2];
            short s = m_contextMenuActions[n];
            if (s == -4) {
                StateInGame.hideContextMenu();
            } else if (s == -3) {
                StateInGame.processCancelAction(m_contextMenuObject);
                StateInGame.hideContextMenu();
            } else if (s == -2) {
                m_contextMenuBackCursor = m_contextMenuItems[2];
                m_contextMenuOnSubMenu = true;
                short s2 = m_contextMenuItems[n];
                Main.m_simData.filterContextMenu(m_contextMenuItems, m_contextMenuActions, m_contextMenuFullActions, s2);
                StateInGame.m_contextMenuItems[4] = m_maxContextMenuItems;
            } else if (s == 109 || s == 108) {
                StateInGame.processCallAction();
            } else if (s == 99) {
                StateInGame.processCookAction();
            } else {
                StateInGame.hideMenus();
                StateInGame.processSimAction(s, Cursor.m_cursorObject, 0, 0);
            }
        } else {
            Main.menuCursorUpDown(m_contextMenuItems);
        }
    }

    public static void stateTransitionPauseMenu(int n) {
        m_pauseMenuState = n;
        switch (n) {
            default: {
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                Debug.UserInterface_prepareGenericMessageBox(59, 58);
                break;
            }
            case 2: {
                Debug.UserInterface_prepareGenericMessageBox(53, 51);
                break;
            }
            case 3: {
                Debug.UserInterface_prepareGenericMessageBox(55, 51);
                break;
            }
            case 4: {
                Debug.UserInterface_prepareGenericMessageBox(57, 51);
            }
        }
        StateInGame.setupSoftkeys();
    }

    public static void showPauseMenu() {
        if (m_contextMenuActive) {
            StateInGame.hideContextMenu();
        }
        if (m_shortcutMenuActive) {
            StateInGame.hideShortcutMenu();
        }
        Cursor.stopCursor();
        m_pauseMenuActive = true;
        m_pauseMenuState = 0;
        StateInGame.m_pauseMenuItems[2] = 0;
        StateInGame.setupSoftkeys();
    }

    public static void hidePauseMenu() {
        m_pauseMenuActive = false;
        StateInGame.setupSoftkeys();
    }

    public static void processKeysPauseMenu() {
        if (GlobalConstants.StateMenu_m_sharedMenuState != -1) {
            GlobalConstants.StateMenu_processKeysSharedMenu();
            return;
        }
        switch (m_pauseMenuState) {
            case 0: {
                if (Main.softPressNeg()) {
                    StateInGame.hidePauseMenu();
                    break;
                }
                if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
                    int n = 5 + m_pauseMenuItems[2];
                    StateInGame.processBasicAction(m_pauseMenuItems[n]);
                    break;
                }
                Main.menuCursorUpDown(m_pauseMenuItems);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
                    if (m_pauseMenuState == 3) {
                        StateInGame.fixInitsequenceGameData();
                    }
                    if (m_pauseMenuState != 1) {
                        Main.saveRMSAppSettings();
                        Main.saveRMSGameData();
                    }
                    if (m_pauseMenuState != 2) {
                        StateInGame.changeSceneWithFade(1, -1);
                        break;
                    }
                    StateInGame.hidePauseMenu();
                    break;
                }
                if (!Main.softPressNeg()) break;
                StateInGame.stateTransitionPauseMenu(0);
                break;
            }
            case 4: {
                if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
                    StateInGame.fixInitsequenceGameData();
                    Main.saveRMSAppSettings();
                    Main.saveRMSGameData();
                    StateInGame.fadeStateTransition(4);
                    break;
                }
                if (!Main.softPressNeg()) break;
                StateInGame.stateTransitionPauseMenu(0);
                break;
            }
            default: {
                Debug.ASSERT(false, "invalid state");
            }
        }
    }

    public static void fixInitsequenceGameData() {
        if (!Main.m_simData.initMsgHasShownAtAirport) {
            Main.m_simData.initMsgHasShownAtHome = false;
        }
        if (Main.m_simData.initMsgHasShownAtHome && Main.m_simData.initMsgHasShownAtAirport && Main.m_simData.timeArrivedInCairo == 0) {
            Main.m_simData.initMsgHasShownAtHome = false;
            Main.m_simData.initMsgHasShownAtAirport = false;
        }
        if (StateInGame.isHouseMode() && Main.getNextHouseId() == 6) {
            if (Main.m_simData.timeArrivedInCairo == 0) {
                Main.m_simData.initMsgHasShownAtHome = false;
                Main.m_simData.initMsgHasShownAtAirport = false;
                Main.m_simData.initMsgHasShownAtCounter = false;
            } else if (Main.m_simData.timeArrivedInCairo > 0) {
                Main.m_simData.initMsgHasShownAtHome = true;
                Main.m_simData.initMsgHasShownAtAirport = true;
                Main.m_simData.initMsgHasShownAtCounter = true;
                Main.m_simData.timeArrivedInCairo = -1;
            }
        }
        if (StateInGame.isZoomMapMode() && Main.getNextZoomMapId() == 58 && Main.m_simData.timeArrivedInCairo > 0) {
            Main.m_simData.initMsgHasShownAtHome = false;
            Main.m_simData.initMsgHasShownAtAirport = false;
            Main.m_simData.initMsgHasShownAtCounter = false;
            Main.m_simData.timeArrivedInCairo = 0;
        }
    }

    public static void renderPauseMenu() {
        ArrayHandler.PostEffects_renderBackgroundDim();
        int n = m_pauseMenuState;
        if (GlobalConstants.StateMenu_m_sharedMenuState != -1) {
            GlobalConstants.StateMenu_renderSharedMenu();
        } else if (n == 0) {
            Debug.UserInterface_drawGenericMenu(m_pauseMenuItems, 1);
        } else if (n == 2 || n == 3 || n == 1 || n == 4) {
            Debug.UserInterface_drawGenericMessageBox();
        }
    }

    public static void showShortcutMenu() {
        m_shortcutByShortcutKey = false;
        if (m_contextMenuActive) {
            StateInGame.hideContextMenu();
        }
        Cursor.stopCursor();
        short[] sArray = m_shortcutMenuItems;
        m_shortcutMenuActive = true;
        Main.menuClear(sArray, 16, GlobalConstants.StateMenu_getMaxMenuItemsPerScreen());
        if (m_actionQueueSize > 0) {
            Main.menuAppendItem(sArray, 101);
        }
        if (Main.m_simData.isTimeForWork(null, 0) && (StateInGame.isHouseMode() && !Main.isForeignAirport(Main.m_simWorld.getHouseId()) || StateInGame.isZoomMapMode() && Main.getNextZoomMapId() == 62 || StateInGame.isMapMode())) {
            Main.menuAppendItem(sArray, 292);
        }
        if (StateInGame.isZoomMapMode() && Main.getNextZoomMapId() == 62) {
            Main.menuAppendItem(sArray, 293);
        }
        if (StateInGame.isHouseMode()) {
            if (!Main.isForeignAirport(Main.m_simWorld.getHouseId())) {
                Main.menuAppendItem(sArray, 293);
            }
            if (Main.isForeignAirport(Main.m_simWorld.getHouseId())) {
                Main.menuAppendItem(sArray, 840);
            }
        }
        if (StateInGame.isZoomMapMode() && (Main.getNextZoomMapId() == 57 || Main.getNextZoomMapId() == 58 || Main.getNextZoomMapId() == 60 || Main.getNextZoomMapId() == 61)) {
            Main.menuAppendItem(sArray, 841);
        }
        if (StateInGame.isMapMode()) {
            Main.menuAppendItem(sArray, 294);
            Main.menuAppendItem(sArray, 112);
        }
        Main.menuAppendItem(sArray, 104);
        Main.menuAppendItem(sArray, 103);
        Main.menuAppendItem(sArray, 105);
        Main.menuAppendItem(sArray, 106);
        Main.menuAppendItem(sArray, 107);
        Main.menuAppendItem(sArray, 108);
        Main.menuAppendItem(sArray, 110);
        StateInGame.setupSoftkeys();
    }

    public static void hideShortcutMenu() {
        m_shortcutMenuActive = false;
        StateInGame.setupSoftkeys();
    }

    public static void processKeysShortcutMenu() {
        if (Main.softPressNeg()) {
            StateInGame.hideShortcutMenu();
        } else if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            int n = m_shortcutMenuItems[2] + 5;
            StateInGame.processBasicAction(m_shortcutMenuItems[n]);
        } else {
            Main.menuCursorUpDown(m_shortcutMenuItems);
        }
    }

    public static void renderShortcutMenu() {
        ArrayHandler.PostEffects_renderBackgroundDim();
        Debug.UserInterface_drawGenericMenu(m_shortcutMenuItems, 1);
    }

    public static void showQuickLinks() {
        StateInGame.clearCameraFollow();
        m_quickLinksActive = true;
        short[] sArray = m_quickLinksMenu;
        Main.menuClear(sArray, 4);
        int n = Main.m_simWorld.getObjectCount();
        for (int i = 0; i < n; ++i) {
            if (!Main.m_simData.isQuickLinkVisited(i)) continue;
            Main.menuAppendItem(sArray, i);
        }
        StateInGame.quickLinksSelect(m_quickLinksMenu[2]);
        StateInGame.setupSoftkeys();
    }

    public static void hideQuickLinks() {
        m_quickLinksActive = false;
        StateInGame.setupSoftkeys();
    }

    public static void processKeysQuickLinks() {
        if (Main.softPressNeg()) {
            StateInGame.hideQuickLinks();
        } else if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            StateInGame.hideQuickLinks();
            Cursor.processKeysFire();
        } else if (Main.menuCursorLeftRight(m_quickLinksMenu)) {
            StateInGame.quickLinksSelect(m_quickLinksMenu[2]);
        }
        if (AnimationManager.PMInput_isPressed(8)) {
            Debug.UserInterface_triggerLeftArrow();
        } else if (AnimationManager.PMInput_isPressed(16)) {
            Debug.UserInterface_triggerRightArrow();
        }
    }

    public static void quickLinksSelect(int n) {
        short s = m_quickLinksMenu[5 + n];
        MapObject mapObject = StateInGame.findRandomObjectByType(s);
        Cursor.setCursorObject(mapObject);
    }

    public static void renderQuickLinks() {
        int n = AnimationManager.getAnimFrameHeight(247, 0);
        int n2 = m_viewportX + (m_viewportWidth >> 1);
        int n3 = m_viewportY + (n >> 1);
        int n4 = m_viewportY + m_viewportHeight - (n >> 1);
        Debug.UserInterface_drawAnimBox(m_viewportX, m_viewportY, m_viewportWidth, m_viewportHeight, 247, -1);
        GameConstants.TextHandler_drawString(112, 0, n2, n3, 3);
        int n5 = m_quickLinksMenu[2] + 5;
        short s = m_quickLinksMenu[n5];
        MapObject mapObject = StateInGame.findRandomObjectByType(s);
        int n6 = mapObject.getTooltipStringId();
        SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendIntToBuffer(m_quickLinksMenu[2] + 1);
        GameConstants.TextHandler_appendStringIdToBuffer(10);
        GameConstants.TextHandler_appendStringIdToBuffer(n6);
        GameConstants.TextHandler_drawString(sDKString, 1, n2, n4, 3);
        int n7 = AnimationManager.getAnimFrameHeight(223, 0);
        int n8 = n4 - (n7 >> 1);
        Debug.UserInterface_m_arrowLeftAnimPlayer.drawAnim(3, n8);
        Debug.UserInterface_m_arrowRightAnimPlayer.drawAnim(237, n8);
    }

    public static void renderQuickLinksMarker(int n, int n2) {
        AnimationManager.drawAnimFrame(288, 0, n, n2);
        AnimationManager.getAnimFrameFirePoint(m_tempInt10, 288, 0, 0);
        SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendIntToBuffer(m_quickLinksMenu[2] + 1);
        GameConstants.TextHandler_drawString(sDKString, 1, n + m_tempInt10[0], n2 + m_tempInt10[1], 17);
    }

    public static void stateTransitionInfoScreen(int n) {
        switch (n) {
            default: {
                break;
            }
            case 0: {
                if (m_infoScreenState != 9) {
                    m_infoScreenSimSelectedIndex = 0;
                }
                StateInGame.initListRelationships();
                break;
            }
            case 9: {
                m_infoScreenSimSelectedIndex = Debug.UserInterface_getListCursor();
                StateInGame.reloadInfoScreenSim();
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                int n2 = 520;
                if (Main.m_simData.getDream() == -1) {
                    n2 = 523;
                } else if (!Main.m_simData.isDreamToPromisePossible()) {
                    n2 = 521;
                }
                GameConstants.TextHandler_wrapString(n2, 1, Debug.UserInterface_m_uiInfoBoxWrapWidth);
                StateInGame.initListDreams();
                break;
            }
            case 4: {
                StateInGame.initListStatus();
                break;
            }
            case 5: {
                StateInGame.initListPersonaGoals();
                break;
            }
            case 6: {
                StateInGame.initListInventory();
                break;
            }
            case 10: {
                StateInGame.initListRecipe();
                break;
            }
            case 7: {
                StateInGame.stateTransition(5);
                break;
            }
            case 8: {
                StateInGame.stateTransition(5);
                if (m_shortcutByShortcutKey) break;
                StateInGame.showShortcutMenu();
                int n3 = -1;
                switch (m_infoScreenState) {
                    default: {
                        break;
                    }
                    case 0: {
                        n3 = 104;
                        break;
                    }
                    case 1: {
                        n3 = 103;
                        break;
                    }
                    case 2: {
                        n3 = 105;
                        break;
                    }
                    case 3: {
                        n3 = 106;
                        break;
                    }
                    case 4: {
                        n3 = 107;
                        break;
                    }
                    case 5: {
                        n3 = 108;
                        break;
                    }
                    case 6: {
                        n3 = 110;
                    }
                }
                if (n3 == -1) break;
                Main.menuSelectById(m_shortcutMenuItems, n3);
            }
        }
        m_infoScreenState = n;
        StateInGame.setupSoftkeys();
    }

    public static void reloadInfoScreenSim() {
        int n = StateInGame.getInfoSim();
        if (n != m_infoLoadedNPC) {
            m_infoLoadedNPC = n;
            int n2 = 98304;
            Main.unloadAllImages(n2, 1);
            n2 = Main.m_simData.getSimAttribute(n, 0) == 0 ? 32768 : 65536;
            Main.m_simWorld.getSimPatches(n, m_palSources, m_palPatches);
            Main.loadAllImages(n2, m_palSources, m_palPatches, 1);
        }
    }

    public static void processKeysInfoScreen() {
        if (m_infoScreenState == 9) {
            if (Main.softPressNeg()) {
                StateInGame.stateTransitionInfoScreen(0);
                return;
            }
            int n = Main.m_simData.getRelationshipNthCount();
            if (AnimationManager.PMInput_isPressed(8)) {
                m_infoScreenSimSelectedIndex = (m_infoScreenSimSelectedIndex + n - 1) % n;
                Debug.UserInterface_triggerLeftArrow();
                StateInGame.reloadInfoScreenSim();
            } else if (AnimationManager.PMInput_isPressed(16)) {
                m_infoScreenSimSelectedIndex = (m_infoScreenSimSelectedIndex + 1) % n;
                Debug.UserInterface_triggerRightArrow();
                StateInGame.reloadInfoScreenSim();
            }
        } else if (m_infoScreenState == 10) {
            if (Main.softPressNeg()) {
                StateInGame.stateTransitionInfoScreen(6);
                return;
            }
            Debug.UserInterface_processKeysList();
        } else {
            if (Main.softPressNeg()) {
                StateInGame.stateTransitionInfoScreen(8);
                return;
            }
            switch (m_infoScreenState) {
                default: {
                    break;
                }
                case 0: {
                    Debug.UserInterface_processKeysList();
                    if (Debug.UserInterface_getListNum() <= 0 || !AnimationManager.PMInput_isPressed(1) && !Main.softPressPos()) break;
                    StateInGame.stateTransitionInfoScreen(9);
                    return;
                }
                case 3: {
                    Debug.UserInterface_processKeysList();
                    if (Main.m_simData.getDream() == -1 || !Main.m_simData.isDreamToPromisePossible() || !AnimationManager.PMInput_isPressed(1) && !Main.softPressPos(8)) break;
                    Main.m_simData.dreamToPromise();
                    GameConstants.TextHandler_wrapString(522, 1, Debug.UserInterface_m_uiInfoBoxWrapWidth);
                    Main.setSoftKeys(4, 0);
                    break;
                }
                case 4: 
                case 5: {
                    Debug.UserInterface_processKeysList();
                    break;
                }
                case 6: {
                    int n;
                    if (Debug.UserInterface_processKeysList()) {
                        StateInGame.setupSoftkeys();
                    }
                    if ((n = StateInGame.getInfoItem()) == -1 || (Main.m_simWorld.getItemFlags(n) & 0x80) == 0 || !AnimationManager.PMInput_isPressed(1) && !Main.softPressPos()) break;
                    StateInGame.stateTransitionInfoScreen(10);
                }
            }
            if (AnimationManager.PMInput_isPressed(8)) {
                if (--m_infoScreenState < 0) {
                    m_infoScreenState = 6;
                }
                StateInGame.stateTransitionInfoScreen(m_infoScreenState);
                Debug.UserInterface_triggerLeftArrow();
            } else if (AnimationManager.PMInput_isPressed(16)) {
                if (++m_infoScreenState > 6) {
                    m_infoScreenState = 0;
                }
                StateInGame.stateTransitionInfoScreen(m_infoScreenState);
                Debug.UserInterface_triggerRightArrow();
            }
        }
    }

    public static void updateInfoScreen(int n) {
        Debug.UserInterface_updateLeftRightArrows(n);
    }

    public static void renderInfoScreen() {
        switch (m_infoScreenState) {
            default: {
                break;
            }
            case 0: {
                Debug.UserInterface_drawUIFullScreen(14);
                break;
            }
            case 1: {
                StateInGame.renderInfoScreenCareer(false);
                break;
            }
            case 2: {
                AnimationManager.setColor(77);
                Debug.PMGraphics_fillRect(0, 0, 240, 260);
                Debug.UserInterface_drawUIFullScreen(17);
                break;
            }
            case 3: {
                Debug.UserInterface_drawUIFullScreen(11);
                break;
            }
            case 4: {
                StateInGame.renderInfoScreenStatus();
                break;
            }
            case 5: {
                StateInGame.renderInfoScreenPersona();
                break;
            }
            case 6: {
                Debug.UserInterface_drawUIFullScreen(12);
                break;
            }
            case 9: {
                StateInGame.renderInfoScreenNPCRelationship();
                break;
            }
            case 10: {
                StateInGame.renderInfoScreenRecipe();
            }
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void initListRelationships() {
        Debug.UserInterface_initList(Main.m_simData.getRelationshipNthCount(), 16, m_infoScreenSimSelectedIndex);
    }

    public static void drawListRelationships(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        if (Debug.UserInterface_getListNum() == 0) {
            int n9 = n + (n3 >> 1);
            int n10 = n2 + 3;
            GameConstants.TextHandler_drawString(565, 0, n9, n10, 17);
            return;
        }
        if (m_npcLongestStringLength == 0) {
            n8 = 0;
            n7 = Main.m_simData.getSimCount();
            for (int i = 1; i < n7; ++i) {
                n6 = Main.m_simData.getSimName(i);
                n5 = GameConstants.TextHandler_getStringWidth(n6, 0);
                if (n5 <= n8) continue;
                n8 = n5;
            }
            m_npcLongestStringLength = n8;
        }
        n8 = n3 - m_npcLongestStringLength - 9;
        n7 = n + n3 - n8 - 3;
        n6 = n + 3;
        n5 = n2;
        int n11 = Debug.UserInterface_getListCursor();
        for (int i = Debug.UserInterface_getListOffset(); n5 < n2 + n4 && i < Debug.UserInterface_getListNum(); ++i) {
            int n12 = Main.m_simData.getRelationshipNthItem(i);
            int n13 = Main.m_simData.getSimName(n12);
            if (i == n11) {
                Debug.UserInterface_drawListSelect(n, n5, n3, 16, n2 + n4, 82, i);
            }
            GameConstants.TextHandler_drawString(n13, 0, n6, n5 + 1, 20);
            int n14 = Main.m_simData.getRelState(n12);
            int n15 = 65536;
            StateInGame.drawRelBar(n7, n5 + 1, n8, n14, n15, true);
            Debug.UserInterface_drawListDivider(n, n5 += 16, n3);
        }
    }

    public static void renderInfoScreenCareer(boolean bl) {
        int n;
        int n2 = -1;
        int n3 = 0;
        if (bl) {
            n = 8;
            n2 = m_jobOfferCareer;
            n3 = m_jobOfferLevel;
        } else {
            n2 = Main.m_simData.getSimCareer(0);
            if (n2 == -1) {
                n = 5;
            } else {
                n = 6;
                n3 = Main.m_simData.getSimCareerLevel(0);
            }
        }
        int n4 = 103;
        if (n2 == -1) {
            if (bl) {
                n4 = 529;
            }
        } else {
            int n5;
            if (bl) {
                n4 = n2 == Main.m_simData.getSimCareer(0) ? 531 : 530;
            }
            Debug.UserInterface_setUIPlaceholderString(1, n4);
            Debug.UserInterface_setUIPlaceholderString(2, Main.m_simData.getCareerDescString(n2));
            Debug.UserInterface_setUIPlaceholderString(3, Main.m_simData.getCareerLevelDescString(n2, n3));
            int n6 = Main.m_simData.getCareerLevelIncome(n2, n3);
            SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
            GameConstants.TextHandler_appendMoneyToBuffer(n6);
            GameConstants.TextHandler_dynamicString(-9, sDKString);
            Debug.UserInterface_setUIPlaceholderString(4, -9);
            int n7 = Main.m_simData.getCareerRabbitHole(n2);
            Debug.UserInterface_setUIPlaceholderString(5, Main.m_simWorld.getObjectStringId(n7));
            int n8 = Main.m_simData.getCareerBoss(n2);
            Debug.UserInterface_setUIPlaceholderString(6, Main.m_simData.getSimName(n8));
            int n9 = Main.m_simData.getCareerLevelFlags(n2, n3);
            sDKString = GameConstants.TextHandler_clearStringBuffer();
            SDKString sDKString2 = GameConstants.TextHandler_getString(8);
            int n10 = 0;
            for (n5 = 0; n5 < SimData.DAY_FLAGS.length; ++n5) {
                if ((n9 & SimData.DAY_FLAGS[n5]) == 0) continue;
                if (n10 > 0) {
                    GameConstants.TextHandler_appendSDKStringToBuffer(sDKString2);
                }
                GameConstants.TextHandler_appendStringIdToBuffer(SimData.DAY_STRINGS[n5]);
                ++n10;
            }
            GameConstants.TextHandler_dynamicString(-8, sDKString);
            Debug.UserInterface_setUIPlaceholderString(7, -8);
            sDKString = GameConstants.TextHandler_clearStringBuffer();
            n5 = Main.m_simData.getCareerLevelHoursStart(n2, n3);
            GameConstants.TextHandler_appendTimeToBuffer24Hour(n5);
            GameConstants.TextHandler_appendStringIdToBuffer(563);
            int n11 = Main.m_simData.getCareerLevelHoursEnd(n2, n3);
            GameConstants.TextHandler_appendTimeToBuffer24Hour(n11);
            GameConstants.TextHandler_dynamicString(-7, sDKString);
            Debug.UserInterface_setUIPlaceholderString(8, -7);
            if (!bl) {
                sDKString = GameConstants.TextHandler_clearStringBuffer();
                int n12 = 0;
                for (int i = 0; i < SimData.PERK_FLAGS.length; ++i) {
                    if ((n9 & SimData.PERK_FLAGS[i]) == 0) continue;
                    if (n12 > 0) {
                        GameConstants.TextHandler_appendSDKStringToBuffer(sDKString2);
                    }
                    GameConstants.TextHandler_appendStringIdToBuffer(SimData.PERK_STRINGS[i]);
                    ++n12;
                }
                if (n12 > 0) {
                    GameConstants.TextHandler_dynamicString(-6, sDKString);
                    Debug.UserInterface_setUIPlaceholderString(9, -6);
                } else {
                    Debug.UserInterface_setUIPlaceholderString(9, 565);
                }
            }
        }
        Debug.UserInterface_setUIPlaceholderString(1, n4);
        Debug.UserInterface_drawUIFullScreen(n);
    }

    public static int drawUISkill(boolean bl, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        if (m_skillLongestStringLength == 0) {
            n10 = Main.m_simData.getSkillCount();
            n9 = 0;
            for (n8 = 0; n8 < n10; ++n8) {
                n7 = Main.m_simData.getSkillDesc(n8);
                n6 = GameConstants.TextHandler_getStringWidth(n7, 0);
                if (n6 <= n9) continue;
                n9 = n6;
            }
            m_skillLongestStringLength = n9;
        }
        if (!bl) {
            n2 += Debug.UserInterface_m_uiTextHeight >> 2;
            n10 = Main.m_simData.getSkillDesc(n5);
            n9 = Main.m_simData.getSkillLevel(n5);
            n8 = Main.m_simData.getSkillLevelDesc(n5);
            n7 = n3 - m_skillLongestStringLength - 3;
            n6 = n + m_skillLongestStringLength + 3;
            GameConstants.TextHandler_drawString(n10, 0, n, n2 + -3, 20);
            StateInGame.drawSkillBar(n6, n2, n7, n9);
            GameConstants.TextHandler_drawString(n8, 0, n, (n2 += Debug.UserInterface_m_uiTextHeight * 2 / 3) + 1, 20);
        }
        return Debug.UserInterface_m_uiTextHeight * 3;
    }

    public static void drawSkillBar(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - 0 >> 10;
        int n7 = 327680 - 0 >> 10;
        int n8 = n3 - 2;
        int n9 = n8 * n6 / n7;
        int n10 = AnimationManager.getAnimFrameHeight(292, 0);
        int n11 = n + 1;
        int n12 = n2 + 1;
        int n13 = n10 + 2;
        AnimationManager.setColor(77);
        Debug.PMGraphics_drawRect(n, n2, n3 - 1, n13 - 1);
        int n14 = Debug.PMGraphics_getClipX();
        int n15 = Debug.PMGraphics_getClipY();
        int n16 = Debug.PMGraphics_getClipWidth();
        int n17 = Debug.PMGraphics_getClipHeight();
        Debug.PMGraphics_setClip(n11, n15, n8, n17);
        AnimationManager.drawAnimFrame(292, 0, n11, n12);
        Debug.PMGraphics_setClip(n14, n15, n16, n17);
        AnimationManager.setColor(77);
        int n18 = 1;
        while (true) {
            if (n18 >= 5) break;
            n5 = n + n3 * n18 / 5;
            Debug.PMGraphics_fillRect(n5, n12, 1, n10);
            ++n18;
        }
        Debug.PMGraphics_setClip(n11, n15, n9, n17);
        AnimationManager.drawAnimFrame(293, 0, n11, n12);
        AnimationManager.setColor(76);
        n18 = 1;
        while (true) {
            if (n18 >= 5) break;
            n5 = n + n3 * n18 / 5;
            Debug.PMGraphics_fillRect(n5, n12, 1, n10);
            ++n18;
        }
        Debug.PMGraphics_setClip(n14, n15, n16, n17);
    }

    public static void initListDreams() {
        Debug.UserInterface_initList(4, 50, -1);
    }

    public static int drawUICurrentDream(boolean bl, int n, int n2, int n3, int n4) {
        if (!bl) {
            int n5 = n + 10;
            int n6 = AnimationManager.getAnimFrameHeight(229, 0);
            int n7 = 25 - (n6 >> 1);
            int n8 = n3 - 30;
            int n9 = n + n3 - n8;
            int n10 = Main.m_simData.getDream();
            int n11 = Main.m_simData.getDreamDescString(n10);
            int n12 = 255;
            if (n10 == -1) {
                n12 = 87;
            }
            GameConstants.TextHandler_drawWrappedStringChunk(19, n11, 1, n8, n9, n2 + 25, 6);
            AnimationManager.drawAnimFrame(n12, 0, n5, n2 + n7);
        }
        return 53;
    }

    public static void renderInfoScreenStatus() {
        Debug.UserInterface_setUIPlaceholderString(1, Main.m_simData.getMoodDescStringId());
        int n = Main.m_simData.getTotalDays();
        SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendIntToBuffer(n);
        GameConstants.TextHandler_dynamicString(-9, sDKString);
        Debug.UserInterface_setUIPlaceholderString(2, -9);
        sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendMoneyToBuffer(Main.m_simData.getMoneySpent());
        GameConstants.TextHandler_dynamicString(-8, sDKString);
        Debug.UserInterface_setUIPlaceholderString(3, -8);
        Debug.UserInterface_drawUIFullScreen(10);
    }

    public static void initListStatus() {
        Debug.UserInterface_initList(Main.m_simData.getMotiveCount(), 17, -1);
    }

    public static void drawListStatus(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = Main.m_simData.getMotiveCount();
        if (m_motiveLongestStringLength == 0) {
            n8 = 0;
            for (n7 = 0; n7 < n9; ++n7) {
                n6 = Main.m_simData.getMotiveDescString(n7);
                n5 = GameConstants.TextHandler_getStringWidth(n6, 0);
                if (n5 <= n8) continue;
                n8 = n5;
            }
            m_motiveLongestStringLength = n8;
        }
        n8 = n + 3;
        n7 = n3 - m_motiveLongestStringLength - 9;
        n6 = n + n3 - n7 - 3;
        n5 = n2;
        for (int i = Debug.UserInterface_getListOffset(); n5 < n2 + n4 && i < Debug.UserInterface_getListNum(); ++i) {
            short s = Main.m_simData.getMotiveDescString(i);
            GameConstants.TextHandler_drawString(s, 0, n8, n5 + 2, 20);
            int n10 = Main.m_simData.getMotiveLevel(i);
            StateInGame.drawStatusBar(n6, n5 + 5, n7, n10);
            Debug.UserInterface_drawListDivider(n, n5 += 17, n3);
        }
    }

    public static void initListPersonaGoals() {
        Debug.UserInterface_initList(Main.m_simData.getPersonaNthGoalCount(), 50, -1);
    }

    public static void renderInfoScreenPersona() {
        SDKString sDKString = Main.getSimName();
        GameConstants.TextHandler_dynamicString(-9, sDKString);
        Debug.UserInterface_setUIPlaceholderString(1, -9);
        short s = Main.m_simData.getPersonaDescString(Main.m_simData.getPersona());
        Debug.UserInterface_setUIPlaceholderString(2, s);
        Debug.UserInterface_drawUIFullScreen(16);
    }

    public static void initListInventory() {
        int n = 0;
        if (m_infoScreenState == 10) {
            n = m_infoScreenItemSelectedIndex;
        }
        Debug.UserInterface_initList(Main.m_simData.getInventoryNthCount(), 18, n);
    }

    public static void initListRecipe() {
        m_infoScreenItemSelectedIndex = Debug.UserInterface_getListCursor();
        m_infoScreenRecipeSelected = Main.m_simWorld.getRecipeForItem(StateInGame.getInfoItem());
        Debug.UserInterface_initList(Main.m_simWorld.getRecipeIngredientCount(m_infoScreenRecipeSelected), 18, -1);
    }

    public static int getInfoItem() {
        return Main.m_simData.getInventoryNthItem(Debug.UserInterface_getListCursor());
    }

    public static void drawListInventory(int n, int n2, int n3, int n4, int n5) {
        int n6 = n + 3 + 8;
        int n7 = n + 3 + 16 + 3;
        int n8 = n7 + 3;
        int n9 = n + n3 - 3;
        int n10 = n9 - 35;
        AnimationManager.setColor(75);
        Debug.PMGraphics_fillRect(n7, n2, 1, n4);
        Debug.PMGraphics_fillRect(n10, n2, 1, n4);
        int n11 = n2;
        int n12 = Debug.UserInterface_getListCursor();
        for (int i = Debug.UserInterface_getListOffset(); n11 < n2 + n4 && i < Debug.UserInterface_getListNum(); ++i) {
            int n13;
            if (n5 == 5) {
                n13 = Main.m_simData.getInventoryNthItem(i);
            } else if (n5 == 9) {
                n13 = Main.m_simWorld.getItemNthItem(m_shoppingObjectType, i);
            } else {
                Debug.ASSERT(n5 == 6, "argh!");
                n13 = Main.m_simWorld.getRecipeIngredient(m_infoScreenRecipeSelected, i);
            }
            int n14 = Main.m_simWorld.getItemDescString(n13);
            int n15 = Main.m_simWorld.getItemIcon(n13);
            if (i == n12) {
                Debug.UserInterface_drawListSelect(n, n11, n3, 18, n2 + n4, 82, i);
            }
            AnimationManager.drawAnimFrame(n15, 0, n6, n11 + 9);
            GameConstants.TextHandler_drawString(n14, 1, n8, n11 + 9, 6);
            int n16 = Main.m_simData.getInventoryCount(n13);
            if (n16 > 0 || n5 == 6) {
                SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
                GameConstants.TextHandler_appendIntToBuffer(n16);
                GameConstants.TextHandler_appendStringIdToBuffer(8);
                if (n5 == 6) {
                    GameConstants.TextHandler_appendIntToBuffer(1);
                } else {
                    GameConstants.TextHandler_appendIntToBuffer(Main.m_simWorld.getItemMaxInventory(n13));
                }
                GameConstants.TextHandler_drawString(sDKString, 1, n9, n11 + 9, 10);
            }
            Debug.UserInterface_drawListDivider(n, n11 += 18, n3);
        }
    }

    public static void renderInfoScreenRecipe() {
        AnimationManager.setColor(77);
        Debug.PMGraphics_fillRect(0, 0, 240, 260);
        int n = Debug.UserInterface_drawDropDownTitle(4, 232, 110);
        int n2 = Main.m_simWorld.getRecipeItem(m_infoScreenRecipeSelected);
        int n3 = Main.m_simWorld.getItemDescString(n2);
        Debug.UserInterface_setUIPlaceholderString(1, n3);
        Debug.UserInterface_drawUIFullScreen(13, n);
    }

    public static int getInfoSim() {
        return Main.m_simData.getRelationshipNthItem(m_infoScreenSimSelectedIndex);
    }

    public static void renderInfoScreenNPCRelationship() {
        int n = StateInGame.getInfoSim();
        AnimationManager.setColor(77);
        Debug.PMGraphics_fillRect(0, 0, 240, 260);
        int n2 = Debug.UserInterface_drawDropDownTitle(4, 232, 104);
        Debug.UserInterface_setUIPlaceholderString(1, Main.m_simData.getSimName(n));
        int n3 = Main.m_simData.getSimPartner(n);
        if (n3 == -1) {
            Debug.UserInterface_setUIPlaceholderString(2, 4);
            Debug.UserInterface_setUIPlaceholderString(3, 4);
        } else {
            Debug.UserInterface_setUIPlaceholderString(2, 546);
            Debug.UserInterface_setUIPlaceholderString(3, Main.m_simData.getSimName(n3));
        }
        int n4 = Main.m_simData.getSimCareer(n);
        int n5 = Main.m_simData.getCareerDescString(n4);
        Debug.UserInterface_setUIPlaceholderString(4, n5);
        Debug.UserInterface_drawUIFullScreen(15, n2);
        Debug.UserInterface_drawDropDownTitle(4, 232, 104);
    }

    public static int drawUIRelationship(boolean bl, int n, int n2, int n3, int n4) {
        if (!bl) {
            int n5 = StateInGame.getInfoSim();
            int n6 = n2;
            int n7 = Main.m_simData.getRelState(n5);
            StateInGame.drawRelBar(n, n6, n3, n7, 65536, true);
            n6 += 15;
            Main.m_simData.getRelationshipLevels(n5, m_tempInt10);
            for (int i = 0; i < 4 && (n7 = m_tempInt10[i]) != -1; i += 2) {
                int n8 = m_tempInt10[i + 1];
                StateInGame.drawRelBar(n, n6 += 3, n3, n7, n8, false);
                n6 += 15;
            }
        }
        return 51;
    }

    public static void drawAnimBar(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = Debug.PMGraphics_getClipX();
        int n10 = Debug.PMGraphics_getClipY();
        int n11 = Debug.PMGraphics_getClipWidth();
        int n12 = Debug.PMGraphics_getClipHeight();
        int n13 = IStringConstants.MathExt_Fmul(n3, n4);
        int n14 = AnimationManager.getAnimFrameWidth(n5, n8);
        int n15 = AnimationManager.getAnimFrameWidth(n6, n8);
        int n16 = Math.min(n3 - n15 - n14, n13 - n14);
        Debug.PMGraphics_setClip(n, n10, n13, n12);
        AnimationManager.drawAnimFrame(n5, n8, n, n2);
        AnimationManager.drawAnimFrame(n6, n8, n + n3 - n15, n2);
        Debug.PMGraphics_setClip(n + n14, n10, n16, n12);
        AnimationManager.drawAnimFrame(n7, n8, n + n14, n2);
        Debug.PMGraphics_setClip(n9, n10, n11, n12);
    }

    public static void drawStatusBar(int n, int n2, int n3, int n4) {
        StateInGame.drawAnimBar(n, n2, n3, 65536, 299, 300, 298, 0);
        int n5 = n4 < 0x230000 ? 2 : 1;
        n4 = IStringConstants.MathExt_Fdiv(n4, 0x640000);
        StateInGame.drawAnimBar(n, n2, n3, n4, 299, 300, 298, n5);
    }

    public static void drawRelBar(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = Main.m_simData.getRelStateFlags(n4);
        int n7 = (n6 & 2) != 0 ? 1 : ((n6 & 1) != 0 ? 3 : 2);
        int n8 = bl ? n7 : 0;
        StateInGame.drawAnimBar(n, n2, ++n3, 65536, 290, 291, 289, n8);
        if (!bl) {
            StateInGame.drawAnimBar(n, n2, n3, n5, 290, 291, 289, n7 + 3);
        }
        int n9 = Main.m_simData.getRelStateDescString(n4);
        int n10 = n + (n3 >> 1);
        int n11 = n2 + 0;
        int n12 = bl ? 0 : 1;
        SDKString sDKString = GameConstants.TextHandler_getString(n9);
        GameConstants.TextHandler_renderScroller(0, n9, n12, n + 2, n11, n3 - 4, 17);
    }

    public static void showJobOffer(int n, int n2, boolean bl) {
        StateInGame.hideQuickLinks();
        m_jobOfferCareer = n;
        m_jobOfferLevel = n2;
        if (n == -1) {
            Debug.UserInterface_prepareGenericMessageBox(528, 529);
        } else {
            if (!bl && !Main.m_simData.careerRequirementsMet(n, n2)) {
                StateInGame.showJobRaiseFail(n, n2);
                return;
            }
            int n3 = Main.m_simData.getSimCareer(0);
            int n4 = n3 == -1 ? 532 : (n3 == n ? 534 : 533);
            GameConstants.TextHandler_wrapString(n4, 1, Debug.UserInterface_m_uiMessageBoxWrapWidth);
        }
        StateInGame.stateTransition(10);
    }

    public static void processKeysJobOffer() {
        if (m_jobOfferCareer == -1) {
            if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos() || Main.softPressNeg()) {
                StateInGame.stateTransition(5);
            }
        } else if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            int n = Main.m_simData.getSimCareer(0);
            int n2 = Main.m_simData.getSimCareerLevel(0);
            int n3 = m_jobOfferCareer;
            int n4 = m_jobOfferLevel;
            Main.m_simData.careerAcceptJob(n3, n4);
            if (n4 == Main.m_simData.getCareerLevelCount(n3) - 1) {
                Main.m_simData.dreamCompleteEvent(41);
            } else if (n4 > 0) {
                Main.m_simData.dreamCompleteEvent(26);
            }
        } else if (Main.softPressNeg()) {
            StateInGame.stateTransition(5);
        }
    }

    public static void renderJobOffer() {
        int n = m_jobOfferCareer;
        if (n != -1) {
            StateInGame.renderInfoScreenCareer(true);
        } else {
            StateInGame.renderMain();
            if (!m_pauseMenuActive) {
                ArrayHandler.PostEffects_renderBackgroundDim();
                Debug.UserInterface_drawGenericMessageBox();
            }
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void finishWork() {
        if (Main.randPercent() < 5) {
            int n = Main.m_simData.getCareerDeathString();
            StateInGame.killPlayer(n);
        } else {
            StateInGame.stateTransition(11);
        }
    }

    public static void processKeysPay() {
        if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos() || Main.softPressNeg()) {
            if (Main.m_simData.careerAutoPromotionDue()) {
                int n = Main.m_simData.getSimCareer(0);
                int n2 = Main.m_simData.getSimCareerLevel(0);
                StateInGame.showJobOffer(n, n2 + 1, false);
            } else {
                StateInGame.stateTransition(5);
            }
        }
    }

    public static void renderPay() {
        Debug.UserInterface_setUIPlaceholderString(1, 604);
        Debug.UserInterface_setUIPlaceholderString(2, 549);
        SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendMoneyToBuffer(m_payIncome);
        GameConstants.TextHandler_dynamicString(-9, sDKString);
        Debug.UserInterface_setUIPlaceholderString(3, -9);
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            ArrayHandler.PostEffects_renderBackgroundDim();
            Debug.UserInterface_drawUIFullScreen(20);
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void showJobRaiseFail(int n, int n2) {
        m_jobOfferCareer = n;
        m_jobOfferLevel = n2;
        int n3 = Main.m_simData.getCareerFailString(n);
        GameConstants.TextHandler_wrapString(n3, 1, Debug.UserInterface_m_uiMessageBoxWrapWidth);
        StateInGame.stateTransition(12);
    }

    public static void renderRaiseFailure() {
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            SDKString sDKString;
            ArrayHandler.PostEffects_renderBackgroundDim();
            int n = m_jobOfferCareer;
            int n2 = m_jobOfferLevel;
            byte[] byArray = Main.m_simData.getCareerLevelRequirements(n, n2);
            byte by = byArray[0];
            byte by2 = byArray[1];
            byte by3 = byArray[2];
            byte by4 = byArray[3];
            int n3 = Main.m_simData.getSimName(Main.m_simData.getCareerBoss(n));
            Debug.UserInterface_setUIPlaceholderString(0, n3);
            Debug.UserInterface_setUIPlaceholderString(1, n3);
            int n4 = 1;
            if (by != -1) {
                n4 = 20;
                Debug.UserInterface_setUIPlaceholderString(2, Main.m_simData.getRequimentName(by));
                sDKString = GameConstants.TextHandler_clearStringBuffer();
                GameConstants.TextHandler_appendIntToBuffer(Main.m_simData.getRequirementValue(by));
                GameConstants.TextHandler_appendStringIdToBuffer(8);
                GameConstants.TextHandler_appendIntToBuffer(by2);
                GameConstants.TextHandler_dynamicString(-9, sDKString);
                Debug.UserInterface_setUIPlaceholderString(3, -9);
            }
            if (by3 != -1) {
                n4 = 21;
                Debug.UserInterface_setUIPlaceholderString(4, Main.m_simData.getRequimentName(by3));
                sDKString = GameConstants.TextHandler_clearStringBuffer();
                GameConstants.TextHandler_appendIntToBuffer(Main.m_simData.getRequirementValue(by3));
                GameConstants.TextHandler_appendStringIdToBuffer(8);
                GameConstants.TextHandler_appendIntToBuffer(by4);
                GameConstants.TextHandler_dynamicString(-8, sDKString);
                Debug.UserInterface_setUIPlaceholderString(5, -8);
            }
            Debug.UserInterface_drawUIFullScreen(n4);
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void processKeysRaiseFailure() {
        if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            StateInGame.stateTransition(5);
        }
    }

    public static void showQuitJob() {
        m_quitJobConfirmed = false;
        int n = Main.m_simData.getCareerLevelDescString(Main.m_simData.getSimCareer(0), Main.m_simData.getSimCareerLevel(0));
        Debug.UserInterface_prepareGenericMessageBox(606, n);
        StateInGame.stateTransition(13);
    }

    public static void processKeysQuitJob() {
        if (Main.softPressNeg() || m_quitJobConfirmed && Main.softPressPos()) {
            StateInGame.stateTransition(5);
        } else if (Main.softPressPos()) {
            Main.m_simData.careerAcceptJob(-1, 0);
            m_quitJobConfirmed = true;
            StateInGame.setupSoftkeys();
            Debug.UserInterface_prepareGenericMessageBox(607, 328);
        }
    }

    public static void renderQuitJob() {
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            ArrayHandler.PostEffects_renderBackgroundDim();
            Debug.UserInterface_drawGenericMessageBox();
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void showNewDream() {
        m_showNewDream = true;
    }

    public static void showExpiredDream(int n) {
        StateInGame.showTickerMessage(516, Main.m_simData.getDreamDescString(n));
    }

    public static void showNewDreamMessage() {
        StateInGame.hideQuickLinks();
        Intro.PMVibrate_vibrate(260);
        int n = 520;
        if (!Main.m_simData.isDreamToPromisePossible()) {
            n = 521;
        }
        GameConstants.TextHandler_wrapString(n, 1, Debug.UserInterface_m_uiInfoBoxWrapWidth);
        StateInGame.stateTransition(14);
    }

    public static void renderNewDream() {
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            ArrayHandler.PostEffects_renderBackgroundDim();
            Debug.UserInterface_drawUIFullScreen(24);
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void processKeysNewDream() {
        if (Main.softPressNeg()) {
            StateInGame.stateTransition(5);
            GameConstants.TextHandler_resetScrollers();
        } else if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            if (Main.m_simData.isDreamToPromisePossible()) {
                Main.m_simData.dreamToPromise();
            }
            StateInGame.stateTransition(5);
            GameConstants.TextHandler_resetScrollers();
        }
    }

    public static void showNewPromise(int n) {
        m_dreamAnimPlayers[n].startAnim(256, 16);
    }

    public static void showGoalCompleted(int n, int n2) {
        StateInGame.showTickerMessage(517, Main.m_simData.getDreamDescString(n));
        StateInGame.getPlayerSim().queueSimAction(9, null, 0, 0);
        if (n2 != -1) {
            m_dreamAnimPlayers[n2].startAnim(257, 16);
        }
    }

    public static void showDoorKnock(int n) {
        StateInGame.showTickerMessage(Main.m_simData.getSimName(n), 513);
    }

    public static void renderShowGetItem() {
        StateInGame.renderMain();
        if (!m_pauseMenuActive) {
            ArrayHandler.PostEffects_renderBackgroundDim();
            Debug.UserInterface_drawUIFullScreen(25);
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void processKeysShowGetItem() {
        if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            m_showGetItem = -1;
            StateInGame.stateTransition(5);
        }
    }

    public static int drawUIGetItem(boolean bl, int n, int n2, int n3, int n4) {
        if (!bl) {
            int n5 = m_showGetItem;
            int n6 = n + 3 + 8;
            int n7 = n2 + 9;
            int n8 = n + 3 + 16 + 3;
            int n9 = n8 + 3;
            int n10 = n2 + 9;
            int n11 = n + n3 - 3;
            int n12 = Main.m_simWorld.getItemIcon(n5);
            AnimationManager.drawAnimFrame(n12, 0, n6, n7);
            SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
            if (m_showGetItemQty != 1) {
                GameConstants.TextHandler_appendIntToBuffer(m_showGetItemQty);
                GameConstants.TextHandler_appendStringIdToBuffer(619);
            }
            GameConstants.TextHandler_appendStringIdToBuffer(Main.m_simWorld.getItemDescString(n5));
            GameConstants.TextHandler_drawString(sDKString, 0, n9, n10, 6);
            sDKString = GameConstants.TextHandler_clearStringBuffer();
            GameConstants.TextHandler_appendIntToBuffer(Main.m_simData.getInventoryCount(n5));
            GameConstants.TextHandler_appendStringIdToBuffer(8);
            GameConstants.TextHandler_appendIntToBuffer(Main.m_simWorld.getItemMaxInventory(n5));
            GameConstants.TextHandler_drawString(sDKString, 0, n11, n10, 10);
        }
        return 18;
    }

    public static boolean isPlayerInactive() {
        return m_simInactivityTimer > 20000;
    }

    public static void resetPlayerInactivity() {
        m_simInactivityTimer = 0;
        StateInGame.getPlayerSim().clearNeedFlags();
    }

    public static void updateEventsHouse(int n) {
        m_simAIEventTimer += n;
        if (Main.getNextHouseId() == 6 && Main.m_simData.timeArrivedInCairo > 0 && Main.m_simData.getGameTimeAbs() - Main.m_simData.timeArrivedInCairo > 120) {
            Main.m_simData.timeArrivedInCairo = -1;
            m_pauseMenuItems = null;
            StateInGame.showMessageBox(837, 836, 6);
        }
        if (IStringConstants.Minigame_maxedWorldKnowledgeFlag) {
            GameConstants.TextHandler_dynamicString(-11, 686, Main.m_simData.getSkillDesc(4));
            Event.triggerEvent(4, -11, 4);
            IStringConstants.Minigame_maxedWorldKnowledgeFlag = false;
        } else if (IStringConstants.Minigame_firstClassBoughtFlag) {
            Main.m_simData.dreamCompleteEvent(23);
            IStringConstants.Minigame_firstClassBoughtFlag = false;
        }
        int n2 = Main.m_simWorld.getHouseId();
        int n3 = 3000;
        if (Main.m_simData.getFastforward()) {
            n3 >>= 1;
        }
        if (n2 == 0 && !Main.m_simData.initMsgHasShownAtHome && m_simAIEventTimer > n3 >> 1) {
            Main.m_simData.initMsgHasShownAtHome = true;
            StateInGame.showMessageBox(828, 827);
        } else if (Main.m_simWorld.showAirportWelcomeMessage && m_mapModePrev == 0 && Main.isForeignAirport(n2) && m_simAIEventTimer > n3 >> 2) {
            Main.m_simWorld.showAirportWelcomeMessage = false;
            switch (n2) {
                case 7: {
                    StateInGame.showMessageBox(954, 953);
                    break;
                }
                case 6: {
                    StateInGame.showMessageBox(956, 955);
                    break;
                }
                case 4: {
                    StateInGame.showMessageBox(958, 957);
                    break;
                }
                case 5: {
                    StateInGame.showMessageBox(960, 959);
                    break;
                }
            }
        }
        if (m_simAIEventTimer > n3) {
            int n4;
            int n5;
            m_simAIEventTimer = 0;
            if (Main.m_simWorld.potentialVisitor != -1) {
                if ((Main.m_simData.getGameTimeAbs() - lastVisitorTime) / 60 > 48 && Main.m_simData.isTimeInRange(Main.m_simData.getGameTime(), 360, 1260)) {
                    if (StateInGame.nextAvailableBank() != -1) {
                        MapObjectSim mapObjectSim = StateInGame.findSim(Main.m_simWorld.potentialVisitor);
                        if (mapObjectSim != null) {
                            Main.m_simWorld.potentialVisitor = Main.m_simData.determinePotentialVisitor();
                            return;
                        }
                        n5 = Main.randPercent();
                        if (n5 < currentVisitorChance) {
                            mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, StateInGame.findRandomObjectByType(4), Main.m_simWorld.potentialVisitor);
                            mapObjectSim.setNeedFlag(32);
                            Main.m_simWorld.potentialVisitor = -1;
                        } else {
                            currentVisitorChance = Main.m_simData.isItAWorkDayToday() ? (currentVisitorChance += 2) : (currentVisitorChance += 10);
                        }
                    } else {
                        Main.m_simWorld.potentialVisitor = -1;
                    }
                }
            }
            int n6 = Main.m_simData.getSimCount();
            for (n5 = 1; n5 < n6; ++n5) {
                n4 = Main.m_simData.getTimeFlags(n5);
                MapObjectSim mapObjectSim = StateInGame.findSim(n5);
                if (mapObjectSim != null) {
                    if ((n4 & (1 | 2 | 4)) != 0) {
                        mapObjectSim.setNeedFlag(1);
                    }
                    if ((n4 & 0x10) == 0) continue;
                    if (n2 == Main.m_simData.getSimHome(n5)) {
                        mapObjectSim.setNeedFlag(4);
                        continue;
                    }
                    Event.PMDebug_println("adding leave (for sleep) flag");
                    mapObjectSim.setNeedFlag(256);
                    continue;
                }
                if ((n4 & 8) == 0 || n2 != Main.m_simData.getSimHome(n5) || StateInGame.nextAvailableBank() == -1) continue;
                MapObject mapObject = StateInGame.findRandomObjectByType(4);
                if (mapObject == null) {
                    mapObject = StateInGame.findRandomObjectByType(3);
                }
                if (mapObject == null) {
                    mapObject = StateInGame.findRandomObjectByParentType(6);
                }
                mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject, n5);
            }
            MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
            for (n4 = 1; n4 < mapObjectSimArray.length; ++n4) {
                MapObject mapObject;
                if (!mapObjectSimArray[n4].isIdle() || !mapObjectSimArray[n4].occupiedIsEmpty()) continue;
                if (Main.isAirport(n2) && Main.randPercent() > 60 && (mapObject = StateInGame.findRandomMapDestination()).getClosestInterestPoint(mapObjectSimArray[n4].getPosX(), mapObjectSimArray[n4].getPosZ(), false, null) != -1) {
                    mapObjectSimArray[n4].beginSimAction(76, mapObject);
                }
                int n7 = (Main.randPercent() < 50 ? 2 : 0) | (Main.randPercent() < 25 ? 8 : 0) | (Main.randPercent() < 50 ? 64 : 0) | (Main.randPercent() < 25 ? 16 : 0) | (Main.randPercent() < 60 ? 32 : 0) | (Main.randPercent() < 15 ? 4 : 0);
                mapObjectSimArray[n4].setNeedFlag(n7);
            }
        }
        MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
        if (Main.getAutonomityEnabled()) {
            if (StateInGame.isPlayerInactive()) {
                if (mapObjectSim.isIdle()) {
                    int n8 = Main.m_simData.getPlayerNeedFlags();
                    if (Main.m_simWorld.getHouseId() != 0 && !Main.isAirport(Main.m_simWorld.getHouseId())) {
                        if (!Main.m_simData.getSimCurRelStateFlags(0, 1)) {
                            n8 |= 0x20;
                        }
                    }
                    mapObjectSim.setNeedFlag(n8);
                }
            } else {
                m_simInactivityTimer += n;
            }
        } else {
            mapObjectSim.clearNeedFlags();
        }
    }

    public static void updateEventsZoomMode(int n) {
        MapObjectSim[] mapObjectSimArray;
        if (GameConstants.MinigameWorldknowledge_tripBought && IStringConstants.Minigame_m_miniGameTargetObject != null) {
            GameConstants.MinigameWorldknowledge_tripBought = false;
        }
        m_simAIEventTimer += n;
        if (Main.getNextZoomMapId() == 58 && Main.m_simData.timeArrivedInCairo != -1 && Main.m_simData.getGameTimeAbs() - Main.m_simData.timeArrivedInCairo > 120) {
            Main.m_simData.timeArrivedInCairo = -1;
            m_pauseMenuItems = null;
            StateInGame.showMessageBox(837, 836, 6);
        }
        int n2 = 5000;
        if (Main.m_simData.getFastforward()) {
            n2 >>= 1;
        }
        if (m_simAIEventTimer > n2 >> 2) {
            switch (Main.getNextZoomMapId()) {
                case 57: {
                    Main.m_simData.dreamCompleteEvent(1);
                    break;
                }
                case 58: {
                    Main.m_simData.dreamCompleteEvent(0);
                    break;
                }
                case 60: {
                    Main.m_simData.dreamCompleteEvent(2);
                    break;
                }
                case 61: {
                    Main.m_simData.dreamCompleteEvent(3);
                    break;
                }
            }
        }
        if (m_simAIEventTimer > n2) {
            MapObjectSim mapObjectSim;
            m_simAIEventTimer = 0;
            Event.PMDebug_println("zoom map event");
            mapObjectSimArray = StateInGame.getSimObjects();
            int n3 = 50;
            if (Main.getNextZoomMapId() == 62 && mapObjectSimArray.length <= 2) {
                boolean bl = false;
                int n4 = Main.m_simData.getSimCount();
                int n5 = 4;
                for (int i = 0; i < n5; ++i) {
                    MapObject mapObject;
                    int n6 = Main.rand(1, n4 - 1);
                    if (Main.m_simData.getSimHome(n6) == -1) continue;
                    mapObjectSim = StateInGame.findSim(n6);
                    int n7 = Main.m_simData.getTimeFlags(n6);
                    if (mapObjectSim != null) {
                        if ((n7 & (1 | 2 | 4)) != 0) {
                            mapObjectSim.setNeedFlag(1);
                        }
                        if ((n7 & 0x10) == 0) continue;
                        Event.PMDebug_println("adding leave (for sleep) flag");
                        mapObjectSim.setNeedFlag(256);
                        continue;
                    }
                    if ((n7 & 8) == 0) continue;
                    if ((n7 & 0x10) != 0 || StateInGame.nextAvailableBank() == -1 || bl) continue;
                    bl = true;
                    if (Main.randPercent() >= n3 || (mapObject = StateInGame.findRandomObjectByType(3)) == null) continue;
                    mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject, n6);
                    mapObjectSim.setNeedFlag(32);
                }
            } else {
                MapObject mapObject;
                int n8;
                for (n8 = Main.m_simWorld.currentAirportSims.length - 1; n8 > Main.m_simWorld.currentAirportSims.length / 2; --n8) {
                    if (Main.randPercent() >= n3) continue;
                    if (StateInGame.nextAvailableBank() == -1 || StateInGame.findSim(Main.m_simWorld.currentAirportSims[n8]) != null || (mapObject = StateInGame.findRandomObjectByType(3)) == null) break;
                    mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject, Main.m_simWorld.currentAirportSims[n8]);
                    break;
                }
                mapObjectSimArray = StateInGame.getSimObjects();
                for (n8 = 1; n8 < mapObjectSimArray.length; ++n8) {
                    if (mapObjectSimArray[n8] == null || !mapObjectSimArray[n8].isIdle()) continue;
                    if (Main.randPercent() < 60) {
                        mapObject = StateInGame.findRandomMapDestination();
                        if (mapObject == null || mapObject.getClosestInterestPoint(mapObjectSimArray[n8].getPosX(), mapObjectSimArray[n8].getPosZ(), false, null) == -1) continue;
                        mapObjectSimArray[n8].beginSimAction(76, mapObject);
                        continue;
                    }
                    if (Main.randPercent() >= 10) continue;
                    mapObjectSimArray[n8].setNeedFlag(32);
                }
            }
        }
        mapObjectSimArray = StateInGame.getPlayerSim();
        if (Main.getAutonomityEnabled()) {
            if (StateInGame.isPlayerInactive()) {
                if (mapObjectSimArray.isIdle()) {
                    int n9 = Main.m_simData.getPlayerNeedFlags();
                    mapObjectSimArray.setNeedFlag(n9);
                }
            } else {
                m_simInactivityTimer += n;
            }
        } else {
            mapObjectSimArray.clearNeedFlags();
        }
    }

    public static void updateEventsMapMode(int n) {
        if ((m_simAIEventTimer += n) > 5000) {
            MapObject mapObject;
            int n2;
            m_simAIEventTimer = 0;
            int n3 = Main.rand(1, Main.m_simData.getSimCount() - 1);
            MapObjectSim mapObjectSim = StateInGame.findSim(n3);
            if (mapObjectSim == null && (n2 = Main.m_simData.getSimHome(n3)) != -1) {
                int n4 = Main.m_simWorld.getHouseMacroObject(n2);
                MapObject mapObject2 = StateInGame.findRandomObjectByType(n4);
                mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject2, n3);
            }
            if (mapObjectSim != null && mapObjectSim.isIdle() && (mapObject = StateInGame.findRandomMapDestination()).getClosestInterestPoint(mapObjectSim.getPosX(), mapObjectSim.getPosZ(), false, null) != -1) {
                mapObjectSim.beginSimAction(76, mapObject);
            }
        }
    }

    public static void updateAmbientSounds(int n, int n2, short[] sArray) {
        if (!PMAudio.isEnabled || sArray == null || sArray.length == 0) {
            return;
        }
        if ((m_ambientEventTimer += n) > n2) {
            m_ambientEventTimer = 0;
            if (m_mapMode == 2 && m_playedMapModeMoveMusicTime != -1L && ArrayOptimizer.PMTimer_tick() - m_playedMapModeMoveMusicTime < 12000L) {
                return;
            }
            int n3 = Main.rand(0, sArray.length - 1);
            PMAudio.play(sArray[n3], 1);
        }
    }

    public static MapObject findRandomMapDestination() {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        Debug.ASSERT(mapObjectArray.length <= 257, "LGC isn't big enough for destination list");
        int n = Main.rand(0, mapObjectArray.length - 1);
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[n];
            if (mapObject.getFlag(4096)) {
                return mapObject;
            }
            while ((n = (1543 * n + 3571) % 257) >= mapObjectArray.length) {
            }
        }
        return null;
    }

    public static void putSimInBed(MapObjectSim mapObjectSim) {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        MapObject mapObject = null;
        MapObject mapObject2 = null;
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject3 = mapObjectArray[i];
            if (mapObject3.getParentType() == 4) {
                if (!mapObjectSim.setOccupied(mapObject3)) continue;
                mapObject = mapObject3;
                break;
            }
            if (mapObject3.getParentType() != 6 || !mapObject3.occupiedIsEmpty()) continue;
            mapObject2 = mapObject3;
        }
        if (mapObject == null) {
            mapObject = mapObject2;
        }
        if (mapObject != null) {
            mapObjectSim.gotoSleep(mapObject);
        } else if (mapObjectSim.getId() == 0) {
            mapObjectSim.beginSimAction(6, null);
        }
    }

    public static void advertiseEvent(int n, MapObjectSim mapObjectSim, MapObject mapObject) {
        int n2 = Main.m_simWorld.getHouseId();
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        int n3 = Main.m_simData.getActionFlags(n);
        if (n == 21) {
            Main.m_simData.setSimCurRelStateFlags(0, 1);
        }
        int n4 = mapObjectSimArray.length;
        for (int i = 0; i < n4; ++i) {
            boolean bl;
            MapObjectSim mapObjectSim2 = mapObjectSimArray[i];
            int n5 = mapObjectSim2.getId();
            if (n5 == 0 || mapObjectSim2 != null && (mapObjectSim2.equals(mapObject) || mapObjectSim2.equals(mapObjectSim)) || (n3 & 0x20000) != 0 && Main.m_simData.getSimHome(n5) != n2 || !(bl = mapObjectSim2.respondToEvent(n, mapObjectSim, mapObject)) || (n3 & 0x400000) == 0) continue;
            Event.PMDebug_println("sim responded");
            return;
        }
    }

    public static void processBasicAction(int n) {
        switch (n) {
            case 49: {
                StateInGame.hidePauseMenu();
                break;
            }
            case 52: {
                StateInGame.stateTransitionPauseMenu(2);
                break;
            }
            case 54: {
                StateInGame.stateTransitionPauseMenu(3);
                break;
            }
            case 56: {
                StateInGame.stateTransitionPauseMenu(4);
                break;
            }
            case 58: {
                StateInGame.stateTransitionPauseMenu(1);
                break;
            }
            case 41: {
                GlobalConstants.StateMenu_stateTransitionSharedMenu(1);
                break;
            }
            case 42: {
                GlobalConstants.StateMenu_stateTransitionSharedMenu(3);
                break;
            }
            case 101: {
                StateInGame.hideMenus();
                StateInGame.cancelSimAction();
                break;
            }
            case 293: {
                Main.m_simData.update(25 * 1000, false);
                StateInGame.gotoMap();
                break;
            }
            case 112: {
                StateInGame.hideMenus();
                StateInGame.showQuickLinks();
                break;
            }
            case 292: {
                if (StateInGame.isMapMode()) {
                    StateInGame.hideMenus();
                    int n2 = Main.m_simData.getSimCareer(0);
                    int n3 = Main.m_simData.getCareerRabbitHole(n2);
                    MapObject mapObject = StateInGame.findRandomObjectByType(n3);
                    StateInGame.startPlayerAction(133, mapObject, 0, 0);
                    break;
                }
                StateInGame.gotoWork();
                break;
            }
            case 294: {
                Main.m_simData.update(25 * 1000, false);
                StateInGame.goHome();
                break;
            }
            case 104: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(0);
                break;
            }
            case 103: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(1);
                break;
            }
            case 105: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(2);
                break;
            }
            case 106: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(3);
                break;
            }
            case 107: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(4);
                break;
            }
            case 108: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(5);
                break;
            }
            case 110: {
                StateInGame.hideMenus();
                StateInGame.stateTransition(8);
                StateInGame.stateTransitionInfoScreen(6);
                break;
            }
            case 240: 
            case 241: {
                StateInGame.hideMenus();
                break;
            }
            case 840: {
                switch (Main.getNextHouseId()) {
                    case 6: {
                        Main.setNextZoomMapId(58);
                        ++Main.m_simData.numVisitsCairo;
                        break;
                    }
                    case 7: {
                        Main.setNextZoomMapId(57);
                        ++Main.m_simData.numVisitsBeijing;
                        break;
                    }
                    case 4: {
                        Main.setNextZoomMapId(60);
                        ++Main.m_simData.numVisitsParis;
                        break;
                    }
                    case 5: {
                        Main.setNextZoomMapId(61);
                        ++Main.m_simData.numVisitsSanFran;
                        break;
                    }
                }
                Main.setupEncounter(null);
                Main.m_simData.update(25 * 1000, false);
                StateInGame.changeSceneWithFade(0, 100);
                break;
            }
            case 841: {
                switch (Main.getNextZoomMapId()) {
                    case 57: {
                        Main.setNextHouseId(7);
                        break;
                    }
                    case 58: {
                        Main.setNextHouseId(6);
                        break;
                    }
                    case 60: {
                        Main.setNextHouseId(4);
                        break;
                    }
                    case 61: {
                        Main.setNextHouseId(5);
                        break;
                    }
                }
                Main.m_simData.update(25 * 1000, false);
                StateInGame.changeSceneWithFade(0, 5);
                break;
            }
            default: {
                Debug.ASSERT(false, "action not implemented");
            }
        }
    }

    public static void initActionQueue() {
        m_actionQueueSize = 0;
        if (m_actionQueueActions == null) {
            m_actionQueueActions = new int[3];
            m_actionQueueArg1s = new MapObject[3];
            m_actionQueueArg2s = new int[3];
            m_actionQueueArg3s = new int[3];
        }
        ArrayHandler.fillArray(m_actionQueueActions, -1);
        ArrayHandler.fillArray(m_actionQueueArg1s, null);
    }

    public static void updateSimAction() {
        MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
        int[] nArray = m_actionQueueActions;
        MapObject[] mapObjectArray = m_actionQueueArg1s;
        if (m_actionQueueSize > 0) {
            int n;
            if (mapObjectSim.isIdle()) {
                int n2;
                --m_actionQueueSize;
                for (n2 = 0; n2 < 2; ++n2) {
                    nArray[n2] = nArray[n2 + 1];
                    mapObjectArray[n2] = mapObjectArray[n2 + 1];
                    StateInGame.m_actionQueueArg2s[n2] = m_actionQueueArg2s[n2 + 1];
                    StateInGame.m_actionQueueArg3s[n2] = m_actionQueueArg3s[n2 + 1];
                }
                mapObjectArray[StateInGame.m_actionQueueSize] = null;
                if (m_actionQueueSize > 0) {
                    n2 = nArray[0];
                    MapObject mapObject = mapObjectArray[0];
                    int n3 = m_actionQueueArg2s[0];
                    int n4 = m_actionQueueArg3s[0];
                    StateInGame.startPlayerAction(n2, mapObject, n3, n4);
                }
            } else if (nArray[0] != mapObjectSim.getSimAction() && (Main.m_simData.getActionFlags(n = mapObjectSim.getSimAction()) & 0x40000) == 0) {
                nArray[0] = n;
                mapObjectArray[0] = mapObjectSim.getSimActionArg1();
            }
        } else {
            int n = mapObjectSim.getSimAction();
            if ((Main.m_simData.getActionFlags(n) & 0x40000) == 0) {
                nArray[0] = mapObjectSim.getSimAction();
                mapObjectArray[0] = mapObjectSim.getSimActionArg1();
                m_actionQueueSize = 1;
            }
        }
    }

    public static void processSimAction(int n, MapObject mapObject, int n2, int n3) {
        StateInGame.resetPlayerInactivity();
        if (StateInGame.getPlayerSim().isIdle()) {
            StateInGame.startPlayerAction(n, mapObject, n2, n3);
        } else {
            int n4 = m_actionQueueSize == 3 ? 2 : m_actionQueueSize++;
            StateInGame.m_actionQueueActions[n4] = n;
            StateInGame.m_actionQueueArg1s[n4] = mapObject;
            StateInGame.m_actionQueueArg2s[n4] = n2;
            StateInGame.m_actionQueueArg3s[n4] = n3;
        }
    }

    public static void startPlayerAction(int n, MapObject mapObject, int n2, int n3) {
        MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
        mapObjectSim.beginSimAction(n, mapObject, n2, n3);
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        for (int i = 0; i < mapObjectSimArray.length; ++i) {
            MapObjectSim mapObjectSim2 = mapObjectSimArray[i];
            if (mapObjectSim2 != null && mapObjectSim2.equals(mapObjectSim)) continue;
            mapObjectSim2.playerAction(mapObject);
        }
    }

    public static void cancelSimAction() {
        StateInGame.resetPlayerInactivity();
        m_playerSim.setOccupied(null);
        if (m_actionQueueSize > 0) {
            StateInGame.m_actionQueueArg1s[--StateInGame.m_actionQueueSize] = null;
            if (m_actionQueueSize == 0) {
                StateInGame.getPlayerSim().interrupt();
            }
        }
    }

    public static void processCancelAction(MapObject mapObject) {
        StateInGame.resetPlayerInactivity();
        if (mapObject != null) {
            m_playerSim.setOccupied(null);
        }
        if (mapObject != null && m_actionQueueSize > 0) {
            int n = ArrayHandler.indexOf(mapObject, m_actionQueueArg1s);
            if (n == 0) {
                StateInGame.getPlayerSim().interrupt();
            } else if (n > 0) {
                --m_actionQueueSize;
                for (int i = n; i < m_actionQueueSize; ++i) {
                    StateInGame.m_actionQueueActions[i] = m_actionQueueActions[i + 1];
                    StateInGame.m_actionQueueArg1s[i] = m_actionQueueArg1s[i + 1];
                    StateInGame.m_actionQueueArg2s[i] = m_actionQueueArg2s[i + 1];
                    StateInGame.m_actionQueueArg3s[i] = m_actionQueueArg3s[i + 1];
                }
                StateInGame.m_actionQueueArg1s[StateInGame.m_actionQueueSize] = null;
            }
        }
    }

    public static void processCallAction() {
        int n = m_contextMenuItems[2] + 5;
        short s = m_contextMenuActions[n];
        short s2 = m_contextMenuItems[n];
        if (s2 == 275 || s2 == 274) {
            m_contextMenuBackCursor = m_contextMenuItems[2];
            m_contextMenuOnSubMenu = true;
            Main.m_simData.createCallContextMenu(m_contextMenuItems, m_contextMenuActions, s);
            StateInGame.m_contextMenuItems[4] = m_maxContextMenuItems;
            if (m_contextMenuItems[0] == 0) {
                StateInGame.hideMenus();
                StateInGame.showMessageBox(665, 664);
            }
        } else {
            StateInGame.hideMenus();
            int n2 = Main.m_simData.getSimByName(s2);
            StateInGame.processSimAction(s, Cursor.m_cursorObject, n2, 0);
        }
    }

    public static void finishCallAction(int n, int n2) {
        if (n == 109) {
            if (StateInGame.findSim(n2) != null) {
                StateInGame.showMessageBox(666, 275);
            } else if (StateInGame.nextAvailableBank() != -1 && Main.m_simData.acceptInvitation(n2)) {
                MapObject mapObject = StateInGame.findRandomObjectByType(4);
                Debug.ASSERT(mapObject != null, "no town object!");
                MapObjectSim mapObjectSim = (MapObjectSim)StateInGame.createObject(1, mapObject.getPosX(), mapObject.getPosZ(), mapObject.getFacingDir(), n2);
                mapObjectSim.setNeedFlag(32);
                StateInGame.showMessageBox(667, 275);
                Main.m_simData.dreamCompleteEvent(25);
            } else {
                StateInGame.showMessageBox(668, 275);
            }
        } else if (n == 108) {
            if (StateInGame.findSim(n2) != null) {
                StateInGame.showMessageBox(666, 274);
            } else {
                int n3 = Main.m_simData.getRelState(n2);
                if ((Main.m_simData.getRelStateFlags(n3) & 0x10) != 0) {
                    Main.m_simData.adjustMotiveLevel(4, 983040);
                }
            }
        }
    }

    public static void processCookAction() {
        int n = m_contextMenuItems[2] + 5;
        short s = m_contextMenuActions[n];
        short s2 = m_contextMenuItems[n];
        if (s2 == 266) {
            m_contextMenuBackCursor = m_contextMenuItems[2];
            m_contextMenuOnSubMenu = true;
            Main.m_simData.createCookContextMenu(m_contextMenuItems, m_contextMenuActions, s);
            StateInGame.m_contextMenuItems[4] = m_maxContextMenuItems;
            if (m_contextMenuItems[0] == 0) {
                StateInGame.hideMenus();
                StateInGame.showMessageBox(677, 676);
            }
        } else {
            StateInGame.hideMenus();
            int n2 = Main.m_simWorld.getRecipeByName(s2);
            StateInGame.processSimAction(s, Cursor.m_cursorObject, n2, 0);
        }
    }

    public static void updateSimData(int n) {
        int n2;
        if (m_timeHit != 0) {
            Main.m_simData.update(m_timeHit * 1000, false);
            m_timeHit = 0;
        } else {
            n2 = n;
            if (Main.m_simData.getFastforward()) {
                n2 <<= 4;
            }
            Main.m_simData.update(n2, true);
        }
        n2 = Main.m_simData.getMoodLevel();
        m_displayedMoodLevel = Debug.UserInterface_interpolateValue(m_displayedMoodLevel, n2, n, 8);
        if (!StateInGame.getPlayerSim().isWorking()) {
            int n3 = Main.m_simData.getTimeFlags(0);
            if ((n3 & 1) != 0 && !StateInGame.isShowingTickerMessage()) {
                StateInGame.showTickerMessage(539, -1);
            } else if ((n3 & 2) != 0 && !StateInGame.isShowingTickerMessage()) {
                StateInGame.showTickerMessage(540, -1);
            }
        } else {
            StateInGame.cancelWorkMessages();
        }
    }

    public static void cancelWorkMessages() {
        StateInGame.cancelTickerMessage(540);
        StateInGame.cancelTickerMessage(539);
    }

    public static void checkGameTimeTriggers(int n, int n2) {
        if (!StateInGame.getPlayerSim().isWorking() && Main.m_simData.getSimCareer(0) != -1) {
            for (int i = n; i < n2; ++i) {
                int n3 = Main.m_simData.getTimeFlags(0, i);
                int n4 = Main.m_simData.getTimeFlags(0, i + 1);
                if ((n3 & 2) == 0) continue;
                if ((n4 & 4) == 0) continue;
                Main.m_simData.careerDayMissed();
                StateInGame.cancelWorkMessages();
                MapObjectSim mapObjectSim = StateInGame.getPlayerSim();
                int n5 = mapObjectSim.m_simActionPrev;
                if (Main.m_simData.getSimCareer(0) == -1) {
                    StateInGame.showMessageBox(544, 543, 2);
                    break;
                }
                StateInGame.showMessageBox(542, 541, 2);
                break;
            }
        }
    }

    public static void renderPlayerGem(int n, int n2) {
        if (m_state != 19) {
            m_playerGemAnimPlayer.drawAnim(n, n2);
        }
    }

    public static void renderBuffs() {
        int n = m_viewportX;
        int n2 = n + 8;
        int n3 = 245 - m_hudBottomHeight;
        if (m_tickerString1 != -1) {
            n3 -= AnimationManager.getAnimFrameHeight(302, 0);
        }
        int n4 = 0;
        while (true) {
            if (n4 >= 6) break;
            int n5 = Main.m_simData.getBuff(n4);
            if (n5 != -1) {
                int n6 = Main.m_simData.getBuffDescString(n5);
                int n7 = Main.m_simData.getBuffFlags(n5);
                int n8 = GameConstants.TextHandler_getStringWidth(n6, 1);
                AnimationManager.setColor(76);
                Debug.PMGraphics_fillRect(n, n3 - 12, n8 + n2 - n + 2, 12);
                AnimPlayer animPlayer = (n7 & 1) == 0 ? m_buffDroppingAnimPlayer : m_buffRisingAnimPlayer;
                animPlayer.drawAnim(n, n3 + -1);
                GameConstants.TextHandler_drawString(n6, 1, n2, n3 - 1, 36);
                n3 -= 12;
            }
            ++n4;
        }
    }

    public static void openShop(MapObject mapObject) {
        m_shoppingObjectType = mapObject.getType();
        m_shoppingTradeAmount = 0;
        StateInGame.stateTransition(17);
        StateInGame.stateTransitionShopping(0);
    }

    public static void stateTransitionShopping(int n) {
        m_shoppingState = n;
        switch (n) {
            default: {
                break;
            }
            case 0: {
                StateInGame.initListShopping();
                break;
            }
            case 1: {
                StateInGame.stateTransition(5);
            }
        }
        StateInGame.setupSoftkeys();
    }

    public static void renderShopping() {
        switch (m_shoppingState) {
            default: {
                break;
            }
            case 0: {
                StateInGame.renderShoppingBrowseMenu();
            }
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void renderShoppingBrowseMenu() {
        int n = Main.m_simWorld.getItemNthItem(m_shoppingObjectType, Debug.UserInterface_getListCursor());
        Debug.UserInterface_setUIPlaceholderString(1, Main.m_simWorld.getObjectStringId(m_shoppingObjectType));
        int n2 = Main.m_simWorld.getItemBuyPrice(n);
        if (n2 > 0) {
            SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
            GameConstants.TextHandler_appendMoneyToBuffer(n2);
            GameConstants.TextHandler_dynamicString(-9, sDKString);
            Debug.UserInterface_setUIPlaceholderString(2, -9);
        } else {
            Debug.UserInterface_setUIPlaceholderString(2, 612);
        }
        int n3 = Main.m_simWorld.getItemSellPrice(n);
        if (n3 > 0) {
            SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
            GameConstants.TextHandler_appendMoneyToBuffer(n3);
            GameConstants.TextHandler_dynamicString(-8, sDKString);
            Debug.UserInterface_setUIPlaceholderString(3, -8);
        } else {
            Debug.UserInterface_setUIPlaceholderString(3, 612);
        }
        int n4 = m_shoppingTradeAmount >= 0 ? m_shoppingTradeAmount * n2 : -m_shoppingTradeAmount * n3;
        SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendIntToBuffer(Main.m_simData.getInventoryCount(n));
        GameConstants.TextHandler_appendStringIdToBuffer(8);
        GameConstants.TextHandler_appendIntToBuffer(Main.m_simWorld.getItemMaxInventory(n));
        GameConstants.TextHandler_dynamicString(-7, sDKString);
        Debug.UserInterface_setUIPlaceholderString(4, -7);
        sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendIntToBuffer(m_shoppingTradeAmount);
        GameConstants.TextHandler_dynamicString(-6, sDKString);
        Debug.UserInterface_setUIPlaceholderString(5, -6);
        sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendMoneyToBuffer(n4);
        GameConstants.TextHandler_dynamicString(-5, sDKString);
        Debug.UserInterface_setUIPlaceholderString(6, -5);
        Debug.UserInterface_drawUIFullScreen(22);
    }

    public static void initListShopping() {
        Debug.UserInterface_initList(Main.m_simWorld.getItemNthCount(m_shoppingObjectType), 18, 0);
    }

    public static void processKeysShopping() {
        switch (m_shoppingState) {
            default: {
                break;
            }
            case 0: {
                if (Main.softPressNeg()) {
                    StateInGame.stateTransitionShopping(1);
                    return;
                }
                if (Debug.UserInterface_processKeysList()) {
                    StateInGame.setShoppingTradeAmount(0);
                    break;
                }
                if ((AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) && m_shoppingTradeAmount != 0) {
                    int n = Main.m_simWorld.getItemNthItem(m_shoppingObjectType, Debug.UserInterface_getListCursor());
                    int n2 = m_shoppingTradeAmount * (m_shoppingTradeAmount > 0 ? Main.m_simWorld.getItemBuyPrice(n) : Main.m_simWorld.getItemSellPrice(n));
                    Main.m_simData.adjustInventory(n, m_shoppingTradeAmount);
                    if (m_shoppingTradeAmount > 0) {
                        int n3 = 15360;
                        if ((Main.m_simWorld.getItemFlags(n) & 0x80) != 0) {
                            Main.m_simData.dreamCompleteEvent(22);
                        }
                    }
                    Main.m_simData.adjustMoney(-n2, false);
                    StateInGame.setShoppingTradeAmount(0);
                    break;
                }
                if (AnimationManager.PMInput_isPressed(8)) {
                    StateInGame.setShoppingTradeAmount(m_shoppingTradeAmount - 1);
                }
                if (!AnimationManager.PMInput_isPressed(16)) break;
                StateInGame.setShoppingTradeAmount(m_shoppingTradeAmount + 1);
            }
        }
    }

    public static void setShoppingTradeAmount(int n) {
        int n2 = Main.m_simWorld.getItemNthItem(m_shoppingObjectType, Debug.UserInterface_getListCursor());
        int n3 = Main.m_simData.getMoney();
        int n4 = Main.m_simWorld.getItemBuyPrice(n2);
        int n5 = Main.m_simWorld.getItemSellPrice(n2);
        int n6 = n4 <= 0 ? 0 : Math.min(Math.min(Main.m_simWorld.getItemMaxInventory(n2) - Main.m_simData.getInventoryCount(n2), n3 / n4), Main.m_simWorld.getItemMaxInventory(n2));
        int n7 = n5 <= 0 ? 0 : -Main.m_simData.getInventoryCount(n2);
        m_shoppingTradeAmount = IStringConstants.MathExt_clip(n, n7, n6);
        StateInGame.setupSoftkeys();
    }

    public static void update() {
        GlobalConstants.StateMenu_page = -1;
        GlobalConstants.StateMenu_lastPageElementY = 0;
        GlobalConstants.StateMenu_lastPageElementH = 0;
        GlobalConstants.StateMenu_skillsPageDrawn = false;
        AnimationManager.Touch_clear();
        long l = ArrayOptimizer.PMTimer_tick();
        timeInterval = (int)(l - timeStamp);
        timeStamp = l;
        if (timeInterval > 150) {
            timeInterval = 150;
        }
        ArrayHandler.PostEffects_update(timeInterval);
        StateInGame.processKeys();
        Main.updateSoftKeys(timeInterval);
        StateInGame.updateStep(timeInterval);
        StateInGame.render();
        IStringConstants.PMSystem_nextFrame();
    }

    static {
        m_tempInt10 = new int[10];
        m_mapMode = 0;
        m_mapModePrev = 0;
        m_palSources = new int[32];
        m_palPatches = new int[32];
        lastVisitorTime = 0;
        currentVisitorChance = 0;
        AMBIENT_SOUNDS_MM = new short[0];
        AMBIENT_SOUNDS_BEIJING = new short[0];
        AMBIENT_SOUNDS_CAIRO = new short[0];
        AMBIENT_SOUNDS_PARIS = new short[0];
        AMBIENT_SOUNDS_SANFRAN = new short[0];
        m_isCursorOnMove = false;
    }
}

