/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.IStringConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.SimWorld;
import dk.progressivemedia.skeleton.state.StateInGame;

public class MapObjectSim
extends MapObject {
    private int m_appearance;
    private int m_subAppearance;
    private int m_appearanceBank;
    private int m_simState;
    private int m_simStateTime;
    private int m_posture;
    private int m_targetPosture;
    private MapObject m_postureObject;
    private int m_simAction;
    private int m_simActionPhaseIndex;
    private int m_simPhase;
    private MapObject m_simActionArg1;
    private int m_simActionArg2;
    private int m_simActionArg3;
    public int m_simActionPrev;
    private int m_queuedSimAction;
    private MapObject m_queuedSimActionArg1;
    private int m_queuedSimActionArg2;
    private int m_queuedSimActionArg3;
    private int m_needFlags;
    private int m_needCheckTimer;
    private MapObject m_occupiedObject;
    private int m_occupiedIndex;
    private int m_walkDestXF;
    private int m_walkDestZF;
    private int[] m_walkPath;
    private int m_walkPathLength;
    private int m_walkPathPoint;
    private boolean m_walkStopShort;
    private int m_checkPosXF;
    private int m_checkPosZF;
    private int m_conversationSim;
    private int m_conversationTimer;
    private int m_lastConversationTimer;
    private int m_feedbackSubAppearance;
    private boolean m_feedbackLoop;
    private boolean m_feedbackRealTime;
    private int m_feedbackTime;
    private int m_feedbackFloaterAnimId;
    private boolean m_feedbackAnimateFloater;
    private int m_feedbackSpeechBubbleAnimId;
    private int[] m_speakMale = new int[0];
    private int[] m_speakFemale = new int[0];
    private int callOverDirectionDir = -551;
    private int[] GENERIC_NEEDS = new int[]{4, 2, 8, 16, 64};

    public MapObjectSim() {
        this.isMapObject = false;
    }

    public final void init(int n, int n2, int n3, int n4, int n5) {
        super.init(n, n2, n3, n4, n5);
        this.m_simState = 0;
        this.m_posture = 0;
        this.m_targetPosture = 0;
        this.m_postureObject = null;
        this.m_simAction = 0;
        this.m_simPhase = 0;
        this.m_simActionArg1 = null;
        this.m_queuedSimAction = -1;
        this.m_queuedSimActionArg1 = null;
        this.m_occupiedObject = null;
        this.m_occupiedIndex = -1;
        this.m_walkDestXF = this.getPosX();
        this.m_walkDestZF = this.getPosZ();
        this.m_walkPath = new int[256];
        this.m_conversationSim = -1;
        this.m_lastConversationTimer = -1;
        this.m_feedbackSubAppearance = -1;
        this.m_feedbackLoop = true;
        this.m_feedbackAnimateFloater = false;
        this.m_feedbackSpeechBubbleAnimId = -1;
        this.getAnimPlayerCreate(2);
        this.getAnimPlayerCreate(1);
        this.m_appearance = -1;
        this.m_subAppearance = 0;
        if (StateInGame.isMapMode()) {
            this.m_appearanceBank = Main.m_simData.getSimMacromapColor(n5);
            this.setAppearance(2);
        } else {
            if (Main.m_simData.getSimAttribute(n5, 0) == 0) {
                this.setAppearance(0);
            } else {
                this.setAppearance(1);
            }
            this.m_appearanceBank = -1;
        }
        if (n5 == 0) {
            int n6 = 0;
            while (true) {
                if (n6 >= 6) break;
                if (Main.m_simData.getBuff(n6) != -1) {
                    this.startBuff(Main.m_simData.getBuff(n6));
                }
                ++n6;
            }
        }
        this.simStateTransition(1);
    }

    public final void update(int n) {
        if (this.m_simStateTime < 3000000) {
            this.m_simStateTime += n;
        }
        if (this.m_conversationSim != -1) {
            this.m_conversationTimer += n;
            if (this.m_conversationTimer > 20000) {
                Event.PMDebug_println("conversation timed out");
                this.clearConversation();
            }
        } else if (this.m_lastConversationTimer >= 0) {
            this.m_lastConversationTimer += n;
            if (this.m_lastConversationTimer > 20000) {
                this.m_lastConversationTimer = -1;
            }
        }
        switch (this.m_simState) {
            case 1: {
                this.simUpdateIdle(n);
                break;
            }
            case 2: {
                this.simUpdateChangePosture(n);
                break;
            }
            case 3: {
                this.simUpdateWalking(n);
                break;
            }
            case 4: {
                this.simUpdateFeedback(n);
                break;
            }
            case 5: {
                this.simUpdateGetAttention(n);
                break;
            }
            case 6: {
                this.simUpdateGetOccupied(n);
                break;
            }
            case 7: {
                this.simUpdateListen(n);
                break;
            }
            case 8: {
                this.simUpdateHide(n);
                break;
            }
        }
    }

    public final void render2D() {
        if (this.m_simState == 8 || this.m_appearanceBank == -1) {
            return;
        }
        SimWorld simWorld = Main.m_simWorld;
        int n = simWorld.getCameraPixelX();
        int n2 = simWorld.getCameraPixelY();
        int n3 = n + simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
        int n4 = n2 + simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ());
        AnimPlayer animPlayer = null;
        if (this.m_subAppearance != 45) {
            if (!(StateInGame.isMapMode() || Event.isShowingEvent() || this.m_targetPosture != 0 && this.m_targetPosture != 6)) {
                AnimationManager.drawAnimFrame(39, 0, n3, n4);
            }
            AnimationManager.setBank(this.m_appearanceBank);
            animPlayer = this.getAnimPlayer(0);
            if (!StateInGame.isMapMode()) {
                int n5 = animPlayer.getAnimID();
                int n6 = animPlayer.getCurrAnimFrame();
                this.drawSimAnim(n5, n6, n3, n4);
            } else {
                animPlayer.drawAnim(n3, n4);
                if (this.getId() == 0) {
                    StateInGame.renderPlayerGem(n3, n4 - 16);
                }
            }
            if (this.getSimActionArg1Sim() != null && this.getSimActionArg1Sim().getPostureObject() == null) {
                this.getSimActionArg1Sim().render2DPost();
            }
            AnimationManager.setBank(0);
        }
        AnimPlayer animPlayer2 = this.getAnimPlayer(2);
        if (this.m_feedbackTime > 0 && animPlayer2.isAnimating()) {
            int[] nArray = MapObject.s_tempInt10;
            int n7 = this.m_feedbackAnimateFloater ? IStringConstants.MathExt_smoothstepF(1000, 2000, this.m_feedbackTime) : 65536;
            int n8 = n7 * 10;
            int n9 = n3;
            int n10 = n4 + (n8 >> 16) - 60 - 10;
            AnimationManager.drawAnim(animPlayer2, n9, n10);
            if (this.m_simPhase == 5) {
                animPlayer2.getFirePointCurrFrame(nArray, 0);
                AnimationManager.drawAnimFrame(this.m_feedbackSpeechBubbleAnimId, 0, n9 + nArray[0], n10 + nArray[1]);
            }
        }
    }

    public final void render2DPost() {
        int n;
        int n2 = Main.m_simWorld.getSubAppearanceAnimSet(this.m_appearance, this.m_subAppearance, true);
        if (n2 != 0 && (n = Main.m_simWorld.getAnim(n2, this.getFacingDir())) != 87) {
            int n3 = Main.m_simWorld.getCameraPixelX();
            int n4 = Main.m_simWorld.getCameraPixelY();
            int n5 = n3;
            int n6 = n4;
            int n7 = this.getAnimPlayer(0).getCurrAnimFrame();
            AnimationManager.setBank(this.m_appearanceBank);
            this.drawSimAnim(n, n7, n5 += Main.m_simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ()), n6 += Main.m_simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ()));
            AnimationManager.setBank(0);
        }
    }

    public void drawSimAnim(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = this.m_appearance == 0 ? 198 : 181;
        int n6 = Main.m_simData.getSimAttribute(this.getId(), 2) + 1;
        int[] nArray = null;
        boolean bl2 = bl = this.getId() == 0;
        if (bl) {
            nArray = MapObject.s_tempInt10;
        }
        boolean bl3 = AnimationManager.drawAnimFrameExt(n, n2, n3, n4, n5, n6, nArray);
        if (bl && bl3) {
            StateInGame.renderPlayerGem(nArray[0], nArray[1]);
        }
    }

    public final int getTooltipStringId() {
        return Main.m_simData.getSimName(this.getId());
    }

    private final void setAppearance(int n) {
        if (this.m_appearance != n) {
            this.m_appearance = n;
            int n2 = this.m_subAppearance;
            this.m_subAppearance = -1;
            this.setSubAppearance(n2);
        }
    }

    public final void setSubAppearance(int n) {
        boolean bl = this.getFacingDir() == 0 || this.getFacingDir() == 1;
        if (this.m_subAppearance != (n = Main.m_simWorld.mapSubAppearance(n, bl))) {
            this.m_subAppearance = n;
            int n2 = Main.m_simWorld.getSubAppearanceAnimSet(this.m_appearance, n, false);
            this.setAnimSet(n2);
        }
    }

    public final void setBank(int n) {
        this.m_appearanceBank = n;
    }

    public final int getBank() {
        return this.m_appearanceBank;
    }

    private final void simStateTransition(int n) {
        if (n == 1 && this.m_simState == 4 && this.m_posture == 2 && this.getId() == 0 && this.callOverDirectionDir != -551) {
            this.setFacingDir(this.callOverDirectionDir);
        }
        switch (this.m_simState) {
            default: {
                break;
            }
            case 3: {
                this.callOverDirectionDir = -551;
                if (n == 3 || !StateInGame.isMapMode()) break;
                this.setAppearance(2);
                if (StateInGame.getCameraFollow() == null || !StateInGame.getCameraFollow().equals(this)) break;
                StateInGame.setCameraFollow(null);
                break;
            }
            case 2: {
                if (this.m_postureObject == null || this.m_posture != 0) break;
                this.m_postureObject.releasePostRenderTarget(this);
                this.m_postureObject = null;
            }
        }
        this.setRuntimeFlag(128);
        int n2 = this.m_simState;
        this.m_simState = n;
        this.m_simStateTime = 0;
        int n3 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1: {
                n3 = this.m_posture == 4 ? 15 : (this.m_posture == 5 ? 49 : (this.m_posture == 1 ? 19 : (this.m_posture == 2 ? 19 : (this.m_posture == 3 ? 23 : (this.m_posture == 6 ? 38 : (this.m_posture == 7 ? 31 : 0))))));
                this.setSubAppearance(n3);
                break;
            }
            case 2: {
                int n4 = this.m_posture;
                MapObject mapObject = this.m_simActionArg1;
                switch (this.m_posture) {
                    default: {
                        Debug.ASSERT(false, "invalid current posture");
                    }
                    case 0: {
                        if (this.m_targetPosture == 7) {
                            n3 = 29;
                            n4 = 7;
                            this.m_postureObject = mapObject;
                            mapObject.phonePickup();
                            break;
                        }
                        if (this.m_targetPosture == 3) {
                            n3 = 22;
                            n4 = 3;
                            break;
                        }
                        if (this.m_targetPosture == 1 || this.m_targetPosture == 4 || this.m_targetPosture == 5) {
                            this.m_postureObject = mapObject;
                            mapObject.setPostRenderTarget(this);
                            n3 = 20;
                            n4 = 1;
                            break;
                        }
                        if (this.m_targetPosture == 6) {
                            n3 = 39;
                            n4 = 6;
                            break;
                        }
                        Debug.ASSERT(mapObject != null, "sitting without a chair");
                        mapObject.setPostRenderTarget(this);
                        this.m_postureObject = mapObject;
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = this.getFacingDir();
                        switch (this.getFacingDir()) {
                            default: {
                                Debug.ASSERT(false, "invalid sim facing");
                            }
                            case 0: {
                                n5 = 524288;
                                break;
                            }
                            case 1: {
                                n6 = 524288;
                                break;
                            }
                            case 2: {
                                n5 = -524288;
                                break;
                            }
                            case 3: {
                                n6 = -524288;
                            }
                        }
                        int n8 = mapObject.getFacingDir();
                        this.setFacingDir(n8);
                        int n9 = 0;
                        int n10 = 0;
                        switch (n8) {
                            default: {
                                Debug.ASSERT(false, "invalid chair facing");
                            }
                            case 0: {
                                n9 = -196608;
                                n5 += 131072;
                                break;
                            }
                            case 1: {
                                n10 = -196608;
                                n6 += 131072;
                                break;
                            }
                            case 2: {
                                n9 = 196608;
                                n5 -= 131072;
                                break;
                            }
                            case 3: {
                                n10 = 196608;
                                n6 -= 131072;
                            }
                        }
                        if (mapObject.chairShouldSnap()) {
                            mapObject.setPos(mapObject.getPosX() + n9, mapObject.getPosZ() + n10);
                            mapObject.setRuntimeFlag(131072);
                        } else {
                            n5 -= n9;
                            n6 -= n10;
                        }
                        this.setPos(this.getPosX() + n5, this.getPosZ() + n6);
                        n3 = 20;
                        n4 = 2;
                        break;
                    }
                    case 1: {
                        if (this.m_targetPosture == 0) {
                            n3 = 18;
                            n4 = 0;
                            break;
                        }
                        if (this.m_targetPosture == 4) {
                            n3 = 17;
                            n4 = 4;
                            break;
                        }
                        if (this.m_targetPosture != 5) break;
                        n3 = 48;
                        n4 = 5;
                        break;
                    }
                    case 2: {
                        n3 = 18;
                        n4 = 0;
                        break;
                    }
                    case 3: {
                        n3 = 25;
                        n4 = 0;
                        break;
                    }
                    case 4: {
                        n3 = 16;
                        n4 = 1;
                        break;
                    }
                    case 5: {
                        n3 = 50;
                        n4 = 1;
                        break;
                    }
                    case 6: {
                        n3 = 37;
                        n4 = 0;
                        break;
                    }
                    case 7: {
                        n3 = 30;
                        n4 = 0;
                        this.m_postureObject.phoneHangup();
                    }
                }
                Debug.ASSERT(n4 != this.m_posture, "invalid posture change");
                Debug.ASSERT(n3 != -1, "invalid posture transition appearance type");
                this.m_posture = n4;
                this.unsetRuntimeFlag(128);
                this.setSubAppearance(n3);
                break;
            }
            case 3: {
                Debug.ASSERT(this.m_posture == 0, "not standing but trying to walk!");
                this.setSubAppearance(1);
                if (this.getId() != 0 || !StateInGame.isMapMode()) break;
                if (!this.isInView() && n2 != 3) {
                    StateInGame.setCameraFollow(this);
                }
                StateInGame.playerMovingOnMapMode();
                break;
            }
            case 4: {
                if (this.m_feedbackFloaterAnimId != -1) {
                    this.getAnimPlayer(2).startAnim(this.m_feedbackFloaterAnimId, 20);
                    if (this.m_simPhase == 5) {
                        this.m_feedbackSpeechBubbleAnimId = Main.m_simData.getActionTalkIcon(this.m_simAction);
                    }
                } else {
                    this.getAnimPlayer(2).setAnimating(false);
                }
                if (this.m_feedbackSubAppearance == -1) {
                    this.m_feedbackSubAppearance = Main.m_simData.getActionWorldArg(this.m_simAction);
                }
                MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
                if (this.m_simAction == 51 || this.m_simAction == 52) {
                    if (Main.m_simData.actionAccept(this.getId(), mapObjectSim.getId(), this.m_simAction)) {
                        mapObjectSim.unsetRuntimeFlag(128);
                        mapObjectSim.setSubAppearance(33);
                        this.m_feedbackSubAppearance = 36;
                    } else {
                        mapObjectSim.unsetRuntimeFlag(128);
                        mapObjectSim.setSubAppearance(35);
                        this.m_feedbackSubAppearance = 34;
                    }
                } else if (this.m_simAction == 62) {
                    mapObjectSim.unsetRuntimeFlag(128);
                    mapObjectSim.setSubAppearance(27);
                } else if (this.m_simAction == 53) {
                    int n11 = mapObjectSim.getId();
                    if (Main.m_simData.actionAccept(this.getId(), n11, this.m_simAction)) {
                        Event.triggerEvent(3, -1, n11);
                    }
                }
                if (!this.m_feedbackLoop) {
                    this.unsetRuntimeFlag(128);
                }
                this.setSubAppearance(this.m_feedbackSubAppearance);
                break;
            }
            case 5: 
            case 6: {
                this.setSubAppearance(0);
                break;
            }
            case 7: {
                this.setFacingObject(this.m_simActionArg1);
                int n12 = 7;
                if (this.getSimActionArg1Sim() != null && (this.getSimActionArg1Sim().getSimAction() == 51 || this.getSimActionArg1Sim().getSimAction() == 52)) {
                    n12 = 0;
                }
                this.setSubAppearance(n12);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.destroy();
            }
        }
        if (this.m_simState == 1 && this.m_posture == 2 && this.getId() == 0) {
            this.callOverDirectionDir = this.getFacingDir();
        }
    }

    private final void simFeedback(int n, int n2, int n3, boolean bl, boolean bl2) {
        this.m_feedbackSubAppearance = n;
        this.m_feedbackLoop = n2 >= 0;
        this.m_feedbackTime = n2;
        this.m_feedbackFloaterAnimId = n3;
        this.m_feedbackAnimateFloater = bl;
        this.m_feedbackRealTime = bl2;
        this.simStateTransition(4);
    }

    private final void endFeedback() {
        this.m_feedbackSubAppearance = -1;
        this.m_feedbackLoop = false;
        this.m_feedbackTime = -1;
        this.m_feedbackFloaterAnimId = -1;
        this.m_feedbackAnimateFloater = false;
        this.m_feedbackRealTime = true;
    }

    private final void simHide(int n, boolean bl) {
        this.m_feedbackTime = n;
        this.m_feedbackRealTime = bl;
        this.simStateTransition(8);
    }

    private final void simUpdateIdle(int n) {
        MapObject mapObject;
        this.updateAnim(n);
        this.m_needCheckTimer += n;
        if (this.getType() == 0) {
            if (this.m_simStateTime > 3000 && Main.m_simData.buffGetActiveSlot(9) != -1) {
                this.beginSimAction(3, null);
                return;
            }
            if (this.m_simStateTime > 3500 && this.m_posture == 0) {
                int n2 = Main.m_simData.getMoodLevel();
                if (n2 > 0x4B0000) {
                    this.beginSimAction(5, null);
                    return;
                }
                if (n2 < -3276800) {
                    this.beginSimAction(6, null);
                    return;
                }
            }
        }
        if (this.m_posture == 1 && this.m_postureObject.getParentType() == 6 && (mapObject = StateInGame.findRandomObjectByParentType(18)) != null && mapObject.getRuntimeFlag(64) && this.m_simStateTime > 1000) {
            int n3 = 16;
            if (mapObject.getRuntimeFlag(32768)) {
                n3 = 15;
            }
            this.beginSimAction(n3, null);
            return;
        }
        if (this.m_needCheckTimer > 2500 && this.occupiedIsEmpty()) {
            this.m_needCheckTimer = 0;
            this.checkNeeds();
        }
    }

    public MapObject getPostureObject() {
        return this.m_postureObject;
    }

    private final void simUpdateChangePosture(int n) {
        this.updateAnim(n);
        if (!this.isAnimating()) {
            if (this.m_posture == 0 && this.m_postureObject != null && this.m_postureObject.getParentType() == 5) {
                int n2 = 131072;
                int n3 = 0;
                int n4 = 0;
                switch (this.getFacingDir()) {
                    default: {
                        Debug.ASSERT(false, "invalid facing, getting off chair");
                    }
                    case 0: {
                        n3 = 1;
                        break;
                    }
                    case 1: {
                        n4 = 1;
                        break;
                    }
                    case 2: {
                        n3 = -1;
                        break;
                    }
                    case 3: {
                        n4 = -1;
                    }
                }
                MapObject mapObject = this.m_postureObject;
                if (mapObject.getRuntimeFlag(131072)) {
                    mapObject.unsetRuntimeFlag(131072);
                    mapObject.setPos(mapObject.getPosX() + n3 * 196608, mapObject.getPosZ() + n4 * 196608);
                } else {
                    n2 += 196608;
                }
                int n5 = 524288;
                int n6 = this.getPosX() + n4 * n5 + n3 * -n2;
                int n7 = this.getPosZ() + n3 * n5 + n4 * -n2;
                boolean bl = Main.m_simWorld.isWorldPointWalkable(n6, n7);
                int n8 = this.getPosX() + n4 * -n5 + n3 * -n2;
                int n9 = this.getPosZ() + n3 * -n5 + n4 * -n2;
                boolean bl2 = Main.m_simWorld.isWorldPointWalkable(n8, n9);
                boolean bl3 = StateInGame.isObjectAt(0, n8, n9);
                if (bl && (bl3 || !bl2)) {
                    this.setPos(n6, n7);
                } else {
                    this.setPos(n8, n9);
                }
            }
            if (this.m_posture == this.m_targetPosture) {
                this.endSimPhase();
            } else {
                this.simStateTransition(2);
            }
        }
    }

    private final void simUpdateWalking(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.getPosX();
        int n7 = this.getPosZ();
        int n8 = this.m_walkDestXF;
        int n9 = this.m_walkDestZF;
        int n10 = Main.m_simWorld.coordWorldToWorldTileX(n6);
        int n11 = Main.m_simWorld.coordWorldToWorldTileZ(n7);
        int n12 = Main.m_simWorld.getAttribute(n10, n11);
        int n13 = IStringConstants.MathExt_sign(n8 - n6);
        int n14 = n13 != 0 ? 0 : IStringConstants.MathExt_sign(n9 - n7);
        int n15 = 2048;
        int n16 = 1310;
        if (this.getRuntimeFlag(4096)) {
            n15 = 1638;
            n16 = 983;
        }
        if (StateInGame.isMapMode()) {
            n15 = n16;
            if (this.hasCar()) {
                n5 = Main.m_simWorld.coordWorldToWorldTileX(n6);
                n4 = Main.m_simWorld.coordWorldToWorldTileZ(n7);
                n3 = Main.m_simWorld.getAttribute(n5, n4);
                int n17 = n2 = (n3 & 0x20) != 0 ? 1 : 0;
                if (n2 != 0) {
                    int n18;
                    if (n14 == 0) {
                        n18 = Main.m_simWorld.coordWorldTileToWorldCenterX(n5);
                        n3 = n13 < 0 && n6 <= n18 || n13 > 0 && n6 >= n18 ? Main.m_simWorld.getAttribute(n5 + n13, n4) : Main.m_simWorld.getAttribute(n5 - n13, n4);
                    } else {
                        n18 = Main.m_simWorld.coordWorldTileToWorldCenterZ(n4);
                        n3 = n14 < 0 && n7 <= n18 || n14 > 0 && n7 >= n18 ? Main.m_simWorld.getAttribute(n5, n4 + n14) : Main.m_simWorld.getAttribute(n5, n4 - n14);
                    }
                    int n19 = n2 = (n3 & 0x20) != 0 ? 1 : 0;
                }
                if (n2 != 0) {
                    n15 = 3276;
                    this.setAppearance(3);
                } else {
                    this.setAppearance(2);
                }
            }
        }
        n5 = n15 * n;
        n7 += n14 * n5;
        if (n13 > 0 && (n6 += n13 * n5) > n8 || n13 < 0 && n6 < n8) {
            n6 = n8;
        }
        if (n14 > 0 && n7 > n9 || n14 < 0 && n7 < n9) {
            n7 = n9;
        }
        this.setFacingDir(n13, n14);
        this.setPos(n6, n7);
        if (!StateInGame.isMapMode()) {
            n4 = Main.m_simWorld.coordWorldToWorldTileX(n6);
            n3 = Main.m_simWorld.coordWorldToWorldTileZ(n7);
            n2 = Main.m_simWorld.getAttribute(n4, n3);
            if ((n12 & 0x20) == 0) {
                if ((n2 & 0x20) != 0) {
                    Event.PMDebug_println("opening door");
                    MapObject mapObject = StateInGame.findRandomObjectByParentType(7);
                    if (mapObject != null && !mapObject.getRuntimeFlag(64)) {
                        mapObject.respondToAction(116, this);
                    }
                }
            }
        }
        this.updateAnim(n);
        if (n6 == n8 && n7 == n9) {
            if (!this.occupiedIsEmpty() && this.getType() != 0) {
                this.failSimPhase(true);
            } else if (this.m_simActionArg1 != null && (this.m_simActionArg1.getPosX() != this.m_checkPosXF || this.m_simActionArg1.getPosZ() != this.m_checkPosZF)) {
                this.simWalkTo(this.m_simActionArg1, 0, 0);
            } else {
                n4 = !this.setOccupied(this.m_simActionArg1) ? 1 : 0;
                n2 = this.m_walkPathLength != -1 ? (this.m_walkPathLength >> 1) - this.m_walkPathPoint : -1;
                if (n2 > ((n3 = this.m_walkStopShort || n4 != 0 ? 1 : 0) != 0 ? 2 : 1)) {
                    if (this.m_simActionArg1 != null && ((n2 & 3) == 0 || n2 < 4)) {
                        if (n4 == 0) {
                            this.setOccupied(null);
                            this.setOccupied(this.m_simActionArg1);
                        }
                        this.simWalkTo(this.m_simActionArg1, 0, 0);
                    } else {
                        ++this.m_walkPathPoint;
                        this.m_walkDestXF = this.m_walkPath[(this.m_walkPathPoint << 1) + 0];
                        this.m_walkDestZF = this.m_walkPath[(this.m_walkPathPoint << 1) + 1];
                    }
                } else {
                    this.m_walkPathLength = -1;
                    if (n4 != 0) {
                        this.beginSimPhase(9);
                    } else {
                        if (this.getId() == 0 && this.m_simActionArg1 != null && (this.m_simActionArg1.getType() == 11 || this.m_simActionArg1.getType() == 9 || this.m_simActionArg1.getType() == 12)) {
                            if (!Main.m_simData.initMsgHasShownAtCounter && Main.m_simWorld.getHouseId() == 8) {
                                StateInGame.showMessageBox(831, 829);
                            } else if (Main.m_simData.timeArrivedInCairo != -1 && Main.m_simWorld.getHouseId() == 6) {
                                StateInGame.showMessageBox(835, 834);
                            }
                        }
                        this.endSimPhase();
                    }
                }
            }
        }
    }

    private final void simWalkTo(MapObject mapObject, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Object[] objectArray;
        int n7;
        boolean bl = false;
        boolean bl2 = false;
        int n8 = n;
        int n9 = n2;
        if (mapObject != null) {
            bl = false;
            bl2 = !this.setOccupied(mapObject);
            n7 = this.m_occupiedIndex;
            if (n7 == -1) {
                n7 = mapObject.getClosestInterestPoint(this.getPosX(), this.getPosZ(), false, null);
            }
            if (n7 == -1) {
                this.failSimPhase(false);
                return;
            }
            objectArray = MapObject.s_tempInt10;
            mapObject.getInterestPoint((int[])objectArray, n7);
            n8 = objectArray[0];
            n9 = objectArray[1];
            this.m_checkPosXF = mapObject.getPosX();
            this.m_checkPosZF = mapObject.getPosZ();
        }
        n8 = Main.m_simWorld.coordWorldTileToWorldCenterX(Main.m_simWorld.coordWorldToWorldTileX(n8));
        n9 = Main.m_simWorld.coordWorldTileToWorldCenterZ(Main.m_simWorld.coordWorldToWorldTileZ(n9));
        if ((n8 != this.getPosX() || n9 != this.getPosZ()) && this.m_posture != 0) {
            Event.PMDebug_println("not standing, so getting up");
            --this.m_simActionPhaseIndex;
            this.beginSimPhase(32);
            return;
        }
        if (StateInGame.isHouseMode() && this.getId() == 0 && Main.m_simWorld.getHouseId() != 0 && Main.m_simWorld.getHouseId() != 8 && Main.m_simWorld.getHouseId() != 7 && Main.m_simWorld.getHouseId() != 6 && Main.m_simWorld.getHouseId() != 4 && Main.m_simWorld.getHouseId() != 5 && this.m_simAction != 119 && !this.getRuntimeFlag(32)) {
            if (!Main.m_simData.getSimCurRelStateFlags(0, 1)) {
                Event.PMDebug_println("barging in check...");
                n7 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
                int n10 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
                n6 = Main.m_simWorld.coordWorldToWorldTileX(n8);
                n5 = Main.m_simWorld.coordWorldToWorldTileZ(n9);
                if ((Main.m_simWorld.getAttribute(n7, n10) & 0x10) == 0) {
                    if ((Main.m_simWorld.getAttribute(n6, n5) & 0x10) != 0) {
                        Event.PMDebug_println("barge-in override");
                        this.m_queuedSimAction = this.m_simAction;
                        this.m_queuedSimActionArg1 = this.m_simActionArg1;
                        this.m_queuedSimActionArg2 = this.m_simActionArg2;
                        this.m_queuedSimActionArg3 = this.m_simActionArg3;
                        this.setRuntimeFlag(16);
                        this.beginSimAction(119, StateInGame.findRandomObjectByParentType(7));
                        return;
                    }
                }
            }
        }
        this.unsetRuntimeFlag(32);
        n7 = 0;
        if (StateInGame.isMapMode()) {
            n7 = this.hasCar() ? 2 : 4;
        } else {
            n7 = 8;
            objectArray = StateInGame.getSimObjects();
            if (objectArray.length > 1) {
                Main.m_simWorld.pathClearAvoidTiles();
                for (n6 = 0; n6 < objectArray.length; ++n6) {
                    int n11 = objectArray[n6];
                    if (n11 == null || n11.equals(this)) continue;
                    n4 = Main.m_simWorld.coordWorldToWorldTileX(n11.getPosX());
                    n3 = Main.m_simWorld.coordWorldToWorldTileZ(n11.getPosZ());
                    Main.m_simWorld.pathAddAvoidTile(n4, n3);
                }
                n7 |= 1;
            }
        }
        int n12 = this.getPosX();
        n6 = this.getPosZ();
        this.m_walkPathLength = 0;
        this.m_walkPathLength = Main.m_simWorld.pathFind(n12, n6, n8, n9, n7, this.m_walkPath);
        if (!bl && bl2 && this.m_walkPathLength == 2) {
            Event.PMDebug_println("target busy, already there");
            this.beginSimPhase(9);
        } else if (bl && this.m_walkPathLength == 2) {
            Event.PMDebug_println("stop short, already there");
            this.endSimPhase();
        } else if (this.m_walkPathLength >= 2) {
            this.m_walkPathPoint = 0;
            this.m_walkStopShort = bl;
            this.m_walkDestXF = this.m_walkPath[(this.m_walkPathPoint << 1) + 0];
            this.m_walkDestZF = this.m_walkPath[(this.m_walkPathPoint << 1) + 1];
            this.simStateTransition(3);
        } else {
            n5 = n12 - n8;
            n4 = n6 - n9;
            n3 = Math.abs(n5) + Math.abs(n4);
            int n13 = 524288;
            if (n3 <= n13) {
                if (n3 != 0) {
                    Event.PMDebug_println("very close");
                    this.m_walkPathPoint = 0;
                    this.m_walkStopShort = bl;
                    this.m_walkDestXF = n8;
                    this.m_walkDestZF = n9;
                    this.simStateTransition(3);
                } else {
                    Event.PMDebug_println("already there");
                    this.endSimPhase();
                }
            } else {
                Event.PMDebug_println("too far/invalid path");
                this.failSimPhase(false);
            }
        }
    }

    public final int getFeedbackTime() {
        return this.m_feedbackTime;
    }

    private final void simUpdateFeedback(int n) {
        int n2;
        int n3 = this.getAnimPlayer(0).getCurrAnimFrame();
        this.updateAnim(n);
        int n4 = this.getAnimPlayer(0).getCurrAnimFrame();
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        if (n3 != n4) {
            if (this.m_simAction == 62 && n4 == 1 && (this.getId() == 0 || this.getSimActionArg1Sim() != null && this.getSimActionArg1Sim().getId() == 0)) {
                Intro.PMVibrate_vibrate(100);
            }
            int n5 = n2 = this.getFacingDir() == 0 || this.getFacingDir() == 1 ? 1 : 1;
            if (this.m_simAction == 52 && this.m_subAppearance == 36 && n4 == n2) {
                Event.triggerEvent(2, 682, this.getSimActionArg1().getId());
            }
            if (this.m_simAction == 4 && n4 == 1 && Main.randPercent() < 5) {
                StateInGame.killPlayer(695);
            }
        }
        this.getAnimPlayer(2).updateAnim(n);
        n2 = 0;
        if (this.m_feedbackLoop) {
            if (this.m_feedbackRealTime) {
                n2 = this.m_feedbackTime <= Main.m_simData.getGameTimeAbs() ? 1 : 0;
            } else {
                if (!IStringConstants.Minigame_inMiniGame()) {
                    this.m_feedbackTime -= n;
                }
                n2 = this.m_feedbackTime <= 0 ? 1 : 0;
            }
        } else {
            int n6 = n2 = !animPlayer.isAnimating() ? 1 : 0;
        }
        if (n2 != 0) {
            this.m_feedbackSubAppearance = -1;
            this.m_feedbackTime = -1;
            this.m_feedbackLoop = true;
            this.endSimPhase();
        } else {
            int n7 = 1000 << 2;
            if (this.getId() == 0 && this.m_simPhase == 23 && this.m_simStateTime > n7 && this.m_feedbackRealTime) {
                if (this.m_feedbackTime - Main.m_simData.getGameTimeAbs() > 60 && this.occupiedIsEmpty() && !StateInGame.isCurtainActive()) {
                    StateInGame.startCurtainIn();
                }
            }
        }
    }

    private final void simUpdateGetAttention(int n) {
        this.updateAnim(n);
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        if (this.m_simAction != 63) {
            int n2 = mapObjectSim.getPosX() - this.getPosX();
            int n3 = mapObjectSim.getPosZ() - this.getPosZ();
            int n4 = Math.abs(n2) + Math.abs(n3);
            int n5 = 524288;
            if (n4 > n5) {
                this.failSimPhase(false);
                return;
            }
        }
        if (this.m_simStateTime > 4000) {
            this.failSimPhase(false);
            return;
        }
        if (mapObjectSim.isIdle()) {
            mapObjectSim.beginSimAction(2, this);
            this.endSimPhase();
        }
    }

    private final void simUpdateGetOccupied(int n) {
        this.updateAnim(n);
        if (this.m_simStateTime > 4000) {
            this.failSimPhase(false);
            return;
        }
        if (this.setOccupied(this.m_simActionArg1)) {
            this.beginSimPhase(1);
        }
    }

    private final void simUpdateListen(int n) {
        this.updateAnim(n);
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        if (mapObjectSim == null || mapObjectSim.isIdle()) {
            this.endSimPhase();
        } else if (mapObjectSim != null && mapObjectSim.getRuntimeFlag(1024)) {
            if (Main.m_simData.hasSimGotTrait(this.getId(), 12) != -1) {
                if (!this.getRuntimeFlag(262144)) {
                    Main.m_simData.tryDiscoverTrait(this.getId(), 12);
                    this.setRuntimeFlag(262144);
                }
            } else {
                mapObjectSim.interrupt();
                this.clearConversation();
                int n2 = 0;
                if (Main.m_simData.hasSimGotTrait(this.getId(), 13) != -1) {
                    n2 = 0x20 | 2;
                    Main.m_simData.tryDiscoverTrait(this.getId(), 13);
                    Main.m_simData.adjustRelLevels(this.getId(), -1, -1);
                }
                this.beginSimAction(14, mapObjectSim, n2, 0);
            }
        }
    }

    private final void simUpdateHide(int n) {
        if (this.m_simAction == 133) {
            return;
        }
        if (this.m_feedbackRealTime) {
            if (this.m_feedbackTime <= Main.m_simData.getGameTimeAbs()) {
                this.endSimPhase();
            }
        } else if (this.m_feedbackTime > 0) {
            this.m_feedbackTime -= n;
            if (this.m_feedbackTime <= 0) {
                this.endSimPhase();
            }
        }
    }

    public final int getSimAction() {
        return this.m_simAction;
    }

    public final MapObject getSimActionArg1() {
        return this.m_simActionArg1;
    }

    public final MapObjectSim getSimActionArg1Sim() {
        if (this.m_simActionArg1 == null || this.m_simActionArg1.isMapObject) {
            return null;
        }
        return (MapObjectSim)this.m_simActionArg1;
    }

    public final boolean isIdle() {
        return (Main.m_simData.getActionFlags(this.m_simAction) & 2) != 0;
    }

    public final boolean isReady() {
        return this.isIdle() || this.m_simPhase == 8 || this.m_simPhase == 9 || this.m_simPhase == 1;
    }

    public final boolean isWorking() {
        return this.m_simPhase == 28;
    }

    public final boolean isSleeping() {
        return (this.m_simAction == 95 || this.m_simAction == 94) && this.m_posture == 4;
    }

    public final void queueSimAction(int n, MapObject mapObject, int n2, int n3) {
        if (this.isReady()) {
            this.beginSimAction(n, mapObject, n2, n3);
        } else {
            this.m_queuedSimAction = n;
            this.m_queuedSimActionArg1 = mapObject;
            this.m_queuedSimActionArg2 = n2;
            this.m_queuedSimActionArg3 = n3;
        }
    }

    public final void beginSimAction(int n, MapObject mapObject) {
        this.beginSimAction(n, mapObject, 0, 0);
    }

    public final void beginSimAction(int n, MapObject mapObject, int n2, int n3) {
        MapObjectSim mapObjectSim;
        if (this.m_simPhase != 0) {
            this.endSimPhase(true);
        }
        this.unsetRuntimeFlag(262146);
        if (n == 92 && this.m_appearance == 0 && Main.randPercent() < 50) {
            n = 93;
        }
        this.m_simAction = n;
        this.m_simActionArg1 = mapObject;
        this.m_simActionArg2 = n2;
        this.m_simActionArg3 = n3;
        if (mapObject == null && n != 76 || !this.setOccupied(mapObject)) {
            // empty if block
        }
        if ((mapObjectSim = this.getSimActionArg1Sim()) != null && (Main.m_simData.getActionFlags(n) & 1) != 0) {
            this.setConversation(mapObjectSim);
        }
        int n4 = Main.m_simData.getActionPhase(n, 0);
        this.m_simActionPhaseIndex = 0;
        this.beginSimPhase(n4);
    }

    public final void playerAction(MapObject mapObject) {
        if (mapObject != null && !mapObject.equals(this) && (this.m_needFlags & 0x20) != 0) {
            MapObjectSim mapObjectSim = StateInGame.getPlayerSim().getSimActionArg1Sim();
            if (this.m_conversationSim == 0 || mapObjectSim != null && this.m_conversationSim == mapObjectSim.getId()) {
                Event.PMDebug_println("abort talking");
                this.clearConversation();
            }
        }
    }

    public final boolean setOccupied(MapObject mapObject) {
        Debug.ASSERT(mapObject != null && !mapObject.equals(this), "attempting to get occupied flag on self");
        if (mapObject != null && mapObject.equals(this.m_occupiedObject)) {
            return true;
        }
        if (this.m_occupiedObject != null) {
            this.m_occupiedObject.occupiedRelease(this.m_occupiedIndex);
            this.m_occupiedObject = null;
            this.m_occupiedIndex = -1;
        }
        if (mapObject == null) {
            return true;
        }
        if (mapObject.occupiedIsAnyAvailable()) {
            int n = -1;
            if (mapObject.getParentType() == 7) {
                int n2 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
                int n3 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
                int n4 = Main.m_simWorld.getAttribute(n2, n3);
                n = (n4 & 0x10) != 0 ? 0 : 1;
            } else {
                n = mapObject.getClosestInterestPoint(this.getPosX(), this.getPosZ(), true, this);
            }
            if (n != -1 && mapObject.occupiedCapture(n, this)) {
                this.m_occupiedObject = mapObject;
                this.m_occupiedIndex = n;
                return true;
            }
        }
        return false;
    }

    public MapObject getOccupiedObject() {
        return this.m_occupiedObject;
    }

    private final void endSimAction() {
        boolean bl = this.getRuntimeFlag(4);
        this.unsetRuntimeFlag(12);
        this.m_simActionPrev = this.m_simAction;
        int n = this.m_simAction;
        MapObject mapObject = this.m_simActionArg1;
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        boolean bl2 = this.getId() == 0;
        this.beginSimAction(0, null);
        int n2 = Main.m_simData.getActionFlags(n);
        if (!bl && mapObjectSim != null && (n2 & 1) != 0) {
            this.setOccupied(null);
            mapObjectSim.setOccupied(null);
            boolean bl3 = mapObjectSim.respondToAction(n, this);
            if (bl3) {
                this.clearConversation();
            }
            if (bl2) {
                int n3 = mapObjectSim.getId();
                if (n == 62) {
                    Main.m_simData.setSimCurRelStateFlags(n3, 32);
                    Main.m_simData.numSlapped();
                } else if (n == 74) {
                    Main.m_simData.setSimCurRelStateFlags(n3, 256);
                }
            }
        } else if (!bl) {
            switch (n) {
                default: {
                    break;
                }
                case 121: {
                    switch (Main.getNextHouseId()) {
                        case 6: {
                            Main.setNextZoomMapId(58);
                            ++Main.m_simData.numVisitsCairo;
                            break;
                        }
                        case 7: {
                            Main.setNextZoomMapId(57);
                            ++Main.m_simData.numVisitsBeijing;
                            break;
                        }
                        case 4: {
                            Main.setNextZoomMapId(60);
                            ++Main.m_simData.numVisitsParis;
                            break;
                        }
                        case 5: {
                            Main.setNextZoomMapId(61);
                            ++Main.m_simData.numVisitsSanFran;
                            break;
                        }
                    }
                    Main.setupEncounter(null);
                    StateInGame.changeSceneWithFade(0, 100);
                    break;
                }
                case 122: {
                    switch (Main.getNextZoomMapId()) {
                        case 57: {
                            Main.setNextHouseId(7);
                            break;
                        }
                        case 58: {
                            Main.setNextHouseId(6);
                            break;
                        }
                        case 60: {
                            Main.setNextHouseId(4);
                            break;
                        }
                        case 61: {
                            Main.setNextHouseId(5);
                            break;
                        }
                    }
                    StateInGame.changeSceneWithFade(0, 5);
                    break;
                }
                case 135: {
                    StateInGame.hasJustFlownFlag = true;
                    if (Main.m_simData.timeArrivedInCairo == -1) {
                        Main.setNextHouseId(0);
                        StateInGame.changeSceneWithSavePrompt(0, -1);
                        break;
                    }
                    StateInGame.showMessageBox(839, 838, 8);
                    break;
                }
                case 123: 
                case 124: 
                case 134: {
                    StateInGame.gotoMapForObject(mapObject);
                    break;
                }
                case 77: {
                    StateInGame.gotoMap();
                    break;
                }
                case 112: {
                    StateInGame.showQuitJob();
                    break;
                }
                case 4: {
                    if (bl2) {
                        Main.m_simData.adjustMotiveLevel(3, -6553600);
                    }
                    if (StateInGame.isObjectAt(1, this.getPosX(), this.getPosZ())) break;
                    int n4 = -1;
                    if (Main.m_simWorld.getHouseId() == 0) {
                        n4 = Main.m_simWorld.objectBuy(7, this.getPosX(), this.getPosZ(), this.getFacingDir());
                    }
                    StateInGame.createObject(7, this.getPosX(), this.getPosZ(), this.getFacingDir(), n4);
                    break;
                }
                case 118: {
                    if (bl2) break;
                    this.m_simStateTime = 0;
                    StateInGame.showDoorKnock(this.getId());
                    break;
                }
                case 126: {
                    Main.m_simData.adjustMotiveLevel(0, 0x280000);
                    break;
                }
                case 94: 
                case 95: {
                    this.m_needFlags &= 0xFFFFFFFB;
                }
            }
        }
        if (n == 119) {
            this.unsetRuntimeFlag(16);
            if (bl) {
                this.m_queuedSimAction = -1;
                this.m_queuedSimActionArg1 = null;
            } else {
                this.setRuntimeFlag(32);
            }
        }
        if (mapObject != null && mapObjectSim == null && !bl) {
            mapObject.respondToAction(n, this);
            if (bl2) {
                Main.m_simData.setQuickLinkVisited(mapObject.getType());
            }
        }
        if (this.m_queuedSimAction != -1 && this.isIdle()) {
            this.beginSimAction(this.m_queuedSimAction, this.m_queuedSimActionArg1, this.m_queuedSimActionArg2, this.m_queuedSimActionArg3);
            this.m_queuedSimAction = -1;
            this.m_queuedSimActionArg1 = null;
        }
    }

    public final boolean respondToAction(int n, MapObjectSim mapObjectSim) {
        int n2 = mapObjectSim.getId();
        int n3 = this.getId();
        int[] nArray = MapObject.s_tempInt10;
        Main.m_simData.relationshipAction(nArray, n2, n3, n);
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[2];
        if ((n4 & 0x40) != 0) {
            StateInGame.advertiseEvent(23, mapObjectSim, this);
        }
        if (n == 72 || n == 67) {
            this.beginSimAction(0, null);
            this.setNeedFlag(256);
        } else if (n5 != -1) {
            if ((Main.m_simData.getActionFlags(n5) & 1) == 0 && n5 != 76) {
                mapObjectSim = null;
            }
            if (n2 == 0 && n5 == 13 && Main.m_simData.hasSimGotFlag(n3, 8)) {
                Main.m_simData.dreamCompleteEvent(11);
            }
            this.beginSimAction(n5, mapObjectSim, n4, 0);
            if (n6 != -1) {
                StateInGame.createEffectAnim(this.getPosX(), this.getPosZ(), n6, 0);
            }
        }
        return (n4 & 0x20) != 0;
    }

    public final boolean respondToEvent(int n, MapObjectSim mapObjectSim, MapObject mapObject) {
        int n2;
        if (this.isSleeping()) {
            return false;
        }
        if (n == 23 && (n2 = Main.m_simData.getSimPartner(this.getId())) != mapObject.getId()) {
            return false;
        }
        int[] nArray = MapObject.s_tempInt10;
        Main.m_simData.relationshipAction(nArray, mapObjectSim.getId(), this.getId(), n);
        int n3 = nArray[1];
        if (n3 != -1) {
            int n4 = nArray[0];
            MapObject mapObject2 = (n4 & 0x2000) != 0 ? mapObject : mapObjectSim;
            this.interrupt();
            this.queueSimAction(n3, mapObject2, 0, 0);
            this.setRuntimeFlag(8);
            return true;
        }
        return false;
    }

    private final void beginSimPhase(int n) {
        boolean bl;
        this.m_simPhase = n;
        int n2 = this.m_simAction;
        MapObject mapObject = this.m_simActionArg1;
        MapObjectSim mapObjectSim = this.getSimActionArg1Sim();
        int n3 = this.m_simActionArg2;
        int n4 = this.m_simActionArg3;
        boolean bl2 = bl = this.getId() == 0;
        if (bl && mapObjectSim != null) {
            Main.m_simData.setLastNPC(mapObjectSim.getId());
        }
        boolean bl3 = false;
        switch (n) {
            case 53: {
                if (Main.m_simData.initMsgHasShownAtCounter) break;
                Main.m_simData.initMsgHasShownAtCounter = true;
                StateInGame.showMessageBox(833, 832, 5);
                break;
            }
            case 0: {
                if (this.m_posture == 7 || this.m_posture == 6) {
                    --this.m_simActionPhaseIndex;
                    this.beginSimPhase(32);
                    break;
                }
                this.simStateTransition(1);
                break;
            }
            case 1: {
                this.simWalkTo(mapObject, n3, n4);
                break;
            }
            case 2: 
            case 3: {
                if (mapObject != null) {
                    this.setFacingObject(mapObject);
                } else {
                    this.setFacingDir(n3 - this.getPosX(), n4 - this.getPosZ());
                }
                if (n == 3) {
                    this.setFacingDir(this.getFacingDir() + 2 & 3);
                }
                this.endSimPhase();
                break;
            }
            case 4: {
                this.setFacingDir(mapObject.getFacingDir());
                this.endSimPhase();
                break;
            }
            case 8: {
                this.simStateTransition(5);
                break;
            }
            case 9: {
                this.simStateTransition(6);
                break;
            }
            case 10: {
                this.getSimActionArg1Sim().interrupt();
                this.endSimPhase();
                break;
            }
            case 11: {
                this.simStateTransition(7);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.performPhaseFeedback(n2, n);
                bl3 = true;
                break;
            }
            case 24: {
                mapObject.turnOn();
                this.endSimPhase();
                bl3 = true;
                break;
            }
            case 25: {
                mapObject.turnOff();
                this.endSimPhase();
                bl3 = true;
                break;
            }
            case 26: {
                MapObject mapObject2 = StateInGame.findRandomObjectByParentType(6);
                if (mapObject2 != null) {
                    int n5 = Main.m_simWorld.coordWorldToWorldTileX(mapObject.getPosX());
                    int n6 = Main.m_simWorld.coordWorldToWorldTileZ(mapObject.getPosZ());
                    int n7 = Main.m_simWorld.coordWorldToWorldTileX(mapObject2.getPosX());
                    int n8 = Main.m_simWorld.coordWorldToWorldTileZ(mapObject2.getPosZ());
                    int n9 = Main.m_simWorld.getAttribute(n5, n6) & 0xF;
                    int n10 = Main.m_simWorld.getAttribute(n7, n8) & 0xF;
                    int n11 = Math.abs(mapObject2.getFacingDir() - mapObject.getFacingDir());
                    if (n9 == n10 && n11 != 0) {
                        this.beginSimAction(113, mapObject2, 0, 0);
                    } else {
                        this.beginSimAction(76, mapObject, 0, 0);
                    }
                } else {
                    this.beginSimAction(76, mapObject, 0, 0);
                }
                bl3 = true;
                break;
            }
            case 27: {
                MapObject mapObject3 = StateInGame.findRandomNeedObject(128);
                if (mapObject3 != null) {
                    this.m_simActionArg1 = mapObject3;
                    this.endSimPhase();
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 17: {
                this.simFeedback(4, 7500, -1, false, false);
                Main.m_simData.setFastforward(true);
                break;
            }
            case 18: {
                this.simFeedback(4, 7500, -1, false, false);
                Main.m_simData.setFastforward(true);
                break;
            }
            case 16: {
                if (bl && Main.m_simData.startRecipe(n3) && mapObject.getParentType() == 15) {
                    mapObject.stoveStart();
                    this.simFeedback(4, 7500, -1, false, false);
                    Main.m_simData.setFastforward(true);
                    break;
                }
                this.failSimPhase(false);
                break;
            }
            case 51: {
                int n12 = Main.m_simWorld.cookingSchoolIsMoreRecipesAvailable();
                if (n12 < 0) {
                    StateInGame.showMessageBox(952, 948);
                    this.endSimAction();
                    break;
                }
                if (Main.m_simData.getMoney() > n12) {
                    StateInGame.stateTransition(21);
                    break;
                }
                StateInGame.showMessageBox(950, 948);
                this.endSimAction();
                break;
            }
            case 52: {
                this.simFeedback(4, 7500, -1, false, false);
                Main.m_simData.setFastforward(true);
                break;
            }
            case 14: {
                if (n2 == 80) {
                    IStringConstants.Minigame_beginMiniGame(3, mapObject);
                } else {
                    IStringConstants.Minigame_beginMiniGame(4, mapObject);
                }
                Main.m_simWorld.isLocationMinigameAvailable = true;
                break;
            }
            case 13: {
                if (Main.m_simWorld.isLocationMinigameAvailable) {
                    IStringConstants.Minigame_beginMiniGame(0, mapObject);
                    break;
                }
                StateInGame.showMessageBox(656, 470);
                this.endSimPhase();
                break;
            }
            case 12: {
                if (Main.m_simWorld.isLocationMinigameAvailable) {
                    IStringConstants.Minigame_beginMiniGame(1, mapObject);
                    break;
                }
                StateInGame.showMessageBox(657, 477);
                this.endSimPhase();
                break;
            }
            case 15: {
                if (Main.m_simWorld.isLocationMinigameAvailable) {
                    IStringConstants.Minigame_beginMiniGame(2, mapObject);
                    break;
                }
                StateInGame.showMessageBox(658, 484);
                this.endSimPhase();
                break;
            }
            case 19: {
                int n13;
                int n14 = 5000;
                if (bl) {
                    n13 = 458752;
                    if (n2 == 99) {
                        n13 = Main.m_simWorld.getRecipeReplenishes(n3);
                    }
                    Main.m_simData.setMotiveAdjust(0, n13);
                    Main.m_simData.setFastforward(true);
                }
                if (mapObject.getParentType() == 10) {
                    mapObject.fridgeOpen();
                    n14 = 7000;
                }
                n13 = 4;
                if (this.m_posture == 2 || this.m_posture == 1) {
                    n13 = 55;
                }
                this.simFeedback(n13, n14, -1, false, false);
                bl3 = true;
                break;
            }
            case 20: {
                int n15 = mapObject.getParentType();
                if (n15 == 13) {
                    if (bl) {
                        Main.m_simData.setMotiveAdjust(3, 655360);
                        Main.m_simData.setFastforward(true);
                    }
                    mapObject.showerStart();
                    this.simHide(15000, false);
                    bl3 = true;
                    break;
                }
                if (n15 == 2) {
                    if (bl && !this.getRuntimeFlag(1024)) {
                        Main.m_simData.setMotiveAdjust(3, 655360);
                        Main.m_simData.setFastforward(true);
                    }
                    mapObject.basinStart();
                    this.simFeedback(4, 8000, -1, false, false);
                    break;
                }
                Debug.ASSERT(false, "what are we washing at?!");
                break;
            }
            case 50: {
                if (mapObject.getType() == 51 || mapObject.getType() == 50) {
                    this.simFeedback(12, 3700, -1, false, false);
                } else if (mapObject.getType() == 49) {
                    this.simFeedback(12, 7800, -1, false, false);
                } else if (mapObject.getType() == 45) {
                    this.simFeedback(35, 1700, -1, false, false);
                } else if (mapObject.getType() == 57) {
                    this.simFeedback(-4, 2270, -1, false, false);
                } else if (mapObject.getType() == 42) {
                    this.simFeedback(52, 3000, -1, false, false);
                } else if (mapObject.getType() == 52 || mapObject.getType() == 53) {
                    this.simFeedback(5, 1120, -1, false, false);
                } else if (mapObject.getType() == 54 || mapObject.getType() == 55) {
                    this.simFeedback(5, 1520, -1, false, false);
                }
                mapObject.interactStart();
                break;
            }
            case 21: {
                if (bl) {
                    Main.m_simData.setMotiveAdjust(2, 0x320000);
                    Main.m_simData.setFastforward(true);
                }
                int n16 = n2 == 92 ? 23 : 24;
                this.simFeedback(n16, 2000, -1, false, false);
                break;
            }
            case 22: 
            case 23: {
                this.performPhaseSleep(n);
                bl3 = true;
                break;
            }
            case 30: {
                Debug.ASSERT(bl, "NPC looking for work!");
                int n17 = Main.m_simData.getJobSearchCareerFromObject(mapObject);
                int n18 = Main.m_simData.getJobSearchLevel(n17);
                StateInGame.showJobOffer(n17, n18, true);
                this.endSimPhase();
                break;
            }
            case 28: {
                if (bl) {
                    this.simStateTransition(8);
                    StateInGame.startCurtainIn();
                    break;
                }
                MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
                if (mapObjectSimArray.length == 2 && Main.m_simWorld.getHouseId() == Main.m_simData.getSimHome(this.getId()) && !Main.m_simData.isWelcome()) {
                    StateInGame.kickPlayer(671, Main.m_simData.getSimName(this.getId()));
                }
                Event.PMDebug_println(2, "Sim with id = {0} is leaving for work!", this.getId());
                this.simStateTransition(9);
                break;
            }
            case 29: {
                StateInGame.finishCallAction(n2, n3);
                this.endSimPhase();
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.performPhasePosture(n);
                break;
            }
            case 31: {
                if (StateInGame.isHouseMode() && Main.getNextHouseId() == Main.m_simData.getSimHome(this.getId()) && Main.m_simWorld.getHouseId() != 0) {
                    StateInGame.kickPlayer(670, 669);
                }
                this.endSimPhase();
                break;
            }
            case 41: {
                if (bl) {
                    this.performPhaseCheckMoney();
                    break;
                }
                this.endSimPhase();
                break;
            }
            case 42: {
                if (bl) {
                    this.performPhaseCheckLock();
                    break;
                }
                this.endSimPhase();
                break;
            }
            case 43: {
                if (bl) {
                    this.performPhaseCheckHappy();
                    break;
                }
                this.endSimPhase();
                break;
            }
            case 44: {
                StateInGame.openShop(mapObject);
                this.endSimPhase();
                break;
            }
            case 49: {
                if (ArrayHandler.Tour_init(n2)) break;
                this.failSimPhase(false);
                break;
            }
        }
        if (bl && bl3 && (Main.m_simData.getActionFlags(n2) & 0x100000) != 0) {
            StateInGame.advertiseEvent(20, this, this.m_simActionArg1);
        }
        if (this.getRuntimeFlag(2)) {
            this.failSimPhase(true);
        }
    }

    private void performPhaseFeedback(int n, int n2) {
        int n3;
        MapObject mapObject;
        if (n == 118 && (mapObject = StateInGame.findRandomObjectByParentType(7)) != null && mapObject.getRuntimeFlag(64)) {
            this.endSimPhase();
            return;
        }
        int n4 = -1;
        int n5 = -1;
        if (n2 == 5 && this.getId() == 0) {
            int n6 = n5 = this.getFacingDir() == 3 || this.getFacingDir() == 0 ? 296 : 297;
            if (Main.m_simData.getSimAttribute(this.getId(), 0) == 1) {
                if (this.m_speakFemale != null && this.m_speakFemale.length > 0) {
                    PMAudio.play(this.m_speakFemale[Main.rand(0, this.m_speakFemale.length - 1)], 1);
                }
            } else if (this.m_speakMale != null && this.m_speakMale.length > 0) {
                PMAudio.play(this.m_speakMale[Main.rand(0, this.m_speakMale.length - 1)], 1);
            }
        }
        boolean bl = false;
        if (n != 108 && n != 109 && this.m_simActionArg2 != 0) {
            n5 = Main.responseToFeedbackAnim(this.m_simActionArg2);
            bl = true;
        }
        int n7 = n3 = n2 == 7 ? -1 : 2000;
        if (n == 17) {
            n3 = 5000;
        }
        this.simFeedback(n4, n3, n5, bl, false);
        if (this.getId() == 0) {
            if (n == 15 || n == 16) {
                Main.m_simData.setMotiveAdjust(5, 196608);
            } else if (n == 17) {
                Main.m_simData.setMotiveAdjust(5, 196608);
            }
        }
    }

    private void performPhaseSleep(int n) {
        int n2 = Main.m_simData.getGameTimeAbs();
        int n3 = Main.m_simData.getWakeupTime(this.getId());
        if (n == 22) {
            n3 = Math.min(n3, n2 + 120);
        }
        int n4 = n3 - n2;
        if (this.getId() == 0) {
            Main.m_simData.setFastforward(true);
            Main.m_simData.setMotiveAdjust(1, 65536);
        }
        this.stopSecondaryAnim();
        this.setEffectAnimId(this.getFacingDir() == 0 ? 41 : 40);
        this.simFeedback(15, n2 + n4, -1, false, true);
    }

    private void performPhasePosture(int n) {
        int n2;
        if (n == 33) {
            Debug.ASSERT(this.m_simActionArg1 != null, "can't auto-sit without a chair");
            if (this.m_simActionArg1.getParentType() == 5) {
                n = 35;
            } else {
                this.setFacingDir(this.getFacingDir() + 2 & 3);
                n = 34;
            }
        }
        int n3 = n == 32 ? 0 : (n == 34 ? 1 : (n == 35 ? 2 : (n == 36 ? 3 : (n == 39 ? 6 : (n == 37 ? 4 : (n2 = n == 38 ? 5 : 7))))));
        if (this.m_posture == n2) {
            if (n2 == 2) {
                boolean bl = true;
            }
            this.endSimPhase();
        } else {
            this.m_targetPosture = n2;
            this.simStateTransition(2);
        }
    }

    private void performPhaseCheckMoney() {
        int n = Main.m_simData.getCostForAction(this.m_simAction);
        int n2 = Main.m_simData.getMoney();
        if (n2 >= n) {
            Main.m_simData.adjustMoney(-n, false);
            StateInGame.createEffectMoney(this.getPosX(), this.getPosZ(), n);
            this.endSimPhase();
        } else {
            this.failSimPhase(false);
        }
    }

    private void performPhaseCheckLock() {
        boolean bl = true;
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        if (mapObjectSimArray.length > 1) {
            bl = false;
        } else if (Main.m_simData.isWelcome()) {
            bl = false;
        }
        if (bl) {
            this.failSimPhase(false);
        } else {
            this.endSimPhase();
        }
    }

    private void performPhaseCheckHappy() {
        if (Main.m_simData.buffGetActiveSlot(11) != -1 || Main.m_simData.buffGetActiveSlot(10) != -1) {
            int n = 7;
            if (Main.randPercent() < 50) {
                n = 14;
            }
            this.beginSimAction(n, this.m_simActionArg1);
        } else {
            this.endSimPhase();
        }
    }

    public final void endSimPhase() {
        this.endSimPhase(false);
    }

    private final void endSimPhase(boolean bl) {
        int n;
        int n2 = Main.m_simWorld.getHouseId();
        int n3 = Main.m_simData.getActionPhaseCount(this.m_simAction);
        boolean bl2 = this.getId() == 0;
        MapObject mapObject = this.m_simActionArg1;
        switch (this.m_simPhase) {
            case 28: {
                break;
            }
            case 19: {
                if (bl2) {
                    Main.m_simData.setMotiveAdjust(0, 0);
                    Main.m_simData.setFastforward(false);
                }
                if (mapObject == null || mapObject.getParentType() != 10) break;
                mapObject.fridgeClose();
                break;
            }
            case 16: {
                if (bl || mapObject.getParentType() != 15) break;
                mapObject.stoveEnd();
                IStringConstants.Minigame_increaseSkill(0);
                Main.m_simData.setFastforward(false);
                if (this.m_simActionArg2 != 8) break;
                Main.m_simData.dreamCompleteEvent(28);
                break;
            }
            case 52: {
                if (!StateInGame.courseBought) break;
                Main.m_simData.setFastforward(false);
                StateInGame.showMessageBox(951, 948);
                Main.m_simWorld.cookingSchoolGiveNextRecipe();
                IStringConstants.Minigame_increaseSkill(0);
                Main.m_simData.dreamCompleteEvent(12);
                StateInGame.courseBought = false;
                break;
            }
            case 17: {
                mapObject.cleanObject();
                Main.m_simData.setFastforward(false);
                break;
            }
            case 18: {
                mapObject.repairObject();
                Main.m_simData.setFastforward(false);
                break;
            }
            case 22: 
            case 23: {
                if (bl2) {
                    Main.m_simData.setMotiveAdjust(1, 0);
                    Main.m_simData.setFastforward(false);
                    if (this.m_simPhase == 23 && n2 != 0) {
                        Main.m_simData.setHouseCurRelStateFlags(n2, mapObject.bedGetRelStateFlags());
                    }
                    if (this.m_simPhase == 22) {
                        if (StateInGame.isZoomMapMode() && Main.getNextZoomMapId() == 58) {
                            Main.m_simData.dreamCompleteEvent(8);
                        } else if (StateInGame.isHouseMode() && Main.isAirport(Main.getNextHouseId())) {
                            Main.m_simData.dreamCompleteEvent(9);
                        }
                    }
                }
                this.setEffectAnimId(-1);
                this.recheckBuffEffects();
                break;
            }
            case 20: {
                if (bl2) {
                    Main.m_simData.setMotiveAdjust(3, 0);
                    Main.m_simData.setFastforward(false);
                }
                if (mapObject == null) break;
                n = mapObject.getParentType();
                if (n == 13) {
                    mapObject.showerEnd();
                    if (!bl2 || n2 == 0) break;
                    Main.m_simData.setHouseCurRelStateFlags(n2, 8);
                    break;
                }
                if (n != 2) break;
                mapObject.basinEnd();
                break;
            }
            case 50: {
                if (bl2) {
                    Main.m_simData.setMotiveAdjust(5, 0x140000);
                }
                if (mapObject.getType() == 51 || mapObject.getType() == 50) {
                    Main.m_simData.dreamCompleteEvent(17);
                } else if (mapObject.getType() == 45) {
                    Main.m_simData.dreamCompleteEvent(18);
                } else if (mapObject.getType() == 57) {
                    Main.m_simData.dreamCompleteEvent(19);
                } else if (mapObject.getType() == 42) {
                    Main.m_simData.dreamCompleteEvent(21);
                } else if (mapObject.getType() == 52 || mapObject.getType() == 53 || mapObject.getType() == 54 || mapObject.getType() == 55) {
                    Main.m_simData.dreamCompleteEvent(20);
                }
                mapObject.interactEnd();
                break;
            }
            case 21: {
                if (!bl2) break;
                Main.m_simData.setMotiveAdjust(2, 0);
                if (Main.isAirport(n2)) {
                    Main.m_simData.dreamCompleteEvent(10);
                } else if (n2 != 0) {
                    // empty if block
                }
                Main.m_simData.setFastforward(false);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.endFeedback();
                if (!bl2 || this.m_simAction != 15 && this.m_simAction != 16 && this.m_simAction != 17) break;
                Main.m_simData.setMotiveAdjust(5, 0);
                break;
            }
        }
        if (!bl) {
            if (this.m_simActionPhaseIndex < n3 - 1) {
                ++this.m_simActionPhaseIndex;
                n = Main.m_simData.getActionPhase(this.m_simAction, this.m_simActionPhaseIndex);
                this.beginSimPhase(n);
            } else {
                this.endSimAction();
            }
        }
    }

    public final void interrupt() {
        Event.PMDebug_println("interrupt");
        int n = Main.m_simData.getActionFlags(this.m_simAction);
        if ((n & 1) != 0 && (n & 0x80000) == 0 && this.getSimActionArg1Sim() != null && this.getSimActionArg1Sim().getId() != this.getId()) {
            this.getSimActionArg1Sim().interrupt();
        }
        this.setRuntimeFlag(2);
        this.failSimPhase(true);
    }

    private final void failSimPhase(boolean bl) {
        Main.m_simData.setFastforward(false);
        this.setRuntimeFlag(4);
        int n = -1;
        int n2 = 239;
        switch (this.m_simPhase) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 44: {
                break;
            }
            case 1: {
                n = 244;
                break;
            }
            case 27: {
                n = 267;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 30: {
                this.endSimPhase(true);
                this.endSimAction();
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                this.endSimPhase();
                break;
            }
            case 16: {
                n = 675;
                n2 = Main.m_simWorld.getRecipeDesc(this.m_simActionArg2);
                break;
            }
            case 41: 
            case 49: {
                n = 265;
                break;
            }
            case 42: {
                n = 288;
                break;
            }
            case 43: {
                n = 804;
                break;
            }
        }
        if (n != -1) {
            if (!bl && this.getId() == 0) {
                StateInGame.showMessageBox(n, n2);
            }
            this.endSimAction();
        }
    }

    private final void checkNeeds() {
        int n = this.m_needFlags;
        if ((n & 0x101) != 0) {
            Event.PMDebug_println(2, "Sim with id = {0} is going to work!", this.getId());
            MapObject mapObject = StateInGame.findRandomObjectByType(4);
            if (mapObject == null) {
                mapObject = StateInGame.findRandomObjectByType(17);
            }
            this.beginSimAction(133, mapObject);
            return;
        }
        if (StateInGame.getContextMenuObject() != null && (StateInGame.getContextMenuObject().equals(this) || this.getType() == 0)) {
            return;
        }
        if (this.m_lastConversationTimer == -1 && (this.m_needFlags & 0x20) != 0 && (this.getId() != 0 || Main.getAutonomityEnabled() && StateInGame.isPlayerInactive()) && (this.getId() == 0 || (this.m_needFlags & 4) == 0) && this.checkNeedChat()) {
            return;
        }
        if ((n & 0x5E) != 0) {
            int n2 = Main.rand(0, this.GENERIC_NEEDS.length - 1);
            if ((n & 4) != 0) {
                n2 = ArrayHandler.indexOf(4, this.GENERIC_NEEDS);
            }
            for (int i = 0; i < this.GENERIC_NEEDS.length; ++i) {
                MapObject mapObject;
                int n3 = this.GENERIC_NEEDS[n2];
                if ((n & n3) != 0 && (mapObject = StateInGame.findRandomNeedObject(n3)) != null) {
                    SimWorld simWorld = Main.m_simWorld;
                    int n4 = mapObject.getType();
                    int n5 = simWorld.getObjectFirstAction(n4);
                    this.beginSimAction(n5, mapObject);
                    int n6 = simWorld.getObjectNeed(n4);
                    this.m_needFlags &= ~n6;
                    return;
                }
                n2 = (n2 + 1) % this.GENERIC_NEEDS.length;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean checkNeedChat() {
        MapObjectSim mapObjectSim;
        block12: {
            int n;
            mapObjectSim = null;
            if (this.m_conversationSim != -1 && !this.checkNeedChatSim(mapObjectSim = StateInGame.findSim(this.m_conversationSim))) {
                mapObjectSim = null;
            }
            if (Main.m_simData.getSimHome(n = this.getId()) != Main.m_simWorld.getHouseId() && !Main.isAirport(Main.m_simWorld.getHouseId())) {
                if (!Main.m_simData.getSimCurRelStateFlags(n, 1) && (n != 0 || Main.getAutonomityEnabled())) {
                    if ((this.m_needFlags & 0x200) == 0) {
                        MapObject mapObject = StateInGame.findRandomObjectByParentType(7);
                        if (mapObject != null) {
                            this.beginSimAction(118, mapObject);
                            Event.PMDebug_println("knocking on door");
                            this.m_needFlags |= 0x200;
                            return true;
                        }
                        break block12;
                    } else {
                        if (n != 0) {
                            if (this.m_simStateTime <= 30000) return true;
                            Event.PMDebug_println("leaving...");
                            this.m_needFlags |= 0x100;
                            return true;
                        }
                        this.m_needFlags &= 0xFFFFFDFF;
                        return true;
                    }
                }
            }
            this.m_needFlags &= 0xFFFFFDFF;
        }
        if (mapObjectSim == null) {
            MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
            int n = mapObjectSimArray.length;
            int n2 = Main.rand(0, n - 1);
            for (int i = 0; i < n; ++i) {
                MapObjectSim mapObjectSim2 = mapObjectSimArray[n2];
                n2 = (n2 + 1) % mapObjectSimArray.length;
                if (!this.checkNeedChatSim(mapObjectSim2)) {
                    continue;
                }
                mapObjectSim = mapObjectSim2;
                break;
            }
        }
        if (mapObjectSim == null) return false;
        int n = Main.randPercent();
        if (n < 30) {
            this.beginSimAction(31, mapObjectSim);
            return true;
        }
        if (n < 70) {
            this.beginSimAction(59, mapObjectSim);
            return true;
        }
        this.beginSimAction(45, mapObjectSim);
        return true;
    }

    private final boolean checkNeedChatSim(MapObjectSim mapObjectSim) {
        if (mapObjectSim != null && mapObjectSim.equals(this) || mapObjectSim == null) {
            return false;
        }
        MapObject mapObject = StateInGame.getContextMenuObject();
        if (mapObjectSim != null && mapObjectSim.equals(mapObject)) {
            return false;
        }
        if (mapObjectSim.getId() == 0 && mapObject != null) {
            return false;
        }
        if (mapObjectSim.isSleeping()) {
            return false;
        }
        if (mapObjectSim.m_conversationSim != -1 && mapObjectSim.m_conversationSim != this.getId()) {
            return false;
        }
        if (mapObjectSim.getRuntimeFlag(8)) {
            return false;
        }
        return !mapObjectSim.getRuntimeFlag(1024) || Main.m_simData.hasSimGotTrait(this.getId(), 12) != -1;
    }

    public final void clearNeedFlags() {
        this.m_needFlags = 0;
    }

    public final void setNeedFlag(int n) {
        this.m_needFlags |= n;
    }

    public final void startBuff(int n) {
        switch (n) {
            default: {
                break;
            }
            case 8: {
                this.setRuntimeFlag(1024);
                if (StateInGame.isMapMode()) break;
                this.setEffectAnimId(48);
                this.setSecondaryAnim(45, 20);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.setRuntimeFlag(4096);
            }
        }
    }

    public final void endBuff(int n) {
        switch (n) {
            default: {
                break;
            }
            case 8: {
                this.unsetRuntimeFlag(1024);
                if (StateInGame.isMapMode()) break;
                this.setEffectAnimId(-1);
                this.stopSecondaryAnim();
                break;
            }
            case 4: 
            case 5: {
                this.unsetRuntimeFlag(4096);
            }
        }
    }

    private void recheckBuffEffects() {
        if (this.getRuntimeFlag(1024)) {
            this.startBuff(8);
        }
    }

    public final void setConversation(MapObjectSim mapObjectSim) {
        this.m_conversationSim = mapObjectSim.getId();
        this.m_lastConversationTimer = -1;
        this.setNeedFlag(32);
        mapObjectSim.m_conversationSim = this.getId();
        mapObjectSim.m_lastConversationTimer = -1;
        mapObjectSim.setNeedFlag(32);
    }

    private final void clearConversation() {
        MapObjectSim mapObjectSim = StateInGame.findSim(this.m_conversationSim);
        if (mapObjectSim != null) {
            mapObjectSim.m_needFlags &= 0xFFFFFFDF;
            mapObjectSim.m_conversationSim = -1;
            mapObjectSim.m_conversationTimer = 0;
            mapObjectSim.m_lastConversationTimer = 0;
        }
        this.m_needFlags &= 0xFFFFFFDF;
        this.m_conversationSim = -1;
        this.m_conversationTimer = 0;
        this.m_lastConversationTimer = 0;
    }

    private final boolean hasCar() {
        int n = Main.m_simData.getSimCareer(this.getId());
        if (n != -1) {
            boolean bl;
            int n2 = Main.m_simData.getSimCareerLevel(this.getId());
            boolean bl2 = bl = (Main.m_simData.getCareerLevelFlags(n, n2) & 1) != 0;
            if (bl) {
                return true;
            }
        }
        if (this.getType() == 0 && Main.m_simData.getInventoryCount(24) != 0) {
            return true;
        }
        return Main.m_simData.hasSimGotFlag(this.getId(), 1);
    }

    public void gotoSleep(MapObject mapObject) {
        Debug.ASSERT(mapObject != null, "can't sleep on null");
        boolean bl = this.setOccupied(mapObject);
        Debug.ASSERT(bl, "couldn't get occupied flag for bed");
        int[] nArray = MapObject.s_tempInt10;
        mapObject.getInterestPoint(nArray, this.m_occupiedIndex);
        this.setPos(nArray[0], nArray[1]);
        this.setFacingObject(mapObject);
        this.setFacingDir((this.getFacingDir() + 2) % 4);
        this.m_posture = 4;
        this.m_targetPosture = 4;
        this.m_postureObject = mapObject;
        mapObject.setPostRenderTarget(this);
        if (this.getId() == 0) {
            StateInGame.snapCameraAndCursor(mapObject);
        }
        this.beginSimAction(95, mapObject);
    }
}

