/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.IStringConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.state.StateInGame;

public class GlobalConstants {
    public static int StateMenu_page = -1;
    public static int StateMenu_lastPageElementY;
    public static int StateMenu_lastPageElementH;
    public static boolean StateMenu_skillsPageDrawn;
    public static int StateMenu_m_sharedMenuState;
    public static short[] StateMenu_m_optionsMenu;
    public static short[] StateMenu_m_inGameOptionsMenu;
    public static short[] StateMenu_m_helpMenu;
    public static short[] StateMenu_m_sharedMenu;
    public static int StateMenu_m_sharedMenuBackState;
    public static short StateMenu_m_maxMenuItemsPerScreen;
    public static int StateMenu_m_state;
    public static int StateMenu_m_afterFadeState;
    public static int StateMenu_m_nextSceneState;
    public static int StateMenu_m_initialState;
    public static short[] StateMenu_m_mainMenu;
    public static int StateMenu_m_mainMenuLast;
    public static long StateMenu_timeStamp;
    public static int StateMenu_timeInterval;
    public static int[] StateMenu_m_tempInt4;
    public static int[] StateMenu_helpMenuText;
    public static int[] StateMenu_helpMenuTitle;
    public static int StateMenu_m_loadingState;
    public static short[] StateMenu_m_languageMenu;
    public static SDKString[] StateMenu_m_languageMenuStrings;
    public static AnimPlayer StateMenu_m_casAnimPlayer;
    public static int StateMenu_m_casHairAnim;
    public static final short[] StateMenu_BUTTON_STRINGS;
    public static int[] StateMenu_m_palSources;
    public static int[] StateMenu_m_palPatches;
    public static AnimPlayer StateMenu_m_casUpArrow;
    public static AnimPlayer StateMenu_m_casDownArrow;
    public static int StateMenu_m_casButtonIndex;
    public static int StateMenu_m_casButtonsOffsetF;
    public static int StateMenu_m_casButtonsOffsetTargetF;
    public static int StateMenu_m_casAttribute;
    public static int StateMenu_m_casAttributePatch;
    public static int StateMenu_m_casColorsOffsetF;
    public static int StateMenu_m_casColorsOffsetTargetF;
    public static int StateMenu_m_casAttributesButtonsAnim;
    public static int StateMenu_m_casAttributesAnimHi;
    public static int StateMenu_m_casAttributesAnimLo;
    public static int StateMenu_m_casAttributeIndex;
    public static int StateMenu_m_casAttributeIndexMin;
    public static int StateMenu_m_casAttributeIndexMax;
    public static boolean StateMenu_m_casArms;
    public static boolean StateMenu_m_casLegs;
    public static boolean StateMenu_m_casHairAcc;
    public static final int[] StateMenu_GRAD_CAS_LIST;
    public static final int[] StateMenu_GRAD_CAS_SKY;
    public static final int[] StateMenu_GRAD_CAS_GROUND;
    public static final char[] StateMenu_SELECT_LETTERS;
    public static boolean StateMenu_m_isCharSelected;
    public static int StateMenu_m_cursorPosition;
    public static int StateMenu_m_charSelectedTime;
    public static int StateMenu_m_lastKeyPressed;
    public static int StateMenu_m_charIndex;
    public static SDKString StateMenu_casNameString;
    public static long PMRandom_seed;

    public static void StateMenu_init(int n) {
        StateMenu_m_casUpArrow = new AnimPlayer();
        StateMenu_m_casDownArrow = new AnimPlayer();
        StateMenu_m_casAnimPlayer = new AnimPlayer();
        StateMenu_m_casAnimPlayer.setAnimating(false);
        StateMenu_timeStamp = ArrayOptimizer.PMTimer_tick();
        GlobalConstants.StateMenu_start(n);
        StateInGame.m_timeAnimPlayer = null;
    }

    public static void StateMenu_update() {
        StateMenu_page = -1;
        StateMenu_lastPageElementY = 0;
        StateMenu_lastPageElementH = 0;
        StateMenu_skillsPageDrawn = false;
        AnimationManager.Touch_clear();
        long l = ArrayOptimizer.PMTimer_tick();
        StateMenu_timeInterval = (int)(l - StateMenu_timeStamp);
        StateMenu_timeStamp = l;
        if (StateMenu_timeInterval > 150) {
            StateMenu_timeInterval = 150;
        }
        ArrayHandler.PostEffects_update(StateMenu_timeInterval);
        GlobalConstants.StateMenu_processKeys();
        Main.updateSoftKeys(StateMenu_timeInterval);
        GlobalConstants.StateMenu_updateStep(StateMenu_timeInterval);
        GlobalConstants.StateMenu_render();
        IStringConstants.PMSystem_nextFrame();
    }

    public static void StateMenu_render() {
        if (StateMenu_m_sharedMenuState != -1) {
            if (StateMenu_m_sharedMenuState == 6) {
                if (StateMenu_m_state == 4) {
                    Intro.drawClear(77);
                } else {
                    Intro.drawBG();
                }
                GlobalConstants.StateMenu_renderLanguageMenu();
            } else {
                Intro.drawBG();
                GlobalConstants.StateMenu_renderSharedMenu();
                Main.renderSoftkeyBar();
            }
            return;
        }
        switch (StateMenu_m_state) {
            default: {
                break;
            }
            case 1: {
                Event.LoadingScreen_draw(false);
                break;
            }
            case 4: {
                Intro.drawClear(77);
                GlobalConstants.StateMenu_renderLanguageMenu();
                break;
            }
            case 5: {
                Intro.drawClear(77);
                Debug.UserInterface_drawGenericMessageBox();
                Main.renderSoftkeyBar();
                break;
            }
            case 6: {
                Intro.renderIntro();
                break;
            }
            case 7: {
                Intro.drawBG();
                Intro.drawMainMenu();
                break;
            }
            case 8: {
                Debug.UserInterface_renderGoalsScreen(3);
                Main.renderSoftkeyBar();
                break;
            }
            case 10: {
                GlobalConstants.StateMenu_renderCASAppearance();
                break;
            }
            case 17: {
                GlobalConstants.StateMenu_renderCASAppearance();
                ArrayHandler.PostEffects_renderBackgroundDim();
                Debug.UserInterface_drawGenericMessageBox();
                Main.renderSoftkeyBar();
                break;
            }
            case 11: {
                GlobalConstants.StateMenu_renderCASPersona();
                break;
            }
            case 12: {
                GlobalConstants.StateMenu_renderCASTraits();
                break;
            }
            case 13: {
                GlobalConstants.StateMenu_renderCASName();
                break;
            }
            case 18: {
                GlobalConstants.StateMenu_renderCASName();
                ArrayHandler.PostEffects_renderBackgroundDim();
                Debug.UserInterface_drawGenericMessageBox();
                Main.renderSoftkeyBar();
                break;
            }
            case 19: {
                Intro.drawBG();
                Intro.drawMainMenu();
                ArrayHandler.PostEffects_renderBackgroundDim();
                Debug.UserInterface_drawGenericMessageBox();
                Main.renderSoftkeyBar();
            }
        }
        ArrayHandler.PostEffects_renderFade(-1);
        Debug.renderDebug();
        Debug.renderPerf();
    }

    public static int StateMenu_getMaxMenuItemsPerScreen() {
        return StateMenu_m_maxMenuItemsPerScreen;
    }

    public static void StateMenu_initSharedMenus() {
        StateMenu_m_maxMenuItemsPerScreen = (short)17;
        short[] sArray = new short[12];
        Main.menuClear(sArray, 41, StateMenu_m_maxMenuItemsPerScreen);
        Main.menuAppendItem(sArray, 61);
        Main.menuAppendItem(sArray, 62);
        Main.menuAppendItem(sArray, 63);
        Main.menuAppendItem(sArray, 64);
        Main.menuAppendItem(sArray, 65);
        StateMenu_m_inGameOptionsMenu = new short[sArray[0] + 5];
        Main.menuCopy(StateMenu_m_inGameOptionsMenu, sArray);
        Main.menuAppendItem(sArray, 3);
        Main.menuAppendItem(sArray, 67);
        StateMenu_m_optionsMenu = sArray;
        sArray = new short[15];
        Main.menuClear(sArray, 42, StateMenu_m_maxMenuItemsPerScreen);
        Main.menuAppendItem(sArray, 74);
        Main.menuAppendItem(sArray, 87);
        Main.menuAppendItem(sArray, 91);
        Main.menuAppendItem(sArray, 89);
        StateMenu_m_helpMenu = sArray;
        StateMenu_m_sharedMenuState = -1;
    }

    public static void StateMenu_stateTransitionSharedMenu(int n) {
        short[] sArray = null;
        int n2 = -1;
        int n3 = 4;
        int n4 = 16;
        Debug.UserInterface_topItem = 0;
        switch (n) {
            default: {
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                sArray = StateMenu_m_optionsMenu;
                break;
            }
            case 1: {
                sArray = StateMenu_m_inGameOptionsMenu;
                break;
            }
            case 2: {
                n4 = 256;
                n3 = 512;
                n2 = 0;
                Debug.UserInterface_prepareGenericMessageBox(68, 67);
                break;
            }
            case 6: {
                n3 = 32768;
                n4 = 16384;
                GlobalConstants.StateMenu_m_languageMenu[2] = (short)Main.getRMSLangIndex();
                break;
            }
            case 3: {
                sArray = StateMenu_m_helpMenu;
                break;
            }
            case 4: {
                n4 = 0;
                n2 = 3;
                break;
            }
            case 5: {
                n4 = 0;
                n2 = -1;
            }
        }
        if (StateMenu_m_sharedMenuState == -1 && sArray != null) {
            sArray[2] = 0;
        }
        StateMenu_m_sharedMenu = sArray;
        StateMenu_m_sharedMenuBackState = n2;
        Main.setSoftKeys(n3, n4);
        StateMenu_m_sharedMenuState = n;
    }

    public static void StateMenu_renderSharedMenu() {
        switch (StateMenu_m_sharedMenuState) {
            default: {
                break;
            }
            case -1: {
                Debug.ASSERT(false, "no shared menu");
                break;
            }
            case 0: {
                Debug.UserInterface_drawGenericMenu(StateMenu_m_optionsMenu, 1);
                break;
            }
            case 1: {
                Debug.UserInterface_drawGenericMenu(StateMenu_m_inGameOptionsMenu, 1);
                break;
            }
            case 2: {
                Debug.UserInterface_drawGenericMessageBox();
                break;
            }
            case 3: {
                Debug.UserInterface_drawGenericMenu(StateMenu_m_helpMenu, 1);
                break;
            }
            case 4: 
            case 5: {
                Debug.UserInterface_drawTextScreen();
                return;
            }
        }
    }

    public static void StateMenu_processKeysSharedMenu() {
        if (StateMenu_m_sharedMenuState == 4 || StateMenu_m_sharedMenuState == 5) {
            Debug.UserInterface_processKeysTextScreen();
        } else if (StateMenu_m_sharedMenuState == 2 && Main.softPressPos()) {
            Main.resetSimSaveData();
            Main.resetGlobalGoals();
            Main.saveRMSAppSettings();
            Main.resetRMSGameData();
            Main.saveRMSGameData();
            GlobalConstants.StateMenu_initMainMenu(41);
            GlobalConstants.StateMenu_stateTransitionSharedMenu(-1);
        }
        if (StateMenu_m_sharedMenu != null) {
            if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
                int n = 5 + StateMenu_m_sharedMenu[2];
                GlobalConstants.StateMenu_processSharedMenuItem(StateMenu_m_sharedMenu[n]);
                AnimationManager.PMInput_reset();
                AnimationManager.PMInput_readKeys();
            } else {
                Main.menuCursorUpDown(StateMenu_m_sharedMenu);
            }
        }
        if (AnimationManager.PMInput_isPressed(4) || Main.softPressNeg()) {
            GlobalConstants.StateMenu_stateTransitionSharedMenu(StateMenu_m_sharedMenuBackState);
        }
    }

    public static void StateMenu_processSharedMenuItem(int n) {
        for (int i = 0; i < StateMenu_helpMenuTitle.length; ++i) {
            if (n != StateMenu_helpMenuTitle[i]) continue;
            Debug.UserInterface_prepareTextScreen(StateMenu_helpMenuText[i], StateMenu_helpMenuTitle[i], true);
            GlobalConstants.StateMenu_stateTransitionSharedMenu(4);
            return;
        }
        switch (n) {
            default: {
                break;
            }
            case 61: {
                if (!PMAudio.isEnabled) {
                    PMAudio.isEnabled = true;
                    PMAudio.update();
                    if (Event.PMStateManager_currentState == 1) {
                        Main.startMusic(1);
                        break;
                    }
                    PMAudio.play(0, 1);
                    break;
                }
                Main.startMusic(-1);
                PMAudio.isEnabled = false;
                break;
            }
            case 62: {
                Intro.PMVibrate_on = !Intro.PMVibrate_on;
                Intro.PMVibrate_vibrate(260);
                Main.saveRMSAppSettings();
                break;
            }
            case 63: {
                Main.m_rmsGSTutorialsEnabled = !Main.m_rmsGSTutorialsEnabled;
                Main.saveRMSAppSettings();
                break;
            }
            case 64: {
                Main.m_rmsGSAutonomityEnabled = !Main.m_rmsGSAutonomityEnabled;
                Main.saveRMSAppSettings();
                break;
            }
            case 65: {
                Main.m_rmsGSSavePrompts = !Main.m_rmsGSSavePrompts;
                Main.saveRMSAppSettings();
                break;
            }
            case 3: {
                GlobalConstants.StateMenu_stateTransitionSharedMenu(6);
                break;
            }
            case 67: {
                GlobalConstants.StateMenu_stateTransitionSharedMenu(2);
            }
        }
    }

    public static void StateMenu_start(int n) {
        Debug.UserInterface_initUI();
        Main.resetGDGoals();
        GlobalConstants.StateMenu_initLanguageMenu();
        if (n == -1) {
            n = 7;
        }
        StateMenu_m_initialState = n;
        if (n == 4 || n == 5) {
            StateMenu_m_initialState = 6;
            GlobalConstants.StateMenu_stateTransition(n);
        } else {
            GlobalConstants.StateMenu_stateTransition(1);
        }
        StateMenu_m_loadingState = 0;
    }

    public static void StateMenu_updateLoading(int n) {
        Event.LoadingScreen_update(n);
        GlobalConstants.StateMenu_updateLoadingState();
    }

    public static void StateMenu_updateLoadingState() {
        if (ArrayHandler.PostEffects_isFading()) {
            return;
        }
        switch (StateMenu_m_loadingState) {
            default: {
                break;
            }
            case 0: {
                short[] sArray = new short[15];
                StateMenu_m_mainMenu = sArray;
                GlobalConstants.StateMenu_initMainMenu(-1);
                ++StateMenu_m_loadingState;
                Main.loadImagesBegin();
                break;
            }
            case 1: {
                if (!Main.loadImagesNext(4)) break;
                ++StateMenu_m_loadingState;
                break;
            }
            case 2: {
                GlobalConstants.StateMenu_stateTransition(StateMenu_m_initialState);
            }
        }
    }

    public static void StateMenu_deinit() {
        Main.unloadAllImages(3076, -1);
        Main.startMusic(-1);
    }

    public static void StateMenu_processKeys() {
        if (StateMenu_m_state == 1) {
            AnimationManager.PMInput_reset();
            return;
        }
        if (StateMenu_m_afterFadeState != 0) {
            GlobalConstants.StateMenu_stateTransition(StateMenu_m_afterFadeState);
            ArrayHandler.PostEffects_startFadeIn();
            StateMenu_m_afterFadeState = 0;
            return;
        }
        if (ArrayHandler.PostEffects_isFading()) {
            return;
        }
        if (StateMenu_m_sharedMenuState != -1) {
            if (StateMenu_m_sharedMenuState == 6) {
                GlobalConstants.StateMenu_processKeysLanguageMenu();
            } else {
                GlobalConstants.StateMenu_processKeysSharedMenu();
            }
            if (StateMenu_m_sharedMenuState == -1) {
                GlobalConstants.StateMenu_stateTransition(StateMenu_m_state);
            }
            return;
        }
        switch (StateMenu_m_state) {
            default: {
                break;
            }
            case 4: {
                GlobalConstants.StateMenu_processKeysLanguageMenu();
                break;
            }
            case 5: {
                if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
                    PMAudio.isEnabled = true;
                    GlobalConstants.StateMenu_fadeStateTransition(1);
                    break;
                }
                if (!AnimationManager.PMInput_isPressed(4096) || Main.m_rightCommandID == 0) break;
                PMAudio.isEnabled = false;
                GlobalConstants.StateMenu_fadeStateTransition(1);
                break;
            }
            case 6: {
                Intro.processKeysIntro();
                break;
            }
            case 7: {
                if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
                    GlobalConstants.StateMenu_processAction(StateMenu_m_mainMenu[5 + StateMenu_m_mainMenu[2]]);
                    break;
                }
                if (Main.softPressNeg()) {
                    GlobalConstants.StateMenu_stateTransition(19);
                    break;
                }
                Main.menuCursorUpDown(StateMenu_m_mainMenu);
                break;
            }
            case 8: {
                Debug.UserInterface_processKeysList();
                if (!Main.softPressNeg()) break;
                GlobalConstants.StateMenu_stateTransition(7);
                break;
            }
            case 10: {
                GlobalConstants.StateMenu_processKeysCASAppearance();
                break;
            }
            case 17: {
                if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
                    GlobalConstants.StateMenu_stateTransition(7);
                    break;
                }
                if (!Main.softPressNeg()) break;
                GlobalConstants.StateMenu_stateTransition(10);
                break;
            }
            case 11: {
                GlobalConstants.StateMenu_processKeysCASPersona();
                break;
            }
            case 12: {
                GlobalConstants.StateMenu_processKeysCASTraits();
                break;
            }
            case 13: {
                GlobalConstants.StateMenu_processKeysCASName();
                break;
            }
            case 18: {
                if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
                    Main.m_rmsSimNameString[Main.m_gameSlotIndex] = StateMenu_casNameString;
                    Main.newGame();
                    Main.beginGame();
                    Event.PMStateManager_set(0, -1);
                    break;
                }
                if (!Main.softPressNeg()) break;
                GlobalConstants.StateMenu_stateTransition(13);
                break;
            }
            case 19: {
                if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
                    GlobalConstants.StateMenu_stateTransition(3);
                    break;
                }
                if (!Main.softPressNeg()) break;
                GlobalConstants.StateMenu_stateTransition(7);
            }
        }
    }

    public static void StateMenu_updateStep(int n) {
        if (StateMenu_m_state == 1) {
            GlobalConstants.StateMenu_updateLoading(n);
            return;
        }
        GameConstants.TextHandler_updateScrollers(n);
        if (StateMenu_m_state != 5 && StateMenu_m_state != 4 && PMAudio.isEnabled && Main.m_musicID != 1) {
            Main.startMusic(1);
        }
        switch (StateMenu_m_state) {
            default: {
                break;
            }
            case 6: {
                Intro.updateIntro(n);
                break;
            }
            case 10: {
                GlobalConstants.StateMenu_updateCASSim(n, false);
                GlobalConstants.StateMenu_updateCASAppearance(n);
                break;
            }
            case 11: {
                GlobalConstants.StateMenu_updateCASSim(n, true);
                break;
            }
            case 12: {
                GlobalConstants.StateMenu_updateCASSim(n, true);
                GlobalConstants.StateMenu_updateCASTraits(n);
                break;
            }
            case 13: {
                GlobalConstants.StateMenu_updateCASName(n);
            }
        }
    }

    public static void StateMenu_stateTransition(int n) {
        AnimationManager.Touch_clear();
        Event.PMDebug_println("SceneMenu.stateTransition: " + n);
        int n2 = StateMenu_m_state;
        StateMenu_m_state = n;
        switch (n) {
            default: {
                break;
            }
            case 1: {
                Main.setSoftKeys(0, 0);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                Event.PMStateManager_set(-1, 0);
                break;
            }
            case 4: {
                Main.setSoftKeys(0, 16384);
                break;
            }
            case 5: {
                Main.setSoftKeys(512, 256);
                Debug.UserInterface_prepareGenericMessageBox(60, 61);
                break;
            }
            case 6: {
                Main.startMusic(1);
                Main.loadAllImages(2);
                Main.setSoftKeys(0, 0);
                Intro.initIntro();
                break;
            }
            case 7: {
                Intro.m_introState = 18;
                Intro.unloadIntro();
                Main.unloadAllImages(2, 0);
                Main.setSoftKeys(0, 16);
                break;
            }
            case 8: {
                Debug.UserInterface_initListGoals();
                Main.setSoftKeys(4, 0);
                break;
            }
            case 10: {
                StateMenu_m_casUpArrow.startAnim(313, 20);
                StateMenu_m_casDownArrow.startAnim(311, 20);
                if (n2 != 11 && n2 != 17) {
                    GlobalConstants.StateMenu_setAppearanceButtonIndex(0, 0);
                } else if (n2 == 11) {
                    GlobalConstants.StateMenu_restartCASSim(false);
                }
                Main.setSoftKeys(4, 2);
                break;
            }
            case 11: {
                GlobalConstants.StateMenu_initListPersonas();
                GlobalConstants.StateMenu_restartCASSim(true);
                GameConstants.TextHandler_wrapString(637, 1, Debug.UserInterface_m_uiInfoBoxWrapWidth);
                Main.setSoftKeys(4, Main.m_simData.getPersona() != -1 ? 2 : 0);
                break;
            }
            case 12: {
                GlobalConstants.StateMenu_initListTraits();
                GlobalConstants.StateMenu_restartCASSim(true);
                GameConstants.TextHandler_wrapString(645, 1, Debug.UserInterface_m_uiInfoBoxWrapWidth);
                int n3 = Main.m_simData.getNumPlayerTraits();
                boolean bl = 5 == n3;
                Main.setSoftKeys(4, bl ? 2 : 0);
                break;
            }
            case 13: {
                if (n2 != 18) {
                    GlobalConstants.StateMenu_initCharEntry();
                }
                Main.setSoftKeys(4, Main.getSimNameLength() != 0 ? 2 : 0);
                break;
            }
            case 17: {
                Debug.UserInterface_prepareGenericMessageBox(38, 37);
                Main.setSoftKeys(512, 256);
                break;
            }
            case 18: {
                Debug.UserInterface_prepareGenericMessageBox(39, 33);
                Main.setSoftKeys(512, 256);
                break;
            }
            case 19: {
                Debug.UserInterface_prepareGenericMessageBox(50, 23);
                Main.setSoftKeys(512, 256);
            }
        }
    }

    public static void StateMenu_fadeStateTransition(int n) {
        StateMenu_m_afterFadeState = n;
        if (!ArrayHandler.PostEffects_isFadingOut()) {
            ArrayHandler.PostEffects_startFadeOut();
        }
    }

    public static void StateMenu_initMainMenu(int n) {
        Main.menuClear(StateMenu_m_mainMenu, 31, GlobalConstants.StateMenu_getMaxMenuItemsPerScreen());
        Main.menuAppendItem(StateMenu_m_mainMenu, 33);
        if (Main.getRMSActiveGame()) {
            Main.menuAppendItem(StateMenu_m_mainMenu, 34);
        }
        if (Event.StateMoreGames_isAvailable()) {
            Main.menuAppendItem(StateMenu_m_mainMenu, 44);
        }
        Main.menuAppendItem(StateMenu_m_mainMenu, 40);
        Main.menuAppendItem(StateMenu_m_mainMenu, 41);
        Main.menuAppendItem(StateMenu_m_mainMenu, 42);
        Main.menuAppendItem(StateMenu_m_mainMenu, 43);
        Main.menuAppendItem(StateMenu_m_mainMenu, 23);
        Main.menuSelectById(StateMenu_m_mainMenu, n);
    }

    public static void StateMenu_processAction(int n) {
        switch (n) {
            case 33: {
                GlobalConstants.StateMenu_casStart();
                break;
            }
            case 34: {
                Main.beginGame();
                Event.PMStateManager_set(0, -1);
                break;
            }
            case 40: {
                GlobalConstants.StateMenu_stateTransition(8);
                break;
            }
            case 41: {
                GlobalConstants.StateMenu_stateTransitionSharedMenu(0);
                break;
            }
            case 43: {
                Debug.UserInterface_prepareTextScreen(71, 43, true);
                GlobalConstants.StateMenu_stateTransitionSharedMenu(5);
                break;
            }
            case 42: {
                GlobalConstants.StateMenu_stateTransitionSharedMenu(3);
                break;
            }
            case 44: {
                Event.PMStateManager_set(2, 0);
                break;
            }
            case 23: {
                GlobalConstants.StateMenu_stateTransition(19);
                break;
            }
            default: {
                Debug.ASSERT(false, "not implemented case in processAction");
            }
        }
    }

    public static void StateMenu_initLanguageMenu() {
        if (StateMenu_m_languageMenu == null) {
            int n;
            int n2 = GameConstants.TextHandler_getNumLanguages();
            short[] sArray = new short[5 + n2];
            StateMenu_m_languageMenu = sArray;
            Main.menuClear(sArray, 3, GlobalConstants.StateMenu_getMaxMenuItemsPerScreen());
            SDKString[] sDKStringArray = new SDKString[n2 + 1];
            StateMenu_m_languageMenuStrings = sDKStringArray;
            for (n = 0; n < n2; ++n) {
                Main.menuAppendItem(sArray, n);
                sDKStringArray[n] = SDKUtils.getHeaderString(n, 0, null);
            }
            n = Main.getRMSLangIndex();
            if (n != -1) {
                sArray[2] = (short)n;
            }
        }
    }

    public static void StateMenu_renderLanguageMenu() {
        Debug.UserInterface_drawGenericMenu(StateMenu_m_languageMenu, 1, StateMenu_m_languageMenuStrings);
        Main.renderSoftkeyBar();
    }

    public static void StateMenu_processKeysLanguageMenu() {
        short s = StateMenu_m_languageMenu[2];
        if (AnimationManager.PMInput_isPressed(1) || Main.softPressPos()) {
            GlobalConstants.StateMenu_setLang(s);
            if (StateMenu_m_sharedMenuState == 6) {
                GlobalConstants.StateMenu_stateTransitionSharedMenu(0);
            } else {
                GlobalConstants.StateMenu_fadeStateTransition(5);
            }
        } else if (Main.softPressNeg()) {
            if (StateMenu_m_sharedMenuState == 6) {
                SDKUtils.setCurrentLanguage(Main.getRMSLangIndex());
                GlobalConstants.StateMenu_stateTransitionSharedMenu(0);
            }
        } else {
            Main.menuCursorUpDown(StateMenu_m_languageMenu);
            short s2 = StateMenu_m_languageMenu[2];
            if (s2 != s) {
                SDKUtils.setCurrentLanguage(s2);
            }
        }
    }

    public static void StateMenu_setLang(int n) {
        GameConstants.TextHandler_loadLanguageChunks(n);
        Main.saveRMSAppSettings();
    }

    public static void StateMenu_casStart() {
        Main.resetRMSGameData();
        StateMenu_m_casArms = Main.m_simData.getSimAttribute(0, 6) != 0;
        StateMenu_m_casLegs = Main.m_simData.getSimAttribute(0, 8) != 0;
        StateMenu_m_casHairAcc = GlobalConstants.StateMenu_doesHairStyleHaveAccent(Main.m_simData.getSimAttribute(0, 2));
        StateMenu_m_cursorPosition = 0;
        GlobalConstants.StateMenu_stateTransition(10);
        GlobalConstants.StateMenu_reloadCASSim(false);
        StateMenu_casNameString = new SDKString(8, 0);
        StateMenu_casNameString.setLength(1);
        StateMenu_casNameString.setCharAt(0, StateMenu_SELECT_LETTERS[0]);
    }

    public static void StateMenu_reloadCASSim(boolean bl) {
        GlobalConstants.StateMenu_restartCASSim(bl);
        Main.m_simWorld.getSimPatches(0, StateMenu_m_palSources, StateMenu_m_palPatches);
        int n = Main.m_simData.getSimAttribute(0, 0) == 0 ? 2048 : 1024;
        Main.unloadAllImages(3072, -1);
        Main.loadAllImages(n, StateMenu_m_palSources, StateMenu_m_palPatches, 0);
    }

    public static void StateMenu_drawCASSim(int n, int n2, boolean bl) {
        int n3 = StateMenu_m_casAnimPlayer.getAnimID();
        if (bl) {
            AnimationManager.getAnimFrameFirePoint(StateMenu_m_tempInt4, n3, 0, 1);
            n -= StateMenu_m_tempInt4[0];
            n2 -= StateMenu_m_tempInt4[1];
        }
        StateMenu_m_casAnimPlayer.drawAnim(n, n2);
        StateMenu_m_casAnimPlayer.getFirePointCurrFrame(StateMenu_m_tempInt4, 0);
        int n4 = Main.m_simData.getSimAttribute(0, 2);
        AnimationManager.drawAnimFrame(StateMenu_m_casHairAnim, n4, n + StateMenu_m_tempInt4[0], n2 + StateMenu_m_tempInt4[1]);
        if (Main.m_simData.getSimAttribute(0, 8) != 0) {
            int n5 = n3 == 335 ? 336 : 339;
            AnimationManager.drawAnimFrame(n5, 0, n, n2);
        }
    }

    public static void StateMenu_restartCASSim(boolean bl) {
        int n;
        int n2;
        if (Main.m_simData.getSimAttribute(0, 0) == 0) {
            if (bl) {
                n2 = 338;
                n = 342;
            } else {
                n2 = 338;
                n = 342;
            }
        } else {
            n2 = 335;
            n = 337;
        }
        StateMenu_m_casAnimPlayer.startAnim(n2, 4);
        StateMenu_m_casHairAnim = n;
    }

    public static void StateMenu_updateCASSim(int n, boolean bl) {
        if (!StateMenu_m_casAnimPlayer.isAnimating()) {
            GlobalConstants.StateMenu_restartCASSim(bl);
        }
        StateMenu_m_casAnimPlayer.updateAnim(n);
    }

    public static void StateMenu_updateCASAppearance(int n) {
        StateMenu_m_casUpArrow.updateAnim(n);
        if (!StateMenu_m_casUpArrow.isAnimating()) {
            StateMenu_m_casUpArrow.startAnim(313, 20);
        }
        StateMenu_m_casDownArrow.updateAnim(n);
        if (!StateMenu_m_casDownArrow.isAnimating()) {
            StateMenu_m_casDownArrow.startAnim(311, 20);
        }
        Debug.UserInterface_updateLeftRightArrows(n);
        StateMenu_m_casButtonsOffsetF = Debug.UserInterface_interpolateValue(StateMenu_m_casButtonsOffsetF, StateMenu_m_casButtonsOffsetTargetF, n, 8);
        StateMenu_m_casColorsOffsetF = Debug.UserInterface_interpolateValue(StateMenu_m_casColorsOffsetF, StateMenu_m_casColorsOffsetTargetF, n, 8);
        if (Math.abs(StateMenu_m_casButtonsOffsetF - StateMenu_m_casButtonsOffsetTargetF) < 32768) {
            StateMenu_m_casButtonsOffsetF = StateMenu_m_casButtonsOffsetTargetF;
        }
        if (Math.abs(StateMenu_m_casColorsOffsetF - StateMenu_m_casColorsOffsetTargetF) < 32768) {
            StateMenu_m_casColorsOffsetF = StateMenu_m_casColorsOffsetTargetF;
        }
    }

    public static void StateMenu_processKeysCASAppearance() {
        if (Main.softPressNeg()) {
            GlobalConstants.StateMenu_stateTransition(17);
        } else if (Main.softPressPos()) {
            GlobalConstants.StateMenu_fadeStateTransition(11);
        } else if (AnimationManager.PMInput_isPressed(32) && StateMenu_m_casButtonIndex > 0) {
            StateMenu_m_casUpArrow.startAnim(312, 16);
            GlobalConstants.StateMenu_setAppearanceButtonIndex(StateMenu_m_casButtonIndex - 1, -1);
        } else if (AnimationManager.PMInput_isPressed(64) && StateMenu_m_casButtonIndex < StateMenu_BUTTON_STRINGS.length - 1) {
            StateMenu_m_casDownArrow.startAnim(310, 16);
            GlobalConstants.StateMenu_setAppearanceButtonIndex(StateMenu_m_casButtonIndex + 1, 1);
        } else if (StateMenu_BUTTON_STRINGS[StateMenu_m_casButtonIndex] == 624) {
            if (AnimationManager.PMInput_isPressed(8)) {
                GlobalConstants.StateMenu_setAppearancePreset(StateMenu_m_casAttributeIndex - 1);
                Debug.UserInterface_triggerLeftArrow();
            } else if (AnimationManager.PMInput_isPressed(16)) {
                GlobalConstants.StateMenu_setAppearancePreset(StateMenu_m_casAttributeIndex + 1);
                Debug.UserInterface_triggerRightArrow();
            }
        } else if (AnimationManager.PMInput_isPressed(8) && StateMenu_m_casAttributeIndex > StateMenu_m_casAttributeIndexMin) {
            GlobalConstants.StateMenu_setAppearanceAttributeIndex(StateMenu_m_casAttributeIndex - 1, false);
            Debug.UserInterface_triggerLeftArrow();
            GlobalConstants.StateMenu_reloadCASSim(false);
        } else if (AnimationManager.PMInput_isPressed(16) && StateMenu_m_casAttributeIndex < StateMenu_m_casAttributeIndexMax) {
            GlobalConstants.StateMenu_setAppearanceAttributeIndex(StateMenu_m_casAttributeIndex + 1, false);
            Debug.UserInterface_triggerRightArrow();
            GlobalConstants.StateMenu_reloadCASSim(false);
        }
    }

    public static void StateMenu_setAppearancePreset(int n) {
        int n2 = Main.m_simData.getPresetCount();
        if (n < 0) {
            n = n2 - 1;
        } else if (n >= n2) {
            n = 0;
        }
        StateMenu_m_casAttributeIndex = n;
        byte[] byArray = Main.m_simData.getAttributePreset(n);
        for (int i = 0; i < 10; ++i) {
            Main.m_simData.setPlayerSimAttribute(i, byArray[i]);
        }
        StateMenu_m_casArms = byArray[10] == 0;
        StateMenu_m_casLegs = byArray[11] == 0;
        GlobalConstants.StateMenu_reloadCASSim(false);
    }

    public static void StateMenu_setAppearanceButtonIndex(int n, int n2) {
        if (!StateMenu_m_casArms && StateMenu_BUTTON_STRINGS[n] == 632) {
            n += n2;
        }
        if (!StateMenu_m_casLegs && StateMenu_BUTTON_STRINGS[n] == 635) {
            n += n2;
        }
        if (!StateMenu_m_casHairAcc && StateMenu_BUTTON_STRINGS[n] == 629) {
            n += n2;
        }
        int n3 = 245 - (AnimationManager.getAnimFrameHeight(329, 0) << 1);
        int n4 = AnimationManager.getAnimFrameCount(319);
        int n5 = AnimationManager.getAnimFrameHeight(320, 0);
        int n6 = (n3 >> 1) + 2 - n5 * n - (n5 >> 1);
        int n7 = n3 - 2 - n5 * n4;
        n6 = IStringConstants.MathExt_clip(n6, n7, 2);
        StateMenu_m_casButtonsOffsetTargetF = n6 << 16;
        if (n2 == 0) {
            StateMenu_m_casButtonsOffsetF = n6 << 16;
        }
        StateMenu_m_casButtonIndex = n;
        int n8 = 321;
        int n9 = 87;
        int n10 = 87;
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        switch (StateMenu_BUTTON_STRINGS[n]) {
            default: {
                break;
            }
            case 624: {
                break;
            }
            case 625: {
                n10 = 323;
                n9 = 322;
                n11 = 0;
                break;
            }
            case 626: {
                n12 = 0;
                n11 = 1;
                break;
            }
            case 627: {
                if (Main.m_simData.getSimAttribute(0, 0) == 1) {
                    n9 = 324;
                    n10 = 325;
                } else {
                    n9 = 326;
                    n10 = 327;
                }
                n11 = 2;
                break;
            }
            case 628: {
                n12 = 1;
                n11 = 3;
                break;
            }
            case 629: {
                n12 = 2;
                n11 = 4;
                break;
            }
            case 630: {
                n12 = 3;
                n11 = 5;
                break;
            }
            case 631: {
                n9 = 332;
                n10 = 333;
                StateMenu_m_casAttributeIndex = StateMenu_m_casArms ? 0 : 1;
                break;
            }
            case 632: {
                n12 = 4;
                n11 = 6;
                n13 = 1;
                break;
            }
            case 633: {
                n12 = 5;
                n11 = 7;
                break;
            }
            case 634: {
                n9 = 330;
                n10 = 331;
                StateMenu_m_casAttributeIndex = StateMenu_m_casLegs ? 0 : 1;
                break;
            }
            case 635: {
                n12 = 6;
                n11 = 8;
                n13 = 1;
                break;
            }
            case 636: {
                n12 = 7;
                n11 = 9;
            }
        }
        StateMenu_m_casAttribute = n11;
        StateMenu_m_casAttributePatch = n12;
        StateMenu_m_casAttributesButtonsAnim = n8;
        StateMenu_m_casAttributesAnimHi = n9;
        StateMenu_m_casAttributesAnimLo = n10;
        StateMenu_m_casAttributeIndexMin = n13;
        if (n8 != 87) {
            if (n12 != -1) {
                Debug.ASSERT(n8 == 321, "need the color anim");
                StateMenu_m_casAttributeIndexMax = Main.m_simWorld.getPal(n12).length - 1;
            } else {
                StateMenu_m_casAttributeIndexMax = AnimationManager.getAnimFrameCount(n9) - 1;
            }
            if (n11 != -1) {
                GlobalConstants.StateMenu_setAppearanceAttributeIndex(Main.m_simData.getSimAttribute(0, n11), true);
            } else {
                GlobalConstants.StateMenu_setAppearanceAttributeIndex(StateMenu_m_casAttributeIndex, true);
            }
        }
    }

    public static boolean StateMenu_doesHairStyleHaveAccent(int n) {
        int n2 = 1 << n;
        if (Main.m_simData.getSimAttribute(0, 0) == 0) {
            n2 <<= 16;
        }
        return (n2 & 0xC000D) != 0;
    }

    public static void StateMenu_setAppearanceAttributeIndex(int n, boolean bl) {
        int n2;
        short s;
        StateMenu_m_casAttributeIndex = n;
        if (StateMenu_m_casAttribute != -1) {
            Main.m_simData.setPlayerSimAttribute(StateMenu_m_casAttribute, n);
        }
        if ((s = StateMenu_BUTTON_STRINGS[StateMenu_m_casButtonIndex]) == 631) {
            if (n == 0) {
                StateMenu_m_casArms = true;
                n2 = Main.m_simData.getSimAttribute(0, 5) + 1;
            } else {
                StateMenu_m_casArms = false;
                n2 = 0;
            }
            Main.m_simData.setPlayerSimAttribute(6, n2);
        } else if (s == 634) {
            if (n == 0) {
                StateMenu_m_casLegs = true;
                n2 = Main.m_simData.getSimAttribute(0, 7) + 1;
            } else {
                StateMenu_m_casLegs = false;
                n2 = 0;
            }
            Main.m_simData.setPlayerSimAttribute(8, n2);
        } else if (s == 625 || s == 627) {
            StateMenu_m_casHairAcc = GlobalConstants.StateMenu_doesHairStyleHaveAccent(Main.m_simData.getSimAttribute(0, 2));
        }
        AnimationManager.getAnimFrameCollisionBox(StateMenu_m_tempInt4, 321, 0, 0);
        n2 = StateMenu_m_tempInt4[2];
        int n3 = StateMenu_m_casAttributeIndexMax - StateMenu_m_casAttributeIndexMin + 1;
        int n4 = AnimationManager.getAnimFrameHeight(315, 0);
        int n5 = Math.min(n3 * n4, n2);
        int n6 = n2 - n5;
        int n7 = (n5 >> 1) + 0 - n4 * n - (n4 >> 1) + n6;
        int n8 = n5 - 0 - n4 * n3 + (n6 >> 1);
        n7 = IStringConstants.MathExt_clip(n7, n8, 0);
        StateMenu_m_casColorsOffsetTargetF = n7 << 16;
        if (bl) {
            StateMenu_m_casColorsOffsetF = n7 << 16;
        }
    }

    public static final void StateMenu_drawVerticalGradient(boolean bl, int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = nArray.length;
        int n6 = (n4 << 16) / n5;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            if (bl) {
                Debug.PMGraphics_setColor(nArray[i]);
            } else {
                AnimationManager.setColor(nArray[i]);
            }
            int n8 = (i + 1) * n6 + 32768 >> 16;
            Debug.PMGraphics_fillRect(n, n2 + n7, n3, n8 - n7);
            n7 = n8;
        }
    }

    public static final void StateMenu_renderCASBackground(int n, int n2, int n3, int n4) {
        int n5 = GlobalConstants.StateMenu_calculateCASGroundHeight(n4);
        int n6 = n4 - n5;
        GlobalConstants.StateMenu_drawVerticalGradient(false, StateMenu_GRAD_CAS_SKY, n, n2, n3, n4);
        GlobalConstants.StateMenu_drawVerticalGradient(false, StateMenu_GRAD_CAS_GROUND, n, n2 + n6, n3, n5);
    }

    public static final int StateMenu_calculateCASGroundHeight(int n) {
        return IStringConstants.MathExt_Fmul(17902, n);
    }

    public static void StateMenu_renderCASAppearance() {
        int n;
        int n2;
        int n3;
        GlobalConstants.StateMenu_renderCASBackground(0, 0, 240, 245);
        int n4 = AnimationManager.getAnimFrameHeight(329, 0);
        int n5 = 0 + AnimationManager.getAnimFrameWidth(329, 0);
        int n6 = n5 + 4;
        int n7 = 0 + n4;
        int n8 = n5 - 4;
        int n9 = 245 - (n4 << 1);
        int n10 = 242 + n6 >> 1;
        int n11 = GlobalConstants.StateMenu_calculateCASGroundHeight(245);
        int n12 = 245 - (n11 >> 1);
        int n13 = Debug.PMGraphics_getClipX();
        int n14 = Debug.PMGraphics_getClipY();
        int n15 = Debug.PMGraphics_getClipWidth();
        int n16 = Debug.PMGraphics_getClipHeight();
        AnimationManager.setColor(60);
        Debug.PMGraphics_fillRect(2, 0, 1, 245);
        Debug.PMGraphics_fillRect(2 + n6 - 1, 0, 1, 245);
        AnimationManager.setColor(77);
        Debug.PMGraphics_fillRect(3, 0, 1, 245);
        Debug.PMGraphics_fillRect(2 + n6 - 2, 0, 1, 245);
        AnimationManager.setColor(76);
        Debug.PMGraphics_fillRect(4, n4, 2, n9);
        Debug.PMGraphics_fillRect(2 + n6 - 2 - 2, n4, 2, n9);
        GlobalConstants.StateMenu_drawVerticalGradient(false, StateMenu_GRAD_CAS_LIST, 6, n7, n8, n9);
        AnimationManager.drawAnimFrame(329, 0, 4, 0);
        AnimationManager.drawAnimFrame(328, 0, 4, 245);
        int n17 = 6 + (n8 >> 1);
        int n18 = AnimationManager.getAnimFrameCount(319);
        int n19 = AnimationManager.getAnimFrameHeight(320, 0);
        int n20 = AnimationManager.getAnimFrameWidth(313, 0);
        int n21 = AnimationManager.getAnimFrameHeight(313, 0);
        int n22 = n4 - n21 >> 1;
        int n23 = 245 - (n4 - n21 >> 1);
        int n24 = 2 + (n6 - n20 >> 1) + (n20 >> 1);
        if (StateMenu_m_casButtonIndex > 0) {
            StateMenu_m_casUpArrow.drawAnim(n24, n22);
        }
        if (StateMenu_m_casButtonIndex < n18 - 1) {
            StateMenu_m_casDownArrow.drawAnim(n24, n23);
        }
        Debug.PMGraphics_setClip(6, n7, n8, n9);
        int n25 = n7 + (StateMenu_m_casButtonsOffsetF >> 16);
        for (n3 = 0; n3 < n18; ++n3) {
            n2 = n3 == StateMenu_m_casButtonIndex ? 320 : 319;
            n = n3;
            if (StateMenu_BUTTON_STRINGS[n3] == 632 && !StateMenu_m_casArms) {
                n2 = 318;
                n = 0;
            }
            if (StateMenu_BUTTON_STRINGS[n3] == 635 && !StateMenu_m_casLegs) {
                n2 = 317;
                n = 0;
            }
            if (StateMenu_BUTTON_STRINGS[n3] == 629 && !StateMenu_m_casHairAcc) {
                n2 = 316;
                n = 0;
            }
            AnimationManager.drawAnimFrame(n2, n, n17, n25);
            n25 += n19;
        }
        Debug.PMGraphics_setClip(n13, n14, n15, n16);
        n17 = 0;
        n17 = IStringConstants.MathExt_Fmul(12179, n11);
        AnimationManager.drawAnimFrame(334, 0, n10, n12 + n17);
        GlobalConstants.StateMenu_drawCASSim(n10, n12 + n17, false);
        n19 = StateMenu_BUTTON_STRINGS[StateMenu_m_casButtonIndex];
        n21 = 240 - n6 - 2 - 8;
        n22 = 2 + n6 + 4;
        n18 = Debug.UserInterface_drawDropDownDoubleTitle(n22, n21, 620, n19);
        n23 = StateMenu_m_casAttributesButtonsAnim;
        if (n23 != 87) {
            n24 = n10;
            n25 = n18 + IStringConstants.MathExt_Fmul(245 - n11 - n18, 12179);
            AnimationManager.drawAnimFrame(n23, 0, n24, n25);
            AnimationManager.getAnimFrameCollisionBox(StateMenu_m_tempInt4, n23, 0, 0);
            n3 = StateMenu_m_casAttributePatch != -1 ? 1 : 0;
            n2 = n24 + StateMenu_m_tempInt4[0];
            n = n25 + StateMenu_m_tempInt4[1];
            int n26 = StateMenu_m_tempInt4[2];
            int n27 = StateMenu_m_tempInt4[3];
            int n28 = n + (n27 >> 1);
            int n29 = AnimationManager.getAnimFrameWidth(315, 0);
            Debug.PMGraphics_setClip(n2, n, n26, n27);
            int n30 = n28;
            int n31 = n2 + (StateMenu_m_casColorsOffsetF >> 16) + (n3 != 0 ? 0 : n29 >> 1);
            for (int i = StateMenu_m_casAttributeIndexMin; i <= StateMenu_m_casAttributeIndexMax; ++i) {
                if (n3 != 0) {
                    byte[] byArray = Main.m_simWorld.getPal(StateMenu_m_casAttributePatch);
                    int[] nArray = Main.m_simWorld.getPatch(byArray[i]);
                    GlobalConstants.StateMenu_renderCASColor(n31, n30, nArray, i == StateMenu_m_casAttributeIndex);
                } else {
                    int n32 = i == StateMenu_m_casAttributeIndex ? StateMenu_m_casAttributesAnimHi : StateMenu_m_casAttributesAnimLo;
                    AnimationManager.drawAnimFrame(n32, i, n31, n30);
                }
                n31 += n29;
            }
            Debug.PMGraphics_setClip(n13, n14, n15, n16);
            if (StateMenu_m_casAttributeIndex > StateMenu_m_casAttributeIndexMin || n19 == 624) {
                AnimationManager.getAnimFrameFirePoint(StateMenu_m_tempInt4, n23, 0, 0);
                Debug.UserInterface_m_arrowLeftAnimPlayer.drawAnim(n24 + StateMenu_m_tempInt4[0], n25 + StateMenu_m_tempInt4[1]);
                AnimationManager.Touch_addTouchData(1, n24 + StateMenu_m_tempInt4[0], n25 + StateMenu_m_tempInt4[1], 0, 0);
            }
            if (StateMenu_m_casAttributeIndex < StateMenu_m_casAttributeIndexMax || n19 == 624) {
                AnimationManager.getAnimFrameFirePoint(StateMenu_m_tempInt4, n23, 0, 1);
                Debug.UserInterface_m_arrowRightAnimPlayer.drawAnim(n24 + StateMenu_m_tempInt4[0], n25 + StateMenu_m_tempInt4[1]);
                AnimationManager.Touch_addTouchData(2, n24 + StateMenu_m_tempInt4[0], n25 + StateMenu_m_tempInt4[1], 0, 0);
            }
        }
        Main.renderSoftkeyBar();
    }

    public static void StateMenu_renderCASColor(int n, int n2, int[] nArray, boolean bl) {
        int n3;
        int n4;
        AnimationManager.getAnimFrameCollisionBox(StateMenu_m_tempInt4, 314, 0, 0);
        int n5 = n + StateMenu_m_tempInt4[0];
        int n6 = n2 + StateMenu_m_tempInt4[1];
        int n7 = StateMenu_m_tempInt4[2];
        if (bl) {
            n4 = n7 + 6;
            AnimationManager.setColor(76);
            Debug.PMGraphics_fillRect(n5 - 3, n6 - 3, n4, n4);
            AnimationManager.setColor(77);
            Debug.PMGraphics_fillRect(n5 - 2, n6 - 2, n4 -= 2, n4);
        }
        n4 = n7 % 2 == 0 ? 1 : 0;
        int n8 = 240;
        int n9 = n8 > 300 ? n8 / 200 : 1;
        int n10 = n3 = n7 - n9 * 2;
        int n11 = n10 * 80 / 100;
        int n12 = n10 * 30 / 100;
        if (n12 == 0 && n10 > 2) {
            n12 = 1;
        }
        if (n4 == 0) {
            ++n11;
        }
        Debug.PMGraphics_setColor(60);
        Debug.PMGraphics_fillRect(n5 - 1, n6 - 1, n7 + 2, n7 + 2);
        Debug.PMGraphics_setColor(nArray[1]);
        Debug.PMGraphics_fillRect(n5, n6, n7, n7);
        Debug.PMGraphics_setColor(nArray[2]);
        Debug.PMGraphics_fillRect(n5 + n9, n6 + n9, n3, n11);
        if (n12 > 0) {
            Debug.PMGraphics_setColor(nArray[3]);
            Debug.PMGraphics_fillRect(n5 + n9, n6 + n9, n3, n12);
        }
    }

    public static void StateMenu_processKeysCASPersona() {
        Debug.UserInterface_processKeysList();
        if (Main.softPressNeg(4) || AnimationManager.PMInput_isPressed(4)) {
            GlobalConstants.StateMenu_stateTransition(10);
        } else if (Main.softPressPos(2)) {
            GlobalConstants.StateMenu_stateTransition(12);
        } else if (AnimationManager.PMInput_isPressed(1) && !AnimationManager.PMInput_isPressed(2048)) {
            Main.m_simData.setPersona(Debug.UserInterface_getListCursor());
            Main.setSoftKeys(4, 2);
        }
    }

    public static void StateMenu_renderCASPersona() {
        Debug.UserInterface_drawUIFullScreen(18);
        GlobalConstants.StateMenu_drawCASSim(240, 245, true);
        Main.renderSoftkeyBar();
    }

    public static void StateMenu_initListPersonas() {
        Debug.UserInterface_initList(Main.m_simData.getPersonaCount(), 15, 0);
    }

    public static void StateMenu_drawListPersonas(int n, int n2, int n3, int n4) {
        int n5 = n + (n3 >> 1);
        int n6 = n2;
        int n7 = Debug.UserInterface_getListCursor();
        for (int i = Debug.UserInterface_getListOffset(); n6 < n2 + n4 && i < Debug.UserInterface_getListNum(); ++i) {
            int n8;
            short s = Main.m_simData.getPersonaDescString(i);
            int n9 = 3;
            int n10 = -1;
            if (i == Main.m_simData.getPersona()) {
                n8 = 0;
                n9 = 1;
                n10 = 75;
            } else {
                n8 = 1;
            }
            if (i == n7) {
                n10 = 82;
            }
            if (n10 != -1) {
                Debug.UserInterface_drawListSelect(n, n6, n3, 15, n2 + n4, n10, i);
            }
            GameConstants.TextHandler_drawString(s, n8, n5, n6 + n9, 17);
            AnimationManager.Touch_addTouchData(12 + i, n, n6, n3, 15);
            Debug.UserInterface_drawListDivider(n, n6 += 15, n3);
        }
    }

    public static int StateMenu_drawUIPersonaDesc(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 - 8 - 15;
        int n7 = 4;
        int n8 = 8 + n7 * Debug.UserInterface_m_uiWrappedLineHeight;
        int n9 = n7;
        for (n5 = 0; n5 < Main.m_simData.getPersonaCount(); ++n5) {
            short[] sArray = new short[10];
            sArray = Cursor.SDKStringUtilsHandler_wrapSDKString(GameConstants.TextHandler_getString(Main.m_simData.getPersonaLongDescString(n5)), sArray, n6, (short)124);
            if (sArray[0] + 1 <= n7) continue;
            n7 = sArray[0] + 1;
            n8 = 8 + n7 * Debug.UserInterface_m_uiWrappedLineHeight;
        }
        if (!bl) {
            Debug.UserInterface_drawDescBox(n, n2, n3, n8);
            n5 = n + 4;
            int n10 = n2 + 4;
            int n11 = n10 + Debug.UserInterface_m_uiWrappedLineHeight;
            GameConstants.TextHandler_drawString(623, 1, n5, n10, 20);
            short s = Main.m_simData.getPersonaLongDescString(Debug.UserInterface_getListCursor());
            GameConstants.TextHandler_drawWrappedStringChunk(0, s, 1, n6, n5, n11, 20);
        }
        return n8;
    }

    public static void StateMenu_updateCASTraits(int n) {
        GameConstants.TextHandler_updateScrollers(n);
    }

    public static void StateMenu_processKeysCASTraits() {
        Debug.UserInterface_processKeysList();
        if (Main.softPressNeg(4) || AnimationManager.PMInput_isPressed(4)) {
            GlobalConstants.StateMenu_stateTransition(11);
        } else if (Main.softPressPos(2)) {
            GlobalConstants.StateMenu_stateTransition(13);
        } else if (AnimationManager.PMInput_isPressed(1) && !AnimationManager.PMInput_isPressed(2048)) {
            int n = Debug.UserInterface_getListCursor();
            if (Main.m_simData.hasSimGotTrait(0, n) == -1) {
                Main.m_simData.traitPlayerAdd(n);
            } else {
                Main.m_simData.traitPlayerRemove(n);
            }
            int n2 = Main.m_simData.getNumPlayerTraits();
            boolean bl = 5 == n2;
            Main.setSoftKeys(4, bl ? 2 : 0);
        }
    }

    public static void StateMenu_renderCASTraits() {
        Debug.UserInterface_drawUIFullScreen(19);
        GlobalConstants.StateMenu_drawCASSim(240, 245, true);
        Main.renderSoftkeyBar();
    }

    public static void StateMenu_initListTraits() {
        Debug.UserInterface_initList(Main.m_simData.getTraitCount(), 15, 0);
    }

    public static void StateMenu_drawListTraits(int n, int n2, int n3, int n4) {
        int n5 = n + (n3 >> 1);
        int n6 = n2;
        int n7 = Debug.UserInterface_getListCursor();
        for (int i = Debug.UserInterface_getListOffset(); n6 < n2 + n4 && i < Debug.UserInterface_getListNum(); ++i) {
            int n8;
            short s = Main.m_simData.getTraitDescString(i);
            int n9 = 3;
            int n10 = -1;
            if (Main.m_simData.hasSimGotTrait(0, i) != -1) {
                n8 = 0;
                n9 = 1;
                n10 = 75;
            } else {
                n8 = 1;
            }
            if (i == n7) {
                n10 = 82;
            }
            if (n10 != -1) {
                Debug.UserInterface_drawListSelect(n, n6, n3, 15, n2 + n4, n10, i);
            }
            GameConstants.TextHandler_drawString(s, n8, n5, n6 + n9, 17);
            AnimationManager.Touch_addTouchData(12 + i, n, n6, n3, 15);
            Debug.UserInterface_drawListDivider(n, n6 += 15, n3);
        }
    }

    public static void StateMenu_initCharEntry() {
        StateMenu_m_isCharSelected = false;
        StateMenu_m_cursorPosition = StateMenu_casNameString.length() - 1;
        StateMenu_m_charSelectedTime = 0;
        StateMenu_m_lastKeyPressed = -1;
        StateMenu_m_charIndex = 0;
    }

    public static void StateMenu_finishCharEntry() {
        if (StateMenu_m_isCharSelected) {
            StateMenu_m_isCharSelected = false;
            if (StateMenu_m_cursorPosition < 8) {
                ++StateMenu_m_cursorPosition;
            }
            StateMenu_m_lastKeyPressed = -1;
        }
    }

    public static void StateMenu_updateCASName(int n) {
        if (StateMenu_m_isCharSelected && (StateMenu_m_charSelectedTime += n) >= 1250) {
            GlobalConstants.StateMenu_finishCharEntry();
        }
    }

    public static void StateMenu_processKeysCASName() {
        boolean bl = false;
        if (Main.softPressPos()) {
            if (Main.getSimNameLength() != 0) {
                GlobalConstants.StateMenu_stateTransition(18);
            }
        } else if (AnimationManager.PMInput_isPressed(4)) {
            GlobalConstants.StateMenu_finishCharEntry();
            int n = StateMenu_m_cursorPosition;
            boolean bl2 = bl = n == 0 && StateMenu_m_charIndex == 0;
            if (!bl) {
                if (StateMenu_m_cursorPosition != 0) {
                    --StateMenu_m_cursorPosition;
                }
                StateMenu_m_charIndex = Main.getSimNameCharIndex(StateMenu_m_cursorPosition);
                if (StateMenu_m_cursorPosition == 0 && n == 0) {
                    StateMenu_m_charIndex = 0;
                    Main.setSimNameCharIndex(0, 0);
                }
                Main.setSimNameLength(StateMenu_m_cursorPosition + 1);
            }
        } else if (Main.softPressNeg()) {
            bl = true;
        } else if (AnimationManager.PMInput_isPressed(8)) {
            if (StateMenu_m_cursorPosition != 0) {
                --StateMenu_m_cursorPosition;
            }
            StateMenu_m_charIndex = Main.getSimNameCharIndex(StateMenu_m_cursorPosition);
            Main.setSimNameLength(StateMenu_m_cursorPosition + 1);
        } else if (AnimationManager.PMInput_isPressed(17)) {
            if (StateMenu_m_cursorPosition < 7) {
                ++StateMenu_m_cursorPosition;
                StateMenu_m_charIndex = 0;
            }
            Main.setSimNameCharIndex(StateMenu_m_cursorPosition, StateMenu_m_charIndex);
        } else if (AnimationManager.PMInput_isPressed(32)) {
            Main.setSimNameCharIndex(StateMenu_m_cursorPosition, ++StateMenu_m_charIndex);
        } else if (AnimationManager.PMInput_isPressed(64)) {
            Main.setSimNameCharIndex(StateMenu_m_cursorPosition, --StateMenu_m_charIndex);
        }
        if (bl) {
            GlobalConstants.StateMenu_stateTransition(12);
        }
    }

    public static void StateMenu_renderCASName() {
        int n;
        int n2;
        GlobalConstants.StateMenu_renderCASBackground(0, 0, 240, 245);
        int n3 = Debug.UserInterface_m_uiTextHeight * (5 + 1) + 6 + 21 + 4;
        int n4 = 245 - n3 + 4;
        int n5 = Debug.UserInterface_drawDropDownDoubleTitle(24, 192, 647, -1);
        SDKString sDKString = StateMenu_casNameString;
        int n6 = GameConstants.TextHandler_getStringWidth(sDKString, 1);
        int n7 = 24 + (192 - n6 >> 1);
        int n8 = n5 - 16;
        int n9 = GameConstants.TextHandler_getLineHeight(1) - 2;
        GameConstants.TextHandler_drawString(sDKString, 1, n7, n8, 20);
        int n10 = -1;
        if (StateMenu_m_isCharSelected || StateMenu_m_charSelectedTime / 750 % 2 == 1) {
            n10 = StateMenu_m_cursorPosition;
        }
        if (n10 != -1) {
            n2 = 5;
            int n11 = n7;
            if (sDKString != null) {
                n11 += SDKUtils.getSubStringSize(sDKString, 0, n10);
                if (n10 != Main.getSimNameLength()) {
                    n2 = SDKUtils.getSubStringSize(sDKString, n10, 1);
                }
            }
            n = n8 + n9;
            AnimationManager.setColor(0);
            Debug.PMGraphics_fillRect(n11, n, n2, 1);
        }
        n2 = Main.m_simData.getPersonaDescString(Main.m_simData.getPersona());
        Debug.UserInterface_drawTitleBox(24, n4, 192, n3, n2, 1);
        n = n4 + 21;
        int n12 = Debug.UserInterface_m_uiTextHeight * 5 + 6;
        Debug.UserInterface_drawDescBox(27, n, 186, n12);
        int n13 = n + 3 + 1;
        int n14 = 0;
        while (true) {
            if (n14 >= 5) break;
            int n15 = Main.m_simData.getSimTrait(0, n14);
            short s = Main.m_simData.getTraitDescString(n15);
            GameConstants.TextHandler_drawString(s, 1, 120, n13, 17);
            n13 += Debug.UserInterface_m_uiTextHeight;
            ++n14;
        }
        Main.renderSoftkeyBar();
    }

    public static final void PMRandom_init(int n) {
        PMRandom_seed = n;
    }

    public static final int PMRandom_get() {
        PMRandom_seed = PMRandom_seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(PMRandom_seed >>> 40);
    }

    public static SDKImage PMImage_loadImage(String string, String string2) {
        return GlobalConstants.PMImage_loadImage(Cursor.PMFile_calcCRC(string), Cursor.PMFile_calcCRC(string2));
    }

    public static SDKImage PMImage_loadImage(short s, short s2) {
        return GlobalConstants.PMImage_loadImage(s, (int)s2);
    }

    public static SDKImage PMImage_loadImage(short s, int n) {
        SDKImage sDKImage = null;
        byte[] byArray = Cursor.PMFile_fileToConstByteArray(s);
        if (byArray == null) {
            return null;
        }
        sDKImage = SDKUtils.createImage(byArray, 0, byArray.length);
        IStringConstants.PMSystem_sleep(10L);
        return sDKImage;
    }

    static {
        StateMenu_m_state = 0;
        StateMenu_m_afterFadeState = 0;
        StateMenu_m_nextSceneState = -1;
        StateMenu_m_mainMenuLast = -1;
        StateMenu_m_tempInt4 = new int[4];
        StateMenu_helpMenuText = new int[]{75, 88, 92, 90, 84, 82, 86, 80};
        StateMenu_helpMenuTitle = new int[]{74, 87, 91, 89, 83, 81, 85, 79};
        StateMenu_BUTTON_STRINGS = new short[]{624, 625, 626, 627, 628, 629, 630, 631, 632, 633, 634, 635, 636};
        StateMenu_m_palSources = new int[32];
        StateMenu_m_palPatches = new int[32];
        StateMenu_GRAD_CAS_LIST = new int[]{11, 12, 13, 14, 15, 14, 13, 12, 11};
        StateMenu_GRAD_CAS_SKY = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30};
        StateMenu_GRAD_CAS_GROUND = new int[]{31, 32, 33, 34, 35, 36, 37, 38, 39};
        StateMenu_SELECT_LETTERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }
}

