/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.skeleton.AnimationManager;

public class AnimPlayer {
    private int m_animID = -1;
    private int m_currentFrame = 0;
    private int m_currentFrameTime = 0;
    private int m_flags = 0;

    public final boolean updateAnim(int n) {
        if ((this.m_flags & 2) == 0) {
            return false;
        }
        this.m_currentFrameTime += n;
        if (this.m_currentFrameTime > AnimationManager.getAnimFrameDuration(this.m_animID, this.m_currentFrame)) {
            if ((this.m_flags & 8) != 0) {
                this.prevFrame();
                return true;
            }
            this.nextFrame();
            return true;
        }
        return false;
    }

    public final void nextFrame() {
        this.m_currentFrameTime -= AnimationManager.getAnimFrameDuration(this.m_animID, this.m_currentFrame);
        if (this.m_currentFrameTime < 0) {
            this.m_currentFrameTime = 0;
        }
        ++this.m_currentFrame;
        if (this.m_currentFrame >= AnimationManager.getAnimFrameCount(this.m_animID)) {
            if ((this.m_flags & 4) != 0) {
                this.m_currentFrame = 0;
            } else {
                this.m_currentFrame = AnimationManager.getAnimFrameCount(this.m_animID) - 1;
                this.m_flags &= 0xFFFFFFFD;
            }
        }
    }

    public final void prevFrame() {
        this.m_currentFrameTime -= AnimationManager.getAnimFrameDuration(this.m_animID, this.m_currentFrame);
        if (this.m_currentFrameTime < 0) {
            this.m_currentFrameTime = 0;
        }
        --this.m_currentFrame;
        if (this.m_currentFrame <= 0) {
            if ((this.m_flags & 4) != 0) {
                this.m_currentFrame = AnimationManager.getAnimFrameCount(this.m_animID) - 1;
            } else {
                this.m_currentFrame = 0;
                this.m_flags &= 0xFFFFFFFD;
            }
        }
    }

    public void startAnim(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = (n2 & 0x10) != 0;
        if (bl || this.m_animID != n) {
            this.m_animID = n;
            this.m_currentFrame = (this.m_flags & 8) != 0 ? AnimationManager.getAnimFrameCount(this.m_animID) - 1 : 0;
            this.m_currentFrameTime = 0;
        } else if (this.m_currentFrame >= AnimationManager.getAnimFrameCount(this.m_animID)) {
            this.m_currentFrame = 0;
        } else if (this.m_currentFrame < 0) {
            this.m_currentFrame = AnimationManager.getAnimFrameCount(this.m_animID) - 1;
        }
        this.m_flags = 3 | n2 & 4;
    }

    public final void drawAnim(int n, int n2) {
        if (this.m_animID >= 0) {
            AnimationManager.drawAnimFrame(this.m_animID, this.m_currentFrame, n, n2);
        }
    }

    public final int getAnimID() {
        return this.m_animID;
    }

    public final int getCurrAnimFrame() {
        return this.m_currentFrame;
    }

    public final int getNumFirePointsCurrFrame() {
        return AnimationManager.getAnimFrameFirePointCount(this.m_animID, this.m_currentFrame);
    }

    public final boolean getFirePointCurrFrame(int[] nArray, int n) {
        return AnimationManager.getAnimFrameFirePoint(nArray, this.m_animID, this.m_currentFrame, n);
    }

    public final boolean isAnimating() {
        return (this.m_flags & 2) != 0;
    }

    public final void setAnimating(boolean bl) {
        this.m_flags = bl ? (this.m_flags |= 2) : (this.m_flags &= 0xFFFFFFFD);
    }
}

