/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKString;
import dk.progressivemedia.skeleton.ArrayHandler;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.IStringConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.TileMap;
import dk.progressivemedia.skeleton.state.StateInGame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SimWorld {
    public final int ATTRIBUTE_LAYER_SIZE;
    public final int TILEMAP_WIDTH;
    public final int TILEMAP_HEIGHT;
    private byte[] d_objectParents;
    private short[] d_objectStringIds;
    private short[] d_objectActionIcons;
    private int[] d_objectFlags;
    private short[] d_objectNeeds;
    private short[] d_objectBuyPrices;
    private short[] d_objectSellPrices;
    private byte[] d_objectFootprintWidths;
    private byte[] d_objectFootprintHeights;
    private short[] d_objectAnimIds;
    private short[][] d_objectAnimSetIds;
    private byte[] d_objectInterestPointXs;
    private byte[] d_objectInterestPointYs;
    private short[] d_objectActions;
    private short[] d_objectActionOffsets;
    private short[] d_animSetIndexes;
    private short[][] d_appearances;
    private byte[][] d_tileArrays;
    private short[] d_itemDescStringIds;
    private short[] d_itemIcons;
    private int[] d_itemFlags;
    private short[] d_itemBuyPrices;
    private short[] d_itemSellPrices;
    private byte[] d_itemMaxInventory;
    private byte[] d_recipeItems;
    private byte[] d_recipeReplenishes;
    private short[][] d_recipeIngredients;
    private short[] d_houseMacroObjects;
    private byte[][] d_houseRoomXs;
    private byte[][] d_houseRoomYs;
    private byte[][] d_houseRoomWidths;
    private byte[][] d_houseRoomHeights;
    private byte[][] d_houseRoomFloors;
    private byte[][] d_houseRoomWalls;
    private byte[][] d_houseDoorXs;
    private byte[][] d_houseDoorYs;
    private byte[][] d_houseDoorWidths;
    private byte[][] d_houseObjectXs;
    private byte[][] d_houseObjectZs;
    private short[][] d_houseObjectTypes;
    private byte[][] d_houseObjectFacingDirs;
    public static final int[][] TRAVELLING_PRICES = new int[][]{{0, 225, 250, 310, 0}, {225, 0, 200, 320, 0}, {250, 200, 0, 325, 0}, {310, 320, 325, 0, 0}, {340, 315, 280, 250, 0}};
    public static final int[][] LOCATION_SPAWNPOINTS = new int[][]{{3}, {43, 46, 3}, {3}, {51, 50, 3}};
    private int m_houseIndex;
    public int[] currentAirportSims = new int[1];
    public boolean showAirportWelcomeMessage;
    public boolean isLocationMinigameAvailable = true;
    public byte[] m_playerHouseObjectXs;
    public byte[] m_playerHouseObjectZs;
    public short[] m_playerHouseObjectTypes;
    public byte[] m_playerHouseObjectFacingDirs;
    private int m_viewportX;
    private int m_viewportY;
    private int m_viewportWidth;
    private int m_viewportHeight;
    public int potentialVisitor = -1;
    public static final int[] ROTATION_FLAGS = new int[]{256, 512, 1024, 2048};
    private int m_screenOffsetX;
    private int m_screenOffsetY;
    private int m_screenOffsetXF;
    private int m_screenOffsetYF;
    private int m_attribWidth;
    private int m_attribHeight;
    private int m_attribOffsetX;
    private int m_attribOffsetZ;
    private byte[] m_attributesLayer;
    private TileMap m_tileMap;
    private TileMap m_tileMapWalls;
    private int m_cameraPosX;
    private int m_cameraPosZ;
    private int[][] d_patches;
    private byte[][] d_pals;
    private int m_pathStartX;
    private int m_pathStartY;
    private int m_pathDestX;
    private int m_pathDestY;
    private int[] m_pathAvoidTiles;
    private int m_pathNumAvoidTiles;
    private int m_pathOffsetX;
    private int m_pathOffsetY;
    private short[] m_pathOpenList;
    private int m_pathOpenCount;
    private long[] m_pathClosedLookup;
    private short[][] m_pathParentArray;
    private int[][] m_pathFCost;
    private int[][] m_pathGCost;
    private int[][] m_pathHCost;
    private short[] m_pathList;
    private int m_pathFlags;

    public SimWorld() {
        this.ATTRIBUTE_LAYER_SIZE = 64;
        this.TILEMAP_WIDTH = 64;
        this.TILEMAP_HEIGHT = 64;
        this.initWorld();
        this.initHouses();
        this.initColors();
        this.pathInit();
    }

    private void initWorld() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Intro.ResourceManager_loadBinaryFile(67);
        int n10 = Cursor.PMFile_readShort();
        this.d_objectParents = new byte[n10];
        this.d_objectStringIds = new short[n10];
        this.d_objectActionIcons = new short[n10];
        this.d_objectFlags = new int[n10];
        this.d_objectNeeds = new short[n10];
        this.d_objectBuyPrices = new short[n10];
        this.d_objectSellPrices = new short[n10];
        this.d_objectFootprintWidths = new byte[n10];
        this.d_objectFootprintHeights = new byte[n10];
        this.d_objectAnimIds = new short[n10];
        this.d_objectAnimSetIds = new short[n10][];
        this.d_objectActions = new short[n10 * 5];
        this.d_objectActionOffsets = new short[n10 + 1];
        this.d_objectInterestPointXs = new byte[n10 * 5];
        this.d_objectInterestPointYs = new byte[n10 * 5];
        for (n9 = 0; n9 < n10; ++n9) {
            this.d_objectParents[n9] = Cursor.PMFile_readByte();
            this.d_objectStringIds[n9] = Main.lookupSimsWorld();
            this.d_objectActionIcons[n9] = Main.lookupSimsWorld();
            this.d_objectFlags[n9] = Cursor.PMFile_readInt();
            this.d_objectNeeds[n9] = Main.lookupSimsWorld();
            if (this.d_objectNeeds[n9] == -1) {
                this.d_objectNeeds[n9] = 0;
            }
            this.d_objectBuyPrices[n9] = Cursor.PMFile_readShort();
            this.d_objectSellPrices[n9] = Cursor.PMFile_readShort();
            this.d_objectFootprintWidths[n9] = Cursor.PMFile_readByte();
            this.d_objectFootprintHeights[n9] = Cursor.PMFile_readByte();
            this.d_objectAnimIds[n9] = Main.lookupSimsWorld();
            n8 = Cursor.PMFile_readByte();
            this.d_objectAnimSetIds[n9] = new short[n8];
            for (n7 = 0; n7 < n8; ++n7) {
                this.d_objectAnimSetIds[n9][n7] = Cursor.PMFile_readShort();
            }
            n7 = Cursor.PMFile_readByte();
            n6 = n9 * 5;
            this.d_objectInterestPointXs[n6] = (byte)n7;
            this.d_objectInterestPointYs[n6] = (byte)n7;
            for (n5 = 1; n5 <= n7; ++n5) {
                this.d_objectInterestPointXs[n6 + n5] = Cursor.PMFile_readByte();
                this.d_objectInterestPointYs[n6 + n5] = Cursor.PMFile_readByte();
            }
            n5 = Cursor.PMFile_readByte();
            n4 = this.d_objectActionOffsets[n9];
            this.d_objectActionOffsets[n9 + 1] = (short)(n4 + n5);
            for (n3 = 0; n3 < n5; ++n3) {
                this.d_objectActions[n4 + n3] = Main.lookupSimsWorld();
            }
        }
        this.d_objectAnimSetIds = ArrayOptimizer.Optimize(this.d_objectAnimSetIds);
        n9 = Cursor.PMFile_readShort();
        n8 = n9 << 2;
        this.d_animSetIndexes = new short[n8];
        for (n7 = 0; n7 < n8; ++n7) {
            this.d_animSetIndexes[n7] = Main.lookupSimsWorld();
        }
        n7 = Cursor.PMFile_readByte();
        this.d_appearances = new short[n7][];
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = Cursor.PMFile_readByte();
            n4 = n5 << 1;
            this.d_appearances[n6] = new short[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.d_appearances[n6][n3] = Cursor.PMFile_readShort();
            }
        }
        this.d_appearances = ArrayOptimizer.Optimize(this.d_appearances);
        n6 = Cursor.PMFile_readByte();
        n5 = Cursor.PMFile_readByte();
        n4 = Cursor.PMFile_readByte();
        this.d_tileArrays = new byte[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = Cursor.PMFile_readByte();
            this.d_tileArrays[n3] = new byte[n2];
            for (n = 0; n < n2; ++n) {
                this.d_tileArrays[n3][n] = Cursor.PMFile_readByte();
            }
        }
        this.d_tileArrays = ArrayOptimizer.Optimize(this.d_tileArrays);
        n3 = Cursor.PMFile_readByte();
        this.d_itemDescStringIds = new short[n3];
        this.d_itemIcons = new short[n3];
        this.d_itemFlags = new int[n3];
        this.d_itemBuyPrices = new short[n3];
        this.d_itemSellPrices = new short[n3];
        this.d_itemMaxInventory = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.d_itemDescStringIds[n2] = Main.lookupSimsWorld();
            this.d_itemIcons[n2] = Main.lookupSimsWorld();
            this.d_itemFlags[n2] = Cursor.PMFile_readInt();
            this.d_itemBuyPrices[n2] = Cursor.PMFile_readShort();
            this.d_itemSellPrices[n2] = Cursor.PMFile_readShort();
            this.d_itemMaxInventory[n2] = Cursor.PMFile_readByte();
        }
        n2 = Cursor.PMFile_readByte();
        this.d_recipeItems = new byte[n2];
        this.d_recipeReplenishes = new byte[n2];
        this.d_recipeIngredients = new short[n2][];
        for (n = 0; n < n2; ++n) {
            this.d_recipeItems[n] = Cursor.PMFile_readByte();
            this.d_recipeReplenishes[n] = Cursor.PMFile_readByte();
            int n11 = Cursor.PMFile_readByte();
            this.d_recipeIngredients[n] = new short[n11];
            for (int i = 0; i < n11; ++i) {
                this.d_recipeIngredients[n][i] = Cursor.PMFile_readByte();
            }
        }
        this.d_recipeIngredients = ArrayOptimizer.Optimize(this.d_recipeIngredients);
        Cursor.PMFile_closeFile();
    }

    private void initHouses() {
        Intro.ResourceManager_loadBinaryFile(65);
        int n = Cursor.PMFile_readByte();
        this.d_houseMacroObjects = new short[n];
        this.d_houseRoomXs = new byte[n][];
        this.d_houseRoomYs = new byte[n][];
        this.d_houseRoomWidths = new byte[n][];
        this.d_houseRoomHeights = new byte[n][];
        this.d_houseRoomFloors = new byte[n][];
        this.d_houseRoomWalls = new byte[n][];
        this.d_houseDoorXs = new byte[n][];
        this.d_houseDoorYs = new byte[n][];
        this.d_houseDoorWidths = new byte[n][];
        this.d_houseObjectXs = new byte[n][];
        this.d_houseObjectZs = new byte[n][];
        this.d_houseObjectTypes = new short[n][];
        this.d_houseObjectFacingDirs = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            this.d_houseMacroObjects[i] = Main.lookupSimsHouses();
            int n4 = Cursor.PMFile_readByte();
            this.d_houseRoomXs[i] = new byte[n4];
            this.d_houseRoomYs[i] = new byte[n4];
            this.d_houseRoomWidths[i] = new byte[n4];
            this.d_houseRoomHeights[i] = new byte[n4];
            this.d_houseRoomFloors[i] = new byte[n4];
            this.d_houseRoomWalls[i] = new byte[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                this.d_houseRoomXs[i][n3] = Cursor.PMFile_readByte();
                this.d_houseRoomYs[i][n3] = Cursor.PMFile_readByte();
                this.d_houseRoomWidths[i][n3] = Cursor.PMFile_readByte();
                this.d_houseRoomHeights[i][n3] = Cursor.PMFile_readByte();
                this.d_houseRoomFloors[i][n3] = (byte)Main.lookupSimsHouses();
                this.d_houseRoomWalls[i][n3] = (byte)Main.lookupSimsHouses();
            }
            n3 = Cursor.PMFile_readByte();
            this.d_houseDoorXs[i] = new byte[n3];
            this.d_houseDoorYs[i] = new byte[n3];
            this.d_houseDoorWidths[i] = new byte[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.d_houseDoorXs[i][n2] = Cursor.PMFile_readByte();
                this.d_houseDoorYs[i][n2] = Cursor.PMFile_readByte();
                this.d_houseDoorWidths[i][n2] = Cursor.PMFile_readByte();
            }
            n2 = Cursor.PMFile_readShort();
            this.d_houseObjectXs[i] = new byte[n2];
            this.d_houseObjectZs[i] = new byte[n2];
            this.d_houseObjectTypes[i] = new short[n2];
            this.d_houseObjectFacingDirs[i] = new byte[n2];
            for (int j = 0; j < n2; ++j) {
                this.d_houseObjectXs[i][j] = Cursor.PMFile_readByte();
                this.d_houseObjectZs[i][j] = Cursor.PMFile_readByte();
                this.d_houseObjectTypes[i][j] = Main.lookupSimsHouses();
                this.d_houseObjectFacingDirs[i][j] = (byte)Main.lookupSimsHouses();
            }
        }
        Cursor.PMFile_closeFile();
        this.d_houseRoomXs = ArrayOptimizer.Optimize(this.d_houseRoomXs);
        this.d_houseRoomYs = ArrayOptimizer.Optimize(this.d_houseRoomYs);
        this.d_houseRoomWidths = ArrayOptimizer.Optimize(this.d_houseRoomWidths);
        this.d_houseRoomHeights = ArrayOptimizer.Optimize(this.d_houseRoomHeights);
        this.d_houseRoomFloors = ArrayOptimizer.Optimize(this.d_houseRoomFloors);
        this.d_houseRoomWalls = ArrayOptimizer.Optimize(this.d_houseRoomWalls);
        this.d_houseDoorXs = ArrayOptimizer.Optimize(this.d_houseDoorXs);
        this.d_houseDoorYs = ArrayOptimizer.Optimize(this.d_houseDoorYs);
        this.d_houseDoorWidths = ArrayOptimizer.Optimize(this.d_houseDoorWidths);
        this.d_houseObjectXs = ArrayOptimizer.Optimize(this.d_houseObjectXs);
        this.d_houseObjectZs = ArrayOptimizer.Optimize(this.d_houseObjectZs);
        this.d_houseObjectTypes = ArrayOptimizer.Optimize(this.d_houseObjectTypes);
        this.d_houseObjectFacingDirs = ArrayOptimizer.Optimize(this.d_houseObjectFacingDirs);
    }

    public int getHouseId() {
        return this.m_houseIndex;
    }

    public int getHouseMacroObject(int n) {
        return this.d_houseMacroObjects[n];
    }

    public int getHouseForObject(int n) {
        return ArrayHandler.indexOf(n, this.d_houseMacroObjects);
    }

    public void initPlayerHouse() {
        if (this.m_playerHouseObjectXs == null) {
            this.m_playerHouseObjectXs = new byte[200];
            this.m_playerHouseObjectZs = new byte[200];
            this.m_playerHouseObjectTypes = new short[200];
            this.m_playerHouseObjectFacingDirs = new byte[200];
        }
        ArrayHandler.fillArray(this.m_playerHouseObjectTypes, -1);
        byte[] byArray = this.d_houseObjectXs[0];
        byte[] byArray2 = this.d_houseObjectZs[0];
        short[] sArray = this.d_houseObjectTypes[0];
        byte[] byArray3 = this.d_houseObjectFacingDirs[0];
        System.arraycopy(byArray, 0, this.m_playerHouseObjectXs, 0, byArray.length);
        System.arraycopy(byArray2, 0, this.m_playerHouseObjectZs, 0, byArray2.length);
        System.arraycopy(sArray, 0, this.m_playerHouseObjectTypes, 0, sArray.length);
        System.arraycopy(byArray3, 0, this.m_playerHouseObjectFacingDirs, 0, byArray3.length);
    }

    public int objectBuy(int n, int n2, int n3, int n4) {
        Debug.ASSERT(this.getHouseId() == 0, "buying at non-home house");
        int n5 = ArrayHandler.indexOf(-1, this.m_playerHouseObjectTypes);
        Debug.ASSERT(n5 != -1, "out of house object slots");
        this.m_playerHouseObjectTypes[n5] = (short)n;
        this.m_playerHouseObjectXs[n5] = (byte)this.coordWorldToWorldTileX(n2);
        this.m_playerHouseObjectZs[n5] = (byte)this.coordWorldToWorldTileZ(n3);
        this.m_playerHouseObjectFacingDirs[n5] = (byte)n4;
        return n5;
    }

    public void objectSell(int n) {
        Debug.ASSERT(this.getHouseId() == 0, "selling at non-home house");
        this.m_playerHouseObjectTypes[n] = -1;
        this.m_playerHouseObjectXs[n] = 0;
        this.m_playerHouseObjectZs[n] = 0;
        this.m_playerHouseObjectFacingDirs[n] = -1;
        Main.m_simData.removeObjectValue(0, n);
    }

    public void resetRMSGameData() {
        this.initPlayerHouse();
    }

    public void loadRMSGameData(DataInputStream dataInputStream) throws IOException {
        for (int i = 0; i < this.m_playerHouseObjectTypes.length; ++i) {
            this.m_playerHouseObjectTypes[i] = dataInputStream.readShort();
            this.m_playerHouseObjectXs[i] = dataInputStream.readByte();
            this.m_playerHouseObjectZs[i] = dataInputStream.readByte();
            this.m_playerHouseObjectFacingDirs[i] = dataInputStream.readByte();
        }
    }

    public void saveRMSGameData(DataOutputStream dataOutputStream) throws IOException {
        for (int i = 0; i < this.m_playerHouseObjectTypes.length; ++i) {
            dataOutputStream.writeShort(this.m_playerHouseObjectTypes[i]);
            dataOutputStream.writeByte(this.m_playerHouseObjectXs[i]);
            dataOutputStream.writeByte(this.m_playerHouseObjectZs[i]);
            dataOutputStream.writeByte(this.m_playerHouseObjectFacingDirs[i]);
        }
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.m_viewportX = n;
        this.m_viewportY = n2;
        this.m_viewportWidth = n3;
        this.m_viewportHeight = n4;
    }

    public int getViewportX() {
        return this.m_viewportX;
    }

    public int getViewportY() {
        return this.m_viewportY;
    }

    public int getViewportWidth() {
        return this.m_viewportWidth;
    }

    public int getViewportHeight() {
        return this.m_viewportHeight;
    }

    private void prepareWorld() {
        this.m_attribWidth = 64;
        this.m_attribHeight = 64;
        this.m_attribOffsetX = this.m_attribWidth >> 1;
        this.m_attribOffsetZ = this.m_attribHeight >> 1;
        this.m_screenOffsetX = 512;
        this.m_screenOffsetXF = this.m_screenOffsetX << 16;
        this.m_screenOffsetY = 264;
        this.m_screenOffsetYF = this.m_screenOffsetY << 16;
        if (this.m_attributesLayer == null) {
            this.m_attributesLayer = new byte[this.m_attribWidth * this.m_attribHeight];
        }
        ArrayHandler.fillArray(this.m_attributesLayer, 0);
    }

    public void prepareWorldHouse(int n) {
        StateInGame.raining = false;
        this.showAirportWelcomeMessage = true;
        this.m_houseIndex = n;
        this.prepareWorld();
        this.prepareWorldHouse2D(n);
        this.createObjectsHouse(n);
        this.potentialVisitor = n == 0 ? Main.m_simData.determinePotentialVisitor() : -1;
    }

    public void createObjectsHouse(int n) {
        int n2;
        byte[] byArray = this.d_houseObjectXs[n];
        byte[] byArray2 = this.d_houseObjectZs[n];
        short[] sArray = this.d_houseObjectTypes[n];
        byte[] byArray3 = this.d_houseObjectFacingDirs[n];
        if (this.getHouseId() == 0) {
            byArray = this.m_playerHouseObjectXs;
            byArray2 = this.m_playerHouseObjectZs;
            sArray = this.m_playerHouseObjectTypes;
            byArray3 = this.m_playerHouseObjectFacingDirs;
        }
        for (n2 = 0; n2 < sArray.length; ++n2) {
            if (sArray[n2] == -1) continue;
            StateInGame.createObjectOnWorldTile(sArray[n2], byArray[n2], byArray2[n2], byArray3[n2], n2);
        }
        n2 = this.getHouseId() == 0 || StateInGame.m_mapModePrev == 0 ? 2 : 3;
        int n3 = -1;
        n3 = ArrayHandler.indexOf(n2, sArray);
        Debug.ASSERT(n3 >= 0, "no player start");
        byte by = byArray[n3];
        int n4 = byArray2[n3];
        int n5 = 0;
        byte by2 = byArray3[n3];
        StateInGame.createObjectOnWorldTile(n5, by, n4, by2, 0);
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        for (n4 = 0; n4 < mapObjectSimArray.length; ++n4) {
            if (mapObjectSimArray[n4].getType() == 0) continue;
            mapObjectSimArray[n4].destroy();
        }
        n4 = n2 == 2 ? n3 : -1;
        int n6 = Main.m_simData.getSimCount();
        if (Main.isForeignAirport(this.getHouseId())) {
            if (StateInGame.m_mapModePrev == 0) {
                int n7 = 1;
                for (int i = 1; i < n6 && StateInGame.nextAvailableBank() != -1; ++i) {
                    MapObject mapObject;
                    byte by3;
                    MapObjectSim mapObjectSim;
                    int n8 = Main.rand(1, n6 - 1);
                    boolean bl = false;
                    if (this.doesThisSimExistAlready(n8)) continue;
                    if (!Main.m_simData.hasSimGotFlag(n8, Main.fromAirportToLocationFlag(this.getHouseId())) && n7 > 0) {
                        this.currentAirportSims[--n7] = n8;
                        bl = true;
                    } else if (n7 == 0) break;
                    if (!bl || (mapObjectSim = (MapObjectSim)StateInGame.createObjectOnWorldTile(1, n5 = byArray[n4 = ArrayHandler.indexOfWrap(2, sArray, Main.rand(0, sArray.length - 1))], by2 = byArray2[n4], by3 = byArray3[n4], n8)) == null || !mapObjectSim.isIdle() || (mapObject = StateInGame.findRandomMapDestination()).getClosestInterestPoint(mapObjectSim.getPosX(), mapObjectSim.getPosZ(), false, null) == -1) continue;
                    mapObjectSim.beginSimAction(76, mapObject);
                }
            } else {
                int n9 = this.currentAirportSims.length / 2;
                if (this.currentAirportSims.length % 2 == 1) {
                    ++n9;
                }
                for (int i = 0; i < n9 && StateInGame.nextAvailableBank() != -1; ++i) {
                    MapObject mapObject;
                    byte by4;
                    n4 = ArrayHandler.indexOfWrap(2, sArray, Main.rand(0, sArray.length - 1));
                    n5 = byArray[n4];
                    MapObjectSim mapObjectSim = (MapObjectSim)StateInGame.createObjectOnWorldTile(1, n5, by2 = byArray2[n4], by4 = byArray3[n4], this.currentAirportSims[i]);
                    if (mapObjectSim == null || !mapObjectSim.isIdle() || (mapObject = StateInGame.findRandomMapDestination()).getClosestInterestPoint(mapObjectSim.getPosX(), mapObjectSim.getPosZ(), false, null) == -1) continue;
                    mapObjectSim.beginSimAction(76, mapObject);
                }
            }
        } else if (this.getHouseId() == 8) {
            int n10 = 1;
            int n11 = 0;
            for (int i = 1; i < n6 && StateInGame.nextAvailableBank() != -1; ++i) {
                MapObject mapObject;
                int n12 = Main.rand(1, n6 - 1);
                boolean bl = false;
                if (this.doesThisSimExistAlready(n12)) continue;
                if (Main.m_simData.getSimHome(n12) != -1 && n10 > 0) {
                    --n10;
                    bl = true;
                } else if (Main.m_simData.getSimHome(n12) == -1 && n11 > 0) {
                    --n11;
                    bl = true;
                } else if (n10 == 0 && n11 == 0) break;
                if (!bl) continue;
                Event.PMDebug_println(2, "--> Spawning sim with id = {0}", n12);
                n4 = ArrayHandler.indexOfWrap(2, sArray, Main.rand(0, sArray.length - 1));
                n5 = byArray[n4];
                by2 = byArray2[n4];
                byte by5 = byArray3[n4];
                MapObjectSim mapObjectSim = (MapObjectSim)StateInGame.createObjectOnWorldTile(1, n5, by2, by5, n12);
                if (mapObjectSim == null || !mapObjectSim.isIdle() || (mapObject = StateInGame.findRandomMapDestination()).getClosestInterestPoint(mapObjectSim.getPosX(), mapObjectSim.getPosZ(), false, null) == -1) continue;
                mapObjectSim.beginSimAction(76, mapObject);
            }
        } else {
            for (int i = 1; i < n6; ++i) {
                if (Main.m_simData.getSimHome(i) != n) continue;
                int n13 = Main.m_simData.getTimeFlags(i);
                if ((n13 & 8) == 0) continue;
                n4 = n2 == 2 ? ArrayHandler.indexOf(3, sArray, 0) : ArrayHandler.indexOf(2, sArray, n4 + 1);
                Debug.ASSERT(n4 >= 0, "no NPC start");
                if (n4 < 0) continue;
                n5 = byArray[n4];
                by2 = byArray2[n4];
                int n14 = 1;
                byte by6 = byArray3[n4];
                MapObjectSim mapObjectSim = (MapObjectSim)StateInGame.createObjectOnWorldTile(n14, n5, by2, by6, i);
                if ((n13 & 0x10) == 0 || Main.randPercent() >= 30) continue;
                StateInGame.putSimInBed(mapObjectSim);
            }
        }
    }

    public boolean doesThisSimExistAlready(int n) {
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        for (int i = 0; i < mapObjectSimArray.length; ++i) {
            if (mapObjectSimArray[i].getId() != n) continue;
            return true;
        }
        return false;
    }

    public boolean isAgainstWall(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        block5: {
            block4: {
                bl = true;
                if (n5 != 0 && n5 != 2) break block4;
                int n6 = 1;
                if (n5 == 2) {
                    n6 = -1;
                }
                int n7 = n - n3 * n6;
                int n8 = n2;
                for (int i = 0; i < n4 && bl; ++i) {
                    bl = (this.getAttribute(n7, n8 - i * n6) & 0x40) != 0;
                }
                break block5;
            }
            if (n5 != 1 && n5 != 3) break block5;
            int n9 = 1;
            if (n5 == 3) {
                n9 = -1;
            }
            int n10 = n;
            int n11 = n2 - n3 * n9;
            for (int i = 0; i < n4 && bl; ++i) {
                bl = (this.getAttribute(n10 - i * n9, n11) & 0x40) != 0;
            }
        }
        return bl;
    }

    public void prepareWorldZoomMap(int n) {
        int n2;
        int n3;
        this.prepareWorld();
        switch (n) {
            case 57: {
                n3 = 44;
                break;
            }
            case 58: {
                n3 = 45;
                StateInGame.raining = false;
                break;
            }
            case 60: {
                n3 = 47;
                break;
            }
            case 61: {
                n3 = 48;
                break;
            }
            case 62: {
                n3 = 49;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        SDKImage sDKImage = Intro.ResourceManager_loadImage(n3);
        TileMap tileMap = new TileMap(n, sDKImage);
        tileMap.setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
        tileMap.setUseOffscreenBuffer(true);
        this.m_tileMap = tileMap;
        this.initAttributesZoomMap(n);
        this.createObjectsFromTilemap(true);
        MapObject mapObject = StateInGame.findRandomObjectByType(3);
        Debug.ASSERT(mapObject != null, "no start point!");
        int n4 = this.coordWorldToWorldTileX(mapObject.getPosX());
        int n5 = this.coordWorldToWorldTileZ(mapObject.getPosZ());
        StateInGame.createObjectOnWorldTile(0, n4, n5, 3, 0);
        MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
        for (n2 = 0; n2 < mapObjectSimArray.length; ++n2) {
            if (mapObjectSimArray[n2].getType() == 0) continue;
            mapObjectSimArray[n2].destroy();
        }
        n2 = Main.getEncounterNPCId();
        if (n2 != -1) {
            MapObject mapObject2 = StateInGame.createObjectOnWorldTile(1, n4, n5 - 1, 1, n2);
            Cursor.setCursorObject(mapObject2);
            StateInGame.showContextMenu(mapObject2);
        } else {
            int n6 = 3;
            int[] nArray = LOCATION_SPAWNPOINTS[Main.fromZoommapToLocationIndex(n)];
            int n7 = Main.fromZoommapToLocationFlag(n);
            if (n7 > 0) {
                int n8 = 100 / nArray.length;
                for (int i = 1; i < Main.m_simData.getSimCount() && StateInGame.nextAvailableBank() != -1; ++i) {
                    MapObject mapObject3;
                    MapObject mapObject4;
                    MapObjectSim mapObjectSim;
                    int n9 = i;
                    n9 = Main.rand(1, Main.m_simData.getSimCount() - 1);
                    if (!Main.m_simData.hasSimGotFlag(n9, n7)) continue;
                    int n10 = Main.randPercent();
                    int n11 = 0;
                    int n12 = n8;
                    while (n12 < 100) {
                        if (n10 < n12) {
                            n6 = nArray[n11];
                            break;
                        }
                        n12 += n8;
                        ++n11;
                    }
                    if ((mapObjectSim = (MapObjectSim)StateInGame.createObjectOnObjectInterestPoint(1, mapObject4 = StateInGame.findRandomObjectByType(n6), n9)) == null || !mapObjectSim.isIdle() || (mapObject3 = StateInGame.findRandomMapDestination()).getClosestInterestPoint(mapObjectSim.getPosX(), mapObjectSim.getPosZ(), false, null) == -1) continue;
                    mapObjectSim.beginSimAction(76, mapObject3);
                }
            }
            Cursor.setCursorObject(StateInGame.getPlayerSim());
        }
    }

    public void prepareWorldMacromap(boolean bl) {
        this.prepareWorld();
        int n = 46;
        SDKImage sDKImage = Intro.ResourceManager_loadImage(n);
        int n2 = 59;
        TileMap tileMap = new TileMap(n2, sDKImage);
        tileMap.setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
        tileMap.setUseOffscreenBuffer(true);
        this.m_tileMap = tileMap;
        this.initAttributesMacromap();
        this.createObjectsFromTilemap(false);
        if (bl) {
            int n3 = Main.m_simData.getCareerRabbitHole(Main.m_simData.getSimCareer(0));
            MapObject mapObject = StateInGame.findRandomObjectByType(n3);
            Debug.ASSERT(mapObject != null, "couldn't find workplace");
            StateInGame.createObjectOnObjectInterestPoint(0, mapObject, 0);
            StateInGame.startPlayerAction(133, mapObject, 0, 0);
        } else {
            int n4 = Main.getNextHouseId();
            if (n4 != -1) {
                int n5 = this.getHouseMacroObject(n4);
                MapObject mapObject = StateInGame.findRandomObjectByType(n5);
                StateInGame.createObjectOnObjectInterestPoint(0, mapObject, 0);
            } else {
                StateInGame.createObject(0, Main.getEncounterPlayerX(), Main.getEncounterPlayerZ(), 0, 0);
                int n6 = Main.getEncounterNPCId();
                if (n6 != -1) {
                    StateInGame.createObject(1, Main.getEncounterNPCX(), Main.getEncounterNPCZ(), 0, n6);
                }
                Main.setupEncounter(null);
            }
        }
    }

    private void createObjectsFromTilemap(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.m_tileMap.getObjectCount();
        short[] sArray = this.m_tileMap.getObjectData();
        for (n6 = 0; n6 < n7; ++n6) {
            int n8 = n6 * 3;
            n5 = sArray[n8 + 0];
            n4 = sArray[n8 + 1] << 16;
            n3 = sArray[n8 + 2] << 16;
            n2 = this.coordScreenToWorldX(n4, n3);
            n = this.coordScreenToWorldZ(n4, n3);
            if (bl) {
                n2 = this.coordWorldTileToWorldCenterX(this.coordWorldToWorldTileX(n2));
                n = this.coordWorldTileToWorldCenterZ(this.coordWorldToWorldTileZ(n));
            }
            StateInGame.createObject(n5, n2, n, 0, -1);
        }
        n6 = this.m_tileMap.getAnimCount();
        short[] sArray2 = this.m_tileMap.getAnimData();
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = n5 * 3;
            n3 = sArray2[n4 + 0];
            n2 = sArray2[n4 + 1] << 16;
            n = sArray2[n4 + 2] << 16;
            int n9 = this.coordScreenToWorldX(n2, n);
            int n10 = this.coordScreenToWorldZ(n2, n);
            if (bl) {
                n9 = this.coordWorldTileToWorldCenterX(this.coordWorldToWorldTileX(n9));
                n10 = this.coordWorldTileToWorldCenterZ(this.coordWorldToWorldTileZ(n10));
            }
            MapObject mapObject = StateInGame.createObject(34, n9, n10, 0, -1);
            mapObject.setAnim(n3);
        }
    }

    public void unload() {
        this.m_tileMap = null;
        this.m_tileMapWalls = null;
    }

    public void renderWorld() {
        this.renderWorld2D();
    }

    public int getCameraPixelX() {
        return this.m_viewportX + (this.m_viewportWidth >> 1) - (this.getCameraPosX() >> 16);
    }

    public int getCameraPixelY() {
        return this.m_viewportY + (this.m_viewportHeight >> 1) - (this.getCameraPosZ() >> 16);
    }

    public int coordWorldToScreenX(int n, int n2) {
        return (n - n2 << 1) + this.m_screenOffsetXF;
    }

    public int coordWorldToScreenY(int n, int n2) {
        return n + n2 + this.m_screenOffsetYF;
    }

    public int coordWorldToScreenPixelsX(int n, int n2) {
        return (n - n2 >> 15) + this.m_screenOffsetX;
    }

    public int coordWorldToScreenPixelsY(int n, int n2) {
        return (n + n2 >> 16) + this.m_screenOffsetY;
    }

    public int coordScreenToWorldX(int n, int n2) {
        return (n - this.m_screenOffsetXF >> 1) + (n2 - this.m_screenOffsetYF) >> 1;
    }

    public int coordScreenToWorldZ(int n, int n2) {
        return (-(n - this.m_screenOffsetXF) >> 1) + (n2 - this.m_screenOffsetYF) >> 1;
    }

    public int coordWorldTileToScreenTileX(int n, int n2) {
        return n - n2;
    }

    public int coordWorldTileToScreenTileY(int n, int n2) {
        return n + n2;
    }

    public int coordWorldTileToWorldCenterX(int n) {
        return (n << 19) + 262144;
    }

    public int coordWorldTileToWorldCenterZ(int n) {
        return (n << 19) + 262144;
    }

    public int coordWorldToWorldTileX(int n) {
        return n >> 19;
    }

    public int coordWorldToWorldTileZ(int n) {
        return n >> 19;
    }

    public boolean isWorldPointWalkable(int n, int n2) {
        return this.isWorldTileWalkable(this.coordWorldToWorldTileX(n), this.coordWorldToWorldTileZ(n2));
    }

    public boolean isWorldTileWalkable(int n, int n2) {
        int n3 = this.getAttribute(n, n2);
        return (n3 & 0x80) == 0;
    }

    public int getAttribute(int n, int n2) {
        if ((n += this.m_attribOffsetX) >= 0 && n < this.m_attribWidth && (n2 += this.m_attribOffsetZ) >= 0 && n2 < this.m_attribHeight) {
            int n3 = n + n2 * this.m_attribWidth;
            return this.m_attributesLayer[n3];
        }
        return 128;
    }

    private void setAttribute(int n, int n2, int n3, int n4) {
        if ((n += this.m_attribOffsetX) >= 0 && n < this.m_attribWidth && (n2 += this.m_attribOffsetZ) >= 0 && n2 < this.m_attribHeight) {
            byte[] byArray = this.m_attributesLayer;
            int n5 = n + n2 * this.m_attribWidth;
            int n6 = byArray[n5] & n3;
            byArray[n5] = (byte)(n6 | n4);
        }
    }

    public void paintAttributes(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = this.m_attribOffsetX + n; i < this.m_attribOffsetX + n + n3; ++i) {
            for (int j = this.m_attribOffsetZ + n2; j < this.m_attribOffsetZ + n2 + n4; ++j) {
                int n7 = i + j * this.m_attribWidth;
                int n8 = this.m_attributesLayer[n7] & n5;
                this.m_attributesLayer[n7] = (byte)(n8 | n6);
            }
        }
    }

    public TileMap getTileMap() {
        return this.m_tileMap;
    }

    private void renderWorld2D() {
        TileMap tileMap = this.m_tileMap;
        int n = Debug.PMGraphics_getClipX();
        int n2 = Debug.PMGraphics_getClipY();
        int n3 = Debug.PMGraphics_getClipWidth();
        int n4 = Debug.PMGraphics_getClipHeight();
        Debug.PMGraphics_setClip(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
        tileMap.setCameraX(this.getCameraPosX() - (this.m_viewportWidth >> 1 << 16));
        tileMap.setCameraY(this.getCameraPosZ() - (this.m_viewportHeight >> 1 << 16));
        tileMap.render();
        this.renderObjects2D();
        Debug.PMGraphics_setClip(n, n2, n3, n4);
    }

    /*
     * WARNING - void declaration
     */
    private void prepareWorldHouse2D(int n) {
        void var15_20;
        int n2;
        int n3;
        int n4;
        byte by;
        void var15_18;
        Object object;
        int n5;
        Object object2;
        int n6;
        Object object3;
        Object object4;
        if (this.m_tileMap == null) {
            object4 = Intro.ResourceManager_loadImage(49);
            object3 = new TileMap(64, 64, (SDKImage)object4);
            ((TileMap)object3).setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
            ((TileMap)object3).setUseOffscreenBuffer(true);
            this.m_tileMap = object3;
        }
        if (this.m_tileMapWalls == null) {
            object4 = Intro.ResourceManager_loadImage(50);
            this.m_tileMapWalls = object3 = new TileMap(64, 64, (SDKImage)object4);
            ((TileMap)object3).setViewport(this.m_viewportX, this.m_viewportY, this.m_viewportWidth, this.m_viewportHeight);
            this.m_tileMap.setLinkedTileMap((TileMap)object3);
        }
        object4 = this.d_houseRoomXs[n];
        object3 = this.d_houseRoomYs[n];
        byte[] byArray = this.d_houseRoomWidths[n];
        byte[] byArray2 = this.d_houseRoomHeights[n];
        byte[] byArray3 = this.d_houseRoomFloors[n];
        byte[] byArray4 = this.d_houseRoomWalls[n];
        byte[] byArray5 = this.d_houseDoorXs[n];
        byte[] byArray6 = this.d_houseDoorYs[n];
        byte[] byArray7 = this.d_houseDoorWidths[n];
        int n7 = ((Object)object4).length;
        int n8 = byArray5.length;
        for (n6 = 0; n6 < n7; ++n6) {
            object2 = object4[n6];
            Object object5 = object3[n6];
            n5 = byArray[n6];
            object = byArray2[n6];
            this.paintAttributes((int)object2, (int)object5, n5, (int)object, 255, n6 + 1 | 0x10);
            this.paintAttributes((int)(object2 - true), (int)(object5 - true), n5 + 2, 1, 255, 128);
            this.paintAttributes((int)(object2 - true), (int)(object5 + object), n5 + 2, 1, 255, 128);
            this.paintAttributes((int)(object2 - true), (int)object5, 1, (int)object, 255, 128);
            this.paintAttributes((int)(object2 + n5), (int)object5, 1, (int)object, 255, 128);
        }
        for (n6 = 0; n6 < n8; ++n6) {
            object2 = byArray5[n6];
            byte by2 = byArray6[n6];
            n5 = Math.abs(byArray7[n6]);
            if ((this.getAttribute((int)(object2 - true), by2) & 0x80) != 0) {
                this.paintAttributes((int)object2, by2, n5, 1, -129, 0);
                continue;
            }
            this.paintAttributes((int)object2, by2, 1, n5, -129, 0);
            byArray7[n6] = (byte)(-n5);
        }
        if (Main.getNextHouseId() == 6) {
            ArrayHandler.fillArray(this.m_tileMap.getTileMapData(), 107);
        } else {
            ArrayHandler.fillArray(this.m_tileMap.getTileMapData(), 16);
        }
        ArrayHandler.fillArray(this.m_tileMapWalls.getTileMapData(), -1);
        n6 = this.m_attribOffsetX;
        object2 = false;
        boolean bl = false;
        while (var15_18 < n7) {
            n5 = n6 + object4[var15_18];
            object = object2 + object3[var15_18];
            by = byArray[var15_18];
            n4 = byArray2[var15_18];
            n3 = byArray3[var15_18];
            n2 = byArray4[var15_18];
            this.drawRoom(n5, (int)object, by, n4, n3, n2);
            ++var15_18;
        }
        boolean bl2 = false;
        while (var15_20 < n8) {
            n5 = byArray5[var15_20];
            object = byArray6[var15_20];
            by = byArray7[var15_20];
            if (by > 0) {
                n4 = this.getAttribute(n5, object - 1);
                n3 = this.getAttribute(n5, object + 1);
            } else {
                n4 = this.getAttribute(n5 - 1, (int)object);
                n3 = this.getAttribute(n5 + 1, (int)object);
            }
            n2 = (n4 & 0xF) - 1;
            int n9 = (n3 & 0xF) - 1;
            int n10 = n2 == -1 ? 3 : byArray3[n2];
            int n11 = n9 == -1 ? 3 : byArray3[n9];
            byte by3 = n9 == -1 ? (byte)0 : byArray4[n9];
            this.drawDoor(n6 + n5, (int)(object2 + object), Math.abs(by), n10, n11, by3, by < 0 ? 2 : 1);
            ++var15_20;
        }
        this.tilemapFixupHouse();
        this.initAttributesHouse();
        this.m_tileMap.refreshOffscreenBuffer();
    }

    private void drawRoom(int n, int n2, int n3, int n4, int n5, int n6) {
        TileMap tileMap = this.m_tileMap;
        byte[] byArray = tileMap.getTileMapData();
        byte[] byArray2 = this.m_tileMapWalls.getTileMapData();
        int n7 = tileMap.getWidth();
        int n8 = this.coordWorldTileToScreenTileX(n, n2);
        int n9 = this.coordWorldTileToScreenTileY(n, n2);
        int n10 = n3 + n4;
        byte by = this.getTile(5, n5);
        byte by2 = this.getTile(12, n6);
        byte by3 = this.getTile(18, n6);
        byte by4 = this.getTile(8, n6);
        byte by5 = this.getTile(14, n6);
        int n11 = n8 - n4;
        int n12 = n9 + n4;
        int n13 = n12 + 1;
        for (int i = 0; i < n10; ++i) {
            int n14;
            byte by6;
            byte by7;
            boolean bl = i < n4;
            boolean bl2 = i < n3;
            byArray2[n11 + (n12 - 0) * n7] = by7 = bl ? by2 : by3;
            byArray2[n11 + (n12 - 1) * n7] = by6 = bl ? by4 : by5;
            byArray2[n11 + (n13 + 0) * n7] = n14 = bl2 ? 56 : 48;
            int n15 = n13 - n12 + 2;
            for (int j = 0; j < n15; ++j) {
                byArray[n11 + (n12 + j) * n7] = by;
            }
            if (i == 0) {
                byArray2[n11 - 1 + (n12 + 0) * n7] = this.getTile(20, n6);
            } else if (i == n10 - 1) {
                byArray2[n11 + 1 + (n12 + 0) * n7] = this.getTile(21, n6);
            }
            ++n11;
            if (i != n3 - 1) {
                n13 += bl2 ? 1 : -1;
            }
            if (i == n4 - 1) continue;
            n12 += bl ? -1 : 1;
        }
    }

    private void drawDoor(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl;
        TileMap tileMap = this.m_tileMap;
        int n8 = tileMap.getWidth();
        byte[] byArray = this.m_tileMapWalls.getTileMapData();
        int n9 = this.coordWorldTileToScreenTileX(n, n2);
        int n10 = this.coordWorldTileToScreenTileY(n, n2);
        boolean bl2 = bl = (n7 & 1) != 0;
        if (bl) {
            byte by = this.getTile(24, n6);
            byte by2 = this.getTile(25, n6);
            byte by3 = this.getTile(7, n4);
            int n11 = --n9 + n10 * n8;
            byArray[n11] = by;
            byArray[n11 += n8] = by2;
            byArray[n11 += n8] = by3;
            for (int i = 0; i < n3; ++i) {
                n11 = ++n9 + ++n10 * n8;
                byArray[n11] = -1;
                byArray[n11 += n8] = -1;
                byArray[n11 += n8] = by3;
            }
            n11 = ++n9 + ++n10 * n8;
            byArray[n11] = 52;
            if (byArray[n11 += n8] == -1) {
                byArray[n11] = this.getTile(14, n6);
                byArray[n11 += n8] = this.getTile(18, n6);
            }
        } else {
            byte by = this.getTile(22, n6);
            byte by4 = this.getTile(23, n6);
            byte by5 = this.getTile(6, n4);
            int n12 = (n9 -= 2) + ((n10 += 2) + 0) * n8;
            byArray[n12] = 52;
            if (byArray[n12 += n8] == -1) {
                byArray[n12] = this.getTile(8, n6);
                byArray[n12 += n8] = this.getTile(12, n6);
            }
            for (int i = 0; i < n3; ++i) {
                n12 = ++n9 + (--n10 + 0) * n8;
                byArray[n12] = -1;
                byArray[n12 += n8] = -1;
                byArray[n12 += n8] = by5;
            }
            n12 = ++n9 + (--n10 + 0) * n8;
            byArray[n12] = by;
            byArray[n12 += n8] = by4;
            byArray[n12 += n8] = by5;
        }
    }

    private void tilemapFixupHouse() {
        byte[] byArray = this.m_tileMapWalls.getTileMapData();
        byte[] byArray2 = this.m_tileMap.getTileMapData();
        int n = this.m_tileMap.getWidth();
        int n2 = this.m_tileMap.getHeight();
        byte[] byArray3 = Main.getNextHouseId() == 6 ? this.getTileArray(4) : this.getTileArray(3);
        byte[] byArray4 = this.getTileArray(5);
        byte[] byArray5 = this.getTileArray(26);
        byte[] byArray6 = this.getTileArray(8);
        byte[] byArray7 = this.getTileArray(14);
        byte[] byArray8 = this.getTileArray(20);
        byte[] byArray9 = this.getTileArray(21);
        for (int i = 1; i < n - 1; ++i) {
            boolean bl = false;
            for (int j = 0; j < n2 - 1; ++j) {
                int n3;
                int n4;
                int n5 = i + (j + 0) * n;
                int n6 = n5 + n;
                byte by = byArray2[n5];
                byte by2 = byArray2[n6];
                int n7 = byArray[n5];
                byte by3 = byArray[n6];
                if (n7 == 56 && by3 == -1) {
                    by3 = byArray7[0];
                }
                if (n7 == 48 && by3 == -1) {
                    by3 = byArray6[0];
                }
                if ((this.getTileIndex(n7, 27) != -1 || ArrayHandler.indexOf(n7, byArray8) != -1) && by3 == -1) {
                    by3 = byArray7[0];
                    n4 = n5 + n;
                    if (byArray[n4] == -1) {
                        byArray[n4] = this.getTile(18, 0);
                    }
                }
                if ((ArrayHandler.indexOf(n7, byArray5) != -1 || ArrayHandler.indexOf(n7, byArray9) != -1) && by3 == -1) {
                    by3 = byArray6[0];
                    n4 = n5 + n;
                    if (byArray[n4] == -1) {
                        byArray[n4] = this.getTile(12, 0);
                    }
                }
                n4 = -1;
                n4 = ArrayHandler.indexOf(n7, byArray7);
                if (n4 != -1) {
                    if (ArrayHandler.indexOf((int)by3, byArray6) != -1 || ArrayHandler.indexOf((int)by3, byArray8) != -1) {
                        n7 = byArray9[n4];
                    } else {
                        n3 = ArrayHandler.indexOf((int)by2, byArray4);
                        if (n3 != -1 && by3 == -1) {
                            by3 = this.getTile(18, n4);
                        }
                    }
                }
                if ((n4 = ArrayHandler.indexOf(n7, byArray6)) != -1) {
                    if (ArrayHandler.indexOf((int)by3, byArray7) != -1 || ArrayHandler.indexOf((int)by3, byArray9) != -1) {
                        n7 = byArray8[n4];
                    } else {
                        n3 = ArrayHandler.indexOf((int)by2, byArray4);
                        if (n3 != -1 && by3 == -1) {
                            by3 = this.getTile(12, n4);
                        }
                    }
                }
                if ((n3 = ArrayHandler.indexOf((int)by, byArray4)) != -1) {
                    int n8;
                    int n9;
                    int n10;
                    int n11 = -1;
                    n11 = ArrayHandler.indexOf((int)by3, byArray6);
                    if (n11 != -1 || (n11 = ArrayHandler.indexOf((int)by3, byArray8)) != -1) {
                        if (!bl) {
                            int n12 = this.getTile(10, n11);
                            n10 = this.getTile(11, n11);
                            for (n9 = 0; n9 < 5; ++n9) {
                                byArray[i + (j - n9) * n] = n8 = n9 == 4 ? n12 : n10;
                            }
                            n7 = n10;
                            byArray[i + (j - 5 - 1) * n] = 52;
                            n9 = i + (j - 5 - 0) * n;
                            byArray[n9] = this.getTile(9, n11);
                            if (byArray[--n9] == 52) {
                                byArray[n9] = 48;
                            }
                            if ((n11 = ArrayHandler.indexOf((int)by3, byArray6)) != -1) {
                                by3 = this.getTile(13, n11);
                            } else {
                                n11 = ArrayHandler.indexOf((int)by3, byArray8);
                                if (n11 != -1) {
                                    by3 = this.getTile(27, n11);
                                }
                            }
                            bl = true;
                        } else if (n7 == -1) {
                            n7 = 48;
                        }
                    } else {
                        n11 = ArrayHandler.indexOf((int)by3, byArray7);
                        if (n11 != -1 || (n11 = ArrayHandler.indexOf((int)by3, byArray9)) != -1) {
                            if (!bl) {
                                int n13 = this.getTile(16, n11);
                                n10 = this.getTile(17, n11);
                                for (n9 = 0; n9 < 5; ++n9) {
                                    byArray[i + (j - n9 - 1) * n] = n8 = n9 == 3 ? n13 : n10;
                                }
                                n7 = n10;
                                n9 = i + (j - 5 - 1) * n;
                                n8 = byArray[n9 - 1];
                                byArray[n9] = this.getTileIndex(n8, 15) != -1 || n8 == 52 ? 56 : 52;
                                byArray[i + (j - 5 - 0) * n] = this.getTile(15, n11);
                                if (byArray[--n9] == 52) {
                                    byArray[n9] = 48;
                                }
                                if ((n11 = ArrayHandler.indexOf((int)by3, byArray7)) != -1) {
                                    by3 = this.getTile(19, n11);
                                } else {
                                    n11 = ArrayHandler.indexOf((int)by3, byArray9);
                                    if (n11 != -1) {
                                        by3 = byArray5[n11];
                                    }
                                }
                                bl = true;
                            } else if (n7 == -1) {
                                n7 = 56;
                            }
                        } else {
                            int n14;
                            int n15;
                            int n16;
                            byte[] byArray10 = this.getTileArray(24);
                            if (n3 == 3 || n3 == 4) {
                                n10 = Main.rand(0, byArray3.length - 1);
                                by = byArray3[n10];
                            }
                            n10 = -1;
                            n9 = byArray[i + 1 + j * n];
                            n10 = ArrayHandler.indexOf(n9, byArray8);
                            if (n10 != -1) {
                                if (!bl) {
                                    n10 = 0;
                                    n8 = this.getTile(30, n10);
                                    n16 = this.getTile(29, n10);
                                    for (n15 = 0; n15 < 5; ++n15) {
                                        byArray[i + (j - n15 - 1) * n] = n14 = n15 == 4 ? n8 : n16;
                                    }
                                    n7 = this.getTile(28, n10);
                                    n15 = i + (j - 1 - 5) * n;
                                    byArray[n15] = this.getTile(22, n10);
                                    bl = true;
                                } else if (n7 == -1) {
                                    n7 = this.getTile(22, 0);
                                }
                                if (by3 == -1) {
                                    by3 = this.getTile(23, 0);
                                }
                            }
                            n8 = -1;
                            n16 = byArray[i - 1 + j * n];
                            if (ArrayHandler.indexOf(n16, byArray9) != -1) {
                                if (n7 == -1) {
                                    n15 = byArray[i - 1 + (j + 1) * n];
                                    n14 = ArrayHandler.indexOf(n15, byArray6);
                                    n7 = byArray10[n14];
                                    by3 = this.getTile(25, n14);
                                }
                            } else {
                                n8 = ArrayHandler.indexOf(n16, byArray5);
                                if (n8 != -1) {
                                    if (!bl) {
                                        int n17;
                                        n8 = 0;
                                        n15 = this.getTile(33, n8);
                                        n14 = this.getTile(32, n8);
                                        for (n17 = 0; n17 < 5; ++n17) {
                                            int n18;
                                            byArray[i + (j - n17 - 1) * n] = n18 = n17 == 4 ? n15 : n14;
                                        }
                                        n7 = this.getTile(31, n8);
                                        n17 = i + (j - 1 - 5) * n;
                                        byArray[n17] = byArray10[n8];
                                        bl = true;
                                        if (byArray[n17 -= n + 1] == 52) {
                                            byArray[n17] = 56;
                                        }
                                    } else if (n7 == -1) {
                                        n7 = byArray10[n8];
                                    }
                                    if (by3 == -1) {
                                        by3 = this.getTile(25, n8);
                                    }
                                }
                            }
                        }
                    }
                }
                byArray2[n5] = by;
                byArray2[n6] = by2;
                byArray[n5] = n7;
                byArray[n6] = by3;
            }
        }
    }

    private void initAttributesHouse() {
        int n;
        TileMap tileMap = this.m_tileMapWalls;
        byte[] byArray = tileMap.getTileMapData();
        int n2 = tileMap.getWidth();
        int n3 = tileMap.getHeight();
        byte[] byArray2 = this.m_attributesLayer;
        for (n = 0; n < this.m_attributesLayer.length; ++n) {
            if ((byArray2[n] & 0x80) == 0) continue;
            int n4 = n;
            byArray2[n4] = (byte)(byArray2[n4] | 0x40);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                byte by = byArray[n + i * n2];
                if (n != 0 && n != n2 - 1 && i != 0 && i != n3 - 1 && this.getTileIndex(by, 11) == -1 && this.getTileIndex(by, 17) == -1 && this.getTileIndex(by, 31) == -1 && this.getTileIndex(by, 32) == -1 && this.getTileIndex(by, 33) == -1 && this.getTileIndex(by, 8) == -1 && this.getTileIndex(by, 10) == -1 && this.getTileIndex(by, 9) == -1 && this.getTileIndex(by, 14) == -1 && this.getTileIndex(by, 16) == -1 && this.getTileIndex(by, 15) == -1) continue;
                int n5 = tileMap.coordTileToWorldX(n);
                int n6 = tileMap.coordTileToWorldY(i);
                int n7 = this.coordScreenToWorldX(n5, n6);
                int n8 = this.coordScreenToWorldZ(n5, n6);
                int n9 = this.coordWorldToWorldTileX(n7);
                int n10 = this.coordWorldToWorldTileZ(n8);
                this.setAttribute(n9, n10, 255, 128);
            }
        }
    }

    private void initAttributesMacromap() {
        int n;
        byte by;
        int n2;
        TileMap tileMap = this.m_tileMap;
        byte[] byArray = tileMap.getTileMapData();
        int n3 = tileMap.getWidth();
        int n4 = tileMap.getHeight();
        byte[] byArray2 = this.getTileArray(34);
        ArrayHandler.fillArray(this.m_attributesLayer, 128);
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                by = byArray[i + n2 * n3];
                if (ArrayHandler.indexOf((int)by, byArray2) == -1) continue;
                n = tileMap.coordTileToWorldX(i);
                int n5 = tileMap.coordTileToWorldY(n2);
                int n6 = this.coordScreenToWorldX(n, n5);
                int n7 = this.coordScreenToWorldZ(n, n5);
                int n8 = this.coordWorldToWorldTileX(n6);
                int n9 = this.coordWorldToWorldTileZ(n7);
                this.setAttribute(n8, n9, -129, 32);
                this.setAttribute(n8 + 1, n9, 255, 16);
                this.setAttribute(n8 - 1, n9, 255, 16);
                this.setAttribute(n8, n9 + 1, 255, 16);
                this.setAttribute(n8, n9 - 1, 255, 16);
            }
        }
        byte[] byArray3 = this.m_attributesLayer;
        for (n2 = 0; n2 < byArray3.length; ++n2) {
            by = byArray3[n2];
            n = 255;
            if ((by & 0x20) != 0) {
                n &= 0xFFFFFFEF;
            }
            if ((by & 0x10) != 0) {
                n &= 0xFFFFFF7F;
            }
            byArray3[n2] = (byte)(by & n);
        }
    }

    private void initAttributesZoomMap(int n) {
        byte[] byArray;
        switch (n) {
            case 57: {
                byArray = this.getTileArray(36);
                break;
            }
            case 58: {
                byArray = this.getTileArray(37);
                break;
            }
            case 60: {
                byArray = this.getTileArray(38);
                break;
            }
            case 61: {
                byArray = this.getTileArray(39);
                break;
            }
            default: {
                byArray = this.getTileArray(35);
            }
        }
        TileMap tileMap = this.m_tileMap;
        byte[] byArray2 = tileMap.getTileMapData();
        int n2 = tileMap.getWidth();
        int n3 = tileMap.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                boolean bl;
                byte by = byArray2[i + j * n2];
                boolean bl2 = bl = ArrayHandler.indexOf((int)by, byArray) != -1;
                if (i != 0 && i != n2 - 1 && j != 0 && j != n3 - 1 && !bl) continue;
                int n4 = i;
                if (!bl && n4 == n2 - 1) {
                    ++n4;
                }
                int n5 = tileMap.coordTileToWorldX(n4);
                int n6 = tileMap.coordTileToWorldY(j);
                int n7 = this.coordScreenToWorldX(n5, n6);
                int n8 = this.coordScreenToWorldZ(n5, n6);
                int n9 = this.coordWorldToWorldTileX(n7);
                int n10 = this.coordWorldToWorldTileZ(n8);
                this.setAttribute(n9, n10, 255, 128);
            }
        }
    }

    private void objectsZSort() {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        boolean bl = false;
        for (int i = 0; i < mapObjectArray.length; ++i) {
            for (int j = 1; j < mapObjectArray.length; ++j) {
                int n;
                MapObject mapObject = mapObjectArray[j];
                MapObject mapObject2 = mapObjectArray[j - 1];
                int n2 = this.coordWorldToScreenPixelsX(mapObject.getPosX(), mapObject.getPosZ());
                if (n2 < (n = this.coordWorldToScreenPixelsX(mapObject2.getPosX(), mapObject2.getPosZ()))) {
                    if (mapObject.getZSortOrderRight() >= mapObject2.getZSortOrderLeft()) continue;
                    mapObjectArray[j - 1] = mapObject;
                    mapObjectArray[j] = mapObject2;
                    bl = true;
                    continue;
                }
                if (mapObject.getZSortOrderLeft() >= mapObject2.getZSortOrderRight()) continue;
                mapObjectArray[j - 1] = mapObject;
                mapObjectArray[j] = mapObject2;
                bl = true;
            }
            if (!bl) break;
            bl = false;
        }
    }

    private void objectsCheckInView2D() {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n = this.m_viewportX - 50;
        int n2 = this.m_viewportY - 20;
        int n3 = this.m_viewportX + this.m_viewportWidth + 50;
        int n4 = this.m_viewportY + this.m_viewportHeight + 60;
        int n5 = this.getCameraPixelX();
        int n6 = this.getCameraPixelY();
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject = mapObjectArray[i];
            int n7 = n5 + this.coordWorldToScreenPixelsX(mapObject.getPosX(), mapObject.getPosZ());
            int n8 = n6 + this.coordWorldToScreenPixelsY(mapObject.getPosX(), mapObject.getPosZ());
            if ((this.getObjectFlags(mapObjectArray[i].getType()) & 0x80) > 0) {
                mapObject.setInView(true);
                continue;
            }
            mapObject.setInView(n7 >= n && n7 <= n3 && n8 >= n2 && n8 <= n4);
        }
    }

    private void renderObjects2D() {
        this.objectsZSort();
        this.objectsCheckInView2D();
        MapObject[] mapObjectArray = StateInGame.getObjects();
        int n = mapObjectArray.length;
        for (int i = 0; i < n; ++i) {
            MapObject mapObject = mapObjectArray[i];
            if (mapObject == null) {
                return;
            }
            if (!mapObject.isInView() || mapObject.getRuntimeFlag(8192)) continue;
            mapObject.render2D();
        }
    }

    public void setCameraPosX(int n) {
        this.m_cameraPosX = n;
    }

    public void setCameraPosZ(int n) {
        this.m_cameraPosZ = n;
    }

    public int getCameraPosX() {
        return this.m_cameraPosX;
    }

    public int getCameraPosZ() {
        return this.m_cameraPosZ;
    }

    public int getObjectCount() {
        return this.d_objectStringIds.length;
    }

    public int getObjectParent(int n) {
        return this.d_objectParents[n];
    }

    public int getObjectStringId(int n) {
        return this.d_objectStringIds[n];
    }

    public int getObjectActionIcon(int n) {
        return this.d_objectActionIcons[n];
    }

    public int getObjectFlags(int n) {
        return this.d_objectFlags[n];
    }

    public int getObjectNeed(int n) {
        return this.d_objectNeeds[n];
    }

    public int getObjectFootprintWidth(int n) {
        return this.d_objectFootprintWidths[n];
    }

    public int getObjectFootprintHeight(int n) {
        return this.d_objectFootprintHeights[n];
    }

    public int getObjectAnimId(int n) {
        return this.d_objectAnimIds[n];
    }

    public int getObjectAnimSetId(int n, int n2) {
        if (n2 < this.d_objectAnimSetIds[n].length) {
            return this.d_objectAnimSetIds[n][n2];
        }
        return 0;
    }

    public int getObjectInterestPointCount(int n) {
        return this.d_objectInterestPointXs[n * 5];
    }

    public int getObjectInterestPointX(int n, int n2, int n3) {
        int n4 = this.d_objectInterestPointXs[n * 5 + n2 + 1];
        int n5 = this.d_objectInterestPointYs[n * 5 + n2 + 1];
        switch (n3) {
            default: {
                Debug.ASSERT(false, "invalid facing dir");
            }
            case 0: {
                break;
            }
            case 1: {
                n4 = n5;
                break;
            }
            case 2: {
                n4 = 1 - n4 - Math.max(this.d_objectFootprintHeights[n], 1);
                break;
            }
            case 3: {
                n4 = 1 - Math.max(this.d_objectFootprintWidths[n], 1) - n5;
            }
        }
        return n4;
    }

    public int getObjectInterestPointZ(int n, int n2, int n3) {
        int n4 = this.d_objectInterestPointXs[n * 5 + n2 + 1];
        int n5 = this.d_objectInterestPointYs[n * 5 + n2 + 1];
        switch (n3) {
            default: {
                Debug.ASSERT(false, "invalid facing dir");
            }
            case 0: {
                break;
            }
            case 1: {
                n5 = n4;
                break;
            }
            case 2: {
                n5 = 1 - n5 - Math.max(this.d_objectFootprintWidths[n], 1);
                break;
            }
            case 3: {
                n5 = 1 - Math.max(this.d_objectFootprintHeights[n], 1) - n4;
            }
        }
        return n5;
    }

    public int getObjectFirstAction(int n) {
        return this.d_objectActions[this.d_objectActionOffsets[n]];
    }

    public int getObjectActions(int n, short[] sArray) {
        short s = this.d_objectActionOffsets[n];
        int n2 = this.d_objectActionOffsets[n + 1] - s;
        for (int i = 0; i < n2; ++i) {
            sArray[i] = this.d_objectActions[s + i];
        }
        return n2;
    }

    public int getObjectQuickLinkIndex(int n) {
        int[] nArray = this.d_objectFlags;
        if ((nArray[n] & 0x20) == 0) {
            return -1;
        }
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & 0x20) == 0) continue;
            if (i == n) {
                return n2;
            }
            ++n2;
        }
        Debug.ASSERT(false, "invalid object type");
        return -1;
    }

    public int getAnim(int n, int n2) {
        int n3 = (n << 2) + n2;
        return this.d_animSetIndexes[n3];
    }

    public int mapSubAppearance(int n, boolean bl) {
        if (n < 0) {
            int n2 = Main.randPercent();
            if (n == -2) {
                if (!bl) {
                    n2 = n2 * 75 / 100;
                }
                n = n2 < 25 ? 6 : (n2 < 50 ? 7 : (n2 < 75 ? 8 : 9));
                Debug.ASSERT(n != 9 || bl, "no north chat 04");
            } else if (n == -3) {
                n = n2 < 50 ? 10 : 11;
            } else if (n == -4) {
                n = n2 < 50 ? 13 : 14;
            }
        }
        return n;
    }

    public int getSubAppearanceAnimSet(int n, int n2, boolean bl) {
        short[] sArray = this.d_appearances[n];
        n2 <<= 1;
        if (bl) {
            ++n2;
        }
        if (n2 < sArray.length) {
            return sArray[n2];
        }
        return bl ? 0 : sArray[0];
    }

    private final byte[] getTileArray(int n) {
        return this.d_tileArrays[n];
    }

    private final byte getTile(int n, int n2) {
        return this.d_tileArrays[n][n2];
    }

    private final int getTileIndex(int n, int n2) {
        return ArrayHandler.indexOf(n, this.d_tileArrays[n2]);
    }

    public int getItemCount() {
        return this.d_itemDescStringIds.length;
    }

    public int getItemDescString(int n) {
        return this.d_itemDescStringIds[n];
    }

    public int getItemIcon(int n) {
        return this.d_itemIcons[n];
    }

    public int getItemFlags(int n) {
        return this.d_itemFlags[n];
    }

    public int getItemBuyPrice(int n) {
        return this.d_itemBuyPrices[n];
    }

    public int getItemSellPrice(int n) {
        return this.d_itemSellPrices[n];
    }

    public int getItemMaxInventory(int n) {
        return this.d_itemMaxInventory[n];
    }

    private int getShopFlags(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 63: {
                return 256;
            }
            case 58: {
                return 16384;
            }
            case 41: {
                return 1024;
            }
            case 44: {
                return 2048;
            }
            case 56: {
                return 4096;
            }
            case 47: {
                return 8192;
            }
            case 62: 
        }
        return 512;
    }

    public int getItemNthCount(int n) {
        return ArrayHandler.countOfFlags(this.getShopFlags(n), this.d_itemFlags);
    }

    public int getItemNthItem(int n, int n2) {
        return ArrayHandler.indexOfNthElementFlags(n2, this.d_itemFlags, this.getShopFlags(n));
    }

    public int getRecipeReplenishes(int n) {
        return IStringConstants.MathExt_Fmul(this.d_recipeReplenishes[n] << 16, 22937);
    }

    public int getRecipeItem(int n) {
        return this.d_recipeItems[n];
    }

    public int getRecipeIngredientCount(int n) {
        return this.d_recipeIngredients[n].length;
    }

    public int getRecipeIngredient(int n, int n2) {
        return this.d_recipeIngredients[n][n2];
    }

    public int getRecipeForItem(int n) {
        return ArrayHandler.indexOf(n, this.d_recipeItems);
    }

    public int getRecipeDesc(int n) {
        return this.d_itemDescStringIds[this.d_recipeItems[n]];
    }

    public int getRecipeByName(int n) {
        for (int i = 0; i < this.d_recipeItems.length; ++i) {
            if (this.getRecipeDesc(i) != n) continue;
            return i;
        }
        return -1;
    }

    public SDKString cookingSchoolGetNextRecipeName() {
        for (int i = 0; i < this.d_itemFlags.length; ++i) {
            if (this.d_itemFlags[i] != 128 || Main.m_simData.getInventoryCount(i) != 0) continue;
            return GameConstants.TextHandler_getString(Main.m_simWorld.d_itemDescStringIds[i]);
        }
        return Cursor.SDKStringUtilsHandler_stringToSDKString("ERROR");
    }

    public int cookingSchoolIsMoreRecipesAvailable() {
        for (int i = 0; i < this.d_itemFlags.length; ++i) {
            if (this.d_itemFlags[i] != 128 || Main.m_simData.getInventoryCount(i) != 0) continue;
            return this.d_itemBuyPrices[i];
        }
        return -1;
    }

    public boolean areThereAnyRecipesLeftToBuy() {
        for (int i = 0; i < this.d_itemFlags.length; ++i) {
            if ((this.d_itemFlags[i] & 0x4000) <= 0 && (this.d_itemFlags[i] & 0x200) <= 0 || Main.m_simData.getInventoryCount(i) != 0) continue;
            return true;
        }
        return false;
    }

    public SDKString cookingSchoolGetNextRecipePrice() {
        for (int i = 0; i < this.d_itemFlags.length; ++i) {
            if (this.d_itemFlags[i] != 128 || Main.m_simData.getInventoryCount(i) != 0) continue;
            return Cursor.SDKStringUtilsHandler_intToSdkstring(Main.m_simWorld.d_itemBuyPrices[i]);
        }
        return Cursor.SDKStringUtilsHandler_stringToSDKString("ERROR");
    }

    public void cookingSchoolGiveNextRecipe() {
        for (int i = 0; i < this.d_itemFlags.length; ++i) {
            if (this.d_itemFlags[i] != 128 || Main.m_simData.getInventoryCount(i) != 0) continue;
            Main.m_simData.adjustInventory(i, 1);
            return;
        }
    }

    private void initColors() {
        int n;
        int n2;
        int n3;
        Intro.ResourceManager_loadBinaryFile(63);
        int n4 = Cursor.PMFile_readByte();
        this.d_patches = new int[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = Cursor.PMFile_readByte();
            this.d_patches[n3] = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.d_patches[n3][n] = Cursor.PMFile_readInt();
            }
        }
        n3 = Cursor.PMFile_readByte();
        this.d_pals = new byte[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            n = Cursor.PMFile_readByte();
            this.d_pals[n2] = new byte[n];
            for (int i = 0; i < n; ++i) {
                this.d_pals[n2][i] = Cursor.PMFile_readByte();
            }
        }
        Cursor.PMFile_closeFile();
    }

    public void patchClear(int[] nArray, int[] nArray2) {
        Debug.ASSERT(nArray.length == nArray2.length, "sources and patches must be equal length");
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = 0xFF00FF;
            nArray2[i] = 0xFF00FF;
        }
    }

    public void patchAdd(int[] nArray, int[] nArray2, int n, int n2) {
        Debug.ASSERT(nArray.length == nArray2.length, "sources and patches must be equal length");
        if (n < 0 || n2 < 0) {
            return;
        }
        int[] nArray3 = this.d_patches[n];
        int[] nArray4 = this.d_patches[n2];
        Debug.ASSERT(nArray3.length == nArray4.length, "patches must be equal length");
        int n3 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != 0xFF00FF) continue;
            n3 = i;
            break;
        }
        Debug.ASSERT(n3 != -1, "patches array full");
        System.arraycopy(nArray3, 0, nArray, n3, nArray3.length);
        System.arraycopy(nArray4, 0, nArray2, n3, nArray4.length);
    }

    public int[] getPatch(int n) {
        return this.d_patches[n];
    }

    public byte[] getPal(int n) {
        return this.d_pals[n];
    }

    public void getSimPatches(int n, int[] nArray, int[] nArray2) {
        byte by = this.d_pals[1][Main.m_simData.getSimAttribute(n, 3)];
        byte by2 = this.d_pals[2][Main.m_simData.getSimAttribute(n, 4)];
        byte by3 = this.d_pals[3][Main.m_simData.getSimAttribute(n, 5)];
        byte by4 = this.d_pals[4][Main.m_simData.getSimAttribute(n, 6)];
        byte by5 = this.d_pals[5][Main.m_simData.getSimAttribute(n, 7)];
        byte by6 = this.d_pals[6][Main.m_simData.getSimAttribute(n, 8)];
        byte by7 = this.d_pals[7][Main.m_simData.getSimAttribute(n, 9)];
        byte by8 = this.d_pals[0][Main.m_simData.getSimAttribute(n, 1)];
        this.patchClear(nArray, nArray2);
        this.patchAdd(nArray, nArray2, 11, by);
        this.patchAdd(nArray, nArray2, 34, by2);
        this.patchAdd(nArray, nArray2, 20, by3);
        this.patchAdd(nArray, nArray2, 30, by4);
        this.patchAdd(nArray, nArray2, 31, by5);
        this.patchAdd(nArray, nArray2, 32, by6);
        this.patchAdd(nArray, nArray2, 33, by7);
        this.patchAdd(nArray, nArray2, 5, by8);
    }

    public void pathClearAvoidTiles() {
        this.m_pathNumAvoidTiles = 0;
    }

    public void pathAddAvoidTile(int n, int n2) {
        if (this.m_pathNumAvoidTiles < 10) {
            int n3 = this.m_pathNumAvoidTiles << 1;
            this.m_pathAvoidTiles[n3] = n;
            this.m_pathAvoidTiles[n3 + 1] = n2;
            ++this.m_pathNumAvoidTiles;
        }
    }

    public int pathFind(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        this.pathReset();
        this.m_pathFlags = n5;
        this.m_pathStartX = this.coordWorldToWorldTileX(n);
        this.m_pathStartY = this.coordWorldToWorldTileZ(n2);
        this.m_pathDestX = this.coordWorldToWorldTileX(n3);
        this.m_pathDestY = this.coordWorldToWorldTileZ(n4);
        if (!this.isWorldTileWalkable(this.m_pathDestX, this.m_pathDestY)) {
            return 0;
        }
        this.m_pathOffsetX = this.m_pathStartX + this.m_pathDestX - 32 >> 1;
        this.m_pathOffsetY = this.m_pathStartY + this.m_pathDestY - 32 >> 1;
        int n12 = this.m_pathStartX - this.m_pathOffsetX;
        int n13 = this.m_pathStartY - this.m_pathOffsetY;
        if (n12 < 0 || n13 < 0 || n12 >= 32 || n13 >= 32) {
            return 0;
        }
        n12 = this.m_pathDestX - this.m_pathOffsetX;
        n13 = this.m_pathDestY - this.m_pathOffsetY;
        if (n12 < 0 || n13 < 0 || n12 >= 32 || n13 >= 32) {
            return 0;
        }
        this.pathAddToOpenList(this.m_pathStartX - this.m_pathOffsetX, this.m_pathStartY - this.m_pathOffsetY);
        n12 = 0;
        while (n12 == 0) {
            n13 = this.pathFindLowestF();
            if (n13 == -1) {
                return 0;
            }
            n11 = this.m_pathOpenList[n13] & 0xFF;
            n10 = (this.m_pathOpenList[n13] & 0xFF00) >> 8;
            for (n9 = 0; n9 < 4; ++n9) {
                n8 = n11 + (n9 == 0 ? -1 : (n9 == 1 ? 1 : 0));
                if (this.pathIsClosed(n8, n7 = n10 + (n9 == 2 ? -1 : (n9 == 3 ? 1 : 0)))) continue;
                if (this.pathAddToOpenList(n8, n7)) {
                    this.pathSetParent(n8, n7, n11, n10);
                    this.pathCalculateGCost(n8, n7);
                    this.pathCalculateHCost(n8, n7);
                    this.pathCalculateFCost(n8, n7);
                    continue;
                }
                if (!this.pathBetterGCost(n8, n7, n11, n10)) continue;
                this.pathSetParent(n8, n7, n11, n10);
                this.pathCalculateGCost(n8, n7);
                this.pathCalculateFCost(n8, n7);
            }
            this.pathSwitchToClosedList(n13);
            if (n11 != this.m_pathDestX - this.m_pathOffsetX || n10 != this.m_pathDestY - this.m_pathOffsetY) continue;
            n12 = 1;
        }
        n13 = Integer.MAX_VALUE;
        n11 = Integer.MAX_VALUE;
        n10 = this.m_pathDestX - this.m_pathOffsetX;
        n9 = this.m_pathDestY - this.m_pathOffsetY;
        n8 = this.m_pathStartX - this.m_pathOffsetX;
        n7 = this.m_pathStartY - this.m_pathOffsetY;
        int n14 = 0;
        while (!(n10 < 0 || n9 < 0 || n10 >= 32 || n9 >= 32 || n10 == n8 && n9 == n7 || n13 == n10 && n11 == n9 || (n6 = this.m_pathParentArray[n10][n9]) == -1)) {
            this.m_pathList[n14] = (short)(n10 | n9 << 8);
            ++n14;
            n13 = n10;
            n11 = n9;
            n10 = n6 & 0xFF;
            n9 = (n6 & 0xFF00) >> 8;
        }
        for (n6 = 0; n6 < n14; ++n6) {
            int n15 = n14 - n6 - 1;
            int n16 = (this.m_pathList[n15] & 0xFF) + this.m_pathOffsetX;
            int n17 = ((this.m_pathList[n15] & 0xFF00) >> 8) + this.m_pathOffsetY;
            nArray[(n6 << 1) + 0] = this.coordWorldTileToWorldCenterX(n16);
            nArray[(n6 << 1) + 1] = this.coordWorldTileToWorldCenterZ(n17);
        }
        return n14 * 2;
    }

    private void pathInit() {
        this.m_pathOpenList = new short[1024];
        this.m_pathOpenCount = 0;
        this.m_pathClosedLookup = new long[32];
        this.m_pathParentArray = new short[32][32];
        this.m_pathGCost = new int[32][32];
        this.m_pathFCost = new int[32][32];
        this.m_pathHCost = new int[32][32];
        this.m_pathList = new short[256];
        this.m_pathNumAvoidTiles = 0;
        this.m_pathAvoidTiles = new int[20];
    }

    private boolean pathAddToOpenList(int n, int n2) {
        short s = (short)(n | n2 << 8);
        for (int i = 0; i < this.m_pathOpenCount; ++i) {
            if (this.m_pathOpenList[i] != s) continue;
            return false;
        }
        this.m_pathOpenList[this.m_pathOpenCount] = s;
        ++this.m_pathOpenCount;
        return true;
    }

    private void pathSwitchToClosedList(int n) {
        int n2 = this.m_pathOpenList[n] & 0xFF;
        int n3 = (this.m_pathOpenList[n] & 0xFF00) >> 8;
        int n4 = n2;
        this.m_pathClosedLookup[n4] = this.m_pathClosedLookup[n4] | 1L << n3;
        this.m_pathOpenList[n] = this.m_pathOpenList[this.m_pathOpenCount - 1];
        --this.m_pathOpenCount;
    }

    private void pathSetParent(int n, int n2, int n3, int n4) {
        this.m_pathParentArray[n][n2] = (short)(n3 | n4 << 8);
    }

    private int pathTileGCost(int n, int n2) {
        if ((this.m_pathFlags & 6) != 0) {
            int n3 = n + this.m_pathOffsetX;
            int n4 = n2 + this.m_pathOffsetY;
            int n5 = this.getAttribute(n3, n4);
            if ((n5 & 0x20) != 0) {
                return (this.m_pathFlags & 2) != 0 ? 5 : 50;
            }
            if ((n5 & 0x10) != 0) {
                return 10;
            }
            return 15;
        }
        return 15;
    }

    private void pathCalculateGCost(int n, int n2) {
        int n3 = this.m_pathParentArray[n][n2] & 0xFF;
        int n4 = (this.m_pathParentArray[n][n2] & 0xFF00) >> 8;
        int n5 = this.m_pathGCost[n3][n4];
        int n6 = 0;
        if ((this.m_pathFlags & 8) != 0) {
            int n7 = this.m_pathParentArray[n3][n4] & 0xFF;
            int n8 = (this.m_pathParentArray[n3][n4] & 0xFF00) >> 8;
            if (!(n7 == n3 && n3 == n || n8 == n4 && n4 == n2)) {
                n6 = 20;
            }
        }
        this.m_pathGCost[n][n2] = n5 + this.pathTileGCost(n, n2) + n6;
    }

    private boolean pathBetterGCost(int n, int n2, int n3, int n4) {
        int n5 = this.m_pathGCost[n][n2];
        int n6 = this.m_pathGCost[n3][n4];
        return (n6 += this.pathTileGCost(n, n2)) < n5;
    }

    private void pathCalculateHCost(int n, int n2) {
        int n3 = this.m_pathDestX - this.m_pathOffsetX - n;
        int n4 = this.m_pathDestY - this.m_pathOffsetY - n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n4 < 0) {
            n4 = -n4;
        }
        int n5 = 0;
        Debug.ASSERT(this.pathIsWalkable(n, n2), "pathCalculateHCost: rx, ry non-walkable");
        if ((this.m_pathFlags & 1) != 0) {
            for (int i = 0; i < this.m_pathNumAvoidTiles; ++i) {
                int n6 = i << 1;
                if (n + this.m_pathOffsetX != this.m_pathAvoidTiles[n6] || n2 + this.m_pathOffsetY != this.m_pathAvoidTiles[n6 + 1]) continue;
                n5 = 250;
                break;
            }
        }
        this.m_pathHCost[n][n2] = n3 * 24 + n4 * 24 + n5;
    }

    private void pathCalculateFCost(int n, int n2) {
        this.m_pathFCost[n][n2] = this.m_pathHCost[n][n2] + this.m_pathGCost[n][n2];
    }

    private int pathFindLowestF() {
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.m_pathOpenCount; ++i) {
            int n3 = this.m_pathOpenList[i] & 0xFF;
            int n4 = (this.m_pathOpenList[i] & 0xFF00) >> 8;
            if (n2 <= this.m_pathFCost[n3][n4]) continue;
            n2 = this.m_pathFCost[n3][n4];
            n = i;
        }
        return n;
    }

    private boolean pathIsWalkable(int n, int n2) {
        int n3 = n + this.m_pathOffsetX;
        int n4 = n2 + this.m_pathOffsetY;
        return this.isWorldTileWalkable(n3, n4);
    }

    private boolean pathIsClosed(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= 32 || n2 >= 32) {
            return true;
        }
        if (!this.pathIsWalkable(n, n2)) {
            return true;
        }
        return (this.m_pathClosedLookup[n] & 1L << n2) > 0L;
    }

    public void pathReset() {
        this.m_pathOpenCount = 0;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                this.m_pathParentArray[i][j] = 0;
                this.m_pathGCost[i][j] = 0;
                this.m_pathFCost[i][j] = 0;
                this.m_pathHCost[i][j] = 0;
            }
            this.m_pathClosedLookup[i] = 0L;
        }
    }
}

