/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.ArrayOptimizer;
import dk.progressivemedia.skeleton.Cursor;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.Event;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.Intro;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObject;
import dk.progressivemedia.skeleton.state.StateInGame;

public class IStringConstants {
    private static int[] MathExt_s_temp2DVec1 = new int[2];
    private static final int[] MathExt_Facos_neg_percalc = new int[]{205525, 205375, 205260, 205163, 205077};
    private static final int[] MathExt_Facos_pos_percalc = new int[]{270, 512, 627, 724, 809};
    private static final int[] MathExt_Fsqrt_smallest_precalced = new int[]{0, 256, 362, 443, 512, 572, 627, 677, 724, 768, 810, 849, 887, 923, 958, 991, 1024, 1056, 1086, 1116, 1145, 1173, 1201, 1227, 1254, 1280, 1305, 1330, 1355, 1378, 1402, 1425, 1448, 1471, 1493, 1515, 1536, 1557, 1578, 1599, 1619, 1639, 1659, 1679, 1698, 1717, 1736, 1755};
    private static final int MathExt_FSQRT_NUM_PRECALCED = MathExt_Fsqrt_smallest_precalced.length;
    private static final int MathExt_FSQRT_LOWER_SCALE_LIMIT = MathExt_Fsqrt_smallest_precalced[MathExt_FSQRT_NUM_PRECALCED - 1];
    public static boolean Minigame_maxedWorldKnowledgeFlag;
    public static boolean Minigame_firstClassBoughtFlag;
    public static MapObject Minigame_m_miniGameTargetObject;
    public static int Minigame_m_miniGameType;
    public static boolean Minigame_renderInGame;
    public static int Minigame_m_miniGameState;
    public static int Minigame_m_miniGameSkill;
    public static int Minigame_m_miniGameTimer;
    public static boolean Minigame_done;
    public static int Minigame_endTimer;
    public static boolean Minigame_interruptedByExternalEvent;
    public static boolean PMSystem_externalPause;
    public static boolean PMSystem_internalLoop;
    public static long PMSystem_time1;
    public static long PMSystem_time2;

    public static int MathExt_sign(int n) {
        return n > 0 ? 1 : (n < 0 ? -1 : 0);
    }

    public static int MathExt_clip(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n3, n));
    }

    public static int MathExt_Fmul(int n, int n2) {
        return (int)((long)n * (long)n2 >> 16);
    }

    public static int MathExt_Fdiv(int n, int n2) {
        return (int)(((long)n << 16) / (long)n2);
    }

    public static int MathExt_Fmag2(int n, int n2) {
        long l = n;
        long l2 = n2;
        return IStringConstants.MathExt_Fsqrt((int)(l * l + l2 * l2 >> 16));
    }

    public static int MathExt_normaliseAngleRadiansF(int n) {
        if (n > 205887) {
            n -= Math.max(1, n / 411775) * 411775;
        } else if (n < -205887) {
            n += Math.max(1, -n / 411775) * 411775;
        }
        return n;
    }

    public static int MathExt_Fcos(int n) {
        int n2 = n >= 0 ? 1 : -1;
        int n3 = IStringConstants.MathExt_Fmul(n2 * n << 1, 20861) & 0x3FFFF;
        int n4 = n3 >> 16 & 3;
        n3 &= 0xFFFF;
        n2 = 1;
        if ((n4 & 1) != 0) {
            n2 = -n2;
            n3 = 65536 - n3;
        }
        if ((n4 & 2) != 0) {
            n2 = -n2;
        }
        n3 = IStringConstants.MathExt_Fmul(n3, 205887) >> 1;
        int n5 = 2;
        int n6 = 1 << 16 + n5;
        int n7 = IStringConstants.MathExt_Fmul(n3, n3);
        int n8 = n7 << n5 - 1;
        n6 -= n8;
        n8 = IStringConstants.MathExt_Fmul(IStringConstants.MathExt_Fmul(n7, n8), 5461);
        n6 += n8;
        n8 = IStringConstants.MathExt_Fmul(IStringConstants.MathExt_Fmul(n7, n8), 2185);
        n6 -= n8;
        n8 = IStringConstants.MathExt_Fmul(IStringConstants.MathExt_Fmul(n7, n8), 1170);
        return (n6 += n8) * n2 >> n5;
    }

    public static int MathExt_Facos(int n) {
        if (n <= -65536) {
            return 205887;
        }
        if (65535 + n < MathExt_Facos_neg_percalc.length) {
            return MathExt_Facos_neg_percalc[65535 + n];
        }
        if (n >= 65536) {
            return 0;
        }
        if (65535 - n < MathExt_Facos_pos_percalc.length) {
            return MathExt_Facos_pos_percalc[65535 - n];
        }
        long l = (long)n * (long)n;
        long l2 = 0x100000000L;
        int n2 = 46661;
        long l3 = 32768L;
        if (n > n2) {
            return 102944 - IStringConstants.MathExt_Facos(IStringConstants.MathExt_Fsqrt((int)(l2 - l + l3 >> 16)));
        }
        if (n < -n2) {
            return 102944 + IStringConstants.MathExt_Facos(IStringConstants.MathExt_Fsqrt((int)(l2 - l + l3 >> 16)));
        }
        int n3 = (int)(l + l3 >> 16);
        int n4 = n;
        int n5 = -n4;
        n4 = IStringConstants.MathExt_Fmul(n4, n3);
        n5 -= IStringConstants.MathExt_Fmul(10923, n4);
        n4 = IStringConstants.MathExt_Fmul(n4, n3);
        n5 -= IStringConstants.MathExt_Fmul(4915, n4);
        n4 = IStringConstants.MathExt_Fmul(n4, n3);
        return 102944 + (n5 -= IStringConstants.MathExt_Fmul(2926, n4));
    }

    public static int MathExt_Fatan2(int n, int n2) {
        if (n == 0) {
            if (n2 < 0) {
                return 205887;
            }
            return 0;
        }
        if (n2 == 0) {
            if (n < 0) {
                return -102944;
            }
            return 102944;
        }
        int n3 = IStringConstants.MathExt_Fmag2(n, n2);
        int n4 = n2 < 0 ? -n2 : n2;
        int n5 = n3 > 0 ? IStringConstants.MathExt_Fdiv(n4, n3) : n4;
        int n6 = IStringConstants.MathExt_Facos(n5);
        if (n < 0 && n2 < 0) {
            n6 -= 205887;
        } else if (n < 0 && n2 > 0) {
            n6 = -n6;
        } else if (n > 0 && n2 < 0) {
            n6 = 205887 - n6;
        }
        return n6;
    }

    public static int MathExt_Fsqrt(int n) {
        int n2;
        if (n < 0) {
            return 0;
        }
        if (n < MathExt_FSQRT_NUM_PRECALCED) {
            return MathExt_Fsqrt_smallest_precalced[n];
        }
        int n3 = n;
        if (n < MathExt_FSQRT_LOWER_SCALE_LIMIT) {
            n3 <<= 2;
        } else if (n > 0x400000) {
            n3 >>= 2;
        }
        if (n3 > 65200 && n3 < 65800) {
            n2 = n3 + 65536 >> 1;
        } else {
            int n4 = (n3 >> 3) + 131072;
            if (n4 > 0x800000) {
                n4 = 0x800000;
            }
            int n5 = MathExt_FSQRT_LOWER_SCALE_LIMIT;
            n2 = n4 + n5 >> 1;
            for (int i = 0; i < 13; ++i) {
                int n6 = IStringConstants.MathExt_Fmul(n2, n2);
                if (n6 > n3) {
                    n4 = n2;
                } else {
                    n5 = n2;
                }
                n2 = n4 + n5 >> 1;
            }
        }
        if (n < MathExt_FSQRT_LOWER_SCALE_LIMIT) {
            n2 >>= 1;
        } else if (n > 0x400000) {
            n2 <<= 1;
        }
        return n2;
    }

    public static int MathExt_smoothstepF(int n, int n2, int n3) {
        if (n3 < n) {
            return 0;
        }
        if (n3 >= n2) {
            return 65536;
        }
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = IStringConstants.MathExt_Fdiv(n4, n5);
        int n7 = IStringConstants.MathExt_Fmul(n6, n6);
        return -2 * IStringConstants.MathExt_Fmul(n7, n6) + 3 * n7;
    }

    public static boolean Minigame_inMiniGame() {
        return StateInGame.m_state == 16;
    }

    public static void Minigame_load(int n) {
    }

    public static void Minigame_unload() {
    }

    public static void Minigame_beginMiniGame(int n, MapObject mapObject) {
        StateInGame.hideMenus();
        Main.m_simData.delayAlerts();
        Minigame_m_miniGameTargetObject = mapObject;
        Minigame_m_miniGameType = n;
        Minigame_endTimer = 4000;
        Minigame_done = false;
        IStringConstants.Minigame_load(n);
        boolean bl = false;
        int n2 = 0;
        Minigame_m_miniGameTimer = 0;
        switch (n) {
            default: {
                break;
            }
            case 3: {
                GameConstants.MinigameWorldknowledge_init(false, false);
                break;
            }
            case 4: {
                Minigame_m_miniGameType = 3;
                GameConstants.MinigameWorldknowledge_init(true, true);
                break;
            }
            case 1: {
                Minigame_m_miniGameSkill = 2;
                bl = true;
                break;
            }
            case 2: {
                Minigame_m_miniGameSkill = 3;
                bl = true;
                break;
            }
            case 0: {
                Minigame_m_miniGameSkill = 1;
                bl = true;
            }
        }
        Minigame_interruptedByExternalEvent = false;
        StateInGame.m_timeHit = n2;
        StateInGame.stateTransition(16);
        if (Minigame_m_miniGameType == 3 && Minigame_m_miniGameTargetObject != null) {
            IStringConstants.Minigame_stateTransitionMiniGame(4);
        } else {
            IStringConstants.Minigame_stateTransitionMiniGame(0);
        }
        if (bl) {
            IStringConstants.Minigame_stateTransitionMiniGame(1);
        }
    }

    public static void Minigame_startFireworks() {
    }

    public static void Minigame_stateTransitionMiniGame(int n) {
        Minigame_m_miniGameState = n;
        block0 : switch (n) {
            default: {
                break;
            }
            case 0: {
                switch (Minigame_m_miniGameType) {
                    case 3: {
                        if (Minigame_m_miniGameTargetObject != null) break block0;
                        Main.setSoftKeys(0, 8);
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                if (Minigame_m_miniGameTargetObject != null) {
                    Cursor.setCursorObject(Minigame_m_miniGameTargetObject);
                }
                StateInGame.stateTransition(5);
                if (Minigame_m_miniGameTargetObject != null) {
                    IStringConstants.Minigame_increaseSkill(Minigame_m_miniGameSkill);
                }
                if (Minigame_m_miniGameType == 3) {
                    int n2 = Minigame_m_miniGameTargetObject != null ? Minigame_m_miniGameTargetObject.getType() : 8;
                    StateInGame.hasJustFlownFlag = true;
                    switch (n2) {
                        case 8: {
                            Main.setNextHouseId(6);
                            break;
                        }
                        case 9: {
                            Main.setNextHouseId(4);
                            break;
                        }
                        case 11: {
                            Main.setNextHouseId(7);
                            break;
                        }
                        case 12: {
                            Main.setNextHouseId(5);
                            break;
                        }
                    }
                    StateInGame.changeScene(0, -1);
                } else if (Minigame_m_miniGameType == 1) {
                    Main.m_simData.dreamCompleteEvent(29);
                    Main.m_simData.dreamCompleteEvent(14);
                } else if (Minigame_m_miniGameType == 2) {
                    Main.m_simData.dreamCompleteEvent(30);
                    Main.m_simData.dreamCompleteEvent(15);
                } else if (Minigame_m_miniGameType == 0) {
                    Main.m_simData.dreamCompleteEvent(27);
                    Main.m_simData.dreamCompleteEvent(16);
                }
                StateInGame.m_playerSim.endSimPhase();
                IStringConstants.Minigame_unload();
                break;
            }
            case 4: {
                StateInGame.m_stateTime = 0;
                if (Main.m_simData.getMoney() > GameConstants.MinigameWorldknowledge_price) {
                    Main.setSoftKeys(512, 256);
                    break;
                }
                Main.setSoftKeys(0, 8);
            }
            case 5: 
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void Minigame_increaseSkill(int n) {
        int n2 = Main.m_simData.getSkillRank(n);
        Main.m_simData.increaseSkill(n);
        int n3 = Main.m_simData.getSkillRank(n);
        int n4 = 661;
        if (n2 != n3) {
            n4 = n3 == 5 ? 663 : 662;
            if (n3 == 5) {
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        Main.m_simData.dreamCompleteEvent(40);
                        break;
                    }
                    case 1: {
                        Main.m_simData.dreamCompleteEvent(31);
                        break;
                    }
                    case 3: {
                        Main.m_simData.dreamCompleteEvent(37);
                        break;
                    }
                    case 4: {
                        Main.m_simData.dreamCompleteEvent(34);
                        Minigame_maxedWorldKnowledgeFlag = true;
                    }
                }
            }
            if (n == 2 || n == 1 || n == 3) {
                Main.m_simWorld.isLocationMinigameAvailable = false;
            }
        }
        if (n2 != n3) {
            if (n3 == 5) {
                if (n == 4) return;
                GameConstants.TextHandler_dynamicString(-11, 686, Main.m_simData.getSkillDesc(n));
                Event.triggerEvent(4, -11, n);
                return;
            }
        }
        if (n2 == 5) return;
        int n5 = Main.m_simData.getSkillDesc(n);
        StateInGame.showMessageBox(n4, n5);
    }

    public static void Minigame_renderMiniGame() {
        AnimationManager.Touch_clear();
        switch (Minigame_m_miniGameType) {
            case 3: {
                GameConstants.MinigameWorldknowledge_render();
                break;
            }
        }
        if (StateInGame.m_tutorialMessageActive) {
            Debug.UserInterface_drawTextScreen();
        }
        if (StateInGame.m_pauseMenuActive) {
            StateInGame.renderPauseMenu();
        }
        StateInGame.renderSoftkeyBar();
    }

    public static void Minigame_processKeysMiniGame() {
        if (Main.softPressNeg(1) || AnimationManager.PMInput_isPressed(4) || Minigame_interruptedByExternalEvent) {
            Minigame_interruptedByExternalEvent = false;
            StateInGame.showPauseMenu();
            return;
        }
        if (Main.softPressPos(64)) {
            IStringConstants.Minigame_stateTransitionMiniGame(3);
            return;
        }
        switch (Minigame_m_miniGameType) {
            default: {
                break;
            }
            case 3: {
                GameConstants.MinigameWorldknowledge_processKeys();
            }
        }
    }

    public static void Minigame_updateMiniGame(int n) {
        if (StateInGame.m_pauseMenuActive || StateInGame.m_tutorialMessageActive) {
            return;
        }
        StateInGame.getPlayerSim().update(n);
        if (Minigame_m_miniGameTargetObject != null) {
            Minigame_m_miniGameTargetObject.update(n);
        }
        StateInGame.updateObjectTypes(n, 5);
        switch (Minigame_m_miniGameType) {
            case 3: {
                GameConstants.MinigameWorldknowledge_update(n);
                break;
            }
            case 1: {
                ArrayOptimizer.MinigameBartering_update(n);
                break;
            }
            case 2: {
                Cursor.MinigameLanguage_update(n);
                break;
            }
            case 0: {
                Intro.MinigameExcavation_update(n);
                break;
            }
        }
    }

    public static void Minigame_externalEvent() {
        if (Minigame_m_miniGameState != 4 && Minigame_m_miniGameState != 5 && !StateInGame.m_pauseMenuActive) {
            Minigame_interruptedByExternalEvent = true;
        }
    }

    public static void PMSystem_nextFrame() {
        if (PMSystem_internalLoop) {
            Event.PMDebug_println("Warning: internal loop detected!");
        }
        PMSystem_internalLoop = true;
        PMAudio.update();
        AnimationManager.PMInput_readKeys();
        Main.preFlush();
        Debug.PMGraphics_flush();
        IStringConstants.PMSystem_frameCap();
    }

    public static void PMSystem_sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void PMSystem_forceGC() {
    }

    public static void PMSystem_frameCap() {
        PMSystem_time2 = ArrayOptimizer.PMTimer_tick();
        if (PMSystem_time2 - PMSystem_time1 < 42L) {
            IStringConstants.PMSystem_sleep(42L - (PMSystem_time2 - PMSystem_time1));
        }
        PMSystem_time1 = ArrayOptimizer.PMTimer_tick();
    }

    static {
        PMSystem_internalLoop = false;
    }
}

