/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import com.ea.sdk.SDKString;
import dk.progressivemedia.skeleton.AnimPlayer;
import dk.progressivemedia.skeleton.AnimationManager;
import dk.progressivemedia.skeleton.Debug;
import dk.progressivemedia.skeleton.GameConstants;
import dk.progressivemedia.skeleton.IStringConstants;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MapObjectSim;
import dk.progressivemedia.skeleton.state.StateInGame;

public class MapObject {
    protected static final int[] s_tempInt10 = new int[10];
    public boolean isMapObject;
    private int m_type;
    private int m_id;
    private short m_typeString;
    private int m_flags;
    private int m_runtimeFlags;
    private int m_state;
    private int m_stateTime;
    private int m_posXF;
    private int m_posZF;
    private int m_facingDir;
    private byte m_footprintWidth;
    private byte m_footprintHeight;
    private boolean m_inView;
    private short m_breakCleanPoints;
    private int m_breakCleanTimer;
    private boolean m_updateCachedStuff;
    private int m_cachedZSortOrderLeft;
    private int m_cachedZSortOrderRight;
    private int m_occupiedFlags;
    private int m_effectMoney;
    private short m_animSetId;
    private AnimPlayer[] m_animPlayers = new AnimPlayer[1];
    private short m_effectAnimId;
    private int m_zSortOffsetLeft;
    private int m_zSortOffsetRight;
    private MapObjectSim m_postRenderTarget1;
    private MapObjectSim m_postRenderTarget2;

    public MapObject() {
        this.m_animPlayers[0] = new AnimPlayer();
        this.isMapObject = true;
    }

    public void init(int n, int n2, int n3, int n4, int n5) {
        this.setPos(n2, n3);
        this.setFacingDir(n4);
        this.m_type = n;
        this.m_id = n5;
        this.m_flags = Main.m_simWorld.getObjectFlags(n);
        this.m_runtimeFlags = 0;
        this.m_typeString = (short)Main.m_simWorld.getObjectStringId(n);
        this.m_zSortOffsetLeft = 0;
        this.m_zSortOffsetRight = 0;
        this.m_postRenderTarget1 = null;
        this.m_postRenderTarget2 = null;
        this.setRuntimeFlag(128);
        this.m_occupiedFlags = 0;
        int n6 = Main.m_simWorld.getObjectAnimId(n);
        int n7 = Main.m_simWorld.getObjectAnimSetId(n, 0);
        if (n == 35) {
            n6 = 74;
            Debug.ASSERT(n7 == 0, "player house shouldn't have an animset");
        }
        if (n6 == 87 && n7 != 0) {
            this.setAnimSet(n7);
        } else {
            this.m_animSetId = (short)-1;
            this.setAnim(n6);
        }
        this.setEffectAnimId(-1);
        int n8 = this.getObjectValue();
        int n9 = 0;
        if (n == 7) {
            n9 = 1;
        } else if (Main.m_simWorld.getObjectParent(n) == 12) {
            n9 = n8 & 0xFFFFFF;
        }
        this.stateTransition(n9);
        if ((n8 & 0x1000000) != 0) {
            this.breakObject();
        }
        if ((n8 & 0x2000000) != 0) {
            this.dirtyObject();
        }
        if (this.getFlag(0x6000000) && !this.getRuntimeFlag(768)) {
            this.m_breakCleanPoints = (short)(n8 & 0xFFFFFF);
            this.m_breakCleanTimer = 0;
            if (this.m_breakCleanPoints == 0) {
                this.m_breakCleanPoints = (short)Main.rand(0, 100);
            }
        }
        if (this.getParentType() == 7) {
            MapObject mapObject = StateInGame.createObject(23, this.getPosX(), this.getPosZ(), this.getFacingDir(), this.getId());
            mapObject.setZSortOffset(20);
        }
    }

    public void destroy() {
        StateInGame.removeObject(this);
        this.m_postRenderTarget1 = null;
        this.m_postRenderTarget2 = null;
    }

    public void setInView(boolean bl) {
        this.m_inView = bl;
    }

    public boolean isInView() {
        return this.m_inView;
    }

    public final int getType() {
        return this.m_type;
    }

    public final int getParentType() {
        return Main.m_simWorld.getObjectParent(this.m_type);
    }

    public final int getId() {
        return this.m_id;
    }

    public final int getTypeString() {
        if (this.getFlag(64)) {
            return this.getHouseTypeString();
        }
        return this.m_typeString;
    }

    public final int getPosX() {
        return this.m_posXF;
    }

    public final int getPosZ() {
        return this.m_posZF;
    }

    public void setPos(int n, int n2) {
        this.m_updateCachedStuff = true;
        this.m_posXF = n;
        this.m_posZF = n2;
    }

    public boolean getFlag(int n) {
        return (this.m_flags & n) != 0;
    }

    public void setFlag(int n) {
        this.m_flags |= n;
    }

    public boolean getRuntimeFlag(int n) {
        return (this.m_runtimeFlags & n) != 0;
    }

    public void setRuntimeFlag(int n) {
        this.m_runtimeFlags |= n;
    }

    public void unsetRuntimeFlag(int n) {
        this.m_runtimeFlags &= ~n;
    }

    protected void updateCachedStuff() {
        if (this.m_updateCachedStuff) {
            this.m_updateCachedStuff = false;
            int n = Main.m_simWorld.coordWorldToScreenPixelsY(this.m_posXF, this.m_posZF);
            this.m_cachedZSortOrderLeft = n + this.m_zSortOffsetLeft;
            this.m_cachedZSortOrderRight = n + this.m_zSortOffsetRight;
        }
    }

    public int getTooltipStringId() {
        if (this.getFlag(16)) {
            return this.getTypeString();
        }
        return 4;
    }

    public void getHotSpot(int[] nArray) {
        int n = 0;
        int n2 = 0;
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        int n3 = animPlayer.getAnimID();
        int n4 = animPlayer.getCurrAnimFrame();
        if (n3 != -1) {
            if (AnimationManager.getAnimFrameFirePoint(nArray, n3, n4, 0)) {
                n = nArray[0];
                n2 = nArray[1];
            } else if (this.getFlag(16384)) {
                n2 = StateInGame.isMapMode() ? (n2 -= 7) : (n2 -= 38);
            }
        }
        nArray[0] = Main.m_simWorld.coordWorldToScreenX(this.getPosX(), this.getPosZ()) + (n << 16);
        nArray[1] = Main.m_simWorld.coordWorldToScreenY(this.getPosX(), this.getPosZ()) + (n2 << 16);
    }

    public void getInterestPoint(int[] nArray, int n) {
        int n2 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
        int n3 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
        int n4 = Main.m_simWorld.getObjectInterestPointX(this.getType(), n, this.getFacingDir());
        int n5 = Main.m_simWorld.getObjectInterestPointZ(this.getType(), n, this.getFacingDir());
        int n6 = n2 + n4;
        int n7 = n3 + n5;
        nArray[0] = Main.m_simWorld.coordWorldTileToWorldCenterX(n6);
        nArray[1] = Main.m_simWorld.coordWorldTileToWorldCenterZ(n7);
    }

    public int getClosestInterestPoint(int n, int n2, boolean bl, MapObjectSim mapObjectSim) {
        int[] nArray = s_tempInt10;
        int n3 = Main.m_simWorld.getObjectInterestPointCount(this.getType());
        if (n3 > 0) {
            int n4 = -1;
            int n5 = Integer.MAX_VALUE;
            for (int i = 0; i < n3; ++i) {
                int n6;
                int n7;
                int n8;
                if (bl && !this.occupiedIsAvailable(i)) continue;
                this.getInterestPoint(nArray, i);
                int n9 = nArray[0];
                int n10 = nArray[1];
                if (!Main.m_simWorld.isWorldPointWalkable(n9, n10)) continue;
                if (bl && !this.getFlag(0x200000)) {
                    n8 = Main.m_simWorld.coordWorldToWorldTileX(n9);
                    n7 = Main.m_simWorld.coordWorldToWorldTileZ(n10);
                    n6 = 0;
                    MapObjectSim[] mapObjectSimArray = StateInGame.getSimObjects();
                    for (int j = 0; j < mapObjectSimArray.length && n6 == 0; ++j) {
                        MapObjectSim mapObjectSim2 = mapObjectSimArray[j];
                        if (mapObjectSim2 != null && mapObjectSim2.equals(mapObjectSim)) continue;
                        int n11 = Main.m_simWorld.coordWorldToWorldTileX(mapObjectSim2.getPosX());
                        int n12 = Main.m_simWorld.coordWorldToWorldTileZ(mapObjectSim2.getPosZ());
                        if (n11 != n8 || n12 != n7) continue;
                        n6 = 1;
                    }
                    if (n6 != 0) continue;
                }
                if ((n6 = (n8 = Math.abs(n - n9)) + (n7 = Math.abs(n2 - n10))) >= n5) continue;
                n5 = n6;
                n4 = i;
            }
            return n4;
        }
        return -1;
    }

    public boolean occupiedCapture(int n, MapObjectSim mapObjectSim) {
        if (this.getFlag(0x200000)) {
            return true;
        }
        if (this.getFlag(0x400000)) {
            if ((this.m_occupiedFlags & 1 << n) == 0) {
                this.m_occupiedFlags |= 1 << n;
                return true;
            }
        } else if (this.m_occupiedFlags == 0) {
            this.m_occupiedFlags = -1;
            return true;
        }
        return false;
    }

    public void occupiedRelease(int n) {
        if (this.getFlag(0x400000)) {
            Debug.ASSERT((this.m_occupiedFlags & 1 << n) != 0, "releasing already unoccupied flag");
            this.m_occupiedFlags &= ~(1 << n);
        } else {
            this.m_occupiedFlags = 0;
        }
    }

    public boolean occupiedIsEmpty() {
        if (this.getFlag(0x200000)) {
            return true;
        }
        return this.m_occupiedFlags == 0;
    }

    public boolean occupiedIsAnyAvailable() {
        if (this.occupiedIsEmpty()) {
            return true;
        }
        int n = Main.m_simWorld.getObjectInterestPointCount(this.getType());
        return this.m_occupiedFlags < (1 << n) - 1;
    }

    public boolean occupiedIsAvailable(int n) {
        return (this.m_occupiedFlags & 1 << n) == 0;
    }

    private int getObjectValue() {
        if (this.getId() == -1) {
            return 0;
        }
        return Main.m_simData.getObjectValue(Main.m_simWorld.getHouseId(), this.getId());
    }

    private void saveObjectValue() {
        if (this.getId() == -1) {
            return;
        }
        int n = 0;
        if (this.getParentType() == 12) {
            n = this.m_state;
        }
        if (this.getFlag(0x2000000) && this.getRuntimeFlag(256)) {
            n |= 0x1000000;
        }
        if (this.getFlag(0x4000000) && this.getRuntimeFlag(512)) {
            n |= 0x2000000;
        }
        if (Main.m_simWorld.getHouseId() == 0 && this.getFlag(0x6000000)) {
            n |= this.m_breakCleanPoints;
        }
        if (this.getRuntimeFlag(32768)) {
            n |= 0x8000000;
        }
        if (this.getRuntimeFlag(16384)) {
            n |= 0x4000000;
        }
        Main.m_simData.saveObjectValue(Main.m_simWorld.getHouseId(), this.getId(), n);
    }

    public boolean isIdle() {
        if (this.getParentType() == 12) {
            return !this.isAnimating() && !this.isAnimating(1) && this.m_state != 1;
        }
        return this.m_state == 0;
    }

    public boolean isActive() {
        if (this.getParentType() == 12 && (this.isAnimating() || this.isAnimating(1))) {
            return false;
        }
        return this.m_state == 1;
    }

    protected final void stateTransition(int n) {
        int n2 = this.getParentType();
        if (n2 == 2) {
            this.basinStateTransition(n);
        } else if (n2 == 7) {
            this.doorStateTransition(n);
        } else if (n2 == 13) {
            this.showerStateTransition(n);
        } else if (n2 == 15) {
            this.stoveStateTransition(n);
        }
        this.m_state = n;
        this.m_stateTime = 0;
    }

    public void update(int n) {
        this.m_stateTime += n;
        if (this.getFlag(0x6000000) && !this.getRuntimeFlag(768)) {
            this.m_breakCleanTimer += n;
            if (this.m_breakCleanTimer > 4000) {
                this.m_breakCleanTimer -= 4000;
                this.addBreakCleanPoints(1);
            }
        }
        if (this.getRuntimeFlag(1)) {
            n = StateInGame.getNormalTimeStep();
        }
        int n2 = this.getType();
        int n3 = this.getParentType();
        this.updateAnim(n);
        if (!this.isAnimating()) {
            // empty if block
        }
        if (n2 == 5) {
            if (!this.isAnimating()) {
                this.destroy();
            }
        } else if (n2 == 6 && this.m_stateTime > 1500) {
            this.destroy();
        }
    }

    protected void updateAnim(int n) {
        if (this.getRuntimeFlag(4096)) {
            n = IStringConstants.MathExt_Fmul(n << 16, 49152) >> 16;
        }
        boolean bl = this.updateAnimPlayer(n, 0);
        if (this.updateAnimPlayer(n, 1)) {
            bl = true;
        }
        if (this.m_effectAnimId != -1 && bl) {
            this.spawnEffects();
        }
    }

    protected boolean updateAnimPlayer(int n, int n2) {
        AnimPlayer animPlayer = this.getAnimPlayer(n2);
        if (animPlayer != null) {
            return animPlayer.updateAnim(n);
        }
        return false;
    }

    protected final void spawnEffects() {
        int n;
        int[] nArray = s_tempInt10;
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        AnimPlayer animPlayer2 = this.getAnimPlayer(1);
        int n2 = 1;
        AnimPlayer animPlayer3 = animPlayer;
        int n3 = 0;
        int n4 = 0;
        if (animPlayer2 != null && animPlayer2.isAnimating()) {
            animPlayer3 = animPlayer2;
            n2 = 0;
            if (animPlayer.getFirePointCurrFrame(nArray, 1)) {
                n3 = nArray[0];
                n4 = nArray[1];
            } else if (this.getRuntimeFlag(1024)) {
                n4 = -30;
            }
        }
        if ((n = animPlayer3.getNumFirePointsCurrFrame()) > n2) {
            for (int i = n2; i < n; ++i) {
                int n5 = this.getPosX();
                int n6 = this.getPosZ();
                int n7 = Main.m_simWorld.coordWorldToScreenX(n5, n6);
                int n8 = Main.m_simWorld.coordWorldToScreenY(n5, n6);
                animPlayer3.getFirePointCurrFrame(nArray, i);
                n5 = Main.m_simWorld.coordScreenToWorldX(n7 += nArray[0] + n3 << 16, n8 += nArray[1] + n4 << 16);
                n6 = Main.m_simWorld.coordScreenToWorldZ(n7, n8);
                int n9 = -(nArray[1] + n4);
                if (this.getFlag(262144)) {
                    n9 += 2;
                }
                StateInGame.createEffectAnim(n5, n6, this.m_effectAnimId, n9);
            }
        }
    }

    public boolean respondToAction(int n, MapObjectSim mapObjectSim) {
        if (this.getType() == 7) {
            if (n == 115) {
                if (this.getId() != -1) {
                    Main.m_simWorld.objectSell(this.getId());
                }
                this.destroy();
            }
        } else if (this.getParentType() == 7) {
            if (n == 116 || n == 119) {
                this.stateTransition(1);
                if (mapObjectSim.getId() == 0) {
                    if (!Main.m_simData.getSimCurRelStateFlags(0, 1)) {
                        StateInGame.advertiseEvent(21, mapObjectSim, this);
                    }
                }
            } else if (n == 117) {
                if (!StateInGame.isObjectAt(0, this.getPosX(), this.getPosZ())) {
                    this.stateTransition(0);
                }
            } else if (n == 118 && mapObjectSim.getId() == 0) {
                StateInGame.advertiseEvent(22, mapObjectSim, this);
            }
        } else if (this.getParentType() == 18) {
            if (n == 103) {
                this.unsetRuntimeFlag(16384);
                this.setRuntimeFlag(32768);
                this.saveObjectValue();
            } else if (n == 102) {
                this.setRuntimeFlag(16384);
                this.unsetRuntimeFlag(32768);
                this.saveObjectValue();
            }
        }
        return false;
    }

    public void breakObject() {
        this.setRuntimeFlag(256);
        switch (this.getParentType()) {
            case 11: 
            case 18: {
                this.turnOff();
                break;
            }
        }
        this.saveObjectValue();
        this.setSecondaryAnim(37, 20);
        StateInGame.showTutorialMessage((byte)9);
    }

    public void repairObject() {
        this.unsetRuntimeFlag(256);
        this.saveObjectValue();
        this.stopSecondaryAnim();
    }

    public void dirtyObject() {
        this.setRuntimeFlag(512);
        this.saveObjectValue();
        this.setSecondaryAnim(46, 20);
        StateInGame.showTutorialMessage((byte)10);
    }

    public void cleanObject() {
        this.unsetRuntimeFlag(512);
        this.saveObjectValue();
        this.stopSecondaryAnim();
    }

    public void addBreakCleanPoints(int n) {
        if (Main.m_simWorld.getHouseId() != 0) {
            return;
        }
        this.m_breakCleanPoints = (short)(this.m_breakCleanPoints + n);
        if (this.m_breakCleanPoints > 300) {
            this.m_breakCleanPoints = 0;
            if (this.getFlag(0x2000000)) {
                this.breakObject();
            } else {
                this.dirtyObject();
            }
        }
        this.saveObjectValue();
    }

    public void turnOn() {
        int n = this.getParentType();
        if (n == 11 || n == 18) {
            this.setAnimSetIndex(1);
        }
        if (n == 18 && !this.getRuntimeFlag(49152)) {
            this.setRuntimeFlag(32768);
        }
        this.setRuntimeFlag(64);
        this.addBreakCleanPoints(15);
    }

    public void turnOff() {
        int n = this.getParentType();
        if (n == 11 || n == 18) {
            this.setAnimSetIndex(0);
        }
        this.unsetRuntimeFlag(64);
        this.addBreakCleanPoints(15);
    }

    public void effectPlayAnim(int n, int n2) {
        this.unsetRuntimeFlag(128);
        this.setAnim(n);
        if (n == 40 || n == 41) {
            this.setRuntimeFlag(1);
        }
        this.setZSortOffset(n2);
    }

    public void effectShowMoney(int n) {
        this.m_effectMoney = n;
        this.setAnim(87);
        this.setZSortOffset(30);
    }

    private void renderMoneyEffect(int n, int n2) {
        int n3 = IStringConstants.MathExt_smoothstepF(0, 1500, this.m_stateTime);
        int n4 = -40 + IStringConstants.MathExt_Fmul(n3, -30);
        SDKString sDKString = GameConstants.TextHandler_clearStringBuffer();
        GameConstants.TextHandler_appendMoneyToBuffer(this.m_effectMoney);
        GameConstants.TextHandler_drawString(sDKString, 0, n, n2 + n4, 17);
    }

    public void basinStart() {
        this.stateTransition(1);
    }

    public void basinEnd() {
        this.stateTransition(0);
    }

    private void basinStateTransition(int n) {
        int n2 = 0;
        int n3 = -1;
        switch (n) {
            default: {
                Debug.ASSERT(false, "invalid state for basin");
            }
            case 0: {
                n3 = -1;
                n2 = 0;
                break;
            }
            case 1: {
                n3 = 49;
                n2 = 1;
            }
        }
        this.setEffectAnimId(n3);
        this.setAnimSetIndex(n2);
    }

    public int bedGetRelStateFlags() {
        MapObject[] mapObjectArray = StateInGame.getObjects();
        MapObject mapObject = null;
        for (int i = 0; i < mapObjectArray.length; ++i) {
            MapObject mapObject2 = mapObjectArray[i];
            if (mapObject2 != null && mapObject2.equals(this) || mapObject2.getParentType() != 4) continue;
            mapObject = mapObject2;
            break;
        }
        if (mapObject != null) {
            if (this.getId() < mapObject.getId()) {
                return 512;
            }
            return 1024;
        }
        return 512;
    }

    public boolean chairShouldSnap() {
        int n;
        int n2 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
        return !Main.m_simWorld.isAgainstWall(n2, n = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ()), 1, 1, this.getFacingDir());
    }

    private void doorStateTransition(int n) {
        this.m_state = n;
        int n2 = -1;
        int n3 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                n3 = 0;
                this.unsetRuntimeFlag(64);
                break;
            }
            case 1: {
                n2 = 1;
                n3 = -15;
                this.setRuntimeFlag(64);
                break;
            }
        }
        this.setAnimSetIndex(n2);
        this.applyFootprint(!this.getRuntimeFlag(64));
        this.setZSortOffset(n3);
    }

    public void fridgeOpen() {
        this.setAnimSetIndex(1);
    }

    public void fridgeClose() {
        this.setAnimSetIndex(0);
        this.addBreakCleanPoints(15);
    }

    private final int getHouseTypeString() {
        int n = -1;
        int n2 = -1;
        int n3 = Main.m_simWorld.getHouseForObject(this.getType());
        int n4 = Main.m_simData.getSimCount();
        for (int i = 0; i < n4; ++i) {
            int n5 = Main.m_simData.getSimHome(i);
            if (n5 != n3) continue;
            if (n == -1) {
                n = i;
                continue;
            }
            if (n2 == -1) {
                n2 = i;
                continue;
            }
            Debug.ASSERT(false, "argh, three sims in the one house!");
        }
        if (n == -1 && n2 == -1) {
            return 170;
        }
        SDKString sDKString = n == 0 ? Main.getSimName() : GameConstants.TextHandler_getString(Main.m_simData.getSimName(n));
        if (n2 == -1) {
            GameConstants.TextHandler_dynamicString(-10, 171, sDKString);
        } else {
            SDKString sDKString2 = GameConstants.TextHandler_getString(Main.m_simData.getSimName(n2));
            GameConstants.TextHandler_dynamicString(-10, 172, sDKString, sDKString2);
        }
        return -10;
    }

    public void phonePickup() {
        this.setAnimSetIndex(1);
    }

    public void phoneHangup() {
        this.setAnimSetIndex(0);
    }

    public void interactStart() {
        if (this.getType() == 42) {
            this.setAnimSetIndex(Main.rand(1, 3));
        } else {
            this.setAnimSetIndex(1);
        }
    }

    public void interactEnd() {
        this.setAnimSetIndex(0);
    }

    public void showerStart() {
        this.stateTransition(1);
    }

    public void showerEnd() {
        this.addBreakCleanPoints(15);
        this.stateTransition(0);
    }

    private void showerStateTransition(int n) {
        this.m_state = n;
        int n2 = -1;
        int n3 = -1;
        switch (n) {
            default: {
                Debug.ASSERT(false, "invalid state for shower");
            }
            case 0: {
                n3 = -1;
                n2 = 0;
                break;
            }
            case 1: {
                n3 = 47;
                n2 = 1;
            }
        }
        this.setEffectAnimId(n3);
        this.setAnimSetIndex(n2);
    }

    public void stoveStart() {
        this.stateTransition(1);
    }

    public void stoveEnd() {
        this.stateTransition(0);
    }

    private void stoveStateTransition(int n) {
        this.m_state = n;
        int n2 = -1;
        int n3 = -1;
        switch (n) {
            default: {
                Debug.ASSERT(false, "invalid state for stove");
            }
            case 0: {
                n3 = -1;
                n2 = 0;
                break;
            }
            case 1: {
                n3 = 47;
                n2 = 1;
            }
        }
        this.setEffectAnimId(n3);
        this.setAnimSetIndex(n2);
    }

    public AnimPlayer getAnimPlayer(int n) {
        if (n < this.m_animPlayers.length) {
            return this.m_animPlayers[n];
        }
        return null;
    }

    protected AnimPlayer getAnimPlayerCreate(int n) {
        Object object;
        if (n >= this.m_animPlayers.length) {
            object = new AnimPlayer[n + 1];
            System.arraycopy(this.m_animPlayers, 0, object, 0, this.m_animPlayers.length);
            this.m_animPlayers = object;
        }
        if (this.m_animPlayers[n] == null) {
            this.m_animPlayers[n] = object = new AnimPlayer();
            ((AnimPlayer)object).setAnimating(false);
        }
        return this.m_animPlayers[n];
    }

    protected void setSecondaryAnim(int n, int n2) {
        AnimPlayer animPlayer = this.getAnimPlayerCreate(1);
        animPlayer.startAnim(n, n2);
    }

    protected void stopSecondaryAnim() {
        AnimPlayer animPlayer = this.getAnimPlayer(1);
        if (animPlayer != null) {
            animPlayer.setAnimating(false);
        }
    }

    public void setEffectAnimId(int n) {
        this.m_effectAnimId = (short)n;
    }

    public int getZSortOrderLeft() {
        this.updateCachedStuff();
        return this.m_cachedZSortOrderLeft;
    }

    public int getZSortOrderRight() {
        this.updateCachedStuff();
        return this.m_cachedZSortOrderRight;
    }

    public void setZSortOffset(int n) {
        this.m_zSortOffsetLeft = n;
        this.m_zSortOffsetRight = n;
        this.m_updateCachedStuff = true;
    }

    public void setPostRenderTarget(MapObjectSim mapObjectSim) {
        if (this.m_postRenderTarget1 == null) {
            this.m_postRenderTarget1 = mapObjectSim;
        } else if (this.m_postRenderTarget2 == null) {
            this.m_postRenderTarget2 = mapObjectSim;
        } else {
            Debug.ASSERT(false, "can't have three post-render targets");
        }
    }

    public void releasePostRenderTarget(MapObjectSim mapObjectSim) {
        if (this.m_postRenderTarget1 != null && this.m_postRenderTarget1.equals(mapObjectSim)) {
            this.m_postRenderTarget1 = null;
        }
        if (this.m_postRenderTarget2 != null && this.m_postRenderTarget2.equals(mapObjectSim)) {
            this.m_postRenderTarget2 = null;
        }
    }

    public void render2D() {
        int[] nArray = s_tempInt10;
        int n = Main.m_simWorld.getCameraPixelX();
        int n2 = Main.m_simWorld.getCameraPixelY();
        int n3 = n + Main.m_simWorld.coordWorldToScreenPixelsX(this.getPosX(), this.getPosZ());
        int n4 = n2 + Main.m_simWorld.coordWorldToScreenPixelsY(this.getPosX(), this.getPosZ());
        if (this.getType() == 6) {
            this.renderMoneyEffect(n3, n4);
            return;
        }
        AnimPlayer animPlayer = this.getAnimPlayer(0);
        animPlayer.drawAnim(n3, n4);
        int n5 = this.getParentType();
        int n6 = n3;
        int n7 = n4;
        AnimPlayer animPlayer2 = this.getAnimPlayer(1);
        if (animPlayer2 != null && animPlayer2.isAnimating()) {
            if (animPlayer.getFirePointCurrFrame(nArray, 1)) {
                n6 += nArray[0];
                n7 += nArray[1];
            } else if (animPlayer.getFirePointCurrFrame(nArray, 0)) {
                n6 += nArray[0];
                n7 += nArray[1];
            }
            animPlayer2.drawAnim(n6, n7);
        }
        if (this.getFlag(0x1000000)) {
            if (this.m_postRenderTarget1 != null) {
                this.m_postRenderTarget1.render2DPost();
            }
            if (this.m_postRenderTarget2 != null) {
                this.m_postRenderTarget2.render2DPost();
            }
            int n8 = Main.m_simWorld.getObjectAnimSetId(this.getType(), 1);
            int n9 = Main.m_simWorld.getAnim(n8, this.getFacingDir());
            AnimationManager.drawAnimFrame(n9, 0, n3, n4);
        }
    }

    public void applyFootprint(boolean bl) {
        int n;
        int n2;
        int n3 = Main.m_simWorld.coordWorldToWorldTileX(this.getPosX());
        int n4 = Main.m_simWorld.coordWorldToWorldTileZ(this.getPosZ());
        int n5 = Main.m_simWorld.getObjectFootprintWidth(this.getType());
        int n6 = Main.m_simWorld.getObjectFootprintHeight(this.getType());
        if (this.getFacingDir() == 1 || this.getFacingDir() == 3) {
            n2 = n5;
            n5 = n6;
            n6 = n2;
        }
        if (bl) {
            if (this.getParentType() == 7) {
                n2 = 255;
                n = 32;
            } else {
                n2 = 255;
                n = 128;
            }
        } else {
            n2 = ~(0x80 | 0x20);
            n = 0;
        }
        Main.m_simWorld.paintAttributes(n3 - n5 + 1, n4 - n6 + 1, n5, n6, n2, n);
        this.m_footprintWidth = (byte)n5;
        this.m_footprintHeight = (byte)n6;
        int n7 = this.m_type;
        if (this.getFlag(0x800000)) {
            this.setZSortOffset(-16);
        } else if (this.getFlag(8)) {
            this.setZSortOffset(0);
        } else if (this.getParentType() == 9) {
            this.setZSortOffset(-3);
        } else if (n7 == 17) {
            this.m_zSortOffsetLeft = n5 * -8 + 4;
            this.m_zSortOffsetRight = (n6 - 1) * -8 + 4;
        } else if (n7 == 31) {
            this.setZSortOffset(-9);
        } else if (n7 == 21) {
            this.m_zSortOffsetLeft = n5 * -8 + 4;
            this.m_zSortOffsetRight = n6 * -8 + 4;
        } else if (n5 != 0 && n6 != 0) {
            this.m_zSortOffsetLeft = n5 * -8 + 4;
            this.m_zSortOffsetRight = n6 * -8 + 4;
        }
        this.m_updateCachedStuff = true;
    }

    public int getFacingDir() {
        return this.m_facingDir;
    }

    public void setFacingDir(int n) {
        if (this.m_facingDir != n) {
            this.m_updateCachedStuff = true;
            this.m_facingDir = n;
            if (this.m_animSetId != -1) {
                this.setAnimSet(this.m_animSetId);
            }
        }
    }

    public void setFacingDir(int n, int n2) {
        if (Math.abs(n) > Math.abs(n2)) {
            if (n < 0) {
                this.setFacingDir(2);
            } else {
                this.setFacingDir(0);
            }
        } else if (n2 < 0) {
            this.setFacingDir(3);
        } else {
            this.setFacingDir(1);
        }
    }

    public void setFacingObject(MapObject mapObject) {
        int n = Math.max(mapObject.m_footprintWidth - 1, 0);
        int n2 = Math.max(mapObject.m_footprintHeight - 1, 0);
        int n3 = n << 3 + 15;
        int n4 = n2 << 3 + 15;
        int n5 = mapObject.getPosX() - n3;
        int n6 = mapObject.getPosZ() - n4;
        this.setFacingDir(n5 - this.getPosX(), n6 - this.getPosZ());
    }

    public void setAnim(int n) {
        if (this.getRuntimeFlag(128)) {
            this.getAnimPlayer(0).startAnim(n, 20);
        } else {
            this.getAnimPlayer(0).startAnim(n, 16);
        }
    }

    public boolean isAnimating() {
        return this.m_animPlayers[0].isAnimating();
    }

    public boolean isAnimating(int n) {
        AnimPlayer animPlayer = this.getAnimPlayer(n);
        return animPlayer != null && animPlayer.isAnimating();
    }

    public void setAnimSet(int n) {
        this.m_animSetId = (short)n;
        int n2 = Main.m_simWorld.getAnim(n, this.getFacingDir());
        this.setAnim(n2);
    }

    public void setAnimSetIndex(int n) {
        this.setAnimSet(Main.m_simWorld.getObjectAnimSetId(this.getType(), n));
    }
}

