/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public final class Fonts {
    public static int fontsCnt;
    public static final int DIACRITIC_SHIFT_X = 0;
    public static final int DIACRITIC_SHIFT_Y = 0;
    private static PlatformImage[] imageCache;
    private static byte[] imageColorVariantsCnt;
    private static final int UPPER_START_LA = 65;
    private static final int UPPER_END_LA = 90;
    private static final int LOWER_START_LA = 97;
    private static final int LOWER_END_LA = 122;
    private static final int UPPER_START_RU = 1040;
    private static final int UPPER_END_RU = 1071;
    private static final int LOWER_START_RU = 1072;
    private static final int LOWER_END_RU = 1103;
    private static final int UPPER_START_GR = 913;
    private static final int UPPER_END_GR = 937;
    private static final int LOWER_START_GR = 945;
    private static final int LOWER_END_GR = 969;
    private static int UPPER_START;
    private static int UPPER_END;
    private static int LOWER_START;
    private static int LOWER_END;
    private static int N_UPPER;
    private static int N_LOWER;
    private static int N_BASE_LETTERS;
    private static final int SPACE = 32;
    private static final int NO_BREAK_SPACE = 160;
    private static final int FRG_OFFSET_X_INDEX = 0;
    private static final int FRG_OFFSET_Y_INDEX = 1;
    private static final int FRG_W_INDEX = 2;
    private static final int FRG_H_INDEX = 3;
    private static final int FRG_BASE_LINE_INDEX = 4;
    private static final int FRG_INFO_CNT = 5;
    private static String baseDiacritics;
    private static String baseLetters;
    private static byte[] baseDecodes;
    private static String[] fontChars;
    private static byte[] fontW;
    private static byte[] fontH;
    private static byte[] diacriticXShift;
    private static byte[] diacriticYShift;
    private static byte[] diacriticYUpShift;
    private static byte[][] lettersProp;
    private static boolean[] upperLetters;
    private static boolean[] inverseFont;
    private static byte[] spaceLetterW;
    public static byte[] spaceW;
    public static String fontName;
    private static char[] textBuffer;

    public static boolean initFont() {
        boolean bl;
        String string;
        String string2 = GMain.langCodes[GMain.langIndex].toLowerCase();
        if (string2.equals("el")) {
            string = "/font__el";
            UPPER_START = 913;
            UPPER_END = 937;
            LOWER_START = 945;
            LOWER_END = 969;
        } else if (string2.equals("ru")) {
            string = "/font__ru";
            UPPER_START = 1040;
            UPPER_END = 1071;
            LOWER_START = 1072;
            LOWER_END = 1103;
        } else {
            string = "/font";
            UPPER_START = 65;
            UPPER_END = 90;
            LOWER_START = 97;
            LOWER_END = 122;
        }
        N_UPPER = UPPER_END - UPPER_START;
        N_LOWER = LOWER_END - LOWER_START;
        N_BASE_LETTERS = N_UPPER + N_LOWER;
        boolean bl2 = bl = !string.equals(fontName);
        if (bl && imageCache != null && imageCache.length > 0) {
            for (int i = imageCache.length - 1; i > -1; --i) {
                Fonts.imageCache[i] = null;
            }
        }
        fontName = string;
        return bl;
    }

    public static void readFontGraphics(PlatformResource platformResource) {
        int n;
        Fonts.initFont();
        fontsCnt = platformResource.readShort();
        imageCache = new PlatformImage[fontsCnt];
        imageColorVariantsCnt = new byte[fontsCnt];
        for (n = 0; n < fontsCnt; n += imageColorVariantsCnt[n]) {
            Utils.readDiffImage(platformResource, imageCache, imageColorVariantsCnt, n, -1);
        }
        baseDiacritics = platformResource.readUTF();
        baseLetters = platformResource.readUTF();
        baseDecodes = new byte[platformResource.readShort()];
        if (baseDecodes.length > 0) {
            platformResource.readFully(baseDecodes);
        }
        platformResource.readShort();
        fontChars = new String[fontsCnt];
        fontH = new byte[fontsCnt];
        fontW = new byte[fontsCnt];
        diacriticXShift = new byte[fontsCnt];
        diacriticYShift = new byte[fontsCnt];
        diacriticYUpShift = new byte[fontsCnt];
        upperLetters = new boolean[fontsCnt];
        inverseFont = new boolean[fontsCnt];
        lettersProp = new byte[fontsCnt][];
        spaceW = new byte[fontsCnt];
        spaceLetterW = new byte[fontsCnt];
        platformResource.readShort();
        for (n = 0; n < fontsCnt; ++n) {
            int n2 = n;
            int n3 = imageColorVariantsCnt[n2];
            Fonts.fontChars[n] = platformResource.readUTF();
            Fonts.upperLetters[n] = false;
            Fonts.lettersProp[n] = null;
            Fonts.spaceW[n] = 0;
            int n4 = platformResource.readShort();
            while (--n4 >= 0) {
                switch (platformResource.readByte()) {
                    case 0: {
                        Fonts.upperLetters[n] = platformResource.readBoolean();
                        break;
                    }
                    case 1: {
                        short s = platformResource.readShort();
                        Fonts.lettersProp[n] = new byte[s];
                        if (s > 0) {
                            platformResource.readFully(lettersProp[n]);
                        }
                        Fonts.fontH[n] = (byte)(lettersProp[n][3] + lettersProp[n][4]);
                        break;
                    }
                    case 2: {
                        Fonts.spaceW[n] = platformResource.readByte();
                        break;
                    }
                    case 3: {
                        Fonts.diacriticYUpShift[n] = platformResource.readByte();
                        break;
                    }
                    case 4: {
                        Fonts.fontH[n] = platformResource.readByte();
                        break;
                    }
                    case 5: {
                        Fonts.diacriticXShift[n] = platformResource.readByte();
                        break;
                    }
                    case 6: {
                        Fonts.diacriticYShift[n] = platformResource.readByte();
                        break;
                    }
                    case 7: {
                        Fonts.inverseFont[n] = platformResource.readByte() != 0;
                        break;
                    }
                    case 8: {
                        Fonts.spaceLetterW[n] = platformResource.readByte();
                    }
                }
            }
            if (spaceLetterW[n] <= 0) {
                Fonts.spaceLetterW[n] = lettersProp[n][2];
            }
            while (n3 > 1) {
                Fonts.fontChars[++n] = fontChars[n - 1];
                Fonts.fontH[n] = fontH[n - 1];
                Fonts.fontW[n] = fontW[n - 1];
                Fonts.upperLetters[n] = upperLetters[n - 1];
                Fonts.lettersProp[n] = lettersProp[n - 1];
                Fonts.spaceW[n] = spaceW[n - 1];
                Fonts.spaceLetterW[n] = spaceLetterW[n - 1];
                Fonts.diacriticXShift[n] = diacriticXShift[n - 1];
                Fonts.diacriticYShift[n] = diacriticYShift[n - 1];
                Fonts.diacriticYUpShift[n] = diacriticYUpShift[n - 1];
                Fonts.inverseFont[n] = inverseFont[n - 1];
                --n3;
            }
        }
    }

    public static void drawGraphicString(int n, char[] cArray, int n2, int n3, int n4, int n5, int n6) {
        byte by;
        int n7;
        PlatformGraphics platformGraphics = Platform.getDisplayGraphics();
        if (lettersProp == null || n >= lettersProp.length) {
            return;
        }
        PlatformImage platformImage = imageCache[n];
        byte by2 = diacriticXShift[n];
        byte by3 = diacriticYShift[n];
        byte by4 = diacriticYUpShift[n];
        boolean bl = upperLetters[n];
        int n8 = lettersProp[n].length / 5;
        if ((n6 & 8) != 0) {
            n4 -= Fonts.getStringWidth(n, cArray, 0, n3);
        } else if ((n6 & 1) != 0) {
            n4 -= Fonts.getStringWidth(n, cArray, 0, n3) >> 1;
        }
        if ((n6 & 0x20) != 0) {
            n5 -= fontH[n];
        } else if ((n6 & 2) != 0) {
            n5 -= fontH[n] >> 1;
            n7 = (n8 - 10 + 9) * 5;
            n5 += lettersProp[n][n7 + 3] + by4;
        } else if ((n6 & 0x10) != 0) {
            n7 = (n8 - 10 + 9) * 5;
            n5 += lettersProp[n][n7 + 3] + by4;
        }
        n7 = 20;
        int n9 = 0;
        byte by5 = by = spaceLetterW[n];
        byte by6 = fontH[n];
        int n10 = 0;
        byte by7 = spaceW[n];
        int n11 = N_BASE_LETTERS + 2;
        if (bl) {
            n11 = N_LOWER + 1;
        }
        int n12 = n2 + n3;
        for (int i = n2; i < n12; ++i) {
            char c;
            int n13;
            int n14;
            int n15;
            boolean bl2;
            int n16;
            block35: {
                int n17;
                block36: {
                    block34: {
                        n17 = cArray[i];
                        if (bl && (n17 >= UPPER_START && n17 <= UPPER_END || n17 >= LOWER_START && n17 <= LOWER_END || LOWER_START != 97 && n17 >= 97 && n17 <= 122)) {
                            n17 = Fonts.toUpperCase((char)n17);
                        } else if (LOWER_START != 97 && n17 >= 97 && n17 <= 122) {
                            n17 = Fonts.toUpperCase((char)n17);
                        }
                        n16 = 0;
                        boolean bl3 = n17 >= UPPER_START && n17 <= UPPER_END;
                        bl2 = false;
                        if (!bl3 && !bl) {
                            boolean bl4 = bl2 = n17 >= LOWER_START && n17 <= LOWER_END;
                        }
                        if (!bl3 && !bl2) {
                            n15 = baseDiacritics.length();
                            for (n14 = 0; n14 < n15; ++n14) {
                                if (baseDiacritics.charAt(n14) != n17) continue;
                                n17 = baseLetters.charAt(n14);
                                n16 = baseDecodes[n14];
                                if (!bl) break;
                                n17 = Fonts.toUpperCase((char)n17);
                                break;
                            }
                            bl3 = n17 >= UPPER_START && n17 <= UPPER_END;
                            bl2 = false;
                            if (!bl3 && !bl) {
                                boolean bl5 = bl2 = n17 >= LOWER_START && n17 <= LOWER_END;
                            }
                        }
                        if (!bl3) break block34;
                        n10 = n17 - UPPER_START;
                        break block35;
                    }
                    if (!bl2) break block36;
                    n10 = n17 - LOWER_START + N_UPPER + 1;
                    if (n17 != 105 || n16 != 0) break block35;
                    n16 = 10;
                    break block35;
                }
                if (n17 == 32 || n17 == 160) {
                    n4 += by + by7;
                    continue;
                }
                n15 = fontChars[n].length();
                n14 = n17;
                if (bl) {
                    if (n17 == 231) {
                        n14 = 199;
                    } else if (n17 == 261) {
                        n14 = 260;
                    } else if (n17 == 281) {
                        n14 = 280;
                    } else if (n17 == 322) {
                        n14 = 321;
                    }
                }
                for (n13 = 0; n13 < n15; ++n13) {
                    c = fontChars[n].charAt(n13);
                    if (c != n17 && (!bl || c != n14)) continue;
                    n10 = n13 + n11;
                    break;
                }
            }
            n15 = n10 * 5;
            int n18 = lettersProp[n][n15++] & 0xFF;
            n9 = lettersProp[n][n15++] & 0xFF;
            by5 = lettersProp[n][n15++];
            by6 = lettersProp[n][n15++];
            int n19 = lettersProp[n][n15];
            platformGraphics.drawRegion(platformImage, n18, n9, by5, by6, 0, n4, n5 + n19, n7);
            if (n16 > 0) {
                n14 = by5 >> 1;
                n13 = n19;
                if (n16 == 2) {
                    n14 += by5 >> 1;
                }
                if (n16 > 1) {
                    n16 = (byte)(n16 - 1);
                }
                n15 = (n8 - 10 + n16) * 5;
                n18 = lettersProp[n][n15++] & 0xFF;
                n9 = lettersProp[n][n15++] & 0xFF;
                c = lettersProp[n][n15++];
                byte by8 = lettersProp[n][n15++];
                n14 += by2;
                if (n16 == 1) {
                    n14 += c >> 1;
                } else if (n16 == 2) {
                    n14 -= c >> 1;
                }
                n13 = bl2 ? (n13 += by3) : (n13 += by4);
                platformGraphics.drawRegion(platformImage, n18, n9, c, by8, 0, n4 + (n14 += 0), n5 + (n13 += 0) - by8, 17);
                n9 = 0;
            }
            n4 += by5 + by7;
        }
    }

    public static void drawGraphicString(int n, String string, int n2, int n3, int n4) {
        int n5 = Fonts.toTextBuffer(string);
        Fonts.drawGraphicString(n, textBuffer, 0, n5, n2, n3, n4);
    }

    public static int getStringWidth(int n, String string) {
        if (lettersProp == null || n >= lettersProp.length) {
            return -1;
        }
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n2 += Fonts.getCharWidth(n, string.charAt(i));
        }
        return n2 - spaceW[n];
    }

    public static int getStringWidth(int n, char[] cArray, int n2, int n3) {
        if (n2 > cArray.length) {
            return 0;
        }
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            n4 += Fonts.getCharWidth(n, cArray[i]);
        }
        return n4;
    }

    public static int getCharWidth(int n, char c) {
        int n2;
        int n3;
        block9: {
            int n4;
            int n5;
            boolean bl;
            block10: {
                block8: {
                    if (lettersProp == null || n >= lettersProp.length) {
                        return -1;
                    }
                    bl = upperLetters[n];
                    n3 = fontW[n];
                    n2 = 0;
                    boolean bl2 = c >= UPPER_START && c <= UPPER_END;
                    boolean bl3 = false;
                    if (!bl2 && !bl) {
                        boolean bl4 = bl3 = c >= LOWER_START && c <= LOWER_END;
                    }
                    if (!bl2 && !bl3) {
                        n5 = baseDiacritics.length();
                        for (n4 = 0; n4 < n5; ++n4) {
                            if (baseDiacritics.charAt(n4) != c) continue;
                            c = baseLetters.charAt(n4);
                            break;
                        }
                    }
                    if (bl && (c >= UPPER_START && c <= UPPER_END || c >= LOWER_START && c <= LOWER_END || LOWER_START != 97 && c >= 'a' && c <= 'z')) {
                        c = Fonts.toUpperCase(c);
                    }
                    if (c < UPPER_START || c > UPPER_END) break block8;
                    n2 = c - UPPER_START;
                    break block9;
                }
                if (c < LOWER_START || c > LOWER_END) break block10;
                n2 = c - LOWER_START + N_UPPER + 1;
                if (!bl) break block9;
                n2 -= N_UPPER + 1;
                break block9;
            }
            if (c == ' ' || c == '\u00a0') {
                return spaceLetterW[n] + spaceW[n];
            }
            n5 = fontChars[n].length();
            for (n4 = 0; n4 < n5; ++n4) {
                if (fontChars[n].charAt(n4) != c) continue;
                if (bl) {
                    n2 = n4 + N_BASE_LETTERS - N_LOWER + 1;
                    break;
                }
                n2 = n4 + N_BASE_LETTERS + 2;
                break;
            }
        }
        n3 = lettersProp[n][n2 * 5 + 2] + spaceW[n];
        return n3;
    }

    public static char toUpperCase(char c) {
        if (c >= UPPER_START && c <= UPPER_END) {
            return c;
        }
        if (c == '\u03c2') {
            return '\u03a3';
        }
        return (char)(c + UPPER_START - LOWER_START);
    }

    public static int getFontHeight(int n) {
        return fontH[n];
    }

    public static void drawNumber(int n, int n2, int n3, int n4, int n5) {
        int n6 = Utils.itoa(n2, 10, textBuffer, 0);
        Fonts.drawGraphicString(n, textBuffer, 0, n6, n3, n4, n5);
    }

    private static int toTextBuffer(String string) {
        int n = string.length();
        if (textBuffer.length < n) {
            textBuffer = new char[n];
        }
        string.getChars(0, n, textBuffer, 0);
        return n;
    }

    public static String[] wrapSystemText(int n, String string, int n2) {
        if (Platform.getFontTextWidth(n, string) > n2) {
            Vector<String> vector = new Vector<String>();
            int n3 = 0;
            int n4 = 1;
            int n5 = 1;
            while (n3 < n4) {
                if (Platform.getFontTextWidth(n, string.substring(n3, n4)) >= n2) {
                    while (Platform.getFontTextWidth(n, string.substring(n3, n5)) >= n2) {
                        --n5;
                    }
                    if (string.charAt(n5) == ' ') {
                        vector.addElement(string.substring(n3, n5));
                    } else {
                        vector.addElement(string.substring(n3, n5 + 1));
                    }
                    n3 = n5 + 1;
                } else if (n4 == string.length()) {
                    vector.addElement(string.substring(n3, n4));
                    break;
                }
                n5 = n4;
                if ((n4 = string.indexOf(32, n4 + 1)) != -1) continue;
                n4 = string.length();
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    static {
        UPPER_START = 65;
        UPPER_END = 90;
        LOWER_START = 97;
        LOWER_END = 122;
        N_UPPER = UPPER_END - UPPER_START;
        N_LOWER = LOWER_END - LOWER_START;
        N_BASE_LETTERS = N_UPPER + N_LOWER;
        textBuffer = new char[64];
    }
}

