/*
 * Decompiled with CFR 0.152.
 */
public class ParticleEmitter
extends GameItem {
    public static final int PARTICLE_POS_X = 0;
    public static final int PARTICLE_POS_Y = 1;
    public static final int PARTICLE_DIR_X = 2;
    public static final int PARTICLE_DIR_Y = 3;
    public static final int PARTICLE_LIFE = 4;
    public static final int PARTICLE_FADE = 5;
    public static final int PARTICLE_COLOR = 6;
    public static final int PARTICLE_SPEED = 7;
    public static final int PARTICLE_DATA = 8;
    public static final int PARTICLE_INITSIZE = 9;
    public static final int PARTICLE_FINALSIZE = 10;
    public static final int PARTICLE_ALLIVE = 11;
    public static final int DATA_PER_PARTICLE = 12;
    protected int[] particles;
    protected boolean loop;
    protected boolean attached;
    protected boolean active;
    public int numParticles;
    public int alliveParticles;
    private int[] data;
    private int[] colorTable;
    private boolean reset;
    public boolean manualState;
    public boolean slow;
    public int radius;

    public ParticleEmitter(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5, 0);
        if (GameItem.dirTable == null) {
            this.genDirectionTable();
        }
        this.radius = 0;
        this.active = false;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    protected void initEmitter(int n, int[] nArray, int[] nArray2, int n2) {
        this.radius = n2;
        this.initEmitter(n, nArray, nArray2);
    }

    protected void initEmitter(int n, int[] nArray, int[] nArray2) {
        this.data = nArray;
        this.colorTable = nArray2;
        this.attached = this.data[0] == 0 || this.data[0] == 2 || this.data[0] == 5 || this.data[0] == 7;
        this.reset = this.data[0] == 2 || this.data[0] == 3;
        this.numParticles = this.data[1];
        this.particles = new int[this.numParticles * 12];
        this.slow = this.data[0] == 5 || this.data[0] == 4 || this.data[0] == 6 || this.data[0] == 7;
        if ((this.data[0] == 6 || this.data[0] == 7 || this.data[0] == 8) && this.radius == 0) {
            this.radius = 7;
        }
        for (int i = 0; i < this.numParticles; ++i) {
            int n2 = Utils.randomInterval(this.data[2], this.data[3]);
            this.particles[i * 12 + 0] = this.attached ? 0 : this.posX * 100;
            this.particles[i * 12 + 1] = this.attached ? 0 : this.posY * 100;
            this.particles[i * 12 + 2] = GameItem.dirTable[n2 * 2];
            this.particles[i * 12 + 3] = GameItem.dirTable[n2 * 2 + 1];
            this.particles[i * 12 + 7] = Utils.randomInterval(this.data[4], this.data[5]);
            this.particles[i * 12 + 4] = Utils.randomInterval(this.data[6], this.data[7]);
            this.particles[i * 12 + 5] = 0;
            this.particles[i * 12 + 9] = Utils.randomInterval(this.data[14], this.data[15]);
            this.particles[i * 12 + 11] = 1;
            if (this.radius > 0) {
                int n3 = i * 12 + 0;
                this.particles[n3] = this.particles[n3] + this.particles[i * 12 + 2] * Utils.randomInterval(0, this.radius);
                int n4 = i * 12 + 1;
                this.particles[n4] = this.particles[n4] + this.particles[i * 12 + 3] * Utils.randomInterval(0, this.radius);
            }
            if (this.slow) {
                this.particles[i * 12 + 8] = this.particles[i * 12 + 7];
            }
            this.particles[i * 12 + 6] = this.colorTable != null ? this.colorTable[Utils.randomInterval(0, this.colorTable.length - 1)] : 0xFFFFFF;
        }
    }

    protected void updateParticles() {
        for (int i = 0; i < this.numParticles; ++i) {
            if (this.particles[i * 12 + 11] == -1) continue;
            if (this.slow) {
                if (this.particles[i * 12 + 8] != 0) {
                    int n = i * 12 + 8;
                    this.particles[n] = this.particles[n] - 1;
                } else {
                    int n = i * 12 + 0;
                    this.particles[n] = this.particles[n] + this.particles[i * 12 + 2];
                    int n2 = i * 12 + 1;
                    this.particles[n2] = this.particles[n2] + this.particles[i * 12 + 3];
                    this.particles[i * 12 + 8] = this.particles[i * 12 + 7];
                }
            } else {
                int n = i * 12 + 0;
                this.particles[n] = this.particles[n] + this.particles[i * 12 + 2] * this.particles[i * 12 + 7];
                int n3 = i * 12 + 1;
                this.particles[n3] = this.particles[n3] + this.particles[i * 12 + 3] * this.particles[i * 12 + 7];
            }
            int n = i * 12 + 5;
            this.particles[n] = this.particles[n] + 1;
            if (this.particles[i * 12 + 5] < this.particles[i * 12 + 4]) continue;
            this.particles[i * 12 + 11] = -1;
            if (this.reset) continue;
            int n4 = Utils.randomInterval(this.data[8], this.data[9]);
            this.particles[i * 12 + 0] = this.attached ? 0 : this.posX * 100;
            this.particles[i * 12 + 1] = this.attached ? 0 : this.posY * 100;
            this.particles[i * 12 + 2] = GameItem.dirTable[n4 * 2];
            this.particles[i * 12 + 3] = GameItem.dirTable[n4 * 2 + 1];
            this.particles[i * 12 + 7] = Utils.randomInterval(this.data[10], this.data[11]);
            this.particles[i * 12 + 4] = Utils.randomInterval(this.data[12], this.data[13]);
            this.particles[i * 12 + 5] = 0;
            this.particles[i * 12 + 9] = Utils.randomInterval(this.data[14], this.data[15]);
            this.particles[i * 12 + 11] = 1;
            if (this.radius > 0) {
                int n5 = i * 12 + 0;
                this.particles[n5] = this.particles[n5] + this.particles[i * 12 + 2] * Utils.randomInterval(0, this.radius);
                int n6 = i * 12 + 1;
                this.particles[n6] = this.particles[n6] + this.particles[i * 12 + 3] * Utils.randomInterval(0, this.radius);
            }
            this.particles[i * 12 + 6] = this.colorTable != null ? this.colorTable[Utils.randomInterval(0, this.colorTable.length - 1)] : 0xFFFFFF;
        }
    }

    protected int setState(int n) {
        int n2 = 0;
        for (int i = 0; i < this.numParticles; ++i) {
            if (n >= this.particles[i * 12 + 4]) {
                this.particles[i * 12 + 11] = -1;
                continue;
            }
            ++n2;
            this.particles[i * 12 + 11] = 1;
            this.particles[i * 12 + 0] = n * (this.particles[i * 12 + 2] * this.particles[i * 12 + 7]);
            this.particles[i * 12 + 1] = n * (this.particles[i * 12 + 3] * this.particles[i * 12 + 7]);
        }
        return n2;
    }

    protected void draw() {
        super.draw();
        this.g = Platform.getDisplayGraphics();
        for (int i = 0; i < this.numParticles; ++i) {
            if (this.particles[i * 12 + 11] == -1) continue;
            this.g.setColor(this.particles[i * 12 + 6]);
            if (this.attached) {
                this.g.fillRect(this.posX + this.particles[i * 12 + 0] / 100, this.posY + this.particles[i * 12 + 1] / 100, this.particles[i * 12 + 9], this.particles[i * 12 + 9]);
                continue;
            }
            this.g.fillRect(this.particles[i * 12 + 0] / 100, this.particles[i * 12 + 1] / 100, this.particles[i * 12 + 9], this.particles[i * 12 + 9]);
        }
    }

    protected void update() {
        if (!this.active) {
            return;
        }
        super.update();
        if (!this.manualState) {
            this.updateParticles();
        }
    }
}

