/*
 * Decompiled with CFR 0.152.
 */
public final class GameLogicShooter
extends GameLogic {
    private static final byte BULLET_MAX = 40;
    private static final byte BULLET_LAST = 39;
    private static final int SCORE_UP_MIN = 160;
    private static final int SCORE_UP_INC = 60;
    private static final int PLAYER_SIZE = 1;
    private static final int LIFE_MAX = 3;
    private static final byte SCORE_INC = 1;
    private static final byte STEP_INC = 3;
    private static final byte STEP_RES = 4;
    private final int[] iArrBulletPos = new int[40];
    private final byte[] bArrLine = new byte[10];
    private final byte bRandomFrom;
    private final byte bRandomTo;
    private short sScoreUp = 0;
    private short sLast;

    public GameLogicShooter() {
        super(1, 3);
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            this.bArrLine[i] = i;
        }
        this.bRandomFrom = (byte)5;
        this.bRandomTo = (byte)10;
    }

    public final void save() throws Exception {
        super.save();
        GUtillIo.writeShort(this.sLast);
        GUtillIo.writeShort(this.sScoreUp);
        GUtillIo.writeArray(this.bArrLine);
        GUtillIo.writeArray(this.iArrBulletPos);
    }

    public final void load() throws Exception {
        super.load();
        this.sLast = GUtillIo.readShort();
        this.sScoreUp = GUtillIo.readShort();
        GUtillIo.read(this.bArrLine);
        GUtillIo.read(this.iArrBulletPos);
        int rowBottom = this.sLast + 10;
        for (int i = 0; i < 10; ++i) {
            GameField.set(rowBottom + i, (byte)1);
        }
    }

    public final void updateLevel(int level) {
        this.clear();
        this.sLast = (short)(200 - level * 10);
        this.sScoreUp = (short)(160 + 60 * (level - 1));
        this.placePlayer();
    }

    public final void updateState() {
        if (this.active && this.canUpdate()) {
            for (int i = this.sLast - 1; i >= 0; --i) {
                if (GameField.get(i) != 1) continue;
                GameField.set(i, (byte)0);
                int next = i + GameField.step[3];
                if (next > this.sLast) {
                    this.lifeDecr();
                    continue;
                }
                GameField.set(next, (byte)1);
            }
            if (!this.gameover) {
                if (this.CurrentScore >= this.sScoreUp) {
                    this.CurrentScore = 0;
                    this.gameup = true;
                    this.placePlayer();
                } else {
                    this.placeLine();
                }
            }
        }
    }

    public final boolean updateEvent() {
        if (this.canUpdate()) {
            if (E.kStates[7] && !this.active) {
                this.active = true;
                int blink_pos = 0;
                blink_pos = this.figure_pos[0] + GameField.step[2];
                GameField.set(blink_pos, (byte)0);
            }
            if (this.active) {
                int j = 0;
                for (int i = 0; i < 40; ++i) {
                    int next = this.iArrBulletPos[i];
                    for (j = 0; j <= 3 && next >= 0; next += GameField.step[2], ++j) {
                        if (GameField.get(next) != 1) continue;
                        GameField.set(next, (byte)0);
                        ++this.score;
                        ++this.CurrentScore;
                        break;
                    }
                    GameField.set(this.iArrBulletPos[i], (byte)0);
                    if (j == 4) {
                        this.iArrBulletPos[i] = next;
                        GameField.set(this.iArrBulletPos[i], (byte)2);
                        continue;
                    }
                    this.iArrBulletPos[i] = -1;
                    GUtillArray.moveOut(this.iArrBulletPos, i, 39);
                }
                int pos = this.figure_pos[0] + GameField.step[2];
                GUtillArray.insert(this.iArrBulletPos, pos, 0);
                GameField.set(pos, (byte)2);
                System.out.println(this.iArrBulletPos[0]);
                System.out.println(this.iArrBulletPos[1]);
                byte[] border = GameField.border(this.figure_pos[0]);
                int blink_pos = 0;
                if (E.kStates[6]) {
                    if (!GUtillArray.contains(border, (byte)1)) {
                        blink_pos = this.figure_pos[0] + GameField.step[2];
                        this.figure_pos[0] = this.figure_pos[0] - 1;
                        if (!this.active) {
                            GameField.set(blink_pos, (byte)0);
                            blink_pos = this.figure_pos[0] + GameField.step[2];
                            GameField.set(blink_pos, (byte)2);
                        }
                    }
                } else if (E.kStates[8] && !GUtillArray.contains(border, (byte)2)) {
                    blink_pos = this.figure_pos[0] + GameField.step[2];
                    this.figure_pos[0] = this.figure_pos[0] + 1;
                    if (!this.active) {
                        GameField.set(blink_pos, (byte)0);
                        blink_pos = this.figure_pos[0] + GameField.step[2];
                        GameField.set(blink_pos, (byte)2);
                    }
                }
            }
        }
        return false;
    }

    private final void placeLine() {
        int i;
        int count = GUtillMath.rnd_to(this.bRandomFrom, this.bRandomTo);
        for (i = 0; i < 10; ++i) {
            int index = GUtillMath.rnd(10);
            int index2 = GUtillMath.rnd(10);
            byte temp = this.bArrLine[index];
            this.bArrLine[index] = this.bArrLine[index2];
            this.bArrLine[index2] = temp;
        }
        for (i = 0; i < count; ++i) {
            GameField.set(this.bArrLine[i], (byte)1);
        }
    }

    protected final void placePlayer() {
        this.active = false;
        GameField.clear();
        GUtillArray.fill(this.iArrBulletPos, -1);
        int rowBottom = this.sLast + 10;
        for (int i = 0; i < 10; ++i) {
            GameField.set(rowBottom + i, (byte)1);
        }
        this.figure_pos[0] = this.sLast + GUtillMath.rnd(10);
        this.figure_elem[0] = 1;
    }
}

