/*
 * Decompiled with CFR 0.152.
 */
public final class GameLogicTetris
extends GameLogic {
    private static final int[][] figures = new int[][]{{5533, 35243}, {30382, 39615, 27373, 22955}, {17821, 27288, 23006, 51354}, {22170}, {18589, 35158}, {31662, 22187}, {27326, 39659, 27054, 27051}};
    private static final int SCORE_UP_MIN = 3000;
    private static final int SCORE_UP_INC = 800;
    private static final int FIGURE_COUNT = 7;
    private static final int FIGURE_H = 4;
    private static final int FIGURE_H2 = 2;
    private static final int SCORE_INC = 100;
    private long lLastKeyPressed = 0L;
    private final int iKeyDelay;
    private int iFigureNext = 0;
    private int iStateNext = 0;
    private int iFigure\u0421ur = -1;
    private int iStateCur = 0;
    private int iStateCount = 1;
    private final int[] iArrPos = new int[2];
    private final int[] iArrPosInit = new int[2];
    private boolean lock = true;
    private int iLineToEmpty = -1;
    private short sScoreUp = 0;

    public GameLogicTetris() {
        super(4);
        this.iKeyDelay = 100;
    }

    protected final void save() throws Exception {
        super.save();
        GUtillIo.writeInt(this.iFigureNext);
        GUtillIo.writeInt(this.iFigure\u0421ur);
        GUtillIo.writeInt(this.iStateCur);
        GUtillIo.writeInt(this.iStateNext);
        GUtillIo.writeInt(this.iStateCount);
        GUtillIo.writeArray(this.iArrPos);
        GUtillIo.writeArray(this.iArrPosInit);
        GUtillIo.writeBoolean(this.lock);
        GUtillIo.writeInt(this.iLineToEmpty);
        GUtillIo.writeShort(this.sScoreUp);
    }

    protected final void load() throws Exception {
        super.load();
        this.iFigureNext = GUtillIo.readInt();
        this.iFigure\u0421ur = GUtillIo.readInt();
        this.iStateCur = GUtillIo.readInt();
        this.iStateNext = GUtillIo.readInt();
        this.iStateCount = GUtillIo.readInt();
        GUtillIo.read(this.iArrPos);
        GUtillIo.read(this.iArrPosInit);
        this.lock = GUtillIo.readBoolean();
        this.iLineToEmpty = GUtillIo.readInt();
        this.sScoreUp = GUtillIo.readShort();
    }

    public final void updateLevel(int level) {
        int index;
        int row_first;
        int cur;
        int count;
        this.clear();
        int width = 10;
        int size = 200;
        this.iArrPosInit[0] = 3;
        this.iArrPosInit[1] = -4;
        this.iFigure\u0421ur = -1;
        this.iFigureNext = GUtillMath.rnd(7);
        this.iStateCount = figures[this.iFigureNext].length;
        this.iStateNext = GUtillMath.rnd(this.iStateCount);
        this.lock = false;
        this.active = true;
        this.sScoreUp = (short)(3000 + (level - 1) * 800);
        int lines_full = (level - 1) / 2;
        int lines_half = (level - 1) % 2;
        for (int i = 0; i < lines_full; ++i) {
            count = GUtillMath.rnd(10);
            cur = 0;
            row_first = 200 - (i + 1) * 10;
            while (cur < count) {
                index = GUtillMath.rnd(10);
                if (GameField.get(row_first + index) != 0) continue;
                GameField.set(row_first + index, (byte)1);
                ++cur;
            }
        }
        if (lines_half == 1) {
            row_first = 200 - lines_full * 10;
            count = GUtillMath.rnd(6);
            cur = 0;
            while (cur < count) {
                index = GUtillMath.rnd(10);
                if (GameField.get(row_first + index) != 0) continue;
                GameField.set(row_first + index, (byte)1);
                ++cur;
            }
        }
    }

    public final void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.iFigure\u0421ur == -1) {
                this.generateFigure();
            }
            if (!this.lock) {
                if (this.can(this.iFigure\u0421ur, this.iStateCur, this.iArrPos[0], this.iArrPos[1] + 1)) {
                    this.iArrPos[1] = this.iArrPos[1] + 1;
                    this.updateFigure();
                } else {
                    int i;
                    for (i = 0; i < 4; ++i) {
                        if (this.figure_pos[i] >= 0) continue;
                        this.gameover = true;
                    }
                    for (i = 0; i < 4; ++i) {
                        GameField.set(this.figure_pos[i], (byte)1);
                        this.figure_pos[i] = -1;
                    }
                    if (!this.gameover) {
                        this.iLineToEmpty = -1;
                        this.lock = true;
                    }
                }
            }
        }
    }

    public final boolean updateEvent() {
        boolean result = false;
        if (this.iFigure\u0421ur != -1 && this.canUpdate()) {
            if (!this.lock) {
                int x = this.iArrPos[0];
                int y = this.iArrPos[1];
                int state = this.iStateCur;
                if (this.lLastKeyPressed + 100L < System.currentTimeMillis()) {
                    if (E.kStates[6]) {
                        --x;
                        this.lLastKeyPressed = System.currentTimeMillis();
                    } else if (E.kStates[8]) {
                        ++x;
                        this.lLastKeyPressed = System.currentTimeMillis();
                    }
                }
                if (E.kStates[10]) {
                    ++y;
                }
                result = this.can(this.iFigure\u0421ur, state, x, y);
                if (E.kStates[7] || E.kStates[4]) {
                    E.kStates[7] = false;
                    E.kStates[4] = false;
                    state = this.iStateCur == this.iStateCount - 1 ? 0 : this.iStateCur + 1;
                    if (this.can(this.iFigure\u0421ur, state, x = this.iArrPos[0], y = this.iArrPos[1])) {
                        result = true;
                    } else {
                        result = false;
                        if (x < 0) {
                            for (int i = 0; i < 2 && !(result = this.can(this.iFigure\u0421ur, state, ++x, y)); ++i) {
                            }
                        } else if (x >= 8) {
                            for (int i = 0; i < 2 && !(result = this.can(this.iFigure\u0421ur, state, --x, y)); ++i) {
                            }
                        }
                        if (result) {
                            if ((this.iFigure\u0421ur == 1 || this.iFigure\u0421ur == 6) && this.iStateCur == 2 && x == 7) {
                                --x;
                            }
                            if (this.iFigure\u0421ur == 0 && this.iStateCur == 0 && x == 7) {
                                --x;
                            }
                        }
                    }
                }
                if (result) {
                    this.iArrPos[0] = x;
                    this.iArrPos[1] = y;
                    this.iStateCur = state;
                    this.updateFigure();
                }
            } else if (this.iLineToEmpty == -1) {
                boolean full = false;
                int width = 10;
                for (int i = 19; i >= 0; --i) {
                    int last = i * 10;
                    int first = last + 10 - 1;
                    full = true;
                    for (int j = first; j >= last && (full &= GameField.get(j) == 1); --j) {
                    }
                    if (!full) continue;
                    this.iLineToEmpty = first;
                    GameField.set(this.iLineToEmpty, (byte)0);
                    --this.iLineToEmpty;
                    GameField.set(this.iLineToEmpty, (byte)0);
                    --this.iLineToEmpty;
                    break;
                }
                if (!full) {
                    this.iFigure\u0421ur = -1;
                    this.updateState();
                }
            } else {
                int excess = this.iLineToEmpty % 10;
                if (excess != 9) {
                    GameField.set(this.iLineToEmpty, (byte)0);
                    --this.iLineToEmpty;
                    GameField.set(this.iLineToEmpty, (byte)0);
                    --this.iLineToEmpty;
                } else if (excess == 9) {
                    for (int i = this.iLineToEmpty; i >= 0; --i) {
                        if (GameField.get(i) != 1) continue;
                        GameField.set(i, (byte)0);
                        GameField.set(i + 10, (byte)1);
                    }
                    this.score += 100;
                    this.CurrentScore += 100;
                    this.iLineToEmpty = -1;
                }
            }
        }
        return false;
    }

    private final int getFigureElem(int figure, int state, int elem) {
        return figures[figure][state] >> elem * 4 & 0xF;
    }

    private final void generateFigure() {
        this.iFigure\u0421ur = this.iFigureNext;
        this.iFigureNext = GUtillMath.rnd(7);
        this.iStateCur = this.iStateNext;
        this.iStateCount = figures[this.iFigure\u0421ur].length;
        this.iStateNext = GUtillMath.rnd(figures[this.iFigureNext].length);
        GUtillArray.copy(this.iArrPos, this.iArrPosInit);
        this.updateFigure();
        GUtillArray.fill(this.info, false);
        for (int i = 0; i < 4; ++i) {
            int figureIndex = this.getFigureElem(this.iFigureNext, this.iStateNext, i);
            this.info[figureIndex] = true;
        }
        GUtillArray.fill(this.figure_elem, (byte)1);
        this.lock = false;
        if (this.CurrentScore >= this.sScoreUp) {
            this.CurrentScore = 0;
            this.gameup = true;
        }
    }

    private final void updateFigure() {
        for (int i = 0; i < 4; ++i) {
            int fieldIndex;
            int figureIndex = this.getFigureElem(this.iFigure\u0421ur, this.iStateCur, i);
            this.figure_pos[i] = fieldIndex = this.figureToField(figureIndex);
        }
    }

    private final int figureToField(int index) {
        return this.iArrPos[1] * 10 + this.iArrPos[0] + index / 4 * 10 + index % 4;
    }

    private final boolean can(int figure, int state, int x, int y) {
        boolean result = true;
        for (int i = 0; i < 4; ++i) {
            int pos = this.getFigureElem(figure, state, i);
            int pos_y = y + pos / 4;
            int pos_x = x + pos % 4;
            if (pos_x < 0 || pos_x > 9) {
                result = false;
                break;
            }
            if (pos_y < 0 || GameField.get(pos_x, pos_y) != 1) continue;
            result = false;
            break;
        }
        return result;
    }

    protected final void placePlayer() {
    }
}

