/*
 * Decompiled with CFR 0.152.
 */
public class GameLogicRacing
extends GameLogic {
    private static final byte CAR_SIZE = 7;
    private static final int LIFE_MAX = 3;
    private static final byte CAR_APPEAR = 11;
    private static final byte SCORE_INC = 10;
    private static final int SCORE_UP = 500;
    private static final int[][] CAR_FIGURE = new int[][]{{163, 172, 173, 174, 183, 192, 194}, {166, 175, 176, 177, 186, 195, 197}};
    private static final int[][] COLLISION_FIGURE = new int[][]{{162, 165, 173, 174, 183, 184, 192, 195}, {165, 168, 176, 177, 186, 187, 195, 198}};
    private byte bCurUpdate = 1;
    private byte bCurPos = 0;
    private byte bCarPos;
    private byte bCarOpCount = 0;
    private byte bSideWall;
    private byte bShowCollision = 0;

    public GameLogicRacing() {
        super(7, 3);
    }

    protected void load() throws Exception {
        super.load();
        this.bCarPos = GUtillIo.readByte();
        this.bSideWall = GUtillIo.readByte();
        this.bCurUpdate = GUtillIo.readByte();
        this.bCarOpCount = GUtillIo.readByte();
        this.bShowCollision = GUtillIo.readByte();
    }

    protected void save() throws Exception {
        super.save();
        GUtillIo.writeByte(this.bCarPos);
        GUtillIo.writeByte(this.bSideWall);
        GUtillIo.writeByte(this.bCurUpdate);
        GUtillIo.writeByte(this.bCarOpCount);
        GUtillIo.writeByte(this.bShowCollision);
    }

    private final void updateFigure() {
        boolean lifedecr = false;
        for (int i = 0; i < 7; ++i) {
            this.figure_pos[i] = CAR_FIGURE[this.bCarPos][i];
            if (GameField.get(this.figure_pos[i]) != 1) continue;
            lifedecr = true;
        }
        if (lifedecr) {
            this.showCollision();
        }
    }

    protected void placePlayer() {
        this.active = false;
        GameField.clear();
        this.bCurUpdate = (byte)6;
        this.bCarOpCount = 0;
        this.bCarPos = (byte)GUtillMath.rnd(2);
        GUtillArray.fill(this.figure_elem, (byte)1);
        this.updateFigure();
    }

    protected void placeOpCar(int shift, int pos) {
        if (this.bCarOpCount < 2) {
            this.bCarOpCount = (byte)(this.bCarOpCount + 1);
        }
        for (int i = 0; i < 7; ++i) {
            GameField.set(CAR_FIGURE[pos][i] - shift, (byte)1);
        }
    }

    public boolean updateEvent() {
        if (E.kStates[7] && !this.active) {
            this.active = true;
        }
        if (this.active && this.bShowCollision == 0) {
            if (E.kStates[6]) {
                if (this.bCarPos == 1) {
                    this.bCarPos = 0;
                    this.updateFigure();
                }
            } else if (E.kStates[8] && this.bCarPos == 0) {
                this.bCarPos = 1;
                this.updateFigure();
            }
            EGame.iDelayUpdateState = E.kStates[7] || E.kStates[4] ? (EGame.iDelayUpdateState /= 3) : Constants.GAME_DELAY[EGame.bGameLast][EGame.iSpeed - 1];
        }
        return false;
    }

    public void updateLevel(int level) {
        this.clear();
        this.placePlayer();
        this.bSideWall = 1;
        this.bCurUpdate = (byte)6;
        this.bCarOpCount = 0;
        this.bShowCollision = 0;
    }

    private final boolean in_car(int i) {
        for (int j = 0; j < CAR_FIGURE[this.bCarPos].length; ++j) {
            if (i != CAR_FIGURE[this.bCarPos][j]) continue;
            return true;
        }
        return false;
    }

    public void updateState() {
        if (this.active && this.canUpdate()) {
            if (this.bShowCollision != 0) {
                if (this.bShowCollision == 4) {
                    this.bShowCollision = 0;
                    this.lifeDecr();
                } else {
                    this.bShowCollision = (byte)(this.bShowCollision + 1);
                }
            } else {
                for (int i = 199; i >= 0; --i) {
                    if (this.in_car(i) || GameField.get(i) != 1) continue;
                    GameField.set(i, (byte)0);
                    GameField.set(i + 10, (byte)1);
                }
                if (this.bSideWall != 3) {
                    GameField.set(0, (byte)1);
                    GameField.set(9, (byte)1);
                    this.bSideWall = (byte)(this.bSideWall + 1);
                } else {
                    this.bSideWall = 1;
                }
                if (this.bCurUpdate < 11) {
                    if (this.bCurUpdate == 1) {
                        this.bCurPos = (byte)GUtillMath.rnd(2);
                    }
                    if (this.bCurUpdate <= 4) {
                        this.placeOpCar(160 + (4 - this.bCurUpdate) * 10, this.bCurPos);
                    }
                    this.bCurUpdate = (byte)(this.bCurUpdate + 1);
                } else if (this.bCurUpdate == 11) {
                    this.bCurUpdate = 1;
                }
                if (this.bCurUpdate == 9 && this.bCarOpCount == 2) {
                    this.score += 10;
                    this.CurrentScore += 10;
                }
                if (this.checkCollision()) {
                    this.CurrentScore = 0;
                    this.showCollision();
                }
                if (this.CurrentScore == 500) {
                    this.score += 200;
                    this.CurrentScore = 0;
                    this.gameup = true;
                    this.placePlayer();
                }
            }
        }
    }

    private final void showCollision() {
        int i = 0;
        for (i = 0; i < 7; ++i) {
            GameField.set(CAR_FIGURE[this.bCarPos][i], (byte)0);
        }
        GUtillArray.fill(this.figure_elem, (byte)0);
        for (i = 0; i < COLLISION_FIGURE[0].length; ++i) {
            GameField.set(COLLISION_FIGURE[this.bCarPos][i], (byte)2);
        }
        GameField.set(COLLISION_FIGURE[this.bCarPos][0] + 1, (byte)0);
        GameField.set(COLLISION_FIGURE[this.bCarPos][0] + 2, (byte)0);
        GameField.set(COLLISION_FIGURE[this.bCarPos][0] + 10, (byte)0);
        GameField.set(COLLISION_FIGURE[this.bCarPos][0] + 20, (byte)0);
        GameField.set(COLLISION_FIGURE[this.bCarPos][0] + 13, (byte)0);
        GameField.set(COLLISION_FIGURE[this.bCarPos][0] + 23, (byte)0);
        GameField.set(COLLISION_FIGURE[this.bCarPos][0] + 31, (byte)0);
        GameField.set(COLLISION_FIGURE[this.bCarPos][0] + 32, (byte)0);
        this.bShowCollision = (byte)(this.bShowCollision + 1);
    }

    private final boolean checkCollision() {
        int posNext = CAR_FIGURE[this.bCarPos][0] - 10;
        return GameField.get(posNext) == 1;
    }
}

