/*
 * Decompiled with CFR 0.152.
 */
public final class GameLogicFillingShooter
extends GameLogic {
    private static final byte BULLET_MAX = 3;
    private static final byte BULLET_LAST = 2;
    private static final int SCORE_UP_MIN = 200;
    private static final int SCORE_UP_INC = 80;
    private static final int PLAYER_SIZE = 1;
    private static final int LIFE_MAX = 3;
    private static final byte SCORE_INC = 20;
    private static final byte STEP_INC = 3;
    private static final byte STEP_RES = 4;
    private final int[] iArrBulletPos = new int[3];
    private final byte[] bArrLine = new byte[10];
    private final byte bRandomFrom;
    private final byte bRandomTo;
    private short sScoreUp = 0;
    private short sLast;
    private int iLineToEmpty = -2;
    private boolean isOnDeleting = false;
    private int iFillingPos = -1;
    private long lLastKeyPressed = 0L;
    private final int iKeyDelay;

    public GameLogicFillingShooter() {
        super(1, 3);
        this.iKeyDelay = 100;
        for (int i = 0; i < 10; i = (int)((byte)(i + 1))) {
            this.bArrLine[i] = i;
        }
        this.bRandomFrom = (byte)5;
        this.bRandomTo = (byte)10;
    }

    public final void save() throws Exception {
        super.save();
        GUtillIo.writeShort(this.sLast);
        GUtillIo.writeShort(this.sScoreUp);
        GUtillIo.writeArray(this.bArrLine);
        GUtillIo.writeArray(this.iArrBulletPos);
        GUtillIo.writeInt(this.iLineToEmpty);
        GUtillIo.writeBoolean(this.isOnDeleting);
        GUtillIo.writeInt(this.iFillingPos);
    }

    public final void load() throws Exception {
        super.load();
        this.sLast = GUtillIo.readShort();
        this.sScoreUp = GUtillIo.readShort();
        GUtillIo.read(this.bArrLine);
        GUtillIo.read(this.iArrBulletPos);
        this.iLineToEmpty = GUtillIo.readInt();
        this.isOnDeleting = GUtillIo.readBoolean();
        this.iFillingPos = GUtillIo.readInt();
        int rowBottom = this.sLast + 10;
        for (int i = 0; i < 10; ++i) {
            GameField.set(rowBottom + i, (byte)1);
        }
    }

    public final void updateLevel(int level) {
        this.clear();
        this.sLast = (short)(200 - level * 10);
        this.sScoreUp = (short)(200 + 80 * (level - 1));
        this.placePlayer();
    }

    public final void updateState() {
        if (this.active && this.canUpdate() && !this.isOnDeleting) {
            for (int i = this.sLast - 1; i >= 0; --i) {
                if (GameField.get(i) != 1) continue;
                GameField.set(i, (byte)0);
                int next = i + GameField.step[3];
                if (next >= this.sLast) {
                    this.lifeDecr();
                    continue;
                }
                GameField.set(next, (byte)1);
            }
            if (!this.gameover) {
                if (this.CurrentScore >= this.sScoreUp) {
                    this.CurrentScore = 0;
                    this.gameup = true;
                    this.placePlayer();
                } else {
                    this.placeLine();
                }
            }
        }
    }

    public final boolean updateEvent() {
        if (this.canUpdate()) {
            if (this.active && !this.isOnDeleting) {
                int j = 0;
                for (int i = 0; i < 3 && !this.isOnDeleting; ++i) {
                    int next = this.iArrBulletPos[2 - i];
                    for (j = 0; j <= 3 && next >= 0; next += GameField.step[2], ++j) {
                        if (GameField.get(next + GameField.step[2]) == 1) {
                            GameField.set(next, (byte)1);
                            this.iFillingPos = next;
                            this.checkScore();
                            break;
                        }
                        if (GameField.get(next + GameField.step[2] * 2) != 1) continue;
                        GameField.set(next + GameField.step[2], (byte)1);
                        this.iFillingPos = next + GameField.step[2];
                        this.checkScore();
                        break;
                    }
                    GameField.set(this.iArrBulletPos[2 - i], (byte)0);
                    if (j == 4) {
                        this.iArrBulletPos[2 - i] = next;
                        GameField.set(this.iArrBulletPos[2 - i], (byte)2);
                        continue;
                    }
                    this.iArrBulletPos[2 - i] = -1;
                    GUtillArray.moveOut(this.iArrBulletPos, 2 - i, 2);
                }
                if (E.kStates[7] && !this.isOnDeleting && this.iArrBulletPos[2] == -1) {
                    int pos = this.figure_pos[0] + GameField.step[2];
                    if (GameField.get(pos + GameField.step[2]) != 1) {
                        GUtillArray.insert(this.iArrBulletPos, pos, 0);
                        GameField.set(pos, (byte)2);
                        System.out.println(this.iArrBulletPos[0]);
                        System.out.println(this.iArrBulletPos[1]);
                    } else {
                        GameField.set(pos, (byte)1);
                        this.lifeDecr();
                    }
                }
                if (this.lLastKeyPressed + 100L < System.currentTimeMillis() && !this.isOnDeleting) {
                    byte[] border = GameField.border(this.figure_pos[0]);
                    int blink_pos = 0;
                    if (E.kStates[6]) {
                        if (!GUtillArray.contains(border, (byte)1)) {
                            blink_pos = this.figure_pos[0] + GameField.step[2];
                            this.figure_pos[0] = this.figure_pos[0] - 1;
                            this.lLastKeyPressed = System.currentTimeMillis();
                            if (!this.active) {
                                GameField.set(blink_pos, (byte)0);
                                blink_pos = this.figure_pos[0] + GameField.step[2];
                                GameField.set(blink_pos, (byte)2);
                            }
                        }
                    } else if (E.kStates[8] && !GUtillArray.contains(border, (byte)2)) {
                        blink_pos = this.figure_pos[0] + GameField.step[2];
                        this.figure_pos[0] = this.figure_pos[0] + 1;
                        this.lLastKeyPressed = System.currentTimeMillis();
                        if (!this.active) {
                            GameField.set(blink_pos, (byte)0);
                            blink_pos = this.figure_pos[0] + GameField.step[2];
                            GameField.set(blink_pos, (byte)2);
                        }
                    }
                }
            } else if (this.isOnDeleting) {
                this.checkScore();
            }
            if (E.kStates[7] && !this.active) {
                this.active = true;
            }
        }
        return false;
    }

    private void checkScore() {
        if (this.iLineToEmpty == -2) {
            boolean full = false;
            int width = 10;
            for (int i = this.iFillingPos / 10; i >= 0; --i) {
                int last = i * 10;
                int first = last + 10 - 1;
                full = true;
                for (int j = first; j >= last && (full &= GameField.get(j) == 1); --j) {
                }
                if (!full) continue;
                this.iLineToEmpty = first;
                GameField.set(this.iLineToEmpty, (byte)0);
                --this.iLineToEmpty;
                GameField.set(this.iLineToEmpty, (byte)0);
                --this.iLineToEmpty;
                this.isOnDeleting = true;
                break;
            }
        } else {
            int excess = this.iLineToEmpty % 10;
            if (excess != 9 && excess != -1) {
                GameField.set(this.iLineToEmpty, (byte)0);
                --this.iLineToEmpty;
                GameField.set(this.iLineToEmpty, (byte)0);
                --this.iLineToEmpty;
            } else if (excess == 9 || excess == -1) {
                for (int i = this.sLast - 1; i >= this.iFillingPos; --i) {
                    if (GameField.get(i) != 1) continue;
                    GameField.set(i, (byte)0);
                }
                this.score += 20;
                this.CurrentScore += 20;
                this.iLineToEmpty = -2;
                this.isOnDeleting = false;
                this.iFillingPos = -1;
            }
        }
    }

    private final void placeLine() {
        int i;
        int count = GUtillMath.rnd_to(this.bRandomFrom, this.bRandomTo);
        for (i = 0; i < 10; ++i) {
            int index = GUtillMath.rnd(10);
            int index2 = GUtillMath.rnd(10);
            byte temp = this.bArrLine[index];
            this.bArrLine[index] = this.bArrLine[index2];
            this.bArrLine[index2] = temp;
        }
        for (i = 0; i < count; ++i) {
            GameField.set(this.bArrLine[i], (byte)1);
        }
    }

    protected final void placePlayer() {
        this.active = false;
        GameField.clear();
        GUtillArray.fill(this.iArrBulletPos, -1);
        int rowBottom = this.sLast + 10;
        for (int i = 0; i < 10; ++i) {
            GameField.set(rowBottom + i, (byte)1);
        }
        this.figure_pos[0] = this.sLast + GUtillMath.rnd(10);
        this.figure_elem[0] = 1;
        this.isOnDeleting = false;
        this.iFillingPos = -1;
    }
}

