/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Alignment;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.Font;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.String;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public class TextField
extends Viewport {
    public int mCurrentKeysStringIndex;
    public String mKeysString;
    public static final byte charCycle;
    public int mCycleTimeLeft;
    public int mCursorBlinkTimeLeft;
    public boolean mIsCapitalised;
    public static final byte typeID;
    public short mMaxLength;
    public byte mCursorRecedeOnLastChar;
    public boolean mIsFocused;
    public int mCursorPosition;
    public static final boolean supportsDynamicSerialization;
    public String mString;
    public static final byte charAppend;
    public Text mText;
    public int mLastKey;
    public boolean mIsCapitalisedLock;
    public int[] mFirstIndexs = new int[20];
    public boolean mIsDigitsOnly;
    public static final byte typeNumber;
    public static final byte charRemoval;
    public Component mCursor;

    public TextField() {
        this.mString = new String();
        this.mKeysString = new String();
        this.Initialize();
    }

    public void destruct() {
        this.mText.SetViewport(null);
        if (this.mCursor != null) {
            this.mCursor.SetViewport(null);
        }
        this.mCursor = null;
        this.mText = null;
    }

    public static TextField Cast(Object object, TextField textField) {
        return (TextField)object;
    }

    public TextField(Viewport viewport, Font font, String string, short s, short s2, short s3, short s4, byte by, boolean bl) {
        super(viewport);
        this.mString = new String();
        this.mKeysString = new String();
        this.Initialize();
        this.SetRect(s, s2, s3, s4);
        this.mString.Assign(string);
        this.mText = new Text(this, font, new String(this.mString), 0, 0, s3, s4, by);
        this.mText.SetMultiline(bl);
        this.mText.KeepTrailingWhiteSpaces(true);
    }

    public void SetFocus(boolean bl) {
        if (bl == this.mIsFocused) {
            return;
        }
        this.mIsFocused = bl;
        this.mCycleTimeLeft = 0;
        this.mCursorPosition = this.mString.GetLength();
        this.UpdateCursorPosition(0);
        this.ResetCursor(bl);
        if (this.mIsFocused) {
            this.TakeFocus();
            this.RegisterInGlobalTime();
            return;
        }
        this.UnRegisterInGlobalTime();
    }

    public void SetMaxCharacters(short s) {
        this.mMaxLength = s;
    }

    public void SetCapitalised(boolean bl) {
        bl = this.mIsCapitalisedLock || bl;
        this.mIsCapitalised = bl;
    }

    public void SetLockCapitalised(boolean bl) {
        this.mIsCapitalisedLock = bl;
    }

    public void SetCursor(Component component) {
        if (this.mCursor != null) {
            this.mCursor.SetViewport(null);
            this.mCursor = null;
        }
        this.mCursor = component;
        if (this.mCursor != null) {
            this.mCursor.SetViewport(this);
            this.mCursor.SetVisible(this.mIsFocused);
            this.UpdateCursorPosition(0);
            if (this.mCursorRecedeOnLastChar == -1) {
                this.mCursorRecedeOnLastChar = (byte)this.mCursor.GetRectWidth();
            }
        }
    }

    public void SetIsDigitOnly(boolean bl) {
        this.mIsDigitsOnly = bl;
    }

    public void SetCursorRecedeOnLastChar(byte by) {
        this.mCursorRecedeOnLastChar = by;
    }

    public void OnTime(int n, int n2) {
        if (this.mIsFocused) {
            this.mCursorBlinkTimeLeft -= n2;
            if (this.mCursor != null && this.mCursorBlinkTimeLeft <= 0) {
                n = !this.mCursor.IsVisible() ? 1 : 0;
                this.ResetCursor(n != 0);
            }
            if (this.mCycleTimeLeft > 0) {
                this.mCycleTimeLeft -= n2;
                if (this.mCycleTimeLeft <= 0) {
                    this.UpdateCursorPosition(1);
                }
            }
        }
    }

    public Component GetCursor() {
        return this.mCursor;
    }

    public Text GetText() {
        return this.mText;
    }

    public short GetMaxCharacters() {
        return this.mMaxLength;
    }

    public Text BeginTextChange() {
        return this.mText;
    }

    public void EndTextChange() {
        this.mString.Assign(this.mText.GetCaption());
        this.mCursorPosition = this.mString.GetLength();
        this.UpdateDisplay();
        this.UpdateCursorPosition(0);
    }

    public void InsertCharacterInSet(byte by, int n) {
        if (this.mKeysString.FindChar(by) == -1) {
            this.mKeysString.InsertCharAt(this.mFirstIndexs[n + 1], by);
            ++n;
            while (n < 20) {
                by = (byte)(this.mFirstIndexs[n] + 1);
                this.mFirstIndexs[n] = by;
                ++n;
            }
        }
    }

    public void RemoveCharacterFromSet(byte by) {
        if ((by = (byte)this.mKeysString.FindChar(by)) >= 0) {
            this.mKeysString.RemoveCharAt(by);
            for (int i = 0; i < 20; ++i) {
                int n;
                if (this.mFirstIndexs[i] <= by) continue;
                this.mFirstIndexs[i] = n = this.mFirstIndexs[i] - 1;
            }
        }
    }

    public void Initialize() {
        this.mMaxLength = (short)255;
        this.mCursorRecedeOnLastChar = (byte)-1;
        this.mKeysString.Assign(StringUtils.CreateString(" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0080\u00a3"));
        this.mFirstIndexs[7] = 0;
        this.mFirstIndexs[8] = 1;
        this.mFirstIndexs[9] = 3;
        this.mFirstIndexs[10] = 7;
        this.mFirstIndexs[11] = 11;
        this.mFirstIndexs[12] = 15;
        this.mFirstIndexs[13] = 19;
        this.mFirstIndexs[14] = 23;
        this.mFirstIndexs[15] = 28;
        this.mFirstIndexs[16] = 32;
        this.mFirstIndexs[17] = 37;
        this.mFirstIndexs[18] = 37;
        this.mFirstIndexs[19] = 38;
    }

    public void ResetCursor(boolean bl) {
        if (this.mCursor != null) {
            this.mCursorBlinkTimeLeft = 800;
            this.mCursor.SetVisible(bl);
        }
    }

    public void UpdateCursorPosition(int n) {
        this.mCursorPosition += n;
        this.ResetCursor(this.mIsFocused);
        Vector2_short vector2_short = new Vector2_short(this.mText.GetCharIndex2DPosition(this.mCursorPosition));
        String string = new String(this.mText.GetLineString(vector2_short.GetY()));
        n = this.mText.GetFont().GetLineWidth(string, 0, string.GetLength(), false);
        int n2 = this.mText.GetFont().GetLineWidth(string, 0, vector2_short.GetX(), false);
        short s = Alignment.GetOffsetX(this.mText.GetAlignment(), this.mText.GetRectWidth(), (short)n);
        if (this.mCursor != null) {
            if (string.GetLength() == this.mMaxLength && n2 >= n) {
                n2 -= this.mCursorRecedeOnLastChar;
            }
            this.mCursor.SetTopLeft((short)FlMath.Minimum(n2 + s, (int)this.mText.GetRectWidth()), (short)(vector2_short.GetY() * this.mText.GetFont().GetLineHeight()));
            this.ChangeOffsetToShow(this.mCursor, true);
        }
    }

    public void UpdateDisplay() {
        String string = new String(this.mString);
        this.mText.SetCaption(string, false);
        short s = 0;
        if (this.mCursor != null) {
            s = this.mCursor.GetRectWidth();
        }
        if (!this.mText.IsMultiline()) {
            this.mText.ComputeLineWidth(false);
            s = (short)(this.mRect_width - s);
            if (this.mText.GetLineWidth(0) >= s || this.mText.GetRectWidth() > s) {
                this.mText.SetSize(FlMath.Maximum(this.mText.GetLineWidth(0), s), this.mText.GetRectHeight());
                this.ChangeOffsetToShow(this.mText, true);
                return;
            }
        } else {
            this.SetSize((short)(this.mText.GetRectWidth() + s), this.mText.GetRectHeight());
        }
    }

    public byte GetCurrentChar() {
        if (this.mIsDigitsOnly) {
            return (byte)(48 + (this.mLastKey - 7));
        }
        if (this.mIsCapitalised) {
            switch (this.mLastKey) {
                case 29: {
                    return 65;
                }
                case 30: {
                    return 66;
                }
                case 31: {
                    return 67;
                }
                case 32: {
                    return 68;
                }
                case 33: {
                    return 69;
                }
                case 34: {
                    return 70;
                }
                case 35: {
                    return 71;
                }
                case 36: {
                    return 72;
                }
                case 37: {
                    return 73;
                }
                case 38: {
                    return 74;
                }
                case 39: {
                    return 75;
                }
                case 40: {
                    return 76;
                }
                case 41: {
                    return 77;
                }
                case 42: {
                    return 78;
                }
                case 43: {
                    return 79;
                }
                case 44: {
                    return 80;
                }
                case 45: {
                    return 81;
                }
                case 46: {
                    return 82;
                }
                case 47: {
                    return 83;
                }
                case 48: {
                    return 84;
                }
                case 49: {
                    return 85;
                }
                case 50: {
                    return 86;
                }
                case 51: {
                    return 87;
                }
                case 52: {
                    return 88;
                }
                case 53: {
                    return 89;
                }
                case 54: {
                    return 90;
                }
            }
        } else {
            switch (this.mLastKey) {
                case 29: {
                    return 97;
                }
                case 30: {
                    return 98;
                }
                case 31: {
                    return 99;
                }
                case 32: {
                    return 100;
                }
                case 33: {
                    return 101;
                }
                case 34: {
                    return 102;
                }
                case 35: {
                    return 103;
                }
                case 36: {
                    return 104;
                }
                case 37: {
                    return 105;
                }
                case 38: {
                    return 106;
                }
                case 39: {
                    return 107;
                }
                case 40: {
                    return 108;
                }
                case 41: {
                    return 109;
                }
                case 42: {
                    return 110;
                }
                case 43: {
                    return 111;
                }
                case 44: {
                    return 112;
                }
                case 45: {
                    return 113;
                }
                case 46: {
                    return 114;
                }
                case 47: {
                    return 115;
                }
                case 48: {
                    return 116;
                }
                case 49: {
                    return 117;
                }
                case 50: {
                    return 118;
                }
                case 51: {
                    return 119;
                }
                case 52: {
                    return 120;
                }
                case 53: {
                    return 121;
                }
                case 54: {
                    return 122;
                }
            }
        }
        switch (this.mLastKey) {
            case 81: {
                return 32;
            }
            case 82: {
                return 33;
            }
            case 83: {
                return 34;
            }
            case 18: {
                return 35;
            }
            case 84: {
                return 36;
            }
            case 85: {
                return 37;
            }
            case 86: {
                return 38;
            }
            case 87: {
                return 39;
            }
            case 88: {
                return 40;
            }
            case 89: {
                return 41;
            }
            case 17: {
                return 42;
            }
            case 90: {
                return 43;
            }
            case 91: {
                return 44;
            }
            case 92: {
                return 45;
            }
            case 93: {
                return 46;
            }
            case 94: {
                return 47;
            }
            case 7: {
                return 48;
            }
            case 8: {
                return 49;
            }
            case 9: {
                return 50;
            }
            case 10: {
                return 51;
            }
            case 11: {
                return 52;
            }
            case 12: {
                return 53;
            }
            case 13: {
                return 54;
            }
            case 14: {
                return 55;
            }
            case 15: {
                return 56;
            }
            case 16: {
                return 57;
            }
            case 95: {
                return 58;
            }
            case 96: {
                return 59;
            }
            case 97: {
                return 60;
            }
            case 98: {
                return 61;
            }
            case 99: {
                return 62;
            }
            case 100: {
                return 63;
            }
            case 101: {
                return 64;
            }
            case 55: {
                return 65;
            }
            case 56: {
                return 66;
            }
            case 57: {
                return 67;
            }
            case 58: {
                return 68;
            }
            case 59: {
                return 69;
            }
            case 60: {
                return 70;
            }
            case 61: {
                return 71;
            }
            case 62: {
                return 72;
            }
            case 63: {
                return 73;
            }
            case 64: {
                return 74;
            }
            case 65: {
                return 75;
            }
            case 66: {
                return 76;
            }
            case 67: {
                return 77;
            }
            case 68: {
                return 78;
            }
            case 69: {
                return 79;
            }
            case 70: {
                return 80;
            }
            case 71: {
                return 81;
            }
            case 72: {
                return 82;
            }
            case 73: {
                return 83;
            }
            case 74: {
                return 84;
            }
            case 75: {
                return 85;
            }
            case 76: {
                return 86;
            }
            case 77: {
                return 87;
            }
            case 78: {
                return 88;
            }
            case 79: {
                return 89;
            }
            case 80: {
                return 90;
            }
            case 102: {
                return 91;
            }
            case 103: {
                return 92;
            }
            case 104: {
                return 93;
            }
            case 105: {
                return 94;
            }
            case 106: {
                return 95;
            }
            case 107: {
                return 123;
            }
            case 108: {
                return 124;
            }
            case 109: {
                return 125;
            }
            case 110: {
                return 126;
            }
            case 111: {
                return (byte)new java.lang.String("\u0080").charAt(0);
            }
            case 112: {
                return (byte)new java.lang.String("\u00a3").charAt(0);
            }
        }
        return 48;
    }

    public void InsertChar(int n) {
        if (this.mString.GetLength() < this.mMaxLength) {
            byte by;
            this.StopCycling();
            this.mLastKey = n;
            int by2 = n = (int)this.GetCurrentChar();
            int n2 = n - 65;
            if (n2 >= 0 && n2 <= 25) {
                by = (byte)(97 + n2);
            }
            if (this.mKeysString.FindChar(by) == -1) {
                return;
            }
            this.mString.InsertCharAt(this.mCursorPosition, (byte)n);
            this.UpdateDisplay();
            this.UpdateCursorPosition(1);
            this.SendMsg(this, -110, 1);
        }
    }

    public void StopCycling() {
        if (this.mCycleTimeLeft > 0) {
            this.mCycleTimeLeft = -1;
            this.UpdateCursorPosition(1);
        }
    }

    public int GetKeysStringIndexFor(int n) {
        return this.mFirstIndexs[n];
    }

    public boolean CanCycle() {
        if (this.mIsDigitsOnly) {
            return false;
        }
        return this.mFirstIndexs[this.mLastKey] != this.mFirstIndexs[this.mLastKey + 1] - 1;
    }

    public boolean IsKeySupported(int n) {
        if (n == 27 || n == 23 || n == 6) {
            return true;
        }
        return n >= 7 && n <= 18 || n > 28 && n < 113;
    }

    public static TextField[] InstArrayTextField(int n) {
        TextField[] textFieldArray = new TextField[n];
        for (int i = 0; i < n; ++i) {
            textFieldArray[i] = new TextField();
        }
        return textFieldArray;
    }

    public static TextField[][] InstArrayTextField(int n, int n2) {
        TextField[][] textFieldArray = new TextField[n][];
        for (int i = 0; i < n; ++i) {
            textFieldArray[i] = new TextField[n2];
            for (int j = 0; j < n2; ++j) {
                textFieldArray[i][j] = new TextField();
            }
        }
        return textFieldArray;
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mCursor = Component.Cast(package_.SerializePointer((byte)-59, true, false), null);
        this.mText = Text.Cast(package_.SerializePointer((byte)71, true, false), null);
        this.mString.Assign(this.mText.GetCaption());
        this.mText.SetViewport(this);
        this.mText.KeepTrailingWhiteSpaces(true);
        this.mMaxLength = package_.SerializeIntrinsic(this.mMaxLength);
        this.mIsCapitalised = package_.SerializeIntrinsic(this.mIsCapitalised);
        this.mIsCapitalisedLock = package_.SerializeIntrinsic(this.mIsCapitalisedLock);
        this.mIsDigitsOnly = package_.SerializeIntrinsic(this.mIsDigitsOnly);
        this.mCursorRecedeOnLastChar = package_.SerializeIntrinsic(this.mCursorRecedeOnLastChar);
        this.SetCursor(this.mCursor);
        this.SetClipChildren(true);
    }

    public static TextField[][][] InstArrayTextField(int n, int n2, int n3) {
        TextField[][][] textFieldArray = new TextField[n][][];
        for (int i = 0; i < n; ++i) {
            textFieldArray[i] = new TextField[n2][];
            for (int j = 0; j < n2; ++j) {
                textFieldArray[i][j] = new TextField[n3];
                for (int k = 0; k < n3; ++k) {
                    textFieldArray[i][j][k] = new TextField();
                }
            }
        }
        return textFieldArray;
    }

    public byte GetTypeID() {
        return 99;
    }

    public static Class AsClass() {
        return null;
    }

    public TextField(Viewport viewport) {
        super(viewport);
        this.mString = new String();
        this.mKeysString = new String();
        this.Initialize();
    }

    public boolean OnDefaultMsg(Component component, int n, int n2) {
        if (n == -128) {
            n2 = n2 == 1 ? 1 : 0;
            this.SetFocus(n2 != 0);
            return true;
        }
        if (n < -121 || n > -119) {
            return super.OnDefaultMsg(component, n, n2);
        }
        if (!this.IsKeySupported(n2)) {
            return super.OnDefaultMsg(component, n, n2);
        }
        if ((n2 == 6 || n2 == 23) && this.mString.GetLength() == 0) {
            this.StopCycling();
            return false;
        }
        if (n == -121) {
            switch (n2) {
                case 6: 
                case 23: {
                    this.StopCycling();
                    if (this.mCursorPosition <= 0) break;
                    this.mString.RemoveCharAt(this.mCursorPosition - 1);
                    this.UpdateDisplay();
                    this.UpdateCursorPosition(-1);
                    this.SendMsg(this, -110, 0);
                    break;
                }
                default: {
                    if (this.mIsDigitsOnly && (n2 < 7 || n2 > 16)) {
                        return true;
                    }
                    this.InsertChar(n2);
                }
            }
        }
        return true;
    }
}

