/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Selection;
import ca.jamdat.flight.Text;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public class Scroller
extends Viewport {
    public static final byte finalState;
    public static final byte typeID;
    public boolean mIsViewportCentered;
    public Component[] mElements;
    public Viewport mScrollerViewport;
    public static final boolean supportsDynamicSerialization;
    public boolean mIsVertical;
    public Selection mNextArrow;
    public int mNumElements;
    public int mMaxNumElements;
    public Selection mPreviousArrow;
    public static final byte intermediateState;
    public static final byte typeNumber;

    public Scroller() {
        this.mIsVertical = true;
    }

    public void destruct() {
        for (int i = 0; i < this.mNumElements; ++i) {
            this.mElements[i] = null;
        }
        this.mElements = null;
    }

    public Scroller(int n) {
        this.mMaxNumElements = n;
        this.mIsVertical = true;
        this.mElements = this.AllocComponentTable();
    }

    public static Scroller Cast(Object object, Scroller scroller) {
        return (Scroller)object;
    }

    public void SetMaxNumElements(int n) {
        this.mMaxNumElements = n;
        Component[] componentArray = this.AllocComponentTable();
        int n2 = this.mMaxNumElements < this.mNumElements ? this.mMaxNumElements : this.mNumElements;
        int n3 = n2;
        for (n2 = 0; n2 < n3; ++n2) {
            componentArray[n2] = this.mElements[n2];
        }
        this.mElements = componentArray;
    }

    public void SetElementAt(int n, Component component) {
        this.mElements[n] = component;
    }

    public Component GetElementAt(int n) {
        return this.mElements[n];
    }

    public void SetNumElements(int n) {
        this.mNumElements = n;
    }

    public int GetNumElements() {
        return this.mNumElements;
    }

    public void SetNextArrow(Selection selection) {
        this.mNextArrow = selection;
    }

    public Selection GetNextArrow() {
        return this.mNextArrow;
    }

    public void SetPreviousArrow(Selection selection) {
        this.mPreviousArrow = selection;
    }

    public Selection GetPreviousArrow() {
        return this.mPreviousArrow;
    }

    public void SetIsViewportCentered(boolean bl) {
        this.mIsViewportCentered = bl;
    }

    public void SetScrollerViewport(Viewport viewport) {
        this.mScrollerViewport = viewport;
    }

    public F32 GetScrollbarRatio() {
        Component component = this.GetFirstElement();
        Vector2_short vector2_short = new Vector2_short();
        this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, component, false);
        if (this.mIsVertical) {
            short s = this.GetVerticalTotalScrollingSize();
            if (this.mScrollerViewport.GetRectHeight() >= s) {
                return F32.Zero(16);
            }
            return new F32(-vector2_short.GetY(), 16).Div(new F32(s - this.mScrollerViewport.GetRectHeight(), 16), 16);
        }
        short s = this.GetHorizontalTotalScrollingSize();
        if (this.mScrollerViewport.GetRectWidth() >= s) {
            return F32.Zero(16);
        }
        return new F32(-vector2_short.GetX(), 16).Div(new F32(s - this.mScrollerViewport.GetRectWidth(), 16), 16);
    }

    public short GetVisibleWindowSize() {
        if (this.mIsVertical) {
            return this.mScrollerViewport.GetRectHeight();
        }
        return this.mScrollerViewport.GetRectWidth();
    }

    public short GetTotalScrollingSize() {
        short s = this.mIsVertical ? this.GetVerticalTotalScrollingSize() : this.GetHorizontalTotalScrollingSize();
        return s;
    }

    public short GetFirstElemOffset() {
        if (this.mIsVertical) {
            return this.mScrollerViewport.GetOffsetY();
        }
        return this.mScrollerViewport.GetOffsetX();
    }

    public void SetVertical(boolean bl) {
        this.mIsVertical = bl;
    }

    public boolean IsVertical() {
        return this.mIsVertical;
    }

    public void FocusGained(int n) {
        if (this.mNextArrow != null) {
            n = n != 0 ? 1 : 0;
            this.mNextArrow.SetSelectedState(n != 0);
            this.mPreviousArrow.SetSelectedState(n != 0);
        }
    }

    public void ResetScroller() {
        if (this.mNumElements > 0) {
            Component component = this.GetFirstElement();
            Component component2 = this.GetLastElement();
            Viewport viewport = this.mScrollerViewport;
            boolean bl = this.mIsVertical ? this.GetVerticalTotalScrollingSize() > viewport.GetRectHeight() : this.GetHorizontalTotalScrollingSize() > viewport.GetRectWidth();
            short s = viewport.GetOffsetX();
            short s2 = viewport.GetOffsetY();
            if (this.mIsViewportCentered && !bl) {
                if (this.mIsVertical) {
                    s2 = (short)(-(viewport.GetRectHeight() + component.GetRectTop() - component2.GetBottom()) / 2);
                } else {
                    s = (short)(-(viewport.GetRectWidth() + component.GetRectLeft() - component2.GetRight()) / 2);
                }
            } else if (this.mIsVertical) {
                s2 = component.GetRectTop();
            } else {
                s = component.GetRectLeft();
            }
            viewport.OffsetTo(s, s2);
        }
        this.UpdateScroller();
    }

    public void UpdateScroller() {
        this.CheckIfArrowsAreNeeded();
        this.UpdateArrowsEnabledState();
    }

    public short GetScrollingPosition() {
        short s = this.mIsVertical ? this.mScrollerViewport.GetOffsetY() : this.mScrollerViewport.GetOffsetX();
        return s;
    }

    public void SetScrollingPosition(short s) {
        short s2 = 0;
        short s3 = 0;
        if (this.mIsVertical) {
            s3 = s;
        } else {
            s2 = s;
        }
        this.mScrollerViewport.OffsetTo(s2, s3);
    }

    public Component[] AllocComponentTable() {
        return new Component[this.mMaxNumElements];
    }

    public void UpdateArrowsEnabledState() {
        if (this.mNextArrow != null && this.mNumElements > 0) {
            Vector2_short vector2_short = new Vector2_short();
            this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, this.GetFirstElement(), false);
            Selection selection = this.mPreviousArrow;
            boolean bl = vector2_short.GetY() < 0;
            selection.SetEnabledState(bl);
            this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, this.GetLastElement(), true);
            Selection selection2 = this.mNextArrow;
            boolean bl2 = vector2_short.GetY() > 0;
            selection2.SetEnabledState(bl2);
        }
    }

    public void CheckIfArrowsAreNeeded() {
        if (this.mNextArrow != null) {
            boolean bl = false;
            if (this.mNumElements > 0) {
                Vector2_short vector2_short = new Vector2_short();
                this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, this.GetFirstElement(), false);
                boolean bl2 = vector2_short.GetX() == 0;
                bl = bl2;
                bl2 = vector2_short.GetY() == 0;
                boolean bl3 = bl2;
                this.mScrollerViewport.GetRequiredOffsetChange(vector2_short, this.GetLastElement(), true);
                bl2 = vector2_short.GetX() == 0;
                boolean bl4 = vector2_short.GetY() == 0;
                bl4 = !bl || !bl3 || !bl2 || !bl4;
                bl = bl4;
            }
            this.mNextArrow.SetVisible(bl);
            this.mPreviousArrow.SetVisible(bl);
        }
    }

    public void OnScrollEvent(int n, boolean n2) {
        int n3;
        n2 = -1;
        Object object = new Vector2_short();
        Component[] componentArray = this.mElements;
        if (n == 1) {
            for (n3 = 0; n3 < this.mNumElements; ++n3) {
                this.mScrollerViewport.GetRequiredOffsetChange((Vector2_short)object, componentArray[n3], true);
                if ((!this.mIsVertical || ((Vector2_short)object).GetY() <= 0) && (this.mIsVertical || ((Vector2_short)object).GetX() <= 0) || !componentArray[n3].IsVisible()) continue;
                n2 = n3;
                break;
            }
        } else {
            for (n3 = this.mNumElements - 1; n3 >= 0; --n3) {
                this.mScrollerViewport.GetRequiredOffsetChange((Vector2_short)object, componentArray[n3], false);
                if ((!this.mIsVertical || ((Vector2_short)object).GetY() >= 0) && (this.mIsVertical || ((Vector2_short)object).GetX() >= 0) || !componentArray[n3].IsVisible()) continue;
                n2 = n3;
                break;
            }
        }
        if (n2 >= 0) {
            if (componentArray[n2] instanceof Text) {
                short s = (short)(n * ((Text)componentArray[n2]).GetLineHeight());
                this.mScrollerViewport.OffsetBy((short)0, s);
            } else {
                object = this.mScrollerViewport;
                Component component = componentArray[n2];
                boolean bl = n == 1;
                ((Viewport)object).ChangeOffsetToShow(component, bl);
            }
            this.UpdateArrowsEnabledState();
            this.SendMsg(this, -111, 0);
        }
    }

    public boolean IsAppropriateHotkey(int n, int n2) {
        return false;
    }

    public Component GetFirstElement() {
        Component[] componentArray = this.mElements;
        for (int i = 0; i < this.mNumElements; ++i) {
            if (!componentArray[i].IsVisible() || !this.mScrollerViewport.IsSelfOrAncestorOf(componentArray[i].GetViewport())) continue;
            return componentArray[i];
        }
        return componentArray[0];
    }

    public Component GetLastElement() {
        Component[] componentArray = this.mElements;
        for (int i = this.mNumElements - 1; i >= 0; --i) {
            if (!componentArray[i].IsVisible() || !this.mScrollerViewport.IsSelfOrAncestorOf(componentArray[i].GetViewport())) continue;
            return componentArray[i];
        }
        return this.mElements[this.mNumElements - 1];
    }

    public short GetVerticalTotalScrollingSize() {
        Component component = this.GetLastElement();
        short s = component.GetAbsoluteTop();
        return (short)(component.GetRectHeight() + s - this.GetFirstElement().GetAbsoluteTop());
    }

    public short GetHorizontalTotalScrollingSize() {
        Component component = this.GetLastElement();
        short s = component.GetAbsoluteLeft();
        return (short)(component.GetRectWidth() + s - this.GetFirstElement().GetAbsoluteLeft());
    }

    public void OnScrollEvent(int n) {
        this.OnScrollEvent(n, true);
    }

    public static Scroller[] InstArrayScroller(int n) {
        Scroller[] scrollerArray = new Scroller[n];
        for (int i = 0; i < n; ++i) {
            scrollerArray[i] = new Scroller();
        }
        return scrollerArray;
    }

    public static Scroller[][] InstArrayScroller(int n, int n2) {
        Scroller[][] scrollerArray = new Scroller[n][];
        for (int i = 0; i < n; ++i) {
            scrollerArray[i] = new Scroller[n2];
            for (int j = 0; j < n2; ++j) {
                scrollerArray[i][j] = new Scroller();
            }
        }
        return scrollerArray;
    }

    public static Scroller[][][] InstArrayScroller(int n, int n2, int n3) {
        Scroller[][][] scrollerArray = new Scroller[n][][];
        for (int i = 0; i < n; ++i) {
            scrollerArray[i] = new Scroller[n2][];
            for (int j = 0; j < n2; ++j) {
                scrollerArray[i][j] = new Scroller[n3];
                for (int k = 0; k < n3; ++k) {
                    scrollerArray[i][j][k] = new Scroller();
                }
            }
        }
        return scrollerArray;
    }

    public byte GetTypeID() {
        return 98;
    }

    public static Class AsClass() {
        return null;
    }

    public boolean OnDefaultMsg(Component component, int n, int n2) {
        if (n == -114) {
            this.ResetScroller();
            return true;
        }
        if (n == -128) {
            this.FocusGained(n2);
            return false;
        }
        if (n == -125) {
            boolean bl = this.mNextArrow != null && this.mNextArrow.IsSelfOrAncestorOf(component);
            boolean bl2 = bl;
            bl = this.mPreviousArrow != null && this.mPreviousArrow.IsSelfOrAncestorOf(component);
            if ((n2 == 0 || 3 == n2) && (bl2 || bl)) {
                this.SendMsg(this, -111, 1);
            }
        } else if (n == -121 || n == -120 || n == -119) {
            int n3 = 0;
            if (this.mIsVertical) {
                if (n2 == 1) {
                    n3 = -1;
                } else if (n2 == 2) {
                    n3 = 1;
                }
            } else if (n2 == 3) {
                n3 = -1;
            } else if (n2 == 4) {
                n3 = 1;
            }
            if (n3 != 0) {
                if (this.mNumElements <= 0) {
                    return true;
                }
                if (this.mNextArrow != null) {
                    Selection selection = n3 == 1 ? this.mNextArrow : this.mPreviousArrow;
                    n2 = -121 != n ? 1 : 0;
                    selection.SetPushedState(n2 != 0);
                } else if (-121 == n) {
                    this.SendMsg(this, -111, 1);
                }
                if (n == -119) {
                    this.OnScrollEvent(n3);
                }
                return true;
            }
            if (this.IsAppropriateHotkey(n, n2)) {
                return true;
            }
        }
        return super.OnDefaultMsg(component, n, n2);
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mNextArrow = Selection.Cast(package_.SerializePointer((byte)97, true, false), null);
        this.mPreviousArrow = Selection.Cast(package_.SerializePointer((byte)97, true, false), null);
        this.mScrollerViewport = Viewport.Cast(package_.SerializePointer((byte)68, true, false), null);
        this.mIsVertical = package_.SerializeIntrinsic(this.mIsVertical);
        this.mIsViewportCentered = package_.SerializeIntrinsic(this.mIsViewportCentered);
        this.mNumElements = package_.SerializeIntrinsic(this.mNumElements);
        this.mMaxNumElements = package_.SerializeIntrinsic(this.mMaxNumElements);
        this.mElements = this.AllocComponentTable();
        for (int i = 0; i < this.mNumElements; ++i) {
            Component component;
            this.mElements[i] = component = Component.Cast(package_.SerializePointer((byte)-59, true, false), null);
        }
        if (package_.IsReading()) {
            this.ResetScroller();
        }
    }
}

