/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.CompiledConfigFile;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FlKeyManager;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.Scene;
import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.String;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.TimeData;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public class Application
extends Viewport {
    public static final byte gameOrientation180;
    public static final byte playViewProfile;
    public int mKeyRepeatTime;
    public byte mCurrentTransitionType = 0;
    public static final byte softKeyPositionTop;
    public static final byte StateLostFocus;
    public static final byte playViewFriends;
    public boolean mExitProcessed;
    public static final byte softKeyPositionBottomRight;
    public static final byte softKeyPositionTopRight;
    public boolean mFlightAltLock;
    public static final byte playViewDeck;
    public boolean mSymModeActivated;
    public static final byte softKeyPositionError;
    public int mLastKeyDown = 0;
    public static final byte defaultGamingKeyPrimary;
    public static final byte softKeyPositionTopLeft;
    public static final byte softKeyPositionBottom;
    public boolean isSuspended;
    public static final byte TimeFormat24H;
    public static final byte StateSystemInterruption;
    public short[] mKeyMap = new short[130];
    public boolean mDirty = true;
    public boolean mGameAltLock = true;
    public static final byte gameOrientation0;
    public byte mState = 0;
    public Scene mCurrentScene;
    public boolean mShiftModeActivated;
    public static final byte StateCount;
    public int mLastUserInputTime = Application.GetRealTime();
    public static final byte gameOrientationCurrent;
    public static final byte ExitTypeNow;
    public static final byte playViewArena;
    public TimeSystem mApplicationTimeSystem;
    public static final byte playViewShowRoom;
    public static final byte StateInactive;
    public static final byte defaultGamingKeySecondary;
    public static final byte softKeyPositionRight;
    public static final byte gameOrientation270;
    public static final byte playViewDefault;
    public boolean mIgnoreSecondKeyDown = true;
    public static final byte TimeFormat12H;
    public Vector2_short mSuspendedResolution = new Vector2_short();
    public static final byte softKeyPositionBottomLeft;
    public static final byte ExitTypeSoon;
    public Component mComponentWithFocus;
    public static final byte softKeyPositionLeft;
    public static final byte StateActive;
    public static final byte gameOrientationSystem;
    public static final byte gameOrientation90;
    public static final byte playViewGames;

    public Application() {
        this.mApplicationTimeSystem = new TimeSystem();
        FrameworkGlobals.GetInstance().application = this;
        this.mComponentWithFocus = this;
        FlRect flRect = DisplayManager.GetVideoModeRect();
        this.SetRect(flRect.GetLeft(), flRect.GetTop(), flRect.GetWidth(), flRect.GetHeight());
        FlKeyManager.GetInstance();
    }

    public void destruct() {
        FrameworkGlobals.GetInstance().mFlKeyManager = null;
        FrameworkGlobals.GetInstance().mFlPowerManager = null;
        FrameworkGlobals.GetInstance().mFlBrowser = null;
        this.mComponentWithFocus = null;
    }

    public void FocusLost() {
        if (!this.GetIsSuspended()) {
            this.Invalidate();
            this.SetIsSuspended(true);
            this.SetState((byte)2);
        }
    }

    public void FocusGained() {
        if (this.GetIsSuspended()) {
            this.ResetLastUserInputTime();
            this.Invalidate();
            this.SetIsSuspended(false);
            this.SetState((byte)0);
        }
    }

    public boolean QuitRequest() {
        return true;
    }

    public void SaveGame() {
    }

    public void Suspend() {
    }

    public void Resume() {
    }

    public void MainThreadCallback() {
    }

    public void OnScreenSizeChange() {
    }

    public void OnMasterVolumeChange(short s) {
    }

    public static Application GetInstance() {
        return FrameworkGlobals.GetInstance().application;
    }

    public static String GetJamdatBuildString() {
        return new String(Application.GetVersionString());
    }

    public static void Kill() {
    }

    public static boolean MemoryCardWasRemoved() {
        return false;
    }

    public static void Exit() {
        Application.ProcessExit();
        Application.OSExit();
    }

    public static void ProcessExit() {
        Application application = Application.GetInstance();
        if (!application.mExitProcessed) {
            Scene scene = application.mCurrentScene;
            if (scene != null) {
                scene.SendMsg(scene, -115, -1);
            }
            application.mExitProcessed = true;
        }
    }

    public static boolean HasExited() {
        return Application.GetInstance().mExitProcessed;
    }

    public static String GetTitle() {
        return new String();
    }

    public static String GetDir() {
        return new String();
    }

    public static String GetDataDir() {
        return new String();
    }

    public static byte GetMajorVersion() {
        return 4;
    }

    public static byte GetMinorVersion() {
        return 30;
    }

    public static short GetBuildVersion() {
        return 84;
    }

    public static String GetVersionString() {
        String string = new String(StringUtils.CreateString("."));
        String string2 = new String(Application.GetMajorVersion());
        string2.AddAssign(string);
        string2.AddAssign(new String(Application.GetMinorVersion()));
        string2.AddAssign(string);
        string2.AddAssign(new String(Application.GetBuildVersion()));
        return string2;
    }

    public static byte GetDemoFlag() {
        return 1;
    }

    public static byte GetLanguageFlag() {
        return 0;
    }

    public static byte GetUserFlag() {
        return 0;
    }

    public static String GetDeviceID() {
        return Application.GetPropertyValue(StringUtils.CreateString("DeviceID"));
    }

    public static String GetCarrierID() {
        return Application.GetPropertyValue(StringUtils.CreateString("CarrierID"));
    }

    public static String GetPlatformID() {
        return StringUtils.CreateString("3");
    }

    public static String GetHardwareKeyString() {
        String string = new String(StringUtils.CreateString(","));
        String string2 = new String(Application.GetCarrierID());
        if (string2.Equals(StringUtils.CreateString("9999"))) {
            return StringUtils.CreateString("1,2,390");
        }
        return string2.Add(string).Add(Application.GetPlatformID()).Add(string).Add(Application.GetDeviceID());
    }

    public static short GetTCPPort() {
        return (short)Application.GetPropertyValue(StringUtils.CreateString("TCPPort")).ToLong();
    }

    public static String GetServerAddr() {
        return Application.GetPropertyValue(StringUtils.CreateString("ServerAddr"));
    }

    public static String GetPropertyValue(String object) {
        object = StringUtils.CreateJavaString((String)object);
        if ((object = new CompiledConfigFile().getAppProperty((java.lang.String)object)) == null) {
            object = "NULL";
        }
        return StringUtils.CreateString((java.lang.String)object);
    }

    public boolean IsPropertySet(String string) {
        return string.GetLength() > 0 && !string.Equals(StringUtils.CreateString("NULL"));
    }

    public void SetOSWaitCursorVisible(boolean bl) {
    }

    public void SetDpadDisable(boolean bl) {
    }

    public void SetDirty(boolean bl) {
        this.mDirty = bl;
    }

    public boolean IsDirty() {
        return this.mDirty;
    }

    public void SendQuitRequestMsg() {
        this.SendMsg(this, -109, 0);
    }

    public void SetIsSuspended(boolean bl) {
        if (this.isSuspended != bl) {
            this.isSuspended = bl;
            if (bl) {
                this.OnSuspendFromOS();
                return;
            }
            this.OnResumeFromOS();
        }
    }

    public boolean GetIsSuspended() {
        return this.isSuspended;
    }

    public void SetState(byte by) {
        this.mState = by;
    }

    public byte GetState() {
        return this.mState;
    }

    public boolean KeyIsDown(int n) {
        return (this.mKeyMap[this.mLastKeyDown] == 0 && n == this.mLastKeyDown || n == this.mKeyMap[this.mLastKeyDown]) && n != 0;
    }

    public void MapKey(int n, int n2) {
        this.ResetDownKeys();
        this.mKeyMap[n] = (short)n2;
    }

    public void ResetDownKeys() {
        this.mLastKeyDown = 0;
    }

    public int GetTranslatedKey(int n) {
        if (this.mKeyMap[n] != 0) {
            n = this.mKeyMap[n];
        }
        return n;
    }

    public void UpdateSoftKey(int n, String string) {
        Bejeweled.getCurrentScene().updateSoftKey(n, StringUtils.CreateJavaString(string));
    }

    public int GetDefaultGamingKey(byte by, byte by2) {
        return 0;
    }

    public byte GetSoftKeyPosition(int n, byte by) {
        return 0;
    }

    public boolean GetKeyAltMode() {
        return this.mGameAltLock || this.mFlightAltLock;
    }

    public boolean GetKeyShiftMode() {
        return this.mShiftModeActivated;
    }

    public boolean GetKeySymMode() {
        return this.mSymModeActivated;
    }

    public boolean GetGameKeyAltMode() {
        return this.mGameAltLock;
    }

    public void SetGameKeyAltMode(boolean bl) {
        this.mGameAltLock = bl;
    }

    public void ReturnToOSGameMenu() {
    }

    public int ToFlightKey(int n) {
        n = this.KeyLayoutToFlightKey(n);
        if (this.GetKeyShiftMode()) {
            return FlKeyManager.FlightKeyToUpper(n);
        }
        return n;
    }

    public boolean OnKeyFromOS(int n, boolean bl) {
        if (n == 0) {
            return false;
        }
        if (n == 24) {
            if (!bl) {
                SoundManager.IncMasterVolume();
            }
            return true;
        }
        if (n == 25) {
            if (!bl) {
                SoundManager.DecMasterVolume();
            }
            return true;
        }
        switch (n) {
            case 114: {
                if (!bl) {
                    this.ToggleKeyAltMode();
                }
                return false;
            }
            case 115: {
                if (!bl) {
                    this.ToggleKeyShiftMode();
                }
                return false;
            }
        }
        this.ResetLastUserInputTime();
        int n2 = this.GetTranslatedKey(n);
        int n3 = this.mLastKeyDown;
        Component component = this.mComponentWithFocus;
        if (bl) {
            if (n3 == n) {
                this.mLastKeyDown = 0;
                component.SendMsg(component, -121, n2);
            } else if (this.mIgnoreSecondKeyDown) {
                this.OnKeyFromOS(n3, true);
            }
        } else if (n3 != 0) {
            this.OnKeyFromOS(n3, true);
            if (!this.mIgnoreSecondKeyDown) {
                this.OnKeyFromOS(n, false);
            }
        } else {
            this.mLastKeyDown = n;
            this.mKeyRepeatTime = Integer.MAX_VALUE;
            component.SendMsg(component, -120, n2);
            if (this.mComponentWithFocus == component) {
                component.SendMsg(component, -119, n2);
            }
        }
        return true;
    }

    public void SendKeyUpToLastKeyDown() {
        this.OnKeyFromOS(this.mLastKeyDown, true);
    }

    public void SetIgnoreSecondKeyDown(boolean bl) {
        this.mIgnoreSecondKeyDown = bl;
    }

    public boolean IsNativeResolution(int n, int n2) {
        Vector2_short vector2_short = new Vector2_short(this.GetSize());
        return vector2_short.GetX() == n && vector2_short.GetY() == n2;
    }

    public int GetAllowedOrientations() {
        return 0;
    }

    public int GetAllowedNativeOrientations() {
        return 0;
    }

    public byte GetCurrentGameOrientation() {
        return 0;
    }

    public boolean SetGameOrientation(byte by, boolean bl) {
        return true;
    }

    public boolean GetIsSystemSelectedOrientation() {
        return true;
    }

    public void StartUpCheck() {
    }

    public boolean IsStartUpCheckCompleted() {
        return true;
    }

    public void SetEnableIGN(boolean bl) {
    }

    public boolean IsIGNActive() {
        return false;
    }

    public void HideIGN() {
    }

    public void SwitchToPlay(byte by) {
    }

    public void RequestMainThreadCallback() {
        this.MainThreadCallback();
    }

    public void SetCurrentFocus(Component component) {
        component = component.ForwardFocus();
        Component component2 = this.mComponentWithFocus;
        this.mComponentWithFocus = component;
        int n = component.GetDepth();
        int n2 = component2.GetDepth();
        Application.MoveFocusForNotifications(component2, component, n - n2);
    }

    public Component GetCurrentFocus() {
        return this.mComponentWithFocus;
    }

    public void OnSuspendFromOS() {
        this.ReleaseAllInput();
        this.mSuspendedResolution.Assign(this.GetSize());
        this.Suspend();
    }

    public void OnResumeFromOS() {
        this.Resume();
    }

    public void ReleaseAllInput() {
        this.SendKeyUpToLastKeyDown();
    }

    public void ResetLastUserInputTime() {
        this.mLastUserInputTime = Application.GetRealTime();
    }

    public int GetDeltaTimeSinceLastUserInput() {
        return Application.GetRealTime() - this.mLastUserInputTime;
    }

    public byte GetTimeFormat() {
        return 1;
    }

    public int GetUserCount() {
        return 0;
    }

    public String GetUserName(int n) {
        return StringUtils.CreateString("");
    }

    public boolean DeleteUser(int n) {
        return true;
    }

    public boolean RenameUser(int n, String string) {
        return true;
    }

    public int AddUser(String string) {
        return 0;
    }

    public TimeData GetUserCreationDate(int n) {
        return new TimeData();
    }

    public int GetUserId(int n) {
        return 0;
    }

    public int GetUserIndex(int n) {
        return 0;
    }

    public boolean IsUserValid(int n) {
        return true;
    }

    public void OnTime(int n, int n2) {
    }

    public static TimeSystem GetGlobalTimeSystem() {
        return Application.GetInstance().mApplicationTimeSystem;
    }

    public static int GetRealTime() {
        return (int)System.currentTimeMillis();
    }

    public void Iteration(int n, int n2) {
        int n3 = this.mLastKeyDown;
        int n4 = this.mKeyRepeatTime;
        if (n3 != 0) {
            if (n4 == Integer.MAX_VALUE) {
                n4 = -350;
            } else if ((n4 += n2) > 150) {
                this.mComponentWithFocus.SendMsg(this.mComponentWithFocus, -119, this.GetTranslatedKey(n3));
                n4 = 0;
            }
        }
        this.mKeyRepeatTime = n4;
        this.mApplicationTimeSystem.OnTime(n, n2);
    }

    public long GetCycleNumber() {
        return 0L;
    }

    public String[] GetCommandLineArgs() {
        return null;
    }

    public int GetCommandLineArgsCount() {
        return 0;
    }

    public Scene GetCurrentScene() {
        return this.mCurrentScene;
    }

    public boolean IsInSceneTransition() {
        return this.mCurrentTransitionType != 0;
    }

    public static void OSExit() {
        Bejeweled.instance.exit();
    }

    public static void MoveFocusForNotifications(Component component, Component component2, int n) {
        if (component == component2) {
            return;
        }
        int n2 = n;
        Component component3 = null;
        if (n <= 0) {
            component.OnFocusChange(false);
            component = component.GetViewport();
            n2 = n + 1;
            if (component == component2) {
                component2.OnFocusChange(true);
            }
        }
        if (n >= 0) {
            component3 = component2;
            component2 = component2.GetViewport();
            --n2;
        }
        Application.MoveFocusForNotifications(component, component2, n2);
        if (component3 != null) {
            component3.OnFocusChange(true);
        }
    }

    public int KeyLayoutToFlightKey(int n) {
        if (!this.GetKeyAltMode() || n < 65 || n <= 90) {
            // empty if block
        }
        if (this.GetKeySymMode()) {
            // empty if block
        }
        if (n == 99999) {
            return 121;
        }
        if (n == 99998) {
            return 114;
        }
        if (n == 99999) {
            return 115;
        }
        if (n == 99999) {
            return 115;
        }
        if (n == 99999) {
            return 21;
        }
        if ((n = FlKeyManager.AsciiToFlightKey(n)) != 0) {
            return n;
        }
        return 0;
    }

    public void ToggleKeyShiftMode() {
        boolean bl = !this.mShiftModeActivated;
        this.mShiftModeActivated = bl;
    }

    public void ToggleKeyAltMode() {
        boolean bl = !this.mFlightAltLock;
        this.mFlightAltLock = bl;
    }

    public void ToggleKeySymMode() {
        boolean bl = !this.mSymModeActivated;
        this.mSymModeActivated = bl;
    }

    public int GetDefaultGamingKey(byte by) {
        return this.GetDefaultGamingKey(by, (byte)0);
    }

    public byte GetSoftKeyPosition(int n) {
        return this.GetSoftKeyPosition(n, (byte)0);
    }

    public boolean SetGameOrientation(byte by) {
        return this.SetGameOrientation(by, true);
    }

    public static Application[] InstArrayApplication(int n) {
        Application[] applicationArray = new Application[n];
        for (int i = 0; i < n; ++i) {
            applicationArray[i] = new Application();
        }
        return applicationArray;
    }

    public static Application[][] InstArrayApplication(int n, int n2) {
        Application[][] applicationArray = new Application[n][];
        for (int i = 0; i < n; ++i) {
            applicationArray[i] = new Application[n2];
            for (int j = 0; j < n2; ++j) {
                applicationArray[i][j] = new Application();
            }
        }
        return applicationArray;
    }

    public static Application[][][] InstArrayApplication(int n, int n2, int n3) {
        Application[][][] applicationArray = new Application[n][][];
        for (int i = 0; i < n; ++i) {
            applicationArray[i] = new Application[n2][];
            for (int j = 0; j < n2; ++j) {
                applicationArray[i][j] = new Application[n3];
                for (int k = 0; k < n3; ++k) {
                    applicationArray[i][j][k] = new Application();
                }
            }
        }
        return applicationArray;
    }
}

