/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.bejeweled;

import ca.jamdat.bejeweled.BaseScene;
import ca.jamdat.bejeweled.BejeweledState;
import ca.jamdat.bejeweled.CommonResourcesManager;
import ca.jamdat.bejeweled.GameEndScene;
import ca.jamdat.bejeweled.GameScene;
import ca.jamdat.bejeweled.HelpMenuScene;
import ca.jamdat.bejeweled.HighScoreScene;
import ca.jamdat.bejeweled.LanguageMenuScene;
import ca.jamdat.bejeweled.OptionsScene;
import ca.jamdat.bejeweled.ParticleGenerator;
import ca.jamdat.bejeweled.ProgressBar;
import ca.jamdat.bejeweled.PromptScene;
import ca.jamdat.bejeweled.SelectorScene;
import ca.jamdat.bejeweled.SplashScene;
import ca.jamdat.flight.Application;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FileStream;
import ca.jamdat.flight.FlLang;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.Font;
import ca.jamdat.flight.Library;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Scene;
import ca.jamdat.flight.Sound;
import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.SoundPlayer;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.String;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.VibrationManager;
import ca.jamdat.flight.Viewport;

public class GameApp
extends Application {
    public int mLastNewHighScorePosition = -1;
    public static final int noMoreMovesFX;
    public static final byte languageMenuPackage;
    public static final int illegalMoveSound;
    public SoundPlayer mSoundPlayer;
    public static final byte singleplayerGameScenePackage;
    public static final byte kRankDIconIndex;
    public boolean mIntroSoundPlaying;
    public static final int goSound;
    public static final byte languageGameScenePackage;
    public static final byte normalFile;
    public static final byte kRankEIconIndex;
    public boolean mIsVibrationOn = true;
    public boolean mSkipTutorial;
    public static final int gemExplosionBSound;
    public static final byte optionsMenuPackage;
    public int mIntroStartTime;
    public Package[] mPackageCache;
    public static final byte helpMenuPackage;
    public static final int gridGenesisSound;
    public boolean mAreHighScoresAllDefaults = true;
    public static final int caveInSound;
    public static final byte particlesPackage;
    public static final byte languageIndependentPackage;
    public static final byte appFile;
    public static final int confirmationSound;
    public static final byte languageCommonPackage;
    public static final byte splashPackage;
    public boolean mMustSaveState;
    public static boolean mAppExitNeededOnBrowserLaunch;
    public int mLastGameTypePlayed = -1;
    public static final byte fakeMainMenuPackage;
    public static final byte fontPackage;
    public static final int opponentAttackReadySound;
    public static final int noMoreMovesSound;
    public static final int soundsCount;
    public static final byte beamPackage;
    public Library mMainLibrary;
    public static final byte aboutMenuPackage;
    public static final byte highScoreMenuPackage;
    public static final int newHighScoreSound;
    public static final int multiplayerLoseSound;
    public boolean mPausing;
    public static final byte kRankCIconIndex;
    public boolean[] mTutorialsFlag;
    public int[] mHighScoreScores;
    public Sound[] mSounds = new Sound[30];
    public static final byte loadingHourGlassPackage;
    public static final int introSound;
    public TimeSystem mAnimationTimeSystem;
    public static final byte introSoundPackage;
    public static final byte languageScenePackage;
    public static final byte pauseMenuPackage;
    public static final int timeUpSound;
    public static final int excellentSound;
    public short mLanguage = 1;
    public static final int gemExplosionABigSound;
    public static final byte soundScenePackage;
    public boolean mFirstLaunch;
    public static final byte fileTypeCount;
    public static final byte invalidPackage;
    public static final byte newHighScoreMenuPackage;
    public static final byte kRankAIconIndex;
    public static final int gemExplosionCSound;
    public boolean mExitGameOnNextOnTime;
    public BejeweledState mGameState;
    public static final int welcomeToBejeweledSound;
    public static final byte timedFile;
    public static final byte gameEndSPMenuPackage;
    public boolean mKeepPackage;
    public static final byte logoPackage;
    public TimeSystem mSceneTimeSystem;
    public static final int gemExplosionASound;
    public static final byte commonPackage;
    public boolean firstSceneOver;
    public static final byte fakeOptionsMenuPackage;
    public static final int gemSelectSound;
    public static final int levelCompleteFX;
    public static final byte commonGameScenePackage;
    public static final byte soundPackage;
    public CommonResourcesManager mpCommonResourcesManager;
    public static final int multiplayerWinSound;
    public String[] mHighScoreNames;
    public static final int incredibleSound;
    public static final int levelCompleteSound;
    public static final int timerNoReturnSound;
    public static final int menuChangeSound;
    public static final int gemSwapSound;
    public static final byte promptMenuPackage;
    public boolean mLoadFileNeeded = true;
    public static final int bombAttackSound;
    public boolean mMustSaveApp;
    public static final byte commonMenuPackage;
    public static final int opponentAttackSound;
    public static final int goodbyeSound;
    public boolean mIsSoundOn = true;
    public boolean mFirstSceneResourcesLoaded;
    public static final byte moreGamesMenuPackage;
    public static final byte languageHelpPackage;
    public static final byte pkgCount;
    public static final byte kRankBIconIndex;
    public static final byte bejeweledLogoPackage;
    public int mAnimationTimeSystemDriff;
    public ProgressBar mProgressBar;
    public static final byte tutorialPackage;
    public boolean mWaitingForRematch;
    public static final int menuNavigationSound;
    public static final byte mainMenuPackage;
    public ParticleGenerator mParticleGenerator;

    public boolean CanResumeGame(int n) {
        boolean bl = false;
        FileStream fileStream = new FileStream(GameApp.GetFileName((byte)n), 0);
        if (fileStream.IsValid() && fileStream.ReadByte() == 0) {
            bl = true;
        }
        fileStream.Close();
        return bl;
    }

    public GameApp() {
        int n;
        this.mTutorialsFlag = new boolean[2];
        this.mHighScoreScores = new int[10];
        this.mHighScoreNames = String.InstArrayString(10);
        this.mPackageCache = new Package[31];
        this.mMainLibrary = new Library(Application.GetDir().Add(StringUtils.CreateString("Bejeweled")));
        DisplayManager.GetMainDisplayContext().EnableCoverageCheck(false);
        for (n = 0; n < 2; ++n) {
            this.mTutorialsFlag[n] = true;
        }
        this.mAnimationTimeSystem = new TimeSystem();
        this.mSceneTimeSystem = new TimeSystem();
        this.RegisterInGlobalTime();
        for (n = 0; n < 31; ++n) {
        }
        this.GetPackage((byte)7, false);
        this.ResetHighScores();
        this.mParticleGenerator = new ParticleGenerator();
        this.mParticleGenerator.LoadResources();
        if (!this.ManageSaveFiles()) {
            return;
        }
        FlMath.Seed(Application.GetRealTime());
        VibrationManager.Get().SetEnabled(true);
        if (this.mLoadFileNeeded && !this.Load()) {
            this.CreateSaveFiles();
        }
        if (this.mLanguage == 2 || this.mLanguage == 1) {
            this.mFirstLaunch = true;
        }
        this.mSoundPlayer = SoundManager.Get().GetChannelSoundPlayer(0);
        for (n = 0; n < this.mSounds.length; ++n) {
            this.mSounds[n] = null;
        }
        this.LoadSounds();
        this.LaunchFirstScene();
        this.mProgressBar = new ProgressBar();
    }

    public void destruct() {
        this.ReleaseStates();
        if (this.mpCommonResourcesManager != null) {
            this.mpCommonResourcesManager = null;
        }
        if (this.mParticleGenerator != null) {
            this.mParticleGenerator.UnloadResources();
            this.mParticleGenerator = null;
        }
        this.mProgressBar = null;
        this.UnRegisterInGlobalTime();
        this.mAnimationTimeSystem = null;
        this.mSceneTimeSystem = null;
        if (this.mSoundPlayer != null) {
            this.mSoundPlayer.SetSound(null);
        }
        for (int i = 30; i >= 0; --i) {
            Package package_ = this.mPackageCache[(byte)i];
            if (package_ == null || !package_.IsLoaded()) continue;
            package_.Unload();
        }
        this.mMainLibrary.Close();
    }

    public void ResetResumeGame(int n) {
        Object object = new FileStream(GameApp.GetFileName((byte)n), 1);
        if (((FileStream)object).IsValid()) {
            ((FileStream)object).WriteByte((byte)1);
        }
        ((FileStream)object).Close();
    }

    public void SetMustSaveApp(boolean bl) {
        this.mMustSaveApp = bl;
    }

    public boolean MustSaveApp() {
        return this.mMustSaveApp;
    }

    public void SetMustSaveState(boolean bl) {
        this.mMustSaveState = bl;
    }

    public boolean MustSaveState() {
        return this.mMustSaveState;
    }

    public void LaunchFirstScene() {
        if (this.mFirstLaunch) {
            this.HandleSceneTransitionCommand(20);
            return;
        }
        this.HandleSceneTransitionCommand(-1);
    }

    /*
     * WARNING - void declaration
     */
    public void HandleSceneTransitionCommand(int n) {
        BaseScene baseScene = null;
        this.TakeFocus();
        switch (n) {
            case 90: {
                this.UnstackAllScenes();
                if (!this.mGameState.IsGameOver()) {
                    this.ReleaseMenuPackages();
                    baseScene = new GameScene(16);
                    break;
                }
                baseScene = new GameEndScene(24);
                break;
            }
            case 80: 
            case 83: {
                int bl;
                int n2 = 2;
                if (n == 83) {
                    bl = 1;
                }
                if (this.CanResumeGame(bl)) {
                    baseScene = new PromptScene(21, 22, 23, 8, 4, 6, 1, true, n + 1, n + 2, 1, false, true);
                    break;
                }
                this.HandleSceneTransitionCommand(n + 1);
                break;
            }
            case 81: 
            case 82: 
            case 84: 
            case 85: {
                int bl;
                void bl2;
                if (n == 82 || n == 85) {
                    boolean promptScene = true;
                } else {
                    boolean bl3 = false;
                }
                void bl22 = bl2;
                boolean baseScene2 = true;
                if (n == 82 || n == 81) {
                    bl = 2;
                }
                if (bl22 == false) {
                    this.ResetResumeGame(bl);
                }
                this.UnstackAllScenes();
                this.ReleaseMenuPackages();
                this.CreateGame(bl, (boolean)bl22);
                baseScene = new GameScene(16);
                break;
            }
            case 86: {
                baseScene = new HighScoreScene(22);
                break;
            }
            case 91: {
                baseScene = new BaseScene(23);
                break;
            }
            case 126: 
            case 127: {
                int n3 = n == 127 ? 1 : 91;
                PromptScene promptScene = new PromptScene(21, 31, 32, 8, 4, 6, 1, true, 2, n3, 1, false, true);
                baseScene = promptScene;
                break;
            }
            case 92: {
                baseScene = new PromptScene(21, 27, 28, 8, 4, 6, 1, true, 1, 88, 0, false, true);
                break;
            }
            case 102: {
                this.UnstackAllScenes();
                this.ReleaseGamePackages();
                baseScene = new GameEndScene(24);
                break;
            }
            case 18: {
                this.ReleaseGamePackages();
                this.UnstackAllScenes();
                baseScene = new SelectorScene(20, true);
                break;
            }
            case -86: 
            case 2: {
                this.UnstackAllScenes();
                baseScene = new SelectorScene(18, true);
                break;
            }
            case 14: {
                baseScene = new OptionsScene(19);
                break;
            }
            case 15: {
                baseScene = new BaseScene(14);
                break;
            }
            case 10: {
                baseScene = new PromptScene(21, 29, 30, 4, 0, 6, 98, false, 0, 0, 0);
                break;
            }
            case 20: {
                boolean bl;
                boolean bl4 = false;
                if (!this.firstSceneOver) {
                    this.UnstackAllScenes();
                    this.SetDefaultLanguage();
                    bl = true;
                } else {
                    this.ReleaseMenuPackages();
                }
                baseScene = new LanguageMenuScene(29, true, bl);
                break;
            }
            case -1: {
                this.SetSound(false);
                this.UnstackAllScenes();
                this.SetDefaultLanguage();
                baseScene = new PromptScene(21, 14, 26, 8, 4, 14, 0, true, -3, -2, 1, false, true);
                break;
            }
            case -3: 
            case -2: {
                void var3_17;
                if (n == -2) {
                    boolean bl = true;
                } else {
                    boolean bl = false;
                }
                this.SetSound((boolean)var3_17);
                this.mpCommonResourcesManager.GetHighlightViewport().SetVisible(false);
                this.HandleSceneTransitionCommand(19);
                break;
            }
            case 19: {
                this.firstSceneOver = true;
                baseScene = new SplashScene(25);
                break;
            }
            case 16: {
                baseScene = new HelpMenuScene(17, true);
                break;
            }
            case 21: {
                baseScene = new PromptScene(21, 18, 19, 8, 4, 6, 1, true, 1, 6, 1, false, true);
                break;
            }
            case 118: {
                this.LoadLanguageAndGoToNextScene((short)11);
                break;
            }
            case 120: {
                this.LoadLanguageAndGoToNextScene((short)14);
                break;
            }
            case 119: {
                this.LoadLanguageAndGoToNextScene((short)12);
                break;
            }
            case 123: {
                this.LoadLanguageAndGoToNextScene((short)19);
                break;
            }
            case 122: {
                this.LoadLanguageAndGoToNextScene((short)9);
                break;
            }
            case -113: {
                this.LoadLanguageAndGoToNextScene((short)26);
                break;
            }
            case -114: {
                this.LoadLanguageAndGoToNextScene((short)28);
                break;
            }
            case -119: {
                this.LoadLanguageAndGoToNextScene((short)29);
                break;
            }
            case -115: {
                this.LoadLanguageAndGoToNextScene((short)30);
                break;
            }
            case -116: {
                this.LoadLanguageAndGoToNextScene((short)31);
                break;
            }
            case -117: {
                this.LoadLanguageAndGoToNextScene((short)4137);
                break;
            }
            case -118: {
                this.LoadLanguageAndGoToNextScene((short)8233);
                break;
            }
            case 17: {
                this.Save();
            }
            case 1: 
            case 94: {
                Scene.Dismiss(0);
                break;
            }
            case -78: {
                Scene.Dismiss(n);
            }
        }
        if (baseScene != null) {
            BaseScene baseScene2 = (BaseScene)GameApp.GetGameAppInstance().GetScene();
            if (baseScene2 != null) {
                void var3_21;
                if (baseScene2.GetPackageID() == baseScene.GetPackageID()) {
                    boolean bl = true;
                } else {
                    boolean bl = false;
                }
                this.mKeepPackage = var3_21;
            }
            baseScene.SetViewport(this);
            Scene.Launch(baseScene);
        }
    }

    public void ResetHighScores() {
        this.mHighScoreNames[0].Assign(StringUtils.CreateString("MAX"));
        this.mHighScoreNames[1].Assign(StringUtils.CreateString("SIMON"));
        this.mHighScoreNames[2].Assign(StringUtils.CreateString("NICK"));
        this.mHighScoreNames[3].Assign(StringUtils.CreateString("FRANCIS"));
        this.mHighScoreNames[4].Assign(StringUtils.CreateString("HUGO"));
        this.mHighScoreNames[5].Assign(StringUtils.CreateString("POLY"));
        this.mHighScoreNames[6].Assign(StringUtils.CreateString("JPP"));
        this.mHighScoreNames[7].Assign(StringUtils.CreateString("DOM"));
        this.mHighScoreNames[8].Assign(StringUtils.CreateString("CARL"));
        this.mHighScoreNames[9].Assign(StringUtils.CreateString("MIKE"));
        this.mHighScoreScores[0] = 10000;
        this.mHighScoreScores[1] = 5500;
        this.mHighScoreScores[2] = 3000;
        this.mHighScoreScores[3] = 1500;
        this.mHighScoreScores[4] = 500;
        this.mHighScoreScores[5] = 10000;
        this.mHighScoreScores[6] = 5500;
        this.mHighScoreScores[7] = 3000;
        this.mHighScoreScores[8] = 1500;
        this.mHighScoreScores[9] = 500;
        this.mAreHighScoresAllDefaults = true;
    }

    public int GetHighScoreScore(int n, int n2) {
        return this.mHighScoreScores[n + (n2 - 1) * 5];
    }

    public String GetHighScoreName(int n, int n2) {
        return this.mHighScoreNames[n + (n2 - 1) * 5];
    }

    public int GetLastNewHighScorePosition() {
        return this.mLastNewHighScorePosition;
    }

    public void SetLastNewHighScorePosition(int n) {
        this.mLastNewHighScorePosition = n;
    }

    public boolean IsHighScore() {
        if (this.mGameState.AreCheatsEnabled()) {
            return false;
        }
        int n = 4 + (this.mGameState.GetGameType() - 1) * 5;
        return this.mGameState.GetScore() >= this.mHighScoreScores[n];
    }

    public int AddHighScore(String string, int n, int n2) {
        String string2 = new String();
        String string3 = new String();
        string3.Assign(string);
        n2 = (n2 - 1) * 5;
        int n3 = -1;
        boolean bl = false;
        for (int i = n2; i < 5 + n2; ++i) {
            if (n < this.mHighScoreScores[i] && !bl) continue;
            int n4 = this.mHighScoreScores[i];
            string2.Assign(this.mHighScoreNames[i]);
            this.mHighScoreScores[i] = n;
            this.mHighScoreNames[i].Assign(string3);
            n = n4;
            string3.Assign(string2);
            bl = true;
            this.mAreHighScoresAllDefaults = false;
            if (n3 != -1) continue;
            n3 = i;
        }
        return n3;
    }

    public boolean AreHighScoresAllDefaults() {
        return this.mAreHighScoresAllDefaults;
    }

    public void ClearStackToScene(byte by, boolean bl) {
        BaseScene baseScene = (BaseScene)this.GetCurrentScene();
        byte by2 = -1;
        while (baseScene != null && by2 != by) {
            by2 = baseScene.GetPackageID();
            if (bl || by2 != by) {
                this.GetCurrentScene();
                Scene.Dismiss(24);
            }
            baseScene = (BaseScene)this.GetCurrentScene();
        }
    }

    public void RebuildStackToMainMenu() {
        this.UnstackAllScenes();
        SelectorScene selectorScene = new SelectorScene(-18, true);
        selectorScene.SetViewport(this);
        Scene.Launch(selectorScene);
    }

    public void ReleaseStates() {
        if (this.mGameState != null) {
            this.mGameState.UnloadResources();
        }
        this.mGameState = null;
    }

    public void SetDefaultLanguage() {
        short s = this.GetGameLanguage();
        if (s == 2 || s == 1) {
            this.SetGameLanguage((short)11);
            return;
        }
        this.SetGameLanguage(s);
    }

    public boolean PlaySound(int n, boolean bl) {
        Sound sound;
        if (this.mIntroSoundPlaying && Application.GetGlobalTimeSystem().GetTotalTime() - this.mIntroStartTime >= 20000) {
            this.mIntroSoundPlaying = false;
        }
        if (bl && this.mIsSoundOn && !this.mIntroSoundPlaying && (sound = this.mSounds[n]) != null) {
            if (n == 1) {
                this.mIntroSoundPlaying = true;
                this.mIntroStartTime = Application.GetGlobalTimeSystem().GetTotalTime();
            }
            if (sound != null) {
                this.mSoundPlayer.SetSound(sound);
            }
            if (sound != null) {
                this.mSoundPlayer.Play();
            }
            return true;
        }
        return false;
    }

    public void StopSound() {
        this.mIntroSoundPlaying = false;
        this.mSoundPlayer.Stop();
    }

    public SoundPlayer GetSoundPlayer() {
        return this.mSoundPlayer;
    }

    public void StartVibration(int n, boolean bl) {
        this.StopSound();
        if (this.mIsVibrationOn && bl) {
            VibrationManager.Get().Start(n);
        }
    }

    public void StopVibration() {
        VibrationManager.Get().Stop();
    }

    public Package GetPackage(byte by, boolean bl) {
        Package package_ = this.mPackageCache[by];
        if (package_ == null) {
            switch (by) {
                case 10: {
                    package_ = this.GetPackageDependencies(10, bl, 5, (byte)7, (byte)8, (byte)9, (byte)0, (byte)6, (byte)-1);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    package_ = this.mMainLibrary.NewPackage(by);
                    break;
                }
                case 12: {
                    package_ = this.GetPackageDependencies(12, bl, 3, (byte)10, (byte)2, (byte)5, (byte)-1, (byte)-1, (byte)-1);
                    break;
                }
                case 13: 
                case 14: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    package_ = this.GetPackageDependencies(by, bl, 2, (byte)10, (byte)12, (byte)-1, (byte)-1, (byte)-1, (byte)-1);
                    break;
                }
                case 17: {
                    package_ = this.GetPackageDependencies(by, bl, 3, (byte)10, (byte)12, (byte)4, (byte)-1, (byte)-1, (byte)-1);
                    break;
                }
                case 16: {
                    package_ = this.GetPackageDependencies(by, bl, 4, (byte)10, (byte)15, (byte)11, (byte)3, (byte)-1, (byte)-1);
                    break;
                }
                case 15: {
                    package_ = this.GetPackageDependencies(by, bl, 2, (byte)10, (byte)3, (byte)-1, (byte)-1, (byte)-1, (byte)-1);
                    break;
                }
                case 25: 
                case 26: {
                    package_ = this.GetPackageDependencies(by, bl, 2, (byte)10, (byte)5, (byte)-1, (byte)-1, (byte)-1, (byte)-1);
                    break;
                }
                case 29: {
                    package_ = this.GetPackageDependencies(by, bl, 4, (byte)10, (byte)6, (byte)5, (byte)2, (byte)-1, (byte)-1);
                    break;
                }
                case 30: {
                    package_ = this.GetPackageDependencies(by, bl, 3, (byte)10, (byte)5, (byte)2, (byte)-1, (byte)-1, (byte)-1);
                    break;
                }
                case 11: {
                    package_ = this.GetPackageDependencies(11, bl, 2, (byte)8, (byte)3, (byte)-1, (byte)-1, (byte)-1, (byte)-1);
                    break;
                }
                case 28: {
                    package_ = this.mMainLibrary.NewPackage(28);
                    break;
                }
                case 27: {
                    package_ = this.mMainLibrary.NewPackage(27);
                    break;
                }
                case 9: {
                    package_ = this.mMainLibrary.NewPackage(9);
                    break;
                }
                case 0: {
                    package_ = this.mMainLibrary.NewPackage(by);
                    break;
                }
                case 1: {
                    package_ = this.mMainLibrary.NewPackage(this.GetLocalisationPackageID(by));
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    package_ = this.GetPackageDependencies(this.GetLocalisationPackageID(by), bl, 1, (byte)1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1);
                }
            }
        }
        if (!package_.IsLoading() && !package_.IsLoaded()) {
            package_.Load(bl);
        }
        package_.SetNextEntryPointIndex(0);
        this.mPackageCache[by] = package_;
        return package_;
    }

    public void RemovePackageFromCache(byte by) {
        Package package_;
        if (by == 12) {
            GameApp.GetGameAppInstance().GetCommonResourcesManager().UnloadBejeweledLogo();
        }
        if ((package_ = this.mPackageCache[by]) != null && (package_.IsLoaded() || package_.IsLoading())) {
            package_.Unload();
        }
        this.mPackageCache[by] = null;
    }

    public CommonResourcesManager GetCommonResourcesManager() {
        if (this.mpCommonResourcesManager == null) {
            this.mpCommonResourcesManager = new CommonResourcesManager();
        }
        return this.mpCommonResourcesManager;
    }

    public ProgressBar GetProgressBar() {
        return this.mProgressBar;
    }

    public Package GetPackageDependencies(int n, boolean bl, int n2, byte by, byte by2, byte by3, byte by4, byte by5, byte by6) {
        byte[] byArray = new byte[]{by, by2, by3, by4, by5, by6};
        Package package_ = this.mMainLibrary.NewPackage(n);
        package_.SetNumDependencies(n2);
        for (by5 = 0; by5 < n2; by5 = (byte)(by5 + 1)) {
            package_.SetDependency(by5, this.GetPackage(byArray[by5], bl));
        }
        return package_;
    }

    public void SetLoadingSpriteVisible(boolean bl) {
        Sprite sprite = Sprite.Cast(this.GetPackage((byte)7, false).GetEntryPoint(0), null);
        if (bl) {
            sprite.SetViewport(this);
            return;
        }
        sprite.SetViewport(null);
    }

    public boolean IsSoundOn() {
        return this.mIsSoundOn;
    }

    public void SetSound(boolean bl) {
        this.mIsSoundOn = bl;
    }

    public boolean IsVibrationOn() {
        return this.mIsVibrationOn;
    }

    public void SetVibration(boolean bl) {
        this.mIsVibrationOn = bl;
    }

    public boolean IsPausing() {
        return this.mPausing;
    }

    public void SetIsPausing(boolean bl) {
        this.mPausing = bl;
    }

    public boolean IsTutorialOn(int n) {
        return this.mTutorialsFlag[n - 1] && !this.mSkipTutorial;
    }

    public void SetTutorial(int n, boolean bl) {
        this.mTutorialsFlag[n] = bl;
        if (n != 0) {
            this.mTutorialsFlag[0] = bl;
        }
    }

    public ParticleGenerator GetParticleGenerator() {
        return this.mParticleGenerator;
    }

    public void ReleaseMenuPackages() {
        this.RemovePackageFromCache((byte)12);
        this.RemovePackageFromCache((byte)5);
    }

    public void ReleaseGamePackages() {
        this.RemovePackageFromCache((byte)15);
        this.RemovePackageFromCache((byte)11);
        this.RemovePackageFromCache((byte)3);
    }

    public static void ToUpper(String string) {
        int n = string.GetLength();
        for (int i = 0; i < n; ++i) {
            byte by = string.GetCharAt(i);
            if (by < 97 || by > 122) continue;
            string.ReplaceCharAt(i, (byte)(by - 32));
        }
    }

    public static void RightTrim(String string) {
        for (int i = string.GetLength(); i > 0 && string.GetCharAt(i - 1) == 32; --i) {
            string.RemoveCharAt(i - 1);
        }
    }

    public static void Trunc(String string, int n, Font font) {
        if (font.GetLineWidth(string) > n) {
            GameApp.RightTrim(string);
            if (string.IsEmpty()) {
                string.AddAssign(StringUtils.CreateString(" "));
                return;
            }
            string.AddAssign(StringUtils.CreateString("."));
            int n2 = font.GetLineWidth(string);
            while (n2 >= n) {
                string.RemoveCharAt(string.GetLength() - 2);
                n2 = font.GetLineWidth(string);
            }
            while (string.GetCharAt(string.GetLength() - 2) == 32) {
                string.RemoveCharAt(string.GetLength() - 2);
            }
        }
    }

    public void CreateGame(int n, boolean bl) {
        this.mLastGameTypePlayed = n;
        this.mMustSaveApp = true;
        this.mGameState = null;
        this.mGameState = new BejeweledState(n, true, bl);
    }

    public BejeweledState GetGameState() {
        return this.mGameState;
    }

    public boolean IsWaitingForRematch() {
        return this.mWaitingForRematch;
    }

    public void SetWaitingForRematch(boolean bl) {
        this.mWaitingForRematch = bl;
    }

    public int GetLastGameTypePlayed() {
        return this.mLastGameTypePlayed;
    }

    public Scene GetScene() {
        return this.GetCurrentScene();
    }

    public void SetKeepPackage(boolean bl) {
        this.mKeepPackage = bl;
    }

    public boolean GetKeepPackage() {
        return this.mKeepPackage;
    }

    public void ResetKeepPackage() {
        this.mKeepPackage = false;
    }

    public void LoadSounds() {
        Object object = this.mSounds;
        Object object2 = this.mSounds[1];
        object2 = Sound.Cast(this.GetPackage((byte)28, false).GetEntryPoint(0), null);
        object[1] = object2;
        object2 = this.GetPackage((byte)27, false);
        object = this.mSounds[0];
        this.mSounds[0] = Sound.Cast(((Package)object2).GetEntryPoint(1), null);
        object = this.mSounds[2];
        this.mSounds[2] = Sound.Cast(((Package)object2).GetEntryPoint(0), null);
        object = this.mSounds[4];
        this.mSounds[4] = Sound.Cast(((Package)object2).GetEntryPoint(8), null);
        object = this.mSounds[6];
        this.mSounds[6] = Sound.Cast(((Package)object2).GetEntryPoint(1), null);
        object = this.mSounds[7];
        this.mSounds[7] = Sound.Cast(((Package)object2).GetEntryPoint(2), null);
        object = this.mSounds[8];
        this.mSounds[8] = Sound.Cast(((Package)object2).GetEntryPoint(3), null);
        object = this.mSounds[9];
        this.mSounds[9] = Sound.Cast(((Package)object2).GetEntryPoint(4), null);
        object = this.mSounds[10];
        this.mSounds[10] = Sound.Cast(((Package)object2).GetEntryPoint(5), null);
        object = this.mSounds[12];
        this.mSounds[12] = Sound.Cast(((Package)object2).GetEntryPoint(6), null);
        object = this.mSounds[25];
        this.mSounds[25] = Sound.Cast(((Package)object2).GetEntryPoint(10), null);
        object = this.mSounds[26];
        this.mSounds[26] = Sound.Cast(((Package)object2).GetEntryPoint(10), null);
        object = this.mSounds[27];
        this.mSounds[27] = Sound.Cast(((Package)object2).GetEntryPoint(9), null);
        object = this.mSounds[28];
        this.mSounds[28] = Sound.Cast(((Package)object2).GetEntryPoint(7), null);
    }

    public void UnstackAllScenes() {
        while (this.GetCurrentScene() != null) {
            this.GetCurrentScene();
            Scene.Dismiss(24);
        }
    }

    public boolean OnMsg(Component component, int n, int n2) {
        if (n == -109) {
            this.QuitApplication();
        }
        return super.OnMsg(component, n, n2);
    }

    public boolean ManageSaveFiles() {
        if (!this.SaveFilesExist()) {
            this.CreateSaveFiles();
            this.mLoadFileNeeded = false;
        }
        return true;
    }

    public boolean SaveFilesExist() {
        for (int i = 0; i < 3; ++i) {
            if (FileStream.FileExists(GameApp.GetFileName((byte)i))) continue;
            return false;
        }
        return true;
    }

    public void CreateSaveFiles() {
        int n;
        this.mMustSaveApp = true;
        this.Save();
        FileStream fileStream = new FileStream(GameApp.GetFileName((byte)2), 1);
        FileStream fileStream2 = new FileStream(GameApp.GetFileName((byte)1), 1);
        fileStream.WriteByte((byte)1);
        fileStream2.WriteByte((byte)1);
        for (n = 0; n < 71; ++n) {
            fileStream.WriteByte((byte)0);
            fileStream2.WriteByte((byte)0);
        }
        for (n = 0; n < 4; ++n) {
            fileStream.WriteLong(0);
            fileStream2.WriteLong(0);
        }
        fileStream.WriteByte((byte)0);
        fileStream.WriteByte((byte)2);
        fileStream.WriteShort((short)0);
        fileStream.WriteShort((short)0);
        fileStream.WriteShort((short)0);
        fileStream2.WriteByte((byte)0);
        fileStream2.WriteByte((byte)2);
        fileStream2.WriteShort((short)0);
        fileStream2.WriteShort((short)0);
        fileStream2.WriteShort((short)0);
        fileStream.Close();
        fileStream2.Close();
    }

    public Package GetPackage(byte by) {
        return this.GetPackage(by, true);
    }

    public static GameApp[] InstArrayGameApp(int n) {
        GameApp[] gameAppArray = new GameApp[n];
        for (int i = 0; i < n; ++i) {
            gameAppArray[i] = new GameApp();
        }
        return gameAppArray;
    }

    public static GameApp[][] InstArrayGameApp(int n, int n2) {
        GameApp[][] gameAppArray = new GameApp[n][];
        for (int i = 0; i < n; ++i) {
            gameAppArray[i] = new GameApp[n2];
            for (int j = 0; j < n2; ++j) {
                gameAppArray[i][j] = new GameApp();
            }
        }
        return gameAppArray;
    }

    public static GameApp[][][] InstArrayGameApp(int n, int n2, int n3) {
        GameApp[][][] gameAppArray = new GameApp[n][][];
        for (int i = 0; i < n; ++i) {
            gameAppArray[i] = new GameApp[n2][];
            for (int j = 0; j < n2; ++j) {
                gameAppArray[i][j] = new GameApp[n3];
                for (int k = 0; k < n3; ++k) {
                    gameAppArray[i][j][k] = new GameApp();
                }
            }
        }
        return gameAppArray;
    }

    static {
        mAppExitNeededOnBrowserLaunch = true;
    }

    public void OnDraw(DisplayContext displayContext) {
        super.OnDraw(displayContext);
        if (this.mParticleGenerator != null) {
            this.mParticleGenerator.OnDraw(displayContext);
        }
    }

    public void SaveGame() {
        if (this.mMustSaveState) {
            this.SaveState();
        }
        if (this.mMustSaveApp) {
            this.Save();
        }
    }

    public void Suspend() {
        this.SuspendApp();
    }

    public void Resume() {
    }

    public void OnTime(int n, int n2) {
        this.mSceneTimeSystem.OnTime(n, n2);
        if (n2 < 400) {
            int n3;
            if (this.mAnimationTimeSystemDriff > 50) {
                this.mAnimationTimeSystemDriff -= 50;
                n3 = 50;
            } else {
                n3 = this.mAnimationTimeSystemDriff;
                this.mAnimationTimeSystemDriff = 0;
            }
            this.mAnimationTimeSystem.OnTime(n, n2 + n3);
            return;
        }
        if (this.GetGameState() != null && this.GetGameState().GetState() == 1) {
            this.mAnimationTimeSystemDriff += n2 - 200 >> 1;
        }
        this.mAnimationTimeSystem.OnTime(n, 200);
    }

    public static GameApp GetGameAppInstance() {
        return (GameApp)Application.GetInstance();
    }

    public short GetGameLanguage() {
        return this.mLanguage;
    }

    public boolean SetGameLanguage(short s) {
        switch (s) {
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 19: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 4137: 
            case 8233: {
                this.mLanguage = s;
                this.mMustSaveApp = true;
                return true;
            }
        }
        return false;
    }

    public void LoadLanguageAndGoToNextScene(short s) {
        this.RemovePackageFromCache((byte)2);
        this.RemovePackageFromCache((byte)4);
        this.RemovePackageFromCache((byte)3);
        this.RemovePackageFromCache((byte)1);
        this.SetGameLanguage(s);
        if (this.firstSceneOver) {
            this.HandleSceneTransitionCommand(1);
            return;
        }
        this.HandleSceneTransitionCommand(-1);
    }

    public byte GetLocalisationPackageID(byte by) {
        switch (GameApp.GetGameAppInstance().GetGameLanguage()) {
            case 11: {
                if (by == 1) {
                    by = (byte)35;
                    break;
                }
                if (by == 2) {
                    by = (byte)36;
                    break;
                }
                if (by == 4) {
                    by = (byte)38;
                    break;
                }
                by = (byte)37;
                break;
            }
            case 14: {
                if (by == 1) {
                    by = (byte)43;
                    break;
                }
                if (by == 2) {
                    by = (byte)44;
                    break;
                }
                if (by == 4) {
                    by = (byte)46;
                    break;
                }
                by = (byte)45;
                break;
            }
            case 12: {
                if (by == 1) {
                    by = (byte)39;
                    break;
                }
                if (by == 2) {
                    by = (byte)40;
                    break;
                }
                if (by == 4) {
                    by = (byte)42;
                    break;
                }
                by = (byte)41;
                break;
            }
            case 19: {
                if (by == 1) {
                    by = (byte)47;
                    break;
                }
                if (by == 2) {
                    by = (byte)48;
                    break;
                }
                if (by == 4) {
                    by = (byte)50;
                    break;
                }
                by = (byte)49;
                break;
            }
            case 9: {
                if (by == 1) {
                    by = (byte)31;
                    break;
                }
                if (by == 2) {
                    by = (byte)32;
                    break;
                }
                if (by == 4) {
                    by = (byte)34;
                    break;
                }
                by = (byte)33;
                break;
            }
            default: {
                return -1;
            }
        }
        return by;
    }

    public boolean QueryGameLanguage() {
        return this.SetGameLanguage(FlLang.GetBestLang());
    }

    public void SuspendApp() {
        ((GameApp)viewport).ResetTimeDrift();
        Viewport viewport = (BaseScene)((Application)viewport).GetCurrentScene();
        if (viewport != null) {
            ((BaseScene)viewport).Suspend();
        }
    }

    public void QuitApplication() {
        if (this.mSoundPlayer != null) {
            this.mSoundPlayer.SetSound(null);
        }
        Application.Exit();
    }

    public boolean IsInTransition() {
        return super.IsInSceneTransition();
    }

    public void Register(TimeControlled timeControlled, boolean bl) {
        if (bl) {
            this.mAnimationTimeSystem.Register(timeControlled);
            return;
        }
        this.mSceneTimeSystem.Register(timeControlled);
    }

    public void UnRegister(TimeControlled timeControlled, boolean bl) {
        if (bl) {
            this.mAnimationTimeSystem.UnRegister(timeControlled);
            return;
        }
        this.mSceneTimeSystem.UnRegister(timeControlled);
    }

    public void ResetTimeDrift() {
        this.mAnimationTimeSystemDriff = 0;
    }

    public static String GetFileName(byte by) {
        String string = new String(Application.GetDataDir());
        switch (by) {
            case 0: {
                string.AddAssign(StringUtils.CreateString("app.bin"));
                break;
            }
            case 2: {
                string.AddAssign(StringUtils.CreateString("t.bin"));
                break;
            }
            case 1: {
                string.AddAssign(StringUtils.CreateString("n.bin"));
            }
        }
        return string;
    }

    public void SaveState() {
        if (this.mGameState != null && !this.mGameState.IsInTutorialMode() && this.mGameState.GetGameType() != 3) {
            this.mGameState.Save();
        }
    }

    public boolean Load() {
        FileStream fileStream = new FileStream(GameApp.GetFileName((byte)0), 0);
        int n = 0;
        if (fileStream.IsValid()) {
            int n2 = !Application.GetDeviceID().Equals(StringUtils.CreateString("NULL")) ? (fileStream.ReadLong() == Application.GetDeviceID().ToLong() ? 1 : 0) : (fileStream.ReadLong() == -1 ? 1 : 0);
            n2 = n2 != 0 && fileStream.ReadByte() == 2 ? 1 : 0;
            n = n2;
            if (n2 != 0) {
                int n3;
                n2 = fileStream.ReadByte() == 1 ? 1 : 0;
                this.mIsSoundOn = n2;
                n2 = fileStream.ReadByte() == 1 ? 1 : 0;
                this.mIsVibrationOn = n2;
                for (n2 = 0; n2 < 2; ++n2) {
                    boolean[] blArray = this.mTutorialsFlag;
                    int n4 = n2;
                    n3 = fileStream.ReadByte() == 1 ? 1 : 0;
                    blArray[n4] = n3;
                }
                this.SetGameLanguage(fileStream.ReadByte());
                for (n3 = 0; n3 < 10; ++n3) {
                    this.mHighScoreScores[n3] = fileStream.ReadLong();
                    this.mHighScoreNames[n3].Assign(fileStream.ReadString());
                }
                n3 = fileStream.ReadByte() == 1 ? 1 : 0;
                this.mAreHighScoresAllDefaults = n3;
                this.mLastGameTypePlayed = fileStream.ReadByte();
            }
        }
        fileStream.Close();
        return n != 0;
    }

    public void Save() {
        if (this.mMustSaveApp) {
            int n;
            FileStream fileStream = new FileStream(GameApp.GetFileName((byte)0), 1);
            if (!Application.GetDeviceID().Equals(StringUtils.CreateString("NULL"))) {
                fileStream.WriteLong(Application.GetDeviceID().ToLong());
            } else {
                fileStream.WriteLong(-1);
            }
            fileStream.WriteByte((byte)2);
            int n2 = this.mIsSoundOn ? 1 : 0;
            fileStream.WriteByte((byte)n2);
            n2 = this.mIsVibrationOn ? 1 : 0;
            fileStream.WriteByte((byte)n2);
            for (n2 = 0; n2 < 2; ++n2) {
                n = this.mTutorialsFlag[n2] ? 1 : 0;
                fileStream.WriteByte((byte)n);
            }
            fileStream.WriteByte((byte)this.mLanguage);
            for (n = 0; n < 10; ++n) {
                fileStream.WriteLong(this.mHighScoreScores[n]);
                fileStream.WriteString(this.mHighScoreNames[n]);
            }
            n = this.mAreHighScoresAllDefaults ? 1 : 0;
            fileStream.WriteByte((byte)n);
            fileStream.WriteByte((byte)this.mLastGameTypePlayed);
            fileStream.Close();
            this.mMustSaveApp = false;
        }
    }
}

