/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.bejeweled;

import ca.jamdat.flight.BitmapMap;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.FlMath;

public class Particle {
    public int mFrameCounter;
    public int mFrictionXDelta;
    public int mFrictionYDelta;
    public short mSize;
    public int mAnimStartTime = -1;
    public BitmapMap mBitmapMap;
    public short mX;
    public short mY;
    public int mAY;
    public int mFrameNb;
    public int mFrameFreq = -1;
    public int mAX;
    public int mVY;
    public int mStartTime = Short.MAX_VALUE;
    public int mVX;
    public int mType = -1;
    public int mFrame = -1;
    public int mLifeSpan;
    public int mFrictionSteps;

    public short GetX() {
        return this.mX;
    }

    public Particle() {
        this.mSize = (short)-1;
    }

    public void destruct() {
    }

    public short GetY() {
        return this.mY;
    }

    public void AddSpeed(int n, int n2) {
        this.mVX += n;
        this.mVY += n2;
        if (this.mFrictionSteps != 0) {
            this.mFrictionXDelta = -this.mVX / this.mFrictionSteps;
            this.mFrictionYDelta = -this.mVY / this.mFrictionSteps;
        }
    }

    public void SetTopLeft(short s, short s2) {
        this.mX = s;
        this.mY = s2;
    }

    public void Init(int n, int n2, BitmapMap bitmapMap) {
        this.mType = n;
        this.mAX = 0;
        this.mVX = 0;
        this.mVY = 0;
        this.mX = 0;
        this.mY = 0;
        this.mStartTime = n2;
        this.mFrameCounter = 0;
        this.mFrictionSteps = 0;
        this.mFrictionXDelta = 0;
        this.mFrictionYDelta = 0;
        this.mAnimStartTime = -1;
        this.mBitmapMap = n == -1 ? null : bitmapMap;
        switch (n) {
            case 0: {
                this.mSize = (short)3;
                this.mLifeSpan = 700;
                this.mAY = 2;
                this.mFrameNb = 4;
                this.mFrame = 0;
                this.mFrameFreq = 100;
                this.mAnimStartTime = 300;
                return;
            }
            case 1: {
                this.mSize = (short)7;
                this.mLifeSpan = FlMath.Random((short)400, (short)800);
                this.mAY = 2;
                this.mFrameNb = 6;
                this.mFrame = 0;
                this.mFrameFreq = 17;
                this.mFrictionSteps = this.mLifeSpan / 30 / 3;
                this.mAnimStartTime = 100;
                return;
            }
            case 3: {
                this.mSize = (short)7;
                this.mLifeSpan = FlMath.Random((short)400, (short)800);
                this.mAY = 2;
                this.mFrameNb = 6;
                this.mFrame = 0;
                this.mFrameFreq = 17;
                this.mFrictionSteps = this.mLifeSpan / 30 / 3;
                this.mAnimStartTime = 100;
                return;
            }
            case -1: {
                this.mSize = (short)-1;
                this.mLifeSpan = 0;
                this.mAY = 0;
                this.mFrame = -1;
            }
        }
    }

    public int GetType() {
        return this.mType;
    }

    public boolean ParticleOnTime(int n, int n2) {
        if (this.mStartTime > 0) {
            this.mStartTime -= n;
            if (this.mStartTime > 0) {
                return true;
            }
        } else if (this.mLifeSpan > 0) {
            if (n2 > 0) {
                while (n2 > 0) {
                    this.mLifeSpan -= 30;
                    if (this.mLifeSpan <= 0) {
                        return true;
                    }
                    n = this.mVX;
                    n = n < 0 ? -(-n >> 3) : (n >>= 3);
                    this.mX = (short)(this.mX + n);
                    this.mY = (short)(this.mY + (this.mVY >> 3));
                    if (this.mFrictionSteps != 0) {
                        --this.mFrictionSteps;
                        this.mVX += this.mFrictionXDelta;
                        this.mVY += this.mFrictionYDelta + this.mAY;
                    } else {
                        this.mVY += this.mAY;
                    }
                    --n2;
                }
            } else {
                this.mLifeSpan -= n;
            }
            if (this.mFrame != -1 && this.mLifeSpan < this.mAnimStartTime) {
                this.mFrameCounter += 30;
                if (this.mFrameCounter >= this.mFrameFreq) {
                    this.mFrameCounter = 0;
                    ++this.mFrame;
                    if (this.mFrame >= this.mFrameNb) {
                        this.mFrame = 0;
                    }
                }
            }
        }
        return this.mLifeSpan > 0;
    }

    public void ParticuleOnDraw(DisplayContext displayContext) {
        int n = 0;
        if (this.mFrame != -1) {
            n = this.mFrame;
        }
        this.mBitmapMap.DrawElementAt(n, displayContext, this.GetX(), this.GetY(), this.mSize, this.mSize, false, false);
    }

    public short GetSize() {
        return this.mSize;
    }

    public static Particle[] InstArrayParticle(int n) {
        Particle[] particleArray = new Particle[n];
        for (int i = 0; i < n; ++i) {
            particleArray[i] = new Particle();
        }
        return particleArray;
    }

    public static Particle[][] InstArrayParticle(int n, int n2) {
        Particle[][] particleArray = new Particle[n][];
        for (int i = 0; i < n; ++i) {
            particleArray[i] = new Particle[n2];
            for (int j = 0; j < n2; ++j) {
                particleArray[i][j] = new Particle();
            }
        }
        return particleArray;
    }

    public static Particle[][][] InstArrayParticle(int n, int n2, int n3) {
        Particle[][][] particleArray = new Particle[n][][];
        for (int i = 0; i < n; ++i) {
            particleArray[i] = new Particle[n2][];
            for (int j = 0; j < n2; ++j) {
                particleArray[i][j] = new Particle[n3];
                for (int k = 0; k < n3; ++k) {
                    particleArray[i][j][k] = new Particle();
                }
            }
        }
        return particleArray;
    }

    public boolean IsVisible() {
        return this.mType != -1 && this.mStartTime <= 0;
    }
}

