/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.JavaBasicFileStream;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Stream;
import ca.jamdat.flight.String;
import ca.jamdat.flight.StringUtils;

public class FileStream
extends Stream {
    public static final byte streamSeekOriginEnd;
    public static final byte fileModeRead;
    public static final short fileBufferDefault;
    public static final byte fileErrorErrorSeeking;
    public static final byte licenseActionConsumePause;
    public byte[] mTmpArray = new byte[4];
    public static final byte fileErrorOutOfMemory;
    public byte mFileMode;
    public static final byte fileModeWrite;
    public static final byte streamSeekOriginStart;
    public static final byte licenseActionConsumeStop;
    public static final byte licenseStateExpired;
    public static final byte fileErrorUnexpectedError;
    public static final byte licenseActionConsumeStart;
    public static final byte licenseStateMimeTypeNotSupported;
    public int mCurrentPos;
    public static final byte licenseStateNotAvailable;
    public String mFileName;
    public boolean mIsCRCValid;
    public static final byte fileErrorReadOnly;
    public static final byte fileErrorNotFound;
    public static final byte fileErrorAccessDenied;
    public int mBufferSize;
    public static final byte fileErrorAlreadyExist;
    public static final byte licenseActionActivate;
    public static final byte fileErrorInActivation;
    public static final byte fileModeAppend;
    public static final byte licenseStateNone;
    public static final byte fileErrorPermissionDenied;
    public int mDataEndPos;
    public static final byte fileErrorNoError;
    public static final byte licenseStateValid;
    public int mNativeFileSize;
    public byte[] mBuffer;
    public static final byte streamSeekOriginCurrent;

    public int GetNativeFileSize() {
        int n;
        if (this.mNativeFileSize < 0 && (n = JavaBasicFileStream.GetFileSize(this.mFileName)) > 0) {
            this.mNativeFileSize = n;
        }
        return this.mNativeFileSize;
    }

    public int GetCRCSize() {
        return 4;
    }

    public void destruct() {
    }

    public int GetHeaderSize() {
        return this.GetCRCSize();
    }

    public byte GetFileErrorState() {
        return 0;
    }

    public byte GetLicenseState() {
        return 0;
    }

    public void ManageLicense(byte by) {
    }

    public FileStream(String string) {
        this(string, 0);
    }

    public FileStream(String string, byte by) {
        this(string, by, 1024);
    }

    public static boolean FileExists(String string) {
        return JavaBasicFileStream.FileExists(string);
    }

    public FileStream(String string, byte by, int n) {
        this(string, by, n, true);
    }

    public void InitReadMode() {
        this.InitReadMode(1024);
    }

    public int GetSize() {
        return this.mNativeFileSize - this.GetHeaderSize();
    }

    public void Skip(int n) {
        this.SetPosition(this.GetPosition() + n);
    }

    public int Read(byte[] byArray, int n) {
        System.arraycopy(this.mBuffer, this.mCurrentPos, byArray, 0, n);
        this.mCurrentPos += n;
        return n;
    }

    public int Write(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.mBuffer, this.mCurrentPos, n);
        this.mCurrentPos += n;
        if (this.mCurrentPos > this.mDataEndPos) {
            this.mDataEndPos = this.mCurrentPos;
            this.mNativeFileSize = this.mCurrentPos;
        }
        return n;
    }

    public boolean IsEndOfFile() {
        return this.mCurrentPos >= this.mDataEndPos;
    }

    public boolean IsOpen() {
        return this.mBuffer != null;
    }

    public short ReadShort() {
        this.mCurrentPos += 2;
        return (short)(((this.mBuffer[this.mCurrentPos] & 0xFF) << 8) + (this.mBuffer[this.mCurrentPos + 1] & 0xFF));
    }

    public String ReadString() {
        short s = this.ReadShort();
        byte[] byArray = new byte[s + 1];
        if (s != 0) {
            this.Read(byArray, s * 1);
        }
        byArray[s] = 0;
        return new String(byArray);
    }

    public void WriteByte(byte by) {
        this.mTmpArray[0] = by;
        this.Write(this.mTmpArray, 1);
    }

    public void WriteShort(short s) {
        this.mTmpArray[0] = (byte)(0xFF & s >> 8);
        this.mTmpArray[1] = (byte)(0xFF & s);
        this.Write(this.mTmpArray, 2);
    }

    public void WriteLong(int n) {
        byte[] byArray = this.mTmpArray;
        byArray[0] = (byte)(0xFF & n >> 24);
        byArray[1] = (byte)(0xFF & n >> 16);
        byArray[2] = (byte)(0xFF & n >> 8);
        byArray[3] = (byte)(0xFF & n);
        this.Write(byArray, 4);
    }

    public void WriteString(String string) {
        string.Write(this);
    }

    public int GetPosition() {
        return this.mCurrentPos - this.GetHeaderSize();
    }

    public void SetPosition(int n) {
        this.mCurrentPos = this.GetHeaderSize() + n;
    }

    public boolean IsValid() {
        return this.mIsCRCValid;
    }

    public void Close() {
        if (this.mFileMode != 0) {
            this.AssignCRC();
            JavaBasicFileStream.WriteFile(this.mFileName, this.mBuffer, this.mDataEndPos, this.mFileMode);
        }
        this.mBuffer = null;
        this.mFileName = null;
    }

    public void WriteText(String string) {
        string.Write(this, false);
    }

    public byte ReadByte() {
        int n;
        int n2 = this.mCurrentPos;
        this.mCurrentPos = n = n2 + 1;
        return this.mBuffer[n2];
    }

    public int ReadLong() {
        byte[] byArray = this.mBuffer;
        int n = this.mCurrentPos;
        this.mCurrentPos += 4;
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public static boolean IsSpaceAvailable(int n) {
        return JavaBasicFileStream.GetAvailableSpace(n);
    }

    public static boolean IsSpaceAvailable(int n, int n2) {
        return JavaBasicFileStream.GetAvailableSpace(n, n2);
    }

    public static boolean FileDelete(String string) {
        return JavaBasicFileStream.FileDelete(string);
    }

    public FileStream(String string, byte by, int n, boolean bl) {
        this.mFileMode = by;
        this.mNativeFileSize = -1;
        this.mFileName = new String(string);
        switch (this.mFileMode) {
            case 0: {
                this.InitReadMode(n);
                return;
            }
            case 1: 
            case 2: {
                int n2 = this.GetHeaderSize();
                this.mBufferSize = n + n2;
                this.mBuffer = new byte[this.mBufferSize];
                this.mNativeFileSize = n2;
                this.mCurrentPos = n2;
                this.mDataEndPos = n2;
                this.mIsCRCValid = true;
            }
        }
    }

    public boolean CanRead() {
        return this.mFileMode == 0;
    }

    public boolean CanWrite() {
        return this.mFileMode != 0;
    }

    public String ReadLine() {
        byte[] byArray = new byte[2048];
        int n = 0;
        byte by = this.ReadByte();
        if (by != 10) {
            while (!this.IsEndOfFile() && n < 2046) {
                byte by2 = this.ReadByte();
                if (by2 == 10) {
                    if (by != 13) {
                        byArray[n++] = by;
                    }
                    byArray[n] = 0;
                    return StringUtils.CreateString(byArray);
                }
                byArray[n++] = by;
                by = by2;
            }
            byArray[n++] = by;
        }
        byArray[n] = 0;
        return StringUtils.CreateString(byArray);
    }

    public void InitReadMode(int n) {
        this.GetNativeFileSize();
        this.mBufferSize = this.mNativeFileSize;
        if (this.mBufferSize > 0) {
            this.mBuffer = new byte[this.mBufferSize];
        }
        if (this.mBuffer == null || this.RefreshBuffer(0) == -1) {
            this.mIsCRCValid = false;
            return;
        }
        this.mIsCRCValid = this.VerifyCRC();
    }

    public boolean VerifyCRC() {
        if (this.mNativeFileSize > this.GetHeaderSize()) {
            this.mCurrentPos = 0;
            this.mCurrentPos = this.GetHeaderSize();
            return (int)Memory.CalculateCRC(this.mBuffer, this.GetHeaderSize(), this.mDataEndPos - this.GetHeaderSize()) == this.ReadLong();
        }
        return false;
    }

    public void AssignCRC() {
        this.mCurrentPos = 0;
        this.WriteLong((int)Memory.CalculateCRC(this.mBuffer, this.GetHeaderSize(), this.mDataEndPos - this.GetHeaderSize()));
    }

    public int RefreshBuffer(int n) {
        this.mBuffer = JavaBasicFileStream.ReadFile(this.mFileName);
        if (this.mBuffer == null) {
            return -1;
        }
        this.mNativeFileSize = this.mBufferSize = this.mBuffer.length;
        this.mDataEndPos = n = this.mBufferSize;
        this.mCurrentPos = this.GetHeaderSize();
        return n;
    }
}

