/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Alignment;
import ca.jamdat.flight.Application;
import ca.jamdat.flight.Bitmap;
import ca.jamdat.flight.Color888;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.Font;
import ca.jamdat.flight.ForceInline;
import ca.jamdat.flight.MIDPDisplayContextImp;
import ca.jamdat.flight.String;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.VideoMode;

public abstract class DisplayContext {
    public short mClipRect_top;
    public boolean mInvertedLandscape;
    public FlRect mScreenRect;
    public boolean mBypassClipping;
    public static final byte resolutionInvalid;
    public short mClipRect_height;
    public short mClipRect_width;
    public VideoMode mVideoMode;
    public short mCumulativeOffsetX;
    public short mClipRect_left;
    public short mCumulativeOffsetY;
    public static final byte resolutionLandscape;
    public static final byte resolutionCount;
    public static final byte resolutionPortrait;

    public void DrawBitmapSection(Bitmap bitmap, short s, short s2, short s3, short s4, short s5, short s6) {
        s = (short)(s + this.mCumulativeOffsetX);
        s2 = (short)(s2 + this.mCumulativeOffsetY);
        short s7 = s;
        short s8 = s2;
        short s9 = s5;
        short s10 = s6;
        if (!this.mBypassClipping) {
            s10 = this.mClipRect_left;
            s9 = this.mClipRect_top;
            int n = s10 + this.mClipRect_width;
            s5 = (short)(s + s5);
            int n2 = s9 + this.mClipRect_height;
            s6 = (short)(s2 + s6);
            if (s10 > s) {
                s7 = s10;
            }
            if (s9 > s2) {
                s8 = s9;
            }
            if (n < s5) {
                s5 = (short)n;
            }
            if (n2 < s6) {
                s6 = (short)n2;
            }
            s9 = (short)(s5 - s7);
            s10 = (short)(s6 - s8);
        }
        if (s9 <= 0 || s10 <= 0) {
            return;
        }
        this.DrawAbsoluteBitmapSection(bitmap, s7, s8, s3 + (s7 - s), s4 + (s8 - s2), s9, s10, (byte)0);
    }

    public void DrawTiledBitmapSection(Bitmap bitmap, short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, short s10, short s11, short s12) {
        int n;
        int n2 = this.mCumulativeOffsetX;
        int n3 = this.mCumulativeOffsetY;
        int n4 = s9 + n2;
        int n5 = s10 + n3;
        int n6 = this.mClipRect_left + this.mClipRect_width;
        s11 = (short)(n4 + s11);
        int n7 = this.mClipRect_top + this.mClipRect_height;
        s12 = (short)(n5 + s12);
        if (this.mClipRect_left > n4) {
            n4 = this.mClipRect_left;
        }
        if (this.mClipRect_top > n5) {
            n5 = this.mClipRect_top;
        }
        if (n6 < s11) {
            s11 = (short)n6;
        }
        if (n7 < s12) {
            s12 = (short)n7;
        }
        n7 = (short)(s11 - n4);
        n6 = (short)(s12 - n5);
        if (n7 <= 0 || n6 <= 0) {
            return;
        }
        int n8 = n4 - n2;
        int n9 = n8 + n7;
        int n10 = n + n6;
        for (n = n5 - n3; n < n10; n += n6) {
            n7 = (n - s10) % s2;
            int n11 = FlMath.Minimum((int)s2, n10 - n + n7);
            n6 = n11 - n7;
            n5 = FlMath.Maximum(0, s4 - n7);
            n7 = FlMath.Maximum(0, n7 - s4);
            n4 = FlMath.Maximum(0, FlMath.Minimum((int)s8, n11 - s4) - n7);
            for (n3 = n8; n3 < n9; n3 += s12) {
                n2 = (n3 - s9) % s;
                int n12 = FlMath.Minimum((int)s, n9 - n3 + n2);
                s12 = (short)(n12 - n2);
                s11 = (short)FlMath.Maximum(0, s3 - n2);
                n2 = FlMath.Maximum(0, n2 - s3);
                this.mBypassClipping = true;
                short s13 = (short)FlMath.Maximum(0, FlMath.Minimum((int)s7, n12 - s3) - n2);
                this.DrawBitmapSection(bitmap, (short)(n3 + s11), (short)(n + n5), (short)(s5 + n2), (short)(s6 + n7), s13, (short)n4);
            }
        }
        this.mBypassClipping = false;
    }

    public void destruct() {
    }

    public void DrawTiledBitmapSection(Bitmap bitmap, short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8) {
        this.DrawTiledBitmapSection(bitmap, s3, s4, (short)0, (short)0, s, s2, s3, s4, s5, s6, s7, s8);
    }

    public void DrawAbsoluteBitmap(Bitmap bitmap, int n, int n2) {
        this.ResetClip();
        this.DrawAbsoluteBitmapBypassClipping(bitmap, n, n2);
    }

    public boolean ApplicationIsPortrait() {
        return this.IsResolution(false, (byte)0);
    }

    public boolean ApplicationIsLandscape() {
        return this.IsResolution(false, (byte)1);
    }

    public boolean DeviceIsPortrait() {
        return this.IsResolution(true, (byte)0);
    }

    public boolean DeviceIsLandscape() {
        return this.IsResolution(true, (byte)1);
    }

    public boolean IsResolution(boolean bl, byte by) {
        return this.GetResolution(bl) == by;
    }

    public byte GetResolution(boolean n) {
        int n2;
        VideoMode videoMode = this.GetVideoMode();
        n = videoMode.GetWidth();
        if (n <= (n2 = videoMode.GetHeight())) {
            return 0;
        }
        return 1;
    }

    public short GetClippingRectLeft() {
        return (short)(this.GetAbsoluteClippingRectLeft() - this.GetCumulativeOffsetX());
    }

    public short GetClippingRectTop() {
        return (short)(this.GetAbsoluteClippingRectTop() - this.GetCumulativeOffsetY());
    }

    public short GetClippingRectWidth() {
        return this.GetAbsoluteClippingRectWidth();
    }

    public short GetClippingRectHeight() {
        return this.GetAbsoluteClippingRectHeight();
    }

    public void SetClippingRect(short s, short s2, short s3, short s4) {
        this.SetAbsoluteClippingRect((short)(s + this.GetCumulativeOffsetX()), (short)(s2 + this.GetCumulativeOffsetY()), s3, s4);
    }

    public short GetAbsoluteClippingRectTop() {
        return this.mClipRect_top;
    }

    public short GetAbsoluteClippingRectLeft() {
        return this.mClipRect_left;
    }

    public short GetAbsoluteClippingRectWidth() {
        return this.mClipRect_width;
    }

    public short GetAbsoluteClippingRectHeight() {
        return this.mClipRect_height;
    }

    public void SetAbsoluteClippingRect(short s, short s2, short s3, short s4) {
        this.mClipRect_left = s;
        this.mClipRect_top = s2;
        this.mClipRect_width = s3;
        this.mClipRect_height = s4;
    }

    public void BeginScene() {
    }

    public void EndScene() {
    }

    public short GetCumulativeOffsetX() {
        return this.mCumulativeOffsetX;
    }

    public short GetCumulativeOffsetY() {
        return this.mCumulativeOffsetY;
    }

    public void SetVideoMode(VideoMode videoMode) {
        this.mVideoMode = videoMode;
    }

    public FlRect GetScreenRect() {
        return this.mScreenRect;
    }

    public boolean InvertedLandscape() {
        return this.mInvertedLandscape;
    }

    public void SetInvertedLandscape(boolean bl) {
        this.mInvertedLandscape = bl;
    }

    public void EnableCoverageCheck(boolean bl) {
    }

    public static DisplayContext CreateContext(VideoMode videoMode) {
        return new MIDPDisplayContextImp(videoMode);
    }

    public abstract void Clear(Color888 var1);

    public abstract void ClearFullscreen(Color888 var1);

    public void ResetClip() {
    }

    public void DrawAbsoluteBitmapBypassClipping(Bitmap bitmap, int n, int n2) {
        this.DrawBitmapSection(bitmap, (short)(n - this.mCumulativeOffsetX), (short)(n2 - this.mCumulativeOffsetY), (short)0, (short)0, bitmap.GetWidth(), bitmap.GetHeight());
    }

    public abstract void DrawAbsoluteBitmapSection(Bitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, byte var8);

    public abstract void DrawArc(Vector2_short var1, short var2, short var3, short var4);

    public abstract void DrawCircle(Vector2_short var1, short var2, boolean var3, Color888 var4, Color888 var5);

    public abstract void DrawFrame(short var1, short var2, short var3, short var4, Color888 var5);

    public abstract void DrawLine(short var1, short var2, short var3, short var4, Color888 var5);

    public abstract void DrawPixel(short var1, short var2, Color888 var3);

    public void DrawAbsoluteSolidRectangle(short s, short s2, short s3, short s4, int n, int n2, int n3) {
        this.DrawRectangle((short)(s - this.mCumulativeOffsetX), (short)(s2 - this.mCumulativeOffsetY), s3, s4, true, n, n2, n3);
    }

    public abstract void DrawRectangle(short var1, short var2, short var3, short var4, boolean var5, int var6, int var7, int var8);

    public DisplayContext(VideoMode videoMode) {
        this.mVideoMode = new VideoMode(videoMode);
        this.mScreenRect = new FlRect(0, 0, (short)videoMode.GetWidth(), (short)videoMode.GetHeight());
    }

    public void RenderApplication() {
        this.BeginScene();
        Application.GetInstance().OnDraw(this);
        this.EndScene();
        Application.GetInstance().SetDirty(false);
    }

    public VideoMode GetVideoMode() {
        return this.mVideoMode;
    }

    public void UpdateOrientation(VideoMode videoMode) {
        this.mScreenRect.Assign(new FlRect(0, 0, (short)videoMode.GetWidth(), (short)videoMode.GetHeight()));
        this.mVideoMode = videoMode;
    }

    public abstract byte GetDisplayAPI();

    public void OffsetBy(short s, short s2) {
        ForceInline.v();
        this.mCumulativeOffsetX = (short)(this.mCumulativeOffsetX + s);
        this.mCumulativeOffsetY = (short)(this.mCumulativeOffsetY + s2);
    }

    public void DrawString(String string, short s, short s2, short s3, short s4, Font font, byte by, int n, int n2, short s5) {
        if (string.GetCharAt(n) == 0) {
            return;
        }
        short s6 = this.mClipRect_left;
        short s7 = this.mClipRect_top;
        short s8 = this.mClipRect_width;
        short s9 = this.mClipRect_height;
        short s10 = (short)(s + this.mCumulativeOffsetX);
        short s11 = (short)(s2 + this.mCumulativeOffsetY);
        if (FlRect.Contains(s6, s7, s8, s9, s10, s11, s3, s4)) {
            this.mBypassClipping = true;
        } else if (!FlRect.Intersects(s6, s7, s8, s9, s10, s11, s3, s4)) {
            return;
        }
        font.DrawString(this, string, (short)(s + Alignment.GetOffsetX(by, s3, s5)), s2, s5, n, n2);
        this.mBypassClipping = false;
    }

    public void DrawMultilineString(String string, int[] nArray, int n, short s, short s2, short s3, short s4, int n2, Font font, byte by, short[] sArray) {
        if (font == null) {
            return;
        }
        int n3 = font.GetLineHeight();
        int n4 = n3 - font.GetLeading();
        int n5 = s + this.mCumulativeOffsetX;
        int n6 = this.mCumulativeOffsetY;
        int n7 = s2 + n6;
        n5 = n5 >= this.mClipRect_left && (short)(n5 + s3 - 1) <= (short)(this.mClipRect_left + this.mClipRect_width - 1) ? 1 : 0;
        int n8 = n5;
        int n9 = this.mClipRect_top + this.mClipRect_height - 1;
        s4 = (short)(n7 + s4 - 1);
        int n10 = this.mClipRect_top - n7;
        int n11 = n2;
        n5 = n7;
        if (n10 > 0) {
            n5 = n7 + n10;
            if (n10 > n4) {
                n11 = n2 + 1 + (n10 - n4) / n3;
                n4 = n3;
            }
        }
        if (n11 > n - 1) {
            return;
        }
        n10 = s4;
        if (s4 > n9) {
            n10 = n9;
        }
        n9 = (n11 - n2) * n3;
        n2 = (short)(n7 - this.mCumulativeOffsetY + n9);
        n7 = n5 - n6;
        n6 = n10 - n6;
        n5 = n11;
        n11 = s2 + n9;
        n10 = n11 + n4;
        do {
            n11 = n8 != 0 && n11 >= n7 && n10 - 1 <= n6 ? 1 : 0;
            this.mBypassClipping = n11;
            n11 = nArray[n5] & 0xFFFF;
            n9 = (nArray[n5] >> 16) - n11 + 1;
            font.DrawString(this, string, (short)(s + Alignment.GetOffsetX(by, s3, sArray[n5])), (short)n2, sArray[n5], n11, n9);
            n2 = (short)(n2 + n3);
            n11 = n10;
            n10 += n3;
        } while (++n5 < n && n11 <= n6);
        this.mBypassClipping = false;
    }
}

