/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.MMAPISoundManagerImp;
import ca.jamdat.flight.SoundPlayer;

public class SoundManager {
    public short mMasterVolume = (short)255;
    public boolean mIsPauseSoundsOnInterrupt;
    public boolean mIsMuted;
    public MMAPISoundManagerImp mImplementor = new MMAPISoundManagerImp();
    public short mScaledMasterVolume = this.CalculateScaledMasterVolume();
    public SoundPlayer[] mChannels = null;

    public SoundManager() {
        FrameworkGlobals.GetInstance().soundManager = this;
        this.mChannels = SoundPlayer.InstArraySoundPlayer(1);
    }

    public void destruct() {
        this.mChannels = null;
    }

    public static SoundManager Get() {
        if (FrameworkGlobals.GetInstance().soundManager == null) {
            FrameworkGlobals.GetInstance().soundManager = new SoundManager();
        }
        return FrameworkGlobals.GetInstance().soundManager;
    }

    public SoundPlayer GetChannelSoundPlayer(int n) {
        return this.mChannels[n];
    }

    public void SetMuted(boolean bl) {
        this.mImplementor.SetMuted(bl);
    }

    public boolean IsMuted() {
        return this.mImplementor.IsMuted();
    }

    public void SetPauseSoundsOnInterrupt() {
        this.mIsPauseSoundsOnInterrupt = true;
    }

    public boolean IsPauseSoundsOnInterrupt() {
        return this.mIsPauseSoundsOnInterrupt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void PauseAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            int n = 0;
            while (n < 1) {
                this.mChannels[n].Pause();
                ++n;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ResumeAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            int n = 0;
            while (n < 1) {
                if (this.mChannels[n].IsPaused()) {
                    this.mChannels[n].Play();
                }
                ++n;
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void StopAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            int n = 0;
            while (n < 1) {
                this.mChannels[n].Stop();
                ++n;
            }
            return;
        }
    }

    public void SetMasterVolume(short s) {
        if (s > 255) {
            s = (short)255;
        }
        if (s < 0) {
            s = 0;
        }
        this.mMasterVolume = s;
        this.mScaledMasterVolume = this.CalculateScaledMasterVolume();
        for (int i = 0; i < 1; ++i) {
            this.mChannels[i].SetNativeVolume();
        }
        FrameworkGlobals.GetInstance().application.OnMasterVolumeChange(s);
    }

    public short GetMasterVolume() {
        return this.mMasterVolume;
    }

    public short GetScaledMasterVolume() {
        return this.mScaledMasterVolume;
    }

    public static void IncMasterVolume() {
        SoundManager soundManager = FrameworkGlobals.GetInstance().soundManager;
        soundManager.SetMasterVolume((short)(soundManager.mMasterVolume + 51));
    }

    public static void DecMasterVolume() {
        SoundManager soundManager = FrameworkGlobals.GetInstance().soundManager;
        soundManager.SetMasterVolume((short)(soundManager.mMasterVolume - 51));
    }

    public static int CalculateNativePlayerVolume(short s, int n) {
        return n * s * FrameworkGlobals.GetInstance().soundManager.GetScaledMasterVolume() >> 16;
    }

    public short CalculateScaledMasterVolume() {
        return this.mMasterVolume;
    }

    public static int CalculateNativePlayerVolume(short s) {
        return SoundManager.CalculateNativePlayerVolume(s, 100);
    }

    public static SoundManager[] InstArraySoundManager(int n) {
        SoundManager[] soundManagerArray = new SoundManager[n];
        for (int i = 0; i < n; ++i) {
            soundManagerArray[i] = new SoundManager();
        }
        return soundManagerArray;
    }

    public static SoundManager[][] InstArraySoundManager(int n, int n2) {
        SoundManager[][] soundManagerArray = new SoundManager[n][];
        for (int i = 0; i < n; ++i) {
            soundManagerArray[i] = new SoundManager[n2];
            for (int j = 0; j < n2; ++j) {
                soundManagerArray[i][j] = new SoundManager();
            }
        }
        return soundManagerArray;
    }

    public static SoundManager[][][] InstArraySoundManager(int n, int n2, int n3) {
        SoundManager[][][] soundManagerArray = new SoundManager[n][][];
        for (int i = 0; i < n; ++i) {
            soundManagerArray[i] = new SoundManager[n2][];
            for (int j = 0; j < n2; ++j) {
                soundManagerArray[i][j] = new SoundManager[n3];
                for (int k = 0; k < n3; ++k) {
                    soundManagerArray[i][j][k] = new SoundManager();
                }
            }
        }
        return soundManagerArray;
    }
}

