/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.Stream;
import ca.jamdat.flight.String;
import ca.jamdat.flight.StringUtils;
import java.io.IOException;
import java.io.InputStream;

public class LibraryStream
extends Stream {
    public int mError;
    public InputStream mInputStream;
    public int mPositionInSegment;
    public static final byte kSizeOfReadShort;
    public static final byte kSizeOfReadInt;
    public int mSegmentSize;
    public int mSizeOfCurrentSegment;
    public int mCurrentSegment;
    public static final byte kEofValue;
    public int mLibrarySize;
    public int mCurrentDecompressionSegIndex;
    public static final byte kSizeOfReadChar;
    public String mFileName;
    public byte[] mBuffer = new byte[4];
    public static final byte kSizeOfReadByte;

    public void destruct() {
        this.Close();
    }

    public static boolean FileExists(String object) {
        boolean bl;
        object = System.out.getClass().getResourceAsStream(StringUtils.CreateJavaString((String)object));
        if (object == null) {
            bl = false;
        } else {
            bl = true;
            try {
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public int Read(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2;
        n += n2;
        do {
            if ((n3 = this.mSizeOfCurrentSegment - this.mPositionInSegment) <= 0) {
                this.CloseSegment();
                ++this.mCurrentSegment;
                this.OpenSegment(this.mCurrentSegment);
                n3 = this.mSizeOfCurrentSegment;
            }
            n3 = FlMath.Minimum(n4, n3);
            try {
                int n5 = 0;
                while ((n5 += this.mInputStream.read(byArray, n - n4 + n5, n3 - n5)) != n3) {
                    if (n5 >= 0) continue;
                    throw new IOException();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPositionInSegment += n3;
        } while ((n4 -= n3) > 0);
        return n2;
    }

    public static int ReadLong(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public byte ReadChar() {
        return this.ReadByte();
    }

    public void Skip(int n) {
        this.SetPosition(this.GetPosition() + n);
    }

    public int Read(byte[] byArray, int n) {
        return this.Read(byArray, this.GetPosition(), n);
    }

    public int Write(byte[] byArray, int n) {
        return 0;
    }

    public short ReadShort() {
        byte[] byArray = this.mBuffer;
        this.Read(byArray, 0, 2);
        return (short)(byArray[0] << 8 | byArray[1] & 0xFF);
    }

    public int GetSize() {
        return this.mLibrarySize;
    }

    public boolean IsEndOfFile() {
        return this.GetPosition() == this.GetSize();
    }

    public boolean IsOpen() {
        return this.mInputStream != null;
    }

    public int GetLastError() {
        return this.mError;
    }

    public void Create(String string) {
        this.mFileName.Assign(String.FromChar((byte)47).Add(string).Add(String.FromChar((byte)46)));
        this.OpenSegment(0);
        if (this.IsOpen()) {
            this.mSizeOfCurrentSegment = this.mLibrarySize = 4096;
            int n = this.ReadLong();
            int n2 = this.ReadLong();
            this.mPositionInSegment += 8;
            if (n == 0 || n2 < n) {
                n = n2;
            }
            this.mSizeOfCurrentSegment = n;
            this.mLibrarySize = n2;
            this.mSegmentSize = n;
            this.SetPosition(0);
        }
    }

    public void CloseSegment() {
        try {
            this.mInputStream.close();
        }
        catch (Exception exception) {
            this.mError = 1;
            exception.printStackTrace();
        }
        this.mInputStream = null;
    }

    public void OpenSegment(int n) {
        int n2 = this.mSegmentSize;
        if (n2 > 0) {
            int n3 = this.mLibrarySize / n2;
            n3 = n < n3 ? n2 : this.mLibrarySize - n3 * n2;
            this.mSizeOfCurrentSegment = n3;
        }
        this.mPositionInSegment = 0;
        InputStream inputStream = this.GetInputStreamOnSegment(n);
        if (inputStream == null) {
            this.mInputStream = null;
            this.mError = 1;
            return;
        }
        this.mInputStream = inputStream;
        this.mError = 0;
    }

    public InputStream GetInputStreamOnSegment(int n) {
        java.lang.String string = StringUtils.CreateJavaString(this.mFileName.Add(new String(n)));
        return System.out.getClass().getResourceAsStream(string);
    }

    public int GetPosition() {
        return this.mPositionInSegment + this.mCurrentSegment * this.mSegmentSize;
    }

    public void SetPosition(int n) {
        int n2;
        int n3 = this.GetSize();
        int n4 = this.mSegmentSize;
        if (n >= n3) {
            n2 = (n3 - 1) / n4;
            n = n3 - n2 * n4;
        } else {
            n2 = n / n4;
            n %= n4;
        }
        if (n2 == this.mCurrentSegment && n >= this.mPositionInSegment) {
            n -= this.mPositionInSegment;
        } else {
            this.mCurrentSegment = n2;
            this.CloseSegment();
            this.OpenSegment(this.mCurrentSegment);
        }
        n3 = -1;
        try {
            for (n4 = 0; n4 < n && n3 != 0; n4 += n3) {
                n3 = (int)this.mInputStream.skip(n - n4);
            }
        }
        catch (Exception exception) {
            this.mError = 1;
            exception.printStackTrace();
        }
        this.mPositionInSegment += n4;
    }

    public boolean IsValid() {
        return this.mInputStream != null;
    }

    public void Close() {
        this.CloseSegment();
    }

    public byte ReadByte() {
        if (this.mPositionInSegment >= this.mSizeOfCurrentSegment) {
            this.CloseSegment();
            ++this.mCurrentSegment;
            this.OpenSegment(this.mCurrentSegment);
        }
        byte[] byArray = this.mBuffer;
        try {
            int n;
            while ((n = this.mInputStream.read(byArray, 0, 1)) < 1) {
                if (n >= 0) continue;
                throw new IOException();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.mPositionInSegment;
        return byArray[0];
    }

    public int ReadLong() {
        byte[] byArray = this.mBuffer;
        this.Read(byArray, 0, 4);
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public LibraryStream(String string) {
        this.mFileName = new String();
        this.Create(string);
    }
}

