/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Color888;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.FQuaternionT_F32;
import ca.jamdat.flight.FVec3T_F32;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.Vector2_short;

public abstract class Controller
extends TimeControlled {
    public byte mAbsolute;
    public static final byte ValueTypeCoord2;
    public static final byte ValueTypeColor;
    public static final byte ValueTypeQuaternion;
    public byte mStartState;
    public byte mCacheState;
    public static final byte typeID;
    public static final byte ValueTypeNone;
    public TimeControlled mControllee;
    public int[] mValueBuffer = new int[12];
    public static final byte ValueTypeInt;
    public static final byte ValueTypeBool;
    public static final byte relative;
    public static final byte ValueTypeFloat;
    public static final boolean supportsDynamicSerialization;
    public int mControlledValueCode;
    public static final byte absolute;
    public static final byte initialized;
    public static final byte uninitialized;
    public static final byte typeNumber;
    public static final byte ValueTypeRect;
    public static final byte ValueTypeVec3;

    public void destruct() {
        this.mControllee = null;
    }

    public static Controller Cast(Object object, Controller controller) {
        return (Controller)object;
    }

    public Vector2_short GetCoord2Value() {
        return new Vector2_short(this.GetCoord2ValueX(), this.GetCoord2ValueY());
    }

    public short GetCoord2ValueX() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return (short)(nArray[0] + nArray[4]);
        }
        return (short)nArray[0];
    }

    public short GetCoord2ValueY() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return (short)(nArray[1] + nArray[5]);
        }
        return (short)nArray[1];
    }

    public int GetLongValue() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return nArray[0] + nArray[4];
        }
        return nArray[0];
    }

    public boolean GetBoolValue() {
        return (this.GetLongValue() & 1) != 0;
    }

    public FlRect GetRectValue() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return new FlRect((short)(nArray[0] + nArray[4]), (short)(nArray[1] + nArray[5]), (short)(nArray[2] + nArray[6]), (short)(nArray[3] + nArray[7]));
        }
        return new FlRect((short)nArray[0], (short)nArray[1], (short)nArray[2], (short)nArray[3]);
    }

    public Color888 GetColorValue() {
        int[] nArray = this.mValueBuffer;
        Color888 color888 = new Color888();
        if (this.mAbsolute != 0) {
            color888.SetRed(Memory.MakeUnsignedByte((byte)(nArray[0] + nArray[4])));
            color888.SetGreen(Memory.MakeUnsignedByte((byte)(nArray[1] + nArray[5])));
            color888.SetBlue(Memory.MakeUnsignedByte((byte)(nArray[2] + nArray[6])));
        } else {
            color888.SetRed(Memory.MakeUnsignedByte((byte)nArray[0]));
            color888.SetGreen(Memory.MakeUnsignedByte((byte)nArray[1]));
            color888.SetBlue(Memory.MakeUnsignedByte((byte)nArray[2]));
        }
        return color888;
    }

    public FVec3T_F32 GetFVec3Value() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return new FVec3T_F32(new F32(nArray[0] + nArray[4], 16), new F32(nArray[1] + nArray[5], 16), new F32(nArray[2] + nArray[6], 16));
        }
        return new FVec3T_F32(new F32(nArray[0], 16), new F32(nArray[1], 16), new F32(nArray[2], 16));
    }

    public FQuaternionT_F32 GetFQuaternionValue() {
        int[] nArray = this.mValueBuffer;
        F32 f32 = new F32(nArray[0], 28);
        FQuaternionT_F32 fQuaternionT_F32 = new FQuaternionT_F32(f32, new FVec3T_F32(new F32(nArray[1], 28), new F32(nArray[2], 28), new F32(nArray[3], 28)));
        if (this.mAbsolute != 0) {
            f32 = new F32(nArray[4], 28);
            fQuaternionT_F32.Assign(new FQuaternionT_F32(f32, new FVec3T_F32(new F32(nArray[5], 28), new F32(nArray[6], 28), new F32(nArray[7], 28))).Mul(fQuaternionT_F32));
        }
        return fQuaternionT_F32;
    }

    public F32 GetF32Value() {
        int[] nArray = this.mValueBuffer;
        if (this.mAbsolute != 0) {
            return new F32(nArray[0] + nArray[4], 16);
        }
        return new F32(nArray[0], 16);
    }

    public void SetValue(short s, short s2) {
        this.mValueBuffer[4] = s;
        this.mValueBuffer[5] = s2;
    }

    public void SetValue(short s, short s2, short s3, short s4) {
        Object object = ((Controller)object).mValueBuffer;
        object[4] = s;
        object[5] = s2;
        object[6] = s3;
        object[7] = s4;
    }

    public void SetValue(Color888 color888) {
        Object object = ((Controller)object).mValueBuffer;
        object[4] = color888.GetRed();
        object[5] = color888.GetGreen();
        object[6] = color888.GetBlue();
    }

    public void SetValue(boolean bl) {
        Object object = ((Controller)object).mValueBuffer;
        bl = bl;
        object[4] = bl;
    }

    public void SetValue(int n) {
        this.mValueBuffer[4] = n;
    }

    public void SetValue(FVec3T_F32 fVec3T_F32) {
        Object object = ((Controller)object).mValueBuffer;
        object[4] = fVec3T_F32.x.ToFixedPoint(16);
        object[5] = fVec3T_F32.y.ToFixedPoint(16);
        object[6] = fVec3T_F32.z.ToFixedPoint(16);
    }

    public void SetValue(FQuaternionT_F32 fQuaternionT_F32) {
        Object object = ((Controller)object).mValueBuffer;
        object[4] = fQuaternionT_F32.GetS().ToFixedPoint(28);
        object[5] = fQuaternionT_F32.GetVx().ToFixedPoint(28);
        object[6] = fQuaternionT_F32.GetVy().ToFixedPoint(28);
        object[7] = fQuaternionT_F32.GetVz().ToFixedPoint(28);
    }

    public void SetValue(F32 f32) {
        this.mValueBuffer[4] = f32.ToFixedPoint(16);
    }

    public void GetControlledValue(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.mValueBuffer[i];
            if (this.mAbsolute == 0) continue;
            nArray[i] = nArray[i] + this.mValueBuffer[4 + i];
        }
    }

    public void SetRequestedValue(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            this.mValueBuffer[4 + i] = nArray[i];
        }
    }

    public void Restore() {
        if (this.mStartState != 0) {
            this.CopyValue(0, 4);
            this.mAbsolute = 0;
            this.mControllee.ControlValue(this.mControlledValueCode, true, this);
            this.mAbsolute = this.mAbsolute;
        }
        this.Refresh();
    }

    public void Refresh() {
        this.mCacheState = 0;
    }

    public abstract void OnTime(int var1, int var2);

    public void SetControlParameters(TimeControlled timeControlled, int n) {
        this.mControllee = timeControlled;
        this.mControlledValueCode = n;
        this.mStartState = 0;
        this.mCacheState = 0;
    }

    public void SetControllee(TimeControlled timeControlled) {
        this.SetControlParameters(timeControlled, this.mControlledValueCode);
    }

    public void SetControlledValueCode(int n) {
        this.SetControlParameters(this.mControllee, n);
    }

    public TimeControlled GetControllee() {
        return this.mControllee;
    }

    public boolean IsAbsolute() {
        return this.mAbsolute == 0;
    }

    public void SetIsAbsolute(boolean bl) {
        boolean bl2 = this.mAbsolute == 0;
        if (bl != bl2) {
            bl2 = !bl;
            this.mAbsolute = (byte)(bl2 ? 1 : 0);
            this.mStartState = 0;
        }
    }

    public void ResetControllee() {
        this.mStartState = 0;
    }

    public void OnSerialize(Package package_) {
        this.mControllee = TimeControlled.Cast(package_.SerializePointer((byte)-1, true, false), null);
        this.mControlledValueCode = package_.SerializeIntrinsic(this.mControlledValueCode);
        this.SetIsAbsolute(package_.SerializeIntrinsic(this.IsAbsolute()));
    }

    public void DefaultOnTime(int n, int n2) {
        if (this.mControllee == null) {
            return;
        }
        if (this.mStartState == 0) {
            this.GetCurrentValue();
            this.mStartState = 1;
        }
        if (this.NeedsUpdate()) {
            this.mControllee.ControlValue(this.mControlledValueCode, true, this);
            this.UpdateCache();
        }
    }

    public void GetCurrentValue() {
        this.mControllee.ControlValue(this.mControlledValueCode, false, this);
    }

    public byte GetTypeID() {
        return 87;
    }

    public static Class AsClass() {
        return null;
    }

    public boolean NeedsUpdate() {
        if (this.mCacheState == 0) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.mValueBuffer[8 + i] == this.mValueBuffer[i]) continue;
            return true;
        }
        return false;
    }

    public void UpdateCache() {
        this.CopyValue(8, 0);
        this.mCacheState = 1;
    }

    public void CopyValue(int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            this.mValueBuffer[n + i] = this.mValueBuffer[n2 + i];
        }
    }
}

