/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Component;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Scroller;
import ca.jamdat.flight.Selection;

public class Selector
extends Scroller {
    public int mCurrentSelectionIndex = -1;
    public static final byte FlagTakeFocus;
    public static final boolean supportsDynamicSerialization;
    public int mLastUpdatedSelectionIndex;
    public static final byte FlagLooping;
    public static final byte typeID;
    public static final byte FlagSkipDisabled;
    public byte mFlags;
    public static final byte typeNumber;

    public void SetSingleSelection(int n, boolean bl, boolean bl2) {
        this.SetSingleSelection(n, bl, bl2, true);
    }

    public Selector() {
        this.mLastUpdatedSelectionIndex = -1;
        this.mFlags = 1;
        this.mIsVertical = false;
    }

    public void SetNumSelections(int n) {
        this.mNumElements = n;
    }

    public int GetNumSelections() {
        return this.mNumElements;
    }

    public Selector(int n) {
        super(n);
        this.mFlags = 1;
        this.mIsVertical = false;
    }

    public boolean GetLooping() {
        return (this.mFlags & 2) != 0;
    }

    public void SetSkipDisabledSelection(boolean bl) {
        if (bl) {
            this.mFlags = (byte)(this.mFlags | 1);
            return;
        }
        this.mFlags = (byte)(this.mFlags & 0xFFFFFFFE);
    }

    public boolean GetSkipDisabledSelection() {
        return (this.mFlags & 1) != 0;
    }

    public void SetTakeFocusOnSync(boolean bl) {
        if (bl) {
            this.mFlags = (byte)(this.mFlags | 4);
            return;
        }
        this.mFlags = (byte)(this.mFlags & 0xFFFFFFFB);
    }

    public boolean GetTakeFocusOnSync() {
        return (this.mFlags & 4) != 0;
    }

    public int GetSingleSelection() {
        return this.mCurrentSelectionIndex;
    }

    public void SetSingleSelection(int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = this.mCurrentSelectionIndex;
        this.mCurrentSelectionIndex = n;
        if (n2 >= 0 && n2 != n && n2 < this.mNumElements) {
            ((Selection)this.mElements[n2]).SetSelectedState(false);
        }
        Selection selection = (Selection)this.mElements[n];
        this.mScrollerViewport.ChangeOffsetToShow(selection, false);
        selection.SetSelectedState(true, bl2, bl3);
        this.UpdateArrowsEnabledState();
        if (bl) {
            selection.TakeFocus();
        }
        this.mLastUpdatedSelectionIndex = this.mCurrentSelectionIndex;
    }

    public void SetSingleSelection(int n) {
        this.SetSingleSelection(n, false);
    }

    public void SetSingleSelection(int n, boolean bl) {
        this.SetSingleSelection(n, bl, false);
    }

    public static Selector[] InstArraySelector(int n) {
        Selector[] selectorArray = new Selector[n];
        for (int i = 0; i < n; ++i) {
            selectorArray[i] = new Selector();
        }
        return selectorArray;
    }

    public static Selector[][] InstArraySelector(int n, int n2) {
        Selector[][] selectorArray = new Selector[n][];
        for (int i = 0; i < n; ++i) {
            selectorArray[i] = new Selector[n2];
            for (int j = 0; j < n2; ++j) {
                selectorArray[i][j] = new Selector();
            }
        }
        return selectorArray;
    }

    public static Selector[][][] InstArraySelector(int n, int n2, int n3) {
        Selector[][][] selectorArray = new Selector[n][][];
        for (int i = 0; i < n; ++i) {
            selectorArray[i] = new Selector[n2][];
            for (int j = 0; j < n2; ++j) {
                selectorArray[i][j] = new Selector[n3];
                for (int k = 0; k < n3; ++k) {
                    selectorArray[i][j][k] = new Selector();
                }
            }
        }
        return selectorArray;
    }

    public void UpdateArrowsEnabledState() {
        if (this.mNextArrow != null) {
            if (!this.GetLooping()) {
                int n = this.mCurrentSelectionIndex;
                int n2 = this.mNumElements - 1;
                int n3 = -1;
                int n4 = -1;
                for (int i = 0; i < this.mNumElements; ++i) {
                    if (n4 == -1 && ((Selection)this.mElements[i]).GetEnabledState()) {
                        n4 = i;
                    }
                    if (n3 == -1 && ((Selection)this.mElements[n2 - i]).GetEnabledState()) {
                        n3 = n2 - i;
                    }
                    if ((n4 | n3) != -1) break;
                }
                Selection selection = this.mNextArrow;
                n3 = n < n3 ? 1 : 0;
                selection.SetEnabledState(n3 != 0);
                selection = this.mPreviousArrow;
                n4 = n > n4 ? 1 : 0;
                selection.SetEnabledState(n4 != 0);
                return;
            }
            this.mNextArrow.SetEnabledState(true);
            this.mPreviousArrow.SetEnabledState(true);
        }
    }

    public void OnScrollEvent(int n, boolean bl) {
        int n2;
        int n3 = n2 = this.mCurrentSelectionIndex;
        int n4 = this.mNumElements;
        boolean bl2 = this.GetLooping();
        boolean bl3 = this.GetSkipDisabledSelection();
        do {
            int n5 = n3 += n;
            if (n3 < 0) {
                n3 = n4 - 1;
            }
            if (n3 >= n4) {
                n3 = 0;
            }
            if (bl2) {
                if (n3 != n2) continue;
                break;
            }
            if (n3 == n5) continue;
            n3 = n5 - n;
            if (!bl3 || ((Selection)this.mElements[n3]).GetEnabledState()) break;
            n3 = this.mCurrentSelectionIndex;
            break;
        } while (bl3 && !((Selection)this.mElements[n3]).GetEnabledState());
        if (bl) {
            if (this.mLastUpdatedSelectionIndex != this.mCurrentSelectionIndex) {
                this.mCurrentSelectionIndex = this.mLastUpdatedSelectionIndex;
            }
            this.SetSingleSelection(n3, true, true, false);
            return;
        }
        this.mCurrentSelectionIndex = n3;
    }

    public boolean IsAppropriateHotkey(int n, int n2) {
        boolean bl = this.GetSkipDisabledSelection();
        for (int i = 0; i < this.mNumElements; i += 1) {
            Selection selection = (Selection)this.mElements[i];
            if (!selection.GetEnabledState() && bl || n2 != selection.GetHotKey()) continue;
            this.SetSingleSelection(i, true, true, true);
            i = n != -121 ? 1 : 0;
            selection.SetPushedState(i != 0);
            return true;
        }
        return false;
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        int n = 0;
        if (package_.IsReading()) {
            n = package_.SerializeIntrinsic(0);
        } else {
            this.mCurrentSelectionIndex = package_.SerializeIntrinsic(this.mCurrentSelectionIndex);
        }
        this.mFlags = package_.SerializeIntrinsic(this.mFlags);
        if (package_.IsReading() && n >= 0) {
            this.SetSingleSelection(n);
        }
    }

    public void OnScrollEvent(int n) {
        this.OnScrollEvent(n, true);
    }

    public byte GetTypeID() {
        return 96;
    }

    public static Class AsClass() {
        return null;
    }

    public Component ForwardFocus() {
        if (this.GetSingleSelection() == -1) {
            return this;
        }
        return this.GetElementAt(this.GetSingleSelection()).ForwardFocus();
    }

    public boolean OnDefaultMsg(Component component, int n, int n2) {
        if (-124 == n) {
            for (int i = 0; i < this.GetNumElements(); ++i) {
                if (!this.GetSelectionAt(i).IsSelfOrAncestorOf(component)) continue;
                this.SetSingleSelection(i, this.GetTakeFocusOnSync());
                this.SendMsg(this, -111, n2);
                i = this.GetNumElements();
            }
        }
        return super.OnDefaultMsg(component, n, n2);
    }

    public static Selector Cast(Object object, Selector selector) {
        return (Selector)object;
    }

    public void SetSelectionAt(int n, Selection selection) {
        super.SetElementAt(n, selection);
        if (this.mCurrentSelectionIndex == n) {
            ((Selection)this.mElements[this.mCurrentSelectionIndex]).SetSelectedState(true);
        }
    }

    public Selection GetSelectionAt(int n) {
        return (Selection)super.GetElementAt(n);
    }

    public void SetLooping(boolean bl) {
        if (bl) {
            this.mFlags = (byte)(this.mFlags | 2);
            return;
        }
        this.mFlags = (byte)(this.mFlags & 0xFFFFFFFD);
    }
}

