/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Blob;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.SoundManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class MMAPISoundImp {
    public Blob mDataBlob;
    public String mSoundFormat = new String();
    Player mPlayer;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int GetPlayerState() {
        int n = 0;
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            if (this.mPlayer == null) return n;
            return this.mPlayer.getState();
        }
    }

    public MMAPISoundImp() {
        this.mDataBlob = new Blob();
    }

    public void destruct() {
        this.mDataBlob = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void ResetSoundPlayer() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            this.Close();
            this.CreatePlayer();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Deallocate() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                SoundManager.Get().mImplementor.UnRegisterAsPrefetchedSound(this);
                this.mPlayer.deallocate();
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void OnSerialize(Package package_) {
        this.mDataBlob = this.mDataBlob.OnSerialize(package_);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean CreatePlayer() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                this.mPlayer = Manager.createPlayer((InputStream)new ByteArrayInputStream(this.mDataBlob.GetData()), (String)this.mSoundFormat);
                this.mPlayer.realize();
                return this.mPlayer != null;
            }
        }
        catch (Throwable throwable) {
            if (this.mPlayer != null) {
                this.mPlayer.close();
            }
            this.mPlayer = null;
        }
        return this.mPlayer != null;
    }

    Player GetPlayer() {
        return this.mPlayer;
    }

    public static MMAPISoundImp[] InstArrayMMAPISoundImp(int n) {
        MMAPISoundImp[] mMAPISoundImpArray = new MMAPISoundImp[n];
        for (int i = 0; i < n; ++i) {
            mMAPISoundImpArray[i] = new MMAPISoundImp();
        }
        return mMAPISoundImpArray;
    }

    public static MMAPISoundImp[][] InstArrayMMAPISoundImp(int n, int n2) {
        MMAPISoundImp[][] mMAPISoundImpArray = new MMAPISoundImp[n][];
        for (int i = 0; i < n; ++i) {
            mMAPISoundImpArray[i] = new MMAPISoundImp[n2];
            for (int j = 0; j < n2; ++j) {
                mMAPISoundImpArray[i][j] = new MMAPISoundImp();
            }
        }
        return mMAPISoundImpArray;
    }

    public static MMAPISoundImp[][][] InstArrayMMAPISoundImp(int n, int n2, int n3) {
        MMAPISoundImp[][][] mMAPISoundImpArray = new MMAPISoundImp[n][][];
        for (int i = 0; i < n; ++i) {
            mMAPISoundImpArray[i] = new MMAPISoundImp[n2][];
            for (int j = 0; j < n2; ++j) {
                mMAPISoundImpArray[i][j] = new MMAPISoundImp[n3];
                for (int k = 0; k < n3; ++k) {
                    mMAPISoundImpArray[i][j][k] = new MMAPISoundImp();
                }
            }
        }
        return mMAPISoundImpArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Close() {
        if (this.mPlayer == null) {
            return;
        }
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            SoundManager.Get().mImplementor.UnRegisterAsPrefetchedSound(this);
            try {
                this.mPlayer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPlayer = null;
            return;
        }
    }

    public void SetSoundFormat(String string) {
        this.mSoundFormat = string;
    }

    public String GetSoundFormat() {
        return this.mSoundFormat;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Prefetch() {
        if (this.mPlayer == null && !this.CreatePlayer()) {
            return;
        }
        SoundManager soundManager = SoundManager.Get();
        boolean bl = true;
        boolean bl2 = false;
        while (!bl2) {
            try {
                synchronized (soundManager) {
                    if (this.mPlayer.getState() == 300) return;
                    int n = soundManager.mImplementor.DeallocateOldestPrefetchedSound(bl, this.mSoundFormat);
                    if (n == -1) {
                        return;
                    }
                    this.mPlayer.prefetch();
                    soundManager.mImplementor.RegisterAsPrefetchedSound(this, n);
                }
            }
            catch (Throwable throwable) {
                bl = false;
                continue;
            }
            break;
        }
        return;
    }
}

