/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.Interpolator;
import ca.jamdat.flight.Package;

public class KeyFrameSequence {
    public static final byte FieldKeysPerChannel;
    public short[] mValues = null;
    public static final byte typeID;
    public static final byte FieldBytesPerValue;
    public static final byte FieldPointPosition;
    public static final byte FieldLoopingPeriod;
    public static final byte FieldLastIndex;
    public static int[] mValueBuffer;
    public static final byte FieldValuesPerKey;
    public static final boolean supportsDynamicSerialization;
    public static final byte FieldSingleInterpolator;
    public static final byte FieldTimeValues;
    public static final byte typeNumber;

    public boolean IsLooping() {
        return this.mValues[5] != 0;
    }

    public KeyFrameSequence() {
    }

    public void destruct() {
        this.mValues = null;
    }

    static {
        mValueBuffer = new int[8];
    }

    public static KeyFrameSequence Cast(Object object, KeyFrameSequence keyFrameSequence) {
        return (KeyFrameSequence)object;
    }

    public KeyFrameSequence(short s, byte by, byte by2, byte by3) {
        short[] sArray = new short[(s * by * by3 + 1 >> 1) + (7 + s)];
        sArray[0] = s;
        sArray[2] = by;
        sArray[3] = by2;
        sArray[1] = by3;
        sArray[4] = 1;
        sArray[5] = 0;
        sArray[6] = -1;
        this.mValues = sArray;
    }

    public void GetObjectValue(int n, int[] nArray) {
        int n2;
        int n3 = this.mValues[1];
        int n4 = this.mValues[5];
        int[] nArray2 = mValueBuffer;
        if (n4 != 0) {
            n = FlMath.Modulo(n, n4);
        }
        int n5 = this.GetKeyFrameIndex(n);
        this.GetKeyFrameValue(n5, nArray2, 0);
        if (this.mValues[4] == 1) {
            this.GetKeyFrameValue(n5 + 1, nArray2, 4);
            if (this.mValues[2] <= 2) {
                int n6 = this.GetCorrectedIndex(n5);
                n5 = this.GetCorrectedIndex(n5 + 1);
                int n7 = 7 + n6;
                short s = this.mValues[n7];
                int n8 = this.mValues[7 + n5];
                if (n6 > n5) {
                    if (n < n8) {
                        n += n4;
                    }
                    n8 += n4;
                }
                if ((n6 = n8 - s) != 0) {
                    n5 = FlMath.Absolute(n6 >> 1);
                    for (n4 = 0; n4 < n3; ++n4) {
                        n7 = (n8 - n) * nArray2[n4] + (n - s) * nArray2[4 + n4];
                        n2 = n7 < 0 ? -n5 : n5;
                        nArray2[n4] = (n7 + n2) / n6;
                    }
                }
            } else {
                F32 f32 = new F32(this.GetTimeRatio(n, n5, n5 + 1));
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = Interpolator.InterpolateLinear(new F32(nArray2[i], (int)this.mValues[3]), new F32(nArray2[4 + i], (int)this.mValues[3]), f32).ToFixedPoint(this.mValues[3]);
                }
                return;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = nArray2[n2];
        }
    }

    public void SetKeyFrame(int n, short s, int[] nArray) {
        this.mValues[7 + n] = s;
        for (s = 0; s < this.mValues[1]; s = (short)(s + 1)) {
            nArray[s] = nArray[s] >> -this.mValues[3];
        }
        this.SetKeyFrameValue(n, nArray);
    }

    public void SetKeyFrame(int n, short s, F32[] f32Array, int n2) {
        this.mValues[7 + n] = s;
        int[] nArray = new int[this.mValues[1]];
        n2 -= this.mValues[3];
        for (int i = 0; i < this.mValues[1]; ++i) {
            nArray[i] = n2 < 0 ? f32Array[i].ToFixedPoint(this.mValues[3]) << -n2 : f32Array[i].ToFixedPoint(this.mValues[3]) >> n2;
        }
        this.SetKeyFrameValue(n, nArray);
    }

    public byte GetInterpolator() {
        return (byte)this.mValues[4];
    }

    public void SetInterpolator(byte by) {
        this.mValues[4] = by;
    }

    public short GetPeriod() {
        return this.mValues[5];
    }

    public void SetPeriod(short s) {
        this.mValues[5] = s;
    }

    public KeyFrameSequence OnSerialize(Package package_) {
        this.mValues = package_.SerializeIntrinsics(this.mValues, (int)package_.SerializeIntrinsic((short)0));
        return this;
    }

    public int GetKeyFrameIndex(int n) {
        int n2;
        int n3;
        int n4;
        short[] sArray = this.mValues;
        if (sArray[6] != -1) {
            n4 = sArray[6];
            n3 = n4 < sArray[0] - 1 ? (int)((short)(n4 + 1)) : 0;
            n2 = n3;
            if (sArray[7 + n4] <= n && (n3 == 0 || sArray[7 + n3] > n)) {
                return n4;
            }
            n3 = n2 < sArray[0] - 1 ? (int)((short)(n2 + 1)) : 0;
            if (sArray[7 + n2] <= n && (n3 == 0 || sArray[7 + n3] > n)) {
                sArray[6] = n2;
                return n2;
            }
        }
        n3 = sArray[0] >> 1;
        n4 = sArray[0] - 1;
        int n5 = 0;
        while (n4 != n5) {
            n2 = sArray[7 + n3];
            if (n2 < n) {
                n5 = n3;
                n2 = n4 - n3 >> 1;
                if (n2 <= 0) {
                    n2 = 1;
                }
                n3 += n2;
                continue;
            }
            if (n2 > n) {
                n4 = n3 - 1;
                n3 = n4 - (n4 - n5 >> 1);
                continue;
            }
            sArray[6] = (short)n3;
            return n3;
        }
        if (n5 == 0 && sArray[7] > n) {
            sArray[6] = -1;
            n5 = sArray[5] != 0 && sArray[5] != n ? this.GetKeyFrameIndex(sArray[5]) : -1;
            return n5;
        }
        sArray[6] = (short)n5;
        return n5;
    }

    public void GetKeyFrameValue(int n, int[] nArray, int n2) {
        short[] sArray = this.mValues;
        short s = sArray[2];
        short s2 = sArray[1];
        int n3 = 7 + sArray[0];
        int n4 = this.GetCorrectedIndex(n) * s * s2;
        if (s > 1) {
            n4 = (n4 >> 1) + n3;
        }
        for (n = 0; n < s2; ++n) {
            int n5 = s == 4 ? sArray[n4++] << 16 | sArray[n4] & 0xFFFF : (s == 2 ? sArray[n4] : (int)((byte)(sArray[n3 + (n4 >> 1)] >> ((~n4 & 1) << 3))));
            ++n4;
            nArray[n + n2] = n5;
        }
    }

    public void SetKeyFrameValue(int n, int[] nArray) {
        Object object = ((KeyFrameSequence)object).mValues;
        int n2 = 7 + object[0];
        Object object2 = object[2];
        int n3 = n * (object2 * object[1]);
        if (object2 > true) {
            n3 = (n3 >> 1) + n2;
        }
        for (n = 0; n < object[1]; ++n) {
            int n4 = nArray[n];
            if (object2 == 4) {
                object[n3++] = (short)(n4 >> 16);
                object[n3] = (short)n4;
            } else if (object2 == 2) {
                object[n3] = (short)n4;
            } else {
                int n5 = n2 + (n3 >> 1);
                n4 = (short)(object[n5] & 255 << ((n3 & 1) << 3) | (n4 & 0xFF) << ((~n3 & 1) << 3));
                object[n5] = n4;
            }
            ++n3;
        }
    }

    public F32 GetTimeRatio(int n, int object, int n2) {
        Object object2 = ((KeyFrameSequence)object2).mValues;
        object = object2[7 + object];
        Object object3 = false;
        if (n2 >= object2[0]) {
            if (object2[5] != false) {
                object3 = object2[5] - object + object2[7];
                if (n < object) {
                    n += object2[5];
                }
            }
        } else {
            object3 = object2[7 + n2] - object;
        }
        if (!object3) {
            return F32.One(16);
        }
        return F32.FromInt(n - object, 16).Div((int)object3);
    }

    public int GetCorrectedIndex(int n) {
        int n2 = this.mValues[0];
        if (n < 0) {
            n2 = this.mValues[5] != 0 ? --n2 : 0;
            n = n2;
        } else if (n >= n2) {
            n2 = this.mValues[5] != 0 ? 0 : --n2;
            n = n2;
        }
        return n;
    }

    public static KeyFrameSequence[] InstArrayKeyFrameSequence(int n) {
        KeyFrameSequence[] keyFrameSequenceArray = new KeyFrameSequence[n];
        for (int i = 0; i < n; ++i) {
            keyFrameSequenceArray[i] = new KeyFrameSequence();
        }
        return keyFrameSequenceArray;
    }

    public static KeyFrameSequence[][] InstArrayKeyFrameSequence(int n, int n2) {
        KeyFrameSequence[][] keyFrameSequenceArray = new KeyFrameSequence[n][];
        for (int i = 0; i < n; ++i) {
            keyFrameSequenceArray[i] = new KeyFrameSequence[n2];
            for (int j = 0; j < n2; ++j) {
                keyFrameSequenceArray[i][j] = new KeyFrameSequence();
            }
        }
        return keyFrameSequenceArray;
    }

    public static KeyFrameSequence[][][] InstArrayKeyFrameSequence(int n, int n2, int n3) {
        KeyFrameSequence[][][] keyFrameSequenceArray = new KeyFrameSequence[n][][];
        for (int i = 0; i < n; ++i) {
            keyFrameSequenceArray[i] = new KeyFrameSequence[n2][];
            for (int j = 0; j < n2; ++j) {
                keyFrameSequenceArray[i][j] = new KeyFrameSequence[n3];
                for (int k = 0; k < n3; ++k) {
                    keyFrameSequenceArray[i][j][k] = new KeyFrameSequence();
                }
            }
        }
        return keyFrameSequenceArray;
    }
}

