/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.ForceInline;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Vector2_short;

public class FlRect {
    public static final boolean supportsDynamicSerialization;
    public static final byte typeID;
    public short[] mData = new short[4];
    public static final byte typeNumber;

    public void SetRight(int n) {
        this.SetWidth((short)(n - this.GetLeft() + 1));
    }

    public FlRect() {
    }

    public void SetBottom(int n) {
        this.SetHeight((short)(n + 1 - this.GetTop()));
    }

    public Vector2_short GetTopRight() {
        return new Vector2_short(this.GetRight(), this.GetTop());
    }

    public Vector2_short GetBottomRight() {
        return new Vector2_short(this.GetRight(), this.GetBottom());
    }

    public void SetBottomRight(Vector2_short vector2_short) {
        this.SetWidth((short)(vector2_short.GetX() + 1 - this.GetLeft()));
        this.SetHeight((short)(vector2_short.GetY() + 1 - this.GetTop()));
    }

    public Vector2_short GetBottomLeft() {
        return new Vector2_short(this.GetLeft(), this.GetBottom());
    }

    public void MoveBy(Vector2_short vector2_short) {
        this.SetLeft((short)(this.GetLeft() + vector2_short.GetX()));
        this.SetTop((short)(this.GetTop() + vector2_short.GetY()));
    }

    public void MoveBy(int n, int n2) {
        this.SetLeft((short)(this.GetLeft() + n));
        this.SetTop((short)(this.GetTop() + n2));
    }

    public static boolean Contains(short s, short s2, short s3, short s4, short s5, short s6) {
        return s <= s5 && s5 <= s + s3 - 1 && s2 <= s6 && s6 <= s2 + s4 - 1;
    }

    public boolean ClipLine(Vector2_short vector2_short, Vector2_short vector2_short2) {
        F32 f32;
        F32 f322;
        F32 f323;
        F32 f324;
        if (this.IsEmpty()) {
            return false;
        }
        F32 f325 = f324 = new F32(vector2_short.GetX() << 16, 16);
        F32 f326 = f323 = new F32(vector2_short.GetY() << 16, 16);
        F32 f327 = f322 = new F32(vector2_short2.GetX() << 16, 16);
        F32 f328 = f32 = new F32(vector2_short2.GetY() << 16, 16);
        F32 f329 = new F32(this.GetLeft() << 16, 16);
        F32 f3210 = new F32(this.GetTop() << 16, 16);
        F32 f3211 = new F32(this.GetLeft() + this.GetWidth() - 1 << 16, 16);
        F32 f3212 = new F32(this.GetTop() + this.GetHeight() - 1 << 16, 16);
        boolean bl = false;
        boolean bl2 = false;
        int n = FlRect.calcode(f324, f323, f329, f3210, f3211, f3212);
        int n2 = FlRect.calcode(f322, f32, f329, f3210, f3211, f3212);
        do {
            if ((n | n2) == 0) {
                bl = true;
                bl2 = true;
                continue;
            }
            if ((n & n2) != 0) {
                bl2 = true;
                continue;
            }
            int n3 = n != 0 ? n : n2;
            int n4 = n3;
            if ((n3 & 1) != 0) {
                f323 = f325.Add(f327.Sub(f325).Mul(f3212.Sub(f326).Div(f328.Sub(f326), 16), 16));
                f324 = f3212;
            } else if ((n3 & 2) != 0) {
                f323 = f325.Add(f327.Sub(f325).Mul(f3210.Sub(f326).Div(f328.Sub(f326), 16), 16));
                f324 = f3210;
            } else if ((n3 & 4) != 0) {
                f324 = f326.Add(f328.Sub(f326).Mul(f3211.Sub(f325).Div(f327.Sub(f325), 16), 16));
                f323 = f3211;
            } else {
                f324 = f326.Add(f328.Sub(f326).Mul(f329.Sub(f325).Div(f327.Sub(f325), 16), 16));
                f323 = f329;
            }
            if (n4 == n) {
                f325 = f323;
                f326 = f324;
                n = FlRect.calcode(f323, f324, f329, f3210, f3211, f3212);
                continue;
            }
            f327 = f323;
            f328 = f324;
            n2 = FlRect.calcode(f323, f324, f329, f3210, f3211, f3212);
        } while (!bl2);
        boolean bl3 = bl;
        vector2_short.SetX((short)f325.ToInt(16));
        vector2_short.SetY((short)f326.ToInt(16));
        vector2_short2.SetX((short)f327.ToInt(16));
        vector2_short2.SetY((short)f328.ToInt(16));
        return bl3;
    }

    public static boolean Intersects(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8) {
        return s5 + s7 > s && s6 + s8 > s2 && s + s3 > s5 && s2 + s4 > s6;
    }

    public static boolean Contains(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8) {
        return s5 >= s && s6 >= s2 && (short)(s5 + s7 - 1) <= (short)(s + s3 - 1) && (short)(s6 + s8 - 1) <= (short)(s2 + s4 - 1);
    }

    public void OffsetTop(short s) {
        ForceInline.v();
        this.SetTop((short)(this.GetTop() + s));
    }

    public void OffsetLeft(short s) {
        ForceInline.v();
        this.SetLeft((short)(this.GetLeft() + s));
    }

    public boolean Equals(FlRect flRect) {
        return this.mData[0] == flRect.mData[0] && this.mData[1] == flRect.mData[1] && this.mData[2] == flRect.mData[2] && this.mData[3] == flRect.mData[3];
    }

    public FlRect Add(Vector2_short vector2_short) {
        return new FlRect((short)(this.GetLeft() + vector2_short.GetX()), (short)(this.GetTop() + vector2_short.GetY()), this.GetWidth(), this.GetHeight());
    }

    public FlRect Assign(FlRect flRect) {
        this.mData[0] = flRect.GetLeft();
        this.mData[1] = flRect.GetTop();
        this.mData[2] = flRect.GetWidth();
        this.mData[3] = flRect.GetHeight();
        return this;
    }

    public static int calcode(F32 f32, F32 f322, F32 f323, F32 f324, F32 f325, F32 f326) {
        int n = 0;
        if (f322.GreaterThan(f326)) {
            n = 1;
        }
        if (f322.LessThan(f324)) {
            n |= 2;
        }
        if (f32.GreaterThan(f325)) {
            n |= 4;
        }
        if (f32.LessThan(f323)) {
            n |= 8;
        }
        return n;
    }

    public static FlRect[] InstArrayFlRect(int n) {
        FlRect[] flRectArray = new FlRect[n];
        for (int i = 0; i < n; ++i) {
            flRectArray[i] = new FlRect();
        }
        return flRectArray;
    }

    public static FlRect[][] InstArrayFlRect(int n, int n2) {
        FlRect[][] flRectArray = new FlRect[n][];
        for (int i = 0; i < n; ++i) {
            flRectArray[i] = new FlRect[n2];
            for (int j = 0; j < n2; ++j) {
                flRectArray[i][j] = new FlRect();
            }
        }
        return flRectArray;
    }

    public static FlRect[][][] InstArrayFlRect(int n, int n2, int n3) {
        FlRect[][][] flRectArray = new FlRect[n][][];
        for (int i = 0; i < n; ++i) {
            flRectArray[i] = new FlRect[n2][];
            for (int j = 0; j < n2; ++j) {
                flRectArray[i][j] = new FlRect[n3];
                for (int k = 0; k < n3; ++k) {
                    flRectArray[i][j][k] = new FlRect();
                }
            }
        }
        return flRectArray;
    }

    public void SetTopLeft(Vector2_short vector2_short) {
        this.SetLeft(vector2_short.GetX());
        this.SetTop(vector2_short.GetY());
    }

    public Vector2_short GetSize() {
        return new Vector2_short(this.mData[2], this.mData[3]);
    }

    public boolean IsEmpty() {
        return this.GetWidth() <= 0 || this.GetHeight() <= 0;
    }

    public Vector2_short GetTopLeft() {
        return new Vector2_short(this.GetLeft(), this.GetTop());
    }

    public short GetBottom() {
        return (short)(this.GetTop() + this.GetHeight() - 1);
    }

    public short GetRight() {
        return (short)(this.GetLeft() + this.GetWidth() - 1);
    }

    public FlRect GetVideoModeRect() {
        return DisplayManager.GetVideoModeRect();
    }

    public void SetWidth(int n) {
        this.mData[2] = (short)n;
    }

    public void SetHeight(int n) {
        this.mData[3] = (short)n;
    }

    public void OnSerialize(Package package_) {
        this.SetLeft(package_.SerializeIntrinsic(this.GetLeft()));
        this.SetTop(package_.SerializeIntrinsic(this.GetTop()));
        this.SetWidth(package_.SerializeIntrinsic(this.GetWidth()));
        this.SetHeight(package_.SerializeIntrinsic(this.GetHeight()));
    }

    public static FlRect Cast(Object object, FlRect flRect) {
        return (FlRect)object;
    }

    public FlRect(FlRect flRect) {
        this.mData[0] = flRect.GetLeft();
        this.mData[1] = flRect.GetTop();
        this.mData[2] = flRect.GetWidth();
        this.mData[3] = flRect.GetHeight();
    }

    public FlRect(short s, short s2, short s3, short s4) {
        this.mData[0] = s;
        this.mData[1] = s2;
        this.mData[2] = s3;
        this.mData[3] = s4;
    }

    public FlRect(Vector2_short vector2_short, Vector2_short vector2_short2) {
        this.mData[0] = vector2_short.GetX();
        this.mData[1] = vector2_short.GetY();
        this.mData[2] = vector2_short2.GetX();
        this.mData[3] = vector2_short2.GetY();
    }

    public Vector2_short GetCenter() {
        return new Vector2_short((short)(this.GetLeft() + this.GetWidth() / 2), (short)(this.GetTop() + this.GetHeight() / 2));
    }

    public short GetWidth() {
        return this.mData[2];
    }

    public short GetHeight() {
        return this.mData[3];
    }

    public short GetTop() {
        return this.mData[1];
    }

    public short GetLeft() {
        return this.mData[0];
    }

    public void SetCenter(Vector2_short vector2_short) {
        this.SetLeft((short)(vector2_short.GetX() - this.GetWidth() / 2));
        this.SetTop((short)(vector2_short.GetY() - this.GetHeight() / 2));
    }

    public void SetTop(int n) {
        this.mData[1] = (short)n;
    }

    public void SetLeft(int n) {
        this.mData[0] = (short)n;
    }
}

