/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.bejeweled;

import ca.jamdat.bejeweled.GameApp;
import ca.jamdat.bejeweled.ParticleGenerator;
import ca.jamdat.flight.Color888;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.FileStream;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.Shape;
import ca.jamdat.flight.Viewport;

public class ProgressBar {
    public boolean mSpeedIsToggled;
    public int mOpponentMarker;
    public Component mOpponentProgressComponent;
    public Component mOpponentProgressCenterComponent;
    public int mOverflowMarker;
    public int mGameType = -1;
    public Component mProgressRightBorderComponent;
    public Component mProgressMarkerComponent;
    public boolean mExploded;
    public Component mLocalProgressCenterComponent;
    public boolean mMultiplayer;
    public Viewport mViewport;
    public int mResult = 0;
    public int mMidPointMarker;
    public int mLocalMarker;
    public int mTotalUnits;
    public int mPointsPerUnit;
    public boolean mIsPaused;
    public Component mProgressLeftBorderComponent;
    public Component mLocalProgressComponent;
    public int mElapsedTime;
    public int mTotalTime;
    public int mTimedUnitCounter;
    public int mTimePerUnit;
    public short[] mFadeFrameOffSetSequence = new short[6];

    public void UpdateTime(int n) {
        if (this.mGameType != 1 && !this.mIsPaused) {
            this.mTimedUnitCounter += n;
            this.mElapsedTime += n;
            if (this.mTimedUnitCounter >= this.mTimePerUnit) {
                this.mTimedUnitCounter -= this.mTimePerUnit;
                --this.mLocalMarker;
                if (this.mGameType == 3) {
                    ++this.mOpponentMarker;
                }
                this.UpdateProgressBarDisplay();
            }
        }
    }

    public ProgressBar() {
        this.mFadeFrameOffSetSequence[0] = 5;
        this.mFadeFrameOffSetSequence[1] = 6;
        this.mFadeFrameOffSetSequence[2] = 7;
        this.mFadeFrameOffSetSequence[3] = 8;
        this.mFadeFrameOffSetSequence[4] = 4;
        this.mFadeFrameOffSetSequence[5] = 2;
    }

    public void destruct() {
    }

    public void UpdateMarker(int n, boolean n2, int n3) {
        if (this.mGameType == 3) {
            n3 = n / this.mPointsPerUnit;
            if (this.mMidPointMarker + (n3 *= (n2 = n2 != 0 ? 1 : -1)) > this.mTotalUnits) {
                this.mOverflowMarker += this.mMidPointMarker + n3 - this.mTotalUnits;
                n3 = this.mTotalUnits - this.mMidPointMarker;
            } else if (this.mOverflowMarker > 0 && n3 < 0) {
                this.mOverflowMarker += n3;
                if (this.mOverflowMarker < 0) {
                    n3 = this.mOverflowMarker;
                    this.mOverflowMarker = 0;
                } else {
                    n3 = 0;
                }
            }
            this.mMidPointMarker += n3;
            this.mLocalMarker += n3;
            this.mOpponentMarker += n3;
        } else if (this.mGameType == 1) {
            this.mLocalMarker += n / this.mPointsPerUnit;
        } else if (!this.mIsPaused || this.mGameType != 2) {
            if (n != 0) {
                this.mLocalMarker += n3 * 3;
            }
        } else {
            return;
        }
        this.UpdateProgressBarDisplay();
    }

    public int GetResult() {
        return this.mResult;
    }

    public boolean IsGameOver() {
        return this.mResult != 0;
    }

    public void Stop() {
        this.mIsPaused = true;
    }

    public void UpdateProgressBarDisplay() {
        int n;
        int n2 = 0;
        boolean bl = false;
        if (this.mLocalMarker >= this.mTotalUnits) {
            this.mResult = 1;
            bl = true;
        } else if (this.mLocalMarker <= 0 && this.mGameType != 1) {
            n = this.mGameType != 2 ? 1 : 0;
            n2 = n;
            if (this.mOpponentMarker >= this.mTotalUnits) {
                bl = true;
                this.mResult = 3;
            } else {
                this.mResult = 2;
            }
        } else if (this.mOpponentMarker >= this.mTotalUnits) {
            bl = true;
            this.mResult = 1;
        } else {
            this.mResult = 0;
        }
        if (this.mResult == 0 || this.mGameType == 3) {
            // empty if block
        }
        if (GameApp.GetGameAppInstance().GetGameState().IsInTutorialMode() && this.mResult != 0) {
            bl = false;
            n2 = 0;
        }
        if (this.mIsPaused && this.mResult != 0) {
            return;
        }
        int n3 = this.mLocalMarker;
        n = this.mOpponentMarker;
        if (n > this.mTotalUnits * 2 || n < 0) {
            // empty if block
        }
        if (this.mLocalMarker < 0) {
            n3 = 0;
        } else if (this.mLocalMarker > this.mTotalUnits * 2) {
            this.mLocalMarker = this.mTotalUnits * 2;
        }
        if (this.mResult != 0 && this.mGameType != 3) {
            this.Stop();
        }
        if (n3 > this.mTotalUnits) {
            n3 = this.mTotalUnits;
        }
        n = 142 * n3 / this.mTotalUnits;
        this.mProgressRightBorderComponent.SetTopLeft((short)(n + 1 + 1), (short)2);
        this.mLocalProgressComponent.SetSize((short)n, (short)7);
        this.mLocalProgressCenterComponent.SetSize((short)n, (short)5);
        if (this.mGameType == 2 || this.mGameType == 3 && !this.mIsPaused) {
            n = 0;
            if (n3 < 36) {
                n = this.mFadeFrameOffSetSequence[(n3 - 3) / 6];
            }
            this.UpdateComponentFrames(n);
        }
        if (!this.mExploded && (n2 != 0 || bl) && this.mGameType != 3) {
            this.Explode(true, n2 != 0, bl);
            this.mExploded = true;
        }
    }

    public void UpdateComponentFrames(int n) {
        Color888 color888 = Color888.Cast(GameApp.GetGameAppInstance().GetPackage((byte)10).GetEntryPoint(37 + n), null);
        ((Shape)this.mLocalProgressComponent).SetColor(color888);
        ((Shape)this.mOpponentProgressComponent).SetColor(color888);
        ((Shape)this.mProgressRightBorderComponent).SetColor(color888);
        ((Shape)this.mProgressLeftBorderComponent).SetColor(color888);
    }

    public void ToggleSpeedLevel() {
        int n = this.mSpeedIsToggled ? this.mTimePerUnit * 7 : this.mTimePerUnit / 7;
        this.mTimePerUnit = n;
        n = !this.mSpeedIsToggled ? 1 : 0;
        this.mSpeedIsToggled = n;
    }

    public void Explode(boolean bl, boolean bl2, boolean bl3) {
        this.mLocalProgressComponent.SetVisible(bl);
        this.mProgressRightBorderComponent.SetVisible(bl);
        this.mProgressLeftBorderComponent.SetVisible(bl);
        ParticleGenerator particleGenerator = GameApp.GetGameAppInstance().GetParticleGenerator();
        if (bl2) {
            particleGenerator.JewelExplosion(this.mLocalProgressComponent.GetAbsoluteLeft(), this.mLocalProgressComponent.GetAbsoluteTop() + 4, 0, 9);
        }
        if (bl3) {
            particleGenerator.JewelExplosion(this.mProgressRightBorderComponent.GetAbsoluteLeft(), this.mProgressRightBorderComponent.GetAbsoluteTop() + 4, 0, 9);
        }
    }

    public void ReStartForTutorial() {
        this.mResult = 0;
        this.mIsPaused = false;
        this.mLocalMarker = 1;
        this.mLocalProgressComponent.SetVisible(true);
        this.mProgressRightBorderComponent.SetVisible(true);
        this.mProgressLeftBorderComponent.SetVisible(true);
    }

    public static ProgressBar[] InstArrayProgressBar(int n) {
        ProgressBar[] progressBarArray = new ProgressBar[n];
        for (int i = 0; i < n; ++i) {
            progressBarArray[i] = new ProgressBar();
        }
        return progressBarArray;
    }

    public static ProgressBar[][] InstArrayProgressBar(int n, int n2) {
        ProgressBar[][] progressBarArray = new ProgressBar[n][];
        for (int i = 0; i < n; ++i) {
            progressBarArray[i] = new ProgressBar[n2];
            for (int j = 0; j < n2; ++j) {
                progressBarArray[i][j] = new ProgressBar();
            }
        }
        return progressBarArray;
    }

    public static ProgressBar[][][] InstArrayProgressBar(int n, int n2, int n3) {
        ProgressBar[][][] progressBarArray = new ProgressBar[n][][];
        for (int i = 0; i < n; ++i) {
            progressBarArray[i] = new ProgressBar[n2][];
            for (int j = 0; j < n2; ++j) {
                progressBarArray[i][j] = new ProgressBar[n3];
                for (int k = 0; k < n3; ++k) {
                    progressBarArray[i][j][k] = new ProgressBar();
                }
            }
        }
        return progressBarArray;
    }

    public void Start() {
        this.mIsPaused = false;
    }

    public void GetResources(boolean bl) {
        Package package_ = GameApp.GetGameAppInstance().GetPackage((byte)16);
        this.mLocalProgressComponent = Component.Cast(package_.GetEntryPoint(7), null);
        this.mOpponentProgressComponent = Component.Cast(package_.GetEntryPoint(8), null);
        this.mProgressMarkerComponent = Component.Cast(package_.GetEntryPoint(11), null);
        this.mProgressLeftBorderComponent = Component.Cast(package_.GetEntryPoint(13), null);
        this.mProgressRightBorderComponent = Component.Cast(package_.GetEntryPoint(12), null);
        this.mLocalProgressCenterComponent = Component.Cast(package_.GetEntryPoint(9), null);
        this.mOpponentProgressCenterComponent = Component.Cast(package_.GetEntryPoint(10), null);
        this.mOpponentProgressCenterComponent.SetVisible(this.mMultiplayer);
        this.mProgressMarkerComponent.SetVisible(this.mMultiplayer);
        this.mOpponentProgressComponent.SetVisible(this.mMultiplayer);
    }

    public void UnloadResources() {
        this.mLocalProgressComponent = null;
        this.mOpponentProgressComponent = null;
        this.mProgressMarkerComponent = null;
        this.mProgressLeftBorderComponent = null;
        this.mProgressRightBorderComponent = null;
        this.mLocalProgressCenterComponent = null;
        this.mOpponentProgressCenterComponent = null;
    }

    public void Init(int n, int n2) {
        this.mGameType = n;
        this.mResult = 0;
        this.mElapsedTime = 0;
        this.mExploded = false;
        this.mMultiplayer = false;
        this.mOpponentMarker = -1;
        this.mPointsPerUnit = 5;
        if (n == 2) {
            this.mTotalUnits = 120;
            this.mLocalMarker = this.mMidPointMarker = 60;
            switch (n2) {
                case 1: {
                    this.mTotalTime = 155000;
                    break;
                }
                case 2: {
                    this.mTotalTime = 75000;
                    break;
                }
                case 3: {
                    this.mTotalTime = 60000;
                    break;
                }
                case 4: {
                    this.mTotalTime = 50000;
                    break;
                }
                case 5: {
                    this.mTotalTime = 40000;
                    break;
                }
                default: {
                    this.mTotalTime = 30000;
                }
            }
            this.mTimePerUnit = this.mTotalTime / this.mMidPointMarker;
        } else {
            this.mLocalMarker = 0;
            this.mMidPointMarker = -1;
            this.mTimePerUnit = 0;
            switch (n2) {
                case 1: {
                    this.mTotalUnits = 100;
                    break;
                }
                case 2: {
                    this.mTotalUnits = 300;
                    break;
                }
                case 3: {
                    this.mTotalUnits = 700;
                    break;
                }
                case 4: {
                    this.mTotalUnits = 1300;
                    break;
                }
                case 5: {
                    this.mTotalUnits = 1900;
                    break;
                }
                case 6: {
                    this.mTotalUnits = 2500;
                    break;
                }
                default: {
                    this.mTotalUnits = 3100;
                }
            }
            this.mProgressLeftBorderComponent.SetTopLeft((short)1, (short)2);
            this.mLocalProgressComponent.SetTopLeft((short)2, (short)1);
        }
        this.mProgressMarkerComponent.SetVisible(this.mMultiplayer);
        this.mOpponentProgressComponent.SetVisible(this.mMultiplayer);
        this.mLocalProgressComponent.SetVisible(true);
        this.mProgressRightBorderComponent.SetVisible(true);
        this.mProgressLeftBorderComponent.SetVisible(true);
        this.UpdateProgressBarDisplay();
        if (this.mGameType == 1) {
            this.UpdateComponentFrames(0);
        }
        this.mSpeedIsToggled = false;
        this.mTimedUnitCounter = 0;
    }

    public void Save(FileStream fileStream) {
        fileStream.WriteByte((byte)this.mResult);
        fileStream.WriteByte((byte)this.mGameType);
        fileStream.WriteShort((short)this.mTotalTime);
        fileStream.WriteShort((short)this.mElapsedTime);
        fileStream.WriteShort((short)this.mLocalMarker);
    }

    public void Load(FileStream fileStream) {
        this.mResult = fileStream.ReadByte();
        this.mGameType = fileStream.ReadByte();
        this.mTotalTime = fileStream.ReadShort();
        this.mElapsedTime = fileStream.ReadShort();
        this.mLocalMarker = fileStream.ReadShort();
        if (this.mResult == 1) {
            this.mExploded = true;
        }
    }
}

