/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.bejeweled;

import ca.jamdat.bejeweled.BejeweledAnimation;
import ca.jamdat.bejeweled.GameApp;
import ca.jamdat.bejeweled.GameScene;
import ca.jamdat.bejeweled.ProgressBar;
import ca.jamdat.flight.FileStream;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.RandomGenerator;
import ca.jamdat.flight.Vector2_short;

public class BejeweledState {
    public static final int vertical;
    public int mCurrentState;
    public static final int kTrumpetExplosionToEnd;
    public static final int pivotJewel;
    public boolean mLocal;
    public static final int kTrumpetNone;
    public int mAttackReceived;
    public int mNbOfConsecutiveCascades;
    public BejeweledAnimation mBejeweledAnimation;
    public boolean mCheatsEnabled;
    public int mTotalNbOfMatches;
    public int mGameType;
    public static final int nextJewel;
    public boolean mCheatNewJewels;
    public int mLongestMatchSizeInLastStroke;
    public static final int jewelSelected;
    public static final int columnCount;
    public int mNumberOfMatches;
    public int mAttackStored;
    public static final int up;
    public static final int levelCompleteTextState;
    public int[] mColumnsFallDelay = new int[8];
    public int mTotalNbOfCascades;
    public boolean mMustLoadGame;
    public int mOpponentResult;
    public int mLongestMatchInGame;
    public static final int movingCursor;
    public int mSavedCursorPos;
    public int mGameLevel = 1;
    public boolean mLevelComplete;
    public boolean mTutorialMode;
    public static final int right;
    public static final int levelComplete;
    public int mTableElementSize;
    public boolean mGridNeedsFallAndFill;
    public boolean mPaused;
    public RandomGenerator mRandomGenerator;
    public static final int waitForOpponentSeed;
    public int mMaxRemovedJewelRow;
    public static final int rowCount;
    public boolean mGameOver;
    public static final int noDir;
    public static final int animating;
    public int mTableElementInterSpace;
    public int mGameResult;
    public static final int init;
    public int[] mTableElements = new int[64];
    public int mTrumpetTime;
    public static final int doubleOverflowWaitPeriod;
    public static final int down;
    public boolean mForceNextLevel;
    public int[] mSwappedJewels = new int[2];
    public static final int left;
    public int mHintJewelIndex = -1;
    public int mMinRemovedJewelColumn = 8;
    public static final int inCaveIn;
    public int mScore;
    public static final int previousJewel;
    public int mMaxRemovedJewelColumn;
    public static final int kTrumpetStartToExplosion;
    public static final int waitingForGridGenesis;
    public static final int elementCount;
    public static final int horizontal;
    public static final int waitForOpponentSeedAck;
    public int mTrumpetState;

    public void EndTutorial() {
        this.mTutorialMode = false;
        this.mAttackReceived = -1;
    }

    public void ReInitRandomGenerator() {
        this.mRandomGenerator.ReInitialize(FlMath.Random((short)0, (short)Short.MAX_VALUE));
    }

    public void destruct() {
        this.mRandomGenerator = new RandomGenerator();
    }

    public void SetSavedCursorPos(int n) {
        this.mSavedCursorPos = n;
    }

    public int GetSavedCursorPos() {
        return this.mSavedCursorPos;
    }

    public void CheatNewJewels() {
        boolean bl = !this.mCheatNewJewels;
        this.mCheatNewJewels = bl;
    }

    public boolean AreCheatsEnabled() {
        return this.mCheatsEnabled;
    }

    public int GetTotalNbOfMatches() {
        return this.mTotalNbOfMatches;
    }

    public int GetTotalNbOfCascades() {
        return this.mTotalNbOfCascades;
    }

    public void Save() {
        if (this.mBejeweledAnimation != null && this.mBejeweledAnimation.GetCurrentAnimation() == 3) {
            this.ClearJewelTable();
        }
        GameApp gameApp = GameApp.GetGameAppInstance();
        FileStream fileStream = new FileStream(GameApp.GetFileName((byte)this.mGameType), 1);
        int n = this.mGameOver ? 1 : 0;
        fileStream.WriteByte((byte)n);
        n = this.mCheatsEnabled ? 1 : 0;
        fileStream.WriteByte((byte)n);
        fileStream.WriteByte((byte)this.mGameType);
        fileStream.WriteByte((byte)this.mHintJewelIndex);
        fileStream.WriteByte((byte)this.mGameLevel);
        fileStream.WriteByte((byte)this.mLongestMatchInGame);
        fileStream.WriteByte((byte)this.mSwappedJewels[0]);
        fileStream.WriteByte((byte)this.mSwappedJewels[1]);
        for (n = 0; n < 64; ++n) {
            fileStream.WriteByte((byte)this.mTableElements[n]);
        }
        fileStream.WriteLong(this.mNumberOfMatches);
        fileStream.WriteLong(this.mTotalNbOfMatches);
        fileStream.WriteLong(this.mTotalNbOfCascades);
        fileStream.WriteLong(this.mScore);
        gameApp.GetProgressBar().Save(fileStream);
        fileStream.Close();
    }

    public void EnableCheats() {
        this.mCheatsEnabled = true;
    }

    public void SkipAnim() {
        while (this.mCurrentState == 1) {
            this.mBejeweledAnimation.OnTime(0, 16383);
            this.OnTime(0, 1);
        }
    }

    public boolean PlaySound(int n, boolean bl) {
        if (!(this.mPaused || ((GameScene)GameApp.GetGameAppInstance().GetScene()).IsDoingVoiceOver() && n == 10)) {
            return GameApp.GetGameAppInstance().PlaySound(n, bl);
        }
        return false;
    }

    public void Load() {
        GameApp gameApp = GameApp.GetGameAppInstance();
        FileStream fileStream = new FileStream(GameApp.GetFileName((byte)this.mGameType), 0);
        int n = fileStream.ReadByte() == 1 ? 1 : 0;
        this.mGameOver = n;
        n = fileStream.ReadByte() == 1 ? 1 : 0;
        this.mCheatsEnabled = n;
        this.mGameType = fileStream.ReadByte();
        this.mHintJewelIndex = fileStream.ReadByte();
        this.mGameLevel = fileStream.ReadByte();
        this.mLongestMatchInGame = fileStream.ReadByte();
        this.mSwappedJewels[0] = fileStream.ReadByte();
        this.mSwappedJewels[1] = fileStream.ReadByte();
        for (n = 0; n < 64; ++n) {
            this.mTableElements[n] = fileStream.ReadByte();
        }
        this.mNumberOfMatches = fileStream.ReadLong();
        this.mTotalNbOfMatches = fileStream.ReadLong();
        this.mTotalNbOfCascades = fileStream.ReadLong();
        this.mScore = fileStream.ReadLong();
        gameApp.GetProgressBar().Init(this.mGameType, this.mGameLevel);
        gameApp.GetProgressBar().Load(fileStream);
        gameApp.GetProgressBar().Start();
        gameApp.GetProgressBar().UpdateMarker(0, true, 0);
        gameApp.GetProgressBar().Stop();
        fileStream.Close();
        if (!this.IsJewelTableFull()) {
            if (this.mScore > 0) {
                this.mForceNextLevel = true;
            }
            this.ResetGrid();
        }
    }

    public void UnloadResources() {
        if (this.mBejeweledAnimation != null) {
            if (this.mBejeweledAnimation.GetCurrentAnimation() == 3) {
                this.ClearJewelTable();
                GameApp.GetGameAppInstance().StopSound();
            }
            this.mBejeweledAnimation.UnloadResources();
        }
        this.mBejeweledAnimation = null;
    }

    public boolean IsPaused() {
        return this.mPaused;
    }

    public boolean IsGameOver() {
        return this.mGameOver;
    }

    public BejeweledState(int n, boolean bl, boolean n2) {
        this.mGameType = n;
        this.mAttackStored = -1;
        this.mTableElementSize = 26;
        this.mTableElementInterSpace = 4;
        this.mMustLoadGame = n2;
        this.mOpponentResult = 0;
        this.mGameResult = 0;
        n2 = GameApp.GetGameAppInstance().IsTutorialOn(n) && n2 == 0 ? 1 : 0;
        this.mTutorialMode = n2;
        this.mCurrentState = 0;
        this.mAttackReceived = -1;
        this.mTrumpetState = 2;
        this.mLocal = bl;
        this.mSavedCursorPos = -1;
        this.mRandomGenerator = new RandomGenerator();
        this.mSwappedJewels[0] = -1;
        this.mSwappedJewels[1] = -1;
        for (n2 = 0; n2 < 8; ++n2) {
            this.mColumnsFallDelay[n2] = -1;
        }
        for (n2 = 0; n2 < 64; ++n2) {
            this.mTableElements[n2] = -1;
        }
    }

    public void PrepareExitScene() {
        this.mPaused = true;
        if (this.mCurrentState == 8) {
            this.mCurrentState = 1;
        }
        this.StopHint();
        if (this.mBejeweledAnimation != null) {
            this.mBejeweledAnimation.EndScoreAnimation();
        }
    }

    public void StartGame() {
        this.mPaused = false;
        GameScene gameScene = (GameScene)GameApp.GetGameAppInstance().GetScene();
        if (!(this.mCurrentState != 0 && this.mCurrentState != 9 || this.mMustLoadGame)) {
            if (this.IsInTutorialMode()) {
                this.CreateJewelsTable();
                this.mBejeweledAnimation.SetCurrentAnimation(4);
                this.SetState(1);
                return;
            }
            this.GridGenesis();
            return;
        }
        if (this.mCurrentState != 1 && (this.mGameType == 3 && this.IsLocal() || this.mGameType != 3 && !this.mLevelComplete) || this.mCurrentState == 1 && this.mBejeweledAnimation.GetCurrentAnimation() == -1 && !this.mLevelComplete) {
            if (!this.IsInTutorialMode() && !this.IsJewelTableFull()) {
                this.ResetGrid();
                return;
            }
            if (!this.IsInTutorialMode()) {
                gameScene.OnStateChange(18, this.IsLocal());
            } else {
                gameScene.StartTutorial();
            }
            this.mMinRemovedJewelColumn = 0;
            this.mMaxRemovedJewelColumn = 7;
            this.mMaxRemovedJewelRow = 7;
            if (!this.FindPossibleMove()) {
                this.NoMoreMove();
                return;
            }
            if (this.mSwappedJewels[0] != this.mSwappedJewels[1]) {
                this.RemoveSwappedJewels();
            } else if (this.CheckForJewelCascadeRemoval()) {
                this.FallAndFill(true);
            } else {
                this.SetState(2);
            }
            if (!this.mTutorialMode) {
                GameApp.GetGameAppInstance().GetProgressBar().Start();
            }
            GameApp.GetGameAppInstance().GetProgressBar().UpdateMarker(0, true, 0);
            this.mMustLoadGame = false;
            return;
        }
        if (!this.IsJewelTableFull()) {
            this.SetState(1);
            this.ResetGrid();
            this.mLevelComplete = false;
            return;
        }
        if (this.mLevelComplete && this.mBejeweledAnimation.GetCurrentAnimation() != 4) {
            GameApp.GetGameAppInstance().GetProgressBar().Start();
            GameApp.GetGameAppInstance().GetProgressBar().UpdateProgressBarDisplay();
            gameScene.OnStateChange(19, this.IsLocal(), -1);
            gameScene.OnStateChange(4, this.IsLocal(), 3);
            this.SetState(8);
        }
    }

    public void CreateJewelsTable() {
        if (this.IsInTutorialMode()) {
            this.SetTutorialGrid();
            this.SetJewelsInBejeweledAnimation();
            return;
        }
        do {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    int n = this.mRandomGenerator.GetUniformShort((short)0, (short)6);
                    while (n == this.GetJewelAt(i - 2, j) && n == this.GetJewelAt(i - 1, j) || n == this.GetJewelAt(i, j - 2) && n == this.GetJewelAt(i, j - 1)) {
                        n = this.NextValidJewel(n);
                    }
                    this.mTableElements[i * 8 + j] = n;
                }
            }
        } while (!this.FindPossibleMove());
        this.SetJewelsInBejeweledAnimation();
    }

    public void SetJewelsInBejeweledAnimation() {
        for (int i = 0; i < 64; ++i) {
            this.mBejeweledAnimation.SetJewel(i, this.mTableElements[i]);
        }
    }

    public boolean FindHintFromPosition(int n, int n2) {
        if (!(n != 0 && n != 7 || n2 != 0 && n2 != 7)) {
            return false;
        }
        int n3 = this.GetIndex(n, n2);
        int n4 = this.mTableElements[n3];
        if (n4 == -1) {
            this.mHintJewelIndex = -1;
            return false;
        }
        this.mHintJewelIndex = -1;
        if (!(n == 7 || n2 == 0 || n2 == 7 || this.mTableElements[n3 - 1] != n4 && this.mTableElements[n3 + 8 - 1] != n4 || this.mTableElements[n3 + 1] != n4 && this.mTableElements[n3 + 8 + 1] != n4)) {
            if (this.mTableElements[n3 + 1] == n4) {
                if (this.mTableElements[n3 - 1] != -1) {
                    this.mHintJewelIndex = n3 + 8 - 1;
                    return true;
                }
            } else if (this.mTableElements[n3 - 1] == n4) {
                if (this.mTableElements[n3 + 1] != -1) {
                    this.mHintJewelIndex = n3 + 8 + 1;
                    return true;
                }
            } else if (this.mTableElements[n3 + 8] != -1) {
                this.mHintJewelIndex = n3;
                return true;
            }
        }
        if (!(n == 0 || n2 == 0 || n2 == 7 || this.mTableElements[n3 - 1] != n4 && this.mTableElements[n3 - 8 - 1] != n4 || this.mTableElements[n3 + 1] != n4 && this.mTableElements[n3 - 8 + 1] != n4)) {
            if (this.mTableElements[n3 + 1] == n4) {
                if (this.mTableElements[n3 - 1] != -1) {
                    this.mHintJewelIndex = n3 - 8 - 1;
                    return true;
                }
            } else if (this.mTableElements[n3 - 1] == n4) {
                if (this.mTableElements[n3 + 1] != -1) {
                    this.mHintJewelIndex = n3 - 8 + 1;
                    return true;
                }
            } else if (this.mTableElements[n3 - 8] != -1) {
                this.mHintJewelIndex = n3;
                return true;
            }
        }
        if (!(n2 == 7 || n == 0 || n == 7 || this.mTableElements[n3 - 8] != n4 && this.mTableElements[n3 - 8 + 1] != n4 || this.mTableElements[n3 + 8] != n4 && this.mTableElements[n3 + 8 + 1] != n4)) {
            if (this.mTableElements[n3 + 8] == n4) {
                if (this.mTableElements[n3 - 8] != -1) {
                    this.mHintJewelIndex = n3 - 8 + 1;
                    return true;
                }
            } else if (this.mTableElements[n3 - 8] == n4) {
                if (this.mTableElements[n3 + 8] != -1) {
                    this.mHintJewelIndex = n3 + 8 + 1;
                    return true;
                }
            } else if (this.mTableElements[n3 + 1] != -1) {
                this.mHintJewelIndex = n3;
                return true;
            }
        }
        if (!(n2 == 0 || n == 0 || n == 7 || this.mTableElements[n3 - 8 - 1] != n4 && this.mTableElements[n3 - 8] != n4 || this.mTableElements[n3 + 8 - 1] != n4 && this.mTableElements[n3 + 8] != n4)) {
            if (this.mTableElements[n3 + 8] == n4) {
                if (this.mTableElements[n3 - 8] != -1) {
                    this.mHintJewelIndex = n3 - 8 - 1;
                    return true;
                }
            } else if (this.mTableElements[n3 - 8] == n4) {
                if (this.mTableElements[n3 + 8] != -1) {
                    this.mHintJewelIndex = n3 + 8 - 1;
                    return true;
                }
            } else if (this.mTableElements[n3 - 1] != -1) {
                this.mHintJewelIndex = n3;
                return true;
            }
        }
        if (n2 > 1 && n2 < 7 && this.mTableElements[n3 - 2] == n4 && this.mTableElements[n3 + 1] == n4 && this.mTableElements[n3 - 1] != -1) {
            this.mHintJewelIndex = n3 - 2;
            return true;
        }
        if (n2 > 0 && n2 < 6 && this.mTableElements[n3 - 1] == n4 && this.mTableElements[n3 + 2] == n4 && this.mTableElements[n3 + 1] != -1) {
            this.mHintJewelIndex = n3 + 2;
            return true;
        }
        if (n > 1 && n < 7 && this.mTableElements[n3 - 16] == n4 && this.mTableElements[n3 + 8] == n4 && this.mTableElements[n3 - 8] != -1) {
            this.mHintJewelIndex = n3 - 16;
            return true;
        }
        if (n > 0 && n < 6 && this.mTableElements[n3 - 8] == n4 && this.mTableElements[n3 + 16] == n4 && this.mTableElements[n3 + 8] != -1) {
            this.mHintJewelIndex = n3 + 16;
            return true;
        }
        return false;
    }

    public boolean FindPossibleMove() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!this.FindHintFromPosition(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public void OnSelect(int n, int n2) {
        n2 = this.GetIndex(n, n2);
        if (this.mCurrentState == 3) {
            this.mBejeweledAnimation.StopSelectAnimation();
            this.SetState(2);
            return;
        }
        if (this.mCurrentState == 2) {
            if (this.mTableElements[n2] == -1) {
                return;
            }
            if (n2 == this.mHintJewelIndex) {
                this.mBejeweledAnimation.StopHintAnimation();
            }
            this.mBejeweledAnimation.StartJewelSelectAnimation(n2);
            this.PlaySound(10, this.mLocal);
            this.SetState(3);
        }
    }

    public boolean OnDirection(int n, int n2, int n3) {
        boolean bl = false;
        if (this.mCurrentState == 3) {
            this.mSwappedJewels[0] = this.GetIndex(n2, n3);
            switch (n) {
                case 1: {
                    if (n2 <= 0) break;
                    this.mSwappedJewels[1] = this.mSwappedJewels[0] - 8;
                    if (this.mTableElements[this.mSwappedJewels[1]] == -1) {
                        bl = false;
                        break;
                    }
                    bl = this.Swap();
                    break;
                }
                case -1: {
                    if (n2 >= 7) break;
                    this.mSwappedJewels[1] = this.mSwappedJewels[0] + 8;
                    if (this.mTableElements[this.mSwappedJewels[1]] == -1) {
                        bl = false;
                        break;
                    }
                    bl = this.Swap();
                    break;
                }
                case -3: {
                    if (n3 >= 7) break;
                    this.mSwappedJewels[1] = this.mSwappedJewels[0] + 1;
                    if (this.mTableElements[this.mSwappedJewels[1]] == -1) {
                        bl = false;
                        break;
                    }
                    bl = this.Swap();
                    break;
                }
                case 3: {
                    if (n3 <= 0) break;
                    this.mSwappedJewels[1] = this.mSwappedJewels[0] - 1;
                    bl = this.mTableElements[this.mSwappedJewels[1]] == -1 ? false : this.Swap();
                }
            }
            if (!bl) {
                this.mSwappedJewels[0] = -1;
                this.mSwappedJewels[1] = -1;
            }
        }
        return bl;
    }

    public boolean Swap() {
        int n;
        int n2;
        if (this.mGridNeedsFallAndFill) {
            return false;
        }
        this.mLongestMatchSizeInLastStroke = 0;
        int n3 = this.mSwappedJewels[0];
        int n4 = FlMath.Absolute(this.mSwappedJewels[0] - this.mSwappedJewels[1]) == 1 ? 12 : 11;
        if (this.mSwappedJewels[0] < this.mSwappedJewels[1]) {
            n2 = this.mSwappedJewels[0];
            n = this.mSwappedJewels[1];
        } else {
            n2 = this.mSwappedJewels[1];
            n = this.mSwappedJewels[0];
        }
        this.mBejeweledAnimation.StopSelectAnimation();
        if (this.mHintJewelIndex == this.mSwappedJewels[1]) {
            this.mBejeweledAnimation.StopHintAnimation();
        }
        boolean bl = this.mTableElements[n2];
        this.mTableElements[n2] = this.mTableElements[n];
        this.mTableElements[n] = bl;
        bl = this.CheckForJewelSwapRemoval(n2, n);
        if (bl) {
            this.mBejeweledAnimation.SetJewel(n2, this.mTableElements[n2]);
            this.mBejeweledAnimation.SetJewel(n, this.mTableElements[n]);
            n3 = this.mSwappedJewels[1];
            this.PlaySound(11, this.mLocal);
        } else {
            int n5 = this.mTableElements[n2];
            this.mTableElements[n2] = this.mTableElements[n];
            this.mTableElements[n] = n5;
            this.PlaySound(12, this.mLocal);
        }
        this.mBejeweledAnimation.BringJewelToFront(n3);
        this.mBejeweledAnimation.StartJewelsSwapAnimation(n2, n, n4, bl);
        this.SetState(1);
        return bl;
    }

    public void ClearJewelTable() {
        for (int i = 0; i < 64; ++i) {
            this.mTableElements[i] = -1;
            this.mBejeweledAnimation.SetJewel(i, -1);
        }
    }

    public void GridGenesis() {
        if (this.mCurrentState != 6) {
            this.SetState(6);
            ((GameScene)GameApp.GetGameAppInstance().GetScene()).ShowJewelViewport(false);
            GameApp.GetGameAppInstance().SetLoadingSpriteVisible(true);
            return;
        }
        GameApp.GetGameAppInstance().SetLoadingSpriteVisible(false);
        this.mBejeweledAnimation.StopAllJewelAnimation();
        this.mColumnsFallDelay[0] = 3;
        for (int i = 1; i < 8; ++i) {
            this.mColumnsFallDelay[i] = this.mColumnsFallDelay[i - 1] + 3;
        }
        this.CreateJewelsTable();
        this.FastFill();
        this.mBejeweledAnimation.SetAnimationSpeed(2);
        this.mBejeweledAnimation.SetCurrentAnimation(4);
        this.SetState(1);
        this.PlaySound(4, this.mLocal);
        this.mLevelComplete = false;
    }

    public boolean CheckForJewelCascadeRemoval() {
        boolean bl = false;
        int n = this.mMaxRemovedJewelRow + 1 >= 8 ? 7 : this.mMaxRemovedJewelRow + 1;
        int n2 = n;
        n = this.mMaxRemovedJewelColumn + 1 >= 8 ? 7 : this.mMaxRemovedJewelColumn + 1;
        int n3 = n;
        n = this.mMinRemovedJewelColumn - 1 < 0 ? 0 : this.mMinRemovedJewelColumn - 1;
        for (int i = n; i <= n3; ++i) {
            for (n = n2; n >= 0; --n) {
                if (!this.PropagateRemoval(n, i)) continue;
                bl = true;
            }
        }
        if (bl) {
            this.ClearMarkedJewels();
        }
        return bl;
    }

    public boolean CheckForJewelSwapRemoval(int n, int n2) {
        return this.IsJewelMatched(n) || this.IsJewelMatched(n2);
    }

    public void ClearMarkedJewels() {
        for (int i = this.mMinRemovedJewelColumn; i <= this.mMaxRemovedJewelColumn; ++i) {
            for (int j = this.mMaxRemovedJewelRow; j >= 0; --j) {
                int n = this.GetIndex(j, i);
                if ((this.mTableElements[n] & 8) == 0) continue;
                this.mTableElements[n] = -1;
            }
        }
    }

    public boolean IsJewelTableFull() {
        for (int i = 0; i < 64; ++i) {
            if (this.mTableElements[i] != -1) continue;
            return false;
        }
        return true;
    }

    public void RemoveSwappedJewels() {
        this.mNumberOfMatches = 0;
        this.mBejeweledAnimation.StopJewelAnimation(this.mSwappedJewels[0]);
        this.mBejeweledAnimation.StopJewelAnimation(this.mSwappedJewels[1]);
        for (int i = 1; i >= 0; --i) {
            Vector2_short vector2_short = new Vector2_short(this.GetJewelCoord2(this.mSwappedJewels[i]));
            short s = vector2_short.GetY();
            this.PropagateRemoval(vector2_short.GetX(), s);
        }
        if (this.mLongestMatchSizeInLastStroke < 4) {
            this.PlaySound(6, this.mLocal);
        } else {
            this.PlaySound(7, this.mLocal);
        }
        this.mLongestMatchSizeInLastStroke = 0;
        this.ClearMarkedJewels();
        this.FallAndFill(true);
        if (GameApp.GetGameAppInstance().GetGameState().GetGameType() != 3) {
            this.mBejeweledAnimation.StartShockWaveAnimation();
        }
    }

    public boolean PropagateRemoval(int n, int n2) {
        int n3 = this.mTableElements[this.GetIndex(n, n2)];
        if (n3 == -1 || (n3 & 8) != 0) {
            return false;
        }
        boolean bl = false;
        if (this.PropagateRemovalInAxis(n, n2, n3, 2)) {
            bl = true;
        }
        if (this.PropagateRemovalInAxis(n, n2, n3, 3)) {
            bl = true;
        }
        if (bl) {
            this.RemoveNextJewel(n, n2, n3, 0, 0, 0);
            this.mBejeweledAnimation.StartJewelRemovalAnimation();
        }
        return bl;
    }

    public boolean PropagateRemovalInAxis(int n, int n2, int n3, int n4) {
        if (n4 == 2 && this.IsJewelMatchedInRow(n, n2, n3) || n4 == 3 && this.IsJewelMatchedInCol(n, n2, n3)) {
            ++this.mNumberOfMatches;
            ++this.mTotalNbOfMatches;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 1;
            int n9 = 1;
            while (n8 != 0 || n9 != 0) {
                if (n8 != 0 && this.RemoveNextJewel(n, n2, n3, ++n7, n4, -1)) {
                    ++n6;
                } else {
                    n8 = 0;
                }
                if (n9 != 0 && this.RemoveNextJewel(n, n2, n3, n7, n4, 1)) {
                    ++n5;
                    continue;
                }
                n9 = 0;
            }
            n9 = n5 + n6 + 1;
            if (this.mLongestMatchSizeInLastStroke < n9) {
                this.mLongestMatchSizeInLastStroke = n9;
            }
            if (n9 > this.mLongestMatchInGame) {
                this.mLongestMatchInGame = n9;
            }
            n9 = this.GetPointsForMatch(n9, this.mNumberOfMatches);
            this.UpdateScore(n9);
            if (GameApp.GetGameAppInstance().GetGameState().GetGameType() != 3) {
                n8 = (n5 - n6) / 2;
                if (n4 == 3) {
                    this.mBejeweledAnimation.SetRemovalScore(n2, n + n8, n9);
                } else {
                    this.mBejeweledAnimation.SetRemovalScore(n2 + n8, n, n9);
                }
            }
            return true;
        }
        return false;
    }

    public boolean RemoveNextJewel(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == 2) {
            n2 += n4 * n6;
        } else if (n5 == 3) {
            n += n4 * n6;
        }
        if ((this.GetJewelAt(n, n2) & 0xFFFFFFF7) == n3) {
            n6 = this.GetIndex(n, n2);
            if (n2 < this.mMinRemovedJewelColumn) {
                this.mMinRemovedJewelColumn = n2;
            }
            if (n2 > this.mMaxRemovedJewelColumn) {
                this.mMaxRemovedJewelColumn = n2;
            }
            if (n > this.mMaxRemovedJewelRow) {
                this.mMaxRemovedJewelRow = n;
            }
            if (n6 == this.mHintJewelIndex) {
                this.mBejeweledAnimation.StopHintAnimation();
            }
            if ((this.mTableElements[n6] & 8) == 0) {
                this.mColumnsFallDelay[n2] = n4;
                n5 = 67 * n4;
                this.mBejeweledAnimation.SetJewelForRemovalAnimation(n6, n5, this.mTableElements[n6]);
                this.mTableElements[n6] = this.mTableElements[n6] | 8;
                this.mBejeweledAnimation.SetJewel(n6, -1);
                this.mBejeweledAnimation.ApplyShockWave(n6, n2, n, n5);
            }
            return true;
        }
        return false;
    }

    public boolean IsJewelMatched(int n) {
        int n2 = this.mTableElements[n];
        Vector2_short vector2_short = new Vector2_short(this.GetJewelCoord2(n));
        n = vector2_short.GetY();
        short s = vector2_short.GetX();
        return this.IsJewelMatchedInRow(s, n, n2) || this.IsJewelMatchedInCol(s, n, n2);
    }

    public boolean IsJewelMatchedInRow(int n, int n2, int n3) {
        return (this.GetJewelAt(n, n2 - 2) & 0xFFFFFFF7) == n3 && (this.GetJewelAt(n, n2 - 1) & 0xFFFFFFF7) == n3 || (this.GetJewelAt(n, n2 - 1) & 0xFFFFFFF7) == n3 && (this.GetJewelAt(n, n2 + 1) & 0xFFFFFFF7) == n3 || (this.GetJewelAt(n, n2 + 1) & 0xFFFFFFF7) == n3 && (this.GetJewelAt(n, n2 + 2) & 0xFFFFFFF7) == n3;
    }

    public boolean IsJewelMatchedInCol(int n, int n2, int n3) {
        return (this.GetJewelAt(n - 2, n2) & 0xFFFFFFF7) == n3 && (this.GetJewelAt(n - 1, n2) & 0xFFFFFFF7) == n3 || (this.GetJewelAt(n - 1, n2) & 0xFFFFFFF7) == n3 && (this.GetJewelAt(n + 1, n2) & 0xFFFFFFF7) == n3 || (this.GetJewelAt(n + 1, n2) & 0xFFFFFFF7) == n3 && (this.GetJewelAt(n + 2, n2) & 0xFFFFFFF7) == n3;
    }

    public void OnTime(int n, int n2) {
        GameApp gameApp = GameApp.GetGameAppInstance();
        ProgressBar progressBar = gameApp.GetProgressBar();
        GameScene gameScene = (GameScene)gameApp.GetScene();
        if (this.mCurrentState == 6) {
            gameScene.ShowJewelViewport(true);
            this.GridGenesis();
            return;
        }
        if (this.mCurrentState == 1) {
            if (this.mTrumpetState != 2) {
                this.mTrumpetTime += n2;
                if (this.mTrumpetTime >= 1500 && this.mTrumpetState == 0) {
                    progressBar.Explode(false, true, false);
                    this.mTrumpetState = 1;
                } else if (this.mTrumpetTime >= 3000 && this.mTrumpetState == 1) {
                    gameScene.OnStateChange(5, this.mLocal, 5);
                    this.mTrumpetTime = 0;
                    this.mTrumpetState = 2;
                }
            }
            if (this.mBejeweledAnimation.IsAnimationEnded()) {
                n2 = this.mBejeweledAnimation.GetCurrentAnimation();
                this.mBejeweledAnimation.EndAnimation(n2);
                if (n2 == 12 || n2 == 11) {
                    if (this.mSwappedJewels[0] != this.mSwappedJewels[1]) {
                        this.RemoveSwappedJewels();
                        this.mNbOfConsecutiveCascades = 1;
                    } else {
                        this.SetState(2);
                    }
                    this.mSwappedJewels[0] = -1;
                    this.mSwappedJewels[1] = -1;
                    return;
                }
                if (n2 == 9) {
                    this.EndFallAndFill(true);
                    return;
                }
                if (n2 == 10) {
                    this.mBejeweledAnimation.EndAnimation(9);
                    this.EndFallAndFill(false);
                    return;
                }
                if (n2 == 4) {
                    this.mBejeweledAnimation.EndAnimation(9);
                    this.mBejeweledAnimation.SetAnimationSpeed(1);
                    if (this.mScore == 0) {
                        gameScene.OnStateChange(0, this.mLocal);
                    }
                    gameScene.OnStateChange(18, this.mLocal);
                    this.SetState(2);
                    this.StartGame();
                    if (this.mGameType == 2 && !this.mTutorialMode) {
                        progressBar.Start();
                        return;
                    }
                } else {
                    if (n2 == 7) {
                        this.ClearJewelTable();
                        this.mCurrentState = 5;
                        return;
                    }
                    if (n2 == 5 || n2 == 3) {
                        if (n2 == 3) {
                            this.mLevelComplete = false;
                            this.ResetGrid();
                            return;
                        }
                        if (this.mGameOver) {
                            this.ClearJewelTable();
                            gameScene.OnStateChange(16, this.mLocal);
                            return;
                        }
                        this.GridGenesis();
                        return;
                    }
                }
            }
        } else if (progressBar.IsGameOver() && this.mLocal && !this.IsInTutorialMode()) {
            this.CheckProgress(false);
        }
    }

    public Vector2_short GetJewelCoord2(int n) {
        int n2 = n;
        n = (short)(n % 8);
        return new Vector2_short((short)((n2 - n) / 8), (short)n);
    }

    public int GetIndex(int n, int n2) {
        return n * 8 + n2;
    }

    public void FallAndFill(boolean bl) {
        if (this.mAttackReceived != 2) {
            this.mBejeweledAnimation.Stop();
            for (int i = this.mMinRemovedJewelColumn; i <= this.mMaxRemovedJewelColumn; ++i) {
                int n;
                int n2;
                int n3;
                int n4 = 0;
                int n5 = 0;
                for (n3 = this.mMaxRemovedJewelRow; n3 >= 0; --n3) {
                    n2 = this.GetIndex(n3, i);
                    if (this.mTableElements[n2] == -1) {
                        ++n4;
                        n5 = 0;
                        continue;
                    }
                    if (n4 <= 0) continue;
                    n = this.GetIndex(n3 + n4, i);
                    this.mTableElements[n] = this.mTableElements[n2];
                    this.mBejeweledAnimation.StopJewelAnimation(n);
                    this.mBejeweledAnimation.SetJewel(n, this.mTableElements[n]);
                    this.mBejeweledAnimation.SetJewelForFallAndFillAnimation(n, n5, n4, this.mColumnsFallDelay[i], bl);
                    ++n5;
                    this.mBejeweledAnimation.StopJewelAnimation(n2);
                    this.mTableElements[n2] = -1;
                    this.mBejeweledAnimation.SetJewel(n2, this.mTableElements[n2]);
                }
                if (this.mAttackReceived == 3 || n4 <= 0) continue;
                for (n = n4 - 1; n >= 0; --n) {
                    n2 = this.mCheatNewJewels ? 3 : (int)this.mRandomGenerator.GetUniformShort((short)0, (short)6);
                    n3 = this.GetIndex(n, i);
                    this.mBejeweledAnimation.StopJewelAnimation(n3);
                    this.mTableElements[n3] = n2;
                    this.mBejeweledAnimation.SetJewel(n3, this.mTableElements[n3]);
                    this.mBejeweledAnimation.SetJewelForFallAndFillAnimation(n3, n5, n4, this.mColumnsFallDelay[i], bl);
                    ++n5;
                }
            }
            this.mBejeweledAnimation.StartJewelFallAndFillAnimation();
        }
        this.SetState(1);
        this.mBejeweledAnimation.SetCurrentAnimation(9);
    }

    public void FastFill() {
        int n = 0;
        int n2 = 7;
        for (int i = 0; i < 64; ++i) {
            if (n == 8) {
                --n2;
                n = 0;
            }
            this.mBejeweledAnimation.SetJewelForFallAndFillAnimation(i, n2, 8, this.mColumnsFallDelay[n], true);
            ++n;
        }
        this.mBejeweledAnimation.StartJewelFallAndFillAnimation();
        this.mBejeweledAnimation.SetCurrentAnimation(9);
    }

    public void EndFallAndFill(boolean bl) {
        for (int i = 0; i < 8; ++i) {
            this.mColumnsFallDelay[i] = -1;
        }
        if (this.CheckForJewelCascadeRemoval()) {
            ++this.mTotalNbOfCascades;
            ++this.mNbOfConsecutiveCascades;
            GameApp gameApp = GameApp.GetGameAppInstance();
            if (this.mNbOfConsecutiveCascades == 1) {
                if (this.mLongestMatchSizeInLastStroke < 4) {
                    this.PlaySound(6, this.mLocal);
                } else {
                    this.PlaySound(7, this.mLocal);
                }
                this.mLongestMatchSizeInLastStroke = 0;
            }
            if (this.mNbOfConsecutiveCascades == 2) {
                this.PlaySound(8, this.mLocal);
            } else if (this.mNbOfConsecutiveCascades == 3) {
                this.PlaySound(9, this.mLocal);
            } else if (this.mNbOfConsecutiveCascades == 4) {
                ((GameScene)gameApp.GetScene()).OnStateChange(1, this.IsLocal());
            } else if (this.mNbOfConsecutiveCascades == 8) {
                ((GameScene)gameApp.GetScene()).OnStateChange(2, this.IsLocal());
            } else {
                this.PlaySound(9, this.mLocal);
            }
            this.FallAndFill(bl);
            if (gameApp.GetGameState().GetGameType() != 3) {
                this.mBejeweledAnimation.StartShockWaveAnimation();
                return;
            }
        } else {
            if (GameApp.GetGameAppInstance().GetProgressBar().GetResult() != 1) {
                this.SetState(2);
            } else {
                this.SetState(7);
            }
            this.mNbOfConsecutiveCascades = 0;
            if (this.mAttackReceived != 2 && this.mAttackReceived != 3) {
                this.mMinRemovedJewelColumn = 8;
                this.mMaxRemovedJewelColumn = 0;
                this.mMaxRemovedJewelRow = 0;
                this.mNumberOfMatches = 0;
            }
            if (!this.FindPossibleMove()) {
                this.NoMoreMove();
            }
        }
    }

    public void CaveIn() {
    }

    public int GetPointsForMatch(int n, int n2) {
        int[] nArray = new int[]{10, 20, 30, 50, 80, 110};
        int[] nArray2 = new int[]{0, 10, 20, 30, 50, 70, 100, 150, 200};
        int[] nArray3 = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        int n3 = this.mGameLevel;
        if (n2 > 9) {
            n2 = 9;
        }
        if (n3 > 9) {
            n3 = 9;
        }
        if ((n2 = (nArray[n - 3] + nArray2[n2 - 1]) * nArray3[n3] / 2) > 999) {
            n2 = 999;
        }
        return n2;
    }

    public void UpdateScore(int n) {
        if (n == -1) {
            this.mScore = 0;
        } else {
            this.mScore += n;
            if (this.mScore > 999999) {
                this.mScore = 999999;
            }
            GameApp.GetGameAppInstance().GetProgressBar().UpdateMarker(n, this.IsLocal(), this.mNumberOfMatches);
        }
        ((GameScene)GameApp.GetGameAppInstance().GetScene()).OnStateChange(15, this.IsLocal());
    }

    public void ManageAttackReceived(int n) {
    }

    public void SendAttack() {
    }

    public void OpponentSentForfeit(boolean bl) {
    }

    public int GetJewelAt(int n, int n2) {
        if (n < 0 || n >= 8 || n2 < 0 || n2 >= 8) {
            return -1;
        }
        return this.mTableElements[this.GetIndex(n, n2)];
    }

    public int NextValidJewel(int n) {
        return (n + 1) % 7;
    }

    public void SetState(int n) {
        this.mCurrentState = n;
    }

    public void GetResources() {
        if (this.IsLocal()) {
            BejeweledAnimation bejeweledAnimation;
            boolean bl = this.mGameType == 3;
            this.mBejeweledAnimation = bejeweledAnimation = new BejeweledAnimation(bl);
        }
        this.mBejeweledAnimation.GetResources();
    }

    public void Init() {
        ProgressBar progressBar = GameApp.GetGameAppInstance().GetProgressBar();
        this.mBejeweledAnimation.Init();
        if (this.mCurrentState == 0) {
            int n = this.mTutorialMode ? 12345 : (int)FlMath.Random((short)0, (short)Short.MAX_VALUE);
            this.mRandomGenerator.ReInitialize(n);
            progressBar.Start();
            progressBar.Init(this.mGameType, 1);
            progressBar.Stop();
            for (n = 0; n < 64; ++n) {
                this.mTableElements[n] = -1;
            }
        }
        if (this.mMustLoadGame) {
            this.Load();
        }
        progressBar.UpdateProgressBarDisplay();
        this.SetJewelsInBejeweledAnimation();
    }

    public void ResetStats() {
        this.mTotalNbOfMatches = 0;
        this.mTotalNbOfCascades = 0;
        this.mLongestMatchInGame = 0;
    }

    public void Hint() {
        if (this.mHintJewelIndex != -1) {
            this.mBejeweledAnimation.StartHintAnimation(this.mHintJewelIndex);
        }
    }

    public void StopHint() {
        this.mBejeweledAnimation.StopHintAnimation();
    }

    public void FullGridReflect() {
        this.mBejeweledAnimation.StartHighlightAnimation();
    }

    public void Bonus() {
        this.mBejeweledAnimation.StopAllJewelAnimation();
        this.mBejeweledAnimation.EndAnimation(10);
        this.mBejeweledAnimation.StartBonusAnimation();
        if (this.mGameType != 3) {
            this.UpdateScore(this.GetPointsForMatch(3, 1) * 10);
        }
        this.SetState(1);
        ((GameScene)GameApp.GetGameAppInstance().GetScene()).OnStateChange(19, this.IsLocal());
    }

    public int GetState() {
        return this.mCurrentState;
    }

    public boolean IsLocal() {
        return this.mLocal;
    }

    public int GetScore() {
        return this.mScore;
    }

    public int GetGameType() {
        return this.mGameType;
    }

    public int GetAttackReceived() {
        return this.mAttackReceived;
    }

    public void EndMultiplayerGame() {
    }

    public void OpponentGameResultChanged(int n) {
        this.mOpponentResult = n;
        if (this.mGameOver) {
            this.EndMultiplayerGame();
        }
    }

    public void NoMoreMove() {
        if (this.mAttackReceived == 2 || this.mAttackReceived == 3) {
            return;
        }
        this.CheckProgress(true);
    }

    public void CheckProgress(boolean bl) {
        if (this.mGameOver || this.mLevelComplete) {
            return;
        }
        GameApp gameApp = GameApp.GetGameAppInstance();
        GameScene gameScene = (GameScene)gameApp.GetScene();
        int n = gameApp.GetProgressBar().GetResult();
        gameScene.OnStateChange(19, this.mLocal);
        this.SetState(1);
        if (n == 1) {
            this.mLevelComplete = true;
            gameScene.OnStateChange(4, this.mLocal, 3);
            return;
        }
        if (n == 2) {
            this.mGameOver = true;
            this.mTrumpetState = 0;
            this.PlaySound(18, true);
            return;
        }
        if (this.mGameType == 2) {
            gameApp.GetProgressBar().Stop();
        }
        n = this.mGameType == 1 ? 1 : 0;
        this.mGameOver = n;
        gameScene.OnStateChange(3, this.mLocal, 5);
    }

    public void ResetGrid() {
        ProgressBar progressBar;
        if (this.mGameType != 3 && ((progressBar = GameApp.GetGameAppInstance().GetProgressBar()).GetResult() == 1 || this.mForceNextLevel)) {
            this.mForceNextLevel = false;
            ++this.mGameLevel;
            if (this.mGameLevel > 99) {
                this.mGameLevel = 99;
            }
            ((GameScene)GameApp.GetGameAppInstance().GetScene()).OnStateChange(6, this.IsLocal());
            progressBar.Init(this.mGameType, this.mGameLevel);
        }
        this.GridGenesis();
    }

    public int GetElementSize() {
        return this.mTableElementSize;
    }

    public int GetElementInterSpace() {
        return this.mTableElementInterSpace;
    }

    public int GetLevel() {
        return this.mGameLevel;
    }

    public void InGameMessageDone(int n) {
        switch (n) {
            case 3: {
                this.PlaySound(22, this.mLocal);
                this.Bonus();
                this.SetState(1);
                return;
            }
            case 5: {
                this.mBejeweledAnimation.StartGameOverAnimation();
                if (GameApp.GetGameAppInstance().IsVibrationOn()) {
                    GameApp.GetGameAppInstance().StartVibration(500, this.mLocal);
                } else {
                    this.PlaySound(21, this.mLocal);
                }
                this.SetState(1);
            }
        }
    }

    public void CheatJewelType(int n, int n2) {
        if (n2 == -1) {
            this.mTableElements[n] = (this.mTableElements[n] + 1) % 8;
            if (this.mTableElements[n] == 7) {
                this.mTableElements[n] = -1;
            }
        } else {
            this.mTableElements[n] = n2;
        }
        this.mBejeweledAnimation.SetJewel(n, this.mTableElements[n]);
        this.mMaxRemovedJewelColumn = 7;
        this.mMinRemovedJewelColumn = 0;
        this.mMaxRemovedJewelRow = 7;
        int[] nArray = this.mColumnsFallDelay;
        n = new Vector2_short(this.GetJewelCoord2(n)).GetY();
        nArray[n] = 0;
    }

    public int GetOpponentResult() {
        return this.mOpponentResult;
    }

    public int GetGameResult() {
        return this.mGameResult;
    }

    public void SetGameResult(int n) {
        this.mGameResult = n;
        n = n != 0 ? 1 : 0;
        this.mGameOver = n;
    }

    public boolean IsInGridGenesis() {
        return this.mBejeweledAnimation != null && this.mBejeweledAnimation.GetCurrentAnimation() == 4;
    }

    public void StopAllAnims() {
        this.mBejeweledAnimation.StopAllJewelAnimation();
        this.mBejeweledAnimation.EndAnimation(10);
    }

    public int GetNbOfConsecutiveCascades() {
        return this.mNbOfConsecutiveCascades;
    }

    public int GetLongestMatch() {
        return this.mLongestMatchInGame;
    }

    public void SetScore(int n) {
        this.mScore = n;
    }

    public void SetTutorialGrid() {
        int n = this.mGameType != 1 && !GameApp.GetGameAppInstance().IsTutorialOn(1) ? 1 : 0;
        int n2 = n;
        this.mTableElements[0] = 0;
        this.mTableElements[1] = 5;
        this.mTableElements[2] = 2;
        this.mTableElements[3] = 6;
        this.mTableElements[4] = 1;
        this.mTableElements[5] = 4;
        this.mTableElements[6] = 4;
        this.mTableElements[7] = 0;
        this.mTableElements[8] = 0;
        this.mTableElements[9] = 5;
        this.mTableElements[10] = 2;
        this.mTableElements[11] = 6;
        this.mTableElements[12] = 0;
        this.mTableElements[13] = 6;
        this.mTableElements[14] = 4;
        this.mTableElements[15] = 0;
        this.mTableElements[16] = 1;
        this.mTableElements[17] = 6;
        this.mTableElements[18] = 4;
        this.mTableElements[19] = 0;
        this.mTableElements[20] = 0;
        this.mTableElements[21] = 5;
        this.mTableElements[22] = 2;
        this.mTableElements[23] = 6;
        this.mTableElements[24] = 0;
        this.mTableElements[25] = 1;
        this.mTableElements[26] = 4;
        this.mTableElements[27] = 3;
        this.mTableElements[28] = 1;
        this.mTableElements[29] = 5;
        this.mTableElements[30] = 2;
        this.mTableElements[31] = 4;
        this.mTableElements[32] = 1;
        this.mTableElements[33] = 5;
        this.mTableElements[34] = 0;
        this.mTableElements[35] = 4;
        this.mTableElements[36] = 0;
        this.mTableElements[37] = 1;
        this.mTableElements[38] = 4;
        this.mTableElements[39] = 1;
        this.mTableElements[40] = 0;
        this.mTableElements[41] = 3;
        int[] nArray = this.mTableElements;
        n = n != 0 ? 0 : 2;
        nArray[42] = n;
        this.mTableElements[43] = 3;
        this.mTableElements[44] = 1;
        this.mTableElements[45] = 6;
        this.mTableElements[46] = 4;
        this.mTableElements[47] = 0;
        this.mTableElements[48] = 1;
        this.mTableElements[49] = 0;
        nArray = this.mTableElements;
        n = n2 != 0 ? 2 : 3;
        nArray[50] = n;
        this.mTableElements[51] = 0;
        this.mTableElements[52] = 2;
        this.mTableElements[53] = 5;
        this.mTableElements[54] = 2;
        this.mTableElements[55] = 6;
        this.mTableElements[56] = 2;
        this.mTableElements[57] = 6;
        this.mTableElements[58] = 4;
        this.mTableElements[59] = 1;
        this.mTableElements[60] = 6;
        this.mTableElements[61] = 5;
        this.mTableElements[62] = 2;
        this.mTableElements[63] = 3;
    }

    public boolean IsInTutorialMode() {
        return this.mTutorialMode;
    }
}

