/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Controller;
import ca.jamdat.flight.F32;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.PtrArray_TimeControlled;
import ca.jamdat.flight.TimeControlled;

public class TimeSystem
extends TimeControlled {
    public static final boolean supportsDynamicSerialization;
    public boolean mPaused;
    public F32 mTimeFlowSpeed = new F32(F32.One(16));
    public F32 mDeltaError = new F32(F32.Zero(16));
    public PtrArray_TimeControlled mTimeControlleds = new PtrArray_TimeControlled();
    public boolean mDirty;
    public static final byte typeID;
    public int mTotalTime;
    public static final byte typeNumber;

    public void destruct() {
    }

    public void OnTime(int n, int n2) {
        if (!this.IsPaused()) {
            if (!this.mTimeFlowSpeed.Equals(F32.One(16))) {
                F32 f32 = new F32(F32.FromInt(n2, 16).Mul(this.mTimeFlowSpeed, 16).Add(this.mDeltaError));
                n2 = f32.ToInt(16);
                this.mDeltaError = f32.Sub(F32.FromInt(n2, 16));
            }
            this.mTotalTime += n2;
            this.SendOnTime(this.mTotalTime, n2);
        }
        this.CleanUpTimeTable();
    }

    public static TimeSystem Cast(Object object, TimeSystem timeSystem) {
        return (TimeSystem)object;
    }

    public void Start() {
        this.mPaused = false;
    }

    public void StartRecursively() {
        this.Start();
        for (int i = this.mTimeControlleds.Start(); i < this.mTimeControlleds.End(); ++i) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i);
            if (timeControlled == null || !(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).StartRecursively();
        }
    }

    public void StopRecursively() {
        this.Stop();
        for (int i = this.mTimeControlleds.Start(); i < this.mTimeControlleds.End(); ++i) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i);
            if (timeControlled == null || !(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).StopRecursively();
        }
    }

    public void Pause() {
        this.mPaused = true;
    }

    public void AdvanceBy(int n) {
        this.mTotalTime += n;
        this.SendOnTime(this.mTotalTime, n);
    }

    public void Register(TimeControlled timeControlled) {
        if (!this.IsRegistered(timeControlled)) {
            this.mTimeControlleds.Insert(timeControlled);
        }
    }

    public void UnRegister(TimeControlled timeControlled) {
        int n = this.mTimeControlleds.Find(timeControlled);
        if (n >= 0) {
            this.mTimeControlleds.SetAt(null, n);
            this.mDirty = true;
        }
    }

    public void UnRegisterAll() {
        PtrArray_TimeControlled ptrArray_TimeControlled = this.mTimeControlleds;
        for (int i = 0; i < ptrArray_TimeControlled.End(); ++i) {
            if (ptrArray_TimeControlled.GetAt(i) == null) continue;
            this.UnRegister(ptrArray_TimeControlled.GetAt(i));
        }
    }

    public boolean IsRegistered(TimeControlled timeControlled) {
        return this.mTimeControlleds.Find(timeControlled) >= 0;
    }

    public F32 GetTimeFlowSpeed() {
        return this.mTimeFlowSpeed.IncreasePrecision(0);
    }

    public void SetTimeFlowSpeed(F32 f32) {
        this.mTimeFlowSpeed = f32.DecreasePrecision(0);
    }

    public int GetTotalTime() {
        return this.mTotalTime;
    }

    public void SetTotalTime(int n) {
        this.mTotalTime = n;
    }

    public void SetTotalTimeRecursively(int n) {
        this.SetTotalTime(n);
        for (int i = this.mTimeControlleds.Start(); i < this.mTimeControlleds.End(); ++i) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i);
            if (timeControlled == null || !(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).SetTotalTimeRecursively(n);
        }
    }

    public boolean IsPaused() {
        return this.mPaused || this.mTimeFlowSpeed.Equals(F32.Zero(16));
    }

    public void RefreshAllControllersIncluded() {
        for (int i = this.mTimeControlleds.Start(); i < this.mTimeControlleds.End(); ++i) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i);
            if (timeControlled == null) continue;
            if (timeControlled instanceof Controller) {
                ((Controller)timeControlled).Refresh();
                continue;
            }
            if (!(timeControlled instanceof TimeSystem)) continue;
            ((TimeSystem)timeControlled).RefreshAllControllersIncluded();
        }
    }

    public int GetNbChildren() {
        return this.mTimeControlleds.End();
    }

    public TimeControlled GetChild(int n) {
        return this.mTimeControlleds.GetAt(n);
    }

    public void OnSerialize(Package package_) {
        this.mTotalTime = package_.SerializeIntrinsic(this.mTotalTime);
        this.mPaused = package_.SerializeIntrinsic(this.mPaused);
        this.mTimeFlowSpeed = package_.SerializeIntrinsic(this.mTimeFlowSpeed);
        this.mTimeControlleds.OnSerialize(package_);
        this.mDirty = false;
    }

    public void Stop() {
        this.mTotalTime = 0;
        this.mPaused = true;
    }

    public void CleanUpTimeTable() {
        if (this.mDirty) {
            int n;
            PtrArray_TimeControlled ptrArray_TimeControlled = this.mTimeControlleds;
            while ((n = ptrArray_TimeControlled.Find(null)) != -1) {
                ptrArray_TimeControlled.SetAt(ptrArray_TimeControlled.GetAt(ptrArray_TimeControlled.End() - 1), n);
                ptrArray_TimeControlled.RemoveAt(ptrArray_TimeControlled.End() - 1);
            }
            this.mDirty = false;
        }
    }

    public void SendOnTime(int n, int n2) {
        int n3 = this.mTimeControlleds.End();
        for (int i = 0; i < this.mTimeControlleds.End(); ++i) {
            TimeControlled timeControlled = this.mTimeControlleds.GetAt(i);
            if (timeControlled == null) continue;
            if (i >= n3) {
                n2 = 0;
            }
            timeControlled.OnTime(n, n2);
        }
    }

    public static TimeSystem[] InstArrayTimeSystem(int n) {
        TimeSystem[] timeSystemArray = new TimeSystem[n];
        for (int i = 0; i < n; ++i) {
            timeSystemArray[i] = new TimeSystem();
        }
        return timeSystemArray;
    }

    public static TimeSystem[][] InstArrayTimeSystem(int n, int n2) {
        TimeSystem[][] timeSystemArray = new TimeSystem[n][];
        for (int i = 0; i < n; ++i) {
            timeSystemArray[i] = new TimeSystem[n2];
            for (int j = 0; j < n2; ++j) {
                timeSystemArray[i][j] = new TimeSystem();
            }
        }
        return timeSystemArray;
    }

    public static TimeSystem[][][] InstArrayTimeSystem(int n, int n2, int n3) {
        TimeSystem[][][] timeSystemArray = new TimeSystem[n][][];
        for (int i = 0; i < n; ++i) {
            timeSystemArray[i] = new TimeSystem[n2][];
            for (int j = 0; j < n2; ++j) {
                timeSystemArray[i][j] = new TimeSystem[n3];
                for (int k = 0; k < n3; ++k) {
                    timeSystemArray[i][j][k] = new TimeSystem();
                }
            }
        }
        return timeSystemArray;
    }

    public byte GetTypeID() {
        return 85;
    }

    public static Class AsClass() {
        return null;
    }
}

