/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Bitmap;
import ca.jamdat.flight.Component;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.Package;

public class Sprite
extends Component {
    public boolean mTileInY;
    public static final byte SPRITE_FLIP_Y;
    public boolean mTileInX;
    public Bitmap mBitmap;
    public static final byte SPRITE_FLIP_X;
    public static final boolean supportsDynamicSerialization;
    public static final byte typeID;
    public static final byte SPRITE_TILE_X;
    public static final byte SPRITE_TILE_Y;
    public static final byte typeNumber;

    public void destruct() {
        this.mBitmap = null;
    }

    public void OnSerialize(Package package_) {
        super.OnSerialize(package_);
        this.mBitmap = Bitmap.Cast(package_.SerializePointer((byte)-21, true, false), null);
        byte by = package_.SerializeIntrinsic((byte)0);
        boolean bl = (by & 1) != 0;
        this.mTileInX = bl;
        bl = (by & 2) != 0;
        this.mTileInY = bl;
    }

    public byte GetTypeID() {
        return 53;
    }

    public static Class AsClass() {
        return null;
    }

    public static Sprite Cast(Object object, Sprite sprite) {
        return (Sprite)object;
    }

    public void SetBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        if (this.mBitmap != null && !this.mTileInX && !this.mTileInY) {
            this.SetSize(this.mBitmap.GetWidth(), this.mBitmap.GetHeight());
        }
    }

    public Bitmap GetBitmap() {
        return this.mBitmap;
    }

    public void SizeToBitmap() {
        this.SetSize(this.mBitmap.GetWidth(), this.mBitmap.GetHeight());
    }

    public void MoveBy(short s, short s2) {
        if (s != 0 || s2 != 0) {
            this.SetTopLeft((short)(this.GetRectLeft() + s), (short)(this.GetRectTop() + s2));
        }
    }

    public void SetTileableXY(boolean bl) {
        this.SetTileableX(bl);
        this.SetTileableY(bl);
    }

    public void SetTileableX(boolean bl) {
        this.mTileInX = bl;
    }

    public void SetTileableY(boolean bl) {
        this.mTileInY = bl;
    }

    public boolean GetTileInX() {
        return this.mTileInX;
    }

    public boolean GetTileInY() {
        return this.mTileInY;
    }

    public static Sprite[] InstArraySprite(int n) {
        Sprite[] spriteArray = new Sprite[n];
        for (int i = 0; i < n; ++i) {
            spriteArray[i] = new Sprite();
        }
        return spriteArray;
    }

    public static Sprite[][] InstArraySprite(int n, int n2) {
        Sprite[][] spriteArray = new Sprite[n][];
        for (int i = 0; i < n; ++i) {
            spriteArray[i] = new Sprite[n2];
            for (int j = 0; j < n2; ++j) {
                spriteArray[i][j] = new Sprite();
            }
        }
        return spriteArray;
    }

    public void OnDraw(DisplayContext displayContext) {
        Bitmap bitmap = this.mBitmap;
        if (bitmap == null) {
            return;
        }
        if (this.mTileInX || this.mTileInY) {
            short s = bitmap.GetWidth();
            short s2 = bitmap.GetHeight();
            displayContext.DrawTiledBitmapSection(bitmap, bitmap.GetWidth(), bitmap.GetHeight(), (short)0, (short)0, (short)0, (short)0, s, s2, this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height);
            return;
        }
        displayContext.DrawBitmapSection(bitmap, this.GetRectLeft(), this.GetRectTop(), (short)0, (short)0, this.GetRectWidth(), this.GetRectHeight());
    }

    public static Sprite[][][] InstArraySprite(int n, int n2, int n3) {
        Sprite[][][] spriteArray = new Sprite[n][][];
        for (int i = 0; i < n; ++i) {
            spriteArray[i] = new Sprite[n2][];
            for (int j = 0; j < n2; ++j) {
                spriteArray[i][j] = new Sprite[n3];
                for (int k = 0; k < n3; ++k) {
                    spriteArray[i][j][k] = new Sprite();
                }
            }
        }
        return spriteArray;
    }
}

