/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Application;
import ca.jamdat.flight.Controller;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.Package;
import ca.jamdat.flight.TimeControlled;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.Viewport;

public abstract class Component
extends TimeControlled {
    public static final byte keyUpMsg;
    public static final byte enabledMsg;
    public static final byte isAttached;
    public static final byte typeID;
    public static final byte returnedFromSceneMsg;
    public static final byte quitRequestMsg;
    public static final byte startTransitionMsg;
    public static final byte completedTransitionMsg;
    public short mRect_width;
    public Component m_pPreviousSibling;
    public Viewport m_pViewport;
    public static final byte isDetached;
    public short mRect_left;
    public boolean mVisible = true;
    public static final byte firstApplicationMsg;
    public short mRect_height;
    public static final byte slideMsg;
    public static final byte reservedMsg;
    public static final byte selectedMsg;
    public static final byte scrollerUpdatedMsg;
    public static final byte focusMsg;
    public static final byte quitTransitionMsg;
    public static final byte isLeaving;
    public static final byte keyDownOrRepeatMsg;
    public static final byte keyDownMsg;
    public static final byte pushedMsg;
    public static final byte textFieldInputMsg;
    public static final boolean supportsDynamicSerialization;
    public static final byte slideStateMsg;
    public static final byte synchronizeSelectorMsg;
    public static final byte resetAncestorScrollerMsg;
    public short mRect_top;
    public static final byte attachMsg;
    public static final byte buttonMsg;
    public static final byte isEntering;
    public static final byte typeNumber;

    public Component() {
    }

    public void destruct() {
        if (this.m_pViewport != null) {
            this.SetViewport(null);
        }
    }

    public static Component Cast(Object object, Component component) {
        return (Component)object;
    }

    public byte GetTypeID() {
        return 67;
    }

    public static Class AsClass() {
        return null;
    }

    public Component(Viewport viewport) {
        this.SetViewport(viewport);
    }

    public void SetViewport(Viewport viewport) {
        Viewport viewport2 = this.m_pViewport;
        if (viewport2 != null) {
            this.UpdateAttach(false);
            viewport2.RemoveChild(this);
        }
        this.m_pViewport = viewport;
        if (viewport != null) {
            viewport.AddChild(this);
            this.UpdateAttach(true);
        }
    }

    public Viewport GetViewport() {
        return this.m_pViewport;
    }

    public void TakeFocus() {
        Application.GetInstance().SetCurrentFocus(this);
    }

    public void OnFocusChange(boolean bl) {
        bl = bl;
        this.SendMsg(this, -128, bl ? 1 : 0);
    }

    public Component ForwardFocus() {
        return this;
    }

    public boolean DescendentOrSelfHasFocus() {
        return this.IsSelfOrAncestorOf(Application.GetInstance().GetCurrentFocus());
    }

    public boolean IsSelfOrAncestorOf(Component component) {
        while (component != null) {
            if (component == this) {
                return true;
            }
            component = component.GetViewport();
        }
        return false;
    }

    public int GetDepth() {
        int n = 0;
        do {
            ++n;
        } while ((this = this.GetViewport()) != null);
        return n;
    }

    public void SendMsg(Component component, int n, int n2) {
        do {
            if (this.OnMsg(component, n, n2)) {
                return;
            }
            if (!this.OnDefaultMsg(component, n, n2)) continue;
            return;
        } while ((this = this.GetViewport()) != null);
    }

    public boolean OnMsg(Component component, int n, int n2) {
        return false;
    }

    public boolean OnDefaultMsg(Component component, int n, int n2) {
        return false;
    }

    public void SetRect(short s, short s2, short s3, short s4) {
        this.Invalidate();
        this.mRect_left = s;
        this.mRect_top = s2;
        this.mRect_width = s3;
        this.mRect_height = s4;
        this.OnRectChange();
        this.Invalidate();
    }

    public short GetRectLeft() {
        return this.mRect_left;
    }

    public short GetRectTop() {
        return this.mRect_top;
    }

    public short GetRectWidth() {
        return this.mRect_width;
    }

    public short GetRectHeight() {
        return this.mRect_height;
    }

    public void SetRect(FlRect flRect) {
        this.SetRect(flRect.GetLeft(), flRect.GetTop(), flRect.GetWidth(), flRect.GetHeight());
    }

    public FlRect GetRect() {
        return new FlRect(this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height);
    }

    public void SetTopLeft(Vector2_short vector2_short) {
        this.SetTopLeft(vector2_short.GetX(), vector2_short.GetY());
    }

    public Vector2_short GetSize() {
        return new Vector2_short(this.GetRectWidth(), this.GetRectHeight());
    }

    public void SetSize(Vector2_short vector2_short) {
        this.SetSize(vector2_short.GetX(), vector2_short.GetY());
    }

    public Vector2_short GetTopLeft() {
        return new Vector2_short(this.GetRectLeft(), this.GetRectTop());
    }

    public Vector2_short GetAbsoluteTopLeft() {
        return new Vector2_short(this.GetAbsoluteLeft(), this.GetAbsoluteTop());
    }

    public void SetTopLeft(short s, short s2) {
        this.Invalidate();
        this.mRect_left = s;
        this.mRect_top = s2;
        this.OnRectChange();
        this.Invalidate();
    }

    public short GetAbsoluteTop() {
        Viewport viewport = this.m_pViewport;
        if (viewport != null) {
            return (short)(this.mRect_top + viewport.GetAbsoluteTop() - viewport.GetOffsetY());
        }
        return this.mRect_top;
    }

    public short GetAbsoluteLeft() {
        Viewport viewport = this.m_pViewport;
        if (viewport != null) {
            return (short)(this.mRect_left + viewport.GetAbsoluteLeft() - viewport.GetOffsetX());
        }
        return this.mRect_left;
    }

    public Vector2_short GetRelativeCoord(Vector2_short vector2_short) {
        int n = vector2_short.GetX();
        int n2 = vector2_short.GetY();
        for (Viewport viewport = this.GetViewport(); viewport != null; viewport = viewport.GetViewport()) {
            n = n - viewport.GetRectLeft() + viewport.GetOffsetX();
            n2 = n2 - viewport.GetRectTop() + viewport.GetOffsetY();
        }
        return new Vector2_short((short)(n - this.mRect_left), (short)(n2 - this.mRect_top));
    }

    public void SetCenter(short s, short s2) {
        this.Invalidate();
        this.mRect_left = (short)(s - this.mRect_width / 2);
        this.mRect_top = (short)(s2 - this.mRect_height / 2);
        this.OnRectChange();
        this.Invalidate();
    }

    public void SetBottomRight(short s, short s2) {
        this.Invalidate();
        this.mRect_width = (short)(s + 1 - this.mRect_left);
        this.mRect_height = (short)(s2 + 1 - this.mRect_top);
        this.OnRectChange();
        this.Invalidate();
    }

    public short GetBottom() {
        return (short)(this.mRect_top + this.mRect_height - 1);
    }

    public short GetRight() {
        return (short)(this.mRect_left + this.mRect_width - 1);
    }

    public void CenterInRect(short s, short s2, short s3, short s4) {
        this.mRect_left = (short)(s + (s3 - this.mRect_width >> 1));
        this.mRect_top = (short)(s2 + (s4 - this.mRect_height >> 1));
    }

    public void SetSize(short s, short s2) {
        this.Invalidate();
        this.mRect_width = s;
        this.mRect_height = s2;
        this.OnRectChange();
        this.Invalidate();
    }

    public void SetVisible(boolean bl) {
        if (this.mVisible != bl) {
            this.mVisible = bl;
            this.OnVisibilityChange();
            this.Invalidate();
        }
    }

    public boolean IsVisible() {
        return this.mVisible;
    }

    public boolean IsGloballyVisible() {
        Viewport viewport = this.m_pViewport;
        if (viewport != null) {
            return this.IsVisible() && viewport.IsGloballyVisible();
        }
        return this.IsVisible();
    }

    public Component GetPreviousSiblingComponent() {
        return this.m_pPreviousSibling;
    }

    public void BringToFront() {
        this.m_pViewport.BringComponentToFront(this);
        this.Invalidate();
    }

    public void SendToBack() {
        this.m_pViewport.SendComponentToBack(this);
        this.Invalidate();
    }

    public void PutBehind(Component component) {
        this.m_pViewport.PutComponentBehind(this, component);
        this.Invalidate();
    }

    public void PutInFront(Component component) {
        this.m_pViewport.PutComponentInFront(this, component);
        this.Invalidate();
    }

    public boolean IsAttached() {
        Component component;
        do {
            component = this;
        } while ((this = this.GetViewport()) != null);
        return component == Application.GetInstance();
    }

    public void OnAttach(boolean bl) {
        Application application;
        if (!bl && (application = Application.GetInstance()).GetCurrentFocus() == this) {
            application.TakeFocus();
        }
    }

    public void Invalidate() {
        Application.GetInstance().SetDirty(true);
    }

    public abstract void OnDraw(DisplayContext var1);

    public void OnMouseRightDown(Vector2_short vector2_short) {
    }

    public void OnMouseOver() {
    }

    public void OnMouseOut() {
    }

    public void OnMouseRightUp(Vector2_short vector2_short) {
    }

    public void OnMouseRightDrag(Vector2_short vector2_short) {
    }

    public boolean IsTrackingPen() {
        return false;
    }

    public boolean IsTrackingMouse() {
        return false;
    }

    public void OnSerialize(Package package_) {
        this.mRect_left = package_.SerializeIntrinsic(this.mRect_left);
        this.mRect_top = package_.SerializeIntrinsic(this.mRect_top);
        this.mRect_width = package_.SerializeIntrinsic(this.mRect_width);
        this.mRect_height = package_.SerializeIntrinsic(this.mRect_height);
        boolean bl = (package_.SerializeIntrinsic((byte)0) & 1) != 0;
        this.mVisible = bl;
    }

    public void ControlValue(int n, boolean bl, Controller controller) {
        if (bl) {
            short s = 0;
            short s2 = 0;
            if (n == 1 || n == 2 || n == 3) {
                s = controller.GetCoord2ValueX();
                s2 = controller.GetCoord2ValueY();
            }
            switch (n) {
                case 1: {
                    this.SetTopLeft(s, s2);
                    return;
                }
                case 2: {
                    this.SetSize(s, s2);
                    return;
                }
                case 3: {
                    this.SetRect((short)(this.GetRectLeft() + (this.GetRectWidth() >> 1) - (s >> 1)), (short)(this.GetRectTop() + (this.GetRectHeight() >> 1) - (s2 >> 1)), s, s2);
                    return;
                }
                case 4: {
                    FlRect flRect = controller.GetRectValue();
                    this.SetRect(flRect.GetLeft(), flRect.GetTop(), flRect.GetWidth(), flRect.GetHeight());
                    return;
                }
                case 5: {
                    this.SetVisible(controller.GetBoolValue());
                    return;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    controller.SetValue(this.mRect_left, this.mRect_top);
                    return;
                }
                case 2: 
                case 3: {
                    controller.SetValue(this.mRect_width, this.mRect_height);
                    return;
                }
                case 4: {
                    controller.SetValue(this.mRect_left, this.mRect_top, this.mRect_width, this.mRect_height);
                    return;
                }
                case 5: {
                    controller.SetValue(this.IsVisible());
                    return;
                }
            }
        }
        super.ControlValue(n, bl, controller);
    }

    public void ResetAncestorScroller() {
        this.SendMsg(this, -114, 0);
    }

    public void TrackPen() {
    }

    public void ReleasePen() {
    }

    public void TrackMouse() {
    }

    public void ReleaseMouse() {
    }

    public void OnVisibilityChange() {
    }

    public void OnRectChange() {
    }

    public void UpdateAttach(boolean bl) {
        if (this.IsAttached()) {
            this.Invalidate();
            this.OnAttach(bl);
        }
    }
}

