/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Bitmap;
import ca.jamdat.flight.BitmapMapBlob;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.Package;

public class BitmapMap {
    public static final boolean supportsDynamicSerialization;
    public Bitmap mReferenceBitmap;
    public static final byte typeID;
    public BitmapMapBlob mBlob;
    public static final byte typeNumber;

    public void destruct() {
        this.mBlob = null;
        this.mReferenceBitmap = null;
    }

    public void SetReferenceBitmap(Bitmap bitmap) {
        this.mReferenceBitmap = bitmap;
    }

    public Bitmap GetReferenceBitmap() {
        return this.mReferenceBitmap;
    }

    public static BitmapMap Cast(Object object, BitmapMap bitmapMap) {
        return (BitmapMap)object;
    }

    public short GetPublicSizeXAt(int n) {
        return this.mBlob.mDataMatrix[(n << 3) + 6];
    }

    public short GetPublicSizeYAt(int n) {
        return this.mBlob.mDataMatrix[(n << 3) + 7];
    }

    public short GetOffsetXAt(int n) {
        return this.mBlob.mDataMatrix[(n << 3) + 4];
    }

    public short GetOffsetYAt(int n) {
        return this.mBlob.mDataMatrix[(n << 3) + 5];
    }

    public short GetSourceLeftAt(int n) {
        return this.mBlob.mDataMatrix[(n << 3) + 0];
    }

    public short GetSourceTopAt(int n) {
        return this.mBlob.mDataMatrix[(n << 3) + 1];
    }

    public short GetSourceWidthAt(int n) {
        return this.mBlob.mDataMatrix[(n << 3) + 2];
    }

    public short GetSourceHeightAt(int n) {
        return this.mBlob.mDataMatrix[(n << 3) + 3];
    }

    public void CopyFrom(BitmapMap bitmapMap) {
        this.mReferenceBitmap = bitmapMap.mReferenceBitmap;
        this.mBlob = null;
        this.SetBitmapMapBlob(new BitmapMapBlob(bitmapMap.mBlob));
    }

    public int GetBitmapCount() {
        return this.mBlob.GetBitmapCount();
    }

    public byte GetTypeID() {
        return 37;
    }

    public static Class AsClass() {
        return null;
    }

    public void DrawElementAt(int n, DisplayContext displayContext, short s, short s2, short s3, short s4, boolean bl, boolean bl2) {
        short[] sArray = this.mBlob.mDataMatrix;
        short s5 = (short)(s + sArray[(n <<= 3) + 4]);
        short s6 = (short)(s2 + sArray[n + 5]);
        if (bl || bl2) {
            displayContext.DrawTiledBitmapSection(this.mReferenceBitmap, sArray[n + 6], sArray[n + 7], (short)(s5 - s), (short)(s6 - s2), sArray[n + 0], sArray[n + 1], sArray[n + 2], sArray[n + 3], s, s2, s3, s4);
            return;
        }
        displayContext.DrawBitmapSection(this.mReferenceBitmap, s5, s6, sArray[n + 0], sArray[n + 1], sArray[n + 2], sArray[n + 3]);
    }

    public void DrawElementAt(int n, DisplayContext displayContext, short s, short s2) {
        this.DrawElementAt(n, displayContext, s, s2, (short)0, (short)0, false, false);
    }

    public void SetAsGrid(int n, int n2) {
        short[] sArray = this.mBlob.mDataMatrix;
        int n3 = this.mReferenceBitmap.GetWidth() / n;
        int n4 = this.mReferenceBitmap.GetHeight() / n2;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n6 = n5 << 3;
                sArray[n6 + 0] = (short)(j * n3);
                sArray[n6 + 1] = (short)(i * n4);
                sArray[n6 + 2] = (short)n3;
                sArray[n6 + 3] = (short)n4;
                sArray[n6 + 6] = (short)n3;
                sArray[n6 + 7] = (short)n4;
                sArray[n6 + 4] = 0;
                sArray[n6 + 5] = 0;
                ++n5;
            }
        }
    }

    public void OnSerialize(Package package_) {
        this.mBlob = BitmapMapBlob.Cast(package_.SerializePointer((byte)52, false, false), null);
        this.mReferenceBitmap = Bitmap.Cast(package_.SerializePointer((byte)-21, true, false), null);
    }

    public short[] GetDataMatrix() {
        return this.mBlob.mDataMatrix;
    }

    public void SetBitmapMapBlob(BitmapMapBlob bitmapMapBlob) {
        this.mBlob = bitmapMapBlob;
    }

    public static BitmapMap[] InstArrayBitmapMap(int n) {
        BitmapMap[] bitmapMapArray = new BitmapMap[n];
        for (int i = 0; i < n; ++i) {
            bitmapMapArray[i] = new BitmapMap();
        }
        return bitmapMapArray;
    }

    public static BitmapMap[][] InstArrayBitmapMap(int n, int n2) {
        BitmapMap[][] bitmapMapArray = new BitmapMap[n][];
        for (int i = 0; i < n; ++i) {
            bitmapMapArray[i] = new BitmapMap[n2];
            for (int j = 0; j < n2; ++j) {
                bitmapMapArray[i][j] = new BitmapMap();
            }
        }
        return bitmapMapArray;
    }

    public static BitmapMap[][][] InstArrayBitmapMap(int n, int n2, int n3) {
        BitmapMap[][][] bitmapMapArray = new BitmapMap[n][][];
        for (int i = 0; i < n; ++i) {
            bitmapMapArray[i] = new BitmapMap[n2][];
            for (int j = 0; j < n2; ++j) {
                bitmapMapArray[i][j] = new BitmapMap[n3];
                for (int k = 0; k < n3; ++k) {
                    bitmapMapArray[i][j][k] = new BitmapMap();
                }
            }
        }
        return bitmapMapArray;
    }
}

