/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.bejeweled;

import ca.jamdat.bejeweled.GameApp;
import ca.jamdat.flight.BitmapMap;
import ca.jamdat.flight.IndexedSprite;
import ca.jamdat.flight.KeyFrameController;
import ca.jamdat.flight.KeyFrameSequence;
import ca.jamdat.flight.Sprite;
import ca.jamdat.flight.TimeSystem;
import ca.jamdat.flight.TimerSequence;
import ca.jamdat.flight.Viewport;

public class JewelController {
    public int mShockWaveStartTime = Short.MAX_VALUE;
    public KeyFrameController mPositionController;
    public IndexedSprite mSprite;
    public int mStartTime;
    public int mCurrentAnimation;
    public int mVY;
    public int mVX;
    public KeyFrameController mFrameController;
    public int mY;
    public int mX;
    public TimeSystem mCurrentTimeSystem;

    public JewelController(int n, int n2) {
        this.mX = n;
        this.mY = n2;
        this.mCurrentAnimation = -1;
        this.mStartTime = Short.MAX_VALUE;
    }

    public short GetX() {
        return this.mSprite.GetAbsoluteLeft();
    }

    public void destruct() {
    }

    public short GetY() {
        return this.mSprite.GetAbsoluteTop();
    }

    public void GetResources(int n, Viewport viewport, boolean bl) {
        BitmapMap bitmapMap = BitmapMap.Cast(GameApp.GetGameAppInstance().GetPackage((byte)15).GetEntryPoint(7), null);
        this.mSprite = new IndexedSprite();
        this.mSprite.SetBitmapMap(bitmapMap);
        this.mSprite.SetCurrentFrame(0);
        this.mSprite.SetViewport(viewport);
        this.mSprite.SetTopLeft((short)(this.mX * n + 2), (short)(this.mY * n + 4));
        this.mFrameController = new KeyFrameController();
        this.mFrameController.SetControlParameters(this.mSprite, 7);
        this.mPositionController = new KeyFrameController();
        this.mPositionController.SetControlParameters(this.mSprite, 1);
    }

    public void SetJewel(int n) {
        IndexedSprite indexedSprite = this.mSprite;
        boolean bl = n != -1;
        indexedSprite.SetVisible(bl);
        if (n != -1) {
            BitmapMap bitmapMap = BitmapMap.Cast(GameApp.GetGameAppInstance().GetPackage((byte)15).GetEntryPoint(7 + n), null);
            this.mSprite.SetBitmapMap(bitmapMap);
            this.mSprite.SetCurrentFrame(0);
        }
    }

    public boolean SetAnimation(int n, KeyFrameSequence keyFrameSequence, KeyFrameSequence keyFrameSequence2) {
        if (n <= this.mCurrentAnimation || !this.mSprite.IsVisible()) {
            return false;
        }
        if (this.mCurrentAnimation != -1) {
            this.UnRegister();
        }
        this.mCurrentAnimation = n;
        if (keyFrameSequence != null) {
            this.mPositionController.SetKeySequence(keyFrameSequence);
            this.mPositionController.SetIsAbsolute(true);
            this.mPositionController.SetIsAbsolute(false);
            this.mPositionController.OnTime(0, 0);
        }
        if (keyFrameSequence2 != null) {
            this.mFrameController.SetKeySequence(keyFrameSequence2);
            this.mFrameController.SetIsAbsolute(true);
            this.mFrameController.SetIsAbsolute(false);
            this.mFrameController.OnTime(0, 0);
        }
        return true;
    }

    public int GetAnimation() {
        return this.mCurrentAnimation;
    }

    public void Register(TimeSystem timeSystem) {
        this.mCurrentTimeSystem = timeSystem;
        switch (this.mCurrentAnimation) {
            case 1: 
            case 2: {
                timeSystem.Register(this.mFrameController);
                break;
            }
            case 11: 
            case 12: {
                timeSystem.Register(this.mPositionController);
                break;
            }
            case 0: 
            case 6: 
            case 10: {
                ((TimerSequence)timeSystem).RegisterInterval(this.mFrameController, this.mStartTime, Short.MAX_VALUE);
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                ((TimerSequence)timeSystem).RegisterInterval(this.mPositionController, this.mStartTime, Short.MAX_VALUE);
                break;
            }
            case 8: {
                ((TimerSequence)timeSystem).RegisterInterval(this.mPositionController, this.mShockWaveStartTime, Short.MAX_VALUE);
                this.mShockWaveStartTime = Short.MAX_VALUE;
                break;
            }
            case 3: 
            case 5: {
                ((TimerSequence)timeSystem).RegisterInterval(this.mFrameController, this.mStartTime, Short.MAX_VALUE);
                ((TimerSequence)timeSystem).RegisterInterval(this.mPositionController, this.mStartTime, Short.MAX_VALUE);
            }
        }
        this.mVY = 0;
        this.mVX = 0;
        this.mStartTime = Short.MAX_VALUE;
    }

    public void UnRegister() {
        if (this.mCurrentTimeSystem != null) {
            int n = 0;
            if (this.mCurrentAnimation == 11 || this.mCurrentAnimation == 12 || this.mCurrentAnimation == 9 || this.mCurrentAnimation == 0 || this.mCurrentAnimation == 5) {
                n = Short.MAX_VALUE;
            }
            if (this.mPositionController != null && this.mCurrentTimeSystem.IsRegistered(this.mPositionController)) {
                this.mPositionController.OnTime(n, 0);
                this.mCurrentTimeSystem.UnRegister(this.mPositionController);
            }
            if (this.mFrameController != null && this.mCurrentTimeSystem.IsRegistered(this.mFrameController)) {
                this.mSprite.SetCurrentFrame(0);
                this.mCurrentTimeSystem.UnRegister(this.mFrameController);
            }
        }
        this.mVY = 0;
        this.mVX = 0;
        this.mShockWaveStartTime = Short.MAX_VALUE;
        this.mStartTime = Short.MAX_VALUE;
        this.mCurrentTimeSystem = null;
        this.mCurrentAnimation = -1;
    }

    public void SetStartTime(int n) {
        if (n < this.mStartTime) {
            this.mStartTime = n;
        }
    }

    public void SetShockWaveParams(int n, int n2, int n3) {
        if (this.mCurrentAnimation == -1) {
            this.mVX += n;
            this.mVY += n2;
            if (n3 < this.mShockWaveStartTime) {
                this.mShockWaveStartTime = n3;
            }
        }
    }

    public int GetVX() {
        return this.mVX;
    }

    public int GetVY() {
        return this.mVY;
    }

    public Sprite GetSprite() {
        return this.mSprite;
    }

    public void UnloadResources() {
        this.mSprite.SetViewport(null);
        this.mSprite = null;
        this.mFrameController = null;
        this.mPositionController = null;
    }
}

